/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.bittorrent;

import com.frostwire.gui.bittorrent.TorrentFileInfo;
import com.frostwire.jlibtorrent.FileStorage;
import com.frostwire.jlibtorrent.TorrentInfo;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.IconManager;
import com.limegroup.gnutella.gui.LabeledTextField;
import com.limegroup.gnutella.gui.search.NamedMediaType;
import com.limegroup.gnutella.gui.tables.SizeHolder;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.RowFilter;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableRowSorter;
import org.apache.commons.io.FilenameUtils;
import org.limewire.util.StringUtils;

public class PartialFilesDialog
extends JDialog {
    private LabeledTextField filter;
    private RowFilter<Object, Object> textBasedFilter;
    private JPanel panel;
    private JTable table;
    private JButton buttonOK;
    private final TorrentInfo torrent;
    private final String name;
    private final TorrentTableModel model;
    private boolean[] filesSelection;
    private JCheckBox checkBoxToggleAll;
    private boolean tablePainted;

    PartialFilesDialog(JFrame frame, File torrentFile) {
        this(frame, new TorrentInfo(torrentFile), torrentFile.getName());
    }

    PartialFilesDialog(JFrame frame, byte[] bytes, String name) {
        this(frame, TorrentInfo.bdecode(bytes), name);
    }

    private PartialFilesDialog(JFrame frame, TorrentInfo torrent, String name) {
        super((Frame)frame, I18n.tr("Select files to download"));
        this.torrent = torrent;
        this.name = name;
        this.model = new TorrentTableModel(this.torrent);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                GUIMediator.instance().setRemoteDownloadsAllowed(false);
            }

            @Override
            public void windowClosing(WindowEvent e) {
                GUIMediator.instance().setRemoteDownloadsAllowed(true);
            }
        });
        this.setupUI();
        this.setLocationRelativeTo(frame);
    }

    private void setupUI() {
        this.setResizable(true);
        this.setMinimumSize(new Dimension(400, 300));
        this.panel = new JPanel(new GridBagLayout());
        this.setupTitle();
        this.setupTextFilter();
        this.setupToggleAllSelectionCheckbox();
        this.setupTable();
        this.setupOkButton();
        this.setupCancelButton();
        this.getContentPane().add(this.panel);
        this.pack();
        this.setDefaultCloseOperation(2);
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.getRootPane().setDefaultButton(this.buttonOK);
        GUIUtils.addHideAction((JComponent)this.getContentPane());
    }

    private void setupCancelButton() {
        JButton _buttonCancel = new JButton(I18n.tr("Cancel"));
        _buttonCancel.addActionListener(this::buttonCancel_actionPerformed);
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(4, 0, 8, 6);
        c.gridwidth = 0;
        c.anchor = 13;
        c.ipadx = 18;
        c.gridy = 4;
        this.panel.add((Component)_buttonCancel, c);
    }

    private void setupOkButton() {
        this.buttonOK = new JButton(I18n.tr("Download Selected Files Only"));
        this.buttonOK.addActionListener(this::buttonOK_actionPerformed);
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(4, 100, 8, 4);
        c.fill = 0;
        c.gridwidth = -1;
        c.anchor = 13;
        c.ipadx = 20;
        c.weightx = 1.0;
        c.gridy = 4;
        this.panel.add((Component)this.buttonOK, c);
    }

    private void setupTable() {
        this.table = new JTable(){

            @Override
            public void paint(Graphics g) {
                super.paint(g);
                try {
                    if (PartialFilesDialog.this.tablePainted) {
                        return;
                    }
                    PartialFilesDialog.this.tablePainted = true;
                    GUIUtils.adjustColumnWidth(PartialFilesDialog.this.model, 3, 150, 10, this);
                    GUIUtils.adjustColumnWidth(PartialFilesDialog.this.model, 2, 620, 10, this);
                }
                catch (Exception e) {
                    PartialFilesDialog.this.tablePainted = false;
                }
            }
        };
        this.table.setPreferredScrollableViewportSize(new Dimension(600, 300));
        this.table.setRowSelectionAllowed(false);
        this.table.setModel(this.model);
        this.table.getColumnModel().getColumn(0).setHeaderValue("");
        this.table.getColumnModel().getColumn(1).setHeaderValue("");
        this.table.getColumnModel().getColumn(2).setHeaderValue(I18n.tr("File"));
        this.table.getColumnModel().getColumn(3).setHeaderValue(I18n.tr("Type"));
        this.table.getColumnModel().getColumn(4).setHeaderValue(I18n.tr("Extension"));
        this.table.getColumnModel().getColumn(5).setHeaderValue(I18n.tr("Size"));
        this.table.getColumnModel().getColumn(0).setPreferredWidth(30);
        this.table.getColumnModel().getColumn(1).setPreferredWidth(30);
        this.table.getColumnModel().getColumn(2).setMinWidth(380);
        this.table.getColumnModel().getColumn(3).setPreferredWidth(150);
        this.table.getColumnModel().getColumn(4).setPreferredWidth(60);
        this.table.getColumnModel().getColumn(5).setPreferredWidth(60);
        JScrollPane _scrollPane = new JScrollPane(this.table, 20, 30);
        this.table.setFillsViewportHeight(true);
        this.table.setAutoResizeMode(0);
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(5, 5, 5, 5);
        c.gridx = 0;
        c.gridy = 3;
        c.gridwidth = 2;
        c.gridheight = 1;
        c.anchor = 17;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.panel.add((Component)_scrollPane, c);
    }

    private void setupToggleAllSelectionCheckbox() {
        this.checkBoxToggleAll = new JCheckBox(I18n.tr("Select/Unselect all files"), true);
        this.checkBoxToggleAll.addItemListener(e -> this.onCheckBoxToggleAll());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.anchor = 17;
        c.fill = 2;
        c.weightx = 1.0;
        c.insets = new Insets(5, 5, 5, 5);
        this.panel.add((Component)this.checkBoxToggleAll, c);
    }

    private void setupTextFilter() {
        this.filter = new LabeledTextField("Filter files", 30);
        this.filter.setMinimumSize(this.filter.getPreferredSize());
        this.textBasedFilter = new RowFilterExtension(this.filter);
        this.filter.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (PartialFilesDialog.this.filter.getText() == null || PartialFilesDialog.this.filter.getText().equals("")) {
                    PartialFilesDialog.this.table.setRowSorter(null);
                    return;
                }
                PartialFilesDialog.this.checkBoxToggleAll.setSelected(false);
                TableRowSorter<TorrentTableModel> sorter = new TableRowSorter<TorrentTableModel>(PartialFilesDialog.this.model);
                sorter.setRowFilter(PartialFilesDialog.this.textBasedFilter);
                PartialFilesDialog.this.table.setRowSorter(sorter);
            }
        });
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 2;
        c.gridheight = 1;
        c.anchor = 17;
        c.weightx = 1.0;
        c.insets = new Insets(5, 5, 5, 5);
        this.panel.add((Component)this.filter, c);
    }

    private void setupTitle() {
        String title = this.torrent.name();
        if (title == null) {
            title = this.torrent.name() != null ? StringUtils.getUTF8String(this.torrent.name().getBytes()) : this.name.replace("_", " ").replace(".torrent", "").replace("&quot;", "\"");
        }
        JLabel labelTitle = new JLabel(title);
        labelTitle.setFont(new Font("Dialog", 1, 18));
        labelTitle.setHorizontalAlignment(2);
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 2;
        c.gridheight = 1;
        c.anchor = 17;
        c.fill = 2;
        c.weightx = 1.0;
        c.insets = new Insets(5, 5, 5, 5);
        this.panel.add((Component)labelTitle, c);
    }

    private void onCheckBoxToggleAll() {
        this.model.setAllSelected(this.checkBoxToggleAll.isSelected());
        this.buttonOK.setEnabled(this.checkBoxToggleAll.isSelected());
    }

    private void checkboxToggleAllSetSelectedNoTrigger(boolean allSelected) {
        ItemListener[] itemListeners;
        for (ItemListener l : itemListeners = this.checkBoxToggleAll.getItemListeners()) {
            this.checkBoxToggleAll.removeItemListener(l);
        }
        this.checkBoxToggleAll.setSelected(allSelected);
        for (ItemListener l : itemListeners) {
            this.checkBoxToggleAll.addItemListener(l);
        }
    }

    private void buttonOK_actionPerformed(ActionEvent e) {
        TorrentFileInfo[] fileInfos = this.model.getFileInfos();
        this.filesSelection = new boolean[fileInfos.length];
        for (int i = 0; i < this.filesSelection.length; ++i) {
            this.filesSelection[i] = fileInfos[i].selected;
        }
        GUIUtils.getDisposeAction().actionPerformed(e);
    }

    private void buttonCancel_actionPerformed(ActionEvent e) {
        GUIUtils.getDisposeAction().actionPerformed(e);
    }

    boolean[] getFilesSelection() {
        return this.filesSelection;
    }

    private final class TorrentTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = -8689494570949104116L;
        private final TorrentInfo _torrent;
        private final TorrentFileInfo[] _fileInfos;

        TorrentTableModel(TorrentInfo torrent) {
            this._torrent = torrent;
            this._fileInfos = new TorrentFileInfo[torrent.numFiles()];
            FileStorage fs = torrent.files();
            for (int i = 0; i < this._fileInfos.length; ++i) {
                this._fileInfos[i] = new TorrentFileInfo(fs.filePath(i), fs.fileSize(i), true);
            }
        }

        @Override
        public int getRowCount() {
            return this._torrent.numFiles();
        }

        @Override
        public int getColumnCount() {
            return 6;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 0;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return Boolean.class;
                }
                case 1: {
                    return Icon.class;
                }
                case 2: {
                    return String.class;
                }
                case 3: {
                    return String.class;
                }
                case 4: {
                    return String.class;
                }
                case 5: {
                    return SizeHolder.class;
                }
            }
            return null;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            String filePath = this._fileInfos[rowIndex].path;
            String extension = FilenameUtils.getExtension(filePath);
            switch (columnIndex) {
                case 0: {
                    return this._fileInfos[rowIndex].selected;
                }
                case 1: {
                    return IconManager.instance().getIconForExtension(extension);
                }
                case 2: {
                    return filePath;
                }
                case 3: {
                    return this.guessHumanType(extension);
                }
                case 4: {
                    return extension;
                }
                case 5: {
                    return new SizeHolder(this._fileInfos[rowIndex].size);
                }
            }
            return null;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                this._fileInfos[rowIndex].selected = (Boolean)aValue;
                this.fireTableDataChanged();
            }
            PartialFilesDialog.this.checkboxToggleAllSetSelectedNoTrigger(this.isAllSelected());
            PartialFilesDialog.this.buttonOK.setEnabled(!this.isNoneSelected());
        }

        void setAllSelected(boolean selected) {
            for (TorrentFileInfo _fileInfo : this._fileInfos) {
                _fileInfo.selected = selected;
            }
            this.fireTableDataChanged();
        }

        boolean isAllSelected() {
            for (TorrentFileInfo _fileInfo : this._fileInfos) {
                if (_fileInfo.selected) continue;
                return false;
            }
            return true;
        }

        boolean isNoneSelected() {
            for (TorrentFileInfo _fileInfo : this._fileInfos) {
                if (!_fileInfo.selected) continue;
                return false;
            }
            return true;
        }

        TorrentFileInfo[] getFileInfos() {
            return this._fileInfos;
        }

        private String guessHumanType(String extension) {
            try {
                return NamedMediaType.getFromExtension(extension).getMediaType().getDescriptionKey();
            }
            catch (Throwable t) {
                return I18n.tr("Unknown");
            }
        }
    }

    static final class RowFilterExtension
    extends RowFilter<Object, Object> {
        private final LabeledTextField labelFilter;
        private final int columnIndex;

        RowFilterExtension(LabeledTextField labelFilter) {
            this.labelFilter = labelFilter;
            this.columnIndex = 2;
        }

        @Override
        public boolean include(RowFilter.Entry<?, ?> entry2) {
            String[] tokens;
            Object value = entry2.getValue(this.columnIndex);
            String fileName = value instanceof String ? (String)value : "";
            for (String t : tokens = this.labelFilter.getText().split(" ")) {
                if (fileName.toLowerCase().contains(t.toLowerCase())) continue;
                return false;
            }
            return true;
        }
    }
}

