/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.bittorrent;

import com.limegroup.gnutella.gui.LimeTextField;
import java.util.HashMap;
import java.util.Set;

public class CryptoCurrencyTextField
extends LimeTextField {
    private final String prefix;
    private final HashMap<String, String> firstValidCharsOnAddress;

    public CryptoCurrencyTextField(CurrencyURIPrefix p) {
        this.prefix = p.toString();
        this.firstValidCharsOnAddress = new HashMap();
        this.initFirstValidChars();
    }

    private void initFirstValidChars() {
        if (this.prefix.equals("bitcoin:")) {
            this.firstValidCharsOnAddress.put("1", "1");
            this.firstValidCharsOnAddress.put("3", "3");
        } else if (this.prefix.equals("litecoin:")) {
            this.firstValidCharsOnAddress.put("L", "L");
        } else if (this.prefix.equals("dogecoin:")) {
            this.firstValidCharsOnAddress.put("D", "D");
        }
    }

    public boolean hasValidPrefixOrNoPrefix() {
        boolean hasPrefix = false;
        boolean hasValidPrefix = false;
        String text = this.getText();
        if (text.contains(":")) {
            hasPrefix = true;
            hasValidPrefix = text.startsWith(this.prefix);
        } else {
            hasPrefix = false;
        }
        return hasPrefix && hasValidPrefix || !hasPrefix;
    }

    public boolean hasValidAddress() {
        boolean result = false;
        String text = this.getText().trim();
        if (text != null && !text.isEmpty()) {
            result = 26 <= (text = text.replaceAll(this.prefix, "")).length() && text.length() <= 34 && this.isFirstCharValid();
        }
        return result;
    }

    public String normalizeValidAddress() {
        String result = this.getText().trim();
        if (!result.startsWith(this.prefix)) {
            result = this.prefix + result;
        }
        return result;
    }

    private boolean isFirstCharValid() {
        boolean foundChar = false;
        String text = this.getText().trim();
        if (text != null && !text.isEmpty() && (text = text.replaceAll(this.prefix, "")).length() > 1) {
            String firstChar = text.substring(0, 1);
            Set<String> firstChars = this.firstValidCharsOnAddress.keySet();
            for (String key : firstChars) {
                if (!key.equals(firstChar)) continue;
                foundChar = true;
                break;
            }
        }
        return foundChar;
    }

    public static enum CurrencyURIPrefix {
        BITCOIN("bitcoin:"),
        LITECOIN("litecoin:"),
        DOGECOIN("dogecoin:");

        private final String prefix;

        private CurrencyURIPrefix(String p) {
            this.prefix = p;
        }

        public String toString() {
            return this.prefix;
        }
    }
}

