/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.alexandria.db;

import com.frostwire.alexandria.Playlist;
import com.frostwire.alexandria.PlaylistItem;
import com.frostwire.alexandria.db.PlaylistDB;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class LibraryDatabase {
    public static final int OBJECT_NOT_SAVED_ID = -1;
    public static final int OBJECT_INVALID_ID = -2;
    public static final int STARRED_PLAYLIST_ID = -3;
    private static final int LIBRARY_DATABASE_VERSION = 4;
    static final String STARRED_TABLE_NAME_DO_NOT_TRANSLATE_THIS = "starred";
    private final String _name;
    private Connection _connection;
    private boolean _closed;

    public LibraryDatabase(File databaseFile) {
        if (databaseFile != null && !databaseFile.isDirectory() && !databaseFile.exists()) {
            databaseFile.mkdirs();
        }
        if (!(databaseFile != null && databaseFile.isDirectory() && databaseFile.canRead() && databaseFile.canWrite())) {
            if (databaseFile != null) {
                throw new IllegalArgumentException("Invalid library database file parameter received: " + databaseFile.getAbsolutePath());
            }
            throw new IllegalArgumentException("Null library database file parameter received.");
        }
        this._name = databaseFile.getName();
        this._connection = this.openOrCreateDatabase(databaseFile, this._name);
    }

    public String getName() {
        return this._name;
    }

    public boolean isClosed() {
        return this._closed;
    }

    public synchronized List<List<Object>> query(String statementSql, Object ... arguments) {
        if (this.isClosed()) {
            return new ArrayList<List<Object>>();
        }
        return this.query(this._connection, statementSql, arguments);
    }

    public synchronized int update(String statementSql, Object ... arguments) {
        if (this.isClosed()) {
            return -1;
        }
        return this.update(this._connection, statementSql, arguments);
    }

    public synchronized int insert(String statementSql, Object ... arguments) {
        if (this.isClosed()) {
            return -2;
        }
        if (!statementSql.toUpperCase().startsWith("INSERT")) {
            return -2;
        }
        if (this.update(statementSql, arguments) != -1) {
            return this.getIdentity();
        }
        return -2;
    }

    public synchronized void close() {
        if (this.isClosed()) {
            return;
        }
        this._closed = true;
        try {
            Statement statement = this._connection.createStatement();
            statement.execute("SHUTDOWN");
            this._connection.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void onUpdateDatabase(Connection connection, int oldVersion) {
        if (oldVersion == 1) {
            this.setupLuceneIndex(connection);
        }
        if (oldVersion == 2) {
            // empty if block
        }
        if (oldVersion == 3) {
            this.setupPlaylistIndexes(connection);
        }
        this.update(connection, "UPDATE Library SET version = ?", 4);
    }

    private Connection openConnection(File path, String name, boolean createIfNotExists) {
        try {
            StringBuilder sb = new StringBuilder();
            sb.append("jdbc:h2:");
            sb.append(new File(path, name).getAbsolutePath());
            if (!createIfNotExists) {
                sb.append(";ifexists=true");
            }
            return DriverManager.getConnection(sb.toString(), "SA", "");
        }
        catch (Exception e) {
            return null;
        }
    }

    private Connection createDatabase(File path, String name) {
        Connection connection = this.openConnection(path, name, true);
        this.update(connection, "CREATE TABLE Library (libraryId INTEGER IDENTITY, name VARCHAR(500), version INTEGER)", new Object[0]);
        this.update(connection, "CREATE TABLE Playlists (playlistId INTEGER IDENTITY, name VARCHAR(500), description VARCHAR(10000))", new Object[0]);
        this.update(connection, "CREATE INDEX idx_Playlists_name ON Playlists (name)", new Object[0]);
        this.update(connection, "CREATE TABLE PlaylistItems (playlistItemId INTEGER IDENTITY, filePath VARCHAR(10000), fileName VARCHAR(500), fileSize BIGINT, fileExtension VARCHAR(10), trackTitle VARCHAR(500), trackDurationInSecs REAL, trackArtist VARCHAR(500), trackAlbum VARCHAR(500), coverArtPath VARCHAR(10000), trackBitrate VARCHAR(10), trackComment VARCHAR(500), trackGenre VARCHAR(20), trackNumber VARCHAR(6), trackYear VARCHAR(6), playlistId INTEGER, starred BOOLEAN, sortIndex INTEGER)", new Object[0]);
        this.update(connection, "CREATE INDEX idx_PlaylistItems_filePath ON PlaylistItems (filePath)", new Object[0]);
        this.update(connection, "CREATE INDEX idx_PlaylistItems_starred ON PlaylistItems (starred)", new Object[0]);
        this.setupLuceneIndex(connection);
        this.update(connection, "INSERT INTO Library (name , version) VALUES (?, ?)", name, 4);
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Connection openOrCreateDatabase(File path, String name) {
        Connection connection = this.openConnection(path, name, false);
        if (connection == null) {
            connection = this.createDatabase(path, name);
        } else {
            int version = this.getDatabaseVersion(connection);
            if (version < 4) {
                this.onUpdateDatabase(connection, version);
                try {
                    connection.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                finally {
                    connection = this.openConnection(path, name, false);
                }
            }
        }
        return connection;
    }

    private List<List<Object>> convertResultSetToList(ResultSet resultSet) throws SQLException {
        ResultSetMetaData meta = resultSet.getMetaData();
        int numColumns = meta.getColumnCount();
        LinkedList<List<Object>> result = new LinkedList<List<Object>>();
        while (resultSet.next()) {
            ArrayList<Object> row = new ArrayList<Object>(numColumns);
            for (int i = 1; i <= numColumns; ++i) {
                row.add(resultSet.getObject(i));
            }
            result.add(row);
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int getIdentity() {
        if (this.isClosed()) {
            return -2;
        }
        try (Statement statement = this._connection.createStatement();){
            ResultSet resultSet = statement.executeQuery("CALL IDENTITY()");
            resultSet.next();
            int n = resultSet.getInt(1);
            return n;
        }
        catch (Exception e) {
            e.printStackTrace();
            return -2;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<List<Object>> query(Connection connection, String statementSql, Object ... arguments) {
        try (PreparedStatement statement = connection.prepareStatement(statementSql);){
            if (arguments != null) {
                for (int i = 0; i < arguments.length; ++i) {
                    statement.setObject(i + 1, arguments[i]);
                }
            }
            ResultSet resultSet = statement.executeQuery();
            List<List<Object>> list = this.convertResultSetToList(resultSet);
            return list;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ArrayList<List<Object>>();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int update(Connection connection, String statementSql, Object ... arguments) {
        try (PreparedStatement statement = connection.prepareStatement(statementSql);){
            if (arguments != null) {
                for (int i = 0; i < arguments.length; ++i) {
                    statement.setObject(i + 1, arguments[i]);
                }
            }
            int n = statement.executeUpdate();
            return n;
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    private int getDatabaseVersion(Connection connection) {
        List<List<Object>> query = this.query(connection, "SELECT version FROM Library", new Object[0]);
        return query.size() > 0 ? (Integer)query.get(0).get(0) : -1;
    }

    private void setupLuceneIndex(Connection connection) {
        this.update(connection, "CREATE ALIAS IF NOT EXISTS FTL_INIT FOR \"org.h2.fulltext.FullTextLucene.init\"", new Object[0]);
        this.update(connection, "CALL FTL_INIT()", new Object[0]);
        this.update(connection, "CALL FTL_CREATE_INDEX('PUBLIC', 'PLAYLISTITEMS', 'FILEPATH, TRACKTITLE, TRACKARTIST, TRACKALBUM, TRACKGENRE, TRACKYEAR')", new Object[0]);
    }

    private void setupPlaylistIndexes(Connection connection) {
        this.update(connection, "ALTER TABLE PlaylistItems ADD sortIndex INTEGER", new Object[0]);
        List<Playlist> playlists = PlaylistDB.getPlaylists(this);
        for (Playlist playlist : playlists) {
            List<PlaylistItem> items = playlist.getItems();
            for (int i = 0; i < items.size(); ++i) {
                PlaylistItem item = items.get(i);
                item.setSortIndexByTrackNumber(i + 1);
                item.save();
            }
        }
    }

    static {
        try {
            Class.forName("org.h2.Driver");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }
}

