/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.alexandria;

import com.frostwire.alexandria.PlaylistItem;
import com.frostwire.alexandria.db.LibraryDatabase;
import com.frostwire.alexandria.db.LibraryDatabaseEntity;
import com.frostwire.alexandria.db.PlaylistDB;
import com.frostwire.alexandria.db.PlaylistItemDB;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class Playlist
extends LibraryDatabaseEntity {
    private int _id;
    private String _name;
    private String _description;
    private boolean deleted;
    private List<PlaylistItem> _items;

    public Playlist(LibraryDatabase libraryDB) {
        super(libraryDB);
        this._id = -2;
        this._items = Collections.synchronizedList(new LinkedList());
        this.deleted = false;
    }

    public Playlist(LibraryDatabase libraryDB, int id, String name, String description) {
        super(libraryDB);
        this._id = id;
        this._name = name;
        this._description = description;
        this._items = new LinkedList<PlaylistItem>();
        this.deleted = false;
    }

    public final boolean isStarred() {
        return this._id == -3;
    }

    public int getId() {
        return this._id;
    }

    public void setId(int id) {
        this._id = id;
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public String getDescription() {
        return this._description;
    }

    public void setDescription(String description) {
        this._description = description;
    }

    public List<PlaylistItem> getItems() {
        return this._items;
    }

    public int size() {
        if (this._items == null) {
            return 0;
        }
        return this._items.size();
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public synchronized void save() {
        if (this.db != null) {
            PlaylistDB.save(this.db, this);
        }
    }

    public synchronized void delete() {
        if (this.db != null) {
            PlaylistDB.delete(this.db, this);
            this.deleted = true;
        }
    }

    public synchronized void refresh() {
        if (this.db != null) {
            this._items.clear();
            this._items.addAll(PlaylistItemDB.getPlaylistItems(this.db, this));
        }
    }

    public PlaylistItem newItem(String filePath, String fileName, long fileSize, String fileExtension, String trackTitle, float trackDurationInSecs, String trackArtist, String trackAlbum, String coverArtPath, String trackBitrate, String trackComment, String trackGenre, String trackNumber, String trackYear, boolean starred) {
        return new PlaylistItem(this, -1, filePath, fileName, fileSize, fileExtension, trackTitle, trackDurationInSecs, trackArtist, trackAlbum, coverArtPath, trackBitrate, trackComment, trackGenre, trackNumber, trackYear, starred);
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof Playlist)) {
            return false;
        }
        Playlist other = (Playlist)obj;
        return other.getId() == this.getId();
    }

    public String toString() {
        return this._name;
    }
}

