/*
 * Decompiled with CFR 0.152.
 */
package com.apple.concurrent;

import com.apple.concurrent.LibDispatchConcurrentQueue;
import com.apple.concurrent.LibDispatchMainQueue;
import com.apple.concurrent.LibDispatchNative;
import com.apple.concurrent.LibDispatchSerialQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;

public final class Dispatch {
    static final Dispatch instance = new Dispatch();
    int queueIndex = 0;
    Executor nonBlockingMainQueue = null;
    Executor blockingMainQueue = null;

    public static Dispatch getInstance() {
        Dispatch.checkSecurity();
        if (!LibDispatchNative.nativeIsDispatchSupported()) {
            return null;
        }
        return instance;
    }

    private static void checkSecurity() {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(new RuntimePermission("canInvokeInSystemThreadGroup"));
        }
    }

    private Dispatch() {
    }

    public Executor getAsyncExecutor(Priority priority) {
        long nativeQueue;
        if (priority == null) {
            priority = Priority.NORMAL;
        }
        if ((nativeQueue = LibDispatchNative.nativeCreateConcurrentQueue(priority.nativePriority)) == 0L) {
            return null;
        }
        return new LibDispatchConcurrentQueue(nativeQueue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecutorService createSerialExecutor(String label) {
        long nativeQueue;
        if (label == null) {
            label = "";
        }
        if (label.length() > 256) {
            label = label.substring(0, 256);
        }
        String queueName = "com.apple.java.concurrent.";
        if ("".equals(label)) {
            Dispatch dispatch = this;
            synchronized (dispatch) {
                queueName = queueName + this.queueIndex++;
            }
        } else {
            queueName = queueName + label;
        }
        if ((nativeQueue = LibDispatchNative.nativeCreateSerialQueue(queueName)) == 0L) {
            return null;
        }
        return new LibDispatchSerialQueue(nativeQueue);
    }

    public synchronized Executor getNonBlockingMainQueueExecutor() {
        if (this.nonBlockingMainQueue != null) {
            return this.nonBlockingMainQueue;
        }
        this.nonBlockingMainQueue = new LibDispatchMainQueue.ASync();
        return this.nonBlockingMainQueue;
    }

    public synchronized Executor getBlockingMainQueueExecutor() {
        if (this.blockingMainQueue != null) {
            return this.blockingMainQueue;
        }
        this.blockingMainQueue = new LibDispatchMainQueue.Sync();
        return this.blockingMainQueue;
    }

    public static enum Priority {
        LOW(-2),
        NORMAL(0),
        HIGH(2);

        final int nativePriority;

        private Priority(int nativePriority) {
            this.nativePriority = nativePriority;
        }
    }
}

