#
# Autogenerated by Thrift Compiler (0.5.0-en-262021)
#
# DO NOT EDIT UNLESS YOU ARE SURE THAT YOU KNOW WHAT YOU ARE DOING
#
#  options string: py:new_style
#

from thrift.Thrift import TType, TMessageType, TException, TApplicationException
from ttypes import *
from thrift.Thrift import TProcessor
from thrift.transport import TTransport
from thrift.protocol import TBinaryProtocol, TProtocol
try:
  from thrift.protocol import fastbinary
except:
  fastbinary = None


class Iface(object):
  """
  Service:  UserStore
  <p>
  The UserStore service is primarily used by EDAM clients to establish
  authentication via username and password over a trusted connection (e.g.
  SSL).  A client's first call to this interface should be checkVersion() to
  ensure that the client's software is up to date.
  </p>
  All calls which require an authenticationToken may throw an
  EDAMUserException for the following reasons:
   <ul>
    <li> AUTH_EXPIRED "authenticationToken" - token has expired
    <li> BAD_DATA_FORMAT "authenticationToken" - token is malformed
    <li> DATA_REQUIRED "authenticationToken" - token is empty
    <li> INVALID_AUTH "authenticationToken" - token signature is invalid
  </ul>
  """
  def checkVersion(self, clientName, edamVersionMajor, edamVersionMinor):
    """
    This should be the first call made by a client to the EDAM service.  It
    tells the service what protocol version is used by the client.  The
    service will then return true if the client is capable of talking to
    the service, and false if the client's protocol version is incompatible
    with the service, so the client must upgrade.  If a client receives a
    false value, it should report the incompatibility to the user and not
    continue with any more EDAM requests (UserStore or NoteStore).
    
    @param clientName
      This string provides some information about the client for
      tracking/logging on the service.  It should provide information about
      the client's software and platform.  The structure should be:
      application/version; platform/version; [ device/version ]
      E.g.   "Evernote Windows/3.0.1; Windows/XP SP3" or
      "Evernote Clipper/1.0.1; JME/2.0; Motorola RAZR/2.0;
    
    @param edamVersionMajor
      This should be the major protocol version that was compiled by the
      client.  This should be the current value of the EDAM_VERSION_MAJOR
      constant for the client.
    
    @param edamVersionMinor
      This should be the major protocol version that was compiled by the
      client.  This should be the current value of the EDAM_VERSION_MINOR
      constant for the client.
    
    Parameters:
     - clientName
     - edamVersionMajor
     - edamVersionMinor
    """
    pass

  def getBootstrapInfo(self, locale):
    """
    This provides bootstrap information to the client. Various bootstrap
    profiles and settings may be used by the client to configure itself.
    
    @param locale
      The client's current locale, expressed in language[_country]
      format. E.g., "en_US". See ISO-639 and ISO-3166 for valid
      language and country codes.
    
    @return
      The bootstrap information suitable for this client.
    
    Parameters:
     - locale
    """
    pass

  def authenticate(self, username, password, consumerKey, consumerSecret):
    """
    This is used to check a username and password in order to create an
    authentication session that could be used for further actions.
    
    This function is only availabe to Evernote's internal applications.
    Third party applications must authenticate using OAuth as
    described at
    <a href="http://dev.evernote.com/documentation/cloud/">dev.evernote.com</a>.
    
    @param username
      The username (not numeric user ID) for the account to
      authenticate against.  This function will also accept the user's
      registered email address in this parameter.
    
    @param password
      The plaintext password to check against the account.  Since
      this is not protected by the EDAM protocol, this information must be
      provided over a protected transport (e.g. SSL).
    
    @param consumerKey
      A unique identifier for this client application, provided by Evernote
      to developers who request an API key.  This must be provided to identify
      the client.
    
    @param consumerSecret
      If the client was given a "consumer secret" when the API key was issued,
      it must be provided here to authenticate the application itself.
    
    @return
      The result of the authentication.  If the authentication was successful,
      the AuthenticationResult.user field will be set with the full information
      about the User.
    
    @throws EDAMUserException <ul>
      <li> DATA_REQUIRED "username" - username is empty
      <li> DATA_REQUIRED "password" - password is empty
      <li> DATA_REQUIRED "consumerKey" - consumerKey is empty
      <li> INVALID_AUTH "username" - username not found
      <li> INVALID_AUTH "password" - password did not match
      <li> INVALID_AUTH "consumerKey" - consumerKey is not authorized
      <li> INVALID_AUTH "consumerSecret" - consumerSecret is incorrect
      <li> PERMISSION_DENIED "User.active" - user account is closed
      <li> PERMISSION_DENIED "User.tooManyFailuresTryAgainLater" - user has
        failed authentication too often
    </ul>
    
    Parameters:
     - username
     - password
     - consumerKey
     - consumerSecret
    """
    pass

  def refreshAuthentication(self, authenticationToken):
    """
    This is used to take an existing authentication token (returned from
    'authenticate') and exchange it for a newer token which will not expire
    as soon.  This must be invoked before the previous token expires.
    
    This function is only availabe to Evernote's internal applications.
    
    @param authenticationToken
      The previous authentication token from the authenticate() result.
    
    @return
      The result of the authentication, with the new token in
      the result's "authentication" field.  The User field will
      not be set in the reply.
    
    Parameters:
     - authenticationToken
    """
    pass

  def getUser(self, authenticationToken):
    """
    Returns the User corresponding to the provided authentication token,
    or throws an exception if this token is not valid.
    The level of detail provided in the returned User structure depends on
    the access level granted by the token, so a web service client may receive
    fewer fields than an integrated desktop client.
    
    Parameters:
     - authenticationToken
    """
    pass

  def getPublicUserInfo(self, username):
    """
    Asks the UserStore about the publicly available location information for
    a particular username.
    
    @throws EDAMUserException <ul>
      <li> DATA_REQUIRED "username" - username is empty
    </ul>
    
    Parameters:
     - username
    """
    pass

  def getPremiumInfo(self, authenticationToken):
    """
    Returns information regarding a user's Premium account corresponding to the
    provided authentication token, or throws an exception if this token is not
    valid.
    
    Parameters:
     - authenticationToken
    """
    pass

  def getNoteStoreUrl(self, authenticationToken):
    """
    Returns the URL that should be used to talk to the NoteStore for the
    account represented by the provided authenticationToken.
    This method isn't needed by most clients, who can retrieve the correct
    NoteStore URL from the AuthenticationResult returned from the authenticate
    or refreshAuthentication calls. This method is typically only needed
    to look up the correct URL for a long-lived session token (e.g. for an
    OAuth web service).
    
    Parameters:
     - authenticationToken
    """
    pass


class Client(Iface):
  """
  Service:  UserStore
  <p>
  The UserStore service is primarily used by EDAM clients to establish
  authentication via username and password over a trusted connection (e.g.
  SSL).  A client's first call to this interface should be checkVersion() to
  ensure that the client's software is up to date.
  </p>
  All calls which require an authenticationToken may throw an
  EDAMUserException for the following reasons:
   <ul>
    <li> AUTH_EXPIRED "authenticationToken" - token has expired
    <li> BAD_DATA_FORMAT "authenticationToken" - token is malformed
    <li> DATA_REQUIRED "authenticationToken" - token is empty
    <li> INVALID_AUTH "authenticationToken" - token signature is invalid
  </ul>
  """
  def __init__(self, iprot, oprot=None):
    self._iprot = self._oprot = iprot
    if oprot is not None:
      self._oprot = oprot
    self._seqid = 0

  def checkVersion(self, clientName, edamVersionMajor, edamVersionMinor):
    """
    This should be the first call made by a client to the EDAM service.  It
    tells the service what protocol version is used by the client.  The
    service will then return true if the client is capable of talking to
    the service, and false if the client's protocol version is incompatible
    with the service, so the client must upgrade.  If a client receives a
    false value, it should report the incompatibility to the user and not
    continue with any more EDAM requests (UserStore or NoteStore).
    
    @param clientName
      This string provides some information about the client for
      tracking/logging on the service.  It should provide information about
      the client's software and platform.  The structure should be:
      application/version; platform/version; [ device/version ]
      E.g.   "Evernote Windows/3.0.1; Windows/XP SP3" or
      "Evernote Clipper/1.0.1; JME/2.0; Motorola RAZR/2.0;
    
    @param edamVersionMajor
      This should be the major protocol version that was compiled by the
      client.  This should be the current value of the EDAM_VERSION_MAJOR
      constant for the client.
    
    @param edamVersionMinor
      This should be the major protocol version that was compiled by the
      client.  This should be the current value of the EDAM_VERSION_MINOR
      constant for the client.
    
    Parameters:
     - clientName
     - edamVersionMajor
     - edamVersionMinor
    """
    self.send_checkVersion(clientName, edamVersionMajor, edamVersionMinor)
    return self.recv_checkVersion()

  def send_checkVersion(self, clientName, edamVersionMajor, edamVersionMinor):
    self._oprot.writeMessageBegin('checkVersion', TMessageType.CALL, self._seqid)
    args = checkVersion_args()
    args.clientName = clientName
    args.edamVersionMajor = edamVersionMajor
    args.edamVersionMinor = edamVersionMinor
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_checkVersion(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = checkVersion_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    raise TApplicationException(TApplicationException.MISSING_RESULT, "checkVersion failed: unknown result");

  def getBootstrapInfo(self, locale):
    """
    This provides bootstrap information to the client. Various bootstrap
    profiles and settings may be used by the client to configure itself.
    
    @param locale
      The client's current locale, expressed in language[_country]
      format. E.g., "en_US". See ISO-639 and ISO-3166 for valid
      language and country codes.
    
    @return
      The bootstrap information suitable for this client.
    
    Parameters:
     - locale
    """
    self.send_getBootstrapInfo(locale)
    return self.recv_getBootstrapInfo()

  def send_getBootstrapInfo(self, locale):
    self._oprot.writeMessageBegin('getBootstrapInfo', TMessageType.CALL, self._seqid)
    args = getBootstrapInfo_args()
    args.locale = locale
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_getBootstrapInfo(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = getBootstrapInfo_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    raise TApplicationException(TApplicationException.MISSING_RESULT, "getBootstrapInfo failed: unknown result");

  def authenticate(self, username, password, consumerKey, consumerSecret):
    """
    This is used to check a username and password in order to create an
    authentication session that could be used for further actions.
    
    This function is only availabe to Evernote's internal applications.
    Third party applications must authenticate using OAuth as
    described at
    <a href="http://dev.evernote.com/documentation/cloud/">dev.evernote.com</a>.
    
    @param username
      The username (not numeric user ID) for the account to
      authenticate against.  This function will also accept the user's
      registered email address in this parameter.
    
    @param password
      The plaintext password to check against the account.  Since
      this is not protected by the EDAM protocol, this information must be
      provided over a protected transport (e.g. SSL).
    
    @param consumerKey
      A unique identifier for this client application, provided by Evernote
      to developers who request an API key.  This must be provided to identify
      the client.
    
    @param consumerSecret
      If the client was given a "consumer secret" when the API key was issued,
      it must be provided here to authenticate the application itself.
    
    @return
      The result of the authentication.  If the authentication was successful,
      the AuthenticationResult.user field will be set with the full information
      about the User.
    
    @throws EDAMUserException <ul>
      <li> DATA_REQUIRED "username" - username is empty
      <li> DATA_REQUIRED "password" - password is empty
      <li> DATA_REQUIRED "consumerKey" - consumerKey is empty
      <li> INVALID_AUTH "username" - username not found
      <li> INVALID_AUTH "password" - password did not match
      <li> INVALID_AUTH "consumerKey" - consumerKey is not authorized
      <li> INVALID_AUTH "consumerSecret" - consumerSecret is incorrect
      <li> PERMISSION_DENIED "User.active" - user account is closed
      <li> PERMISSION_DENIED "User.tooManyFailuresTryAgainLater" - user has
        failed authentication too often
    </ul>
    
    Parameters:
     - username
     - password
     - consumerKey
     - consumerSecret
    """
    self.send_authenticate(username, password, consumerKey, consumerSecret)
    return self.recv_authenticate()

  def send_authenticate(self, username, password, consumerKey, consumerSecret):
    self._oprot.writeMessageBegin('authenticate', TMessageType.CALL, self._seqid)
    args = authenticate_args()
    args.username = username
    args.password = password
    args.consumerKey = consumerKey
    args.consumerSecret = consumerSecret
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_authenticate(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = authenticate_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.userException is not None:
      raise result.userException
    if result.systemException is not None:
      raise result.systemException
    raise TApplicationException(TApplicationException.MISSING_RESULT, "authenticate failed: unknown result");

  def refreshAuthentication(self, authenticationToken):
    """
    This is used to take an existing authentication token (returned from
    'authenticate') and exchange it for a newer token which will not expire
    as soon.  This must be invoked before the previous token expires.
    
    This function is only availabe to Evernote's internal applications.
    
    @param authenticationToken
      The previous authentication token from the authenticate() result.
    
    @return
      The result of the authentication, with the new token in
      the result's "authentication" field.  The User field will
      not be set in the reply.
    
    Parameters:
     - authenticationToken
    """
    self.send_refreshAuthentication(authenticationToken)
    return self.recv_refreshAuthentication()

  def send_refreshAuthentication(self, authenticationToken):
    self._oprot.writeMessageBegin('refreshAuthentication', TMessageType.CALL, self._seqid)
    args = refreshAuthentication_args()
    args.authenticationToken = authenticationToken
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_refreshAuthentication(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = refreshAuthentication_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.userException is not None:
      raise result.userException
    if result.systemException is not None:
      raise result.systemException
    raise TApplicationException(TApplicationException.MISSING_RESULT, "refreshAuthentication failed: unknown result");

  def getUser(self, authenticationToken):
    """
    Returns the User corresponding to the provided authentication token,
    or throws an exception if this token is not valid.
    The level of detail provided in the returned User structure depends on
    the access level granted by the token, so a web service client may receive
    fewer fields than an integrated desktop client.
    
    Parameters:
     - authenticationToken
    """
    self.send_getUser(authenticationToken)
    return self.recv_getUser()

  def send_getUser(self, authenticationToken):
    self._oprot.writeMessageBegin('getUser', TMessageType.CALL, self._seqid)
    args = getUser_args()
    args.authenticationToken = authenticationToken
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_getUser(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = getUser_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.userException is not None:
      raise result.userException
    if result.systemException is not None:
      raise result.systemException
    raise TApplicationException(TApplicationException.MISSING_RESULT, "getUser failed: unknown result");

  def getPublicUserInfo(self, username):
    """
    Asks the UserStore about the publicly available location information for
    a particular username.
    
    @throws EDAMUserException <ul>
      <li> DATA_REQUIRED "username" - username is empty
    </ul>
    
    Parameters:
     - username
    """
    self.send_getPublicUserInfo(username)
    return self.recv_getPublicUserInfo()

  def send_getPublicUserInfo(self, username):
    self._oprot.writeMessageBegin('getPublicUserInfo', TMessageType.CALL, self._seqid)
    args = getPublicUserInfo_args()
    args.username = username
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_getPublicUserInfo(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = getPublicUserInfo_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.notFoundException is not None:
      raise result.notFoundException
    if result.systemException is not None:
      raise result.systemException
    if result.userException is not None:
      raise result.userException
    raise TApplicationException(TApplicationException.MISSING_RESULT, "getPublicUserInfo failed: unknown result");

  def getPremiumInfo(self, authenticationToken):
    """
    Returns information regarding a user's Premium account corresponding to the
    provided authentication token, or throws an exception if this token is not
    valid.
    
    Parameters:
     - authenticationToken
    """
    self.send_getPremiumInfo(authenticationToken)
    return self.recv_getPremiumInfo()

  def send_getPremiumInfo(self, authenticationToken):
    self._oprot.writeMessageBegin('getPremiumInfo', TMessageType.CALL, self._seqid)
    args = getPremiumInfo_args()
    args.authenticationToken = authenticationToken
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_getPremiumInfo(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = getPremiumInfo_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.userException is not None:
      raise result.userException
    if result.systemException is not None:
      raise result.systemException
    raise TApplicationException(TApplicationException.MISSING_RESULT, "getPremiumInfo failed: unknown result");

  def getNoteStoreUrl(self, authenticationToken):
    """
    Returns the URL that should be used to talk to the NoteStore for the
    account represented by the provided authenticationToken.
    This method isn't needed by most clients, who can retrieve the correct
    NoteStore URL from the AuthenticationResult returned from the authenticate
    or refreshAuthentication calls. This method is typically only needed
    to look up the correct URL for a long-lived session token (e.g. for an
    OAuth web service).
    
    Parameters:
     - authenticationToken
    """
    self.send_getNoteStoreUrl(authenticationToken)
    return self.recv_getNoteStoreUrl()

  def send_getNoteStoreUrl(self, authenticationToken):
    self._oprot.writeMessageBegin('getNoteStoreUrl', TMessageType.CALL, self._seqid)
    args = getNoteStoreUrl_args()
    args.authenticationToken = authenticationToken
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_getNoteStoreUrl(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = getNoteStoreUrl_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.userException is not None:
      raise result.userException
    if result.systemException is not None:
      raise result.systemException
    raise TApplicationException(TApplicationException.MISSING_RESULT, "getNoteStoreUrl failed: unknown result");


class Processor(Iface, TProcessor):
  def __init__(self, handler):
    self._handler = handler
    self._processMap = {}
    self._processMap["checkVersion"] = Processor.process_checkVersion
    self._processMap["getBootstrapInfo"] = Processor.process_getBootstrapInfo
    self._processMap["authenticate"] = Processor.process_authenticate
    self._processMap["refreshAuthentication"] = Processor.process_refreshAuthentication
    self._processMap["getUser"] = Processor.process_getUser
    self._processMap["getPublicUserInfo"] = Processor.process_getPublicUserInfo
    self._processMap["getPremiumInfo"] = Processor.process_getPremiumInfo
    self._processMap["getNoteStoreUrl"] = Processor.process_getNoteStoreUrl

  def process(self, iprot, oprot):
    (name, type, seqid) = iprot.readMessageBegin()
    if name not in self._processMap:
      iprot.skip(TType.STRUCT)
      iprot.readMessageEnd()
      x = TApplicationException(TApplicationException.UNKNOWN_METHOD, 'Unknown function %s' % (name))
      oprot.writeMessageBegin(name, TMessageType.EXCEPTION, seqid)
      x.write(oprot)
      oprot.writeMessageEnd()
      oprot.trans.flush()
      return
    else:
      self._processMap[name](self, seqid, iprot, oprot)
    return True

  def process_checkVersion(self, seqid, iprot, oprot):
    args = checkVersion_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = checkVersion_result()
    result.success = self._handler.checkVersion(args.clientName, args.edamVersionMajor, args.edamVersionMinor)
    oprot.writeMessageBegin("checkVersion", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_getBootstrapInfo(self, seqid, iprot, oprot):
    args = getBootstrapInfo_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = getBootstrapInfo_result()
    result.success = self._handler.getBootstrapInfo(args.locale)
    oprot.writeMessageBegin("getBootstrapInfo", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_authenticate(self, seqid, iprot, oprot):
    args = authenticate_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = authenticate_result()
    try:
      result.success = self._handler.authenticate(args.username, args.password, args.consumerKey, args.consumerSecret)
    except evernote.edam.error.ttypes.EDAMUserException, userException:
      result.userException = userException
    except evernote.edam.error.ttypes.EDAMSystemException, systemException:
      result.systemException = systemException
    oprot.writeMessageBegin("authenticate", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_refreshAuthentication(self, seqid, iprot, oprot):
    args = refreshAuthentication_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = refreshAuthentication_result()
    try:
      result.success = self._handler.refreshAuthentication(args.authenticationToken)
    except evernote.edam.error.ttypes.EDAMUserException, userException:
      result.userException = userException
    except evernote.edam.error.ttypes.EDAMSystemException, systemException:
      result.systemException = systemException
    oprot.writeMessageBegin("refreshAuthentication", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_getUser(self, seqid, iprot, oprot):
    args = getUser_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = getUser_result()
    try:
      result.success = self._handler.getUser(args.authenticationToken)
    except evernote.edam.error.ttypes.EDAMUserException, userException:
      result.userException = userException
    except evernote.edam.error.ttypes.EDAMSystemException, systemException:
      result.systemException = systemException
    oprot.writeMessageBegin("getUser", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_getPublicUserInfo(self, seqid, iprot, oprot):
    args = getPublicUserInfo_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = getPublicUserInfo_result()
    try:
      result.success = self._handler.getPublicUserInfo(args.username)
    except evernote.edam.error.ttypes.EDAMNotFoundException, notFoundException:
      result.notFoundException = notFoundException
    except evernote.edam.error.ttypes.EDAMSystemException, systemException:
      result.systemException = systemException
    except evernote.edam.error.ttypes.EDAMUserException, userException:
      result.userException = userException
    oprot.writeMessageBegin("getPublicUserInfo", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_getPremiumInfo(self, seqid, iprot, oprot):
    args = getPremiumInfo_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = getPremiumInfo_result()
    try:
      result.success = self._handler.getPremiumInfo(args.authenticationToken)
    except evernote.edam.error.ttypes.EDAMUserException, userException:
      result.userException = userException
    except evernote.edam.error.ttypes.EDAMSystemException, systemException:
      result.systemException = systemException
    oprot.writeMessageBegin("getPremiumInfo", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_getNoteStoreUrl(self, seqid, iprot, oprot):
    args = getNoteStoreUrl_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = getNoteStoreUrl_result()
    try:
      result.success = self._handler.getNoteStoreUrl(args.authenticationToken)
    except evernote.edam.error.ttypes.EDAMUserException, userException:
      result.userException = userException
    except evernote.edam.error.ttypes.EDAMSystemException, systemException:
      result.systemException = systemException
    oprot.writeMessageBegin("getNoteStoreUrl", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()


# HELPER FUNCTIONS AND STRUCTURES

class checkVersion_args(object):
  """
  Attributes:
   - clientName
   - edamVersionMajor
   - edamVersionMinor
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'clientName', None, None, ), # 1
    (2, TType.I16, 'edamVersionMajor', None, 1, ), # 2
    (3, TType.I16, 'edamVersionMinor', None, 21, ), # 3
  )

  def __init__(self, clientName=None, edamVersionMajor=thrift_spec[2][4], edamVersionMinor=thrift_spec[3][4],):
    self.clientName = clientName
    self.edamVersionMajor = edamVersionMajor
    self.edamVersionMinor = edamVersionMinor

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.clientName = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.I16:
          self.edamVersionMajor = iprot.readI16();
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.I16:
          self.edamVersionMinor = iprot.readI16();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('checkVersion_args')
    if self.clientName is not None:
      oprot.writeFieldBegin('clientName', TType.STRING, 1)
      oprot.writeString(self.clientName)
      oprot.writeFieldEnd()
    if self.edamVersionMajor is not None:
      oprot.writeFieldBegin('edamVersionMajor', TType.I16, 2)
      oprot.writeI16(self.edamVersionMajor)
      oprot.writeFieldEnd()
    if self.edamVersionMinor is not None:
      oprot.writeFieldBegin('edamVersionMinor', TType.I16, 3)
      oprot.writeI16(self.edamVersionMinor)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class checkVersion_result(object):
  """
  Attributes:
   - success
  """

  thrift_spec = (
    (0, TType.BOOL, 'success', None, None, ), # 0
  )

  def __init__(self, success=None,):
    self.success = success

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.BOOL:
          self.success = iprot.readBool();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('checkVersion_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.BOOL, 0)
      oprot.writeBool(self.success)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getBootstrapInfo_args(object):
  """
  Attributes:
   - locale
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'locale', None, None, ), # 1
  )

  def __init__(self, locale=None,):
    self.locale = locale

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.locale = iprot.readString();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getBootstrapInfo_args')
    if self.locale is not None:
      oprot.writeFieldBegin('locale', TType.STRING, 1)
      oprot.writeString(self.locale)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getBootstrapInfo_result(object):
  """
  Attributes:
   - success
  """

  thrift_spec = (
    (0, TType.STRUCT, 'success', (BootstrapInfo, BootstrapInfo.thrift_spec), None, ), # 0
  )

  def __init__(self, success=None,):
    self.success = success

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.STRUCT:
          self.success = BootstrapInfo()
          self.success.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getBootstrapInfo_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.STRUCT, 0)
      self.success.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class authenticate_args(object):
  """
  Attributes:
   - username
   - password
   - consumerKey
   - consumerSecret
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'username', None, None, ), # 1
    (2, TType.STRING, 'password', None, None, ), # 2
    (3, TType.STRING, 'consumerKey', None, None, ), # 3
    (4, TType.STRING, 'consumerSecret', None, None, ), # 4
  )

  def __init__(self, username=None, password=None, consumerKey=None, consumerSecret=None,):
    self.username = username
    self.password = password
    self.consumerKey = consumerKey
    self.consumerSecret = consumerSecret

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.username = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRING:
          self.password = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.STRING:
          self.consumerKey = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 4:
        if ftype == TType.STRING:
          self.consumerSecret = iprot.readString();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('authenticate_args')
    if self.username is not None:
      oprot.writeFieldBegin('username', TType.STRING, 1)
      oprot.writeString(self.username)
      oprot.writeFieldEnd()
    if self.password is not None:
      oprot.writeFieldBegin('password', TType.STRING, 2)
      oprot.writeString(self.password)
      oprot.writeFieldEnd()
    if self.consumerKey is not None:
      oprot.writeFieldBegin('consumerKey', TType.STRING, 3)
      oprot.writeString(self.consumerKey)
      oprot.writeFieldEnd()
    if self.consumerSecret is not None:
      oprot.writeFieldBegin('consumerSecret', TType.STRING, 4)
      oprot.writeString(self.consumerSecret)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class authenticate_result(object):
  """
  Attributes:
   - success
   - userException
   - systemException
  """

  thrift_spec = (
    (0, TType.STRUCT, 'success', (AuthenticationResult, AuthenticationResult.thrift_spec), None, ), # 0
    (1, TType.STRUCT, 'userException', (evernote.edam.error.ttypes.EDAMUserException, evernote.edam.error.ttypes.EDAMUserException.thrift_spec), None, ), # 1
    (2, TType.STRUCT, 'systemException', (evernote.edam.error.ttypes.EDAMSystemException, evernote.edam.error.ttypes.EDAMSystemException.thrift_spec), None, ), # 2
  )

  def __init__(self, success=None, userException=None, systemException=None,):
    self.success = success
    self.userException = userException
    self.systemException = systemException

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.STRUCT:
          self.success = AuthenticationResult()
          self.success.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.userException = evernote.edam.error.ttypes.EDAMUserException()
          self.userException.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.systemException = evernote.edam.error.ttypes.EDAMSystemException()
          self.systemException.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('authenticate_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.STRUCT, 0)
      self.success.write(oprot)
      oprot.writeFieldEnd()
    if self.userException is not None:
      oprot.writeFieldBegin('userException', TType.STRUCT, 1)
      self.userException.write(oprot)
      oprot.writeFieldEnd()
    if self.systemException is not None:
      oprot.writeFieldBegin('systemException', TType.STRUCT, 2)
      self.systemException.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class refreshAuthentication_args(object):
  """
  Attributes:
   - authenticationToken
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'authenticationToken', None, None, ), # 1
  )

  def __init__(self, authenticationToken=None,):
    self.authenticationToken = authenticationToken

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.authenticationToken = iprot.readString();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('refreshAuthentication_args')
    if self.authenticationToken is not None:
      oprot.writeFieldBegin('authenticationToken', TType.STRING, 1)
      oprot.writeString(self.authenticationToken)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class refreshAuthentication_result(object):
  """
  Attributes:
   - success
   - userException
   - systemException
  """

  thrift_spec = (
    (0, TType.STRUCT, 'success', (AuthenticationResult, AuthenticationResult.thrift_spec), None, ), # 0
    (1, TType.STRUCT, 'userException', (evernote.edam.error.ttypes.EDAMUserException, evernote.edam.error.ttypes.EDAMUserException.thrift_spec), None, ), # 1
    (2, TType.STRUCT, 'systemException', (evernote.edam.error.ttypes.EDAMSystemException, evernote.edam.error.ttypes.EDAMSystemException.thrift_spec), None, ), # 2
  )

  def __init__(self, success=None, userException=None, systemException=None,):
    self.success = success
    self.userException = userException
    self.systemException = systemException

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.STRUCT:
          self.success = AuthenticationResult()
          self.success.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.userException = evernote.edam.error.ttypes.EDAMUserException()
          self.userException.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.systemException = evernote.edam.error.ttypes.EDAMSystemException()
          self.systemException.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('refreshAuthentication_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.STRUCT, 0)
      self.success.write(oprot)
      oprot.writeFieldEnd()
    if self.userException is not None:
      oprot.writeFieldBegin('userException', TType.STRUCT, 1)
      self.userException.write(oprot)
      oprot.writeFieldEnd()
    if self.systemException is not None:
      oprot.writeFieldBegin('systemException', TType.STRUCT, 2)
      self.systemException.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getUser_args(object):
  """
  Attributes:
   - authenticationToken
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'authenticationToken', None, None, ), # 1
  )

  def __init__(self, authenticationToken=None,):
    self.authenticationToken = authenticationToken

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.authenticationToken = iprot.readString();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getUser_args')
    if self.authenticationToken is not None:
      oprot.writeFieldBegin('authenticationToken', TType.STRING, 1)
      oprot.writeString(self.authenticationToken)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getUser_result(object):
  """
  Attributes:
   - success
   - userException
   - systemException
  """

  thrift_spec = (
    (0, TType.STRUCT, 'success', (evernote.edam.type.ttypes.User, evernote.edam.type.ttypes.User.thrift_spec), None, ), # 0
    (1, TType.STRUCT, 'userException', (evernote.edam.error.ttypes.EDAMUserException, evernote.edam.error.ttypes.EDAMUserException.thrift_spec), None, ), # 1
    (2, TType.STRUCT, 'systemException', (evernote.edam.error.ttypes.EDAMSystemException, evernote.edam.error.ttypes.EDAMSystemException.thrift_spec), None, ), # 2
  )

  def __init__(self, success=None, userException=None, systemException=None,):
    self.success = success
    self.userException = userException
    self.systemException = systemException

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.STRUCT:
          self.success = evernote.edam.type.ttypes.User()
          self.success.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.userException = evernote.edam.error.ttypes.EDAMUserException()
          self.userException.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.systemException = evernote.edam.error.ttypes.EDAMSystemException()
          self.systemException.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getUser_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.STRUCT, 0)
      self.success.write(oprot)
      oprot.writeFieldEnd()
    if self.userException is not None:
      oprot.writeFieldBegin('userException', TType.STRUCT, 1)
      self.userException.write(oprot)
      oprot.writeFieldEnd()
    if self.systemException is not None:
      oprot.writeFieldBegin('systemException', TType.STRUCT, 2)
      self.systemException.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getPublicUserInfo_args(object):
  """
  Attributes:
   - username
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'username', None, None, ), # 1
  )

  def __init__(self, username=None,):
    self.username = username

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.username = iprot.readString();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getPublicUserInfo_args')
    if self.username is not None:
      oprot.writeFieldBegin('username', TType.STRING, 1)
      oprot.writeString(self.username)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getPublicUserInfo_result(object):
  """
  Attributes:
   - success
   - notFoundException
   - systemException
   - userException
  """

  thrift_spec = (
    (0, TType.STRUCT, 'success', (PublicUserInfo, PublicUserInfo.thrift_spec), None, ), # 0
    (1, TType.STRUCT, 'notFoundException', (evernote.edam.error.ttypes.EDAMNotFoundException, evernote.edam.error.ttypes.EDAMNotFoundException.thrift_spec), None, ), # 1
    (2, TType.STRUCT, 'systemException', (evernote.edam.error.ttypes.EDAMSystemException, evernote.edam.error.ttypes.EDAMSystemException.thrift_spec), None, ), # 2
    (3, TType.STRUCT, 'userException', (evernote.edam.error.ttypes.EDAMUserException, evernote.edam.error.ttypes.EDAMUserException.thrift_spec), None, ), # 3
  )

  def __init__(self, success=None, notFoundException=None, systemException=None, userException=None,):
    self.success = success
    self.notFoundException = notFoundException
    self.systemException = systemException
    self.userException = userException

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.STRUCT:
          self.success = PublicUserInfo()
          self.success.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.notFoundException = evernote.edam.error.ttypes.EDAMNotFoundException()
          self.notFoundException.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.systemException = evernote.edam.error.ttypes.EDAMSystemException()
          self.systemException.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.STRUCT:
          self.userException = evernote.edam.error.ttypes.EDAMUserException()
          self.userException.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getPublicUserInfo_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.STRUCT, 0)
      self.success.write(oprot)
      oprot.writeFieldEnd()
    if self.notFoundException is not None:
      oprot.writeFieldBegin('notFoundException', TType.STRUCT, 1)
      self.notFoundException.write(oprot)
      oprot.writeFieldEnd()
    if self.systemException is not None:
      oprot.writeFieldBegin('systemException', TType.STRUCT, 2)
      self.systemException.write(oprot)
      oprot.writeFieldEnd()
    if self.userException is not None:
      oprot.writeFieldBegin('userException', TType.STRUCT, 3)
      self.userException.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getPremiumInfo_args(object):
  """
  Attributes:
   - authenticationToken
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'authenticationToken', None, None, ), # 1
  )

  def __init__(self, authenticationToken=None,):
    self.authenticationToken = authenticationToken

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.authenticationToken = iprot.readString();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getPremiumInfo_args')
    if self.authenticationToken is not None:
      oprot.writeFieldBegin('authenticationToken', TType.STRING, 1)
      oprot.writeString(self.authenticationToken)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getPremiumInfo_result(object):
  """
  Attributes:
   - success
   - userException
   - systemException
  """

  thrift_spec = (
    (0, TType.STRUCT, 'success', (PremiumInfo, PremiumInfo.thrift_spec), None, ), # 0
    (1, TType.STRUCT, 'userException', (evernote.edam.error.ttypes.EDAMUserException, evernote.edam.error.ttypes.EDAMUserException.thrift_spec), None, ), # 1
    (2, TType.STRUCT, 'systemException', (evernote.edam.error.ttypes.EDAMSystemException, evernote.edam.error.ttypes.EDAMSystemException.thrift_spec), None, ), # 2
  )

  def __init__(self, success=None, userException=None, systemException=None,):
    self.success = success
    self.userException = userException
    self.systemException = systemException

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.STRUCT:
          self.success = PremiumInfo()
          self.success.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.userException = evernote.edam.error.ttypes.EDAMUserException()
          self.userException.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.systemException = evernote.edam.error.ttypes.EDAMSystemException()
          self.systemException.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getPremiumInfo_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.STRUCT, 0)
      self.success.write(oprot)
      oprot.writeFieldEnd()
    if self.userException is not None:
      oprot.writeFieldBegin('userException', TType.STRUCT, 1)
      self.userException.write(oprot)
      oprot.writeFieldEnd()
    if self.systemException is not None:
      oprot.writeFieldBegin('systemException', TType.STRUCT, 2)
      self.systemException.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getNoteStoreUrl_args(object):
  """
  Attributes:
   - authenticationToken
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'authenticationToken', None, None, ), # 1
  )

  def __init__(self, authenticationToken=None,):
    self.authenticationToken = authenticationToken

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.authenticationToken = iprot.readString();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getNoteStoreUrl_args')
    if self.authenticationToken is not None:
      oprot.writeFieldBegin('authenticationToken', TType.STRING, 1)
      oprot.writeString(self.authenticationToken)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getNoteStoreUrl_result(object):
  """
  Attributes:
   - success
   - userException
   - systemException
  """

  thrift_spec = (
    (0, TType.STRING, 'success', None, None, ), # 0
    (1, TType.STRUCT, 'userException', (evernote.edam.error.ttypes.EDAMUserException, evernote.edam.error.ttypes.EDAMUserException.thrift_spec), None, ), # 1
    (2, TType.STRUCT, 'systemException', (evernote.edam.error.ttypes.EDAMSystemException, evernote.edam.error.ttypes.EDAMSystemException.thrift_spec), None, ), # 2
  )

  def __init__(self, success=None, userException=None, systemException=None,):
    self.success = success
    self.userException = userException
    self.systemException = systemException

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.STRING:
          self.success = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.userException = evernote.edam.error.ttypes.EDAMUserException()
          self.userException.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.systemException = evernote.edam.error.ttypes.EDAMSystemException()
          self.systemException.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getNoteStoreUrl_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.STRING, 0)
      oprot.writeString(self.success)
      oprot.writeFieldEnd()
    if self.userException is not None:
      oprot.writeFieldBegin('userException', TType.STRUCT, 1)
      self.userException.write(oprot)
      oprot.writeFieldEnd()
    if self.systemException is not None:
      oprot.writeFieldBegin('systemException', TType.STRUCT, 2)
      self.systemException.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)
