




# 0.8.6 Release

- author: Markus Raab
- pubDate: Sat, 21 Jun 2014 12:00:00 +0100
- shortDesc: adds technical previews & other improvements

## Introduction

The Elektra Initiative moved to Github for following reasons:

- We were seriously missing a bug tracker
- It may make collaboration easier
- Build Server Integration:
    - [Build on MergeRequests](https://build.libelektra.org/job/elektra-mergerequests/) waits for the first merge request to be built!
    - And the build status is now published [for this job](https://build.libelektra.org/job/elektra-gcc47-all/)

The main entrance point and URL for any advertisement and linking stays

https://www.libelektra.org

(which points to github at the moment).

Additionally (not related to github), we now have a
[LCOV code coverage report](https://doc.libelektra.org/coverage/latest/)!

## Improvements

The hosts plugin got documentation and several bug fixes.
Multiline comments now remove the comment start sequences within
the metadata comment.
Additionally the kdb tool has an improved error message on invalid
filenames. (thanks to Manuel Mausz)

Fix a issue that the resolver plugin did not delete tmpfile in some
error situations and add testcases with error plugin.

Fix KS_END in C++ that did not specify the namespace.

"kdb run_all" will now run all tests using Elektra from your system.
Because not all testdata will be installed, some testcases fail unless
you copy the data manually. Those are:
testmod_yajl testmod_augeas testmod_fstab testmod_hosts test_xml

Virtually all clang compiler warnings were fixed
(thanks to Felix Berlakovich).

kdb mv now is atomic. (API was used wrongly in the tool)

Clang, icc and gcc are now all supported and tested.

## Technical Previews

A plugin that logs write operations and errors via the native
journald interface was added (thanks to Felix Berlakovich).

A preview of the augeas plugin was added. In cmake add "augeas" to PLUGINS
and then run "kdb info augeas" for further instructions. Additionally,
see Outlook below (thanks to Felix Berlakovich).

A preview of python3 and lua bindings were added. In cmake enable the
options BUILD_SWIG BUILD_SWIG_LUA BUILD_SWIG_PYTHON so that they are
compiled (thanks to Manuel Mausz).

The code generator was extended to support contextual values, more
information about that topic later.

The libtools library is back to life again! It has the same idea as its
predecessor, but it is much more powerful. Because of the plugin system
libtools is able to export and import any configuration format
Elektra supports. Additionally it adds support for mounting backends.
While most of its functionality is mature, the API is not final, though.

## API Changes

The API and ABI is as always backwards-compatible within the 0.8 series.

This time it is, however, not forward-compatible (that means programs
linked against 0.8.6 might not work with 0.8.5), because ksAtCursor()
was added.

ksAtCursor() provides the means for an external iterator. This
was immediately exploited by an implementation of the C++
iterators. These new C++(11) (reverse)iterators allow multi-pass
algorithm over the same KeySet.

ksSort was in the kdb.h header file, even though it never was
needed nor available in 0.8. Automatic compatibility checkers may
wrongly tell that the API is not compatible, but this is not the case
(thanks to Manuel Mausz).

The C++ API changed, including:
- does not wrongly convert garbage to default types using ```get<T>```
- getMeta now interally uses ```get<T>``` and both throw the
  KeyTypeConversion Exception
- KeySet::at directly allows one to use ksAtCursor()
- KeyTypeConversion (or former KeyBadMeta) is not thrown anymore if key
  is not available
- Key::hasMeta allows one to directly check if metadata is available

CMake: ENABLE_CXX11 is now default OFF (because gcc 4.6 and older won't
       work with it). It disables some tests, though.
unique_ptr will automatically be used instead of auto_ptr in this mode.

Note for maintainers: libelektratools now needs to be installed so that
the kdb tool will work.

## Outlook

One drawback of Elektra is the small number of available storage
plugins. While writing storage plugins isn't too hard, it still requires
knowledge of Elektra’s plugin architecture. In addition it is always
necessary to keep both translation directions in mind (from file to
Elektra and back).  In order to mitigate this issue Felix Berlakovich
is working on an Elektra storage plugin which uses Augeas [1] to read
and manipulate configuration files. Augeas uses a concept called lenses
to translate between files and abstract trees (i.e. trees that hide
unimportant details like whitespaces). In brief, what makes lenses special
is the fact that they automatically disallow translations that cannot be
reversed. This means that one of the translation directions comes for free
as it is implicitly described by the other one. Therefore writing lenses
is much simpler than programming both directions explicitly as done in
traditional Elektra storage plugins.  Furthermore many lenses for common
applications like Apache, MySQL, DHCPd and many more [2] already exist.
Besides these benefits, Augeas lacks many features of Elektra. Although
this is mostly intended because Augeas aims to concentrate just on
configuration file manipulation some of these features would be valuable
for administrators and developers. Some of these mentioned Elektra
features include but are not limited to: logging of all configuration
changes done, transformation of character encoding as needed, import and
export of configuration data in any format, e.g. XML or JSON (Augeas has
a similar feature for XML), file conflict detection and several different
validations for configuration options (see [3] for a full list of
features). With the Augeas storage plugin these features cannot be used
with only the applications already integrated into Elektra, but with all
applications for which lenses exist.  This storage plugin targets system
administrators as well as developers, that wish to take advantage of
Elektra’s features, but were unable to do so because of missing plugins. If
no lens exists already, writing a new one requires neither programming
skills nor knowledge of Elektra’s plugin architecture. Furthermore,
implementing a new configuration file format is just a matter of writing a
lens instead of writing a full-fledged parser.
[1] http://augeas.net/
[2] http://augeas.net/stock_lenses.html
[3] https://www.libelektra.org

Since Elektra is written in C, integration is limited to projects
written in C and languages compatible with C like C++. In order to
change this situation Manuel Mausz is working on the implementation of
language bindings using two different techniques.  The first technique
uses SWIG as a generic generator for various languages. In a nutshell,
SWIG is a compiler that takes C/C++ declarations and creates the wrappers
needed to access those declarations from other languages. The second
technique is called GObject Introspection. In contrast to SWIG, GObject
Introspection generates a language independent metadata file. For dynamic
languages the GObject Introspection support in the target language will
load this metadata file to generate bindings at run-time. In order to
provide bindings for static languages a compiler on the metadate file
will be used. This is comparable to using SWIG. Manuel will focus on
implementing language bindings for Python and Lua though both techniques
will support various other languages.  As language bindings only allow
to call into Elektra’s API Manuel will also embed the interpreters of
both Python and Lua into two generic plugins. Using these plugins in
combination with the languages bindings it will be fully possible to
write plugins for Elektra in languages other than C/C++.

While Elektra offers sophisticated methods to store and manipulate
configuration, currently there is only a command line tool (kdb)
available to interact with the database. This requires the user to study
and learn the possible commands and does not allow free exploration of the
options of the application.  To enable new ways to interact with Elektra,
Raffael Pancheri is designing and implementing a Graphical User Interface
(GUI). To increase the probability to create a GUI that is indeed usable
and beneficial, Pancheri is following the design principles proposed by
Ben Shneiderman and Jakob Nielson.

Finally, as you already noticed, Ian Donnelly is working on a semantic
3-way merge to make distribution and package upgrades smoother.
This is done as GSOC project. The progress is documented here:
http://community.libelektra.org/wp/

## Get It!

You can download the release at:
 http://www.markus-raab.org/ftp/elektra/releases/elektra-0.8.6.tar.gz
 
- size: 1188337
- md5sum: 4a59824e70a29295e9ef9ae7605d9299
- sha1: 2570710b0057470223611ca00d61a0196e54e7b2
- sha256: e815cf69b070c339784472841aa0ee0b169fab7c78f41cbbd7044f53fa9ed216

Docu can be found here:
 https://doc.libelektra.org/api/0.8.6/html/

You can install the debian packages for debian (wheezy, amd64 only,
some packages will be added later) by adding following lines to your
/etc/apt/sources.list:
 deb http://markus-raab.org/ftp/wheezy wheezy main

and install or upgrade the packages with:
 sudo apt-get update
 sudo apt-get install libelektra-core4 libelektra-full4 libelektra-bin libelektra-dev libelektra-test libelektra-xmltool4 libelektra-json4 libelektra-dbus4 libelektra-doc

Best regards,
Markus





# 0.8.7 release

- author: Markus Raab
- pubDate: Mon, 28 Jul 2014 12:00:00 +0100
- shortDesc: adds python2 bindings, 3-way merge & improvements

Again, we managed to have a great feature release with dozens of
corrections!

## New Features

Thanks to Manuel Mausz for further improving lua, python3 bindings
and the new python2 bindings.

The GSoC efforts have their first large contribution to Elektra, the 3
way merge finally arrives with this release. It is still a long way to
go, however, because augeas plugins can only be mounted with a
workaround and the package integration of the 3-way merge is still in
its infancy. More information about GSoC and its progress can be found
[here](http://community.libelektra.org/wp).

A special thanks to  Felix Berlakovich for his contributions to the
3-way merge, including meta merging, conflict resolving strategies and
extensive testing.

Additionally, he added the plugins keytometa, ini and greatly improved
the glob plugin. These plugins are technical previews and will receive
some improvements in the next release, too.

Now a script for tab completion is available
[here](/scripts/kdb-bash-completion), again thanks to Felix
Berlakovich.

The contextual values now got a [tutorial]
(https://github.com/ElektraInitiative/libelektra/tree/master/src/tools/gen)
and small fixes.

## Corrections

Thanks to Pino Toscano for fixing a lot of spelling errors, simplify
RPATH setting, respect $HOME and $TMPDIR, improvements of test cases,
and his debian-packaging efforts.

In the kdb tool not allowed subfolders are now checked properly
and the output of warnings comes before output of the error.
This fixes the problem that in the case of a longer list of
warnings one did not see the error anymore.

Fix compilation warnings on clang and gcc 4.9.
Also improve test coverage on kdb tool and some plugins.

Fix kdb import/export for some plugins (Should now work with any storage
plugin again).

kdb run_all should run flawlessly with this release. Remaining problems
with not installed test data were fixed. kdb run_all also checks if the
test cases do not modify any existing key and keeps a backup if this
happened.

Some remaining mem leaks in rare circumstances were fixed. Valgrind
should now never report any leaks, if it does, please report the issue.

## API Changes

Added delMeta() for C++, because setMeta() with NULL will set the
number 0 and not remove the meta.

Arguments of isBelow, isDirectBelow, isBelowOrSame are swapped for
better readability. k.isBelow(root) now means the obvious thing.
The change only effects the C++ binding, keyIsBelow is unaffected by
the change.

## Documentation

[Specification of metadata](/doc/METADATA.ini) and
[contracts](/doc/CONTRACT.ini) written/greatly improved.

[Decisions](/doc/decisions) are introduced again.

Most often the KeySet is ideal, e.g. when doing full iteration or when
performing set operations. In some cases, however, a hierarchical data
structure fits better. This is especially true for GUIs. Luckily, Keys
can be in multiple data structures because of their reference counting.

## Other Stuff

We now fully embrace github:
- We use its issue tracker (all issues from local text files were moved
  there)
- We have rewritten many READMEs to use githubs markdown
- On pull requests the build server checks if the merge would break
  the build.
- All previous gitorious users are now at github. (Most had an account
  anyway)

Raffael Pancheri also made progress with its qt-gui. It now features a
model that implements great parts of Elektra’s features. Unfortunately
the model cannot be serialised and thus changes cannot made persistent.
Also undo and other important use-cases are still not there. The GUI
looks very clean and was evaluated in a SUS study on 23.07.2014.
The current implementation can be found [here]
(https://github.com/0003088/qt-gui).

Many distributions already have Elektra packages
 - [Fedora](https://admin.fedoraproject.org/pkgdb/package/elektra/)
 - [Gentoo](http://packages.gentoo.org/package/app-admin/elektra)
 - [Arch Linux](https://aur.archlinux.org/packages/elektra/)

In some distributions Elektra packages are available, but are not
up-to-date. Pino Toscano is working on get them (actually
Debian, but others are derived from it) up-to-date.
 - [Ubuntu](https://launchpad.net/ubuntu/+source/elektra)
 - [Debian](https://packages.debian.org/de/wheezy/libelektra3)
 - [Linux Mint](http://community.linuxmint.com/software/view/elektra)

A special thanks to Kai-Uwe Behrmann for providing packages for
[CentOS, Fedora, OpenSUSE, RHEL and
SLE](http://software.opensuse.org/download.html?project=home%3Abekun&package=elektra).

## Get It!

You can download the release from:

http://www.markus-raab.org/ftp/elektra/releases/elektra-0.8.7.tar.gz
size: 1566800
md5sum: 4996df62942791373b192c793d912b4c
sha1: 00887cc8edb3dea1bc110f69ea64f6b700c29402
sha256: 698ebd41d540eb0c6427c17c13a6a0f03eef94655fbd40655c9b42d612ea1c9b

already build API-Docu can be found here:

https://doc.libelektra.org/api/0.8.7/html/

Best regards,
Markus





# 0.8.8 Release

- guid: eca69e19-5ddb-438c-ac06-57c20b1a9160
- author: Markus Raab
- pubDate: Tue, 02 Sep 2014 17:31:42 +0200
- shortDesc: adds 3-way merging, reworked documentation & improved kdb tool

In this release we changed 578 files in 473 commits
(68596 insertions(+), 59260 deletions(-) compared to Elektra 0.8.7).
We assume thats the largest change set for any of Elektra’s releases
up to now. It happened only within a bit more than a month up
(0.8.7 was released 28.07.2014).

## New features

GSoC finished successfully (thanks Ian and Felix)
See http://community.libelektra.org/wp for the latest results.
So Elektra now has a 3-way merging framework that is superior
to text-based merging in many scenarios (e.g. moving configuration
options within a file or with in-line comments) iff a storage plugin
creates key names that are not only line numbers.
We love to get Feedback!

Writing plugins is now even more comfortable.
A plugin writer tutorial was written (thanks Ian):
https://github.com/ElektraInitiative/libelektra/blob/master/doc/tutorials/plugins.md
The documentation was completely reworked:
https://doc.libelektra.org/api/0.8.7/html/group__plugin.html
And two new macros allow printf formating for warnings and errors
(ELEKTRA_ADD_WARNINGF and ELEKTRA_SET_ERRORF).

The ini plugin was greatly improved (tested with samba configurations
and added to ALL plugins) and the hosts plugin was rewritten to support
ipv6 properly (thanks to Felix).

The constants plugin was added and allows introspection of Elektra’s
cmake variables. Because such non-file based plugins (e.g. also uname)
do not need resolving, the plugin noresolver was added. It supersedes
the success plugin.

Elektra now allows one to correctly fsync its configuration files
(sync plugin) and the folders where files are stored (resolver plugin).
Just make sure to add the "sync" plugin using kdb mount.
The resolver plugin now reads from passwd and no longer needs
environment variables.  Additionally, the resolver plugin was prepared
to support other variants by so called compilation variants.

The error plugin now allows, next to list all possible errors, to
provoke errors when opening plugins. We fixed some issues related
to plugins having errors when they initialize themselves.

So following plugins were added: sync noresolver line ini constants
Nearly all plugins now have a README.md for further information
(thanks to Ian). An overview of all plugin is on with links to them:
https://github.com/ElektraInitiative/libelektra/blob/master/src/plugins/

The kdb tools were greatly improved (thanks to Felix):
- added remount tool
- umount now also accepts mountpath
- mount allows one to specify different resolvers
- import now can use merge strategies
- check without arguments checks key database
- mount is now more verbose when validation fails

New/improved scripts/make targets (note that scripts can be executed by
kdb scriptname):
- mounting, unmounting scripts were added
- generate template for a new plugin was improved
- configure-debian was added
- added targets run_all and run_memcheck
- bash completion file now installed
- ucf integration
- merging scripts were added for the usage with ucf
- scripts doing internal checks on source of plugins

## Compatibility

This time we had to break compatibility. We did not change the ABI (your
application still will be able to use Elektra 0.8.8) and we did not
change the API (your application still will compile against Elektra). We
changed the third part of our interface: the semantic interface.

The problems were following:
keyAddBaseName/keySetBaseName did something obvious when no special
characters were in the baseName. But once there were, there are two
different interpretations what it should do:
1.) add/set a basename, so escape characters that are not canonical
    in the basename
2.) add all parts of the name given (with slashes)

The methods were used in both ways, so it was obvious that something is
very wrong. We decided that it should do what the name says, that is
add/set a basename (variant 1).

The variant 2, to add any name was added and is called keyAddName() and
added as proposal.

(Thank Felix for implementations and Manuel for investigations)

When keys are renamed after adding to a keyset is a bad thing because it
destroys the order of the keyset. This is now avoided by keyLock.
Use keyDup() to get rid of such locks.

Another, even larger, change is also about ordering of keys in keysets.
Elektra now internally has an null-terminated unescaped key name.
Ordering of keysets will always happen on this name. The keyCmp() tool
can be used to check this order. It works very efficiently with
memcmp() and never gets confused by ASCII ordering of / (because / is
0 in the unescaped key name).

The syntax, semantics and conventions of key names is now documented in
detail:
https://doc.libelektra.org/api/0.8.8/html/group__keyname.html

ksNew() does now return a keyset with a properly set cursor (ksRewind).

Because its always possible that software relies on bugs the
better way to deal with such a situation (as the keySetBaseName()
situation described above) is to provide the same function twice.
Manuel said he will create a prototype to introduce symbol versioning
in Elektra. With that, old customers would still receive the old
behaviour, but people compiling against a new version would get the new
behaviour. So in one of the next releases we will also avoid semantic
interface changes when there is a valid use case for it (there is none
if the program e.g.  crashes).

Symbol versioning also allows one to compile against old versions on
purpose if you do not want the new behaviour.

We have prepared an ABI-test suite, that also checks behaviour,
for that purpose, but we also improved testing in other parts:
- (New Test strategy)[/doc/TESTING.md]
- New resolver tests for conflicts (needs tty)

If you try to execute test_ks from 0.8.7 with libelektra 0.8.8 it will
crash, but not because of any incompatibility, but because of strcmp in
the test itself gets a null pointer. The pointer is now null, because
ksNew correctly rewinds its internal cursor (see above). Amusingly,
it says on that line 94 in test_ks.c:
  // TODO: why is the cursor here?

## API Proposals

see above for more information:
- keyAddName         ..  add key name without escaping, like keySetName
- keyUnescapedName   ..  get access to null-separated unescaped name
- keyLock            ..  to allow one to secure keys against modifications

some new ideas:
- keySetStringF      ..  printf format-style changing of the key string
- elektraKeySetName  ..  to allow one to set meta + cascading keys

elektraArrayIncName() now works correctly with empty arrays embedded in
other arrays (yajl+line plugin)

elektraArrayValidateName() was also added, thanks to Felix.

These methods are declared in the file kdbproposal.h
but do not guarantee any forms of compatibility (they might
even be removed).

## Issues

Many issues were resolved as you can see in github:
https://github.com/ElektraInitiative/libelektra/issues
Alone for the milestone 0.8.8 we closed 17 issues, including
those mentioned in "Compatibility". Other issues (not all were
tracked on github):

- fix undefined errors in kdbOpen() or kdbClose()
- Now Python 2+3 work in parallel
- python2 interpreter is found correctly (also on Arch)
- Sentinel now makes sure that you cannot forget KS_END to end ksNew
- Fixes for architecture-specific problems by Pino
- fix .pc file
- fix compilation problem with KDB_MAX_PATH_LENGTH
- tmpnam to mkstemp (security)
- make test data naming consistent (thanks Pino)
- use LIB_SUFFIX for TARGET_TOOL_EXEC_FOLDER thanks to Kai Uwe
- Fix search for boost (thank Pino)

## Other Stuff

Thanks to Pino Toscano Elektra 0.8.7-4 is now available in Debian
Testing: https://packages.debian.org/search?keywords=elektra
So it is only a matter of time that other (debian-based) distributions
will follow and replace the dusty Elektra 0.7.

Debian Continuous Integration http://ci.debian.net/packages/e/elektra
(thanks Pino)
greatly complement our tests running on https://build.libelektra.org/

Elektra’s buildserver also was improved:

 - now also compiles with icc
 - runs make run_memcheck
 - checks if plugins are added correctly in-source
 - runs ABI + behavioural tests

Raffael Pancheri now made a merge request for qt-gui
https://github.com/ElektraInitiative/libelektra/pull/103/files
in which copy, paste and delete of keys already works.
It is, however, still work in progress.

Manuel Mausz made great progress in script-based Elektra plugins. He is
also working on glib+gobject-introspection based bindings.
He investigated some issues, e.g. a crash of the python binding which
was only triggered if python3 is build with a specific flag/module
combination, see:
https://github.com/ElektraInitiative/libelektra/issues/25

## Get It!

You can download the release from:

http://www.markus-raab.org/ftp/elektra/releases/elektra-0.8.8.tar.gz

- size: 1644441
- md5sum: fe11c6704b0032bdde2d0c8fa5e1c7e3
- sha1: 16e43c63cd6d62b9fce82cb0a33288c390e39d12
- sha256: ae75873966f4b5b5300ef5e5de5816542af50f35809f602847136a8cb21104e2

already built API-Docu can be found here:

https://doc.libelektra.org/api/0.8.8/html/

Best regards,
Markus





# Augeas and Config::Model

- author: Markus Raab
- guid: eca69e19-5ddb-438c-ac06-57c20b1a9160
- pubDate: Mon, 22 Oct 2014 17:31:42 +0200

A common question is: now we have Augeas for editing config files,
why do we need Elektra, Config::Model or something else?

First, it is clear that Augeas is a huge step forward and improved
configuration of Linux systems, especially when used with centralized
configuration management tools.

Augeas, in short, introduces a special-purpose programming language that
allows to transform configuration files into configuration trees and
back. This transformation is it strength (so it is easy to add support
for a particular legacy configuration files), but also it weakness (the
mapping is implementation-defined by a language that is limited to a bit
more than regular expressions). Augeas is not able nor is it intended
to provide more abstraction over the configuration files. Instead Augeas
mirrors the structure of the configuration as closely as possible.

Elektra’s goal, instead, is not only to provide access to legacy
configuration files, but to provide access to the configuration
exactly as the programs itself uses it. So with Elektra, the developers of
applications are part of Elektra’s ecosystem by providing specifications
how their configuration should look like and by writing plugins that
define how the configuration is accessed and checked. Ideally, after
some time of legacy issues and migration, developers will also not
have to care about writing plugins anymore, but just use any available
ones (and users of their application can choose any other compatible
plugin).  What is about to stay is a specification that defines the
application's configuration, e.g. in INI (could be any syntax):

    [/yourapp/file_dialog/show_hidden_files]
    type=Boolean
    default=true

allows other applications to reuse your setting show_hidden_files by
referring to above specification. So Elektra not only abstracts from
cross-platform-related issues with an consistent API, but also allows
us to be aware of other applications' configurations, leveraging easy
application integration.

Config::Model shares most of Elektra’s goals, especially those regarding
validation (you saw the type=Boolean above) and having a unified
interface for all programs (this feature is unavoidable with any such
approach). The projects mainly differs that Elektra is supposed to be used
by the programs themselves (and not only by GUIs and validation tools)
and that Elektra uses self-describing data: the specification itself
is also in Elektra’s key database, stored in metadata and e.g. below
system/elektra/mountpoints. In Elektra validators can be
written in any language (because the specification is just data)
and can enforce constraints on any access (because plugins define
the behaviour of the key database).






# 0.8.9 Release

- guid: 38640673-3e07-4cff-9647-f6bdd89b1b08
- author: Markus Raab
- pubDate: Tue, 04 Nov 2014 10:48:14 +0100
- shortDesc: adds qt-gui, several optimizations & fixes

Again we managed to do an amazing feature release in just two month.
In 416 commits we modified 393 files with 23462 insertions(+) and
9046 deletions(-).

## Most awaited

The most awaited feature in this release is certainly the *qt-gui*
developed by Raffael Pancheri. It includes a rich feature set including
searching, unmounting, importing and exporting. A lot of functionality
is quite stable now, even though its version is 0.0.1 alpha. If you find
any bugs or want to give general feedback, feel free to use the issue
tracker of the Elektra project. A screenshot can be found
[here](https://github.com/ElektraInitiative/libelektra/blob/master/doc/images/screenshot-qt-gui.png)
To compile it (together with Elektra), see the README
[here](https://github.com/ElektraInitiative/libelektra/tree/master/src/tools/qt-gui)

Manuel Mausz also has been very active and developed glib+gi bindings.
These bindings make Elektra more friendly to the glib/gtk/gnome world.
Using the gobject introspection python3 and lua bindings were developed.
Additionally he got rid of all clang warnings.

Felix Berlakovich also made progress: [the ini
plugin](https://github.com/ElektraInitiative/libelektra/tree/master/src/plugins/ini)
now supports multiline and
which can be dynamically turned on and off, i.e. during mounting
(thanks to Felix)

Last, but not least, Kai-Uwe ported Elektra to Windows7. MinGW is now
one more supported compiler (tested on build-server, see later).
Astonishingly, it was only little effort necessary:
Basically we only needed a new implementation of the resolver, which
is now called *wresolver*. Different from the *resolver* it lacks the
sophisticated multi-process and multi-thread atomicity properties. On
the plus side we now have a resolver that is very easy to study and
understand and still works as file resolver (_noresolver_ does not).

## Interfaces

ABI/API of the C-API is still completely stable even though under the
hood a lot was changed. All testcases compiled against the previous
version still run against Elektra 0.8.9.

This is, however, not the case for libtools. For MinGW porting it was
necessary to rename an enum related to merging because it conflicted
with an already defined MACRO.

For maintainers also some changes are necessary. For MinGW and to
actually use the flexibility of the new resolver variants two new CMake
Variables are introduced: KDB_DEFAULT_RESOLVER and KDB_DEFAULT_STORAGE.

More importantly for maintainers the CMake variables regarding SWIG
bindings are now abandoned in favour to the new variable BINDINGS that
works like PLUGINS and TOOLS. Just start with

	-DBINDINGS=ALL

and CMake should remove the bindings that have missing dependencies
on your system. Remember that glib and gi (i.e. *gi_python3* and
*gi_lua*) bindings were introduced, too. Additionally, the *cpp*
binding can now be deactivated if not added to BINDINGS.

Finally, the *gen* tool added a Python package called `support`.

## Other Bits

A proof of concept storage plugin `regexstore` was added. It allows one to
capture individual configuration options within an otherwise not
understood configuration file (e.g. for vimrc or emacs where
the configuration file may contain programming constructs).

Most tests now also work with the BUILD_SHARED variant (from our
knowledge all would work now, but some are still excluded if
BUILD_FULL and BUILD_STATIC is disabled. Please report issues
if you want to use uncommon CMake combinations).

A small but very important step towards specifying configuration files
is the new proposed API method ksLookupBySpec (and ksLookup implementing
cascading search). It introduces a `logical view` of
configuration that in difference to the `physical view` of
configuration does not have namespaces, but everything is below the root
"/". Additionally, contextual values now allow one to be compile-time
configured using C++-Policies. These are small puzzle pieces that will
fit into a greater picture at a later time.

A (data) race detection tool was implemented. Using it a configurable
number of processes and threads it tries to kdbSet() a different
configuration at (nearly) the same time.

With this tool the resolver could be greatly be improved (again). It now
uses stat with nanosecond precision that will be updated for every
successful kdbSet(). Even if the configuration file was modified
manually (not using Elektra) the next kdbSet() then is much more likely
to fail.  Additionally a recursive mutex now protects the file locking
mechanism.

The build server now additionally has following build jobs:

- [i386 build:](https://build.libelektra.org/job/elektra-gcc-i386/):
  We had an i386 regression, because none of the developers
  seems to use i386 anymore.
- [Configure Debian Script](https://build.libelektra.org/job/elektra-gcc-configure-debian/)
  Calls the scripts/configure-debian(-wheezy).
- [Local Installation:](https://build.libelektra.org/job/elektra-local-installation/)
  We had an regression that local installation was not possible because
  of a bash completion file installed to /etc. This build tests if it is
  possible to install Elektra in your home directory (and calls kdb
  run_all afterwards)
- [Test bindings:](https://build.libelektra.org/job/elektra-test-bindings/)
  Compiles and tests ALL bindings.
- [Mingw:](https://build.libelektra.org/job/elektra-gcc-configure-mingw-w64/)
  Compiles Elektra using mingw.

Many more examples were written and are used within doxygen. Most
snippets now can also be found in compilable files:

- [keyNew examples](https://github.com/ElektraInitiative/libelektra/tree/master/examples/keyNew.c)
- [keyCopy examples](https://github.com/ElektraInitiative/libelektra/tree/master/examples/keyCopy.c)
- [C++ deep dup](https://github.com/ElektraInitiative/libelektra/tree/master/src/bindings/cpp/examples/cpp_example_dup.cpp)
- [How to put Key in different data structures](https://github.com/ElektraInitiative/libelektra/tree/master/src/bindings/cpp/examples/cpp_example_ordering.cpp)
- [Mount some config files using augeas](https://github.com/ElektraInitiative/libelektra/tree/master/scripts/mount-augeas)
- [Mount system information](https://github.com/ElektraInitiative/libelektra/tree/master/scripts/mount-info)

Most plugins now internally use the same CMake function `add_plugin`
which makes plugin handling more consistent.

Felix converted the METADATA spec to ini files and added a proposal
how comments can be improved.

### Refactoring:

- reuse of utilities in gen code generator
- the gen support library is now in its own package (`support`)
- refactor array handling
- internal comparision functions (keyCompareByName)

### Optimization:

- lookupByName does not need to allocate two keys
- lookups in generated code
- prefer to use allocation on stack

### Fixes:

- disable cast that segfaults on i386 (only testing code was affected)
- fix keyAddBaseName in xmltool and testing code
- support non-system installation (e.g. in home directory)
- rewrote test cases to use succeed_if_same to avoid crashes on
  null pointers
- allow one to use python 2.6 for kdb gen
- improve exception messages
- use memcasecmp (fix lookup ignoring case)
- fix memory leaks (ini)
- text messages for some warnings/errors
- fix many issues regarding CMake, more variants of setting CMake
  options are now allowed.
- cmake policies fixes allow us to use cmake version > 3

## Get It!

You can download the release from
[here](http://www.markus-raab.org/ftp/elektra/releases/elektra-0.8.9.tar.gz)

- size: 1936524
- md5sum: 001c4ec67229046509a0cb9eda223dc6
- sha1: 79ea9b83c08ed4c347ed0100b5e0e2d3309b9d04
- sha256: e0895bba28a27fb37f36f59ef77c95235f3a9c54fb71aa6f648566774d276568

already built API-Docu can be found
[here](https://doc.libelektra.org/api/0.8.9/html/)

For more information, see https://www.libelektra.org

Best regards,
Markus





# 0.8.10 Release

- guid: 6ce57ecf-420a-4a31-821e-1c5fe5532eb4
- author: Markus Raab
- pubDate: Tue, 02 Dec 2014 18:37:51 +0100
- shortDesc: adds XDG/OpenICC compatibility & java binding

Hello,

we are delighted to announce our latest feature release providing
major updates in:

- compatibility with standards,
- tooling,
- plugins (hosts, rename),
- Qt-Gui and
- a new Java binding

## XDG Compatibility

Elektra now is
[fully XDG 0.8](http://standards.freedesktop.org/basedir-spec/basedir-spec-0.8.html)
compliant. Following changes were necessary:

- newly created configuration files for user/ now have the permissions
  0600
- newly created configuration directories for user/ now have the
  permissions 0700
- existing configuration files will retain their permissions.
- The default path to store user configuration is now ~/.config
- A new resolver variant x (for user and system) is introduced
 - implements handling of XDG environment variables
 - ignores empty dirs and absolute paths in envvar
- add new shell based test suite for (xdg)-resolver

For example, we could use resolver_fm_xhp_x:

    kdb mount --resolver=resolver_fm_xhp_x file.dump /example dump
    kdb file user/example
    kdb file system/example

Will show you that for both user+system the resolver respects
XDG environment variables, e.g. above lines will print:

    /home/m/.config/file.dump
    /etc/xdg/file.dump

Of course, any attempts to get and set keys below user/example and
system/example will also be in these files.

The letters after _ describe the variant of the resolver:

- f .. file based locking
- m .. mutex based locking (for multiple KDB per process)
- for user configuration (after next _)
 - x .. first check XDG_CONFIG_HOME environment
 - h .. then check HOME environment
 - p .. then fall back to passwd
- for system configuration (after next _)
 - x .. check all paths in XDG_CONFIG_DIRS and falls back to /etc/xdg

A lot of such resolver variants are added when -DPLUGINS=ALL is used.
Of course you can create new variants with different behaviour by adding
them to PLUGINS.

To make your application (that uses Elektra) XDG aware, you have nothing
to do: you get it to free. Make sure to always use cascading lookup.
Additionally, an XDG conforming application should not write system/
keys.

## OpenICC Compatibility

Based on that, Elektra now also implements the draft for
[the OpenICC specification](https://www.openicc.info/index.php%3Ftitle=OpenICC_Configuration_0.1.html).

The mount command looks like quite complicated, but it consists of
simple parts:

    kdb mount --resolver=resolver_fm_xhp_x \
      color/settings/openicc-devices.json /org/freedesktop/openicc \
      yajl rename cut=org/freedesktop/openicc

We already know the first two lines: we use the XDG resolver already
introduced above. Only the file name and the path where it should be
mounted differs.

The plugin yajl is a storage plugin that reads/writes json. The plugin
rename was the missing link to support OpenICC (thanks to Felix
Berlakovich for closing this gap). It is needed, because every OpenICC
file starts like this:

    { "org": { "freedesktop": { "openicc": {

Because the backend is mounted at /org/freedesktop/openicc, it would
lead to keys below /org/freedesktop/openicc/org/freedesktop/openicc
which we obviously do not want. So we simply get rid of the common
prefix by cutting it out using the rename plugin.

Of course this renaming functionality can be used in every situation and
is not limited to OpenICC.

## Tools

A large number of old and new tools were added, mostly for convenience
e.g.:

    kdb mount-openicc

saves you from writing the long mount command we had in the previous
section.

To get a list of all tools that are installed, now the command (which is
also an external tool and as such currently not displayed in kdb --help):

    kdb list-tools

is available. Do not be surprised: on typical installations this will
be a large list. You can run each of these tools by using kdb <command>.
Most of the tools, however, are part of the test suite,
which you can run using:

    kdb run_all

Other tools are "old friends", e.g. convert-fstab written in 2006 by Avi
Alkalay still works:

    kdb convert-fstab | kdb import system/filesystems xmltool

It will parse your /etc/fstab and generate a XML. This XML then can be
imported. Other convert tools directly produce kdb commands, though.

kdb now uses KDB itself for many commands:

- /sw/kdb/current/resolver .. You always want a different default
    resolver than that was compiled in as default when mounting
    backends?
- /sw/kdb/current/format .. If you are annoyed by the default format
    dump format for import/export.
- /sw/kdb/current/plugins .. If you always forget to add some plugins
    when mounting something.

By default the plugin "sync" is added automatically (it makes sure that
fsync is executed on config files, the directory is already done by the
resolver), you should not remove it from /sw/kdb/current/plugins
otherwise the next mount command will not add it. To preserve it use a
space separated list, e.g.:

    kdb set user/sw/kdb/current/plugins "sync syslog"

Last, but not least, kdb get now supports cascading get:

    kdb get /sw/kdb/current/plugins

This feature allows you to see the configuration exactly as seen by the
application.

Other options:

- -123 options for hiding nth column in `kdb mount`
- hide warnings during script usage of `kdb mount`
- -0 option accepted in some tools (null termination)
- Mount got a new -c option for backend configuration. For example
  -c cut=org/freedesktop/openicc would be the parameter cut for all
  plugins. Have a look at #146 if you want to use it.

## Compatibility

The core API (kdb.h), as always, stayed API/ABI compatible. The only
changes in kdb.h is the addition of KEY_CASCADING_NAME and
KEY_META_NAME. So applications compiled against 0.8.10 and using these
constants, will not work with Elektra 0.8.9.

The constants allow us to create following kinds of keys:

- empty names: this was always possible, because invalid names
  (including empty names) did not cause keyNew to abort
- metanames: this is a new feature that allows us to compare key names
  with metakeys
- cascading names: names starting with / have the special meaning that
  they do not specify which namespace they have. When such names are
  used for
  - kdbGet() and kdbSet() keys are retrieved from all namespaces
  - ksLookup() keys are searched in all namespaces
  - ksLookupByName() is now just a wrapper for ksLookup().
      The method does not do much except creating a key and passing
      them to ksLookup().

Usage in C is:

    Key *c = keyNew("/org/freedesktop", KEY_CASCADING_NAME, KEY_END);
    Key *m = keyNew("comment/#0", KEY_META_NAME, KEY_END);

The same functionality exists, of course, in available in all bindings,
too.

Changes in non-core API are:

- xmltool now does not output default (unchanged) uid,gid and mode
- ksLookupBySpec from kdbproposal.h was removed, is now integrated into
    ksLookup
- extension keyNameGetNamespace was removed
- the hosts comment format has changed
- the default resolver has changed (uses passwd)
- kdb::tools::Backend::Backend constructor, tryPlugin and addPlugin
  have changed:
 - mountname is now automatically calculated
 - addPlugin allows us to add a KeySet to validate plugins with different
     contracts correctly
- C++ binding now throws std::bad_alloc on allocation problems (and not
  InvalidName)

## CMake

It is now possible to remove a plugin/binding/tools by prefixing a name
with "-".  The new "-element" syntax is accepted by TOOLS, BINDINGS and
PLUGINS. It is very handy in combination with ALL, e.g.:

    -DPLUGINS="ALL;-xmltool"

will include all plugins except xmltool.

## Improved comments

Comment preserving was improved a lot. Especially, the hosts plugin was
rewritten completely. Now multiple different comment styles can be
intermixed without losing information. E.g. some INI formats support
both ; and # for comments. With the new comments it is possible to
preserve that information and even better: applications can iterate
over that information (metadata).

To mount the new hosts plugin use (if you already have mounted it, you
have nothing to do):

    kdb mount /etc/hosts system/hosts hosts

The hosts plugin now seperates from ipv4 and ipv6 which makes the host
names canonical again, e.g.:

    kdb get system/hosts/ipv4/localhost
    kdb get system/hosts/ipv6/localhost

To access the inline-comment, use:

    kdb getmeta system/hosts/ipv4/localhost "comment/#0"

For other meta information, see:

    kdb lsmeta system/hosts/ipv4/localhost

Additionally, a small API for specific metadata operations emerges.
These operations will be moved to a separate library and will not stay
in Elektra’s core library.

## Proposal

- lookup options:
 - KDB_O_SPEC uses the lookup key as specification
 - KDB_O_CREATE creates a key if it could not be found
- elektraKeyGetMetaKeySet creates a KeySet from metadata
- elektraKsFilter allows us to filter a KeySet arbitrarily (not only
    keyIsBelow in case of ksCut). It reintroduces more functional
    programming.
- keyGetNamespace was reintroduced. In one of the next versions of
  Elektra we will introduce new namespaces. keyGetNamespace allows the
  compiler to output a warning when some namespaces are not handled in
  your C/C++ code.

## Java binding

Elektra now fully supports applications written in Java and also Plugins
written in the same language.

The
[new binding was developed using jna.](https://github.com/ElektraInitiative/libelektra/tree/master/src/bindings/jna)
For the
[plugin interface JNI](https://github.com/ElektraInitiative/libelektra/tree/master/src/plugins/jni)
was used.
We developed already
[some plugins](https://master.libelektra.org/src/bindings/jna/libelektra4j/src/main/java/org/libelektra/plugin).

## Qt-Gui

Raffael Pancheri released the version 0.0.2 of the Qt-Gui:

* added Backend Wizard for mounting
* user can hover over TreeView items and quickly see key name, key value
  and metakeys
* it is now easily possible to create and edit arrays
* added header to MetaArea for better clarity
* many small layout and view update fixes

## Further stuff and small fixes

- Two new error/warnings information: mountpoint and configfile.
    It is added automatically and all tools will print it.
- C++ I/O for key(s) now allows null terminator next to new-line
    terminator
- fix error plugin: now use on_open/trigger_warnings to be consistent
- fix metaset: now correctly append new key
- arrays are also available when compiled with mingw
   (but tests still have to be excluded for successful compilation)
- fix #136
- fix long help text in `kdb check`
- signed release tags are now used

## Get It!

You can download the release from
[here](http://www.markus-raab.org/ftp/elektra/releases/elektra-0.8.10.tar.gz)

- size: 1915277
- md5sum: 2b16a4b555bc187562a0b38919d822a1
- sha1: 08b1d0139fc5eb0d03c52408478e68b91b1825dc
- sha256: 526e2ed61e87d89966eb36ddad78d8139b976e01ce18aab340d8a1df47132355

already built API-Docu can be found
[here](https://doc.libelektra.org/api/0.8.10/html/)

## Stay tuned!

Subscribe to the
[new RSS feed](https://doc.libelektra.org/news/feed.rss)
to always get the release notifications.

[Permalink to this NEWS entry](https://doc.libelektra.org/news/6ce57ecf-420a-4a31-821e-1c5fe5532eb4.html)

For more information, see https://www.libelektra.org

Best regards,
Markus





# 0.8.11 Release

- guid: 7d4647d4-4131-411e-9c2a-2aca39446e18
- author: Markus Raab
- pubDate: Fri, 03 Apr 2015 02:39:37 +0200
- shortDesc: adds specification namespace & numerous improvements

From the beginning of the Elektra Initiative, Elektra aimed at avoiding
hard coded information in the application and to make the application's
configuration more transparent. While avoiding any paths to files was
reality from the first released Elektra version, now also hard coding
default values, fallback mechanisms and even Elektra’s paths to keys
can be avoided.

## How does that work?

Elektra 0.8.11 introduces a so called specification for the
application's configuration. It is located below its own namespace
`spec` (next to user and system).

Once the base path is known, the user can find out all Elektra
paths used by an application, using:

    kdb ls spec/basepath

Keys in `spec` allow us to specify which keys are read by the application,
which fallback it might have and which is the default value using
metadata. The implementation of these features happened in `ksLookup`.
When cascading keys (those starting with `/`) are used following features
are now available (in the metadata of respective `spec`-keys):

- `override/#`: use these keys *in favour* of the key itself (note that
    `#` is the syntax for arrays, e.g. `#0` for the first element,
    `#_10` for the 11th and so on)
- `namespace/#`: instead of using all namespaces in the predefined order,
    one can specify which namespaces should be searched in which order
- `fallback/#`: when no key was found in any of the (specified) namespaces
    the `fallback`-keys will be searched
- `default`: this value will be used if nothing else was found

This technique does not only give you the obvious advantages, but
also provides complete transparency how a program will fetch a configuration
value. In practice that means that:

    kdb get "/sw/app/#0/promise"

will give you the *exact same value* as the application uses when it
lookups the key `promise`. Many `if`s and hard coded values are avoided,
we simply fetch and lookup the configuration by following code:

    Key *parentKey = keyNew("/sw/app/#0", KEY_CASCADING_NAME, KEY_END);
    kdbGet(kdb, ks, parentKey);

    ksLookupByName(ks, "/sw/app/#0/promise", 0);

We see in that example that only Elektra paths are hard coded in
the application.  But those can be found out easily, completely without
looking in the source code. The technique is simple: append a
logger plugin and the KDB base path is printed to:

- stdout in the case of the plugin tracer
- syslog in the case of the plugin syslog
- journald in the case of the plugin journald

What we do not see in the program above are the default values and
fallbacks. They are only present in the so specification (namespace `spec`).
Luckily, the specification are key-value pairs, too. So we do not have
to learn something new, e.g. using the ni plugin we can specify:

    [promise]
    default=20
    fallback/#0=/somewhere/else
    namespace/#0=user

1.) When this file is mounted to `spec/sw/app/#0` we specify, that
    for the key `/sw/app/#0/promise` only the namespace `user` should be
    used.
2.) If this key was not found, but `/somewhere/else` is present, we will use
    this key instead.  The `fallback` technique is very powerful: it allows
    us to have (recursive) links between applications. In the example above,
    the application is tricked in receiving e.g. the key `user/somewhere/else`
    when `promise` was not available.
3.) The value `20` will be used as default, even if no configuration file
    is found.

Note that the fallback, override and cascading works on *key level*,
and not like most other systems have implemented, on
configuration *file level*.

## Namespaces

The specification gives the namespaces clearer semantics and
purpose. Key names starting with a namespace are connected to a
configuration source. E.g. keys starting with:

- `user` are keys from the home directory of the current user
- `system` are keys from the `/etc` directory of the current system
- `spec` are keys from the specification directory (configurable
    with KDB_DB_SPEC, typically `/usr/share/elektra/specification`)

When a key name starts with an `/` it means that it is looked up by
specification. Such a cascading key is not really present in the keyset
(except when a default value was found). They are neither received
nor stored by `kdbGet` and `kdbSet`.

Applications shall only lookup using cascading keys (starting with `/`).
If no specification is present, cascading of all namespaces is used as before.

Elektra will (always) continue to work for applications that do not have a
specification. We strongly encourage you, however, to write such a
specification, because:

- it helps the administrator to know which keys exist
- it documents the keys (including lookup behaviour and default value)
- and many more advantages to come in future releases..

For a tutorial how to actually elektrify an application and for more
background to Elektra,
[read this document](https://github.com/ElektraInitiative/libelektra/blob/master/doc/tutorials/application-integration.md).

For a full list of proposed and implemented metadata,
[read this document](https://github.com/ElektraInitiative/libelektra/blob/master/doc/help/elektra-namespaces.md).

## Simplification in the merging framework

As it turned out the concept of very granular merge strategies was hard to understand
for users of the three-way merging framework that emerged in the last year's
GSoC. While this granularity is desirable for flexibility, we
additionally wanted something easy to use. For that reason merge
configurations were introduced. These are simply preconfigured configurations for a merger
that arrange required strategies for the most common merging scenarios. Especially
they make sure that meta merging is handled correctly.

Have a look at the changes in the example
[/src/libs/tools/examples/merging.cpp](https://github.com/ElektraInitiative/libelektra/blob/master/src/libs/tools/examples/merging.cpp)
for an glimpse of the simplifications.

A big thanks to Felix Berlakovich!

The header files will be installed to /usr/include/elektra/merging, but they are
subject to be changed in the future (e.g. as they did in this release).

From the merging improvements some minor incompatibility happened in
`kdb import`. Not all merging strategies that worked in 0.8.10 work
anymore. Luckily, now its much simpler to choose the strategies.

## API

The main API kdb.h has two added lines. First a new method was added:

    ssize_t keyAddName(Key *key, const char *addName);

This method is already used heavily in many parts. Contrary to `keySetBaseName` and
`keyAddBaseName` it allows us to extend the path with more than one Element at once,
i.e. `/` are not escaped.

The other new line is the new enum value `KEY_FLAGS`.
This feature allows bindings to use any flags in keyNew without actually
building up variable argument lists.  (Thanks to Manuel Mausz)

As always, API+ABI is stable and compatible.

## Proposed

Many new functions are proposed and can be found in
[the doxygen docu](https://doc.libelektra.org/api/0.8.11/html) and in
[kdbproposal.h](https://github.com/ElektraInitiative/libelektra/blob/master/src/include/kdbproposal.h).

Noteworthy is the method `keyGetNamespace` which allows us to query all
namespaces. Since this release we changed every occurrence of namespaces
(except documentation) with switch-statements around `keyGetNamespace`.
This allows us to add new more namespaces more easily. (Although its
currently not planned to add further namespaces.)

Finally, a bunch of new lookup options were added, which might not be
useful for the public API (they allow us to disable the
specification-aware features mentioned in the beginning).

## Obsolete and removed concepts

### umount

The concept that backends have a name (other than their mountpoint)
is now gone. Backends will simply be named with their escaped mountpath
below system/elektra/mountpoints without any confusing additional name.

Unmounting still works with the mountpath.

Removing this concept makes Elektra easier to understand and it also
removes some bugs. E.g. having mountpoints which do not differ except
having a `_` instead of a `/` would have caused problems with the
automatic name generation of Elektra 0.8.10.

Old mountpoints need to be removed with their 0.8.10 name
(`_` instead of `/`).

### directory keys

Additionally, the so called directory keys were also removed.
Elektra was and still is completely key-value based. The `/` separator
is only used for mountpoints.

### fstab

The plugin fstab is also improved: Slashes in mountpoints are
escaped properly with the internal escaping engine of keyAddBaseName()
(i.e. without any problematic `/` replacements).

### dirname

getDirName() was removed from C++, gi-lua, gi-python2, gi-python3,
swig-lua, swig-python2 and swig-python3. It was never present in C and
did not fit well with keyBaseName() (which returns an unescaped name,
which is not possible for the dirname). (Thanks to Manuel Mausz)

### invalid parent names

While empty (=invalid) names are still accepted as parentName to `kdbGet`
and `kdbSet` for compatibility reasons, but the parentKey

    Key *parentKey = keyNew("/", KEY_END);

should be used instead (if you want to get or store everything).
They have identical behaviour, except that
invalid names (that cannot be distinguished from empty names) will
produce a warning. In the next major version invalid parentNames
will produce an error.

## KDB Behaviour

It is now enforced that before a kdbSet() on a specific path a kdbGet()
on that path needs to be done. This was always documented that way and
is the only way to correctly detect conflicts, updates and missing
configuration files. Error #107 will be reported on violations.

Additionally, the handling with missing files was improved. Empty
keysets for a mountpoint now will remove a file. Such an empty file
is always up-to-date. Removing files has the same atomicity guarantees
as other operations.

The concurrency behaviour is at a very high level: as expected many processes
with many threads can each concurrently write to the key database,
without any inconsistent states: This is noted here because Elektra
works on standard configuration files without any guarding processes.

Filesystem problems, e.g. permission, now always lead to the same errors
(#9, #75, #109, #110), regardless of the storage plugin.

## Qt-Gui 0.0.6

Raffael Pancheri was very busy and did a lot of stabilizing work:

- Added markdown converter functionality for plugin documentation
- Integrated help (Whats this?)
- Added credits to other authors
- do not show storage/resolver plugins if a plugin of that kind has been selected
- added menu to newkey toolbar button to allow new array entries
- added option to include a configuration keyset when adding a plugin
- show included keys when creating the plugin configuration
- Added all storageplugins to namefilters
- Reimplement ErrorDialog
- Added undo/redo of all commands and correctly update the view
- modified ToolTip size
- Color animation on search results
- Refactored Buttons to accept shortcuts
- Updated Translations
- Colors are now customizeable
- Many small fixes

The gui is already used and the remaining small bugs (see github)
are going to be fixed soon. One of the highlights is undo for
nearly every action, so nothing prevents you from trying it out!

A huge thanks to Raffael Pancheri for his contributions. His thesis can
be found at [here](https://www.libelektra.org/ftp/elektra/pancheri2015gui.pdf).

## Bug fixing

- fix issues with escaped backslashes in front of slashes
- atomic commits across namespaces work again
- memleak on ReadFile error in ni plugin
- `kdb getmeta` reports errorcode if key, but no meta was found
- `ksLookup` now will also work if a key of the keyset is used as
    search-key (aliasing problem fixed by dup() on namelock)
- resolver regex does not match to wrongly written plugins
- jna plugin is now named libelektra-0.8.11.jar, with proper symbolic link to current version, for every CMake version
- fix bashism ($RANDOM)
- new keys are correctly renamed, fixes OpenICC (thanks to Felix Berlakovich)
- comments in host keys are correctly restored (thanks to Felix Berlakovich)
- output stream in type checking is no longer locale dependent (thanks to Manuel Mausz)
- cmake uninstall works again
- simplify CMAKE_DL_LIBS (thanks to Manuel Mausz)

## Further gems

- Examples were improved, added (e.g. cascading, namespace) and included in
  [Doxygen docu](https://doc.libelektra.org/api/0.8.11/html).
- [METADATA specification](https://github.com/ElektraInitiative/libelektra/blob/master/doc/METADATA.ini)
    was nearly completely rewritten (thanks to Felix Berlakovich)
- benchmarks were greatly enhanced (run-time+heap profiling),
    and some important performance improvements were done
- All plugins now use the cmake function `add_plugin`
    (thanks to Ian Donnelly for most of the work)
- data directory (keysets as C-files) is now shared between different
    kinds of test suites.
- many more tests were added, e.g. distribution tests, KDB API tests;
  and allocation tests were readded
- now all kdb commands accept cascading keys.
- More compiler warning-flags are added and many warnings are fixed
- cleanup of old unused `keyName` methods
- The key `system/elektra/mountpoints` itself was always created and a
    left-over on a freshly installed system after the unit tests run the
    first time. The physical presence of the key is now irrelevant and
    it won't be created automatically.
- Bash completion was greatly improved (thanks to Manuel Mausz)
- Configure scripts were refactored and are now much shorter (thanks to Manuel Mausz)
- New Debian build agents were added that are magnitutes faster than the old ones (a big thanks to Manuel Mausz)
- Many KDB tests, written in C, lua and python were added (thanks to Manuel Mausz)
- SWIG3 is preferred when available
- add the plugin counter that counts how often the methods of a plugin are called
- `kdb list-tools` is now advertised in `kdb --help`
- macOS support was greatly improved, thanks to Peter Nirschl
  and Kai-Uwe Behrmann. The feature rich resolver, now also works
  for macOS.  wresolver is now only needed for mingw.
- Elektra still compiles with gcc (also mingw variants), icc and clang.

## Further Notes

With 471 files changed, 27978 insertions(+), 11512 deletions(-) this
release is huge. With 773 commits over four month much more changes
happened which did not find their place in these release notes, even
though the notes are much less detailed than usual.

Thanks for all contributions that are not enlisted here!

For any questions and comments, please contact the
[Mailing List](https://lists.sourceforge.net/lists/listinfo/registry-list)
or elektra@markus-raab.org.

## Get It!

You can download the release from
[here](http://www.markus-raab.org/ftp/elektra/releases/elektra-0.8.11.tar.gz)

- name: elektra-0.8.11.tar.gz
- size: 2022129
- md5sum: c53a8151aab760851842d745e904a4f8
- sha1: d7929d17d1a6529089d156f1910d87f678b84998
- sha256: c20fefcfba62cc906228f9b55d1f411ef8f884ff9d75774a0dd4f8eb8f5b48f6

This release tarball now is also available
[signed by me using gpg](http://www.markus-raab.org/ftp/elektra/releases/elektra-0.8.11.tar.gz.gpg)

already built API-Docu can be found [here](https://doc.libelektra.org/api/0.8.11/html/)

## Stay tuned!

Subscribe to the
[new RSS feed](https://doc.libelektra.org/news/feed.rss)
to always get the release notifications.

[Permalink to this NEWS entry](https://doc.libelektra.org/news/7d4647d4-4131-411e-9c2a-2aca39446e18.html)

For more information, see https://www.libelektra.org

Best regards,
Markus





# 0.8.12 Release

- guid: 98770541-32a1-486a-98a1-d02f26afc81a
- author: Markus Raab
- pubDate: Sun, 12 Jul 2015 20:14:09 +0200
- shortDesc: adds directory namespace & other improvements and fixes

Again we managed to release with new features, many build system
fixes and also other improvements.

## dir namespace

This namespace adds per-project or per-directory (hence the name) configurations.
E.g. think how git works: not only /etc and ~ are relevant sources
for configuration but also the nearest .git directory.

This technique is, however, much more widely useful than just for git
repositories! Nearly every application can benefit from such a per-dir
configuration. Its almost certain that you have already run into the
problem that different projects have different guidelines
(e.g. coding conventions, languages, whitespace requirements, line breaks, ..).
Obviously, thats not a per-user configuration and
its also not a per-file issue (thats how its usually solved today).
So in fact you want, e.g., your editor to have an additional per-project layer
to choose between such settings.

The technique is useful for nearly every other tool:
- different color palettes in gimp, inkscape,..
- different languages for LibreOffice
- different security settings for media players, interpreters (e.g. when in Download folder)
- per-folder .htaccess in apache or other web servers
- any other per-dir configuration you can imagine..

It is simple to use, also for the administrative side. First, change to the folder to your
folder (e.g. where a project is):

    cd ~/projects/abc

Then add some user (or system or spec) configuration to have some default.

    kdb set user/sw/editor/textwidth 72

Then verify that we get this value back when we do a cascading lookup:

    kdb get /sw/editor/textwidth

The default configuration file for the dir-namespace is `pwd`/KDB_DB_DIR/filename:

    kdb file dir/sw/editor/textwidth

- KDB_DB_DIR can be modified at compile-time and is `.dir` per default
- filename can be modified by mounting, see below, and is `default.ecf` by default

We assume, that the project abc has the policy to use textwidth 120, so
we change the dir-configuration:

    kdb set dir/sw/editor/textwidth 120

Now we will get the value 120 in the folder ~/projects/abc and its
subdirectories (!), but everywhere else we still get 72:

    kdb get /sw/editor/textwidth

Obviously, that does not only work with kdb, but with every elektrified tool.

### mount files in dir namespaces

For cascading mountpoints, the dir name is also automatically mounted, e.g.:

    kdb mount editor.ini /sw/editor ini

But its also possible to only mount for the namespace dir if no cascading mountpoint is
present already:

    kdb mount app.ini dir/sw/app tcl

In both cases keys below dir/sw/editor would be in the INI file
`.dir/editor.ini` and not in the file `.dir/default.ecf`.

### dir together with spec namespace

In the project P we had the following issue: We needed on a specific computer the
configuration in /etc to be used in favour of the dir config.

We could easily solve the problem using the specification:

    kdb setmeta spec/sw/P/current/org/base override/#0 /sw/P/override/org/base


Hence, we could create system/sw/P/override/org/base which would be in favour of dir/sw/P/current/org/base.
So we get system/sw/P/override/org/base when we do:

    kdb get /sw/P/current/org/base

Alternatively, one could also use the specification:

    kdb setmeta spec/sw/P/current/org/base namespace/#0 user
    kdb setmeta spec/sw/P/current/org/base namespace/#1 system
    kdb setmeta spec/sw/P/current/org/base namespace/#2 dir

Which makes dir the namespace with the least priority and system would be preferred.
This was less suitable for our purpose, because we needed the override
only on one computer. For all other computers we wanted dir
to be preferred with only one specification.

### Conclusion

The great thing is, that every elektrified application, automatically gets all the mentioned features.
Not even a recompilation of the application is necessary.

Especially the specification provides flexibility not present in other configuration systems.

## Qt-Gui 0.0.7

Raffael Pancheri again did a lot of stabilizing work:
- show errormessage on exception when starting gui
- Correctly update keyAreaView property when selecting item in TreeView
- Fix crash when creating key in MountingWizard
- Remove information on successful export
- Show error dialog on failed import
- Remove namefilters (every syntax can have any file extension)
- other namespaces (including dir) are included

The GUI can be handy for many purposes, e.g. we use it already as xml and json editor.
Note that there are still [some bugs](https://git.libelektra.org/issues).

## Other fixes

- constants now additionally gives information about SPEC and DIR.
- Doku about CMake variables `ELEKTRA_DEBUG_BUILD` and `ELEKTRA_VERBOSE_BUILD` fixed, thanks to Kurt Micheli
- Fixed compilation of `ELEKTRA_DEBUG_BUILD` and `ELEKTRA_VERBOSE_BUILD`, thanks to Manuel Mausz
- Example with error handling added, thanks to Kurt Micheli
- Add design decision about global plugins
- Split dependencies document to individual README.md, thanks to Ian Donnelly
- Fix nearly all compilation warnings of SWIG, thanks to Manuel Mausz
- CMake: Fix gtest to be build if `BUILD_TESTING` activated, but not `ENABLE_TESTING`
- CMake: Allow compilation without BUILD_STATIC
- Explain compilation options more, thanks to Kai-Uwe Behrmann for asking the question
- CMake: always build examples, allow one to only build documentation
- add common header file for C++ plugins (used by plugins struct and type)
- fix compilation of race tool under oS-11.4 thanks to Kai-Uwe Behrmann
- CMake: find python3 correctly
- CMake: fix BUILD_SHARED_LIBS
- Doxygen: remove `HTML_TIMESTAMP` to make build reproduceable
- Doxygen: rewrite of main page+add info about all five namespaces
- CMake: allow one to use qt-gui with qt built with -reduce-relocations
- fix kdb ls, get to list warnings during open
- during kdbOpen() use Configfile: to state phase
- add -f option to kdb check+improve docu
- improve readability of warning output
- run_all always uses dump for backups
- line plugin round-trips correctly
- untypical resolvers have their non-existant filename handled correctly + sync ignored them correctly
- cmake-3.0 fixes
- cascading merging, a big thanks to Felix Berlakovich for the last minute fix

## Compatibility

As always, the API and API is fully compatible. Because nothing was added, its even
possible to link against an older version of Elektra (if compiled against 0.8.12).

In plugins some small changes may effect compatibility:
- in rename the handling of parent key is different (see #206)
- resolving of spec absolute and relative paths are no more handled identical.
  Instead absolute paths will be searched absolutely, while relatives are below KDB_DB_SPEC (as before).
  This behaviour is consistent to the behaviour of the other namespaces.

These two points are also the only unit tests that fail when Elektra 0.8.12 is used with 0.8.11 unit tests.

## Build Server

- special github command to build bindings "jenkins build bindings please", thanks to Manuel Mausz
- open build service update
  For [OpenSUSE, CentOS, Fedora, RHEL and SLE](https://build.opensuse.org/package/show/home:bekun:devel/elektra)
  Kai-Uwe Behrmann kindly provides packages [for download](http://software.opensuse.org/download.html?project=home%3Abekun%3Adevel&package=libelektra4).

## Get It!

You can download the release from
[here](https://www.libelektra.org/ftp/elektra/releases/elektra-0.8.12.tar.gz)
and now also [here on github](https://github.com/ElektraInitiative/ftp/tree/master/releases/elektra-0.8.12.tar.gz)

- name: elektra-0.8.12.tar.gz
- size: 2102450
- md5sum: a40a33ae6661ebfa096378f0986ede6c
- sha1: 3594ef58b6e3b0ffa9589d787679b6e739fbb0dd
- sha256: 562432bea9455a61ff6e6b3263078ea9b26bef2ed177a04b5f9b181d605bc021

This release tarball now is also available
[signed by me using gpg](https://www.libelektra.org/ftp/elektra/releases/elektra-0.8.12.tar.gz.gpg)

already built API-Docu can be found [here](https://doc.libelektra.org/api/0.8.12/html/)

## Stay tuned!

Subscribe to the
[RSS feed](https://doc.libelektra.org/news/feed.rss)
to always get the release notifications.

For any questions and comments, please contact the
[Mailing List](https://lists.sourceforge.net/lists/listinfo/registry-list)
the issue tracker [on github](https://git.libelektra.org/issues)
or by mail elektra@markus-raab.org.

[Permalink to this NEWS entry](https://doc.libelektra.org/news/98770541-32a1-486a-98a1-d02f26afc81a.html)

For more information, see https://libelektra.org

Best regards,
Markus





# 0.8.13 Release

- guid: 3c00a5f1-c017-4555-92b5-a2cf6e0803e3
- author: Markus Raab
- pubDate: Thu, 17 Sep 2015 17:32:16 +0200
- shortDesc: adds elektrify-getenv & other improvements

Again we managed to release with many new features, many fixes
and also other improvements.

## Elektrify-getenv

getenv(3) is one of the most popular ways to retrieve configuration,
even though it has many known problems:

- no standard way to modify it
- relogin (or restart of shell) necessary
- names are flat (no hierarchical structure)
- cannot be set for individual applications
- different in at, cron and similar scripts

With elektrify-getenv we wrote a solution which solves most of the
problems. We use the LD_PRELOAD technique to *additionally* retrieve
values from Elektra, and not only the environment.

You simply can do:

```bash
kdb set user/env/override/HTTP_PROXY "http://my.proxy:8080"
```

This will set the `HTTP_PROXY` environment variable to `http://my.proxy:8080`.
Configuration can be retrieved with `kdb get`:

```bash
kdb get user/env/override/HTTP_PROXY
lynx   # or start another www-browser with the newly set HTTP_PROXY
```

Or using the man pages:

    kdb elektrify-getenv man man --elektra:MANWIDTH=40

Will use MANWIDTH 40 for this invocation of man man.
This feature is handy, if an option is only available
by environment, but not by command-line arguments,
because sometimes environment variables are not trivial
to set (e.g. in Makefiles).

Some more examples:

    kdb set user/env/override/MANOPT -- "--regex -LC"
    kdb elektrify-getenv getenv MANOPT   # to check if it is set as expected
    kdb getenv MANOPT   # if /etc/ld.so.preload is active

So is this the final solution for configuration and manual elektrification
of applications is not needed anymore?

The answer is: no and yes.

It is quite satisfactory for configuration that is inherently sharable
(not different from one application to another) *and* needs the environment
semantics, i.e. some subprocesses should have different configuration
than others, e.g. in a specific terminal.

But it might not be a good solution for your own application, because
libgetenv(3) implies many architectural decision, that other elektrified
applications would decide differently, e.g.:

- it uses global variables (getenv(3) has no handle)
- it uses mutex for multi-threading safety
- the API getenv(3) only returns `char*` and has no support for other data types

For more information see [src/libgetenv/README.md](https://git.libelektra.org/blob/master/src/libs/getenv/README.md)

## Compatibility

As always, the API and API is fully forward-compatible, i.e. programs compiled against an
older 0.8 versions of Elektra will continue to work.

Because `keyUnescapedName` and `keyGetUnescapedNameSize` is added in this release, it is not backward-compatible,
i.e. programs compiled against 0.8.13, might *not* work with older 0.8 libraries.

The function `keyUnescapedName` provides access to an unescaped name, i.e. one where `/` and `\\` are
literal symbols and do not have any special meaning. `NULL` characters are used as path separators.
This function makes it trivial and efficient to iterate over all path names, as already exploited
in all bindings:

 - [jna (java)](https://git.libelektra.org/blob/master/src/bindings/jna/HelloElektra.java)
 - [lua](https://git.libelektra.org/blob/master/src/bindings/swig/lua/tests/test_key.lua)
 - [python2](https://git.libelektra.org/blob/master/src/bindings/swig/python2/tests/testpy2_key.py)
 - [python3](https://git.libelektra.org/blob/master/src/bindings/swig/python/tests/test_key.py)

Other small changes/additions in bindings:

- fix key constructor, thanks to Manuel Mausz
- add copy and deepcopy in python (+examples,+testcases), thanks to Manuel Mausz
- dup() in python3 returned wrong type (SWIG wrapper), thanks to Toscano Pino for reporting, thanks to Manuel Mausz for fixing it

Doxygen 1.8.8 is preferred and the configfile was updated to this version.

The symbols of nickel (for the ni plugin) do not longer leak from the Elektra library.
As such, old versions of testmod_ni won't work with Elektra 0.8.13.
A version-script is now in use to only export following symbols:

- kdb*
- key*
- ks*
- libelektra* for module loading system
- elektra* for proposed and other functions (no ABI/API compatibility here!)

In this release, ENABLE_CXX11 was changed to `ON` by default.

Note that in the next release 0.8.14 there will be two changes:

- According to [issue #262](https://git.libelektra.org/issues/262), we plan to remove the option ENABLE_CXX11
  and require the compiler to be C++11 compatible.
  If you have any system you are not able to build Elektra with -DENABLE_CXX11=ON (which is
  the default for 0.8.13) please report that immediately.
- the python3 bindings will be renamed to python

By not having to care for pre-C++11 compilers, we hope to attract more developers.
The core part is still in C99 so that Elektra can be used on systems where libc++ is not available.
Many new plugins are still written in C99, also with the purpose of not depending on C++.

## Python Plugins

A technical preview of [python3](https://git.libelektra.org/blob/master/src/plugins/python)
and [python2](https://git.libelektra.org/blob/master/src/plugins/python2) plugins has been added.

With them its possible to write any plugin with python scripts.

Note, they are a technical preview. They might have severe bugs
and the API might change in the future.
Nevertheless, it is already possible to, e.g. develop storage plugins
with it.

They are not included in `ALL` plugins.  To use it, you have to specify it:

    -PLUGINS="ALL;python;python2"

Thanks to Manuel Mausz for to this work on the plugins and the patience in all
the last minute fixes!

## Qt-gui 0.0.8

The GUI was improved and the most annoying bugs are fixed:

- only reload and write config files if something has changed
- use merging in a way that only a conflict free merge will be written, thanks to Felix Berlakovich
- made sure keys can only be renamed if the new name/value/metadata is different from the existing ones
- fixed 1) and 2) of #233
- fixed #235
- fixed qml warning when deleting key
- fixed qml typerror when accepting an edit

A big thanks to Raffael Pancheri!

## KDB Tool

The commandline tool `kdb` also got some improvements.
Most noteworthy is that `kdb get -v` now gives a complete trace for
every key that was tried. This is very handy if you have a complex
specification with many fallback and override links.

It also shows default values and warnings in the case of context-oriented
features.

Furthermore:

- Add `-v` for setmeta
- Copy will warn when it won't overwrite another key (behaviour did not change)
- improve help text, thanks to Ian Donnelly

## Documentation Initiative

As Michael Haberler from [machinekit](http://www.machinekit.io/) pointed out it was certainly not easy for someone
to get started with Elektra. With the documentation initiative we are going to change that.

- The discussion in [github issues](https://git.libelektra.org/issues) should clarify many things
- We start writing man pages in ronn-format(7), thanks to Ian Donnelly for current work
- Kurt Micheli is woring on improved doxygen docu + pdf generation
- Daniel Bugl already restructed the main page
- Daniel Bugl also improved formatting
- doc: use @retval more, thanks to Pino Toscano
- doxygen: fix template to use `@` and not `\\`.
- SVG logo is preferred, thanks to Daniel Bugl
- doc: use @retval more, thanks to Pino Toscano
- many typo fixes, thanks to Pino Toscano
- fix broken links, thanks to Manuel Mausz, Daniel Bugl and Michael Haberler

Any further help is very welcome! This call is especially addressed to beginners in Elektra because
they obviously know best which documentation is lacking and what they would need.

## Portability

`kdb-full` and `kdb-static` work fine now for Windows 64bit, thanks to Manuel Mausz.
The wresolver is now more relaxed with unset environment.

All issues for macOS were resolved. With the exception of elektrify-getenv
everything should work now, thanks to Mihael Pranjic:

- fix mktemp
- testscripts
- recursive mutex simplification
- clearenv ifdef

and thanks to Daniel Bugl:

- RPATH fixed, so that `kdb` works

furthermore:

- fix `__FUNCTION__` to `__func__` (C99), thanks to Pino Toscano
- avoid compilation error when JNI_VERSION_1_8 is missing
- fix (twice, because of an accidental revert) the TARGET_CMAKE_FOLDER, thanks to Pino Toscano

Thanks to Manuel Mausz for to testing and improving portability!

## Packaging and Build System

- [0.8.12 packaged+migrated to testing](https://packages.qa.debian.org/e/elektra/news/20150726T155000Z.html), thanks to Pino Toscano
- fix build with external gtest, thanks to Pino Toscano
- switch from FindElektra.cmake to ElektraConfig.cmake, thanks to Pino Toscano
- use `cmake_parse_arguments` instead of `parse_arguments`, thanks to Manuel Mausz

## Further Fixes

- Key::release() will also work when Key holds a null-pointer
- Key::getName() avoids std::string exception
- support for copy module was introduced, thanks to Manuel Mausz
- be more POSIX compatible in shell scripts (`type` to `command -v` and avoid `echo -e`) thanks to Pino Toscano
- fix vararg type for KEY_FLAGS, thanks to Pino Toscano
- fix crash of example, thanks to Pino Toscano
- add proper licence file for Modules (COPYING-CMAKE-SCRIPTS), thanks to Pino Toscano
- fix XDG resolver issue when no given path in XDG_CONFIG_DIRS is valid
- make dbus example work again
- fix compiler warnings for gcc and clang
- fix Valgrind suppressions
- Installation of GI binding is fixed, thanks to Dāvis
- make uninstall is fixed and docu improved

## Notes

There are some misconceptions about Elektra and semi structured data (like XML, JSON).
Elektra is a key-value storage, that internally represents everything with key and values.
Even though, Elektra can use XML and JSON files elegantly, there are limitations what
XML and JSON can represent. XML, e.g., cannot have holes within its structure, while this
is obviously easily possible with key-value. And JSON, e.g., cannot have non-array entries
within an array. This is a more general issue of that configuration files in general
are constrained in what they are able to express. The solution to this problem is
validation, i.e. keys that does not fit in the underlying format are rejected.
Note there is no issue the other way round: special characteristics of configuration
files can always be captured in Elektra’s metadata.

## Get It!

You can download the release from
[here](https://www.libelektra.org/ftp/elektra/releases/elektra-0.8.13.tar.gz)
and now also [here on github](https://github.com/ElektraInitiative/ftp/tree/master/releases/elektra-0.8.13.tar.gz)

- name: elektra-0.8.13.tar.gz
- size: 2141758
- md5sum: 6e7640338f440e67aba91bd64b64f613
- sha1: ca58524d78e5d39a540a4db83ad527354524db5e
- sha256: f5c672ef9f7826023a577ca8643d0dcf20c3ad85720f36e39f98fe61ffe74637

This release tarball now is also available
[signed by me using gpg](https://www.libelektra.org/ftp/elektra/releases/elektra-0.8.13.tar.gz.gpg)

already built API-Docu can be found [here](https://doc.libelektra.org/api/0.8.13/html/)

## Stay tuned!

Subscribe to the
[RSS feed](https://doc.libelektra.org/news/feed.rss)
to always get the release notifications.

For any questions and comments, please contact the
[Mailing List](https://lists.sourceforge.net/lists/listinfo/registry-list)
the issue tracker [on github](https://git.libelektra.org/issues)
or by mail elektra@markus-raab.org.

[Permalink to this NEWS entry](https://doc.libelektra.org/news/3c00a5f1-c017-4555-92b5-a2cf6e0803e3.html)

For more information, see [https://libelektra.org](https://libelektra.org)

Best regards,
Markus





# 0.8.14 Release

- guid: 519cbfac-6db5-4594-8a38-dec4c84b134f
- author: Markus Raab
- pubDate: Thu, 19 Nov 2015 17:48:14 +0100
- shortDesc: adds massive documentation improvements & new or overhauled plugins

Again we managed to release with many new features and plugins (lua, enum,
list, crypto, csvstorage, conditionals, mathcheck, filecheck, logchange)
many fixes, and especially with a vastly improved polished documentation.

## Documentation Initiative

The Documentation Initiative is a huge success and now the documentation
of Elektra is in a state where someone (preferable a linux guru),
never heard of Elektra, still can use Elektra only by reading man pages.

There are now many ways to show a man page:

- [on github](https://master.libelektra.org/doc/help/kdb.md)
- [in the API docu](https://doc.libelektra.org/api/latest/html/md_doc_help_kdb.html)
- by using `kdb --help` or `kdb help <command>`
- by using `man kdb`

### Help system

Ian Donnelly wrote man pages for all the tools delivered with Elektra.
Additionally, nearly all README.md are now also converted to man pages
and also to Doxygen.

### Doxygen Filter

Kurt Micheli did an amazing work with a new doxygen filter.
The filter allows all Elektra markdown pages to be also included
in the doxygen documentation. Thus all technical concepts are now
explained in Markdown pages, this filter is essential.

But even more, the filter also includes all man pages written
for the tools, giving a nice html view for them. (In addition to
the markdown rendering on github).

Enjoy the [result](https://doc.libelektra.org/api/0.8.14/html/).

A big thanks to Kurt Micheli!

### Further Docu fixes

- getenv debugging docu was improved
- typo fix: Specify, thanks to Pino Toscano
- [Design decisions](https://master.libelektra.org/doc/decisions)
  Definition of Bool, capabilities and
  Publish Subscribe (thanks to Daniel Bugl)
- Improve iconv docu
- usage examples for many plugins
- improve README for line plugin (thanks to Ian Donnelly)
- add docu about dependencies for some plugins (thanks to Ian Donnelly)
- create many new links within the documentation

## Simplicity

We shifted our [goals](https://git.libelektra.org/blob/master/doc/GOALS.md)
a bit: We want to prefer simplicity to flexibility.  Not because we
do no like flexibility, but because we think we achieved enough of it.
Currently (and in future) you can use Elektra:

- obviously as primitive key-value storage
- with specifications and dozens of plugins driven by it
- with code generation
- ...

But we cut flexibility regarding:

- namespaces are only useful for configuration (not for arbitrary key-value)
- the semantics of [metadata](https://git.libelektra.org/blob/master/doc/METADATA.ini)
- mounting functionality
- error code meanings are fixed, if a resolver detects a conflict, our defined
  error must be used
- of course ABI, API

## Qt-gui 0.0.9

Raffael Pancheri again updated his qt-gui to version 0.0.9 (beta)
with important of fixes and improvements:

- Fixes for Qt 5.5
- Handling of merge-conflicts improved
- Avoid rewriting on merge-conflicts
- Allow QML to destroy C++ owned model
- Dialog at startup
- Reduce memory footprint
- add man page

A bit thanks to Raffael Pancheri!

## Compatibility

As always, the API and API is fully forward-compatible, i.e. programs
compiled against an older 0.8 versions of Elektra will continue to work.

The behaviour of some plugins, however, changed:

- the INI plugin, the section handling was improved.
- in the NI plugin, the symbol Ni_GetVersion vanished
- in the resolver plugin files of other namespaces which are not
  mounted are not resolved anymore

### Build System

ENABLE_CXX11 does not exist anymore, it is always on.
We do not care about 199711L compilers anymore, which
makes development easier, without losing any actually
used platform.

Some programs that are only used in-source are not installed
anymore. (by Pino Toscano)

Python and Lua plugins are enabled now in `-DPLUGINS=ALL`.

Python3 plugin was renamed to python.

## Lua Plugin

Manuel Mausz add a lightweight alternative to the python plugin:
[the lua plugin](https://master.libelektra.org/src/plugins/lua/).
In a similar way, someone can write scripts, which are executed on every
access to the
[key database](https://master.libelektra.org/doc/help/elektra-glossary.md).

To mount a lua based filter, you can use:

    kdb mount file.ini /lua ini lua script=/path/to/lua/lua_filter.lua

Even though it works well, it is classified as technical preview.

Thanks to Manuel Mausz for this plugin!

## Cryptography Plugin

In this technical preview, Peter Nirschl
[demonstrates how a plugin](https://master.libelektra.org/src/plugins/crypto/)
can encrypt Elektra’s values. In testcases it is already able to do so,
but for the end user an easy way for key derivation is missing.

A big thanks to Peter Nirschl!


## INI Plugin

The INI plugin got a near rewrite. Now it handles many situations better,
has many more options and features, including:

- preserving the order
- using keys as metadata
- many new testcases
- fix escaping

Thanks to Thomas Waser for this work!

## Mathcheck plugin

This plugin allows you to check and even calculate keys from
other keys using an polish prefix notation.
It supports the typical operations `+ - / *` and
`<, <=, ==, !=, =>, >, :=`. To mount, check and
calculate values, one would use:

    kdb mount mathcheck.dump /example/mathcheck dump mathcheck
    kdb setmeta user/example/mathcheck/k check/math "== + a b"
    kdb setmeta user/example/mathcheck/k check/math ":= + a b"

For details [see the documentation](https://master.libelektra.org/src/plugins/mathcheck/).

Thanks to Thomas Waser for this important plugin!

## List Plugin

Currently, Elektra has some limitations on how many plugins can be
added to certain
[placement](https://master.libelektra.org/doc/dev/plugins-ordering.md).
Because of the rapidly growing number of plugins, some combinations
are not possible anymore.

This plugin tackles the issue, by delegating the work to an arbitrary
number of subplugins. As a bonus, it works lazily and thus might avoid
the loading of some plugins all together.

Thanks to Thomas Waser for this plugin!

## Conditionals

Brings `if` inside Elektra. It lets you check if some keys have
the values they should have.

	kdb mount conditionals.dump /tmount/conditionals conditionals dump
	kdb set user/tmount/conditionals/fkey 3.0
	kdb set user/tmount/conditionals/hkey hello
	kdb setmeta user/tmount/conditionals/key check/condition "(hkey == 'hello') ? (fkey == '3.0')" # success
	kdb setmeta user/tmount/conditionals/key check/condition "(hkey == 'hello') ? (fkey == '5.0')" # fail

For details [see the documentation](https://master.libelektra.org/src/plugins/conditionals/).

Again, thanks to Thomas Waser for this plugin!

## Csvstorage Plugin

You can now mount csv-files. To mount `test.csv` simply use:

    kdb mount test.csv /csv csvstorage

There are many options, e.g. changing the delimiter, use header
for the key names or predefine how the columns should be named.
For details [see the documentation](https://master.libelektra.org/src/plugins/csvstorage/).

Thanks to Thomas Waser!

## Filecheck plugin

This plugin lets you validate lineendings, encodings, null, bom and
unprintable characters.

The also new plugin lineendings is already superseded by the filecheck
plugin.

Thanks to Thomas Waser!

## Enum plugin

The Enum plugin checks string values of Keys by comparing it against a
list of valid values.

Thanks to Thomas Waser!

## Elektrify Machinekit.io

We are proud that [Machinekit](http://www.machinekit.io/) starts using
Elektra.

Alexander Rössler is digging into all details, and already enhanced
the DBUS Plugin for their needs. DBus now can emit a message for every
changed key.

A big thanks to Alexander Rössler!

## Bugfixes

- libgetenv did not reinitalized its mutexes on forks
- add needSync also in C++ binding
- handle removed current working directories (fallback to /)
- avoid segfault on missing version keys (when doing `kdb rm system/elektra/version`)
- fix glob plugin + kdb mount with
  [config/needs usage](https://master.libelektra.org/doc/help/elektra-contracts.md)
- fix different handling of strerror_r in macOS (thanks to Daniel Bugl)
- do not change the users parentKey in early-error scenarios
- do not try to interpret some binary keys as function keys

## Other Gems

- getenv example: do not link to elektra/elektratools,
  thanks to Pino Toscano
- fixes in other examples
- avoid useless UTF-8 chars and fix typos, thanks to Kurt Micheli
- fix kdb check return code (open fail)
- pdf now also allows UTF-8 characters if added to
  elektraSpecialCharacters.sty, thanks to Kurt Micheli
- libgetenv: lookup also used for layers
- handle wrong arguments of metals better, thanks to Ian Donnelly
- Improvement of error messages in the augeas plugin
- `kdb set` avoids fetching unnecessary namespaces
- verbose unmount
- logchange: small demonstration plugin to show how to log added,
  removed and changed keys
- setmeta will use spec as default
- libtools: avoid useless getName, add verbosity flag for findBackend
- Improve iconv error messages
- That mount needs permissions to /etc should now really be obvious
  with new error message
- many fixes in the template for new plugins

## Get It!

You can download the release from
[here](https://www.libelektra.org/ftp/elektra/releases/elektra-0.8.14.tar.gz)
and now also [here on github](https://github.com/ElektraInitiative/ftp/tree/master/releases/elektra-0.8.14.tar.gz)

- name: elektra-0.8.14.tar.gz
- size: 2252008
- md5sum: a87cd3845e590bf413959dfd555e3704
- sha1: 2360603c347ae3f3a28e827eb9260ff0b9881e46
- sha256: af681a38c9c2921b8d249f98ab851c3d51371735471d8a1f833a224c4446fe2e

This release tarball now is also available
[signed by me using gpg](https://www.libelektra.org/ftp/elektra/releases/elektra-0.8.14.tar.gz.gpg)

already built API-Docu can be found [here](https://doc.libelektra.org/api/0.8.14/html/)

## Stay tuned!

Subscribe to the
[RSS feed](https://doc.libelektra.org/news/feed.rss)
to always get the release notifications.

For any questions and comments, please contact the
[Mailing List](https://lists.sourceforge.net/lists/listinfo/registry-list)
the issue tracker [on github](https://git.libelektra.org/issues)
or by mail elektra@markus-raab.org.

[Permalink to this NEWS entry](https://doc.libelektra.org/news/519cbfac-6db5-4594-8a38-dec4c84b134f.html)

For more information, see [https://libelektra.org](https://libelektra.org)

Btw. the whole release happened with
[elektrify-getenv](https://master.libelektra.org/src/libs/getenv/README.md)
enabled.

Best regards,
Markus





# 0.8.15 Release

- guid: 1ab4a560-c286-46d2-a058-1a8e7e208fe8
- author: Markus Raab
- pubDate: Tue, 16 Feb 2016 17:47:00 +0100
- shortDesc: adds improved mounting, split of library & configuration validation

In case you do not yet know about it, here is an abstract about Elektra:

Elektra serves as a universal and secure framework to access configuration
parameters in a global, hierarchical key database.
Elektra provides a mature, consistent and easily comprehensible API.
Its modularity effectively avoids code duplication across applications
and tools regarding configuration tasks. Elektra abstracts from
cross-platform-related issues and allows applications to be aware of other
applications' configurations, leveraging easy application integration.

See [https://libelektra.org](https://libelektra.org)

## Overview

This is one of the largest release up to now. It includes many
user-visible improvements. Some highlights:

- Mounting is vastly improved:
  think about Debian's "dpkg" to "apt"-like functionality
- In previous releases you could already specify the structure
  of the configuration. Now you can also automatically enforce
  this property.
- We split the shared library `libelektra` into smaller parts.
  Now users can link against the parts of the library they need.
- As always, the ABI and API is fully forward-compatible.
- The release contains improvements in the
  [bootstrapping process](https://github.com/ElektraInitiative/libelektra/blob/master/doc/decisions/bootstrap.md).
- We improved the `ini`, `rename` and `crypto` plugins.
- The tool `kdb` now supports bookmarks and profiles.
- The new tool `kdb editor` allows you to edit KDB configuration in
  your favorite text editor.
- We are glad of the new packages for Debian, Arch Linux and OpenWRT.

The same text as follows is also available
[here as html](https://doc.libelektra.org/news/1ab4a560-c286-46d2-a058-1a8e7e208fe8.html)
and
[here on github](https://github.com/ElektraInitiative/libelektra/blob/master/doc/news/2016-02-16_0.8.15.md)

## Global Mount

Sometimes you simply want some functionality for the whole key database.
For example, you want to enable logging or notification of configuration
changes. In previous versions, you had to change every mountpoint
individually.  Even more problematic, every mountpoint created its
individual logs and notifications, without any way for someone to know
if an application has issued its last log/notification.

These problems are now solved by global plugins. The same plugins are
reused for this purpose. Also the mounting works nearly in the same way,
you only have to omit the configuration file and the mountpoint:

	kdb global-mount syslog journald dbus

Voilà, from now on every configuration change gets logged to syslog
and journald. Additionally, every application gets notified via dbus.

If you want it more verbose for debugging, you can easily do so by:

	kdb global-mount logchange counter

Which gives you detailed information to standard output which keys
were changed/edited/deleted. Additionally, Elektra counts how often
the `counter` plugin is invoked.

The underlying work for the global plugins, i.e. hooks in the core
libraries and the `list` plugin that allows us to use many plugins
without bloating the core was done by Thomas Waser.

It was already possible in earlier versions of Elektra to specify the
configuration of your program. Until now, this specification could be
mainly used to to generate code as described
[here](https://github.com/ElektraInitiative/libelektra/tree/master/src/tools/gen).
This release adds two more interesting options:

1. the spec plugin, and
2. the spec mount.

## Spec Plugin

The most important global plugin that is now newly introduced with this
release (thanks to Thomas Waser) is the `spec` plugin.  By default it
will be added for every global-mount. So for a new installation make
sure you executed at least once:

	kdb global-mount

The spec plugin is a global plugin that copies metadata from the
`spec`-namespace to other namespaces. That means, it reads the
specification, and makes sure that the configuration conforms to it. The
actual validation is done by the many validation plugins already present.

Lets start by saying a key is a long and must have at least the
value 10:

	kdb setmeta spec/example/longkey check/type long

Then we can create a key in a different namespace and see if the `spec`
plugin applies the metadata correctly:

	kdb set /example/longkey 25
	kdb lsmeta /example/longkey

Should now at least print `check/type`.
By itself, this is useful for documentation of keys.
For example, the application developer says:

	kdb setmeta spec/example/longkey description "Do not change"
	kdb setmeta spec/example/longkey example 30

The user can retrieve this documentation by:

	kdb getmeta /example/longkey description

But we want `check/type` to be not only a documentation, but also
enforced.

## Spec Mount

Using `kdb setmeta` extensively and always looking out that all plugins
are mounted correctly is error-prone. So instead, one can directly mount
the plugins as specified.  For the example above one simply needs:

	kdb setmeta spec/example mountpoint example.ecf
	kdb spec-mount /example

Now, when we try to modify `/example/longkey` it will be validated:

	kdb set /example/longkey a
	> Error (#52) [...] long [not] matched [...] a

Based on the present metadata, the correct plugins (in this case `type`
because of the metadata `check/type`) will be loaded.

We can also create a whole specification file, first mount the
specification and then the mountpoint according the specification, e.g
when we have `battery.ini` in the folder `$(dirname $(kdb file spec))`
with following content:

	[]
	mountpoint = battery.ini
	infos/plugins = ini

	[level]
	check/enum = 'critical', 'low', 'high', 'full'

Then we can use:

	# mount the file itself:
	kdb mount battery.ini spec/example/battery ni
	# make sure all plugins are present (e.g. enum for check/enum):
	kdb spec-mount /example/battery

Now lets verify if it worked:

	kdb lsmeta /example/battery/level
	# we see it has a check/enum
	kdb getmeta /example/battery/level check/enum
	# now we know allowed values
	kdb set /example/battery/level low
	# success, low is ok!
	kdb set /example/battery/level wrong
	# fails, not one of the allowed values!

The main idea of the spec-mount is: search a plugin for every
specification (metadata) found in the spec-namespace.

## General Mount Improvements

In earlier versions `kdb mount` failed when plugin dependencies were
not satisfied.  Now dependencies will automatically be fulfilled, e.g.

	kdb mount /etc/modules system/modules line

In earlier versions you would have got an error because of the missing
`null` plugin. Now it simply adds the needed plugins.

The plugins given in the command-line used to be real plugins. Now also
so called providers are accepted.

To make providers useful we need to actually know which plugin is the
best candidate. To get the information we added a `infos/status` clause
in the contract. In this clause the plugin developer adds many details
how well the plugin is tested, reviewed, documented, maintained and so
on. Based on this information, the best suited plugin will be chosen.
For example, you now can use:

	kdb mount /etc/security/limits.conf system/limits augeas \
		lens=Limits.lns logging

And the best suitable logger will automatically be chosen.

The configuration variable `/sw/kdb/current/plugins` now allows
us to pass plugin configuration with the same syntax as the plugin
specification passed on the commandline. A subtle difference is that
thus the shell-splitting of arguments is missing, it is not possible to
include whitespaces in the plugin configuration that way.

Now it is also possible to include the same plugin multiple times and
also give them individual names. This feature is essential for
script-based plugins, e.g. you now might add:

	kdb mount file.x /example/mountpoint \
		lua#resolver script=resolver.lua \
		lua#storage script=storage.lua

Furthermore, `kdb mount` now supports recommendations, which can be
enabled with `--with-recommends`. E.g. supplied to the mount command
using augeas above, comments will automatically transformed to metadata
to avoid cluttering of the real configuration.

## Library Split

Up to now, Elektra consisted only of a single shared library,
`libelektra.so`.  Not all symbols in it were relevant to end users, for
example, some were only needed by plugins. Others were only proposed and
not yet part of the stable API. And finally, other symbols were not needed
in some situations, e.g.  the plugins do not need the `kdb` interface.

Thus, we split `libelektra.so`, so that only coherent parts are in the
same library:

- `libelektra-core.so` only contains the `KeySet` data structure and
  module loading.  Every binary using Elektra should link against it.
- `libelektra-kdb.so` contains the missing `KDB` symbols. Together with
  the `core` they contain everything declared in `kdb.h`.
  Michael Zehender  plans to have multiple variants of `libelektra-kdb.so`
  that use different kinds of concurrency.
  Headerfile: `<kdb.h>`
- `libelektra-ease.so` adds functionality missing in `core` to make the
  life for C programmers easier.
  New headerfile: `kdbease.h`
- `libelektra-proposal.so` adds functionality proposed for `core`. It
  directly uses internal structures of `core`, thus they always need to
  have exactly the same version.
  Headerfile: `kdbproposal.h`

The source code is now better organized by the introduction of a `libs`
folder.  The explanation of every library can be found in
[/src/libs/](https://github.com/ElektraInitiative/libelektra/tree/master/src/libs).

The rationale of the library split is documented
[here](https://github.com/ElektraInitiative/libelektra/blob/master/doc/decisions/library_split.md).
Shortly put, it was needed for further evolution and allowing us to grow
and enhance without getting a fat core.

Thanks to Manuel Mausz for fixing many bugs related to the library split
and also adapting all the bindings for it.

### Benchmark

To show that the split does not make Elektra slower, Mihael Pranjić made
a small benchmark. The real time of
[benchmarks/large](https://github.com/ElektraInitiative/libelektra/blob/master/benchmarks/large.c)
and revision 634ad924109d3cf5d9f83c33aacfdd341b8de17a

1. kdb-static: Median :0.8800
2. kdb-full: Median :0.8700
3. kdb: Median :0.8700

So it seems that the split does not influence the time of running
elektrified processes.

*Times were measured with time(1) and the median is calculated for 21
runs of benchmarks/large. This was done using
[scripts/benchmark_libsplit.sh](https://github.com/ElektraInitiative/libelektra/blob/master/scripts/benchmark_libsplit.sh)*

## Compatibility

As always, the ABI and API is fully forward-compatible, i.e. programs
compiled against an older 0.8 version of Elektra will continue to work
(ABI) and you will be able to recompile every program without errors
(API).

We added `keyGetNamespace` which allows us to handle all namespaces
in a switch and to iterate all namespaces. This is essential, when
a new namespace is added, thus then the compiler can warn you about
every part where the new namespace is not yet considered. We currently
do not plan to add a new namespace, but better be safe than sorry.

The internal function `keyCompare` now also detects any metadata
change.

libtools was nearly rewritten. Even though it is mostly API compatible
(you should not use the low-level `Backend` anymore but instead use the
`BackendBuilder`), it is certainly not ABI compatible.  If you have an
undefined symbol: `_ZN3kdb5tools7Backend9addPluginESsNS_6KeySetE` you need
to recompile your tool. Even the merging part has ABI incompatibility
(different size of `_ZTVN3kdb5tools7merging14NewKeyStrategyE`).
Unfortunately, we still cannot guarantee compatibility in `libtools`,
further changes are planned (e.g. implementing mounting of lazy plugins).

The python(2) and lua interfaces changed, an additional argument (the
plugin configuration) is passed to `open`.

The INI plugin was rewritten, so many options changed in incompatible ways.

The default format plugin (e.g. for import/export) is no longer hard coded
to be `dump`.  Instead KDB_DEFAULT_STORAGE will be used.
To get KDB_DEFAULT_STORAGE you can use the constants plugin:

	kdb mount-info
	kdb get system/info/elektra/constants/cmake/KDB_DEFAULT_STORAGE

Thanks to Manuel Mausz plugins do no longer export any method other than
`elektraPluginSymbol`. It now will fail if you directly linked against
plugins and did not correctly use their public interface. Please
use the module loading and access functions via the contract.

The CMake and Pkgconfig Files now only link against `elektra-core` and
`elektra-kdb`.  If you used some symbols not present in `kdb.h`, your
application might not work anymore.

`libelektra.so` is still present for compatibility reasons.  It should
not be used for new applications.  Some unimportant parts, however,
moved to the "sugar" libraries.  E.g. the symbol `elektraKeyCutNamePart`
is no longer part of `libelektra.so`.

### Bootstrapping

When you use `kdbOpen` in Elektra as first step it reads mountpoint
configuration from `/elektra`.  This step is the only hard coded one,
and all other places of the KDB's tree can be customized as desired
via mounting.

The bootstrapping now changed, so that `/elektra` is not part of the
default configuration `default.ecf` (or as configured with `KDB_DB_FILE`),
but instead we use `elektra.ecf` (or as configured with `KDB_DB_INIT`).
This behaviour solves the problem that `default.ecf` was read twice
(and even differently, once for `/elektra` and once for `/`).

To be fully compatible with previous mountpoints, Elektra will still read
mountpoints from `default.ecf` as long as `elektra.ecf` is not present.

To migrate the mountpoints to the new method, simply use:

	kdb upgrade-bootstrap

which basically exports `system/elektra/mountpoints`, then does `kdb rm
-r system/elektra/mountpoints` so that `default.ecf` will be without an
mountpoint and thus the compatibility mode does not apply anymore. As
last step it will import again what it exported before.

[Details are here](https://github.com/ElektraInitiative/libelektra/blob/master/doc/decisions/bootstrap.md)

## Plugins

We already highlighted the new `spec` plugin, but also other plugins
were improved at many places.  Small other changes are:

- Conditionals now also support `assign/condition` syntax,
  thanks to Thomas Waser
- Lua and Python are not tagged experimental anymore.
  They now correctly add their configuration to the open-call.
- The plugin `yajl` (the json parser and generator) now also accepts the
  type `string` and yields better warnings on wrong types.
- Improved error message in the `type` plugin.

Larger changes were done in the following plugins:

### INI

The INI plugin was rewritten and a huge effort was taken so that it
fully-roundtrips and additionally preserves all comments and ordering.
Currently, it is brand new. It is planned that it will replace `dump`
in the future.

Currently is has some minor problems when used as KDB_DEFAULT_STORAGE.
You can avoid most problems by mounting a different file into root:

	kdb mount root.ini /

Read [here about the details](https://github.com/ElektraInitiative/libelektra/tree/master/src/plugins/ini).

A huge thanks to Thomas Waser.

### Rename

Thanks to Thomas Waser `rename` is now fixed for cascading keys.
Additionally, it does not change the `sync` status of the keys so
that notification plugins work properly afterwards.

### Crypto

The crypto plugin is a facility for securing sensitive Keys by symmetric
encryption of the value. It acts as a filter plugin and it will only
operate on Keys, which have the meta-key „crypto/encrypt“ set.

The key derivation is still work-in-progress, so the plugin does not
work with kdb yet. A planned method for key derivation is to utilize
the gpg-agent.

For now the plugin requires the following Keys within the plugin
configuration in order to work properly:

1. /crypto/key - the cryptographic key (binary 256 bit long)
2. /crypto/iv  - the initialization vector (binary 128 bit long)

Please note that this method of key input is for testing purposes only
and should never be used in a productive environment!

Thanks to Peter Nirschl, especially the patience for also supporting
different platforms where dependencies need to be handled differently.

## KDB

A technical preview of a new tool was added: `kdb editor` allows you
to edit any part of Elektra’s configuration with any editor and any
syntax. It uses 3-way merging and other stable technology, but it
currently does not provides a way to abort editing. So you only should
use it with care.

The tool `kdb list` now searches in the rpath for libraries and thus
will also find plugins not present at compile time (using `glob`).
Additionally, it sorts the plugins by `infos/status` score, which can
also be printed with `-v`. The last plugins printed are the ones ranked
highest.

When running as root, `kdb` will now use the `system` namespace when
writing configuration to cascading key names.

Long paths are cumbersome to enter in the CLI.  Thus one can define
bookmarks now. Bookmarks are key names that start with `+`.  They are
only recognized by the `kdb` tool or tools that explicitly have support
for it. Applications should not depend on the presence of a bookmark. For
example, if you set the bookmark kdb:

	kdb set user/sw/elektra/kdb/#0/current/bookmarks
	kdb set user/sw/elektra/kdb/#0/current/bookmarks/kdb user/sw/elektra/kdb/#0/current

You are able to use:

	kdb ls +kdb/bookmarks
	kdb set +kdb/format ini

The kdb tool got much more robust when the initial configuration is broken,
no man page viewer is present or Elektra was installed wrongly.

The `--help` usage is unified and improved.

The new key naming conventions are now used for
configuration of the `kdb`-tool itself: `/sw/elektra/kdb/#0/%/`
and `/sw/elektra/kdb/#0/current/` are additionally read.  The option
`-p`/`--profile` is now supported for every command, it allows to fetch
configuration from `/sw/elektra/kdb/#0/<profile>/` instead of `current`.
KDB is more robust when it cannot fetch its own configuration due to
KDB errors.

## Coding Guidelines

Thanks to Kurt Micheli the code guidelines are
[now properly documented](https://github.com/ElektraInitiative/libelektra/blob/master/doc/CODING.md).
Thanks to René Schwaiger we also provide a style file for clang-format.

Furthermore we unified and fixed the source:
- only use @ for doxygen commands
- always use elektra* functions for allocation
- added a file header for every file

## C++11 migration

Since we now only use C++11, we applied `clang-modernize` which simplified
many loops and replaced many `0` to `nullptr`. Additionally, we added
`override` and `default` at many places.

We removed all places where we had `ifdefs` to use `auto_ptr` if no
modern smart pointer is available.

Because of these changes there is no easy way to compile Elektra without
C++11 support, except by avoiding the C++ parts all together.

The C++ `KeySet` now also supports a `get` to retrieve whole containers
at once.  By specializing `KeySetTypeWrapper` you can support your own
containers.  Currently only `map<string, T>` is supported (T is any type
supported by `Key::get`).

If you haven't removed it from your flags already, there is no use
anymore to set `ENABLE_CXX11`.

## Documentation

The documentation was improved vastly.  Most thanks to Kurt Micheli who
did a lot of editing and fixed many places throughout the documentation
Also thanks to Michael Zehender who added two paragraphs in the main
README.md.

Key names of applications should be called `/sw/org/app/#0/current`,
where `current` is the default profile (non given). `org` and
`app` is supposed to not contain `/` and be completely lowercase.
Key names are documented [here](/doc/help/elektra-key-names.md).
[See also here](/doc/tutorials/application-integration.md). The main
reason for long paths is the provided flexibility in the future
(e.g. to use profiles and have a compatible path for new major versions
of configuration). By using bookmarks, users should not be confronted
by it too often.

- many man pages were improved
- many typos were fixed, thanks to Pino Toscano!
- Fix documentation for kdb list, thanks to Christian Berrer
- Compilation variants are explained better,
  thanks to Peter Nirschl for pointing out what was missing
- document ronn as dependency, thanks to Michael Zehender
- fix broken links, thanks to Daniel Bugl

Thanks to Kurt Micheli, developers are now warned during compilation on
broken links in Markdown.  The output format is the same as for gcc.
Additionally, the markdown documentation of plugins now get a proper
title in the pdf and html output of doxygen.

## Qt-Gui 0.0.10

Raffael Pancheri again updated qt-gui with many nice improvements:

- update existing nodes in case the config was changed outside the gui
- safely update tree
- add update signal to metadata
- fix crash when closing the GUI
- move Actions in separate file to make main.qml less clustered
- plugins do not output messages at startup
- `BackendBuilder` is now used, which automatically takes cares of the correct ordering of plugins
- Qt 5.4 compatibility is still ensured
- C++11 is now used in Qt-Gui, too

## Packaging and Build System

Elektra 0.8.14 now in Debian with qt-gui, man pages,
thanks to Pino Toscano
[read more here](https://packages.qa.debian.org/e/elektra/news/20151215T000031Z.html)

Thanks to Gustavo Alvarez for updating and splitting the packages on
Arch Linux!

Thanks to [Harald Geyer](http://friends.ccbib.org/harald/supporting/),
Elektra is now packaged for OpenWRT.  We fixed a number of
cross-compilation issues and now officially support building against musl
libc, with one minor limitation: RPATH works differently on musl so you
need to install all plugins directly in /usr/lib/ or set LD_LIBRARY_PATH.
Report any bugs in
[Harald's OpenWRT packaging issue tracker](https://github.com/haraldg/packages).

- export errors/symbols are now called `elektra-export-symbols` and
  `elektra-export-symbols` and can be installed using `INSTALL_BUILD_TOOLS`
  (by default off).  This is needed for cross-compilation.
  Thanks to Harald Geyer for reporting.
- some header files are renamed because they endlessly included themselves
  if the header files were found in wrong order.
  Thanks to Harald Geyer for reporting.
- fixed compilation when built on more than 20 cores with >= -j15,
  thanks to Gustavo Alvarez for reporting and Manuel Mausz for analyzing
- lua 5.1 now works too (except for iterators),
  thanks to Harald Geyer for reporting.
  thanks to Manuel Mausz for adding a new FindLua.cmake
- pdf builds do not fail due to half written files,
  reported by René Schwaiger and fixed by Kurt Micheli

Read about [other packages here](https://github.com/ElektraInitiative/libelektra#packages).

## Fixes and Improvements

- 3 way merge now properly deals with binary data,
  thanks to Felix Berlakovich
- getenv: fix wrapping on powerpc, thanks to Pino Toscano
- markdownlinkconverter: fix char/int mismatch, thanks to Pino Toscano
- wresolver: use KDB_MAX_PATH_LENGTH instead of PATH_MAX,
  thanks to Pino Toscano
- Cleaning up #ifdefs that break statements, thanks to Romero Malaquias
- Daniel Bugl tested the INI plugin
- cmake list_filter was broken because of different behaviour in
  cmake_parse_arguments, thanks to Christian Berrer for reporting
- g++5.3 is now supported
- gtest does not link against pthread if not needed
- testcases that are built with BUILD_SHARED also successfully work
- kdb list works when libs are in same path as plugins,
  thanks to Harald Geyer for reporting
- fix macOS issues,
  thanks to Peter Nirschl, René Schwaiger and Mihael Pranjic
- fix resolver-baseflag docu, thanks to Harald Geyer for reporting
- do not create wrong directories called `(` and `)` in source,
  thanks to René Schwaiger
- fix cmake for systems where iconv is not part of libc,
  thanks to Michael Zehender and Peter Kümmel (for FindIconv.cmake)
- fix segfault in libgetenv if root keys are present
- lua: fix Key:tostring(), thanks to Manuel Mausz
- add list of [supported bindings](https://github.com/ElektraInitiative/libelektra/tree/master/src/bindings),
  thanks to Manuel Mausz

## Get It!

You can download the release from
[here](https://www.libelektra.org/ftp/elektra/releases/elektra-0.8.15.tar.gz)
and now also [here on github](https://github.com/ElektraInitiative/ftp/tree/master/releases/elektra-0.8.15.tar.gz)

- name: elektra-0.8.15.tar.gz
- size: 2338297
- md5sum: 33ec1e5982fb7fbd8893bf7b579b80f0
- sha1: 6b1fdd5aa5aaad6ba377b4bb5ef437e0c85319ff
- sha256: 6a406986cecb8d4a44485ced118ee803bc039b0824b72298e123b4dd47eb0b22
- sha512: 86a408dd546b33e3b437f92f415de7aee6a235189f9eab0762b3f44ab4c453ee369a53de10a9f5b0df1b446460b12c57c6b8b77c282648ec2a49f2328d9af13d

This release tarball now is also available
[signed by me using gpg](https://www.libelektra.org/ftp/elektra/releases/elektra-0.8.15.tar.gz.gpg)

already built API-Docu can be found [here](https://doc.libelektra.org/api/0.8.15/html/)

## Stay tuned!

Subscribe to the
[RSS feed](https://doc.libelektra.org/news/feed.rss)
to always get the release notifications.

For any questions and comments, please contact the
[Mailing List](https://lists.sourceforge.net/lists/listinfo/registry-list)
the issue tracker [on github](https://git.libelektra.org/issues)
or by mail elektra@markus-raab.org.

[Permalink to this NEWS entry](https://doc.libelektra.org/news/1ab4a560-c286-46d2-a058-1a8e7e208fe8.html)

For more information, see [https://libelektra.org](https://libelektra.org)

Best regards,
Markus





# 0.8.16 Release

- guid: 9c9247ee-ee9c-4f4a-a68e-76959def9b82
- author: Markus Raab
- pubDate: Fri, 29 Apr 2016 12:45:39 +0200
- shortDesc: adds stability improvements, configuration profiles & new plugins

In case you do not yet know about it, here is an abstract about Elektra:

Elektra serves as a universal and secure framework to access configuration
parameters in a global, hierarchical key database.
Elektra provides a mature, consistent and easily comprehensible API.
Its modularity effectively avoids code duplication across applications
and tools regarding configuration tasks. Elektra abstracts from
cross-platform-related issues and allows applications to be aware of other
applications' configurations, leveraging easy application integration.

Elektra consists of three parts:

1. *LibElektra* is a modular configuration access toolkit to
   construct and integrate applications into a global,
   hierarchical key database. The building blocks are:
   - language bindings (inclusive high-level interfaces)
   - GenElektra, the code generator for type-safe bindings
   - plugins for configuration access behaviour and validation
2. *SpecElektra* is a configuration specification language
   that is easy to use and self-contained in the same key database (i.e.
   written in any of the configuration file formats Elektra supports).
3. Tools on top of LibElektra for administrators, such as CLI tools and GUIs.

See [https://libelektra.org](https://libelektra.org)

The same text as follows is also available
[here as html](https://doc.libelektra.org/news/9c9247ee-ee9c-4f4a-a68e-76959def9b82.html)
and
[here on github](https://github.com/ElektraInitiative/libelektra/blob/master/doc/news/2016-04-29_0.8.16.md)

## Highlights

- Elektra now allows applications to support multiple
  profiles with a plugin, thus *without code modifications* in
  Elektra applications.
  That means a user can select multiple configuration files to use,
  even if the application has no explicit support for it.
  It completes the cascading feature (level $HOME before /etc), to allows
  us also to select different configuration for the same level.
- Resolver can now better handle conflicts that happen
  when files are removed and others that happen
  within a single time tick (resolution of your clock)
  and also better handles NFS and older file systems
- Default storage and resolver can be changed by symlink.
  So no need to recompile Elektra to change the default storage
  from INI to dump.
  INI now works quite reliable as default plugin and already
  used by default by its author Thomas Waser.

## Other important features

- shell plugin allows you to execute shell commands on every KDB access
  and curlget plugin allows you to download configuration files
  from a URL during KDB access.
- Improvements in sync/merge of qt-gui with important fix
  (Usage of 0.8.15 qt-gui is discouraged)
- Add plugin for dpkg database (read-only)
- Assignment for conditionals using `assign/condition`.
- Support for multiple and nested statements
- Support for `condition/validsuffix` which allows you to suffix
  numbers with signs such as `%` or `$`.
  It does not check if the suffixes are identical.
- kdb mount now uses topological sorting to always
  find a dependency solution if there is one,
  many effort was put in that ordering is as requested, thanks to
  Thomas Waser for the topological sorting implementation
- Frontend generated by GenElektra now also can reload its
  values with taking the correct context into account.
- Source is now automatically formatted and formatting is checked on build server
- More flexible CMake syntax for PLUGINS

## Plugins

Many new or vastly improved plugins are waiting to be explored.

### curlget

The plugin curlget fetches a configuration file from a remote host before
the configuration is being accessed:

    kdb mount -R noresolver /tmp/curltest.ini system/curltest ini curlget url="https://raw.githubusercontent.com/ElektraInitiative/libelektra/master/src/plugins/ini/ini/plainini"
    kdb ls system/curltest  # every get access will redownload the file

Thanks to Thomas Waser!

### INI

The INI plugin is still under heavy development and
was again nearly rewritten:

- fixed key is below hacks
- fixed ordering
- custom delimiter
- use meta array for comments
- rewritten ordering
- best effort order
- fixed array support

Thanks to Thomas Waser!

### shell

This plugin allows you to executes shell commandos after kdbGet, kdbSet and kdbError (failing kdbSet):

    kdb mount /tmp/test.ini system/shelltest ini array= shell 'execute/set=echo set >> /tmp/log,execute/get=echo get >> /tmp/log'
    kdb set system/shelltest
    cat /tmp/log

Thanks to Thomas Waser!

### validation

The validation plugin is not new, but got many new features.
It allows you to match values by a regex and set your own
error messages in case a validation did not match.

Up to now, the regex was given as is to regcomp, which means
that if the regex is contained *anywhere* in the value, the
value is accepted.

Often this is not what we want, thus Thomas Waser added special
support for icase, word and line validation.
Additionally, flags allow you now to ignore the case or invert
the match. This can be changed for every individual value
or for the whole mountpoint.

Additionally, `kdb vset` validation was updated to use the new
metadata and correctly match against the whole value.

Thanks to Thomas Waser!

### hosts

Only minor improvements were necessary for the host plugin but
it is quite matured already. The contract was changed so that
ipv6 addresses for ipv4 addresses will be rejected:

```
# kdb mount --with-recommends /etc/hosts system/hosts hosts
# kdb set system/hosts/ipv4/localhost ::1
The command set failed...
Reason: localhost value: ::1 message: Address family not supported
# kdb set system/hosts/ipv6/localhost ::1
```

You can also comfortably and safely edit the hosts file
with: `kdb editor system/hosts hosts`, then you have the
functionality `visudo` for the hosts file.

### rename

Again not a new plugin, but the plugin was greatly improved
and many test cases were added.

Now you can set upper/lowercase individually for both sides:

1. What applications see.
2. What the configuration file contains.

For example, if you always want the keys in the configuration file upper case,
but for your application lower case you would use:
```
$ kdb mount caseconversion.ini /rename ini rename get/case=tolower,set/case=toupper
$ kdb set user/rename/section/key valu
$ cat ~/.config/caseconversion.ini
[SECTION]
KEY = value
```

Thanks to Thomas Waser!

### Resolver

Resolving by ~ as home directory now also for system and spec namespaces,
thanks to Thomas Waser.

Files keep their previous owner, useful when root edits configuration
files of others, thanks to Thomas Waser.

The resolver has many improvements to better detect conflicts.

The lock is now extended longer after the commit and already requested
in the temporary file.

The warnings were improved when `getcwd` fails.

Resolver now can correctly handle conflicts with empty files.  It can also
better cope with frequent commits of the same binary.  Elektra already
reached some limits filesystems have.

## Bindings

### Java

Marvin Mall improved the Java binding, fixed the appending
of keysets, added lots of documentation, and many unit tests.

### C++

Some kind of misusage of vaargs is now detected at compile-time instead
of crashing at runtime.

### Generated C++

Value now supports convenience activations.
Values can be used to activate context, no more layers are needed.
Topological sorting makes sure that values are activated in the
correct order, loops are not allowed anymore.

The `bool operator<` is now correctly inline (allows to use it in more than
one translation unit)

## Documentation

René Schwaiger<sanssecours> reworked most of the documentation and
fixed countless spelling mistakes and other problems.

- Peter Nirschl updated the status of the crypto-plugin
  and fixed a typo
- Daniel Bugl wrote a cascading tutorial
- Daniel Bugl fixed all broken links
- René Schwaiger also drew a new logo with SVG.
  It is already used on github as avatar for the organisation.
- make all é use the same code point 233.

## Testing

- Tests work if the build path contains spaces
- Tests: Fix problems locating memory checker
- remove obsolete TestScript.cmake

Thanks to René Schwaiger

## Maintainer

By default now ALL plugins except EXPERIMENTAL are included.
Plugins will be automatically excluded if dependencies are missing.

The PLUGINS syntax was vastly improved.  Now many categories can be
intermixed freely and also categories can be used for exclusion.

E.g. to include all plugins without deps,
that provide storage (except yajl) and are maintained, but not include all plugins
that are experimental, you would use:

	-DPLUGINS="NODEP;STORAGE;-yajl;MAINTAINED;-EXPERIMENTAL"

Details see [/doc/COMPILE.md](https://github.com/ElektraInitiative/libelektra/tree/master/doc/COMPILE.md).

### Renamed files:

/usr/include/elektra/merging/kdbmerge.hpp ->
  /usr/include/elektra/merging/mergingkdb.hpp

/etc/profile.d/kdb -> /etc/profile.d/kdb.sh

(So that it works on arch linux, thanks to Gabriel Rauter)

### removed files:

- /usr/lib/elektra/libelektra-crypto.so

was only necessary because of limitations of the build system and is
now removed.  It never had actual functionality, but was only a stub
without a crypto provider selected.

### new files:

- /usr/include/kdbease.h
- /usr/lib/elektra4/libelektra-curlget.so*
- /usr/lib/elektra4/libelektra-dpkg.so*
- /usr/lib/elektra4/libelektra-profile.so*
- /usr/lib/elektra4/libelektra-resolver_fm_hpu_b.so
- /usr/lib/elektra4/libelektra-shell.so*

more new files with ALL or EXPERIMENTAL:

- /usr/lib/elektra/libelektra-semlock.so

new tests all in folder /usr/lib/elektra/tool_exec:
testcpp_contextual_update testkdb_conflict test_keyname testmod_curlget
testmod_dpkg testmod_jni testmod_profile testmod_semlock testmod_shell
testtool_mergingkdb

Following Plugins are excluded on specific platforms:

- mathcheck on Intel compiler (reason: failing test cases)
- simpleini on non-glibc systems (reason: not portable printf extension)

### new symlinks:

- /usr/lib/elektra4/libelektra-storage.so
- /usr/lib/elektra4/libelektra-resolver.so

### new releases

The first release of the libraries libelektratools-full, libelektratools
and libelektragetenv. They now have SOVERSION 0.

## Development

You do not need to format the source manually anymore.
Make sure that you run scripts/reformat-source before
creating a PR.

`clang-tidy` helps you to add blocks to have better
maintainable code.

Felix Berlakovich improved the performance of the augeas plugin and
also contributed a script to benchmark different host plugin.
His thesis can be downloaded from [here](https://www.libelektra.org/ftp/elektra/berlakovich2016universal.pdf).
It contains benchmarks and discussions about augeas.

The CMake function `add_plugin` was completely rewritten.
Now you do not have to register your plugin at multiple points
but instead information of README.md is parsed to correctly
register the plugin to categories as stated by `infos/status`
and `infos/provides`.

The code generator for errors also yields macros. This
avoids usage of the IDs, which can be problematic if
multiple pullrequests are prepared at once.

## Compatibility

This might be the last release supporting wheezy, because
it gets more and more time-intensive to find workarounds
for the old compiler. The C++11 regex do not work at all.

### Binary Compatibility Test

When you execute the testcases of 0.8.15 against Elektra 0.8.16
following testcases fail. None of them effect the API.

- test_splitget test_splitset .. Internal restructuring
- testmod_crypto .. not included by default now
- testmod_ini .. section handling changed, line 178:
                `nosectionkey contained no comment`
- testmod_rename .. internal API elektraKeyCreateNewName changed
- testmod_resolver .. internal data structure now contains more
                     members to remember uid and gid
- testmod_template .. not present by default
- testtool_backend testtool_backendbuilder testtool_backendparser
- testtool_specreader .. changes in KDB tool before release
- check_kdb_internal_check .. experimental plugins are now excluded

### Added API

in libease René Schwaiger added:

    extern char const * elektraKeyGetRelativeName(Key const * cur, Key const * parentKey);

in libmeta Thomas Waser added (partly based on ideas/code from Felix Berlakovich):

    extern void elektraMetaArrayAdd(Key *, char const *, char const *);
    extern KeySet * elektraMetaArrayToKS(Key *, char const *);
    extern char * elektraMetaArrayToString(Key *, char const *, char const *);
    extern int elektraSortTopology(KeySet *, Key * *);

## Tools

### Qt-gui

Raffael Pancheri fixed an important issue which broke the synchronization
because an key related to Elektra’s internal version information was missing.

Felix Berlakovich updated the qt-gui so that it uses a newly written sync-method
added in libtools.

Gabriel Rauter added a desktop file that uses the new svg logo from
René Schwaiger.

## Portability

- Peter Nirschl fixed code in the resolver that uses EBADMSG which was not
  available in BSD.
- Peter Nirschl improved detection of librt
- Felix Berlakovich fixed searching of FindSystemd
- MinGW64 resolver now handles conflicts correctly and does not ignore them
  anymore and now also is able to create empty files (but still not directories)

### macOS

A lot of effort was invested to all test cases also run on macOS:

- .template syntax
- linking errors
- fix regex in conditionals plugins

Thanks to René Schwaiger

## Bugs

- print null-environment correctly with `kdb getenv`
- keyIs(Direct)Below didn't work with cascading keys
- fix elektraKeyGetRelativeName (needed by ni) for cascading
  keys and move it to libease, thanks to René Schwaiger
- make nickel tests show correct test name, thanks to René Schwaiger
- glib: replace cursor_t with gssize so that GElektra-4.0.gir
  builds with gobject-introspection later than 1.47, thanks to Manuel Mausz
- fixed out-of-bounds bug in timeofday plugin
- elektraMetaArrayToKS correctly adds parent key, thanks to Thomas Waser
- kdb-shell: Do not abort ksOutput on binary data.
- some rework for global hooks, still not stable

## Get It!

You can download the release from
[here](https://www.libelektra.org/ftp/elektra/releases/elektra-0.8.16.tar.gz)
and now also [here on github](https://github.com/ElektraInitiative/ftp/tree/master/releases/elektra-0.8.16.tar.gz)

- name: elektra-0.8.16.tar.gz
- size: 2405443
- md5sum: ef0c138b4a4fda017aa8bb6f812671ce
- sha1: c6a6f9c26addd5fcc274cea635de02ef680cfb1a
- sha256: 3cf0624eb027e533192ca9d612618df3d38ec3674c9cd20474f04ff269fad77e
- sha512: b225e61379907365a423ea75ec7138e5257bb78c526bb05a1ec21f66a52eb4bad9e6f1eb23209d700670b21b86166497b47c3bc46bc9d45f6d366cd544afc326

This release tarball now is also available
[signed by me using gpg](https://www.libelektra.org/ftp/elektra/releases/elektra-0.8.16.tar.gz.gpg)

already built API-Docu can be found [here](https://doc.libelektra.org/api/0.8.16/html/)

## Stay tuned!

Subscribe to the
[RSS feed](https://doc.libelektra.org/news/feed.rss)
to always get the release notifications.

For any questions and comments, please contact the
[Mailing List](https://lists.sourceforge.net/lists/listinfo/registry-list)
the issue tracker [on github](https://git.libelektra.org/issues)
or by mail elektra@markus-raab.org.

[Permalink to this NEWS entry](https://doc.libelektra.org/news/9c9247ee-ee9c-4f4a-a68e-76959def9b82.html)

For more information, see [https://libelektra.org](https://libelektra.org)

Best regards,
Markus





# 0.8.17 Release

- guid: e6153a39-c4bd-41c3-bc86-785d451eb6c5
- author: Markus Raab
- pubDate: Tue, 14 Jun 2016 08:32:44 +0200
- shortDesc: adds several improvements & survey about configuration

## Survey

First off: We created a survey questionnaire to gather more knowledge
about the relevance of configuration systems.  If you are involved in
the development of free and open source software (FLOSS) you are the
person we are looking for.

It would be a great help if you take this survey:

[survey](http://elektra.limequery.org/625192)

It will be available till 18.07.2016 (anywhere on earth).

For every thoroughly and not anonymously finished survey € 40 cent
will be donated to one of the following organizations of your choice:

- LimeSurvey (LimeService, kindly hosts this survey)
- SPI (General Donation: 0 A.D., LibreOffice, Debian, ArchLinux, …)
- FSFE
- GNOME
- KDE
- Mozilla (Firefox)
- Wikimedia Foundation (Wikipedia)

## Why should I use Elektra?

The three main points relevant for most people are:

1. Even though Elektra provides a global keydatabase
   configuration files stay human read- and writable
   which allows us to integrate unmodified software.
2. Flexible adoption on how the configuration is accessed
   via plugins: you can run arbitrary code, e.g. do a
   `git commit` or log/notify when configuration files
   are changed.
3. Elektra allows you to specify configuration values:
   - use the value of other configuration values (symbolic links)
   - calculate the values based on other configuration values
   - validation configuration files
   - [generate code based on it](https://github.com/elektrainitiative/libelektra/tree/master/src/tools/gen)
   - [and much more](https://github.com/elektrainitiative/libelektra/tree/master/src/plugins/README.md)

Read more about [Why using Elektra](https://github.com/elektrainitiative/libelektra/tree/master/doc/WHY.md),
which also contains since this release unique features,
further reasons and limitations.

For a small demo see here

[![asciicast](https://asciinema.org/a/cantr04assr4jkv8v34uz9b8r.png)](https://asciinema.org/a/cantr04assr4jkv8v34uz9b8r)

## Highlights

- Qt-Gui reworked mounting and native icons
- Full macOS Support, Build Server improvements
  and new beginner friendly tasks
- allows us to mount csv, json and xml (and other common provider names)
  without needing to know plugin names
- colored output for kdb tools
- Experimental GSettings support

## Beginner friendly tasks

In this release starting developing Elektra gets easier:

- `ELEKTRA_DEBUG` adds run-time checks and makes stack traces
  as if Elektra would not use plugins
- `CMakeLists.txt` for plugins got simplified, in most cases it
  should be not more than calling a single function,
  even if unit tests and test data are present
- We prepared [beginner friendly tasks](https://github.com/ElektraInitiative/libelektra/issues?q=is%3Aissue+is%3Aopen+label%3A%22beginner+friendly%22)
  for you.

For details about `ELEKTRA_DEBUG` and cmake, see individual points below.

## Find-Tools

There is now a fine collection of external scripts which can
executed by `kdb + <script>`. The new script `kdb find-tools`
provides full text search over the meta data as provided by
the scripts.

   * `kdb find-tools -b BRIEF` to search for a short text.
   * `kdb find-tools -a AUTHOR` to search for a author.
   * `kdb find-tools -d DATE` to search for a creation date.
   * `kdb find-tools -e EXECUTE` to search for a type.

Developers should now [add MetaData for their scripts.](https://github.com/elektrainitiative/libelektra/tree/master/scripts/README.md).

Thanks to Kurt Micheli!

## macOS Support

Because of its POSIX support one might think it would be trivial to
support macOS. Unfortunately there were many small issues, especially
in the regular expression handling and the filesystem.

Nevertheless we finally fully support macOS and the newly added
travis build server makes sure it will stay this way.

A huge thanks to Manuel Mausz and Mihael Pranjić for fixing the
issues and setting up travis:

- jni plugin now can load Elektra (avoids using `.so`)
  thanks to Mihael Pranjić
- initial creation of travis.yml
  thanks to Manuel Mausz
- Add all 3 different XCode setups and some macOS fixes
  thanks to Mihael Pranjić

## jenkins

Now (nearly) every build job can be triggered from Pull Requests.
For example:

* jenkins build [git-buildpackage-jessie](https://build.libelektra.org/job/elektra-git-buildpackage-jessie/) please
* jenkins build [git-buildpackage-wheezy](https://build.libelektra.org/job/elektra-git-buildpackage-wheezy/) please
* jenkins build [icc](https://build.libelektra.org/job/elektra-icc/) please
* jenkins build [local-installation](https://build.libelektra.org/job/elektra-local-installation/) please

For a full list see [here](https://github.com/elektrainitiative/libelektra/tree/master/doc/GIT.md).

Thanks to Mihael Pranjić for the setup!

## Fixes

- fix inconsistency with one excluded compilation variant,
  thanks to Harald Geyer for reporting #698
- fix dynamic searching of installed plugins,
  needed so that kdb list-tools works correctly
  thanks to Harald Geyer for reporting
- kdbtimer, `include <vector>` as needed by some compilers,
  a big thanks to Andreas Bombe for the non-maintainer
  upload in Debian to fix it for upcoming Debian release
- also find yajl header files if installed in non-standard
  include directories,
  thanks to Mihael Pranjić
- glib: make sure we use all definitions returned by pkg-config #719,
  fixes build on FreeBSD
  now glib bindings need cmake 2.8.12
  thanks to Mihael Pranjić for reporting/testing
  and Manuel Mausz  for fixing
- fix INI for macOS (did require some non-portable sorting
  properties of `qsort`.)
- INI makes INI-specific meta-data private by prefixing `ini`.
- `kdb export` also works under MinGW,
  thanks to Gabriel Rauter

## Rework Add Plugin

- prefer to link shared
- add plugin tests when using link shared
- make ADD_TEST simpler (without calling add_plugintest)
- make installation of test data simpler + honor INSTALL_TESTING option
- fix installation of test_data (do not install whole dir)
- introduce cache so that it is enough to pass parameters
  to add_plugin* once
- avoid PLUGIN_DIRECTORY_NAME and change CMAKE_CURRENT_SOURCE_DIR
  and CMAKE_CURRENT_BINARY_DIR instead
- add_plugin: remove unused option SHARED_SOURCES
- implement a 3rd phase to add test cases:
  correctly handles dependencies of testcases to bindings
- fix testmod_jni

## CMake

for maintainers:

- The cmake variables KDB_DB_SYSTEM and KDB_DB_HOME are now STRING and not PATH.
- BUILD_FULL and BUILD_STATIC are now OFF by default
- building with BUILD_SHARED is now preferred (for all examples, test cases,...)
- ELEKTRA_DEBUG_BUILD and ELEKTRA_VERBOSE_BUILD is not used anymore.
- ENABLE_DEBUG was added: it does not add debug symbols but run-time assertions.
- More cmake variables are marked as advanced.

for developers:

- BUILD_STATIC and BUILD_FULL is now OFF by default
  (nearly) all unit tests now also work with BUILD_SHARED
- to support shared unit tests, a third phase was added when
  adding plugins
  inconsistent adding (across phases) of plugins and unit tests is reported
- in `add_plugin` remove SHARED_SOURCES, and add `ADD_TEST` and `INSTALL_TEST_DATA`.

and fixes:

- adding plugin tests is now much simpler, simply use `ADD_TEST`
  in `add_plugin`.
- KDB_DB_SYSTEM and KDB_DB_HOME are now STRING and not PATH because
  of incorrect resolving of `~`.
- lua bindings tests: make sure lua executable matches with the lua libraries version
  thanks to Mihael Pranjić
- lua bindings: do not use hard-coded `lua` executable.
- Fix cmake configure when BUILD_DOCUMENTATION is set to OFF
  thanks to Kurt Micheli

See more about changes to plugin adding in cmake in the
[plugin decision](https://github.com/elektrainitiative/libelektra/tree/master/doc/decisions/cmake_plugins.md).

## Experimental GSettings support

As part of the ongoing work of the bachelor thesis
`Integration of Elektra into the GNOME desktop environment`
we now have experimental support for Elektra as a GSettings backend on Linux
(We will look into getting macOS support on a later date).
When installed, applications using GSettings default backend will write to Elektra
below the `/sw` key. The GSettings bindings are intended as a preview version so
please do not use them in a production system.

To build the GSettings backend you have to explicitly add the binding even if `ALL` is given.
e.g. `-DBINDINGS=gsettings` `-DBINDINGS="ALL;gsettings"`

All needed core functionality of a GSettings backend is already implemented.
This includes notification support if you have your `/sw` mounted with the dbus plugin.

Please report any bugs you encounter.

For further information regarding the status of the implementations
please refer to the corresponding [README](https://github.com/elektrainitiative/libelektra/tree/master/src/bindings/gsettings)
and [ticket](https://github.com/ElektraInitiative/libelektra/issues/775).

## Common Provider Names

Mounting now supports to mount commonly known names even if the name is not a plugin.
If more than one plugin is available automatically the best one is selected.
The selection process works by annotating different qualities of the plugins,
see `infos/status` in the README.md of individual plugins.

E.g. to mount a file using a json plugin (called yajl because of the library's name
it build upon)

    kdb mount file.json json

## New Cachefilter Plugin

stores filtered keys internally so that they
do not get accidentally lost and can be written to the storage again without
the user having to remember including them in the writeout

The longer term goal is to add such global plugins per default, so that
the usage of the API is easier.

For now you can simply add it using:

     kdb global-mount cachefilter

Thanks to Marvin Mall.

## Qt GUI 0.0.12

The Qt GUI receives new features and a better gnome integration.
Its version number was updated to 0.0.12 (beta).
Major features:

- use native icons (Qt GUI xdg icon theme support rework)
  thanks to Gabriel Rauter
- update desktop entry org.libelektra.elektra-qt-editor.desktop
  with new symbolic icon of Elektra’s logo
  so that qt-gui can nicely started from within Gnome
  thanks to Gabriel Rauter
- Add new layout elements to backend wizard
  and integrate new BackendBuilder functionality (See Common Provider Names) to qt-gui
  thanks to Raffael Pancheri

Bug fixes:

- Reset to defaults now reverts back to build-in defaults.
- Make clicks on search icon focus on search textfield.
- save settings when settings dialog is closed.
- fix crash of qt-gui when crypto plugin was enabled
  (and added /shutdown option to enable previous behaviour)
  thanks to Peter Nirschl
- fix qt-gui fails to synchronize because of readonly plugins
  thanks to Raffael Pancheri
- Rename desktop file: correct reverse url from org.elektra to org.libelektra.
- Rename elektra-qt to elektra-qt-editor.
- Rename ChooseColorWindow: The ChooseColorWindows will be replaced by a
  AppearanceSettingsWindow, all references to ChooseColor, choose color have been
  replaced by AppearanceSettings or choose appearance.

Other improvements:

- Install `elektra-qt-editor` binary so both the desktop files TryExec works
  and people not starting the gui trough `kdb qt-gui` have a speaking name
  in their process list.
- Replace occurences of `Elektra Editor` with `Elektra Qt Editor` so that
  we use the same name in all places apart from the tools binary.
- Introduce Appearance Settings Window: Appearance Settings Window
  contains both color settings as well as a switch to disable or enable
  the system icon theme. For this to work we had to introduce the setting
  in `guisettings`. We also added a private function in `guisettings` to
  get and set settings with a boolean value.
- Tree reload on Settings close: We now synch and refresh the tree view on
  closing of the settings window if any settings have been changed, so
  changes can be seen imediatly in the tree.
- Add qt5 svg module as dependency: the qt5 svg module is needed so we can
  display icon themes that provide svg as icon format.
- Add and install symbolic icon with the installation of the Elektra
  Qt Editor.

Thanks to Gabriel Rauter and Raffael Pancheri for the engagement in
improving qt-gui.

## Colored kdb tool

A big thanks to Gabriel Rauter for improving the user experience with the kdb tool.
On errors and in `kdb info` it was often quite hard to find the relevant text.

Now important parts are highlighted by bold or colorful text.
This helps to spot the important information immediately without sacrificing
information that would be important for a detailed analysis.

Every tool now has the option `--color` and `-C` which is set to `auto` per default.
By writing to:

    kdb set user/sw/elektra/kdb/#0/color off

one can go back to previous behavior.

## Documentation

- improve documentation about how to pop a key
- document how to avoid running test cases as root in
  [TESTING.md](https://github.com/elektrainitiative/libelektra/tree/master/doc/TESTING.md).
- document guarantees of `elektraPluginGetData`,
  thanks to Marvin Mall
- doc mentions that -1 should be returned
  *always* when an error is set
- many more spelling mistakes were fixed and useless whitespace was removed,
  thanks to René Schwaiger
- describe preferences when plugins are included/excluded
- improvements in `ksCopy`, `ksPop`, `kdbGet` and `kdbSet`
  [API description](https://doc.libelektra.org/api/0.8.17/html/)
- added [WHY document](https://github.com/elektrainitiative/libelektra/tree/master/doc/WHY.md)
- updated [plugin decision](https://github.com/elektrainitiative/libelektra/tree/master/doc/decisions/cmake_plugins.md) to include 3rd phase

## ELEKTRA_DEBUG build

ENABLE_DEBUG now enables a debug build for Elektra.
It has nothing to do with debug symbols, but:

- it enables assertions
- it enables [undefinied behavior sanitizer](http://clang.llvm.org/docs/UndefinedBehaviorSanitizer.html)
  for clang
- plugins will not be closed so that stack traces are more useful
  (using `RTLD_NODELETE`)

`ENABLE_DEBUG` is recommended for every developer, even if you are not
modifying Elektra itself. The assertions will give you hints on API misusage.

For example, `keyNew` was known to be error-prone. `ENABLE_DEBUG` now will report
wrong parameters by an assertion.

The old options `ELEKTRA_DEBUG` and `ELEKTRA_VERBOSE` are not available anymore.

Thanks to:
- Thomas Waser for pointing to `RTLD_NODELETE`
- Gabriel Rauter for fixing qt-gui with `-DENABLE_DEBUG=ON`


The constants plugin was updated to provide `cmake/ENABLE_LOGGER` `cmake/ENABLE_DEBUG`
and will no longer provide `cmake/ELEKTRA_DEBUG_BUILD` `cmake/ELEKTRA_VERBOSE_BUILD`

## Other

- Gabriel Rauter is now listed in
  [AUTHORS.md](https://github.com/elektrainitiative/libelektra/tree/master/doc/AUTHORS.md)
- constants plugin: configure_file now uses current binary directory, not cluttering
  the main build directory.
- fix ssize_t for VS2015,
  thanks to Gabriel Rauter
- gtest: fix linking when using arch systemd-nspawn,
  thanks to Marvin Mall
- `LD_LIBRARY_PATH` is added to lua and python bindings needed for macOS,
  thanks to Mihael Pranjić
- Fix external unit test for Ubuntu 15.04 by putting files before
  the flags,
  thanks to Marvin Mall
- symbols in Ni_ namespace are now in elektraNi_
- add more ipv4 and ipv6 test cases for IP adress validation
  checker
- crypto-plugin avoid usage of hardcoded error numbers,
  thanks to Peter Nirschl
- do not use number for resolver position
- to fix a compiler warning in macOS, we made the printf
  format specifier of time_t more portable,
  thanks to René Schwaiger
- many preparations for global plugins and mmap
- in the constants plugin `cmake/BUILTIN_PLUGIN_FOLDER`, `BUILTIN_DATA_FOLDER`
  and `BUILTIN_EXEC_FOLDER` were added.
- doxygen is only run once during build,
  thanks to René Schwaiger
- add script configure-home to build Elektra
  that it will resolve all pathes to home-directories
- add script metaini-to-c that converts METADATA.ini
  to C-code, thanks to Thomas Waser
- add note that default values must be present for
  code generation, thanks to Martin Schleiss
- avoid `seq` as it is not available in some `*BSD`,
  thanks to Mihael Pranjić
- make jni testmod check consistent to others

## Compatibility

As always, the ABI and API is fully forward- and backward-compatible, i.e. programs
compiled against an older 0.8 version of Elektra will continue to work
(ABI) and you will be able to recompile every program without errors
(API). This time you can even compile programs against 0.8.17 and run with 0.8.16.

For the qt-gui the svg module is added as dependency.

New and missing files in the installation:

- `elektra-qt-editor` is installed in the path (needed for TryExec in Desktop file)
- `libelektrasettings.so` will be installed if `gsettings` binding is enabled
- `libelektra-cachefilter.so` is the new cachefilter plugin
- `tool_exec/testmod_cachefilter` is its unit test
- `tool_exec/find-tools` is a new python script to find other tools
- `appdata/org.libelektra.elektra-qt-editor.appdata.xml`
- `icons/hicolor/scalable/apps/elektra-symbolic.svg`
- `share/man/man1/kdb-find-tools.1`

Renamed files:

- `applications/org.elektra.elektra-qt.desktop` got renamed to
  `applications/org.libelektra.elektra-qt-editor.desktop`.

Removed files:

- Some of the installed "test data" actually was source code from
  Elektra. Test data from the following plugins is affected:
  `hosts`, `ini`, `lineendings`,

Temporarily removed files:

- `testmod_lua`, `testmod_python` and `testmod_python2` do not work in a shared build
  and are temporarily disabled if `BUILD_SHARED` is enabled.
  Also their test data is affected.

## Get It!

You can download the release from
[here](https://www.libelektra.org/ftp/elektra/releases/elektra-0.8.17.tar.gz)
and also [here on github](https://github.com/ElektraInitiative/ftp/tree/master/releases/elektra-0.8.17.tar.gz)

- name: elektra-0.8.17.tar.gz
- size: 2459542
- md5sum: e53efdb9a5e0852c58b21280b1e6c07d
- sha1: a1abcd4ac5aabfc60c34da98a02c4636e4634b5c
- sha256: a6a41afb0160feef84f7d1e0d199da26022ff8cb52ed455a0d306b589838d8f5

This release tarball now is also available
[signed by me using gpg](https://www.libelektra.org/ftp/elektra/releases/elektra-0.8.17.tar.gz.gpg)

already built API-Docu can be found [here](https://doc.libelektra.org/api/0.8.17/html/)

## Stay tuned!

Subscribe to the
[RSS feed](https://doc.libelektra.org/news/feed.rss)
to always get the release notifications.

For any questions and comments, please contact the
[Mailing List](https://lists.sourceforge.net/lists/listinfo/registry-list)
the issue tracker [on github](https://git.libelektra.org/issues)
or by email elektra@markus-raab.org.

[Permalink to this NEWS entry](https://doc.libelektra.org/news/e6153a39-c4bd-41c3-bc86-785d451eb6c5.html)

For more information, see [https://libelektra.org](https://libelektra.org)

Best regards,
Markus





# 0.8.18 Release

- guid: 190576e0-9fef-486e-b8da-c4e75be08329
- author: Markus Raab
- pubDate: Fri, 16 Sep 2016 23:31:27 +0200
- shortDesc: adds intercept open, crypto plugins & improved git-resolver

## What is Elektra?

Elektra serves as a universal and secure framework to access configuration
parameters in a global, hierarchical key database.
For a small demo see here:

[![asciicast](https://asciinema.org/a/cantr04assr4jkv8v34uz9b8r.png)](https://asciinema.org/a/cantr04assr4jkv8v34uz9b8r)

## Highlights

- Intercept open syscalls which allows Elektra to dynamically
  generate config files from Elektra’s database
- Experimental version of cryptographic plugins
- A new zsh completion file (next to the bash completion file)
- Gitresolver allows to directly read and write config files
  from git instead of files present in the file system.
- Survey completed successfully (and debts paid), we are now
  preparing raw data.

### Crypto Plugin

Gpg is now used to decrypt a master password, which is used
by the individual crypto backends. So all necessary parts
for encryption of decryption of individual keys is present.

Furthermore, a new [botan](https://botan.randombit.net) backend
was implemented.

[See here](https://git.libelektra.org/tree/master/src/plugins/crypto)

Thanks to Peter Nirschl.

### Open Interception

When Elektra directly modifies config files which are on the disc,
and applications read the config files without Elektra, Elektra has
no control over the access, e.g. we cannot dynamically calculate
values. To avoid this, we wrote a library that
intercepts the `open`-call.

Together with the `mozprefs` plugin, we got control over the configuration
of Firefox and can dynamically change config values with all possibilities
Elektra provides.

For easy setup, we implemented the script `configure-firefox`.

[See here](https://git.libelektra.org/tree/master/src/bindings/intercept)

Thanks to Thomas Waser.

### Resolver

Resolvers in Elektra are the code that are responsible to determine where
content should be read from and stored to. They are independent of the
actual configuration file syntax.

The [gitresolver](https://git.libelektra.org/tree/master/src/plugins/gitresolver)
allows you to get/store config data in git.

The [blockresolver](https://git.libelektra.org/tree/master/src/plugins/blockresolver)
allows Elektra to take control of parts of the configuration
file. This is useful for config files such as vim or zsh, which contain
program code. The plugin allows you to split config files with special markers
into parts containing code and others controlled by Elektra.

### zsh completion

Added zsh completion file, and a script (`kdb install-sh-completion`)
that installs bash+zsh completion when the default installation places
do not work (e.g. for macOS).

Thanks to Sebastian Bachmann.

## Documentation

- fix `kdb-import` man page, thanks to Kurt Micheli
- mark `keyIsSystem`/`keyIsUser` as internal
- fix doxygen reference to example
- better document that `global-mount` or `gmount` will overwrite
  previously mounted global plugins
- fix spelling mistake, thanks to René Schwaiger
- Wrote tutorial how to use Elektra-python bindings,
  thanks to Ulrike Schäfer

## Quality

- shell recorder test cases now run during `make test`, thanks to Kurt
  Micheli and René Schwaiger (Warning: might remove present keys
  when it conflicts with their mountpoints)
- find-tools now is pep and pyflakes happy, thanks to Kurt Micheli
- fix bashism, thanks to Thomas Waser and Kurt Micheli
- better error message for conditionals plugin, thanks to Thomas Waser
- better error message for augeas plugin, thanks to Felix Berlakovich
- Many compilation warnings fixed, thanks to Gabriel Rauter, Thomas Waser
- GSettings: fix double free, thanks to Gabriel Rauter
- Fix external links and implement an external link checker,
  thanks to Kurt Micheli
- Fix openwrt/musl warnings with wrong printf format, thanks to
  Thomas Waser
- Fix NODEP metadata, allows you to build all plugins that do not
  have dependencies.

## Compatibility

As always, the ABI and API of kdb.h is fully compatible, i.e. programs
compiled against an older 0.8 version of Elektra will continue to work
(ABI) and you will be able to recompile programs without errors (API).

### Libtools

Libtools got a new major version (SOVERSION 0 -> 1):

- backend/plugin configs are now validated by plugins (needed
  by gpg plugin, which checks if wrong key IDs are supplied during mount)
- resolveRecommends was never implemented and was now removed

### Plugins

The plugins conditionals and mathcheck are incompatible in some cases
because of changes in syntax.

### Proposal

New API: `keyRel2` which differs from `keyRel` by allowing you to
specify which relation should be checked.

## Development

- github descriptions+workflow (displayed by github when creating
  PRs and issues)
- new trigger phases for github, see
  [doc/GIT](https://git.libelektra.org/tree/master/doc/GIT.md)
  thanks to Mihael Pranjić
- valgrind suppressions are great again, thanks to Peter Nirschl
- Plugins get a new namespace `internal` which can be used for meta-data
  that is not relevant for other plugins.
- kdberrors.h is only generated once, which allows us to use other build
  systems, thanks to René Schwaiger
- `INCLUDE_SYSTEM_DIRECTORIES` in add_plugin allows you to add a include
  path where warnings are suppressed (useful for boost).
- `infos/provides` now allows multiple entries

## Packaging

- Plugin-provider `CRYPTO` can be used to enable/disable all crypto
  plugin variants (not enabled by default because its experimental).
- Config option `ENABLE_OPTIMIZATIONS`, enable by default: trade more
  memory for speed (can be turned off on embedded systems)
- `INSTALL_SYSTEM_FILES` is now off by default on macOS.
- bash-completion is installed to where pkg-config tells us,
  thanks to Gabriel Rauter
  (fallback is now `/usr/share/bash-completion/completions/kdb`)
  was `/etc/bash_completion.d/kdb` (removed)
- zsh is now installed to `/usr/share/zsh/vendor-completions/_kdb`
  (except for Darwin, where `/usr/local/share/zsh/site-functions` is used)
- removed `/etc/profile.d/kdb.sh`: the script `elektraenv.sh` was
  removed (and is no longer installed), superseded by `elektrify-getenv`
- added scripts install-sh-completion configure-firefox elektrify-open
- added plugins libelektra-blockresolver.so  libelektra-boolean.so
  libelektra-crypto_botan.so libelektra-crypto_openssl.so
  libelektra-desktop.so libelektra-mozprefs.so libelektra-passwd.so
- added tests testmod_blockresolver testmod_boolean
  testmod_crypto_botan testmod_crypto
  gcrypt testmod_crypto_openssl testmod_mozprefs testmod_passwd
  test_opmphm_vheap test_opmphm_vstack
- added test data blockresolver mozprefs passwd

## Other

- Conditionals and mathcheck plugins got support to specify relative
  keys, thanks to Thomas Waser
- `kdb` command-list: commands are written in bold
- GSettings backend can be build standalone, thanks to Gabriel Rauter
- first data structures for order preserving minimal perfect hash map,
  thanks to Kurt Micheli
- added a new passwd plugin, thanks to Thomas Waser
- [boolean](https://git.libelektra.org/tree/master/src/plugins/boolean)
  plugin to normalize boolean values, thanks to Thomas Waser
- [desktop](https://git.libelektra.org/tree/master/src/plugins/desktop)
  plugin to detect which desktop currently is running (supports kde,
  gnome, tde, unity or any other XDG conformant desktop)
- `doc/paper` contains some info for [joss](https://github.com/openjournals/joss)

## Get It!

You can download the release from
[here](https://www.libelektra.org/ftp/elektra/releases/elektra-0.8.18.tar.gz)
and also [here on github](https://github.com/ElektraInitiative/ftp/tree/master/releases/elektra-0.8.18.tar.gz)

- name: elektra-0.8.18.tar.gz
- size: 2582183
- md5sum: 62fe0fbf9ee57ffaa58a982f602f596a
- sha1: 743484e16b102a00cd58956a49f0c558939d56a8
- sha256: 9ee65895ba5cba6736c13c264637664c1410b25f4aaaeac8f1f83712ff93d53b

This release tarball now is also available
[signed by me using gpg](https://www.libelektra.org/ftp/elektra/releases/elektra-0.8.18.tar.gz.gpg)

already built API-Docu can be found [here](https://doc.libelektra.org/api/0.8.18/html/)

## Stay tuned!

Subscribe to the
[RSS feed](https://doc.libelektra.org/news/feed.rss)
to always get the release notifications.

For any questions and comments, please contact the
[Mailing List](https://lists.sourceforge.net/lists/listinfo/registry-list)
the issue tracker [on github](https://git.libelektra.org/issues)
or by email elektra@markus-raab.org.

[Permalink to this NEWS entry](https://doc.libelektra.org/news/190576e0-9fef-486e-b8da-c4e75be08329.html)

For more information, see [https://libelektra.org](https://libelektra.org)

Best regards,
Markus





# 0.8.19 Release

- guid: 8e05231a-4f3d-488b-8dc2-5f0d5c474c39
- author: Markus Raab
- pubDate: Tue, 22 Nov 2016 22:04:59 +0100
- shortDesc: adds more tutorials, ruby bindings & cleanup of core

## What is Elektra?

Elektra solves a non-trivial issue: how to abstract configuration
in a way that software can be integrated and reconfiguration can
be automated.  Elektra solves this problem in a holistic way.
Read [why Elektra](https://master.libelektra.org/doc/WHY.md)
for an explanation of why such a solution is necessary. It can be seen as a
[virtual file system](https://master.libelektra.org/doc/BIGPICTURE.md)
for configuration files.

## Highlights

- more tutorials and getting started guides
- new Ruby bindings
- cleanup of core (only 124K for main library on Debian/amd64)

### More Tutorials

Elektra already has an open and welcoming environment, with many
interesting discussions.  It is our interest that we keep it
that way.  To make this a bit more formal we added a [code of
conduct](https://master.libelektra.org/CODE_OF_CONDUCT.md).

But without good introductions, it is easy to get lost in such
a large initiative like Elektra. Thus we focused on writing
great tutorials for this release!

- We wrote an [overview readme](https://master.libelektra.org/doc/tutorials/README.md)
- We wrote new tutorials about [mounting](https://master.libelektra.org/doc/tutorials/mount.md)
  and [validation](https://master.libelektra.org/doc/tutorials/validation.md)
  (thanks to Christoph Weber)
- We wrote a readme to shell recorder transpiler
  which allows us to execute tutorials and verify that the examples in
  them work. (thanks to Thomas Waser)
- [Lua](https://master.libelektra.org/src/plugins/lua) and
  [Python](https://master.libelektra.org/src/plugins/python)
  plugins got tutorials and better explanations!
  (Thanks to Marvin Mall)
- The [doxygen](https://doc.libelektra.org/api/0.8.19/html/) docu now also
  uses links to directories, thanks to Kurt Micheli!

Thanks to Armin Wurzinger for pointing to areas of improvement.
A big thanks to Marvin Mall, Kurt Micheli, Christoph Weber and Thomas Waser!

If you like the tutorials, we would love to read from you.
Please feel free to [start a discussion or ask a
question](https://git.libelektra.org/issues/new).
We also added a
[FAQ](https://master.libelektra.org/doc/help/elektra-faq.md)
and updated
[CONTRIBUTING](https://master.libelektra.org/.github/CONTRIBUTING.md)

### Ruby Bindings

We now provide Ruby bindings for Elektra. The bindings are based on the
C++ bindings and are generated by SWIG. A strong focus was put on a good
integration with standard Ruby features and conventions, such as naming
conventions, predicates, key and meta data iteration...

A [short introduction](https://master.libelektra.org/src/bindings/swig/ruby/README.md)
shows some basic usage scenarios.  More detailed examples can be found in the
[examples directory](https://master.libelektra.org/src/bindings/swig/ruby/examples).

A big thanks to Bernhard Denner!

### Cleanup of Core

Following methods were hidden (`static`) or removed:

- `mount*` methods
- `trie*` methods
- `backend*`
- `split*`
- `keyGetParentNameSize`
- `keyGetParentName`

These are dozens of methods and it was required to adapt
the unit tests to work with the hidden methods.

A big thanks to Kurt Micheli!

## Usability

- Improved many error messages
 - spelling
 - be more friendly to the user
 - capitalization
 - mention `sudo !!`
- `kdb set`: do not print what was not done
- `kdb editor` handles non-modified files (will not do anything)
- Be more chatty about what `kdb` does, can be disabled with `-q` or
  `/sw/elektra/kdb/#0/current/quiet`.
- Furthermore, `-v` now tells even more details (e.g. `kdb-import` outputs
  the key about to import)

## Plugins

### New

- [c plugin](https://master.libelektra.org/src/plugins/c) generates C code that represents
  configuration. This is useful for unit tests or if you need to have hard-coded
  fallback configuration in your C application.
- [base64 plugin](https://master.libelektra.org/src/plugins/base64) allows you to encode
  binary data. This is especially handy in combination with the
  [crypto plugin](https://master.libelektra.org/src/plugins/crypto)
  to avoid problems with non-printable characters in configuration files.
  (Thanks to Peter Nirschl)
- [fcrypt plugin](https://master.libelektra.org/src/plugins/fcrypt) allows you to
  fully encrypt configuration files. They are only decrypted when applications
  access them. (Thanks to Peter Nirschl)
- [required plugin](https://master.libelektra.org/src/plugins/required) rejects
  every key that is not required by an application.
- [simple spec lang](https://master.libelektra.org/src/plugins/simplespeclang) allows you
  to define metadata for [enum](https://master.libelektra.org/src/plugins/enum)
  and required in a more compact way.

### Major Enhancements

- [simpleini](https://master.libelektra.org/src/plugins/simpleini) got a configurable
  format in which it will read and write configuration files. For example, one
  can use `format=% -> %` to have `key -> value`.
- [enum](https://master.libelektra.org/src/plugins/enum) got support for multi-enums,
  i.e., multiple separated values within one value. The error reporting was improved,
  too. (Thanks to Thomas Waser)
- [glob](https://master.libelektra.org/src/plugins/glob) accepts a list of named flags
  instead of an integer value and aborts matching after first hit.
  (Thanks to Felix Berlakovich)
- [hosts](https://master.libelektra.org/src/plugins/hosts) now only accepts `ipv4` and
  `ipv6` keys.
  (Thanks to Felix Berlakovich)

## Development

In the perpetual effort to improve software quality, we made several improvements:
(This information is mainly intended for Elektra’s developers.)

- A new logger encourages developers to write more comments (`ELEKTRA_LOG`)
- `ELEKTRA_ASSERT` prints better messages on failure and does not need `&&` trick.
- get rid of previous `VERBOSE` macro at many places.
- Many assertions were added in the low-level helpers (memory management)
- Using the assertions we fixed some undefined behavior.
  (Thanks to Thomas Waser)
- added new `configure-debian-debug` and `configure-debian-log` helper scripts
- The build server now checks if builds with active logger and debugging
  work correctly.
- Improved Coding Style in crypto_botan (thanks to Peter Nirschl)
- add `external-links.txt` to `outputs`
  (The file is generated in the build directory and contains
   all external-links. To validate them, use `./scripts/link-checker`)
  (Thanks to Kurt Micheli)
- `markdownlinkconverter` handles directories correctly (using `stat`).
  (Thanks to Kurt Micheli)
- Fixed compiler warning caused by libxml2 (different behavior since 2.9.4),
  thanks to René Schwaiger
- added often used links in [main README](https://master.libelektra.org/README.md)
- Improve documentation about failing test cases and what to do about it.
- added [decisions](https://master.libelektra.org/doc/decisions/) about `plugin_variants`
  and `array`.
  (Thanks to Marvin Mall)
- Rename to metadata, metakey, mountpoint
  (Thanks to Peter Nirschl)
- std::ios_base::showbase can be used to output metadata when streaming keys (C++)
- New `infos/status`: `readonly`, `writeonly`, `limited`
  (Thanks to Marvin Mall)
- The tool `update-infos-status` orders `infos/status` and allows devs to easily add/rem
  entries.  (Thanks to Kurt Micheli)
- Automatic setting of `infos/status`: `nodoc`, `nodep`, `unittest`, `memleak`, `configurable`
  (Thanks to Kurt Micheli)
- Improve `create_lib_symlink`, add `PLUGIN` argument
  and make it useful also for other library symlinks.
- New markdown style applied to most markdown files.
  (Thanks to Marvin Mall)
- Tracer is now disabled, even for `ENABLE_DEBUG`.
  (Thanks to Marvin Mall)
- Updated [SECURITY document](https://master.libelektra.org/doc/SECURITY.md)
- Macro naming convention `ELEKTRA_`, added `kdbmacros.h`
- `ENABLE_DEBUG` also works with `clang` and `ENABLE_ASAN` now allows devs
  to additionally enable sanitizers.
  Thanks to Gabriel Rauter.

## Compatibility

As always, the ABI and API of kdb.h is fully compatible, i.e. programs
compiled against an older 0.8 version of Elektra will continue to work
(ABI) and you will be able to recompile programs without errors (API).

It is now possible to enquiry which plugins provide a specific format.
This needed changes in libtools, which got a new major revision.
Changes in the plugin's contract are fully compatible:
You can now use `storage/ini` instead of `storage ini` in `infos/provides`
which gives you the information that `ini` is a storage format (and not
anything else the plugin might provide). For compatibility reasons,
the build system still adds `storage ini` even if only `storage/ini`
is specified.

That means that `kdb mount file.json /examples/json json` still will find
`json` plugins even if they are not called `json` but
[yajl](https://master.libelektra.org/src/plugins/yajl).

Another breaking change in `libtools` is that `appendNamespace` was renamed
to `prependNamespace`.

Error messages changed a bit, so if you tried to parse them, make sure
to make the `e` of error case-insensitive (`[eE]`).

In the C++ binding, `rewindMeta` is now `const` and some methods
to check if a key is in a namespace were added.

The intercept libraries were moved to a [common
folder](https://master.libelektra.org/src/bindings/intercept).
They can now be included or excluded like other `BINDINGS`.
For consistency reasons the libraries were also renamed
(`libelektraintercept-fs.so` and `libelektraintercept-env.so.0`),
but symlinks allow you to link against their old names
(`lib/libelektraintercept.so` and `lib/libelektragetenv.so.0`).

## Package Maintainers

This information is intended for package maintainers.

- GI Bindings were removed from `BINDINGS=ALL`.
  It is recommended to use `SWIG` bindings instead, which
  will be added with `ALL`.
- Intercept libraries are part of `BINDINGS`.
  They will be added on glibc systems where `BINDINGS=ALL` is used.
- Documentation in textfiles is now installed,
  `TARGET_DOCUMENTATION_TEXT_FOLDER` was added for that purpose.
  The files are:
  - `BIGPICTURE.md`, `GOALS.md`, `LICENSE.md`, `METADATA.ini`, `SECURITY.md`, `AUTHORS`, `CONTRACT.ini`, `NEWS.md`, and `WHY.md`

Other new files are:

- Plugins: `libelektra-base64.so`, `libelektra-c.so`, `libelektra-fcrypt.so`
           `libelektra-required.so`, `libelektra-simplespeclang.so`
  (only in `EXPERIMENTAL`, not added by default, but with `ALL`)
- `site_ruby/_kdb.so` (ruby binding, only in `ALL`)
- `testcpp_keyio`, `testkdb_error`, `testmod_base64`,
  `testmod_fcrypt` (test binaries in `TARGET_TOOL_EXEC_FOLDER`)

Changed files are:

- `libelektraintercept-env.so` (renamed from `libelektragetenv.so.`, but still available as symlink)
- `libelektraintercept-fs.so` (renamed from `libelektraintercept.so`, but still available as symlink)
- version upgrade: `libelektratools.so.2`

## Portability

Elektra should work on every system that has `cmake` and a `C/C++` compiler.

For this release we increased portability to better work with macOS,
CentOS 7, and OpenSuse 42.

- macOS:
 - Travis build server now also build qt-gui
 - Support for xcode8 added (xcode6 still supported)
- fix lua != 5.2 issues (wrong output), update docu
- remove hard dependency to `pkg-config`
- remove hard dependency to version 3 of `cmake`
  (most parts still work with version 2)
- make search for swig 2 visible
- fix plugin names and mounting on OpenSuse 42.1

A big thanks to Kai-Uwe Behrmann, Mihael Pranjić and
Sebastian Bachmann.

## Fixed Issues

- simpleini: use correct error number when open file fails
- yajl: improve error message on non-utf8 text.
  (Thanks to Christoph Weber)
- drop multiple `/` from `~` paths
  (Thanks to Thomas Waser)
- fix failing testcases with `ENABLE_DEBUG` #988
  (Thanks to Thomas Waser)
- csvstorage: files in source are rewritten  #987
  (Thanks to Thomas Waser)
- fix RTLD_NODELETE for OpenBSD
  (Thanks to Thomas Waser)
- better handle adding/deleting of read-only (info) plugins.
- fix behavior of multiple plugins setting errors (first error wins,
  later errors are transformed to warnings)
  (Thanks to Thomas Waser)
- fix resolver logic for missing files
- regex string in conditionals
  (Thanks to Thomas Waser)
- use `KDB` environment variable in shell tests and fix counting of tests
  for `kdb run_all`.
- output to `stderr` for `elektrify-*` scripts
- make [desktop plugin](https://master.libelektra.org/src/plugins/desktop)
  mountable
- avoid cmake warnings in `make uninstall` (avoid `@`)
- fix quoting in ini plugin
  (Thanks to Thomas Waser)
- fix plugin names and mounting with plugin pre/postfixes
  (Thanks to Kai-Uwe Behrmann)
- mount-openicc: rename to openicc.json
  (Thanks to Kai-Uwe Behrmann)

## Get It!

You can download the release from
[here](https://www.libelektra.org/ftp/elektra/releases/elektra-0.8.19.tar.gz)
and also [here on github](https://github.com/ElektraInitiative/ftp/tree/master/releases/elektra-0.8.19.tar.gz)

- name: elektra-0.8.19.tar.gz
- size: 2681639
- md5sum: 6669e765c834e259fb7570f126b85d7e
- sha1: 82cefe4cea58d6e6b0a99ddbda24d1b57e98d93a
- sha256: cc14f09539aa95623e884f28e8be7bd67c37550d25e08288108a54fd294fd2a8

This release tarball now is also available
[signed by me using gpg](https://www.libelektra.org/ftp/elektra/releases/elektra-0.8.19.tar.gz.gpg)

already built API-Docu can be found [here](https://doc.libelektra.org/api/0.8.19/html/)

## Stay tuned!

Subscribe to the
[RSS feed](https://doc.libelektra.org/news/feed.rss)
to always get the release notifications.

For any questions and comments, please contact the
[Mailing List](https://lists.sourceforge.net/lists/listinfo/registry-list)
the issue tracker [on github](https://git.libelektra.org/issues)
or by email elektra@markus-raab.org.

[Permalink to this NEWS entry](https://doc.libelektra.org/news/8e05231a-4f3d-488b-8dc2-5f0d5c474c39.html)

For more information, see [https://libelektra.org](https://libelektra.org)

Best regards,
Markus





# Website Release

- guid: 102b84a3-c41e-485c-8fe2-f12a24b3fbfd
- author: Marvin Mall
- pubDate: Thu, 22 Dec 2016 17:46:19 +0100
- shortDesc: introduces new Elektra website with snippet sharing

## Highlight

1. Release of new Elektra website with an integrated service for
   sharing of configuration snippets.
2. The website also supports conversion between different
   configuration formats.
3. Website structures documentation and news sections in a new way.

## Introduction

With Elektra developing into a more and more reliable as well as
popular system to manage system configurations, the demand for a
better public appearance increases as well. For this reason, we
are happy to be able to announce the release of our new
[website](https://www.libelektra.org)!

The new website does not only give us a chance to better present
ourselves to the open world, it also enables us to structure our
project documentation better. We hope that this will make it easier
for our users to get started with Elektra and all of its awesome
features!

Besides the documentation, the website does also include a database
that can be used to share, search, download and convert configuration
snippets in various formats. We hope that this tool helps developers
and administrators, but also anyone else to simplify their
configuration processes when they have to look for a specific
configuration snippet. Btw. with snippet we mean that you can
also share parts of configuration files that you find particular
useful!

But sharing of snippets does not only help other users, it can help
yourself as well because you can search for them easier. You also
have access to the snippets in various formats at any time, allowing
you to use them across multiple system by mounting them with the
[curlget](https://master.libelektra.org/src/plugins/curlget) resolver!

## The Website

The website was written by Marvin Mall in the course of his
[bachelor thesis](https://www.libelektra.org/ftp/elektra/mall2016rest.pdf)
as part of the front-end he developed for his snippet sharing service.
His main goals were to create a proper appearance for Elektra, but
also to create a platform that promotes his service. We think that
this worked out quite well by connecting the website with the service
the way it was done.

### Documentation

An important aspect of the new website was to make existing documentation
more transparent and structured. A lot of documentation files have been
changed to achieve this goal and an equal amount of effort was put into
writing a system that decouples the documentation structure on the
website from the structure used within the Elektra repository.

The tutorials section was partially reworked to make the first steps
together with Elektra easier for our users. Clearly the effort put into
the tutorials is worth it. Thanks to Erik Schnetter for the valuable
feedback where improvements are needed and Christoph Weber for (re)writing
the tutorials!

We should note -- as always in software -- that the structure on the website
is not final yet and will definitely develop over time, especially the
bindings and libraries sections will get some more attention.

If you are interested in the techniques we use to structure our files,
you can have a look at the
[rest-frontend readme](https://blob.libelektra.org/src/tools/rest-frontend/README.md).
The website is already the fourth view of our markdown pages!
The others are man pages, doxygen, and github.

### Homepage & News

Besides the documentation we also wanted a place to properly present
ourselves and our news around Elektra. For this reason we created a new
home page which shall give an overview of what Elektra is and can do.
Additionally to that, we also added a news section to keep you better
up-to-date!

We hope that you enjoy our new appearance as much as we do!

### Snippet Sharing

Another important part of the website and also without doubt the part
that took most effort to create, is the service that allows for sharing
of configuration snippets. It is run by a REST service fully built with
the help of [CppCMS](http://cppcms.com/) on basis of Elektra as
data store. All data concerning snippets and user accounts is stored
in Elektra’s key database (of course with password being properly hashed).

The service allows you to paste configuration snippets in various (supported)
formats and to tag, describe and name them. This in return allows you to
search snippets by keywords and to download them -- even in other formats than
the format used for uploading.

Clearly the service is meant to be driven by its users. Therefore we ask
you to share your own configuration snippets, maybe they can be of help, e.g.,
be a time saver for someone else!

Snippets shared with the service are
[BSD licensed](https://www.libelektra.org/devgettingstarted/license).
The snippets can also be downloaded directly as bundle from a separate
[GitHub repository](https://github.com/ElektraInitiative/snippets).
As soon as a snippet is added, changed or deleted on the website, a job
that updates the repository is triggered. So you can expect the repository
to be always up-to-date.

### NoScript

The website is fully written with the help of AngularJS and is therefore
heavily based on JavaScript. This should be no issue though as the
website does only use resources that can be found in the official Elektra
repository:

1. So in case you cannot or do not want to use JavaScript, you
   can find all resources also [here](https://git.libelektra.org).
2. If you are only worried about executed untrusted JavaScript,
   you can study and improve the
   [Web Frontend](https://blob.libelektra.org/src/tools/rest-frontend/README.md),
   which builds the website.
   Based on this, we hope you disable `NoScript` for our page
   so that you are able to share snippets!

## Domains

All Elektra Domains directly hosted by us are now only served by `https`.
The former `http` sites are only redirects to `https`. This might cause
trouble with some software, e.g., update `/etc/apt/sources.list`:

    deb     [trusted=yes] https://build.libelektra.org/debian/ wheezy main
    deb-src [trusted=yes] https://build.libelektra.org/debian/ wheezy main

The build Server is no longer reachable at port 8080, but now only directly at
[https://build.libelektra.org/](https://build.libelektra.org/).

The new [RestApi](https://restapi.libelektra.org) serves as backend
for the website. For the docu, simply visit the site with your browser.

While most `libelektra.org` now point to the new website, you can still
directly go to [github](https://git.libelektra.org) and also to the
[bug tracker](https://bugs.libelektra.org).

The old Wordpress installation was shut down because of security concerns.

## Feedback

At this point there is not much more to say about the new website except for:
Feel free to explore it!

We greatly appreciate all feedback, be it for the website, the snippet sharing
service or other parts of the Elektra project. We always have an open ear
for suggestions and we also like to help with technical issues, simply
[leave us a note on github](https://bugs.libelektra.org)!

## Stay tuned!

Subscribe to the reimplemented
[RSS feed](https://www.libelektra.org/news/feed.rss)
to always get the release notifications.

For any questions and comments, please contact the
[mailing list](https://lists.sourceforge.net/lists/listinfo/registry-list),
use the issue tracker [on github](https://bugs.libelektra.org)
or write an email to elektra@markus-raab.org.
For issues or feedback concerning the website, you can also
contact us at website@libelektra.org.

[Permalink to this NEWS entry](https://www.libelektra.org/news/website-release)

For more information, see [https://libelektra.org](https://libelektra.org)

Best regards,
Marvin & Markus





# Elektrify LCDproc

- guid: d52657b5-60da-4a21-9679-f8aacf6d6b72
- author: Markus Raab
- pubDate: Sat, 18 Mar 2017 20:43:03 +0100
- shortDesc: Elektrify LCDproc


> LCDproc is a piece of open source software that displays real-time
> system information from your Linux/*BSD box on a LCD.

LCDproc's [website](http://lcdproc.omnipotent.net/) is a bit outdated
but LCDproc itself is now well-maintained on
[GitHub](https://github.com/lcdproc/lcdproc) and had a
[release recently](https://github.com/lcdproc/lcdproc/releases).

Like in many projects, it invented its own configuration access and
INI parser which did not evolve with the needs of the project.  As a
consequence inconsistencies and code duplication spread over the source.
For example, the LCDproc configuration access does not support values
that represent display's size (such as `20x4`).  Thus every LCDproc's
module has its own parsing code for such values.

Some days ago (16.03.2017), we met with Harald Geyer and discussed the
current situation.  We decided that we will elektrify LCDproc and remove
all the configuration access and parsing code within LCDproc.
To **elektrify** an application means to change the application so
that it uses LibElektra afterwards.


## Goals

We formulated three goals:

1. We (Elektra Initiative, mainly Thomas Waser) remove as much code
   as possible from LCDproc's code base.
2. Users of LCDproc should be able to use `LCDd.conf` as they use it now.
3. We avoid the current duplications of configuration specifications.
   (Currently in `LCDd.conf`, the docbook, in code checking the limits,
   and the default parameter in the code.)

Nice-to-have is:

- Safe updates: `make install` should not break the current `LCDd.conf`.
  (As it is already done in Debian.)
- The robustness of LCDproc on misconfiguration should be improved
  (Thomas Waser writes the specification).
- Automatic reloading of the daemon when using Elektra to update configuration.
  (Manual `SIGHUP`-signals will work in any case.)
- Have physical units with metric prefix like `500ms` for `0.5s` (seconds).

Possible limitations are:

- We break support for systems that only have very old compilers.
- The `-c` option to specify a different configuration file is
  against the abstraction Elektra should deliver.  We might create a
  [wrapper script](https://github.com/ElektraInitiative/libelektra/issues/1416)
  that emulates `-c` via mountpoints.
- LCDproc will depend on the yet-to-be-released
  [0.8.20](https://github.com/ElektraInitiative/libelektra/milestone/11).
  We will delay the 0.8.20 release until all parts for LCDproc are tested and ready.

In any case, the [advertised benefits of Elektra](https://www.libelektra.org)
will automatically apply (incomplete list):

- Global key database: you can connect other configuration files with the
  LCDproc's configuration and validation.
- Allows users to easily modify the specifications, for example to have different
  command-line options, or support for environment variables.
- [Profile support](https://www.libelektra.org/plugins/profile): Having multiple
  complete configuration settings you can easily choose from. (thanks to Thomas Waser)
- Introspectibility: you can check with `kdb`-tool which configuration
  settings LCDproc will receive.
- Other configuration file formats can be used instead, e.g. JSON or XML.
  (Only if wanted as personal preference, by default INI will be used to
   remain compatibility with `LCDd.conf`.)
- Easy migration paths to use other configuration file formats such as YAML
  as default in future. (thanks to René Schwaiger)
- Elektra's tool can be used to configure LCDconf, including:
 - `kdb set` to modify individual settings within scripts and validation.
 - `kdb editor`, which spawns your favourite editor but validates
   the configuration file before writing it out.
 - `kdb qt-gui`, the Qt GUI (thanks to Raffael Pancheri).
 - The web UI of Elektra (thanks to Daniel Bugl).
- Elektra's website can be used to share LCDproc's configuration files,
  and you can use the [curlget plugin](https://www.libelektra.org/plugins/curlget)
  to mount files from the website. (thanks to Marvin Mall)
- You can use Shell, Python, or Lua to write small scripts that are executed on
  configuration access.
- Elektra allows you to directly read and write from git
  using the [git plugin](https://www.libelektra.org/plugins/gitresolver).
  (Even if `LCDd.conf` is not checked out, thanks to Thomas Waser)
- We extensively [test](https://www.libelektra.org/devgettingstarted/testing)
  Elektra with modern techniques such as fuzzing.


## Validation

Instead of `if`s within the code, we will use SpecElektra for validation.
[SpecElektra](https://www.libelektra.org/manpages/elektra-glossary)
is a configuration specification language that allows us to describe
which configuration is valid.

This specification will be installed as part of LCDproc to
`/usr/share/elektra/specifications`.
It uses the [metadata](https://www.libelektra.org/docgettingstarted/metadata)
as defined by the plugins to validate configuration changed via
Elektra.

For broken installations or when executing LCDproc from the source
repository, there is also a built-in specification.  The specification
will only be used if the installed one cannot be found.

Thus the configuration validation specification is a normal configuration
file also integrated in Elektra, also the specification can be introspected:
useful for system administrators who want to know about valid entries, but
also for tools like our newly developed web-UI by Daniel Bugl.

The web-UI automatically restricts the interface so that only valid
entries can be entered.  For example, if you should enter a boolean,
only a check box is presented to you.

- For more information about validation, see the [tutorial](https://www.libelektra.org/tutorials/validate-configuration)


## Code Generation

We (mainly Dominik Hofer) are currently developing
[a high-level API](https://www.libelektra.org/decisions/high-level-api),
whose first user will be LCDproc.  In this API, we will make sure during
compilation, that configuration access is done correctly.

This is especially useful when configuration settings get renamed.
Then all places where out-dated configuration settings are used will fail to compile.

In particular using code generation developers do not need to use strings
to refer to configuration settings and they get easy-to-use enums consistent
with the configuration specification.

Furthermore, code generation will make sure that a specification (and default configuration settings)
will be found even if no `/etc` or no `/usr` is found.

We also found that we cannot use code generation everywhere.
In generic access code, code generation obviously is limited.

- For more information about code generation, see the [tutorial](https://www.libelektra.org/tools/gen)


## Risks

Understandably, users might be concerned that such a change will not work or create
problems in the future. Here we will discuss some of the concerns.

> Elektra might be discontinued.

From history perspective, Elektra received steady development since 2004.
Elektra is a FLOSS project and welcomes everyone to join. In the last
years several people did, with an increasing number per year.
Currently following people are working on substantial new features in Elektra
(sorted by first name):

- Armin Wurzinger: Quality Improvements
- Bernhard Denner: [Puppet Module](https://github.com/ElektraInitiative/puppet-libelektra)
- Daniel Bugl: [WebUI](https://www.libelektra.org/tools/web)
- Dominik Hofer: [the high-level API](https://www.libelektra.org/decisions/high-level-api)
- Kurt Micheli: Order Preserving Minimal Hash Map
- Markus Raab: Maintainer
- Michael Zehender: Quality Improvements
- Mihael Pranjić: mmap plugin
- Peter Nirschl: [crypto plugin](https://www.libelektra.org/plugins/crypto)
- René Schwaiger: YAML plugin
- Sebastian Bachmann: Shell Completion
- Thomas Waht: Notification
- Thomas Waser: Validation and Transformations of Configuration
- Vanessa Kos: Misconfiguration Bug Database

Obviously, there are many more casual contributors.

Elektra has a large set of [automated tests](https://build.libelektra.org)
and only a small amount of technical dept. Elektra has no required external
dependencies except libc. So without internal changes, only minimal maintenance
cost is required.


> Elektra is unfinished.

Technically this is true: we did not reach
[1.0](https://git.libelektra.org/milestone/12).
We are, however, on track to reach this goal within this summer.
Now is the best time to join because we can provide more support
and are more flexible for changes and wishes.

Some [time ago](https://www.libelektra.org/news/2016-06-14_0.8.17.md) we asked in a survey in
which direction Elektra should develop. Most open issues are (in)direct
responses from this wanted direction.

Some plugins are experimental or proof-of-concept, but they are clearly
marked as such.


> It seems a bit to me like [xkcd: Standards](https://xkcd.com/927/).

Elektra does not invent a new configuration file format nor new standards
where to store configuration files but abstracts over these issues.


> Elektra not being available in my distribution.

For the following Linux Distributions Elektra 0.8 packages are available:

 - [Openwrt](https://github.com/openwrt/packages/tree/master/libs/elektra) (by Harald Geyer)
 - [Fedora](https://admin.fedoraproject.org/pkgdb/package/elektra/)
 - [Gentoo](http://packages.gentoo.org/package/app-admin/elektra)
 - [Arch Linux](https://aur.archlinux.org/packages/elektra/)
 - [Debian](https://packages.debian.org/de/jessie/libelektra4)
 - [Ubuntu](https://launchpad.net/ubuntu/+source/elektra)
 - [OpenSuse](https://software.opensuse.org/package/elektra)
 - PLDLinux
 - [LEDE](https://lede-project.org/packages/pkgdata/libelektra-core?s[]=elektra)
 - [Linux Mint](https://community.linuxmint.com/software/view/elektra-bin)

See [INSTALL](https://www.libelektra.org/docgettingstarted/installation)
for the complete and up-to-date list.


> If Elektra does not take off and achieve world dominance,
> will we be worse off than before?

Making sure that projects will not be worse off is what we did the last
years: Not only offer an API and wait for world dominance but to offer
an implementation that can compete with any configuration library out
there. We are not completely there yet (there are some details where
specific other libraries are better than Elektra in specific points)
but these are not points that the current configuration system of
LCDproc supports (not even close). And the libraries that can compete
with Elektra have a completely different level on which dependencies
they have: Elektra is the only one only requiring libc.

> Do we retain the old way of configuring things,
> i.e. manually editing a ini file in /etc?

Absolutely, you can think of libelektra as a small library in C that
reads a configuration file and returns a data structure if you do not
use any of its advanced features.

> Do we retain the old way reloading/restarting the system service?

Elektra does not interfere with restarting. It is a passive library.
It provides some techniques for reloading but they are optional (but we
recommend that you keep the in-memory and persistent configuration in
sync via notification).

For more information, see the [FAQ](https://www.libelektra.org/manpages/elektra-faq).


## Win-Win

We can both profit from it:

1. For LCDproc it will be a simplification of code while getting many more tools.
2. For Elektra it will improve its adoption and packaging.

For oyranos it already worked well on both sides, see our discussions in the issue tracker, for example [#1134](https://issues.libelektra.org/1134).

If you also maintain an free or open source (FLOSS) project with an out-dated configuration system, please contact us.

Obviously, we cannot fully port every FLOSS project ourselves, instead we will handle requests on a first come, first serve basis.
Earlier projects will also have an higher impact on the feature set of Elektra, thus you will less likely need to implement your own plugin.


## See also

- Progress can be viewed [here](https://git.libelektra.org/projects/7)
- We discussed about alternatives to Elektra [here](https://issues.libelektra.org/1266).

Best regards,
Markus





# 0.8.20 Release

- guid: 547d48e2-c044-4a8e-9d32-ca6b6fb914d9
- author: Markus Raab
- pubDate: Thu, 31 Oct 2017 23:08:07 +0200
- shortDesc: New Website, puppet-libelektra, New Plugins


## What is Elektra?

Elektra serves as a universal and secure framework to access
configuration settings in a global, hierarchical key database.
For more information, visit [https://libelektra.org](https://libelektra.org).

## Highlights

This is by far the largest release in Elektra's history.
In 2813 commits, 19 authors changed 1714 files with 92462
insertions(+) and 21532 deletions(-).  The highlights are:

- libelektra.org: new website and puppet-libelektra
- plugin+bindings for Haskell and Ruby
- improved shell completion
- new plugins: yamlcpp, camel, mini, date, file, range,
  multifile, xerces, ipaddr

### libelektra.org

Unfortunately this release was delayed. The reason for the delay is that our
community server ([build server](https://build.libelektra.org), web site,...)
was compromised and we needed to reinstall everything from scratch.

We took advantage of the situation, and reinstalled everything properly
managed by [puppet-libelektra](https://github.com/ElektraInitiative/puppet-libelektra).
With puppet-libelektra, you can directly set keys, specifications (validations),
and even mount new configuration files from within Puppet.

Our community server is now completely managed by libelektra.

Thanks to Bernhard Denner, for rescuing us from the difficult situation, especially
for the sprint shortly before the release.


As already already announced in [December 2016](https://master.libelektra.org/doc/news/2016-12-17_website_release.md)
we completely reimplemented our website. Now all our websites are available via https.
This release is the first one that includes the source code of the website and its
snippet sharing functionality.

The backend for this snippet sharing website uses Elektra itself: both for its
configuration and for the configuration snippets.

Thanks again to Marvin Mall for the awesome website.

#### Haskell and Ruby

The Ruby binding, created by Bernhard Denner, was greatly improved and now
includes libtools bindings. It is the first binding that goes beyond Elektra's
main API. Bernhard Denner also added many
[examples](https://master.libelektra.org/src/bindings/swig/ruby/examples) that
demonstrate how you can take advantage of the Ruby bindings.

Armin Wurzinger created a new [binding](https://master.libelektra.org/src/bindings/haskell)
for the functional language Haskell. He also added support for
[Haskell plugins](https://master.libelektra.org/src/plugins/haskell).
Due to generic CMake and C Code, plugins can be written
exclusively in Haskell, without any glue code. Several Haskell
[examples](https://master.libelektra.org/src/bindings/haskell/examples)
already exist. The Haskell support is currently experimental.

### Shell Completion

René Schwaiger added completion support for [Fish](http://fishshell.com)
in this release.  We also extended our support for other shells: The new
tool `kdb complete` suggests how to complete an Elektra path. It considers
mountpoints and also takes bookmarks into account.  Thanks to Armin
Wurzinger for creating this useful utility. Our Zsh and fish completions
already take advantage of `kdb complete`. Thanks to Sebastian Bachmann
for taking the time to update the `zsh` completions.

### New Plugins

See [plugin overview](https://www.libelektra.org/plugins/)
to get an overview of the ever-growing number of plugins.

The [yamlcpp plugin](https://www.libelektra.org/plugins/yamlcpp)
and [camel plugin](https://www.libelektra.org/plugins/camel)
add first support for YAML.

The [mini plugin](https://www.libelektra.org/plugins/mini)
is yet another minimal INI plugin.

Thanks to René Schwaiger.

The [date plugin](https://www.libelektra.org/plugins/date)
supports validation of dates according to three standards:

* `RFC2822`
* `ISO8601`
* `POSIX`

The [multifile plugin](https://www.libelektra.org/plugins/multifile)
allows us to integrate many configuration files via globbing with
a single mount command. It supports `.d` configuration directories
as often used today.

The [file plugin](https://www.libelektra.org/plugins/file)
interprets the content of a file as configuration value.

The [ipaddr plugin](https://www.libelektra.org/plugins/ipaddr)
adds support for IP address validation on systems that do not
support `getaddrinfo`.

Thanks to Thomas Waser for creating these useful plugins.

The [xerces plugin](https://www.libelektra.org/plugins/xerces)
supplants the [xmltool plugin](https://www.libelektra.org/plugins/xmltool)
and allows us to use XML files not following a specific schemata.
Attributes are mapped to Elektra's metadata, multiple keys with the
same names are mapped to arrays.

Thanks to Armin Wurzinger.


## Documentation

The documentation was greatly improved within this release.

- Added "Hello, Elektra" and logging tutorial,
  thanks to René Schwaiger
- extended [FAQ](https://master.libelektra.org/doc/help/elektra-faq.md)
- Christoph Weber (@krit0n) improved some tutorials
- options are passed to PDFLaTeX compiler,
  thanks to René Schwaiger
- small fixes, thanks to Dominik Hofer
- fix many spelling mistakes, use American english, fix formatting,
  fix+add links, unify title style, fix code blocks, add titles
  and fix the PDF manual
  a big thanks to René Schwaiger

## Features

We added even more functionality, which could not make it to the highlights:

- DBUS support for qt-gui (listening to configuration changes):
  qt-gui gets a viewer-mode where configuration settings are immediately updated
  via DBus notifications, thanks to Raffael Pancheri
  With the new qt-gui and newer qt releases (~5.7) the qtquick experience is much smoother,
  for example, the tree view does not collapse on syncs anymore.
- Armin Wurzinger greatly improved the [JNA binding](https://www.libelektra.org/bindings/jna).
  The build system now uses Maven to build them. Armin also added Doxygen documentation
  and a [script](http://master.libelektra.org/scripts/randoop/randoop.in)
  to test the JNA binding using [Randoop](https://randoop.github.io/randoop).
- The improved [curlget plugin](https://www.libelektra.org/plugins/curlget),
  is now able to upload configuration files,
  thanks to Thomas Waser and Peter Nirschl (CMake fixes).
- New command `kdb rmmeta`, thanks to Bernhard Denner
- [crypto plugin](https://www.libelektra.org/plugins/crypto) and [fcrypt plugin](https://www.libelektra.org/plugins/fcrypt)
   - The configuration option `gpg/key` was renamed to `encrypt/key`
   - The plugins now make sure that you configured them properly by
     validating key IDs
   - thanks to Peter Nirschl
- [fcrypt plugin](https://www.libelektra.org/plugins/fcrypt):
   - The plugin now list available GPG keys when config is missing
   - You can now specify signatures via the configuration option `sign/key`
   - New text mode, enabled by default (disable by setting `fcrypt/textmode` to `0`)
   - New option `fcrypt/tmpdir` allows you to specify the output directory of `gpg`
   - If you want to learn how to use the plugin please check out our new [ASCII cast](https://asciinema.org/a/153014)
   - thanks to Peter Nirschl
- Thomas Waser added useful scripts:
  - [mount-list-all-files](https://master.libelektra.org/doc/help/kdb-mount-list-all-files.md)
    to list all mounted files.
  - [mountpoint-info](https://master.libelektra.org/doc/help/kdb-mountpoint-info.md)
    to provide more info about mountpoints.
  - [stash](https://master.libelektra.org/doc/help/kdb-stash.md)
    to stash away Elektra's configuration, to be restored using `restore`.
  - [backup](https://master.libelektra.org/doc/help/kdb-backup.md)
    to backup Elektra's configuration.
  - [restore](https://master.libelektra.org/doc/help/kdb-restore.md)
    to restore a backup or stash.
  - [check-env-dep](https://master.libelektra.org/doc/help/kdb-check-env-dep.md)
    allows users to check if environment has influence on configuration settings.
  - [change-resolver-symlink](https://master.libelektra.org/doc/help/kdb-change-resolver-symlink.md)
    allows users to change the default resolver.
  - [change-storage-symlink](https://master.libelektra.org/doc/help/kdb-change-storage-symlink.md)
    allows users to change the default storage.
- limit min/max depth for `kdb ls` (`-mM`), thanks to Armin Wurzinger.
- conditionals: allow multiple assigns and conditions
- base64 also works as filter for binary data (not just encrypted data),
  thanks to René Schwaiger
- [csvstorage plugin](https://www.libelektra.org/plugins/csvstorage):
  compatibility with RFC 4180, thanks to Thomas Waser
- [gitresolver plugin](https://www.libelektra.org/plugins/gitresolver):
  improvements and update of libgit version, thanks to Thomas Waser
- [curlget plugin](https://www.libelektra.org/plugins/curlget):
  also allow uploading of configuration files, thanks to Thomas Waser

## Compatibility

As always, the ABI and API of kdb.h is fully compatible, i.e. programs
compiled against an older 0.8 version of Elektra will continue to work
(ABI) and you will be able to recompile programs without errors (API).

We added `explicit` to some C++ constructors in libtools and internally moved
some typedefs. ModulesPluginDatabase now has protected members (instead
of private). This might break code in special cases, but should not affect binary
compatibility. As always we tested for binary compatibility.
This time we had to revert some changes to keep libelektra-tools
ABI compatible.

Furthermore:

- scripts now work on macOS (readlink and sed),
  thanks to Armin Wurzinger and René Schwaiger
- generalized error #60, "invalid line encountered"
- added new errors #164 - #187
- added private headerfiles `kdbglobal.h`, `kdbinvoke.h`

## Notes for Package Maintainer

These notes are of interest for people maintaining packages of Elektra:

- LICENSE.md now contains only the BSD 3-Clause License
  (without any additional non-license text)
- AUTHORS renamed to AUTHORS.md
- NEWS.md is now a generated file containing all news concatenated
- CMake 2.8.8 is no longer supported, CMake 3.0 is now needed
- fix macOS `RPATH`, remove old policies, thanks to René Schwaiger
- new option `BUILD_DOCSET` to build DocSet, thanks to René Schwaiger
- new option `ENABLE_OPTIMIZATIONS` for `OPMPHM` preparation work,
  thanks to Kurt Micheli
  For this release, please keep `ENABLE_OPTIMIZATIONS` turned off.
  Currently the flag increases memory usage, without being faster.
- add `TARGET_TOOL_DATA_FOLDER` for installation of tool data
  (for rest-backend and rest-frontend)

The following files are new:

- Libs: `libelektra-utility.so` ,`libelektra4j-0.8.20.pom.xml`,
  `libelektra-invoke` (needed by plugins: curlget, gitresolver, dini, blockresolver, multifile)
- Plugins: `libelektra-camel.so`, `libelektra-date.so`,
  `libelektra-file.so`, `libelektra-ipaddr.so`, `libelektra-mini.so`,
  `libelektra-multifile.so`, `libelektra-range.so`, `libelektra-xerces.so`,
  `libelektra-yamlcpp.so`
- Tools: `backup`, `mount-list-all-files`, `mountpoint-info`, `restore`,
  `stash`, `update-snippet-repository`
- Tests: `change-resolver-symlink`, `change-storage-symlink`,
  `check-env-dep`, `check_bashisms`, `check_doc`, `check_meta`,
  `testmod_camel`, `testmod_crypto_openssl`, `testmod_date`,
  `testmod_file`, `testmod_ipaddr`, `testmod_jni`, `testmod_mini`,
  `testmod_range`, `testmod_simpleini`, `testmod_xerces`, `testmod_yamlcpp`,
  `testtool_plugindatabase`, `test_utility`

The following files were removed: `testmod_curlget`, `testmod_dpkg`,
  `testmod_profile`, `testmod_shell`, `testmod_spec`, `test_opmphm_vheap`,
  `test_opmphm_vstack`

The following files were renamed:
 `libelektra-1.jar` → `libelektra4j-0.8.19.jar`

In the Debian branch of the [git repo](https://git.libelektra.org/tree/debian),
we now build upon the work of Pino Toscano. The branch allows building
Debian packages of the release for Debian Stretch and Jessie.

Thanks to Pino Toscano for the high-quality packages.


## Notes for Elektra's Developers

These notes are of interest for people developing Elektra:

- Added macros, thanks to René Schwaiger:
   - `ELEKTRA_NOT_NULL` is an assertion against null pointers
   - `ELEKTRA_MALLOC_ERROR` sets an error when allocation failed
   - `ELEKTRA_STRINGIFY` to quote a macro value
   - `ELEKTRA_PLUGIN_STATUS_ERROR`, `ELEKTRA_PLUGIN_STATUS_SUCCESS`,
     `ELEKTRA_PLUGIN_STATUS_NO_UPDATE` for return values of plugins.
- `ELEKTRA_STRINGIFY` used throughout, thanks to René Schwaiger
- use `(void)` instead of `()` (added `-Wstrict-prototypes`)
- new positions for global plugins,
  thanks to Mihael Pranjic
- Kurt Micheli added `generateKeySet` to randomly generate large key sets
- add vagrant and docker support, thanks to Christoph Weber (@krit0n)
- improve support for CLion, NetBeans and `oclint`
- portability improvements for logger, thanks to René Schwaiger
- metadata consistency check within source repo, thanks to Thomas Waser
- `ELEKTRA_PLUGIN_EXPORT` accepts macro as argument
- fallthroughs in switch statements are now marked with `FALLTHROUGH`
- introduce `print_result` to unify test output, thanks to René Schwaiger
- export `validateKey` as preparation for type plugin

## Other

Various other changes happened in the code repository:

- kdb: errors are more colorful, add infos to report issues,
       catch signals for `kdb` tools to print errors on crashes,
       use `$EDITOR` if `sensible-editor` and `editor` is not found.
       René Schwaiger fixed preposition and format of the messages.
- added Spanish translation for qt-gui
  thanks to AdanGQ (@pixelead0)
- augeas plugin: error messages improved, export genconf (for WebUI to list all lenses)
- improvements for CentOS and Debian Packages,
  thanks to Sebastian Bachmann
- Travis improvements, fixes, and many build variants added,
  thanks to Mihael Pranjic and René Schwaiger
- `ronn` now always uses UTF-8 as encoded and is no longer required
  as essential dependency to get man pages, thanks to René Schwaiger
- GitHub now recognizes that we have a BSD licence,
  thanks to René Schwaiger
- uninstallation Script also uninstalls directories and Python files,
  thanks to René Schwaiger
- Kurt Micheli created a benchmark tool to generate large KeySets
- added/reformatted use cases, thanks to Daniel Bugl
- Thomas Wahringer prepared for a new theme on the website
- Arfon Smith updated meta data for Elektra's journal entry

## Quality

In this release we had a focus on quality improvements:

- fixed all remaining ASAN problems,
  thanks to René Schwaiger and Armin Wurzinger
  (some tests are excluded when compiled with ASAN)
- fix many compilation warnings,
  thanks to René Schwaiger and Armin Wurzinger
- fixed many potential out-of-bound errors,
  thanks to René Schwaiger
- fixed warnings of Clang's static analyzers,
  thanks to René Schwaiger
- fixed cppcheck warnings, thanks to Armin Wurzinger
- fixed strict prototypes, thanks to Armin Wurzinger
- fixed and use scan-build (clang)
- fixed potential memory leaks on errors
- added assertions
- generate Java API tests with randoop which
  revealed bugs in jna bindings that were fixed,
  thanks to Armin Wurzinger
- Numerous fixes in the shell recorder,
  which does regression tests on Elektra's tutorials
  and READMEs, thanks to René Schwaiger and Thomas Waser

## Fixes

Many problems were resolved with the following fixes:

- `kdb file`: never print errors, thanks to René Schwaiger
- plugin mathcheck: fixed regex #1094, thanks to Thomas Waser
- dbus: properly do unref and document how to integrate DBus,
  thanks to Kai-Uwe Behrmann
- dbus accepts announce=once which is used for `kdb mount-openicc`
  It protects against message floods in large configuration files,
  thanks to Kai-Uwe Behrmann for reporting
- plugin desktop: fix crash if `DESKTOP_SESSION` is missing
- shell-recorder: many fixes and improvements,
  thanks to Thomas Waser and René Schwaiger
- fix getopt positional parameters, thanks to Armin Wurzinger
- resolver: avoid silent errors of fchown/fchmod
- plugin fcrypt: fixes in file name handling to make leaks less likely
  (still needs tmpfs to be secure!), thanks to Peter Nirschl
- plugin jni: fix segfaults on errors, plugin is nevertheless tagged
  as experimental due to other problems
- plugin type: reject integers if garbage follows
- `kdb`: fix memleak when listing plugins
- many spelling fixes and fix typo in source of qt-gui:
  thanks to klemens (ka7)
- dpkg, fix file leakage, thanks to Armin Wurzinger
- plugin line: only skip parentKey if present
- plugin resolver: avoid failure after commit for files that
  cannot be removed
- plugin simpleini: handle more errors, make format parameter more robust
  thanks to Bernhard Denner
- plugin crypto: fix compilation errors for openssl versions on
  Debian 9, thanks to Peter Nirschl
- `kdb mv`: fail without keys also in recurse mode
- fix bashism, thanks to Armin Wurzinger
- qtgui: fix crash on unhandled exception on binary values,
  thanks to Raffael Pancheri

## Outlook

We are currently working on following topics:

- Migration of LCDproc, OpenIcc, machinekit, ... to Elektra.
- A reimplementation of Elektra's core API in Rust
  (next to implementation in C).
- A user interface which generates restricted input fields
  based on the specification.
- YAML as configuration file format (next to INI, XML, JSON, TCL, ...).
- An mmap persistent cache.
- Improvements for the specification language.
- New APIs to be directly used by applications.
- An order-preserving minimal hash for O(1) lookup and iteration.
- Mainloop migration for notifications (currently only DBus,
  to be extended to Redis, ZeroMq).
- Improvements on the Website and snippet sharing to also
  handle misconfiguration.


## Get It!

You can download the release from [here](https://www.libelektra.org/ftp/elektra/releases/elektra-0.8.20.tar.gz)
or [GitHub](https://github.com/ElektraInitiative/ftp/blob/master/releases/elektra-0.8.20.tar.gz?raw=true)


The [hashsums are:](https://github.com/ElektraInitiative/ftp/blob/master/releases/elektra-0.8.20.tar.gz.hashsum?raw=true)

- name: elektra-0.8.20.tar.gz
- size: 4740032
- md5sum: 0e906f1a1677a8bfb31d144e1eaeb3cf
- sha1: 5e33c49ae6e3b890c9267288fb9f321289910eb5
- sha256: e9cbc796e175685ccb6221f1dd5ea5c43832f545c40557c32b764ff5d567b312

The release tarball is also available signed by me using gpg from
[here](https://www.libelektra.org/ftp/elektra/releases/elektra-0.8.20.tar.gz.gpg) or
[GitHub](https://github.com/ElektraInitiative/ftp/blob/master/releases//elektra-0.8.20.tar.gz.gpg?raw=true)

Already built API-Docu can be found [online](https://doc.libelektra.org/api/0.8.20/html/)
or [GitHub](https://github.com/ElektraInitiative/doc/tree/master/api/0.8.20).


## Stay tuned!

Subscribe to the
[RSS feed](https://www.libelektra.org/news/feed.rss)
to always get the release notifications.

For any questions and comments, please contact the
issue tracker [on GitHub](http://issues.libelektra.org)
or me by email using elektra@markus-raab.org.

[Permalink to this NEWS entry](https://www.libelektra.org/news/0.8.20-release)

For more information, see [https://libelektra.org](https://libelektra.org)

Best regards,
Markus








# 0.8.21 Release

We are proud to release Elektra 0.8.21.

- guid: 7f5de1b1-6086-47a6-9922-cac08c898ae7
- author: Markus Raab
- pubDate: Fri, 22 Dec 2017 09:24:02 +0100
- shortDesc: FOSDEM, New Book, Maturing of Plugins


## What is Elektra?

Elektra serves as a universal and secure framework to access
configuration settings in a global, hierarchical key database.
For more information, visit [https://libelektra.org](https://libelektra.org).

The news can be read rendered at [our web server](https://www.libelektra.org/news/0.8.21-release).



## Highlights

In this release 8 authors created 307 commits and changed 217 files (5227 insertions, 1914 deletions).
The highlights of this release are:

- Fosdem Talk about Elektra was accepted
- CC-licensed book about Elektra published
- Maturing of plugins
- Elektra with encryption
- Preparation for switch to INI as default storage

### Fosdem Talk about Elektra in Main Track

We are happy to announce that there will be a talk about
Elektra in one of the [main tracks of Fosdem 2018](https://fosdem.org/2018/schedule/event/elektra/):

- Title: Configuration Revolution
- Subtitle: Why it Needed 13 Years and How it Will be Done
- Day: Saturday 2018-02-03
- Start time: 15:00
- Duration: 50 min
- Room: K.1.105 (La Fontaine)

And a second talk in the [Config Management DevRoom](https://fosdem.org/2018/schedule/event/puppet_key_value/):

- Title: Breaking with conventional Configuration File Editing
- Subtitle: Puppet with a Key/Value API in a User Study
- Day: Sunday 2018-02-04
- Start time: 12:30
- Duration: 25 min
- Room: UA2.114 (Baudoux)

See you in Brussels at 3 and 4 February 2018!

I will also be present in the [Config Management Camp](http://cfgmgmtcamp.eu/) directly after Fosdem in Gent.

### CC-licenced Book About Vision of Elektra Published

I am proud to release a book with the title "Context-aware Configuration" describing:

- the last 13 years of Elektra (focus on last 4 years with the questionnaire survey and code analysis),
- the current state of Elektra, and
- the long-term goals of Elektra (context-aware configuration).

The Fosdem talk will cover some highlights from the book.

A huge thanks to everyone involved in the questionnaire survey,
without you we would not have been able to collect all the
information that led to the requirements for Elektra.

The LaTeX sources are available [here](https://book.libelektra.org)
and the compiled book can be downloaded from [here](https://www.libelektra.org/ftp/elektra/publications/raab2017context.pdf).

### Maturing of Plugins

- The new [Directory Value plugin](https://www.libelektra.org/plugins/directoryvalue) supports storage plugins such as [YAJL](https://www.libelektra.org/plugins/yajl) and [YAML CPP ](https://www.libelektra.org/plugins/yamlcpp). It adds extra leaf values for directories (keys with children) that store the data of their parents. This way plugins that normally are only able to store values in leaf keys are able to support arbitrary key sets.
- The [YAML CPP plugin](https://www.libelektra.org/plugins/yamlcpp) reads and writes [YAML](http://yaml.org) data using [yaml-cpp](https://github.com/jbeder/yaml-cpp). The plugin supports arrays, binary data and metadata.
- The [Camel plugin](https://www.libelektra.org/plugins/camel) stores data as simplified YAML flow lists containing double quoted keys and values. For proper YAML support please use the [YAML CPP](https://www.libelektra.org/plugins/yamlcpp) instead.
- The [mINI plugin](https://www.libelektra.org/plugins/mini) reads and writes simple property list, separated by equal (`=`) signs.
- The [xerces plugin](https://www.libelektra.org/plugins/xerces) allows Elektra to read and write XML data. The plugin uses [Xerces-C++](http://xerces.apache.org/xerces-c) for this task. It supports both arrays and metadata.
- The [boolean plugin](https://www.libelektra.org/plugins/boolean) normalizes boolean values such as `0`, `1`, `true` and `false`.
- The [crypto plugin](https://www.libelektra.org/plugins/crypto) and [fcrypt plugin](https://www.libelektra.org/plugins/fcrypt) are described below.

### Elektra With Encryption

The plugins `fcrypt` and `crypto` are now considered stable. They are no longer tagged as `experimental`.
While `crypto` encrypts individual values within configuration files, `fcrypt` encrypts and/or signs the whole configuration file.

For this release Peter Nirschl prepared a demo showing Elektra's cryptographic abilities:

[![asciicast](https://asciinema.org/a/153014.png)](https://asciinema.org/a/153014)

Thanks to Peter Nirschl for this great work!

### Switch to INI

We plan to switch to INI as default storage instead of Elektra's infamous internal dump format.

As preparation work we implemented the `dini` plugin which transparently
converts all `dump` files to `ini` files on any write attempt.
Furthermore, we fixed most of the INI bugs which blocked INI to be the
default storage.

Due to this progress we will likely switch to INI as default starting
with the next release. If you want to, you can switch now by compiling
Elektra with:<br>
`-DKDB_DEFAULT_STORAGE=dini`

Or simply switch for your installation with:<br>
`sudo kdb change-default-storage dini`

If you are already using `ini` as default, changing to `dini` will:

- add some overhead because `dini` always checks if a file uses the `dump`
  format, unless the `dump` plugin is not installed.
- add support for binary values using the `binary` plugin

> NOTE: INI (dini) was not completely ready for 0.8.21 thus we kept `dump` as default.
> `dini` is currently an experimental plugin.

## Other New Features

We added even more functionality, which could not make it to the highlights:

- `kdb rm` now supports `-f` to ignore non-existing keys
- use `%` as profile name to disable reading from any profile
- The new function `elektraArrayDecName`:

  ```c
  int elektraArrayDecName (Key * key);
  ```

   decreases the index of an array element by one. It can be used to reverse the effect of `elektraArrayIncName`,
   thanks to René Schwaiger

## Documentation

We improved the documentation in the following ways:

- We renamed our beginner friendly issues to "good first issue" as recommended by GitHub.
- In many parts of the documentation we already switched to American spelling
  thanks to René Schwaiger
- Added more [automatic spelling corrections](https://master.libelektra.org/scripts/sed)
  thanks to René Schwaiger
- Fixed many spelling mistakes
  thanks to René Schwaiger
- We extended the ReadMe of the `jni` plugin. The ReadMe now also contains information about the Java prerequisites of the `jni` plugin on Debian Stretch.
- Improved notes about testing
  thanks to Thomas Wahringer
- qt-gui: give hints which package to install
- The build phrases `jenkins build all please` and `jenkins build doc please` were [documented](https://master.libelektra.org/doc/GIT.md)
  thanks to René Schwaiger
- Documentation for libelektra-invoke was added

## Compatibility

As always, the ABI and API of kdb.h is fully compatible, i.e. programs
compiled against an older 0.8 version of Elektra will continue to work
(ABI) and you will be able to recompile programs without errors (API).

All unit tests of 0.8.20 run successfully with Elektra 0.8.21.
There are, however, some additions and changes in rarely used interfaces:

- added `elektraArrayDecName` and `elektraArrayValidateName` in libease
- fixed `kdbinvoke.h` interface: make structure private and complete API
- fixed `xmlns` and `xsi:schemaLocation` to be `https://www.libelektra.org`
- the private header file `kdbopmphm.h` got nearly rewritten

## Notes for Maintainer

These notes are of interest for people maintaining packages of Elektra:

- We added the following files in this release:
  - `libelektra-dini.so`
  - `libelektra-directoryvalue.so`
  - `testmod_directoryvalue`
- The following plugins are not marked as experimental anymore:
  - `camel`
  - `crypto`
  - `mini`
  - `xerces`
  - `yamlcpp`
- The binding `intercept-fs` is now marked more clearly as experimental
- The `jni` plugin is again experimental because it does not work with some Java systems.
  For the `lua` plugin there are also problems with some Lua systems.

## Notes for Elektra's Developers

These notes are of interest for people developing Elektra:

- From now on release notes are written as part of PRs
- Elektra Initiative is spelled as two words
- At some more places we switched to use the logger, thanks to René Schwaiger
- Shell Recorder got many improvements, see below in Testing.
  Please use it.
- The plugin's template now adds all placements within backends by default
  (must be removed accordingly).
- We now warn if plugins do not have any placement.
- Please prefer -log and -debug builds
- The build server now understands the build phrase `jenkins build all please`
  thanks to René Schwaiger.
  Please use it carefully, since it puts our [build server](https://build.libelektra.org/) under heavy load.
- Markdown Shell Recorder Syntax recommended when reporting bugs.
- Elektra's [Dockerfile](https://master.libelektra.org/scripts/docker/Dockerfile) was improved and simplified, thanks to Thomas Wahringer.
- Add more Explanations how to do Fuzz Testing
- Started documenting disabled tests in [doc/todo/TESTING](https://master.libelektra.org/doc/todo/TESTING)
- You now can use `tests/icheck.suppression` to disable already checked API changes.
- The (hopefully) last Sourceforge references were removed and a redirection page was added,
  thanks to @the-Arioch for reporting.

## Testing

- AFL unveiled some crashes in INI code
- fix OCLint problems, thanks to René Schwaiger
- fix ASAN problems, thanks to René Schwaiger
- disabled non-working tests
- Shell recorder
- Benchmark optionally also works with OpenMP, thanks to Kurt Micheli
- The Shell Recorder now uses `kdb-static` or `kdb-full` if `kdb` is not available (`BUILD_SHARED=OFF`)

## Fixes

Many problems were resolved with the following fixes:

- fix use of `dbus_connection_unref(NULL)` API
  thanks to Kai-Uwe Behrmann
- Properly include headers for `std::bind`
  thanks to Nick Sarnie
- qt-gui: assure active focus on appearance selection window
  thanks to Raffael Pancheri
- René Schwaiger repaired the `boolean` plugin:
  - wrong metadata was used
  - plugin configuration was missing
  - documentation was missing
  - logging code was added
- René Schwaiger repaired many problems different build agents had
- `kdb info -l` does not open `KDB` anymore.
- `change-resolver-symlink` and `change-storage-symlink` now correctly use
  `@TARGET_PLUGIN_FOLDER@`
- date plugin will be removed on attempts to compile it with gcc 4.7, thanks to René Schwaiger
- C plugin: storage/c metadata added
- fix disabling documentation in CMake, thanks to Kurt Micheli
- Simplify `elektraArrayValidateName`, thanks to René Schwaiger

## Outlook

The Order Preserving Minimal Perfect Hash Map (OPMPHM) is ready to extend `ksLookup`. The implementation of the randomized Las Vegas hash map
algorithm is in a final stage and the heuristic functions that ensure time and space optimality are backed up by benchmarks.
Thanks to Kurt Micheli, the next release will include the OPMPHM!

## Get It!

You can download the release from [here](https://www.libelektra.org/ftp/elektra/releases/elektra-0.8.21.tar.gz)
or [GitHub](https://github.com/ElektraInitiative/ftp/blob/master/releases/elektra-0.8.21.tar.gz?raw=true)


The [hashsums are:](https://github.com/ElektraInitiative/ftp/blob/master/releases/elektra-0.8.21.tar.gz.hashsum?raw=true)

- name: elektra-0.8.21.tar.gz
- size: 4712043
- md5sum: d627a01a0249fde46e80042c848d4521
- sha1: a7659a7bb1b2388d03cdf0084160de612e5c4511
- sha256: 51892570f18d1667d0da4d0908a091e41b41c20db9835765677109a3d150cd26

The release tarball is also available signed by me using GnuPG from
[here](https://www.libelektra.org/ftp/elektra/releases/elektra-0.8.21.tar.gz.gpg) or
[GitHub](https://github.com/ElektraInitiative/ftp/blob/master/releases//elektra-0.8.21.tar.gz.gpg?raw=true)

Already built API-Docu can be found [online](https://doc.libelektra.org/api/0.8.21/html/)
or [GitHub](https://github.com/ElektraInitiative/doc/tree/master/api/0.8.21).


## Stay tuned!

Subscribe to the
[RSS feed](https://www.libelektra.org/news/feed.rss)
to always get the release notifications.

For any questions and comments, please contact the
issue tracker [on GitHub](http://issues.libelektra.org)
or me by email using elektra@markus-raab.org.

[Permalink to this NEWS entry](https://www.libelektra.org/news/0.8.21-release)


For more information, see [https://libelektra.org](https://libelektra.org)

Best regards,
Markus Raab for the [Elektra Initiative](https://www.libelektra.org/developers/authors)







# 0.8.22 Release

- guid: 4884a54f-996a-4564-a138-38a70166fed7
- author: Markus Raab
- pubDate: Tue, 27 Feb 2018 19:35:58 +0100
- shortDesc: Logo, INI, Lookup

We are proud to release Elektra 0.8.22!
In 429 commits, 8 authors changed 548 files with 60369 insertions(+), 6783 deletions(-).


## What is Elektra?

Elektra serves as a universal and secure framework to access
configuration settings in a global, hierarchical key database.
For more information, visit [https://libelektra.org](https://libelektra.org).

For a small demo see here:

[![asciicast](https://asciinema.org/a/cantr04assr4jkv8v34uz9b8r.png)](https://asciinema.org/a/cantr04assr4jkv8v34uz9b8r)

You can also read the news [on our website](https://www.libelektra.org/news/0.8.22-release)

You can read the [FOSDEM interview](https://fosdem.org/2018/interviews/markus-raab/) and watch the
[FOSDEM main talk](https://fosdem.org/2018/schedule/event/elektra/) given recently.

Elektra is now an official part of [Homebrew](http://formulae.brew.sh/formula/elektra) and
[Alpine Linux](https://pkgs.alpinelinux.org/package/edge/testing/x86_64/elektra).



## Highlights

- New Logo and Website Theme
- INI plugin greatly improved
- Notifications API and Bindings for Asynchronous I/O
- Plugin Processes
- Lookup with the Order Preserving Minimal Perfect Hash Map


### New Logo and Website Theme

We are proud to present our new logo.
It has a new shape and cooler colors.

<img src="https://cdn.rawgit.com/ElektraInitiative/libelektra/master/doc/images/logo/logo_color.svg" alt="Elektra" width="150" />

Thanks to Philipp Frei!

We also gave the website a new look. It has the colors from the logo and new
fonts ([Lato](https://fonts.google.com/specimen/Lato) and
[Libre Franklin](https://fonts.google.com/specimen/Libre+Franklin)) that improve
readability and add to a unique look. The restructured start page contributes to
the new look as well.

We also updated asciinema-player to 2.6.0.

Thanks to Thomas Wahringer.

We also fixed security issues in the Website due to an old version of jquery,
thanks to Marvin Mall.

Thanks to Bernhard Denner for keeping our infrastructure running.

### INI plugin greatly improved

- `dini` is no longer experimental anymore and adds the binary plugin.
- We added a crash test for the INI plugin that feeds the plugin with problematic input data we determined using [AFL](http://lcamtuf.coredump.cx/afl)
- We fixed various small bugs that could potentially cause the INI plugin to crash and fixes the problems as reported by AFL
- The INI plugin now [converts a section to a normal key-value pair](https://github.com/ElektraInitiative/libelektra/issues/1793) if you store a value inside it. This has the advantage that you will not [lose data unexpectedly anymore](https://github.com/ElektraInitiative/libelektra/issues/1697).
- The [INI plugin](https://www.libelektra.org/plugins/ini) should now read most key-value pairs containing delimiter characters (`=`) properly.

Thanks to René Schwaiger!

Nevertheless, we did not switch to INI as default format.
This has some reasons:

- In many workflows, `dump` is the better choice: e.g. with `kdb editor` you can edit any parts of Elektra with any format (e.g. INI) more safely.
  (With the INI plugin in some of these situations meta data is wrongly shown.)
- The code base of INI is not fully tested and partly not well understood.
- We plan to switch to a newly written parser (most likely YAML) and want to avoid that users have two migrations.
  The migration from `dump` is easier (especially compared with INI) because the `dump` format is recognisable without ambiguity.
  (Thus the INI file parses nearly any file, it is hard to detect that a file is not INI)

But for those who want to switch, the migration will be smooth:
The `dini` plugin makes sure that old dump files are still being read.
Only when writing out configuration files, configuration files are converted to INI.
To change to INI during compilation, simply use: 

`-DKDB_DEFAULT_STORAGE=dini`

Or simply switch for your installation with:<br>
`sudo kdb change-default-storage dini`

You can also mount INI (or dini) as root:<br>
`sudo kdb mount default.ini / dini`


### Notification API and Bindings for Asynchronous I/O

This release contains an experimental implementation of Elektra's notification feature.
This feature enables applications to get updates when configuration is changed at run-time.
For more details see the preview tutorial at
[doc/tutorials/notifications.md](https://github.com/ElektraInitiative/libelektra/tree/master/doc/tutorials/notifications.md)

The
[Notification API](https://doc.libelektra.org/api/current/html/kdbnotification_8h.html)
is implemented by a new library called `elektra-notification`.
To use the library you need the new internalnotification plugin.
Since the plugin is experimental it needs to be enabled when building Elektra
from source (e.g. by passing
`-DPLUGINS="ALL;-EXPERIMENTAL;internalnotification"` to `cmake`).

New bindings for asynchronous I/O called "I/O bindings" also have been added.
These bindings allow Elektra's plugins and other parts to perform *asynchronous* operations.
I/O bindings are opt-in for application developers.
New features of Elektra that take advantage of I/O bindings will have fallbacks where viable.
These fallbacks will use synchronous I/O thus keeping the status quo.

This release includes an experimental I/O binding for [uv](http://libuv.org/).
The interface for I/O bindings is currently experimental and might change in the future.

Elektra's notification feature is not complete yet.
So called "transport plugins" will be responsible for sending and receiving
notifications using different protocols or libraries (like ZeroMQ or D-Bus).
These plugins will make use of the new I/O bindings.
We plan to introduce the first transport plugins with the next release of Elektra.


### Plugin Processes

A new library called [pluginprocess](https://github.com/ElektraInitiative/libelektra/tree/master/src/libs/pluginprocess)
has been added. This library contains functions that aid in executing plugins in
a separate process. This child process is forked from Elektra's main process
each time such plugin is used and gets closed again afterwards. It uses a simple
communication protocol based on a KeySet that gets serialized through a pipe via
the `dump` plugin to orchestrate the processes.

Such a behavior is useful for plugins which cause memory leaks to be
isolated in an own process. Furthermore this is useful for runtimes or libraries
that cannot be reinitialized in the same process after they have been used.


### Lookup with the Order Preserving Minimal Perfect Hash Map

The `ksLookup (...)` has a new search algorithm, that acts as an alternative to the
binary search. The Order Preserving Minimal Perfect Hash Map (OPMPHM) is a non-dynamic,
randomized hash map and is very effective for mostly static configurations.
The OPMPHM can be enabled for a search by passing the in [kdbproposal.h](https://github.com/ElektraInitiative/libelektra/blob/master/src/include/kdbproposal.h)
defined option `KDB_O_OPMPHM` to the lookup.
Be aware that if the KeySet changes often using the OPMPHM might not be a good
idea, read more about the [OPMPHM](https://github.com/ElektraInitiative/libelektra/blob/master/doc/dev/data-structures.md#order-preserving-minimal-perfect-hash-map-aka-opmphm).

When you are not sure if the OPMPHM will speed up you searches, wait for the next release,
that one will include a hybrid search algorithm that combines the best properties of
both search algorithms.

To disable OPMPHM (e.g. on systems with tight memory constraints), you can pass
`-DENABLE_OPTIMIZATIONS=OFF`


## Other New Features

We added even more functionality, which could not make it to the highlights:

- The Web UI was greatly improved, thanks to Daniel Bugl
  The version of clusterd was increased from 1.0.0 to 1.1.0.
- Elektra is now part of the official [Homebrew repository](http://formulae.brew.sh/formula/elektra). We still provide a
  [tap](http://github.com/ElektraInitiative/homebrew-elektra), if you want to install Elektra together with plugins or bindings that require
  additional libraries.
- The building and linking of the haskell bindings and haskell plugins has been
  [greatly improved](https://github.com/ElektraInitiative/libelektra/pull/1698).
- The invoke library can now [report errors](https://github.com/ElektraInitiative/libelektra/pull/1801) upon opening/closing a plugin,
  thanks to Armin Wurzinger.
- The [YAML CPP plugin](https://www.libelektra.org/plugins/yamlcpp) does not require [Boost](http://www.boost.org) anymore, if you
  installed [yaml-cpp 0.6](https://github.com/jbeder/yaml-cpp/releases/tag/yaml-cpp-0.6.0).
- Improved colored output in `kdb` tool.
- We added two build jobs: [docker](https://build.libelektra.org/job/test-docker/) and [haskell](https://build.libelektra.org/job/elektra-haskell/).
  Thanks to Bernhard Denner and Armin Wurzinger.
- [YAML CPP](https://www.libelektra.org/plugins/yamlcpp) does not write binary data to a config file, if you forget to load the [Base64 plugin](https://www.libelektra.org/plugins/base64).
- [YAML CPP](https://www.libelektra.org/plugins/yamlcpp) now encodes empty binary keys as NULL values (`~`), and also adds the meta key `binary` for such values automatically.

## Documentation

We improved the documentation in the following ways:

- We have [documented how you can setup a build node for Jenkins using a Docker container](https://github.com/ElektraInitiative/libelektra/tree/master/scripts/docker/jenkinsnode/README.md)
  We also provide an example Dockerfile based on Debian Stretch for that purpose,
  thanks to Armin Wurzinger.
- Document how `rlwrap` might be used for `kdb shell`.
- Fixed docu in `hosts` plugin.
- Greatly improved the [license documentation](https://git.libelektra.org/blob/debian/debian/copyright)
  in `debian/copyright` in the `debian` branch, thanks to Thomas Wahringer.
- Various fixes in doc/METADATA.ini

## Compatibility

As always, the ABI and API of kdb.h is fully compatible, i.e. programs
compiled against an older 0.8 version of Elektra will continue to work
(ABI) and you will be able to recompile programs without errors (API).

We executed old test cases against the latest Elektra version and all
tests passed.

In `kdbinvoke.h` we changed the API so that `elektraInvokeOpen`
and `elektraInvokeClose` can yield error messages.

We added:

- the public headerfiles `kdbnotification.h`, `kdbio.h`, `kdbiotest.h`.
- the private headerfiles `kdbnotificationplugin.h`, `kdbioprivate.h`.

## Portability

- Fix bash shebang of bash scripts, thanks to Jakub Jirutka
- Remove unportable unneeded asm, thanks to Timo Teräs and Jakub Jirutka
- Fixed syntax in shell recorder, thanks to René Schwaiger
- Used `mktemp` in `check_distribution.sh` to allow parallel run of test cases,
  thanks to Armin Wurzinger.

## Notes for Maintainer

These notes are of interest for people maintaining packages of Elektra:

- `dini` is no longer experimental.
- CMake: `BINDINGS` now behaves like `PLUGINS`
  By default now all MAINTAINED bindings except EXPERIMENTAL and DEPRECATED are included.
  For more details see
  [/doc/COMPILE.md](https://github.com/ElektraInitiative/libelektra/tree/master/doc/COMPILE.md).
  To include both intercept bindings, you now need to write `INTERCEPT`, to only include getenv
  interception `intercept_env`. `intercept` in lower-case does not work anymore.

The following files are new:

- Libs: `libelektra-notification.so`, `libelektra-io.so`, `libelektra-io-uv.so`, `libelektra-pluginprocess.so`
- Headers: `kdbgetenv.h`, `kdbio.h`, `kdbpluginprocess.h`
- Plugins: `base64/Base64.pdf`
- Binaries: `getenv`, `test_context`, `test_fork`, `test_getenv`, `test_ks_opmphm`, `test_opmphm`
- Other: `elektra-io.pc`

The following files were removed:

- Tests: `testmod_semlock`

## Notes for Elektra's Developers

These notes are of interest for people developing Elektra:

- We now use `clang-reformat-5.0` for formatting.
  Please upgrade your clang.
- Build Agent `ryzen v2` was added to speed up `jenkins build all please`,
  thanks to Armin Wurzinger.
- Travis maintenance (Qt 5 and other problems),
  thanks to René Schwaiger.
- `BINDINGS` was greatly improved and the CMake functions were simplified.
   Bindings now also have a `README.md` with meta data.
   A big thanks to Thomas Wahringer.
- Decision: Logging with `ELEKTRA_LOG` is only for C/C++.
- Including `kdberrors.h` in a C++ files now also works, if you do not add the statement

  ```cpp
  using namespace ckdb;
  ```

  before you import `kdberrors.h`.
- The CMake code for Elektra’s [Qt-GUI](https://www.libelektra.org/tools/qt-gui) now detects the location of Qt 5 automatically if you
  installed Qt via Homebrew.
- All Shell Recorder tests should not now correctly restore your old configuration after you execute them,
  thanks to René Schwaiger.
- The [Base64 plugin](https://www.libelektra.org/plugins/base64) does not encode empty binary values in meta mode anymore. This update allows plugins such as YAML CPP to handle empty keys properly.

## Fixes

Many problems were resolved with the following fixes:

- `kdb global-umount` also removed other mountpoints
- We fixed [internal inconsistency](https://github.com/ElektraInitiative/libelektra/pull/1761) in the CMake code of the [Augeas plugin](https://www.libelektra.org/plugins/augeas)
- We fixed the [haskell bindings and plugins on Debian Stretch](https://github.com/ElektraInitiative/libelektra/pull/1787)
  and added a [new build server job](https://build.libelektra.org/job/elektra-haskell/) to test that in the future.
- Cleanup in list plugin, thanks to Thomas Wahringer
- The Shell Recorder now exports and imports the root of a mountpoint instead of the mountpoint itself. This change makes sure that Shell
  Recorder test do not change the configuration directly below the specified mountpoint.

## Get It!

You can download the release from [here](https://www.libelektra.org/ftp/elektra/releases/elektra-0.8.22.tar.gz)
or [GitHub](https://github.com/ElektraInitiative/ftp/blob/master/releases/elektra-0.8.22.tar.gz?raw=true)


The [hashsums are:](https://github.com/ElektraInitiative/ftp/blob/master/releases/elektra-0.8.22.tar.gz.hashsum?raw=true)

- name: elektra-0.8.22.tar.gz
- size: 5885118
- md5sum: 5cbd9e33daf51f6f33791ff3f99342a6
- sha1: 4954ff16cfe7dc69e45e6a748556262b8fb1a9fa
- sha256: 962598315619d5dff3a575d742720f076dc4ba3702bd01609bfb7a6ddb5d759f

The release tarball is also available signed by me using GnuPG from
[here](https://www.libelektra.org/ftp/elektra/releases/elektra-0.8.22.tar.gz.gpg) or
[GitHub](https://github.com/ElektraInitiative/ftp/blob/master/releases//elektra-0.8.22.tar.gz.gpg?raw=true)

Already built API-Docu can be found [online](https://doc.libelektra.org/api/0.8.22/html/)
or [GitHub](https://github.com/ElektraInitiative/doc/tree/master/api/0.8.22).


## Stay tuned!

Subscribe to the
[RSS feed](https://www.libelektra.org/news/feed.rss)
to always get the release notifications.

For any questions and comments, please contact the
issue tracker [on GitHub](http://issues.libelektra.org)
or me by email using elektra@markus-raab.org.

[Permalink to this NEWS entry](https://www.libelektra.org/news/0.8.22-release)

For more information, see [https://libelektra.org](https://libelektra.org)

Best regards,
[Elektra Initiative](https://www.libelektra.org/developers/authors)





# 0.8.23 Release

- guid: 9a9ab08b-9ca0-4242-b617-5a8b21ea42a0
- author: Markus Raab
- pubDate: Sun, 13 May 2018 08:57:15 +0200
- shortDesc: Notification, Web UI, Build System

We are proud to release Elektra 0.8.23.

In 717 commits 11 authors changed 835 files with 31144 insertions(+), 21773 deletions(-).

## What is Elektra?

Elektra serves as a universal and secure framework to access
configuration settings in a specified, global, hierarchical key database.
For more information, visit [https://libelektra.org](https://libelektra.org).

For a small demo see here:

[![asciicast](https://asciinema.org/a/cantr04assr4jkv8v34uz9b8r.png)](https://asciinema.org/a/cantr04assr4jkv8v34uz9b8r)

You can also read the news [on our website](https://www.libelektra.org/news/0.8.23-release)



## Highlights

- Notification: New transport plugin
- Web UI greatly improved
- Overhaul of Build System and Daily Stretch Repository


### Notification: New transport plugin

To keep persistent configuration settings in sync with the configuration settings of applications, notifications are needed.
For notifications it is important that they do not block the execution of the applications.
In Elektra we achieve this using transport plugins.

Elektra's notification feature has received its first transport plugin pair:
D-Bus.
Transport plugins provide a link between applications using Elektra.
These plugins send and receive notifications when a key is modified within the
key database.
The existing `dbus` plugin has been modified to use an asynchronous I/O binding
for sending messages, if available.
The new `dbusrecv` plugin is responsible for receiving messages sent from the
`dbus` plugin and other sources with the same
[message format](https://www.libelektra.org/plugins/dbus#notification-format).

For more details see the
[notification tutorial](https://github.com/ElektraInitiative/libelektra/tree/master/doc/tutorials/notifications.md)
or the
[example applications](https://github.com/ElektraInitiative/libelektra/tree/master/src/libs/notification/example).

Thanks to Thomas Wahringer.


### Web UI greatly improved

The goal of the Web UI is to provide safe and unified access to all configuration settings of a system.
Different to other UIs, it generates its interface according specifications as found in Elektra.

For example, if a configuration setting only has a number of choices, you get exactly these choices
within the user interface.

To get outstanding usability, Web UI now provides:

- undo functionality
- visibility functionality to hide irrelevant configuration settings
- built-in validation for many types of configuration settings
- support for arrays
- descriptions of configuration settings embedded in the user interface

Furthermore:

- The Web-UI now is able to install itself via cmake.
- The API was updated for [elektrad](https://master.libelektra.org/doc/api_blueprints/elektrad.apib)
  and [webd](https://master.libelektra.org/doc/api_blueprints/webd.apib) (former clusterd).

[Read here to get started](https://www.libelektra.org/tools/web).

> Note that new version of the Web UI requires Elektra 0.8.23 or later.

Thanks to Daniel Bugl.


### Overhaul of Build System and Daily Stretch Repository

We started to overhaul our build system to improve build times and responsiveness.
It focuses heavily on containerisation to improve hardware utilization.

If you are interested in `#devops` have a look at our
[Jenkinsfile](https://github.com/ElektraInitiative/libelektra/blob/master/scripts/jenkins/Jenkinsfile).

Daily builds Debian packages for Stretch are available again in our
[stretch repository](https://debian-stretch-repo.libelektra.org).
Add it to your `sources.list`:

```
deb     [trusted=yes] https://debian-stretch-repo.libelektra.org/ stretch main
deb-src [trusted=yes] https://debian-stretch-repo.libelektra.org/ stretch main
```

Thanks to Lukas Winkler.


## Other New Features

We added even more functionality, which could not make it to the highlights:

- A new experimental [I/O binding for glib](https://www.libelektra.org/bindings/io_glib)
  has been added.
  It can be used to integrate the notification feature with applications based
  on glib.
- The Order Preserving Minimal Perfect Hash Map (OPMPHM), used to speed up the lookups, got optimized
  and a benchmark was added,
  thanks to Kurt Micheli
- We added a script that calculates the complexity of configuration settings based on their specification,
  thanks to Anton Hößl
- `kdb ls` now has `-0` option to allow key names with newlines (needed for Web UI)
- The [csvstorage](https://www.libelektra.org/plugins/csvstorage) now can treat selected columns
  to be part of the key. Error messages were improved.
  thanks to Thomas Waser

## Other News

- We added a tutorial about securing the integrity and confidentiality of configuration values,
  thanks to Peter Nirschl
- Peter Nirschl finished his [thesis](https://www.libelektra.org/ftp/elektra/publications/nirschl2018cryptographic.pdf)
  ([signature](https://www.libelektra.org/ftp/elektra/publications/nirschl2018cryptographic.pdf.sig)).
  It includes a benchmark of different cryptographic providers.
- Markus Raab gave a [talk](https://cfp.linuxwochen.at/de/LWW18/public/events/798) at Linuxwochen Wien (in German).
  For similar talks in English, please refer to the [FOSDEM talks](https://fosdem.org/2018/schedule/speaker/markus_raab/).
- We replaced the word "project" to "initiative"  in the [Code of Conduct](https://www.libelektra.org/devgettingstarted/code-of-conduct) (project has per definition an end date).

## Documentation

We improved the documentation in the following ways:

- FAQ was extended by [Why do I need Elektra if I already use configuration management tools?](https://www.libelektra.org/docgettingstarted/faq)
- Documentation about the recommended [environment](https://www.libelektra.org/devgettingstarted/testing) for test runs were added
- uniformly add `.` at end of short help
- Logo for Doc Set was added and logo for favicon was updated,
  thanks to René Schwaiger
- template of design decisions was updated to use the words
  problem (instead of issue) and rationale (instead of argument).
- [METADATA.ini](https://www.libelektra.org/docgettingstarted/meta-specification):
  - added visibility (as used in Web UI)
  - added type (only check/type existed)
  - plenty of metadata is now used by Web UI
- update docu for type plugin that `check/type/min` and  `check/type/max` are deprecated
- Fixed various spelling mistakes,
  thanks to René Schwaiger
- Document limitations of resolver (kdbOpen fails if no home directory found)
  and json/yaml plugins (intermixing of array and objects not detected, which is possible
  in Elektra but impossible in JSON)
- Required environment to run tests is documented.
- A decision about [deferred plugin calls](https://master.libelektra.org/doc/decisions/deferred_plugin_calls.md) has been made and implemented,
  thanks to Thomas Wahringer.


## Compatibility

As always, the ABI and API of kdb.h is fully compatible, i.e. programs
compiled against an older 0.8 version of Elektra will continue to work
(ABI) and you will be able to recompile programs without errors (API).

We removed:

- the not used error code `12` from `kdb mv` from docu

We changed:

- `kdb get`, `kdb mv` and `kdb cp` now use error code `11` if keys are not found
- cascading keys as arguments to `kdb cp` and `kdb mv` now fail instead
  of doing something unexpected, thanks to René Schwaiger for reporting

Shell scripts:

- cp and mv no longer accept cascading keys.


## Notes for Maintainer

These notes are of interest for people maintaining packages of Elektra:

- Docu is updated that [cmake3](https://cmake.org/cmake/help/v3.0/) is required.
  thanks to Lukas Winkler for reporting.
- To run all tests successfully, the `spec` and `list` plugin is required.
  So if `ENABLE_TESTING` is checked, cmake checks the presence of a storage,
  a resolver, the list and the spec plugin,
  thanks to René Schwaiger
- Tests no longer clear environment or reset locales.
  This fixes lua and dbus problems but might cause problems if TMPDIR is set,
  thanks to Lukas Winkler
- This will be the last release supporting Debian Wheezy
  (LTS support will stop in May).
  Directly after the release, Jessie (oldstable) with gcc 4.8.4 will
  be the oldest supported platform.

We added:

- the private headerfiles `kdbnotificationinternal.h`, `kdbioplugin.h`.
- the headerfiles `kdbio_glib.h` and `kdbio_uv.h`
- the plugin `libelektra-dbusrecv.so`
- the scripts `build-web`, `run-elektrad`, and `run-web`
- the test case `testmod_dbusrecv`
- the constant `ENABLE_ASAN` in the constants plugin
- several man pages such as: `kdb-run-elektrad.1` and `kdb-run-web.1`

We removed:

- `Base64.pdf` is not installed anymore
- doxygen-generated man pages such as: `doc_docker_jenkinsnode_README_md.3elektra`,
  `doc_docker_README_md.3elektra`, and `doc_vagrant_README_md.3elektra`


## Website

The website is generated from the repository, so all information about
plugins, bindings and tools are always up to date. Furthermore, we changed:

- Error page that is shown if no JavaScript is enabled now more clearly
  says that the Website only renders content from the repo and
  only contains free JavaScript.
- The [FAQ](https://www.libelektra.org/docgettingstarted/faq) is now
  more visible (added to "getting started").
- The [Code of Conduct](https://www.libelektra.org/devgettingstarted/code-of-conduct)
  was added.


## Notes for Elektra's Developers

These notes are of interest for people developing Elektra:

- `. run_dev_env` is a script to be sourced from the build directory.
  It sets environment variables, so that Elektra from the build
  directory is used (instead of the installed one).
- All current versions of Clang-Format (6.0+) and the outdated Clang-Format 5 will now produce exactly the same output for the whole codebase,
  thanks to René Schwaiger.
- To make enums nicely formatting, make sure at least one member
  is documented.
- You can now add a [Markdown Shell Recorder][] test for a plugin
  via the CMake function `add_plugin` by adding `TEST_README`.
  Furthermore `TEST_REQUIRED_PLUGINS` allows us to specify which
  additional plugins are required,
  thanks to René Schwaiger
- `const` was added to exceptions in catch blocks
  thanks to René Schwaiger
- We now mention to read [doc/DESIGN.md](https://master.libelektra.org/doc/DESIGN.md)
  in the contributing guidelines.
- The CMake functions

   - `add_plugin`
   - `add_msr_test`
   - `add_msr_test_plugin`, and the new
   - `add_shell_recorder_test`

    now allow you to specify a list of required plugins for [Shell Recorder][] and
   Markdown Shell Recorder tests.
- The [Markdown Shell Recorder][] now compares the whole output of `stderr` with the text following the directive `STDERR:`,
  thanks to René Schwaiger
- You can now leave the text following the directive `STDERR:` in a [Markdown Shell Recorder][] test empty:

   ```sh
   true # Print nothing to `stderr`
   # STDERR:
   ```

   . The Markdown Shell Recorder will then check if the command printed nothing to the standard error output.
- The [Shell Recorder][] now also prints the content of the protocol file if a test was unsuccessful or you used the command switch `-p`,
  and always cleans up the protocol,
  thanks to René Schwaiger
- We added an [Markdown Shell Recorder][] test for the [Constants](http://libelektra.org/plugins/constants) plugin.
- The [Markdown Shell Recorder][] now prints the path of the test file.
  thanks to René Schwaiger
- The Haskell binding now explicitly requires GHC installed with a minimum version of 8.0.0 during cmake
  thanks to René Schwaiger and Lukas Winkler
- If any of the tests in `make run_memcheck` fail valgrind will now set an exit-code which will get picked up by make,
  thanks to Lukas Winkler
- We introduced git reference repositories to save I/O on our build system,
  thanks to Lukas Winkler
- Set `LD_LIBRARY_PATH` in all tests removing the need to specify it for running ctest,
  thanks to Lukas Winkler
- Provide the `RUN_SERIAL` property to all tests that can not be run in parallel,
  thanks to Lukas Winkler
- Speeding up your test runs via `ctest -j` is now possible,
  thanks to Lukas Winkler
- We now disable the [Xerces plugin](http://libelektra.org/plugins/xerces) if you use GCC with enabled ASAN to build Elektra. This update
  makes sure that you do not build the plugin with compilation settings that are known to
  [cause problems](https://github.com/ElektraInitiative/libelektra/issues/1895).
- Documentation and debugging capabilities of [Markdown Shell Recorder][] were improved.
- We added style guidelines for CMake code to
   [`doc/CODING.md`](https://github.com/ElektraInitiative/libelektra/blob/master/doc/CODING.md#cmake-guidelines).

[Markdown Shell Recorder]: https://master.libelektra.org/tests/shell/shell_recorder/tutorial_wrapper
[Shell Recorder]: https://master.libelektra.org/tests/shell/shell_recorder


## Fixes

Many problems were resolved with the following fixes:

- [YAML CPP](http://libelektra.org/plugins/yamlcpp) now also saves key values directly below a mountpoint correctly,
  thanks to René Schwaiger
- If you use a minimal configuration ([`dump`](http://libelektra.org/plugins/dump), [`resolver`](https://www.libelektra.org/plugins/resolver), list, and spec), all test of the test suite now finish successfully again,
  thanks to René Schwaiger
- small refactoring in `kdb-test`
- The Haskell plugin failed to build if the Haskell bindings were not included explicitly by name.
- Fix invalid handling of keynames in the [spec](http://libelektra.org/plugins/spec) plugin.
- The [Shell Recorder][] counts the number of executed tests properly again.
- CMake now fails if the required plugins [list](http://libelektra.org/plugins/list) or [spec](http://libelektra.org/plugins/spec) (on
   non-[MinGW](http://mingw.org) platforms) are missing from the current build configuration.
- The [Lua](http://libelektra.org/plugins/lua), [Python 2](http://libelektra.org/plugins/python2),
  [Python](http://libelektra.org/plugins/python), and [Ruby](http://libelektra.org/plugins/ruby) plugins now require SWIG bindings for
  the corresponding programming language,
  thanks to René Schwaiger
- The [type checker](https://www.libelektra.org/plugins/type) now also honors `type` next to `check/type`
- Fix various compiler warnings
- The detection of Botan, Libgcrypt, LibGit2 and OpenSSL now also works properly, if we treat warnings as errors (compiler switch `-Werror`),
  thanks to René Schwaiger
- The [multifile plugin](http://libelektra.org/plugins/multifile) now passes the child config
  to the storage plugins too and also handles symlinks correctly,
  thanks to Thomas Waser


## Workshop

[Elektra Initiative](https://www.libelektra.org/developers/authors) are the people behind Elektra.
Our goal is to build up expertise with configuration settings and improve the situation in the FLOSS landscape.
To learn more about the needs of configuration-wise non-trivial FLOSS applications, we have workshops.
After a successful workshop with the LCDproc's maintainer, the next Workshop will be with people from KDE.

We will use the opportunity of [Akademy](https://akademy.kde.org/2018) being in Vienna.
We already got positive feedback from kconfig maintainers (David Faure and Aleix Pol).

If you are interested, you can [sign up](https://dudle.inf.tu-dresden.de/config_workshop_akademy/).
We are looking forward to an informative, interactive and interesting workshop!


## Outlook

We are currently working on following topics:

- Klemens Böswirth: [elektrifying LCDproc](https://www.libelektra.org/news/elektrify-lcdproc)
  After some setbacks (the two original developers who wanted to work on LCDproc resigned because of job duties)
  LCDproc development restarted now successfully.
  The new plan is to have more intermediate stages.
  In particular the first integration will be a minimal invasive integration without high-level API.
- Armin Wurzinger: type system for Elektra's specification language
- Anton Hössl: Puppet
- Daniel Bugl: Web UI
- Hani Torabi Makhsos: reduce community entry barriers
- Kurt Micheli: order preserving minimal perfect hash map
- Lukas Winkler: continous integration
- Mihael Pranjić: mmap plugin (i.e. avoiding reparsing of configuration files)
- Peter Nirschl: integrity and confidentiality
- René Schwaiger: parsing techniques
- Thomas Wahringer: notification techniques
- Thomas Waser: Linux distribution based on Elektra
- Ulrike Schaefer: generate shell completion files from Elektra's specification
- Vanessa Kos: misconfiguration bug database
- We created a proof of concept for a Chef resource and an Ansible module successfully setting Elektra's keys.
  They are not yet published.  If you are interested on this preliminary work, please contact us.


## Get It!

You can download the release from [here](https://www.libelektra.org/ftp/elektra/releases/elektra-0.8.23.tar.gz)
or [GitHub](https://github.com/ElektraInitiative/ftp/blob/master/releases/elektra-0.8.23.tar.gz?raw=true)


The [hashsums are:](https://github.com/ElektraInitiative/ftp/blob/master/releases/elektra-0.8.23.tar.gz.hashsum?raw=true)

- name: elektra-0.8.23.tar.gz
- size: 5870069
- md5sum: 0a065ed381a59b6213bd46fd3c82ba83
- sha1: 0727b420ff721e654b0ba6ab1d0c78e5e2341d26
- sha256: f1d3cd4888ba3ef47c1327cbddf21dff7be289f94217f12e5e93105273ca6c48

The release tarball is also available signed by Markus Raab using GnuPG from
[here](https://www.libelektra.org/ftp/elektra/releases/elektra-0.8.23.tar.gz.gpg) or
[GitHub](https://github.com/ElektraInitiative/ftp/blob/master/releases//elektra-0.8.23.tar.gz.gpg?raw=true)

Already built API-Docu can be found [online](https://doc.libelektra.org/api/0.8.23/html/)
or [GitHub](https://github.com/ElektraInitiative/doc/tree/master/api/0.8.23).


## Stay tuned!

Subscribe to the
[RSS feed](https://www.libelektra.org/news/feed.rss)
to always get the release notifications.

For any questions and comments, please contact the
issue tracker [on GitHub](http://issues.libelektra.org)
or Markus Raab by email using elektra@markus-raab.org.

[Permalink to this NEWS entry](https://www.libelektra.org/news/0.8.23-release)

For more information, see [https://libelektra.org](https://libelektra.org)

Best regards,
[Elektra Initiative](https://www.libelektra.org/developers/authors)





# 0.8.24 Release

This release did not happen yet.

- guid: 889b700d-9eac-4eff-9a3d-f6fb15c3d9da
- author: Markus Raab
- pubDate: Sat, 18 Aug 2018 18:13:40 +0200
- shortDesc:

We are proud to release Elektra 0.8.24.

Number commits: 1734
      1 Author: Mihael Pranjic <mpranj@limun.org>
      1 Author: Peter Nirschl <petermax2@users.noreply.github.com>
      2 Author: Michael Zronek <Michael.Zronek@gmail.com>
      2 Author: Thomas Waser <thomas.waser@libelektra.org>
      4 Author: René Schwaiger <sanssecours@me.com>
      5 Author: Michael Zronek <michael.zronek@gmail.com>
     12 Author: Kurt Micheli <e1026558@student.tuwien.ac.at>
     16 Author: Peter Nirschl <peter.nirschl@gmail.com>
     21 Author: Klemens Böswirth <k.boeswirth+git@gmail.com>
     22 Author: winlu <derwinlu+git@gmail.com>
     96 Author: Markus Raab <elektra@markus-raab.org>
    101 Author: markus2330 <markus2330@users.noreply.github.com>
    102 Author: Thomas Wahringer <thomas.wahringer@libelektra.org>
    117 Author: Daniel Bugl <me@omnidan.net>
    243 Author: derwinlu <derwinlu+git@gmail.com>
    249 Author: e1528532 <e1528532@student.tuwien.ac.at>
    740 Author: René Schwaiger <sanssecours@me.com>
 792 files changed, 27677 insertions(+), 39176 deletions(-)

## What is Elektra?

Elektra serves as a universal and secure framework to access
configuration settings in a global, hierarchical key database.
For more information, visit [https://libelektra.org](https://libelektra.org).

For a small demo see here:

[![asciicast](https://asciinema.org/a/cantr04assr4jkv8v34uz9b8r.png)](https://asciinema.org/a/cantr04assr4jkv8v34uz9b8r)

You can also read the news [on our website](https://www.libelektra.org/news/0.8.24-release)



## Highlights

- Type system prototype
- Chef Cookbook
- Elektra Web 1.6
- Notifications

### Type system prototype

Elektra supports specifying the semantics of keys via metakeys in the `spec`
namespace. An example is the metakey `check/range` which can be used to specify
that a key only holds numbers in a given range. Another metakey is `check/enum`
which only allows specific keywords to be the content of a key. Up to now these
semantics are being checked at runtime. Therefore a type system was developed to
be able to check configuration specifications statically. As an example, it
would detect when one accidentally adds both a range and an enum check if their
possible contents are not compatible with each other.

The type system is available as a plugin that gets mounted along with a
configuration specification into the spec namespace. Furthermore we include a
set of type definitions for commonly used metakeys such as `check/range`,
`check/enum`, `check/validation`, `fallback` or `override`.

For more details see the
[typechecker readme](https://www.libelektra.org/plugins/typechecker)

Thanks to Armin Wurzinger.


### Chef Cookbook

Next to the [Puppet Resource Type](http://puppet.libelektra.org/)
we now also prepared a [Chef Cookbook](https://supermarket.chef.io/cookbooks/kdb)
which allows us to use Elektra from within chef.

For example, to set mount a configuration file, you can use:

```
kdbmount 'system/hosts' do
	file '/etc/hosts'
	plugins 'hosts'
	action :create
end
```

And to add an hosts entry, you can use:

```
kdbset '/hosts/ipv4/showthatitworks' do
	namespace 'system'
	value '127.0.0.33'
	action :create
end
```

> Note that currently `kdb` is invoked
> and Elektra needs to be installed for
> managed systems.

Thanks to Michael Zronek and Vanessa Kos.


### Elektra Web 1.6

The new release of Elektra Web features many UX improvements from the usability test!

[![Elektra Web 1.6 video](https://img.youtube.com/vi/lLg9sk6Hx-E/0.jpg)](https://www.youtube.com/watch?v=lLg9sk6Hx-E)

Try it out now on: http://webdemo.libelektra.org/

1.5 changelog:

- search completely reworked - it does not act as a filter on already opened keys anymore, and instead searches the whole key database - feedback from the search was also greatly improved (pulsating while searching, glowing blue when done)
- added "abort" buttons to dialogs to revert actions
- added "create array" button to easily create arrays
- removed confirmation dialog before deletion (undo can be used instead)
- created a docker image: `elektra/web`
- implemented auto-deployment of webdemo.libelektra.org
- small fixes:
  - updated visibility levels
  - removed "done" button in main view
  - fixed issues with the opener click area
  - remove metakeys when they are set to the default value or empty/0
  - improved keyboard support
  - fixed many small issues (#2037)

1.6 changelog:

- fixed bugs related to arrays (#2103)
- improved performance of search for many results
- added 404 page for invalid instance ids
- implement drag & copy by holding the Ctrl or Alt key
- add button to show error details
- allow deleting all keys in a namespace

Thanks to Daniel Bugl.


### Notifications

Elektra's notification feature which allows applications to keep persistent
configuration settings in sync with the key database and other applications was
greatly improved with this release:

- The [notification API](https://doc.libelektra.org/api/current/html/group__kdbnotification.html)
  now supports more types and has improved support for callbacks.
- With the addition of the [zeromqsend](https://www.libelektra.org/plugins/zeromqsend)
  and [zeromqrecv](https://www.libelektra.org/plugins/zeromqrecv) plugins
  together with the [hub-zeromq](https://www.libelektra.org/tools/hub-zeromq)
  tool we have an alternative to the D-Bus transport plugins
  ([dbus](https://www.libelektra.org/plugins/dbus) and
  [dbusrecv](https://www.libelektra.org/plugins/dbusrecv)).
- The new asynchronous I/O binding for [ev](https://www.libelektra.org/bindings/io_ev)
  is the third I/O binding - so notifications can be used in applications using
  [glib](https://www.libelektra.org/bindings/io_glib), [uv](https://www.libelektra.org/bindings/io_uv)
  or [ev](https://www.libelektra.org/bindings/io_ev).
  If your application uses a different library please check out the
  ["How to create your own I/O binding" section](https://www.libelektra.org/tutorials/notifications#how-to-create-your-own-i-o-binding) in the [notification tutorial](https://www.libelektra.org/tutorials/notifications).
- Notifications can be used to reload KDB after Elektra's configuration (e.g.
  mountpoints or globally mounted plugins) has changed.
  We added a [how-to to the notification tutorial](https://www.libelektra.org/tutorials/notifications#howto-reload-kdb-when-elektras-configuration-has-changed)
  that explains the required steps and the ["notificationReload"](https://www.libelektra.org/examples/notificationreload) example with the complete code.

More details can be [found](#zeromq-transport-plugins) [in](#misc) [this](#bindings) [news](#notifications).
Check out the updated [notification tutorial](https://www.libelektra.org/tutorials/notifications)
and notification examples ([polling](https://www.libelektra.org/examples/notificationpolling),
[async](https://www.libelektra.org/examples/notificationasync) and
[reload](https://www.libelektra.org/examples/notificationreload).

## Plugins

### CCode

- We fixed various warnings in the source code reported by [OCLint](http://oclint.org). *(René Schwaiger)*
- The plugin now also encodes and decodes key names in addition to key values. *(René Schwaiger)*

### CPP Template

- We added a new [template for C++ based plugins](https://www.libelektra.org/plugins/cpptemplate). To create a plugin based on this
  template, please use the command

  ```sh
  scripts/copy-template -p pluginname
  ```

  , where `pluginname` specifies the name of your new plugin. *(René Schwaiger)*

### Crypto

- The `crypto` plugin now uses Elektra's `libinvoke` and the `base64` plugin in order to encode and decode Base64 strings. This improvement reduces code duplication between the two plugins. *(Peter Nirschl)*

### CSVStorage

- Changed behaviour of export to validate the structure of exported keys only. *(Thomas Waser)*

### Directory Value

- We rewrote the plugin using C++. *(René Schwaiger)*
- [Directory Value](https://www.libelektra.org/plugins/directoryvalue) now also supports nested arrays. *(René Schwaiger)*
- The plugin now also adds leafs for a key, if its value is null or the empty string. *(René Schwaiger)*

### fcrypt

- The `fcrypt` plugin will consider the environment variable `TMPDIR` in order to detect its temporary directory. See [#1973] *(Peter Nirschl)*

### fstab

- The `fstab` plugin now passes tests on musl builds. *(Lukas Winkler)*

### Haskell

- An issue when building Haskell plugins with a cached sandbox is fixed in case
  a Haskell library bundled with elektra gets changed. *(Armin Wurzinger)*
- The [script](https://master.libelektra.org/scripts/generate-haskell-dependencies) that generates the list of haskell dependencies now also works on
  ghc8.0.1 and older cabal versions. Furthermore one can specify the build directory as
  a parameter if it is not located within the source directory. *(Armin Wurzinger)*

### Interpreter Plugins

- The plugins Ruby, Python and Jni can now also be mounted as global plugin.
- Fix crashes in global Python plugin by using pluginprocess. *(Markus Raab and Armin Wurzinger)*
- Python plugin can now shutdown properly again *(Markus Raab)*

### JNI

- We now disable the plugin if  `BUILD_STATIC` or `BUILD_FULL` are enabled, since otherwise the plugin breaks the `kdb` tool.
  *(René Schwaiger)*
- We disabled the internal check (`testscr_check_kdb_internal_check`) for the plugin, since it always fails. *(René Schwaiger)*

### HexNumber

- The plugin [hexnumber](https://www.libelektra.org/plugins/hexnumber) has been added. It can be used
  to convert hexadecimal values into decimal when read, and back to hexadecimal when written. *(Klemens Böswirth)*

### List

- The [`list` plugin](http://libelektra.org/plugins/list) now allows us to pass
  common configuration for all plugins by using keys below the "config/" setting.
  The updated plugin documentation contains more information and an example. *(Thomas Wahringer)*
- The [`list` plugin](http://libelektra.org/plugins/list) which is responsible
  for global mounting had a bug which prevented globally mounted plugins from
  being configurable. *(Thomas Wahringer)*

### mINI

- We fixed a memory leak in the [mINI plugin](https://libelektra.org/plugins/mini) by requiring the plugin
  [`ccode`](https://libelektra.org/plugins/ccode) instead of the “provider” `code`. *(René Schwaiger)*
- Removed unused header files. *(René Schwaiger)*

### network

- Fixed an error in network plugin that prevented it from working on non glibc
    platforms. *(Lukas Winkler)*

### Regex Dispatcher

- The plugin [regexdispatcher](https://www.libelektra.org/plugins/regexdispatcher) has been added.
  It calculates regex representations for commonly used specification keywords to be used with the
  [typechecker](https://www.libelektra.org/plugins/typechecker). Currently the keywords `check/range`,
  `check/enum` and `default` are supported. *(Armin Wurzinger)*

### Type

- We extended the [Markdown Shell Recorder][] example inside the [ReadMe of the plugin](https://www.libelektra.org/plugins/type).
  *(René Schwaiger)*

### Typechecker

- The plugin [typechecker](https://www.libelektra.org/plugins/typechecker), used to validate
  configuration specifications for Elektra statically, has been improved under the hood. It now
  supports a more concise and efficient typechecking process including a greatly
  improved type inference scheme that should make generated specification files and thus
  generated errors to be easier to understand. An example of such error message is shown in the
  [readme](https://www.libelektra.org/plugins/typechecker). *(Armin Wurzinger)*

### Tcl

- The [`tcl`](http://libelektra.org/plugins/tcl) plugin does not fail anymore, if its configuration file does not exist and you try to
  retrieve the plugin contract. *(René Schwaiger)*
- The plugin now uses relative key names. This update addresses issue [#51](https://issues.libelektra.org/51). *(René Schwaiger)*

### YAJL

- The [YAJL Plugin](http://libelektra.org/plugins/yajl) now uses the internal logger functionality instead of `printf` statements.
  *(René Schwaiger)*
- We fixed a problem with negative values reported by the
  [UndefinedBehaviorSanitizer](https://clang.llvm.org/docs/UndefinedBehaviorSanitizer.html). *(René Schwaiger)*

### YAML CPP

- The plugin does not save empty intermediate keys anymore. The example below shows the old and the new behavior of the plugin:

   ```sh
   # Mount plugin
   kdb mount config.yaml /tests/yamlcpp yamlcpp
   # Store single key-value pair
   kdb set /tests/yamlcpp/level1/level2/level3 value

   # Old behavior
   kdb ls /tests/yamlcpp
   #> user/tests/yamlcpp/level1
   #> user/tests/yamlcpp/level1/level2
   #> user/tests/yamlcpp/level1/level2/level3

   # New behavior
   kdb ls /tests/yamlcpp
   #> user/tests/yamlcpp/level1/level2/level3
   ```
   . *(René Schwaiger)*

- [YAML CPP](http://libelektra.org/plugins/yamlcpp) now requires at least `yaml-cpp 0.6`, since the current
  [MSR test for the plugin](https://master.libelektra.org/src/plugins/yamlcpp/README.md) triggers two bugs:

  - https://github.com/jbeder/yaml-cpp/issues/247
  - https://github.com/jbeder/yaml-cpp/issues/289

  in earlier versions of the [yaml-cpp library](https://github.com/jbeder/yaml-cpp). *(René Schwaiger)*

- The plugin does now support [arrays](https://www.libelektra.org/tutorials/arrays) containing empty fields. *(René Schwaiger)*
- YAML CPP now also adds `array` meta data for arrays containing arrays. *(René Schwaiger)*
- The plugin now also supports empty arrays:

  ```sh
  kdb mount test.yaml user/tests/yamlcpp yamlcpp
  kdb setmeta user/tests/yamlcpp/array array ''
  kdb export user/tests/yamlcpp/array yamlcpp
  #> []
  ```

  .

- YAML CPP now handles null values containing meta data properly:

   ```sh
   kdb mount test.yaml user/tests/yamlcpp yamlcpp
   kdb set user/tests/yamlcpp/null
   kdb setmeta user/tests/yamlcpp/null comment 'Null Key'
   kdb export user/tests/yamlcpp/null yamlcpp
   #> !<!elektra/meta>
   #> - ~
   #> - comment: Null Key
   ```
   .

### YAML Smith

- [YAML Smith](http://libelektra.org/plugins/yamlsmith) is a plugin that converts Elektra’s `KeySet` data structure to a textual
  representation in the [YAML][] serialization format. The plugin is currently in a **very early stage of development**. Please be advised,
  that it is quite likely that the plugin will produce incorrect or even invalid YAML data, especially if your `KeySet` contains special
  characters.

### Yan LR

- The experimental [Yan LR plugin](http://libelektra.org/plugins/yanlr) uses a parser, generated by [ANTLR](http://www.antlr.org) to read
  basic [YAML][] data. The plugin only converts YAML data to Elektra’s `KeySet` data structure. If you want to write data in the YAML
  format please take a look at the [YAML Smith plugin](http://libelektra.org/plugins/yamlsmith). *(René Schwaiger)*

### ZeroMQ transport plugins

- New notification transport plugins for [ZeroMQ](http://zeromq.org/) were added.
  The new ["zeromqsend"](https://www.libelektra.org/plugins/zeromqsend) and ["zeromqrecv"](https://www.libelektra.org/plugins/zeromqrecv) plugins use
  `ZMQ_PUB` and `ZMQ_SUB` sockets to send and receive notifications.
  The plugins can be used instead or along with the
  ["dbus"](https://www.libelektra.org/plugins/dbus) and
  ["dbusrecv"](https://www.libelektra.org/plugins/dbusrecv) transport plugins.
  Check out the
  [plugin documentation](https://www.libelektra.org/plugins/zeromqrecv) for more
  information. *(Thomas Wahringer)*

### Misc

- The logging plugins ["syslog"](https://www.libelektra.org/plugins/syslog),
  ["journald"](https://www.libelektra.org/plugins/journald) and
  ["logchange"](https://www.libelektra.org/plugins/logchange) now have a new
  option called "get" which can be enabled to log which configuration settings
  are loaded by applications.
  The new option can be used for logging application behavior when using
  [notifications](https://www.libelektra.org/tutorials/notifications). *(Thomas Wahringer)*
- Do not exclude `simpleini` silently on non-glibc systems but output a message
  like for other plugins *(Markus Raab)*
- We updated the `infos/status` clause of the following plugins:

  - [`boolean`](http://libelektra.org/plugins/boolean),
  - [`constants`](http://libelektra.org/plugins/constants),
  - [`csvstorage`](http://libelektra.org/plugins/csvstorage),
  - [`hexnumber`](http://libelektra.org/plugins/hexnumber),
  - [`internalnotification`](http://libelektra.org/plugins/internalnotification),
  - [`ruby`](http://libelektra.org/plugins/ruby),
  - [`simpleini`](http://libelektra.org/plugins/simpleini),
  - [`uname`](http://libelektra.org/plugins/uname), and
  - [`xerces`](http://libelektra.org/plugins/xerces)

  . *(René Schwaiger)*

[YAML]: http://yaml.org


## Libraries

### Core

### General

- replaced strdup with elektraStrDup (for C99 compatibility) *(Markus Raab)*
- You can now remove the basename of a key via the C++ API by calling `key.delBaseName()`. *(René Schwaiger)*
- The function `elektraArrayGetNextKey` now uses `NULL` instead of the empty string as init value for the returned key. *(René Schwaiger)*
- <<TODO>>
- <<TODO>>
- <<TODO>>

### pluginprocess

- The library [`pluginprocess`](http://master.libelektra.org/src/libs/pluginprocess) that is used to
  execute plugins run inside own processes has been improved. This is useful as some plugins like
  haskell-based plugins or [`python`](http://libelektra.org/plugins/python) can only be started once
  inside a single process, while libelektra may call a plugin several times. The library now uses an
  improved communication protocol that separates between pluginprocess-related data and keysets
  passed to plugins. This avoids any possible name clashes between keys used by a plugin and keys
  used by pluginprocess.
  The documentation of the plugin has been improved as well, some mistakes were corrected and it
  should be more clear how to store plugin data besides pluginprocess's data structure.
  Tests have been added to the library to ensure its correct functionality. *(Armin Wurzinger)*
- Anonymous pipes are now used instead of named pipes for the communication as anonymous pipes get
  terminated by the OS in case a child process dies before writing back data to the parent.
  Currently the parent process will freeze otherwise attempting to read from the child. *(Armin Wurzinger)*

## Bindings

- A new I/O binding for [ev](https://www.libelektra.org/bindings/io_ev) has been
  added.
  It can be used to integrate the notification feature with applications based
  on [ev](http://libev.schmorp.de) main loops. *(Thomas Wahringer)*

## Notifications

- The
  [notification API](https://doc.libelektra.org/api/current/html/group__kdbnotification.html)
  was extended.
  The API now supports more types: `int`, `unsigned int`,
  `long`, `unsigned long`, `long long`, `unsinged long long`, `float` and `double`.
  It also supports all of Elektra's `kdb_*_t` types defined in `kdbtypes.h`.
  Also contexts for callbacks were added and
  `elektraNotificationRegisterCallbackSameOrBelow()` allows for notifications
  for the registered key or below. *(Thomas Wahringer)*

## Tools

- The new tool `kdb find` lists keys of the database matching a certain regular expression. *(Markus Raab)*
- You can now build the [Qt-GUI](https://www.libelektra.org/tools/qt-gui) using Qt `5.11`. *(René Schwaiger)*

## Scripts

- The script [`check_formatting.sh`](https://master.libelektra.org/tests/shell/check_formatting.sh) now also checks the formatting of CMake
  code if you installed [`sponge`](https://joeyh.name/code/moreutils) and [`cmake-format`][]. *(René Schwaiger)*
- The script [`check_formatting.sh`](https://master.libelektra.org/tests/shell/check_formatting.sh) now no longer writes to stdout if clang-format5.0
    can not be found. *(Lukas Winkler)*
- The script [`check_bashisms.sh`](https://master.libelektra.org/tests/shell/check_bashisms.sh) should now work correctly again, if the
  system uses the GNU version `find`. *(René Schwaiger)*
- The script [`reformat-cmake`](https://master.libelektra.org/scripts/reformat-cmake) now checks if `cmake-format` works before it reformats CMake files. Thank you to Klemens Böswirth for the [detailed description of the problem](https://github.com/ElektraInitiative/libelektra/pull/1903#discussion_r189332987). *(René Schwaiger)*
- `scripts/run_icheck` now no longer leaves the base directory of the project
  when checking if the ABI changed. *(Lukas Winkler)*
- The completion for [fish](http://fishshell.com) now also suggest the `info/` meta attributes of the
  [file plugin](https://www.libelektra.org/plugins/file). *(René Schwaiger)*

### Copy Template

- The script [`copy-template`](https://master.libelektra.org/scripts/copy-template) is now location independent. It will always create a
  new plugin in `src/plugins`. *(René Schwaiger)*
- The command now also supports the new [template for C++ based plugins](https://www.libelektra.org/plugins/cpptemplate). Please use the
  command line switch `-p` to create a new plugin based on `cpptemplate`.

[`cmake-format`]: https://github.com/cheshirekow/cmake_format

## Documentation

- We improved the formatting of our [compilation guide](/doc/COMPILE.md). *(René Schwaiger)*
- We fixed various minor spelling mistakes in the documentation. *(René Schwaiger)*
- The man pages for [`kdb change-resolver-symlink`](https://www.libelektra.org/manpages/kdb-change-resolver-symlink) and
   [`kdb change-storage-symlink`](https://www.libelektra.org/manpages/kdb-change-storage-symlink) referenced the wrong command.
   *(Lukas Winkler, René Schwaiger)*
- We added documentation for our build system in
    [BUILDSERVER.md](https://master.libelektra.org/doc/BUILDSERVER.md).
    *(Lukas Winkler)*
- The documentation for `kdb` and `kdb set` now mentions the `--` argument that stops processing of command line switches. This is useful
  for setting negative values among other things. *(Klemens Böswirth)*
- We added a new tutorial about the jna binding. The tutorial shows how to use the java library to interact with kdb *(Michael Zronek)*
- GitHub now detects the license of the repository correctly again. *(René Schwaiger)*
- We added a tutorial describing Elektra’s [array data type](https://www.libelektra.org/tutorials/arrays). *(René Schwaiger)*


## Tests

### (Markdown) Shell Recorder

- We added new [Markdown Shell Recorder][] tests for the
  - [`ccode`](https://www.libelektra.org/plugins/ccode),
  - [`file`](https://www.libelektra.org/plugins/file),
  - [`iconv`](https://www.libelektra.org/plugins/iconv),
  - [`ni`](https://www.libelektra.org/plugins/ni),
  - [`rename`](https://www.libelektra.org/plugins/rename), and
  - [`uname`](https://www.libelektra.org/plugins/uname)
  plugin. *(René Schwaiger)*
- (Markdown) Shell Recorder tests now save test data below `/tests` (see issue [#1887][]). *(René Schwaiger)*
- The Markdown Shell Recorder checks `kdb set` commands to ensure we only add tests that store data below `/tests`. *(René Schwaiger)*
- The Markdown Shell Recorder now supports indented code blocks. *(René Schwaiger)*
- The Markdown Shell Recorder now also tests if a command prints nothing to `stdout` if you add the check `#>`. *(René Schwaiger)*
- We fixed some problems in the [Markdown Shell Recorder](https://master.libelektra.org/tests/shell/shell_recorder/tutorial_wrapper) test
  of [`kdb ls`](https://master.libelektra.org/doc/help/kdb-ls.md). *(René Schwaiger)*
- The [Shell Recorder][] now does not interpret `-` in checks as option character any more. *(René Schwaiger)*
- The `add_plugin` helper now respects `ENABLE_KDB_TESTING` when adding
    Markdown Shell Recorder tests. *(Lukas Winkler)*
- The Markdown Shell Recorder test for [`kdb find`](https://master.libelektra.org/doc/help/kdb-find.md) now removes the configuration file
  at the end of the test. *(René Schwaiger)*
- The [Shell Recorder][] now properly unmounts any additional mountpoints created
    during a test. *(René Schwaiger)*
- We removed the broken auto unmounting feature from the [Markdown Shell Recorder][]. *(René Schwaiger)*
- The [Markdown Shell Recorder][] does not require a `bash` compatible shell anymore. *(René Schwaiger)*

[#1887]: https://github.com/ElektraInitiative/libelektra/issues/1887
[Markdown Shell Recorder]: https://master.libelektra.org/tests/shell/shell_recorder/tutorial_wrapper
[Shell Recorder]: (https://master.libelektra.org/tests/shell/shell_recorder)

### General

- Plugins added with the flag `SHARED_ONLY` no longer get tested in the script `check_kdb_internal_check.sh` if executed with kdb-full or kdb-static. *(Armin Wurzinger)*
- Add `compare_regex_to_line_files` which allows to compare a file made of
    regex patterns to be compared with a text file line by line.
    *(Lukas Winkler)*
- The OPMPHM has a new test case *(Kurt Micheli)*
- Do not execute `fcrypt` and `crypto` unit tests if the `gpg` binary is not available. *(Peter Nirschl)*
- Resolved an issue where tests did not cleanup properly after they ran.
    This was especially noticeable for `gpg` tests as the `gpg-agents` that were
    spawned did not get cleaned up afterwards. *(Lukas Winkler)*
- We disabled the general plugin test (`testkdb_allplugins`) for the [`semlock` plugin](https://libelektra.org/plugins/mini), since the
  test reported [memory leaks](https://issues.libelektra.org/2113) on the latest version of Debian Unstable. *(René Schwaiger)*
- The [CFramework](https://master.libelektra.org/tests/cframework) macro `compare_keyset` now supports the comparison of two empty key sets. *(René Schwaiger)*
- The C++ version of the macro `exit_if_fail` now really exits the test progamm if the test fails. *(René Schwaiger)*
- The C++ testing framework now supports the macro `compare_keyset` that checks if two key sets are equal. *(René Schwaiger)*


## Build

Debian Wheezy is not supported anymore. As written in the previous release notes:
Jessie (oldstable) with gcc 4.8.4 is now the oldest supported platform.

### CMake

- The build system no longer installs Haskell dependencies from hackage by itself, instead
  this has to be done beforehand like it is the case with all other dependencies. The main
  reason is that the build servers shouldn't compile the dependencies over and over again,
  only if something changes. See the [readme](https://www.libelektra.org/bindings/haskell). *(Armin Wurzinger)*
- Plugins can be specified to be only built for `BUILD_SHARED` builds, but to be excluded
  from any `BUILD_FULL` or `BUILD_STATIC` builds using the new optional argument `ONLY_SHARED`
  for our cmake macro `add_plugin`. This way `BUILD_SHARED` can be combined with the other
  options without excluding such plugins. The cmake messages about plugin inclusion have
  been updated to indicate this behavior. This behavior has been applied for the Haskell
  plugins- and bindings as they currently don't support full or static builds. *(Armin Wurzinger)*
- We now import the current version of [Google Test][] as external project at configuration time using
   [DownloadProject](https://github.com/Crascit/DownloadProject). If you want to use a local installation of
   [Google Test][] instead, please set the value of `GTEST_ROOT` to the path of you local copy of the
   [Google Test][] framework. *(René Schwaiger)*
- The cmake variable `GTEST_ROOT` now respects the environment variable
  `GTEST_ROOT` if it is set. *(Lukas Winkler)*
- The build system does not install [Google Test][] anymore if you install Elektra. *(René Schwaiger)*
- We disabled the test `testlib_notification` on ASAN enabled builds, since Clang reports that the test leaks memory. *(René Schwaiger)*
- Disable Markdown Shell Recorder test `validation.md` for ASAN builds.
  It leaks memory and thus fails the test during spec mount. *(Lukas Winkler)*
- Haskell plugins and bindings are now correctly excluded when using `BUILD_FULL` or `BUILD_STATIC`
  as this is currently unsupported. Another issue when building Haskell plugins with a cached sandbox
  is fixed as well. *(Armin Wurzinger)*
- Fix compilation with `BUILD_TESTING=OFF` when `spec` or `list` plugins are not selected.
- Set coverage prefix to `PROJECT_SOURCE_DIR`, resulting in easier readable
    coverage reports. *(Lukas Winkler)*
- The functions `add_plugintest` and `add_plugin` now also support adding a C++ test instead of a C test. *(René Schwaiger)*
- The function `add_plugintest` now also supports setting environment variables for C/C++ based tests. *(René Schwaiger)*
- The build system now automatically detects Homebrew’s OpenSSL version on macOS. *(René Schwaiger)*
- We improved the automatic detection of Libgcrypt and OpenSSL. *(René Schwaiger)*
- Resolved an issue where cmake did not properly set test feature macros to detect and use libc functionality. *(Lukas Winkler)*
- Improve the detection of `ftw.h`, if the current build use the compiler switch `-Werror`. *(René Schwaiger)*
- We now ignore warnings about

  - zero size arrays (Clang),
  - variadic macros (Clang, GCC),
  - conversions to non-pointer type (GCC), and
  - attribute warnings (GCC),

  caused by code generated via [SWIG](http://www.swig.org) in the Ruby binding and plugin. *(René Schwaiger)*

[Google Test]: https://github.com/google/googletest

### Docker

- `clang-5.0` is now used for clang tests by the build system *(Lukas Winkler)*
- An additional build job on Ubuntu:xenial has been added *(Lukas Winkler)*
- `withDockerEnv` Jenkinsfile helper now no longer provides stages automatically. *(Lukas Winkler)*
- [Google Test][] is installed in Docker images used by the build system. *(Lukas Winkler)*

## Infrastructure

### Jenkins

- A build job checks if PRs modify the release notes. *(Markus Raab)*
- Several improvements to the build system have been implemented *(Lukas Winkler)*:
  - Better Docker image handling.
  - Abort of previously queued but unfinished runs on new commits.
  - Document how to locally replicate the Docker environment used for tests.
- The Jenkins build server now also compiles and tests Elektra with enabled address sanitizer. *(Lukas Winkler)*
- Add `STATIC` and `FULL` linked builds. *(Lukas Winkler)*
- Ported GCC ASAN build job to new build system *(René Schwaiger + Lukas Winkler)*
- Docker artifacts are now cleaned up in our daily build job. *(Lukas Winkler)*
- `clang` tests have been ported to the new build system *(Lukas Winkler et al)*
- `icheck` build server job has been ported to our new build system. *(Lukas Winkler)*
- Port `elektra-gcc-configure-debian-optimizations` to new build system. *(Lukas Winkler)*
- Port `elektra-gcc-configure-mingw-w64` to new build system. *(Lukas Winkler)*
- Port `debian-multiconfig-gcc-stable` to new build system. *(Lukas Winkler)*
- Port `elektra-ini-mergerequests` to new build system. *(Lukas Winkler)*
- Port `elektra-gcc-configure-debian-nokdbtest` to new build system. *(Lukas Winkler)*
- Port `elektra-gcc-configure-xdg`to new build system. *(Lukas Winkler)*
- Port `elektra-gcc-i386` to new build system. *(Lukas Winkler)*
- Port `elektra-gcc-configure-debian-musl` to new build system. *(Lukas Winkler)*
- Docker Registry is cleaned up by our daily buildserver task. *(Lukas Winkler)*
- Remove `elektra-gcc-configure-debian-nokdbtest` test. Instead we are now
    removing write permissions of Elektra's paths to detect if we write to the
    filesystem even though tests are not tagged as such. *(Lukas Winkler)*
- Remove `elektra-gcc-configure-debian-withspace` test. We now test for
    compatibility of spaced build paths during normal tests. *(Lukas Winkler)*
- Check for source formatting during early test stages. *(Lukas Winkler)*
- Remove the amount of spawned tests via not running a full multiconfig setup for
  the `PLUGINS=NODEP` config. They did not provide any additional coverage.
  Instead we added a new test checking if `PLUGINS=NODEP` builds in an minimal
  Docker image. *(Lukas Winkler)*
- Speed up coverage data upload. *(Lukas Winkler)*
- Fix an issue where file archiving did not happen because of suppressed shell
    expansion *(Lukas Winkler)*
- Setup mailing for jenkins *(Lukas Winkler)*
  - send mail to build@libelektra.org when `master` fails *(Lukas Winkler)*
  - parse change list into mail *(Lukas Winkler)*
  - do not send mails if pipeline run was aborted *(Lukas Winkler)*

### Travis

- Travis now uses the latest version of GCC and Clang to translate Elektra on Linux. *(René Schwaiger)*
- Our Travis build job now
  - builds all (applicable) bindings by default again, and
  - checks the formatting of CMake code via [`cmake-format`][]
  . *(René Schwaiger)*
- Some cache issues on the Travis build job for cached haskell sandboxes have been resolved. *(Armin Wurzinger)*
- Travis caches downloaded Homebrew packages to improve the reliability of macOS build jobs. *(René Schwaiger)*
- Travis is now using Xcode 9.4.1 on macOS 10.13 for most macOS build jobs. *(Mihael Pranjić)*
- We added a unique name to each build job, so you can see quickly which configuration caused problems. *(René Schwaiger)*
- We now specify custom binding, plugin and tool configuration for jobs via the environment variables:

  - `BINDINGS`,
  - `PLUGINS`, and
  - `TOOLS`

  . We also added environment variables for the build configuration options `BUILD_FULL`, `COMMON_FLAGS`, `ENABLE_ASAN` and the command
  used to test the build (`TEST_COMMAND`). *(René Schwaiger)*
- The ASAN build jobs `🍏 Clang ASAN` and `🐧 GCC ASAN` now only build the `kdb` tool and the `cpp` binding. This update ensures, that we
  do not hit the [job timeout for public repositories](https://docs.travis-ci.com/user/customizing-the-build/#build-timeouts) that often.
  *(René Schwaiger)*
- We now use the latest version of Ruby (`2.5.1`) to build and test the Ruby binding/plugin. *(René Schwaiger)*

## Compatibility

As always, the ABI and API of kdb.h is fully compatible, i.e. programs
compiled against an older 0.8 version of Elektra will continue to work
(ABI) and you will be able to recompile programs without errors (API).

Following changes were made:

- The C++ API was extended with `delBaseName()`.
  This does not affect ABI compatibility, also C++ programs compiled against 0.8.24 and using `delBaseName()` will work with Elektra 0.8.23 or older.
- `kdbtypes.h` now comes with support for C99 types
- We added the private headerfiles `kdbnotificationinternal.h`, `kdbioplugin.h`. *(Thomas Wahringer)*
- The I/O binding header files have been moved a new directory called `kdbio`.
  For example, instead of including `elektra/kdbio_ev.h` users of the binding now include `elektra/kdbio/ev.h`. *(Thomas Wahringer)*
- directoryvalue has changed its behavior, see above
- the list plugin changed its configuration, see above
- The yamlcpp plugin now gets excluded with too old versions of yamlcpp (Debian Stretch is affected)

New plugins:

- hexnumber
- yamlsmith
- zeromqrecv
- zeromqsend

New tool: kdb-find

## Website

The website is generated from the repository, so all information about
plugins, bindings and tools are always up to date. Furthermore, we changed:

- <<TODO>>
- <<TODO>>
- <<TODO>>

## Outlook

We are currently working on following topics:

- The hybrid search algorithm for the Key search `ksLookup (...)` is now in preparation.
  The preparation includes a new KeySet flag `KS_FLAG_NAME_CHANGE`, this flag will be used by the hybrid search.
  The hybrid search combines the best properties of the binary search and the [OPMPHM](https://master.libelektra.org/doc/dev/data-structures.md#order-preserving-minimal-perfect-hash-map-aka-opmphm).
  The hybrid search uses a modified branch predictor to predicts KeySet changes and decides if binary search or OPMPHM would be faster. *(Kurt Micheli)*
- <<TODO>>
- <<TODO>>


## Get It!

You can download the release from [here](https://www.libelektra.org/ftp/elektra/releases/elektra-0.8.24.tar.gz)
or [GitHub](https://github.com/ElektraInitiative/ftp/blob/master/releases/elektra-0.8.24.tar.gz?raw=true)


The [hashsums are:](https://github.com/ElektraInitiative/ftp/blob/master/releases/elektra-0.8.24.tar.gz.hashsum?raw=true)

<<`scripts/generate-hashsums`>>

The release tarball is also available signed by me using GnuPG from
[here](https://www.libelektra.org/ftp/elektra/releases/elektra-0.8.24.tar.gz.gpg) or
[GitHub](https://github.com/ElektraInitiative/ftp/blob/master/releases//elektra-0.8.24.tar.gz.gpg?raw=true)

Already built API-Docu can be found [online](https://doc.libelektra.org/api/0.8.24/html/)
or [GitHub](https://github.com/ElektraInitiative/doc/tree/master/api/0.8.24).


## Stay tuned!

Subscribe to the
[RSS feed](https://www.libelektra.org/news/feed.rss)
to always get the release notifications.

For any questions and comments, please contact the
issue tracker [on GitHub](http://issues.libelektra.org)
or Markus Raab by email using elektra@markus-raab.org.

[Permalink to this NEWS entry](https://www.libelektra.org/news/0.8.24-release)

For more information, see [https://libelektra.org](https://libelektra.org)

Best regards,
[Elektra Initiative](https://www.libelektra.org/developers/authors)
