/**
 * @file
 *
 * @brief Build system configuration
 *
 * @copyright BSD License (see LICENSE.md or https://www.libelektra.org)
 */

// clang-format off


/***************************************************************************
 *                                                                         *
 * This header file is AUTO GENERATED.                                     *
 * Do not edit this file, otherwise your changes will be discarded in the  *
 * next cmake run.                                                         *
 *                                                                         *
 ***************************************************************************/

#ifndef KDBCONFIG_H
#define KDBCONFIG_H

/**Below this directory the system configuration (system/) will be searched.*/
#define KDB_DB_SYSTEM            "/etc/kdb"

/** Depending on the resolver this might be the
  * postfix to search for user configuration. */
#define KDB_DB_USER              ".config"

/** Prefix to search specification configuration (spec/). */
#define KDB_DB_SPEC              "/usr/share/elektra/specification"

#define KDB_DB_SPEC_REAL              "share/elektra/specification"
/** The folder to add for directory namespace */
#define KDB_DB_DIR               ".dir"

/** Depending on the resolver this might be the root 
  * to search for user configuration. */
#define KDB_DB_HOME              "/home"

#define KDB_DB_FILE              "default.ecf"

#define KDB_DB_INIT              "elektra.ecf"

/** Only to be used where really the specific
  * storage is needed!
  * Note that for mounting/export and so on
  * KDB_STORAGE should be preferred.*/
#define KDB_DEFAULT_STORAGE      "dump"

/** Only to be used where really the specific
  * resolver is needed!
  * Note that for mounting/export and so on
  * KDB_STORAGE should be preferred.*/
#define KDB_DEFAULT_RESOLVER     "resolver_fm_hpu_b"

/** To be used if you want the currently
  * build-in default storage, whatever it is. */
#define KDB_STORAGE              "storage"

/** To be used if you want the currently
  * build-in default resolver, whatever it is. */
#define KDB_RESOLVER             "resolver"

#define ELEKTRA_PLUGINS          "base64;boolean;c;camel;ccode;conditionals;constants;counter;crypto_gcrypt;crypto_openssl;csvstorage;curlget;date;dbus;desktop;dini;directoryvalue;dpkg;dump;enum;error;fcrypt;filecheck;fstab;glob;hexcode;hexnumber;hidden;hosts;iconv;ini;ipaddr;journald;keytometa;line;lineendings;list;logchange;mathcheck;mini;multifile;network;ni;noresolver;null;path;profile;range;regexstore;rename;required;resolver_fm_b_b;resolver_fm_hb_b;resolver_fm_hp_b;resolver_fm_hpu_b;resolver_fm_pb_b;resolver_fm_ub_x;resolver_fm_uhb_xb;resolver_fm_xb_x;resolver_fm_xhp_x;resolver_fm_xp_x;shell;simpleini;spec;struct;sync;syslog;timeofday;tracer;type;uname;validation;wresolver;xmltool"

#define ELEKTRA_TOOLS            "kdb"

/** Declares a parameter as unused. */
#define ELEKTRA_UNUSED           __attribute__ ((unused))

/** Declares a switch fallthrough case. */
#define ELEKTRA_FALLTHROUGH      __attribute__ ((fallthrough))

/** Declares an API as deprecated. */
#define ELEKTRA_DEPRECATED       __attribute__ ((deprecated))

/** Declares non sanitize for asan. */
#define ELEKTRA_NO_SANITIZE_INTEGER	
#define ELEKTRA_NO_SANITIZE_UNDEFINED	

/** Where plugins are installed */
#define BUILTIN_PLUGIN_FOLDER    "/usr/lib/elektra"

/** Where tools (and other executables like scripts) are installed */
#define BUILTIN_EXEC_FOLDER      "/usr/lib/elektra/tool_exec"

#define BUILTIN_DATA_FOLDER      "/usr/share/elektra/test_data"

#define SIZEOF_INT               4
#define SIZEOF_SIZE_T            8
#define SIZEOF_LONG              8
#define SIZEOF_MODE_T            4
#define SIZEOF_TV_USEC           8

#define HAVE_SIZEOF_LONG_LONG
#ifdef HAVE_SIZEOF_LONG_LONG
# define SIZEOF_LONG_LONG         8
#endif

#define HAVE_SIZEOF_LONG_DOUBLE
#ifdef HAVE_SIZEOF_LONG_DOUBLE
# define SIZEOF_LONG_DOUBLE       16
#endif

/* ENABLE_OPTIMIZATIONS */
#define ELEKTRA_ENABLE_OPTIMIZATIONS

/* ENDIANNESS */
/* #undef ELEKTRA_BIG_ENDIAN */

/* debug mode */
#define DEBUG 0

#ifndef DEBUG
# define NDEBUG
#endif

/* disable output messages to stdout (to be migrated to logger) */
#define VERBOSE 0

#ifndef HAVE_LOGGER
/* #undef HAVE_LOGGER */
#endif

/* define if your system has the `clearenv' function. */
#ifndef HAVE_CLEARENV
#define HAVE_CLEARENV
#endif

/* define if your system has the `glob' function. */
#ifndef HAVE_GLOB
#define HAVE_GLOB
#endif

/* define if your system has the <ctype.h> header file. */
#ifndef HAVE_CTYPE_H
#define HAVE_CTYPE_H
#endif

/* define if your system has the <errno.h> header file. */
#ifndef HAVE_ERRNO_H
#define HAVE_ERRNO_H
#endif

/* define if your system has the <locale.h> header file. */
#ifndef HAVE_LOCALE_H
#define HAVE_LOCALE_H
#endif

/* define if your system has the `setenv' function. */
#ifndef HAVE_SETENV
#define HAVE_SETENV
#endif

/* define if your system has the `futimens' function. */
#ifndef HAVE_FUTIMENS
#define HAVE_FUTIMENS
#endif

/* define if your system has the `futimes' function. */
#ifndef HAVE_FUTIMES
#define HAVE_FUTIMES
#endif

/* define if your system has the <stdio.h> header file. */
#ifndef HAVE_STDIO_H
#define HAVE_STDIO_H
#endif

/* define if your system has the <stdlib.h> header file. */
#ifndef HAVE_STDLIB_H
#define HAVE_STDLIB_H
#endif

/* define if your system has the <string.h> header file. */
#ifndef HAVE_STRING_H
#define HAVE_STRING_H
#endif

/* define if your system has the <time.h> header file. */
#ifndef HAVE_TIME_H
#define HAVE_TIME_H
#endif

/* define if your system has the `clearenv' function. */
#ifndef HAVE_CLOCK_GETTIME
#define HAVE_CLOCK_GETTIME
#endif


/* define if your system has the <unistd.h> header file. */
#ifndef HAVE_UNISTD_H
#define HAVE_UNISTD_H
#endif

/* define if your system has the `hsearch_r' function family. */
#ifndef HAVE_HSEARCHR
#define HAVE_HSEARCHR
#endif






#endif
