--[[
Copyright (c) 2013 - translation -  BuTcHeR (extragry.pl)

The study, diagnosis and surgery on the translation performed by:
- Bemberg, the anesthesiologist - translation, corrections, testing (grajpopolsku.pl)
- Butcher, as the head - the originator, translation, corrections, fonts, tests (extragry.pl)
- Johnny, as a doctor - correction (grajpopolsku.pl)
- Machiner, as a GP - translation, corrections (grajpopolsku.pl)
- Mziab, as a surgeon - translation, font, corrections, tools and preparing script to CAT software (mziab.grajpopolsku.pl)
- Spec0071, as a doctor - correction, tests
- Twig, as a consultant - technical issues (grajpopolsku.pl)

Permission is hereby granted, free of charge, to any person obtaining a copy of
this software and associated documentation files (the "Software"), to deal in
the Software without restriction, including without limitation the rights to
use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
of the Software, and to permit persons to whom the Software is furnished to do
so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE. --]]

Font("unicode")
Language("Polski", "Polish", "pl", "pol")
Inherit("English")
Encoding(utf8)

font_location_window.caption = "Wybierz czcionkę (%1%)"

misc = {
  hospital_open = "Szpital otwarty",
  save_success = "Gra zapisana poprawnie",
  save_failed = "BŁĄD: Gra nie została zapisana",
  low_res = "Niska Rozdz.",
  no_heliport = "Albo nadal nie odkryto żadnych chorób, bądź na tej mapie nie ma lądowiska dla helikopterów.",
  grade_adverb = {
    extremely = "maksymalnie",
    mildly = "nieznacznie",
    moderately = "średnio",
  },
  not_yet_implemented = "(jeszcze nie wdrożono)",
  send_message = "Wyślij wiadomość do gracza %d",
  out_of_sync = "Błąd synchronizacji gry",
  balance = "Poziom Trudności:",
  load_failed = "Wczytywanie nieudane",
  mouse = "Mysz",
  done = "Zrobione",
  force = "Siła",
  pause = "Pauza",
  send_message_all = "Wyślij wiadomość do wszystkich graczy",
}
handyman_window = {
  all_parcels = "Wszystkie",
  parcel = "Parcela",
}
staff_list = {
  morale = "MORALE",
  tiredness = "ZMĘCZENIE",
  skill = "UMIEJĘTNOŚCI",
  total_wages = "WYPŁATY",
}
research = {
  allocated_amount = "Przeznaczona Suma",
  funds_allocation = "Przeznaczenie Funduszy",
  categories = {
    improvements = "Ulepszenia",
    drugs = "Badania nad Lekami",
    diagnosis = "Sprzęt do Diagnozowania",
    cure = "Sprzęt do Leczenia",
    specialisation = "Specjalizacje",
  },
}
debug_patient_window = {
  caption = "Debug Pacjenta",
}
totd_window = {
  previous = "Poprzednia Porada",
  tips = {
    [1] = "Każdy szpital potrzebuje recepcji oraz Gabinetu Lekarskiego, aby móc normalnie funkcjonować. Później to zależy od rodzaju pacjentów którzy odwiedzają szpital. Budowa apteki to zawsze dobry wybór.",
    [2] = "Maszyny takie jak Napowietrzacz wymagają konserwacji. Zatrudnienij dozorcę albo dwóch do naprawy twoich urządzeń, w przeciwnym wypadku będziesz ryzykował, że twój personel oraz pacjenci zostaną ranni.",
    [3] = "Po chwili Twój personel będzie zmęczony. Upewnij się, że wybudujesz pokój socjalny, aby mogli się oni zrelaksować.",
    [4] = "Umieść odpowiednią ilość kaloryferów aby utrzymać personel oraz pacjentów w cieple, w przeciwnym razie będą oni niezadowoleni. Skorzystaj z mapy miasta aby zlokalizować miejsca w szpitalu, które potrzebują więcej ogrzewania.",
    [5] = "Poziom umiejśtności lekarzy ma ogromny wpływ na prędkość oraz jakość diagnozowania. Umieść wykwalifikowanego lekarza w Gabinecie Lekarskim a nie będziesz potrzebował wielu dodatkowych gabinetów diagnostycznych.",
    [6] = "Asystenci oraz doktorzy mogą doskonalić swoje umiejętności ucząc się od konsultanta w sali treningowej. Jeżeli konsultant posiada specjalne kwalifikacje (chirurg, psychiatra, naukowiec), będzie on również przekazywał i tą wiedzę swoim uczniom.",
    [7] = "Czy próbowałeś wpisać Europejski numer alarmowy (112) na faxie? Upewnij się, że masz włączony dźwięk!",
    [8] = "Niektóre ustawienia gry, takie jak rozdzielczość oraz język, możesz dostosować w oknie opcji, dostępnym w głównym menu gry.",
    [9] = "Wybrano język inny niż angielski jednak cały tekst jest wyświetlany po angielsku? Pomóż nam przetłumaczyć brakujące teksty na Twój język ojczysty!",
    [10] = "Ekipa CorsixTH poszukuje wzmocnień! Czy jesteś zainteresowany kodowaniem, tłumaczeniem lub tworzeniem grafiki dla CorsixTH? Skontaktuj się z nami na naszym forum, liście email lub kanale IRC (corsix-th na freenode).",
    [11] = "Jeśli znajdziesz jakiś błąd, zgłoś go w naszym systemie: th-issues.corsix.org",
    [12] = "Na każdym poziomie należy spełnić pewne wymagania, zanim będzie można przejść do kolejnego. Sprawdź, w oknie statusu, aby zobaczyć postęp w realizacji celów poziou.",
    [13] = "Jeśli chcesz edytować lub usunąć istniejące pomieszczenia, można to zrobić za pomocą przycisku edycji pomieszczenia znajdującego się w pasku narzędzi na dole.",
    [14] = "W tłumie oczekujących pacjentów, można szybko dowiedzieć się, którzy z nich czekają do danego gabinetu. Wystarczy najechać kursorem myszy na pacjenta.",
    [15] = "Kliknij na drzwi gabinetu, aby zobaczyć oczekującą do niego kolejkę. Można dokonać tam również przydatnych zmian, takich jak na przykład zmiana kolejności w kolejce lub wysyłanie pacjenta do innego gabinetu.",
    [16] = "Niezadowolony personel będzie często prosił o podwyżki. Upewnij się, że Twój personel pracuje w komfortowych warunkach aby tego uniknąć.",
    [17] = "Pacjenci będą spragnieni podczas czekania w szpitalu, tym bardziej jeśli podkręcisz ogrzewanie! Umiejscowienie Automatów do napoi w strategicznych miejscach przyniesie dodatkowy dochód.",
    [18] = "Jeżeli już spotkał się z daną chorobą, w każdym momencie możesz przerwać diagnozowanie pacjenta i odgadnąć jak go wyleczyć. Pamiętaj jednak, że może to zwiększyć ryzyko błędnej kuracji, co może prowadzić do śmierci pacjenta.",
    [19] = "Nagłe wypadki mogą być dobrym źródłem dodatkowych pieniędzy, pod warunkiem, że posiadasz niezbędne gabinety do wyleczenia pacjentów w wyznaczonym czasie.",
  },
  next = "Następna Porada",
}
queue_window = {
  num_in_queue = "Długość Kolejki",
  num_entered = "Odwiedzono",
  max_queue_size = "Maks. Roz.",
  num_expected = "Spodziewani",
}
staff_class = {
  doctor = "Lekarz",
  handyman = "Dozorca",
  receptionist = "Recepcjonistka",
  nurse = "Pielęgniarka",
  surgeon = "Chirurg",
}
tooltip = {
  hire_staff_window = {
    prev_person = "Zobacz poprzednią osobę",
    cancel = "Anuluj",
    psychiatrist = "Psychiatra",
    salary = "Pensja",
    next_person = "Zobacz następną osobę",
    nurses = "Zobacz dostępne Pielęgniarki",
    surgeon = "Chirurg",
    handymen = "Zobacz dostępnych Dozorców",
    doctors = "Zobacz dostępnych Lekarzy",
    doctor_seniority = "Rangi Lekarzy (Asystent, Doktor, Konsultant)",
    hire = "Zatrudnij",
    researcher = "Naukowiec",
    qualifications = "Dodatkowe specjalizacje Lekarzy",
    receptionists = "Zobacz dostępne Recepcjonistki",
    staff_ability = "Umiejętności personelu",
  },
  handyman_window = {
    parcel_select = "Miejsce, w którym dozorca przyjmuje zadania, kliknij aby zmienić ustawienia.",
    close = "Anuluj żądanie",
    ability = "Umiejętności",
    face = "Twarz Dozorcy",
    prio_machines = "Zwiększ priorytet naprawy urządzeń",
    prio_litter = "Zwiększ priorytet sprzątania",
    happiness = "Zadowolenie",
    prio_plants = "Zwiększ priorytet podlewania roślin",
    name = "Imię Dozorcy",
    tiredness = "Zmęczenie",
    center_view = "Zbliżenie na Dozorcę",
    salary = "Pensja",
    sack = "Zwolnij",
    pick_up = "Podnieś",
  },
  staff_list = {
    ability_2 = "Poziom Umiejętności Pracowników",
    next_person = "Zobacz następną osobę",
    detail = "Troska o Detale",
    happiness = "Zadowolenie pracowników",
    researcher_train = "%d%% szkolony na Naukowca",
    handymen = "Zobacz listę Dozorców zatrudnionych w tym szpitalu",
    tiredness = "Zmęczenie pracowników",
    researcher = "Wykwalifikowany Naukowiec",
    happiness_2 = "Morale Pracowników",
    pay_rise = "Podnieś pensję tej osoby o 10%",
    bonus = "Daj tej osobie 10% premii",
    prev_person = "Zobacz poprzednią osobę",
    nurses = "Zobacz listę Pielęgniarek zatrudnionych w tym szpitalu",
    psychiatrist = "Wykwalifikowany Psychiatra",
    salary = "Indywidualne pensje pracowników",
    ability = "Umiejętności pracowników",
    close = "Wyjdź i wróć do gry",
    sack = "Zwolnij tę osobę",
    surgeon = "Wykwalifikowany Chirurg",
    tiredness_2 = "Zmęczenie Pracowników",
    doctors = "Zobacz listę Lekarzy zatrudnionych w tym szpitalu",
    doctor_seniority = "Ranga Lekarza",
    view_staff = "Zobacz osobę w pracy",
    surgeon_train = "%d%% szkolony na Chirurga",
    skills = "Dodatkowe specjalizacje",
    receptionists = "Zobacz listę Recepcjonistek zatrudnionych w tym szpitalu",
    psychiatrist_train = "%d%% szkolony na Psychiatrę",
  },
  research = {
    cure_inc = "Zwiększ procenty",
    close = "Zamknij ekran Badań",
    specialisation_dec = "Zmniejsz procenty",
    diagnosis_dec = "Zmniejsz procenty",
    allocated_amount = "Ilość przeznaczonego budżetu",
    improvements_inc = "Zwiększ procenty",
    drugs_dec = "Zmniejsz procenty",
    drugs_inc = "Zwiększ procenty",
    cure_dec = "Zmniejsz procenty",
    specialisation_inc = "Zwiększ procenty",
    improvements_dec = "Zmniejsz procenty",
    diagnosis_inc = "Zwiększ procenty",
  },
  machine_window = {
    repair = "Wyślij Dozorcę do naprawy urządzenia",
    name = "Nazwa",
    close = "Anuluj żądanie",
    times_used = "Liczba użyć",
    status = "Stan urządzenia",
    replace = "Wymień urządzenie",
  },
  place_objects_window = {
    confirm = "Potwierdź",
    cancel = "Anuluj",
    pick_up = "Podnieś obiekt",
    buy_sell = "Kup/sprzedaj obiekty",
  },
  totd_window = {
    previous = "Pokaż poprzednią poradę",
    next = "Pokaż następną poradę",
  },
  status = {
    percentage_cured = "Musisz wyleczyć przynajmniej %d%% pacjentów odwiedzających twój szpital. Do tej pory wyleczyłeś %d%%",
    thirst = "Ogólny poziom pragnienia ludzi w twoim szpitalu",
    close = "Zamknij okno Statystyk",
    population_chart = "Diagram pokazuje jaki odsetek ludności odwiedza każdy szpital",
    win_progress_own = "Pokaż postęp twojego szpitala ku wygranej",
    reputation = "Poziom reputacji musi wynosić co najmniej %d. Obecnie jest to %d",
    population = "Musisz ściągnąć do swego szpitala %d%% ogólnej populacji",
    warmth = "Ogólny poziom ciepła w twoim szpitalu",
    percentage_killed = "W tej misji umrzeć może nie więcej niż %d%% pacjentów szpitala. Do tej pory umarło %d%%",
    balance = "Stan twojego konta musi wynosić co najmniej %d. Obecnie jest to %d",
    value = "Twój szpital musi być wart przynajmniej %d PLN. Obecna jego wartość to %d PLN",
    win_progress_other = "Pokaż postęp %s ku wygranej",
    num_cured = "W tej misji musisz wyleczyć %d ludzi. Do tej pory wyleczyłeś %d",
    happiness = "Ogólne zadowolenie ludzi w twoim szpitalu",
  },
  queue_window = {
    end_of_queue = "Przeciągnij pacjenta na tę ikonę, aby przesunąć go na tył kolejki",
    num_entered = "Liczba pacjentów odwiedzających do tej pory",
    close = "Zamknij to okno",
    num_in_queue = "Liczba pacjentów w kolejce",
    num_expected = "Liczba pacjentów oczekiwanych wkrótce ",
    front_of_queue = "Przeciągnij pacjenta na tę ikonę, aby przesunąć go na przód kolejki",
    dec_queue_size = "Zmniejsz maksymalny rozmiar kolejki",
    max_queue_size = "Maksymalny rozmiar kolejki",
    inc_queue_size = "Zwiększ maksymalny rozmiar kolejki",
    patient = "Przeciągnij pacjenta, aby przesunąć go w kolejce. Prawy-klik na pacjencie, aby wysłać go do domu lub do szpitala konkurencji",
    patient_dropdown = {
      send_home = "Wypisz pacjenta ze szpitala",
      hospital_2 = "Wyślij pacjenta do innego szpitala",
      reception = "Wyślij pacjenta do Recepcji",
      hospital_1 = "Wyślij pacjenta do innego szpitala",
      hospital_3 = "Wyślij pacjenta do innego szpitala",
    },
  },
  jukebox = {
    rewind = "Poprzedni utwór",
    loop = "Odtwarzanie zapętlone",
    stop = "Stop",
    close = "Zamknij szafę grającą",
    current_title = "Szafa grająca",
    play = "Odtwarzaj",
    fast_forward = "Następny utwór",
  },
  graphs = {
    deaths = "Przełącz zgony",
    close = "Zamknij Wykresy",
    scale = "Skala wykresu",
    money_out = "Przełącz wydatki",
    visitors = "Przełącz odwiedzających",
    wages = "Przełącz wypłaty",
    balance = "Przełącz stan konta",
    money_in = "Przełącz dochody",
    cures = "Przełącz wyleczonych",
    reputation = "Przełącz reputację",
  },
  toolbar = {
    reputation = "Twoja reputacja",
    casebook = "Teczka z lekami",
    edit = "Edytuj pomieszczenia/przedmioty",
    staff_list = "Przegląd personelu",
    policy = "Strategia szpitala",
    date = "Data",
    charts = "Wykresy",
    objects = "Wyposaż korytarz",
    balance = "Twój stan konta",
    research = "Badania",
    hire = "Zatrudnij personel",
    status = "Pozycja",
    town_map = "Mapa miasta",
    rooms = "Zbuduj pomieszczenie",
    bank_button = "Lewe Kliknięcie - Menadżer Banku, Prawe Kliknięcie - Raport Bankowy",
  },
  message = {
    button = "Kliknij lewym przyciskiem myszy aby otworzyć wiadomość",
    button_dismiss = "Lewy przycisk myszy otwiera wiadomość, prawy ją usuwa",
  },
  pay_rise_window = {
    accept = "Spełnij żądania płacowe",
    decline = "Nie dawaj podwyżki, tylko zwolnij",
  },
  town_map = {
    close = "Wyjdź z mapy miasta",
    plants = "Przełącz rośliny",
    fire_extinguishers = "Przełącz gaśnice",
    people = "Przełącz ludzi",
    balance = "Bilans",
    heat_dec = "Zmniejsz ogrzewanie",
    heating_bill = "Rachunek za ogrzewanie",
    radiators = "Przełącz kaloryfery",
    objects = "Przełącz obiekty",
    heat_level = "Poziom ciepła",
    heat_inc = "Zwiększ ogrzewanie",
  },
  custom_game_window = {
    start_game_with_name = "Wczytaj poziom %s",
    free_build = "Zaznacz, jeżeli chcesz grać bez limitów finansowych oraz ustalonych warunków przegranej lub zwycięstwa",
  },
  cheats_window = {
    close = "Zamknij okno oszustw",
    cheats = {
      end_month = "Przeskakuje na koniec miesiąca.",
      create_patient = "Tworzy pacjenta na skraju mapy.",
      money = "Dodaje 10.000 do swojego konta.",
      emergency = "Tworzy nagły wypadek.",
      win_level = "Wygrywa obecny poziom.",
      vip = "Tworzy VIP'a.",
      lose_level = "Przegrywa obecny poziom.",
      earthquake = "Tworzy trzęsienie ziemi.",
      all_research = "Dokańcza wszystkie badania.",
      end_year = "Przeskakuje na koniec roku.",
    },
  },
  casebook = {
    sent_home = "Liczba pacjentów odesłanych do domu",
    cure_requirement = {
      hire_staff_old = "Musisz zatrudnić %s, aby leczyć to schorzenie",
      possible = "Możesz leczyć to schorzenie",
      not_possible = "Nie możesz jeszcze leczyć tego schorzenia",
      ward_hire_nurse = "Potrzebujesz Pielęgniarki do pracy na Oddziale, aby leczyć to schorzenie",
      hire_surgeon = "Musisz zatrudnić drugiego Chirurga, aby przeprowadzać operacje",
      hire_staff = "Musisz zatrudnić personel aby poradzić sobie z tym schorzeniem",
      research_machine = "Musisz wynaleźć urządzenie do tej kuracji",
      build_room = "Musisz zbudować gabinet, aby leczyć to schorzenie",
      build_ward = "Musisz zbudować Oddział, aby prowadzić kuracje",
      hire_surgeons = "Musisz zatrudnić dwóch Chirurgów, aby przeprowadzać operacje",
    },
    increase = "Zwiększ kwotę",
    up = "Przewiń w górę",
    reputation = "Reputacja Leczenia lub Diagnozowania",
    research = "Kliknij tutaj, aby użyć specjalnego budżetu badawczego na tę kurację",
    close = "Zamknij Teczkę",
    earned_money = "Całkowity zarobek",
    cure_type = {
      psychiatrist = "Psychiatra zajmuje się tą kuracją",
      drug_percentage = "Ta kuracja używa leku, który jest efektywny w %d%%",
      drug = "Ta kuracja wymaga leków",
      machine = "Ta kuracja wymaga urządzenia",
      unknown = "Nadal nie wiesz jak leczyć to schorzenie",
      surgery = "To schorzenie wymaga operacji",
    },
    decrease = "Zmniejsz kwotę",
    deaths = "Liczba zgonów",
    cured = "Liczba wyleczonych osób",
    down = "Przewiń w dół",
    treatment_charge = "Koszt",
  },
  policy = {
    diag_termination = "Diagnozowanie pacjenta będzie kontynuowane, dopóki Lekarz nie będzie pewny jak ustawiony jest wskaźnik ZATRZYMAJ PROCEDURĘ, lub dopóki wszystkie urządzenia diagnostyczne nie zostaną sprawdzone",
    close = "Zamknij okno Strategii Szpitala",
    staff_leave = "Kliknij tutaj, aby wysłać wolnych pracowników do pomocy swoim kolegom",
    diag_procedure = "Jeżeli diagnoza Lekarza jest mniej pewna niż ustalony wskaźnik WYPISZ DO DOMU, pacjent będzie odesłany do domu. Jeżeli diagnoza jest lepsza niż wskaźnik POSTAW DIAGNOZĘ, pacjent zostanie wysłany na odpowiednie leczenie",
    staff_rest = "Jak bardzo personel musi być zmęczony, zanim pójdzie odpocząć",
    staff_stay = "Kliknij tutaj, aby pracownicy pozostali w gabinetach, które im przydzieliłeś",
  },
  bank_manager = {
    graph = "Wykres spodziewanych wpłat od %s",
    close = "Zamknij okno banku",
    hospital_value = "Wartość szpitala",
    graph_return = "Wróć do poprzedniego widoku",
    current_loan = "Zaciągnięte pożyczki",
    borrow_5000 = "Pożycz 5000 PLN z banku",
    balance = "Stan konta",
    interest_payment = "Miesięczne odsetki",
    inflation_rate = "Roczna stawka inflacji",
    interest_rate = "Roczna stawka odsetek",
    repay_5000 = "Spłać 5000 PLN bankowi",
    show_graph = "Pokaż wykres spodziewanych wpłat od %s",
    insurance_owed = "Ilość pieniędzy, które jest winien %s",
  },
  main_menu = {
    exit = "Nie, nie, proszę nie odchodź!",
    custom_level = "Zbuduj swój szpital na dodatkowych poziomach",
    network = "Rozpocznij grę sieciową",
    quit = "Wyjdź",
    continue = "Kontynuuj poprzednią grę",
    options = "Zmień różne ustawienia gry",
    load_menu = {
      load_slot = "WCZYTAJ GRĘ",
      empty_slot = "PUSTY",
    },
    new_game = "Zacznij grę od samego początku‏",
    load_game = "Wczytaj zapisaną grę",
  },
  patient_window = {
    graph = "Kliknij, aby przełączyć się pomiędzy wykresem zdrowia osób a ich historią leczenia",
    casebook = "Pokaż detale choroby",
    close = "Anuluj żądanie",
    queue = "Zobacz detale kolejki",
    happiness = "Zadowolenie",
    warmth = "Temperatura",
    center_view = "Zbliżenie na osobę",
    thirst = "Pragnienie",
    send_home = "Wypisz osobę ze szpitala",
    abort_diagnosis = "Wyślij osobę na leczenie bez skończenia diagnozowania choroby",
  },
  menu_list_window = {
    save_date = "Kliknij tutaj aby sortować listę według ostatniej daty modyfikacji",
    name = "Kliknij tutaj aby sortować listę według nazwy",
    back = "Wróć",
  },
  watch = {
    emergency = "Nagły wypadek: czas pozostały na wyleczenie wszystkich pacjentów z wypadku.",
    hospital_opening = "Czas budowy: to czas pozostały do oficjalnego otwarcia szpitala. Kliknij na przycisk, aby natychmiast otworzyć szpital.",
    epidemic = "Epidemia: czas pozostały na opanowanie epidemii. Gdy czas upłynie lub zarażony pacjent opuści szpital, odwiedzi cię Inspektor Zdrowia. Przycisk włącza/wyłącza tryb szczepienia. Kliknij na pacjenta, aby zaszczepiła go Pielęgniarka.",
  },
  new_game_window = {
  player_name = "Wprowadź nazwę jaka będzie używana podczas gry",
  difficulty = "Wybierz poziom trudności na jakim chcesz rozpocząć grę",
  easy = "Jeżeli jesteś początkującym graczem, jest to dla ciebie odpowiedni poziom",
  medium = "Jest to średni poziom trudności, zalecany dla większości graczy",
  hard = "Jeżeli chcesz mieć więcej wyzwań a tego typu gry to twój chleb powszedni wybierz tą opcję",
  tutorial = "Jeżeli potrzebujesz pomocy przy rozpoczęciu gry zaznacz to pole.",
  start = "Rozpocznij grę z wybranymi ustawieniami",
  cancel = "Och, tak naprawdę nie chcę rozpoczynać nowej gry!",
  },
  save_game_window = {
    new_save_game = "Wprowadź nazwę dla zapisanej gry",
    save_game = "Nadpisz zapisaną grę %s",
  },
  calls_dispatcher = {
    assigned = "To pole jest zaznaczone, jeśli ktoś jest przypisany do wybranego zadania.",
    task = "Lista zadań - kliknij na zadanie, aby otworzyć okno poleceń dla personelu i przejść do wybranej lokacji zadania.",
    close = "Zamknij okno dyspozycji.",
  },
  research_policy = {
    research_progress = "Postęp w kierunku nowego odkrycia w tej dziedzinie: %1%/%2%",
    no_research = "W tym momencie nie są prowadzone żadne badania w tej dziedzinie",
  },
  information = {
    close = "Zamknij okno informacji",
  },
  lua_console = {
    textbox = "Tutaj wprowadź kod Lua aby go uruchomić",
    execute_code = "Uruchom kod który wprowadziłeś",
    close = "Zamknij konsolę",
  },
  staff_window = {
    doctor_seniority = "Ranga - Asystent, Doktor lub Konsultant",
    psychiatrist = "Psychiatra",
    close = "Anuluj żądanie",
    ability = "Poziom umiejętności",
    pick_up = "Podnieś",
    sack = "Zwolnij",
    surgeon = "Chirurg",
    happiness = "Poziom zadowolenia",
    salary = "Miesięczna pensja",
    name = "Imię i nazwisko pracownika",
    tiredness = "Poziom zmęczenia",
    center_view = "Lewe kliknięcie przybliża pracownika, prawe kliknięcie przełącza między pracownikami",
    skills = "Specjalizacje",
    researcher = "Naukowiec",
    face = "Twarz tej osoby - kliknij aby otworzyć ekran zarządzania",
  },
  rooms = {
    ultrascan = "Lekarz używa Ultraskanera do diagnozowania pacjentów",
    research_room = "Lekarze ze specjalizacją Naukowca mogą wynajdować nowe leki i urządzenia w Dziale Badawczym",
    fracture_clinic = "Pielęgniarka korzysta z Gabinetu Ortopedycznego do składania Zgruchotanych Kości",
    gps_office = "Pacjenci otrzymują wstępną konsultację w Gabinecie Lekarskim",
    inflation = "Lekarz używa Napowietrzacza do leczenia pacjentów z Głowowzdęciem",
    staffroom = "Lekarze i Pielęgniarki odpoczywają i regenerują siły w pokoju dla personelu",
    jelly_vat = "Lekarz używa Galaretownicę do leczenia Galaretowatości",
    scanner = "Lekarz używa Skanera do diagnozowania pacjentów",
    decontamination = "Lekarz używa Prysznica Odkażającego, aby wyleczyć Radioaktywność",
    pharmacy = "Pielęgniarka wydaje pacjentom leki w Aptece",
    cardiogram = "Lekarz używa Kardiografu do diagnozowania pacjentów",
    ward = "Oddział jest przydatny zarówno do diagnozowania jak i leczenia. Pacjenci są tu przysyłani na obserwację oraz rekonwalescencję pooperacyjną",
    training_room = "Sala Szkoleniowa z Konsultantem może być używana do szkolenia innych Lekarzy",
    operating_theatre = "Sala Operacyjna potrzebuje dwóch Lekarzy ze specjalizacją chirurga",
    psychiatry = "Gabinet Psychiatryczny leczy szalonych pacjentów i diagnozuje różne choroby, potrzebuje jednak lekarza ze specjalizacją Psychiatry",
    hair_restoration = "Lekarz używa Przeszczepiacza Włosów do leczenia łysych pacjentów",
    tongue_clinic = "Lekarz używa Krajalnicy do leczenia Obwisłego Języka",
    dna_fixer = "Lekarz używa Re-GEN-eratora do leczenia pacjentów z DNA Obcych",
    general_diag = "Lekarz używa gabinetu do przeprowadzenia Podstawowych Badań. Tanie a zarazem bardzo efektywne",
    toilets = "Zbuduj Toalety, aby pacjenci nie zapaskudzili szpitala!",
    electrolysis = "Lekarz używa Elektrolizera do leczenia Włochacizny",
    x_ray = "Lekarz używa Rentgena do diagnozowania pacjentów",
    blood_machine = "Lekarz używa Analizatora Krwi do diagnozowania pacjentów",
  },
  statement = {
    close = "Zamknij ekran Raportu",
  },
  buy_objects_window = {
    confirm = "Kup przedmiot(y)",
    cancel = "Anuluj",
    increase = "Kup o jeden przedmiot więcej",
    total_value = "Wartość zamówionych przedmiotów",
    price = "Cena przedmiotu",
    decrease = "Kup o jeden przedmiot mniej",
  },
  load_game_window = {
    load_game = "Wczytaj grę %s",
    load_autosave = "Wczytaj autozapis",
    load_game_number = "Wczytaj grę %d",
  },
  window_general = {
    confirm = "Potwierdź",
    cancel = "Anuluj",
  },
  fax = {
    close = "Zamknij okno bez usuwania wiadomości",
  },
  objects = {
    chair = "Krzesło: tutaj siedzą pacjenci i mówią o swoich dolegliwościach.",
    litter = "Odpadek: Rzucony przez pacjenta na podłogę, gdyż nie znalazł on śmietnika, do którego mógł go wyrzucić.",
    sofa = "Sofa: pracownicy będą grzecznie na niej siedzieli, dopóki nie znajdą sobie lepszej formy relaksu.",
    operating_table = "30 OB_OP_TABLE",
    bed2 = "nieużywane",
    bench = "Ławka: zapewnia siedzenie dla jednego pacjenta, dzięki czemu oczekiwanie jest komfortowe.",
    scanner = "14 OB_SCANNER",
    couch = "18 OB_COUCH",
    blood_machine = "42 OB_BLOOD_MC",
    table1 = "Stół (REMOVED): na nim leżą czasopisma, aby pacjenci się nie nudzili.",
    video_game = "Gra video: personel relaksuje się grając w Hi-Octane.",
    lamp = "Lampa: świeci i zapewnia widoczność personelowi.",
    op_sink2 = "34 OB_OP_SINK_2",
    door = "Drzwi: ludzie je często otwierają i zamykają.",
    auto_autopsy = "Autopsja: znacznie pomaga w odkrywaniu nowych leków",
    reception_desk = "Biurko Recepcji: wymaga Recepcjonistki, która pokieruje pacjentów do Lekarzy.",
    hair_restorer = "25 OB_HAIR_RESTORER",
    projector = "37 OB_PROJECTOR",
    crash_trolley = "20 OB_CRASH",
    tv = "TV: dzięki niemu pracownicy nie przegapią ulubionych programów.",
    ultrascanner = "22 OB_ULTRASCAN",
    surgeon_screen = "35 OB_SURGEON_SCREEN",
    litter_bomb = "Bomba Śmieciowa: sabotuje konkurencyjne szpitale",
    inflator = "Napowietrzacz: leczy ludzi z Głowowzdęciem.",
    table2 = "12 OB_BTABLE",
    desk = "Biurko: Wymagane do postawienia na nim komputera.",
    pool_table = "Bilard: pomaga personelowi się zrelaksować.",
    x_ray_viewer = "29 OB_XRAY_VIEWER",
    radiation_shield = "28 OB_RAD_SHIELD",
    bed = "Łóżko: leżą tutaj ciężko chorzy ludzie.",
    swing_door2 = "53 OB_DOUBLE_DOOR2",
    console = "15 OB_SCANNER_CONSOLE",
    op_sink1 = "33 OB_OP_SINK_1",
    bookcase = "Biblioteczka: źródło informacji dla Lekarzy.",
    drinks_machine = "Automat do napoi: zapobiega pragnieniu oraz przynosi dochody.",
    comfortable_chair = "61 OB_COMFY_CHAIR",
    skeleton = "Szkielet: używany w celach szkoleniowych oraz na Halloween.",
    computer = "Komputer: klucz do prowadzenia badań",
    bin = "Śmietnik: pacjenci wrzucają tu odpadki.",
    pharmacy_cabinet = "Apteka: tutaj trzymane są leki",
    radiator = "Kaloryfer: zapewnia ciepło w całym szpitalu.",
    cast_remover = "24 OB_CAST_REMOVE",
    atom_analyser = "Analizator Atomów: umieszczony w Dziale Badawczym, przyspiesza cały proces badawczy.",
    plant = "Roślina: zwiększa zadowolenie pacjentów i oczyszcza powietrze.",
    jelly_moulder = "47 OB_JELLY_VAT",
    cardio = "13 OB_CARDIO",
    toilet = "Klozet: pacjenci, noo... używają go.",
    electrolyser = "46 OB_ELECTRO",
    fire_extinguisher = "Gaśnica: minimalizuje zagrożenie ze strony uszkodzonych urządzeń.",
    bed3 = "nieużywane",
    swing_door1 = "52 OB_DOUBLE_DOOR1",
    lecture_chair = "Krzesło ucznia: twoi uczący się lekarze siedzą tutaj i robią notatki, nudzą się i bezmyślnie bazgrolą. Im więcej krzeseł, tym większa może być klasa.",
    screen = "16 OB_SCREEN",
    toilet_sink = "Zlew: twoi bardziej świadomi higieny pacjenci mogą umyć tu brudne ręce. Jeśli zabraknie zlewów, pacjenci robią się niezadowoleni.",
    shower = "54 OB_DECON_SHOWER",
    gates_of_hell = "48 OB_HELL",
    entrance_right = "59 OB_ENT_RDOOR",
    entrance_left = "58 OB_ENT_LDOOR",
    slicer = "26 OB_SLICER",
    dna_fixer = "23 OB_DNA_FIXER",
    x_ray = "27 OB_XRAY",
    cabinet = "Szafka: zawiera akta pacjentów, notatki oraz dokumenty naukowe.",
  },
  build_room_window = {
    cost = "Koszt wybranego pomieszczenia",
    room_classes = {
      treatment = "Wybierz gabinety Podstawowego Leczenia",
      diagnosis = "Wybierz gabinety Diagnostyczne",
      facilities = "Wybierz gabinety Udogodnień",
      clinic = "Wybierz gabinety Specjalistyczne",
    },
    close = "Przerwij i wróć do gry",
  },
  options_window = {
    fullscreen = "Wybór pomiędzy trybem pełnoekranowym lub grą w oknie",
    fullscreen_button = "Kliknij aby włączyć tryb pełnoekranowy",
    resolution = "Rozdzielczość w jakiej powinna działać gra",
    select_resolution = "Wybierz nową rozdzielczość",
    width = "Wpisz żądaną szerokość ekranu",
    height = "Wpisz żądaną wysokość ekranu",
    apply = "Zatwierdź wybraną rozdzielczość",
    cancel = "Powrót bez zmiany rozdzielczośći",
    data_location = "Katalog z zainstalowaną oryginalną grą Theme Hospital, która wymagana jest do uruchomienia CorsixTH",
    font_location = "Lokalizacja pliku z czcionką, która jest w stanie wyświetlić znaki wymagane przez twój język. Jeżeli nie będzie ona wybrana, wybór języka obsługującego inne znaki niż oryginalna gra nie będzie możliwy. Przykłady: Rosyjski i Chiński",
    language = "Język, w którym wyświetlone zostaną teksty gry",
    select_language = "Wybierz język gry",
    language_dropdown_item = "Wybierz %s jako język gry",
    original_path = "Aktualnie wybrany katalog z zainstalowaną grą Theme Hospital",
    browse = "Zmień ścieżkę zainstalowanej gry Theme Hospital (obecna lokalizacja: %1%)",
    browse_font = "Zmień ścieżkę dla innego pliku z czcionką (obecna lokalizacja: %1%)",
    no_font_specified = "Lokalizacja czcionki nie została jeszcze wybrana!",
    back = "Zamknij okno opcji",
  },
}
menu_charts = {
  bank_manager  = "  (F1) MENADŻER BANKU  ",
  statement     = "  (F2) RAPORT  ",
  staff_listing = "  (F3) LISTA PERSONELU  ",
  town_map      = "  (F4) MAPA MIASTA  ",
  casebook      = "  (F5) TECZKA  ",
  research      = "  (F6) BADANIA  ",
  status        = "  (F7) POZYCJA  ",
  graphs        = "  (F8) WYKRESY  ",
  policy        = "  (F9) STRATEGIA SZPITALA  ",
  briefing      = "  ODPRAWA  ",
}
town_map = {
  number = "Numer Gruntu",
  not_for_sale = "Nie na Sprzedaż",
  chat = "Inf. o Mieście",
  price = "Cena Gruntu",
  for_sale = "Na Sprzedaż",
  owner = "Właściciel",
  area = "Rozmiar",
}
vip_names = {
  [1] = "Burmistrz Trumpton",
  [2] = "Lawrence Nightingale",
  [3] = "Bernard, król Niderlandów",
  [4] = "Aung Sang Su Kyi, lider birmańskiej opozycji demokratycznej",
  [5] = "Sir Reginald Crumbly",
  [6] = "Billy Savile, Oficer Orderu",
  [7] = "Radny Crawford Purves",
  [8] = "Rakieta Ronnie Jepson",
  [9] = "Piłkarz ligi Premiership",
  [10] = "L. F. Probst III",
  health_minister = "Minister Zdrowia",
}
custom_game_window = {
  caption = "Gra niestandardowa",
  free_build = "Wolna budowa",
}
cheats_window = {
  cheats = {
    end_month = "Koniec miesiąca",
    create_patient = "Stwórz pacjenta",
    money = "Pieniądze",
    emergency = "Nagły wypadek",
    win_level = "Wygraj poziom",
    vip = "Stwórz VIP",
    lose_level = "Przegraj poziom",
    earthquake = "Stwórz trzęsienie ziemi",
    all_research = "Dokończ badania",
    end_year = "Koniec roku",
  },
  close = "Zamknij",
  caption = "Oszustwa",
  cheated = {
    no = "Używano oszustw: Nie",
    yes = "Używano oszustw: Tak",
  },
  warning = "Uwaga: Jeżeli będziesz oszukiwć nie dostaniesz dodatkowych punktów na koniec poziomu!",
}
room_descriptions = {
  ultrascan = {
    [1] = "Ultraskaner//",
    [2] = "Udoskonalony przyrząd diagnozujący. Jest wart swej wysokiej ceny, o ile chcesz zapewnić pacjentom najlepsze warunki diagnozowania.//",
    [3] = "Ultraskaner wymaga Lekarza. Musi być także konserwowany. ",
  },
  gp = {
    [1] = "Gabinet Lekarski//",
    [2] = "To najważniejszy gabinet w Twoim szpitalu. Nowi pacjenci są tu wysyłani, aby dowiedzieć się co im dolega. Następnie odsyłani są do dalszej diagnozy lub do gabinetów, w których mogą zostać wyleczeni. Możesz zbudować kolejny Gabinet Lekarski, jeżeli w tym będzie zbyt tłoczno. Rozmiar gabinetu i liczba urządzeń są wyznacznikiem autorytetu jakim cieszy się pracujący w nim Lekarz. To dotyczy również innych pomieszczeń.//",
    [3] = "Do funkcjonowania Gabinetu Lekarskiego niezbędny jest Lekarz. ",
  },
  fracture_clinic = {
    [1] = "Gabinet Ortopedyczny//",
    [2] = "Usuwacz Gipsu używa potężnego przemysłowego lasera do przecięcia stwardniałego gipsu, wywołując przy tym nieznaczny ból u pacjenta.//",
    [3] = "Gabinet Ortopedyczny potrzebuje Pielęgniarki. Wymaga również częstej konserwacji. ",
  },
  tv_room = {
    [1] = "SALA TV NIE UŻYWANA",
  },
  inflation = {
    [1] = "Napowietrzalnia//",
    [2] = "Pacjenci z bolesnym, acz zabawnym Głowowzdęciem muszą odwiedzić Napowietrzalnię, gdzie przerośnięta głowa zostaje przebita, a następnie napompowana do odpowiednich rozmiarów.//",
    [3] = "Napowietrzalnia musi mieć Lekarza do obsługi. Musi być także pod stałym nadzorem Dozorcy. ",
  },
  jelly_vat = {
    [1] = "Przychodnia Galaretowatości//",
    [2] = "Pacjenci dotknięci przezabawnym choróbskiem Galaretowatość, muszą dokiwać się do Przychodni Galaretowatości, gdzie umieszcza się ich w Galaretownicy. Właśnie w ten, nie do końca jasny dla medycyny sposób, zostają wyleczeni.//",
    [3] = "Przychodnia Galaretowatości potrzebuje Lekarza. Jak również nadzoru Dozorcy. ",
  },
  scanner = {
    [1] = "Skaner//",
    [2] = "Pacjenci są diagnozowani przy użyciu wymyślnego Skanera, po czym wracają do Gabinetu Lekarskiego w celu dalszego leczenia.//",
    [3] = "Skaner wymaga Lekarza. Musi być także konserwowany. ",
  },
  blood_machine = {
    [1] = "Analizator Krwi//",
    [2] = "Analizator Krwi jest częścią wyposażenia diagnozującego, które sprawdza komórki krwi pacjenta i określa ich stan.//",
    [3] = "Analizator Krwi wymaga Lekarza. Musi być także konserwowany. ",
  },
  pharmacy = {
    [1] = "Apteka//",
    [2] = "Pacjenci, którzy zostali zdiagnozowani i mogą być wyleczeni dzięki lekom, muszą zgłosić się po nie do Apteki. W miarę jak będą wymyślane nowe leki, ten gabinet stanie się naprawdę oblegany. Prawdopodobnie będziesz musiał wtedy zbudować drugą Aptekę.//",
    [3] = "Do pracy w Aptece potrzebna jest Pielęgniarka. ",
  },
  cardiogram = {
    [1] = "Kardiograf//",
    [2] = "Diagnozuje się tutaj pacjentów zanim wrócą do Gabinetu Lekarskiego i zostaną wysłani na leczenie.//",
    [3] = "Kardiograf wymaga Lekarza. Musi być także konserwowany. ",
  },
  ward = {
    [1] = "Oddział//",
    [2] = "Pacjenci przebywają tu na obserwacji podczas diagnozy. Poza tym kierowani są tu przed zabiegiem chirurgicznym.//",
    [3] = "Oddział potrzebuje Pielęgniarki. ",
  },
  psych = {
    [1] = "Psychiatra//",
    [2] = "Pacjenci ze zdiagnozowaną chorobą psychiczną muszą odwiedzić Gabinet Psychiatryczny, aby otrzymać poradę. Psychiatra diagnozuje pacjenta pod kątem dolegliwości i jeśli mają one podłoże psychiczne, leczy go z wykorzystaniem swej niezawodnej kozetki.//",
    [3] = "W Gabinecie Psychiatrycznym wymagany jest Lekarz ze specjalizacją Psychiatry. ",
  },
  staff_room = {
    [1] = "Pokój Socjalny//",
    [2] = "Twój personel podczas pracy męczy się. W tym pokoju pracownicy mogą się odprężyć i zrelaksować. Gdy są zmęczeni, pracują wolniej, domagają się większych podwyżek i popełniają więcej błędów. Budowa Pokoju Socjalnego z bogatym wyposażeniem jest bardzo opłacalna. Upewnij się, że znajdzie się tam miejsce dla kilku osób jednocześnie. ",
  },
  operating_theatre = {
    [1] = "Sala Operacyjna//",
    [2] = "Ważne pomieszczenie, w którym leczy się różnorodne schorzenia. Sala musi mieć sporą powierzchnię oraz powinna zawierać odpowiednie wyposażenie. Jest to nieodzowna część twojego szpitala.//",
    [3] = "Sala operacyjna wymaga dwóch Lekarzy ze specjalizacją Chirurga. ",
  },
  training = {
    [1] = "Sala Szkoleniowa//",
    [2] = "Twoi Asystenci oraz Doktorzy mogą tutaj zdobywać dodatkowe specjalizacje. Konsultant ze specjalizacją Chirurga, Psychiatry lub Naukowca przekazuje swoją wiedzę każdemu szkolonemu Lekarzowi. Lekarze, którzy posiadają już te specjalizacje, będą mogli je tutaj rozwijać.//",
    [3] = "Sala Szkoleniowa potrzebuje Konsultanta. ",
  },
  dna_fixer = {
    [1] = "Przychodnia DNA//",
    [2] = "DNA pacjentów, którzy zostali porwani przez obcych, musi zostać wymienione w tym gabinecie. Re-GEN-erator to bardzo skomplikowane urządzenie, dlatego wskazane jest mieć w pogotowiu gaśnicę, tak na wszelki wypadek.//",
    [3] = "Re-GEN-erator wymaga okresowego przeglądu przez Dozorcę. Potrzebny jest także Lekarz ze specjalizacją Naukowca. ",
  },
  research = {
    [1] = "Dział Badawczy//",
    [2] = "Tutaj wymyśla się lub ulepsza leki oraz sposoby leczenia. To bardzo ważna część szpitala, dzięki której liczba wyleczonych poszybuje w górę.//",
    [3] = "W Dziale Badawczym musi pracować Lekarz ze specjalizacją Naukowca. ",
  },
  hair_restoration = {
    [1] = "Gabinet Przeszczepu Włosów//",
    [2] = "Pacjenci cierpiący na ekstremalne Łysienie są kierowani do tego gabinetu w celu przeszczepienia włosów. Lekarz obsługuje maszynę, która szybko obsiewa łysą głowę pacjenta nowymi cebulkami.//",
    [3] = "W gabinecie Przeszczepu Włosów potrzebny jest Lekarz. Wymaga on także okresowej konserwacji. ",
  },
  general_diag = {
    [1] = "Badania Podstawowe//",
    [2] = "Pacjenci wymagający dalszej diagnozy są wysyłani tutaj. Jeżeli w Gabinecie Lekarskim nie wykryta zostanie przypadłość pacjenta, zazwyczaj zostanie to dokonane w gabinecie Badań Podstawowych. Stąd pacjenci zostają odesłani do Gabinetu Lekarskiego w celu analizy wyników przeprowadzonych tu badań.//",
    [3] = "Do pracy w gabinecie Badań Podstawowych wymagany jest Lekarz. ",
  },
  electrolysis = {
    [1] = "Gabinet Elektrolizy//",
    [2] = "Pacjenci cierpiący na Włochaciznę są kierowani do tego gabinetu, gdzie specjalna maszyna zwana Elektrolizerem wyszarpuje włosy i zalepia elektrycznie pory specjalną mieszaniną podobną do tynku.//",
    [3] = "Gabinet Elektrolizy potrzebuje Lekarza. Musi być także doglądany przez Dozorcę. ",
  },
  slack_tongue = {
    [1] = "Przychodnia Obrzynania//",
    [2] = "Pacjenci zdiagnozowani w Gabinecie Lekarskim z chorobą Obwisłego Języka są kierowani do tego gabinetu. Przy pomocy nowoczesnej aparatury Lekarz wyciąga i obcina język, przywracając pacjenta do zdrowia.//",
    [3] = "Przychodnia Obrzynania potrzebuje Lekarza. Wymaga również częstej konserwacji. ",
  },
  toilets = {
    [1] = "Toalety//",
    [2] = "Pacjenci, którzy poczują zew matki natury, będą musieli skorzystać z twoich komfortowych toalet. Jeżeli spodziewasz się dużo gości, możesz zbudować dodatkowe latryny i umywalki. Być może trzeba będzie rozważyć budowę kolejnych toalet w innych częściach szpitala. ",
  },
  no_room = {
    [1] = "",
  },
  x_ray = {
    [1] = "Rentgen//",
    [2] = "Rentgen używa specjalnych promieni, aby zrobić zdjęcie wnętrza pacjenta. Dzięki temu lekarz wie, co dzieje się wewnątrz chorego.//",
    [3] = "Rentgen wymaga Lekarza. Musi być także konserwowany. ",
  },
  decontamination = {
    [1] = "Gabinet Odkażania//",
    [2] = "Pacjenci, którzy zostali narażeni na Napromieniowanie są natychmiast kierowani do Gabinetu Odkażania. Pomieszczenie to posiada prysznic, który oczyszcza ich ze strasznego napromieniowania i brudu.//",
    [3] = "Do obsługi Prysznica wymagany jest Lekarz. Musi być także nadzorowany przez Dozorcę. ",
  },
}
errors = {
  unavailable_screen_size = "Rozmiar ekranu, który podałeś, nie jest obsługiwany w trybie pełnoekranowym.",
  dialog_missing_graphics = "Niestety, demo nie zawiera tego dialogu.",
  maximum_screen_size = "Proszę wpisać rozmiar ekranu, maksimum 3000x2000.",
  load_prefix = "Błąd podczas ładowania gry: ",
  no_games_to_contine = "Nie ma zapisanych gier.",
  save_prefix = "Błąd podczas zapisywania gry: ",
  map_file_missing = "Nie można znaleźć pliku z mapą %s dla tego poziomu!",
  minimum_screen_size = "Proszę wpisać rozmiar ekranu, minimum 640x480.",
}
bank_manager = {
  current_loan = "Pożyczka",
  balance = "Bilans",
  interest_payment = "Odsetki",
  hospital_value = "Wartość Szpitala",
  interest_rate = "Poziom Odsetek",
  insurance_owed = "Ubezpieczalnie",
  statistics_page = {
    balance = "Bilans",
    details = "Szczegóły",
    date = "Data",
    current_balance = "Obecny Stan Konta",
    money_in = "Dochody",
    money_out = "Wydatki",
  },
  inflation_rate = "Poziom Inflacji",
}
main_menu = {
  exit = "Wyjście",
  custom_level = "Gra niestandardowa",
  version = "Wersja: ",
  new_game = "Nowa gra",
  continue = "Powrót do gry",
  load_game = "Wczytaj grę",
  options = "Ustawienia",
  savegame_version = "Wersja zapisu: ",
}
date_format = {
  daymonth = "%1% %2:months%",
}
menu_display = {
  mcga_lo_res = "  NISKA ROZDZIELCZOŚĆ",
  shadows = "  CIENIE  ",
  high_res = "  WYSOKA ROZDZIELCZOŚĆ",
}
original_credits = {
  [1] = " ",
  [2] = " ",
  [3] = " ",
  [4] = " ",
  [5] = " ",
  [6] = " ",
  [7] = " ",
  [8] = " ",
  [9] = " ",
  [10] = " ",
  [11] = " ",
  [12] = ":Zaprojektowane i stworzone przez",
  [13] = ":Bullfrog Productions",
  [14] = " ",
  [15] = ":ekipa Pluto Development ",
  [16] = ",",
  [17] = "Mark Webley",
  [18] = "Gary Carr",
  [19] = "Matt Chilton",
  [20] = "Matt Sullivan",
  [21] = "Jo Rider",
  [22] = "Rajan Tande",
  [23] = "Wayne Imlach",
  [24] = "Andy Bass",
  [25] = "Jon Rennie",
  [26] = "Adam Coglan",
  [27] = "Natalie White",
  [28] = " ",
  [29] = " ",
  [30] = " ",
  [31] = ":Programowanie",
  [32] = ",",
  [33] = "Mark Webley",
  [34] = "Matt Chilton",
  [35] = "Matt Sullivan",
  [36] = "Rajan Tande",
  [37] = " ",
  [38] = " ",
  [39] = " ",
  [40] = ":Oprawa graficzna",
  [41] = ",",
  [42] = "Gary Carr",
  [43] = "Jo Rider",
  [44] = "Andy Bass",
  [45] = "Adam Coglan",
  [46] = " ",
  [47] = " ",
  [48] = " ",
  [49] = ":Dodatkowe programowanie",
  [50] = ",",
  [51] = "Ben Deane",
  [52] = "Gary Morgan",
  [53] = "Jonty Barnes",
  [54] = " ",
  [55] = " ",
  [56] = " ",
  [57] = ":Dodatkowa grafika",
  [58] = ",",
  [59] = "Eoin Rogan",
  [60] = "George Svarovsky",
  [61] = "Saurev Sarkar",
  [62] = "Jason Brown",
  [63] = "John Kershaw",
  [64] = "Dee Lee",
  [65] = " ",
  [66] = " ",
  [67] = " ",
  [68] = ":Intro",
  [69] = ",",
  [70] = "Stuart Black",
  [71] = " ",
  [72] = " ",
  [73] = " ",
  [74] = ":Muzyka i efekty dźwiękowe",
  [75] = ",",
  [76] = "Russell Shaw",
  [77] = "Adrian Moore",
  [78] = " ",
  [79] = " ",
  [80] = " ",
  [81] = ":Dodatkowa muzyka",
  [82] = ",",
  [83] = "Jeremy Longley",
  [84] = "Andy Wood",
  [85] = " ",
  [86] = " ",
  [87] = " ",
  [88] = ":Lektor",
  [89] = ",",
  [90] = "Rebecca Green",
  [91] = " ",
  [92] = " ",
  [93] = " ",
  [94] = ":Projekty poziomów",
  [95] = ",",
  [96] = "Wayne Imlach",
  [97] = "Natalie White",
  [98] = "Steven Jarrett",
  [99] = "Shin Kanaoya",
  [100] = " ",
  [101] = " ",
  [102] = " ",
  [103] = ":Skrypty",
  [104] = ",",
  [105] = "James Leach",
  [106] = "Sean Masterson",
  [107] = "Neil Cook",
  [108] = " ",
  [109] = " ",
  [110] = " ",
  [111] = ":R&D",
  [112] = " ",
  [113] = ":Silnik graficzny",
  [114] = ",",
  [115] = "Andy Cakebread",
  [116] = "Richard Reed",
  [117] = " ",
  [118] = " ",
  [119] = " ",
  [120] = ":Wsparcie R&D",
  [121] = ",",
  [122] = "Glenn Corpes",
  [123] = "Martin Bell",
  [124] = "Ian Shaw",
  [125] = "Jan Svarovsky",
  [126] = " ",
  [127] = " ",
  [128] = " ",
  [129] = ":Biblioteki i narzędzia",
  [130] = " ",
  [131] = "Biblioteki Dos i Win 95",
  [132] = ",",
  [133] = "Mark Huntley",
  [134] = "Alex Peters",
  [135] = "Rik Heywood",
  [136] = " ",
  [137] = " ",
  [138] = " ",
  [139] = ":Biblioteki sieciowe",
  [140] = ",",
  [141] = "Ian Shippen",
  [142] = "Mark Lamport",
  [143] = " ",
  [144] = " ",
  [145] = " ",
  [146] = ":Biblioteki dźwięku",
  [147] = ",",
  [148] = "Russell Shaw",
  [149] = "Tony Cox",
  [150] = " ",
  [151] = " ",
  [152] = " ",
  [153] = ":Instalator",
  [154] = ",",
  [155] = "Andy Nuttall",
  [156] = "Tony Cox",
  [157] = "Andy Cakebread",
  [158] = " ",
  [159] = " ",
  [160] = " ",
  [161] = ":Wsparcie duchowe",
  [162] = ",",
  [163] = "Peter Molyneux",
  [164] = " ",
  [165] = " ",
  [166] = " ",
  [167] = ":Menadżer testowania",
  [168] = ",",
  [169] = "Andy Robson",
  [170] = " ",
  [171] = " ",
  [172] = " ",
  [173] = ":Główni testerzy",
  [174] = ",",
  [175] = "Wayne Imlach",
  [176] = "Jon Rennie",
  [177] = " ",
  [178] = " ",
  [179] = " ",
  [180] = ":Testerzy",
  [181] = ",",
  [182] = "Jeff Brutus",
  [183] = "Wayne Frost",
  [184] = "Steven Lawrie",
  [185] = "Tristan Paramor",
  [186] = "Nathan Smethurst",
  [187] = " ",
  [188] = "Ryan Corkery",
  [189] = "Simon Doherty",
  [190] = "James Dormer",
  [191] = "Martin Gregory",
  [192] = "Ben Lawley",
  [193] = "Joel Lewis",
  [194] = "David Lowe",
  [195] = "Robert Monczak",
  [196] = "Dominic Mortoza",
  [197] = "Karl O'Keeffe",
  [198] = "Michael Singletary",
  [199] = "Andrew Skipper",
  [200] = "Stuart Stephen",
  [201] = "David Wallington",
  [202] = " ",
  [203] = "oraz pozostali testerzy",
  [204] = " ",
  [205] = " ",
  [206] = " ",
  [207] = ":Wsparcie techniczne",
  [208] = ",",
  [209] = "Kevin Donkin",
  [210] = "Mike Burnham",
  [211] = "Simon Handby",
  [212] = " ",
  [213] = " ",
  [214] = " ",
  [215] = ":Marketing",
  [216] = ",",
  [217] = "Pete Murphy",
  [218] = "Sean Ratcliffe",
  [219] = " ",
  [220] = " ",
  [221] = " ",
  [222] = ":Z podziękowaniami dla:",
  [223] = ",",
  [224] = "Tamara Burke",
  [225] = "Annabel Roose",
  [226] = "Chris Morgan",
  [227] = "Pete Larsen",
  [228] = " ",
  [229] = " ",
  [230] = " ",
  [231] = ":PR",
  [232] = ",",
  [233] = "Cathy Campos",
  [234] = " ",
  [235] = " ",
  [236] = " ",
  [237] = ":Dokumentacja",
  [238] = ",",
  [239] = "Mark Casey",
  [240] = "Richard Johnston",
  [241] = "James Lenoel",
  [242] = "Jon Rennie",
  [243] = " ",
  [244] = " ",
  [245] = " ",
  [246] = ":Dokumentacja i projekt pudełka",
  [247] = ",",
  [248] = "Caroline Arthur",
  [249] = "James Nolan",
  [250] = " ",
  [251] = " ",
  [252] = " ",
  [253] = ":Menadżer lokalizacji",
  [254] = ",",
  [255] = "Carol Aggett",
  [256] = " ",
  [257] = " ",
  [258] = " ",
  [259] = ":Lokalizacja",
  [260] = ",",
  [261] = "Sandra Picaper",
  [262] = "Sonia 'Sam' Yazmadjian",
  [263] = " ",
  [264] = "Bettina Klos",
  [265] = "Alexa Kortsch",
  [266] = "Bianca Normann",
  [267] = " ",
  [268] = "C.T.O. S.p.A. Zola Predosa (BO)",
  [269] = "Gian Maria Battistini",
  [270] = "Maria Ziino",
  [271] = "Gabriele Vegetti",
  [272] = " ",
  [273] = "Elena Ruiz de Velasco",
  [274] = "Julio Valladares",
  [275] = "Ricardo Martínez",
  [276] = " ",
  [277] = "Kia Collin",
  [278] = "CBG Consult",
  [279] = "Ulf Thor",
  [280] = " ",
  [281] = " ",
  [282] = " ",
  [283] = ":Realizacja",
  [284] = ",",
  [285] = "Rachel Holman",
  [286] = " ",
  [287] = " ",
  [288] = " ",
  [289] = ":Producent",
  [290] = ",",
  [291] = "Mark Webley",
  [292] = " ",
  [293] = " ",
  [294] = " ",
  [295] = ":Współproducent",
  [296] = ",",
  [297] = "Andy Nuttall",
  [298] = " ",
  [299] = " ",
  [300] = " ",
  [301] = ":Wdrożenie",
  [302] = ",",
  [303] = "Steve Fitton",
  [304] = " ",
  [305] = " ",
  [306] = " ",
  [307] = ":Administracja firmy",
  [308] = ",",
  [309] = "Audrey Adams",
  [310] = "Annette Dabb",
  [311] = "Emma Gibbs",
  [312] = "Lucia Gobbo",
  [313] = "Jo Goodwin",
  [314] = "Sian Jones",
  [315] = "Kathy McEntee",
  [316] = "Louise Ratcliffe",
  [317] = " ",
  [318] = " ",
  [319] = " ",
  [320] = ":Zarząd spółki",
  [321] = ",",
  [322] = "Les Edgar",
  [323] = "Peter Molyneux",
  [324] = "David Byrne",
  [325] = " ",
  [326] = " ",
  [327] = ":Zespół Bullfrog Productions",
  [328] = " ",
  [329] = " ",
  [330] = " ",
  [331] = ":Specjalne podziękowania dla",
  [332] = ",",
  [333] = "Pracowników szpitala Frimley Park",
  [334] = " ",
  [335] = ":a zwłaszcza dla",
  [336] = ",",
  [337] = "Beverley Cannell",
  [338] = "Doug Carlisle",
  [339] = " ",
  [340] = " ",
  [341] = " ",
  [342] = ":Do spolszczenia szpitalnych perypetii przyczynili się",
  [343] = "bemberg, jako anestezjolog - tłumaczenie, korekta, testy",
  [344] = "Butcher, jako ordynator - pomysłodawca, tłumaczenie, korekta, czcionka, testy",
  [345] = "Johnny, jako pielęgniarz - korekta",
  [346] = "Machiner, jako lekarz pierwszego kontaktu - tłumaczenie, korekta",
  [347] = "mziab, jako chirurg - tłumaczenie, czcionka, korekta,",
  [348] = "narzędzia i przygotowanie skryptu do oprogramowania CAT",
  [349] = "spec0071, jako pielęgniarz - korekta, testy",
  [350] = "twig, jako konsultant - sprawy techniczne",
  [351] = " ",
  [352] = ":Miej głowę na karku",
  [353] = " ",
  [354] = " ",
  [355] = " ",
  [356] = " ",
  [357] = " ",
  [358] = " ",
  [359] = " ",
  [360] = " ",
  [361] = ".",
}
pay_rise = {
  definite_quit = "Cokolwiek zrobisz, nic mnie tu już nie zatrzyma. Mam dość tego miejsca.",
  regular = {
    [1] = "Jestem wykończony. Jeżeli nie chcesz, bym rzucił tę zakichaną robotę, pozwól mi odpocząć oraz daj podwyżkę o %d.",
    [2] = "Jestem bardzo zmęczony. Żądam odpoczynku i podwyżki o %d, z pensją %d. No dalej, tyranie!",
    [3] = "Daj spokój. Haruję tu jak pies. Daj mi premię %d, to zostanę w twoim szpitalu.",
    [4] = "Jestem bardzo niezadowolony. Żądam podwyżki o %d, dającej mi pensję %d, inaczej spadam stąd.",
    [5] = "Rodzice mówili mi, że w medycynie można sporo zarobić. Albo więc dasz mi podwyżkę o %d, albo zostanę producentem gier.",
    [6] = "Mam dosyć. Daj mi przyzwoitą pensję. Podwyżka o %d powinna wystarczyć.",
  },
  poached = "%s zaproponowali mi %d. Jeśli nie zapłacisz mi tyle samo, odchodzę.",
}
menu_debug = {
  lua_console = "  (F12) KONSOLA LUA  ",
  porter_pagers = "  PORTER PAGERS        ",
  object_cells = "  OBJECT CELLS         ",
  display_pager = "  DISPLAY PAGER        ",
  disable_salary_raise = "  DISABLE SALARY RAISE  ",
  make_debug_fax = "  MAKE DEBUG FAX  ",
  display_big_cells = "  DISPLAY BIG CELLS    ",
  make_debug_patient = "  MAKE DEBUG PATIENT  ",
  mapwho_checking = "  MAPWHO CHECKING      ",
  sprite_viewer = "  SPRITE VIEWER  ",
  keep_clear_cells = "  KEEP CLEAR CELLS     ",
  dump_strings = "  DUMP STRINGS  ",
  machine_pagers = "  MACHINE PAGERS       ",
  remove_walls = "  USUŃ ŚCIANY         ",
  enter_nav_debug = "  ENTER NAV DEBUG      ",
  lose_game_anim = {
    [1] = "  LOSE GAME 1 ANIM     ",
    [2] = "  LOSE GAME 2 ANIM     ",
    [3] = "  LOSE GAME 3 ANIM     ",
    [4] = "  LOSE GAME 4 ANIM     ",
    [5] = "  LOSE GAME 5 ANIM     ",
    [6] = "  LOSE GAME 6 ANIM     ",
    [7] = "  LOSE GAME 7 ANIM     ",
  },
  map_overlay = "  MAP OVERLAY  ",
  calls_dispatcher = "  CALLS DISPATCHER  ",
  show_nav_cells = "  SHOW NAV CELLS       ",
  win_game_anim = "  WIN GAME ANIM        ",
  display_room_status = "  DISPLAY ROOM STATUS  ",
  cheats = "  (F11) CHEATS  ",
  remove_objects = "  USUŃ OBIEKTY       ",
  nav_bits = "  NAV BITS             ",
  win_level_anim = "  WIN LEVEL ANIM       ",
  dump_gamelog = "  (CTRL+D) DUMP GAME LOG  ",
  limit_camera = "  LIMIT CAMERA  ",
  pixbuf_cells = "  PIXBUF CELLS         ",
  transparent_walls = "  (X) TRANSPARENT WALLS  ",
  show_help_hotspot = "  SHOW HELP HOTSPOTS   ",
  jump_to_level = "  JUMP TO LEVEL  ",
  entry_cells = "  ENTRY CELLS          ",
  plant_pagers = "  PLANT PAGERS         ",
}
progress_report = {
  free_build = "WOLNA BUDOWA",
  too_hot = "Zrób coś z centralnym ogrzewaniem. Jest za gorąco. ",
  percentage_pop = "% populacji",
  win_criteria = "KRYTERIA ZWYCIĘSTWA",
  very_unhappy = "Twoi ludzie są bardzo niezadowoleni. ",
  quite_unhappy = "Twoi ludzie są niezadowoleni. ",
  header = "Informacje o postępie",
  too_cold = "Jest zdecydowanie za zimno. Dokup kaloryfery. ",
  more_drinks_machines = "Kup więcej Automatów do napoi. ",
}
menu_options = {
  game_speed = "  SZYBKOŚĆ GRY ",
  music_vol = "  GŁOŚNOŚĆ MUZYKI ",
  sound_vol = "  GŁOŚNOŚĆ DŹWIĘKU ",
  adviser_disabled = "  DORADCA  ",
  warmth_colors = "  CIEPŁOŚĆ BARW  ",
  edge_scrolling = "  PRZEWIJANIE PRZY KRAWĘDZIACH  ",
  announcements = "  POWIADOMIENIA   ",
  lock_windows = "  ZABLOKUJ OKNA  ",
  settings = "  USTAWIENIA  ",
  sound = "  DŹWIĘK   ",
  announcements_vol = "  GŁOŚNOŚĆ POWIADOMIEŃ  ",
  music = "  MUZYKA  ",
  autosave = "  AUTOZAPIS ",
  jukebox = "  SZAFA GRAJĄCA ",
}
menu_options_warmth_colors = {
  choice_1 = "  CZERWONY  ",
  choice_2 = "  NIEBIESKI ZIELONY CZERWONY  ",
  choice_3 = "  ŻÓŁTY POMARAŃCZOWY CZERWONY  ",
}

menu_options_game_speed = {
  pause               = "  (P) PAUZA  ",
  slowest             = "  (1) NAJWOLNIEJ  ",
  slower              = "  (2) WOLNO  ",
  normal              = "  (3) NORMALNIE  ",
  max_speed           = "  (4) NAJSZYBCIEJ  ",
  and_then_some_more  = "  (5) I JESZCZE TROCHĘ  ",
}
rooms_short = {
  ultrascan = "Ultraskaner",
  research_room = "Dział Badawczy",
  fracture_clinic = "Gab. Ortopedyczny",
  gps_office = "Gabinet Lekarski",
  destroyed = "Zniszczone",
  staffroom = "Pokój Socjalny",
  jelly_vat = "Galaretownica",
  scanner = "Skaner",
  decontamination = "Gabinet Odkażania",
  pharmacy = "Apteka",
  cardiogram = "Kardiograf",
  reception = "Recepcja",
  training_room = "Sala Szkoleniowa",
  corridor_objects = "Obiekty Korytarza",
  operating_theatre = "Sala Operacyjna",
  dna_fixer = "Re-GEN-erator",
  ward = "Oddział",
  psychiatric = "Psychiatra",
  hair_restoration = "Przeszczep Włosów",
  general_diag = "Podst. Badania",
  inflation = "Napowietrzalnia",
  tongue_clinic = "Przych. Obrzynania",
  toilets = "Toalety",
  electrolysis = "Gabinet Elektrolizy",
  x_ray = "Rentgen",
  blood_machine = "Analizator Krwi",
}
level_names = {
  [1] = "BIAŁOBYL",
  [2] = "ŚPIOCHY DUŻE",
  [3] = "ŚWIĄDEK ZDRÓJ",
  [4] = "ZASTRZYKI GÓRNE",
  [5] = "PROSTACZKOWO",
  [6] = "ROPIEŃ DOLNY",
  [7] = "ZIELONA GULA",
  [8] = "ZAKICHANE",
  [9] = "SZARYSTOK",
  [10] = "JAJECZNICA MAŁA",
  [11] = "ŻABOBRZEGI",
  [12] = "CHORUŃ",
  [13] = "MIŁOGRÓD",
  [14] = "WYCISK MAŁY",
  [15] = "ZIELSKO-BIAŁA",
}
insurance_companies = {
  [1] = "Łabądek Ltd.",
  [2] = "Cebula z Norfolk ",
  [3] = "Lodołamacz S.A.",
  [4] = "Potężny Żołądź Ltd.",
  [5] = "Pęcherz Walenia",
  [6] = "Poczciwy Józef S.A.",
  [7] = "Holding Pulchnego",
  [8] = "Leon Katz Corp.",
  [9] = "Buch i Faja S.A.",
  [10] = "Fikuśne Westalki",
  [11] = "Ubezp. Syndykatowe",
  out_of_business = "ZAKOŃCZYŁ DZIAŁALNOŚĆ",
}
lua_console = {
  execute_code = "Start",
  close = "Zamknij",
}
staff_descriptions = {
  good = {
    [1] = "Bardzo szybki i pilny pracownik. ",
    [2] = "Bardzo sumienny pracownik. Przykłada się. ",
    [3] = "Ma szeroką skalę umiejętności. ",
    [4] = "Bardzo przyjazny i lubiący śmiech pracownik. ",
    [5] = "Super wytrzymały pracownik. Ciągle brnie naprzód. ",
    [6] = "Nadzwyczaj uprzejmy i miły pracownik. ",
    [7] = "Niewiarygodnie utalentowany pracownik. ",
    [8] = "Zawsze dba o to, co robi. ",
    [9] = "Perfekcjonista, który się nie poddaje. ",
    [10] = "Pomaga ludziom z uśmiechem na ustach. ",
    [11] = "Czarujący, miły i pomocny pracownik. ",
    [12] = "Generalnie dobrze zmotywowany i oddany pracownik. ",
    [13] = "Przyjacielski i bardzo wydajny pracownik. ",
    [14] = "Lojalny i przyjazny pracownik. ",
    [15] = "Pracownik staranny i niezawodny w nagłych wypadkach. ",
  },
  misc = {
    [1] = "Gra w golfa. ",
    [2] = "Nurkuje. ",
    [3] = "Rzeźbi w lodzie. ",
    [4] = "Pija wino. ",
    [5] = "Jeździ wyścigówkami. ",
    [6] = "Skacze na bungie. ",
    [7] = "Kolekcjonuje pokale. ",
    [8] = "Lubi skoki ze sceny. ",
    [9] = "Lubi surfing. ",
    [10] = "Poszerza rzeki. ",
    [11] = "Destyluje bimber. ",
    [12] = "Złota rączka. ",
    [13] = "Lubi francuskie kino. ",
    [14] = "Często gra w Theme Park. ",
    [15] = "Jeździ TIRem. ",
    [16] = "Ściga się na motorach. ",
    [17] = "Gra na skrzypcach i wiolonczeli. ",
    [18] = "Wysadza pociągi. ",
    [19] = "Uwielbia psy. ",
    [20] = "Słucha radia. ",
    [21] = "Bierze częste kąpiele. ",
    [22] = "Plecie kosze z wikliny. ",
    [23] = "Przerabia warzywa na mydelniczki. ",
    [24] = "Pracuje w policji na pół etatu. ",
    [25] = "Była hostessa w TV. ",
    [26] = "Kolekcjonuje szrapnele. ",
    [27] = "Przestawia meble. ",
    [28] = "Słucha muzyki rave i trip-hopu. ",
    [29] = "Rozwściecza insekty dezodorantami. ",
    [30] = "Przeszkadza satyrykom w występach. ",
    [31] = "Węszy w urzędach. ",
    [32] = "Skryty ogrodnik. ",
    [33] = "Przemyca trefne zegarki. ",
    [34] = "Śpiewa w zespole rockowym. ",
    [35] = "Uwielbia telewizję śniadaniową. ",
    [36] = "Łaskocze pstrągi. ",
    [37] = "Drażni turystów w muzeach. ",
  },
  bad = {
    [1] = "Powolny i kapryśny pracownik. ",
    [2] = "Leniwy i słabo zmotywowany pracownik. ",
    [3] = "Niekompetentny i nieudolny pracownik. ",
    [4] = "Niegrzeczny i zgryźliwy pracownik. Czepia się ludzi. ",
    [5] = "Ma straszliwą wytrzymałość - i złe nastawienie. ",
    [6] = "Głuchy jak pień pracownik. Trochę cuchnie kapustą. ",
    [7] = "W pracy do niczego. Jest jak kula u nogi. ",
    [8] = "Lekkomyślny i roztargniony pracownik. ",
    [9] = "Zestresowany pracownik, popełnia błędy. ",
    [10] = "Pracownik zgorzkniały i obrażony - płonący z nienawiści. ",
    [11] = "Flejtuch powodujący wypadki. ",
    [12] = "Nie dba o pracę. W sumie nie dba o nic. ",
    [13] = "Bezmyślny ryzykant, któremu wszystko zwisa. ",
    [14] = "Szczwany, przebiegły wywrotowiec. ",
    [15] = "Arogancki i próżny pracownik. ",
  },
}
room_classes = {
  diagnosis = "Diagnozy",
  clinics = "Przychodnie",
  facilities = "Udogodnienia",
  treatment = "Leczenie",
}
install = {
  exit = "Wyjście",
  th_directory = "CorsixTH potrzebuje plików z originalnej gry Theme Hospital (lub dema), do poprawnego działania. Proszę użyć poniższego pola, w celu zlokalizowania zainstalowanej gry Theme Hospital.",
  title = "--------------------------------- Ustawienia CorsixTH ---------------------------------",
}
place_objects_window = {
  pick_up_object = "Kliknij na obiekt, aby go podnieść lub wybierz inną opcję",
  place_objects_in_corridor = "Rozmieść obiekty na korytarzu",
  place_windows = "Jeżeli chcesz, wstaw okna i kliknij zatwierdź",
  confirm_or_buy_objects = "Możesz zatwierdzić pokój lub dokupić nowe przedmioty",
  drag_blueprint = "Rozciągnij niebieskie pole do odpowiedniego rozmiaru",
  place_door = "Wstaw drzwi",
  place_objects = "Rozmieść i poprzesuwaj wszystkie obiekty, następnie zatwierdź",
}
newspaper = {
  [1] = {
    [1] = "ORTOPEDA WILKOŁAKIEM!",
    [2] = "INTERNISTA UDAJE BOGA!",
    [3] = "SZOK FRANKENSTEINA",
    [4] = "CO KRYŁA MASKA CHIRURGA?",
    [5] = "RYZYKOWNE BADANIA ZATRZYMANE ",
  },
  [2] = {
    [1] = "ULULANY KONOWAŁ",
    [2] = "CHIRURG PŁUCZE NERKI",
    [3] = "KONSULTANT NA GAZIE",
    [4] = "BEŁT NA ZNIECZULENIE",
    [5] = "ON ZA KITEL NIE WYLEWA",
    [6] = "ORDYNATORYJNY DENATURAT",
  },
  [3] = {
    [1] = "CHCIWY CHIRURG",
    [2] = "LEKARZ Z RĘKĄ W BASENIE",
    [3] = "ZEJŚCIE DOKTORA",
    [4] = "NIENASYCONY CHIRURG",
  },
  [4] = {
    [1] = "NIEULECZALNY PRZEKRĘT",
    [2] = "WRZÓD PRZESTĘPCZY",
    [3] = "OPERACJA PRZESZCZEPU PIENIĘDZY",
    [4] = "ZATOR FINANSOWY",
  },
  [5] = {
    [1] = "ZDROWOTNE ŁUPIENIE GROBÓW",
    [2] = "LEKARZ HIENĄ CMENTARNĄ",
    [3] = "PO JEGO TRUPIE",
    [4] = "DZIEŃ ROZRACHUNKU DOKTORA ŚMIERCI",
    [5] = "ŚMIERTELNA NIEDBAŁOŚĆ",
    [6] = "CMENTARNE WYKOPKI",
  },
  [6] = {
    [1] = "DOKTOR ZASZYTY!",
    [2] = "NIEUWAŻNY ZNACHOR",
    [3] = "PONURA DIAGNOZA",
    [4] = "NIESPECJALNY SPECJALISTA",
  },
  [7] = {
    [1] = "DOKTOROWI POSYPAŁY SIĘ KULKI",
    [2] = "CHIRURG SAM SIĘ ZOPEROWAŁ",
    [3] = "ROBÓTKI RĘCZNE W LATRYNIE",
    [4] = "DOKTOR GWIAZDĄ SKANDALU",
    [5] = "LEKARZ ZDROWO NAMIESZAŁ",
  },
}
load_game_window = {
  caption = "Wczytaj Grę (%1%)",
}
staff_title = {
  junior = "Asystent",
  psychiatrist = "Psychiatra",
  consultant = "Konsultant",
  surgeon = "Chirurg",
  doctor = "Lekarz",
  researcher = "Naukowiec",
  nurse = "Pielęgniarka",
  receptionist = "Recepcjonistka",
  general = "Ogólne",
}
graphs = {
  deaths = "Zgony",
  money_in = "Dochody",
  money_out = "Wydatki",
  visitors = "Pacjenci",
  wages = "Wypłaty",
  balance = "Bilans",
  time_spans = {
    [1] = "1 Rok",
    [2] = "12 Lat",
    [3] = "48 Lat",
  },
  cures = "Wyleczeni",
  reputation = "Reputacja",
}
adviser = {
  tutorial = {
    hire_receptionist = "Będzie ci także potrzebna Recepcjonistka do rejestrowania pacjentów.",
    build_pharmacy = "Gratulacje! Teraz zbuduj Aptekę i zatrudnij w niej Pielęgniarkę, aby szpital wreszcie mógł zacząć pracę.",
    hire_doctor = "Potrzebujesz Lekarza do diagnozowania i leczenia chorych.",
    place_receptionist = "Umieść Recepcjonistkę w którymkolwiek miejscu szpitala. Jest ona na tyle sprytna, że sama znajdzie drogę do biurka.",
    place_windows = "Umieść okna w ten sam sposób co drzwi. Okna nie są wymagane, jednak twój personel będzie szczęśliwszy, gdy wyjrzy sobie na zewnątrz.",
    confirm_room = "Kliknij na migającą ikonę, aby otworzyć gabinet lub kliknij X, aby anulować.",
    rotate_and_place_reception = "Kliknij prawym przyciskiem myszy, aby obrócić Biurko, a lewym, aby umieścić je w wybranym miejscu.",
    build_reception = "Witaj. Na początku twój szpital potrzebuje Biurko Recepcji. Wybierz je z menu Wyposażenie Korytarza.",
    doctor_in_invalid_position = "Hej! Nie możesz tutaj umieścić Lekarza.",
    start_tutorial = "Przeczytaj Zadania Misji, a następnie kliknij, aby rozpocząć szkolenie.",
    receptionist_invalid_position = "Nie możesz tutaj umieścić Recepcjonistki.",
    room_too_small_and_invalid = "Pomieszczenie jest za małe i stoi w niewłaściwym miejscu. Bez żartów.",
    window_in_invalid_position = "To okno jest w niewłaściwym miejscu. Byłoby miło, gdybyś wstawił je gdzie indziej.",
    choose_doctor = "Sprawdź dokładnie kwalifikacje każdego Lekarza, zanim któregoś wybierzesz.",
    information_window = "Okno pomocy powie ci wszystko na temat tego pięknego Gabinetu Lekarskiego, który właśnie zbudowałeś.",
    build_gps_office = "Aby rozpocząć diagnozowanie chorych, musisz wybudować Gabinet Lekarski.",
    select_doctors = "Kliknij lewym przyciskiem myszy na migającej ikonie, aby zobaczyć dostępnych Lekarzy.",
    select_diagnosis_rooms = "Kliknij w migającą ikonę, aby wyświetlić listę gabinetów diagnostycznych.",
    select_receptionists = "Kliknij na migającej ikonie, aby wyświetlić dostępne Recepcjonistki. Numer na ikonie informuje, ile jest chętnych do pracy.",
    order_one_reception = "Kliknij lewym przyciskiem myszy w migającą linię, aby zamówić jedno Biurko Recepcyjne.",
    choose_receptionist = "Wybierz Recepcjonistkę, która ma dobre kwalifikacje oraz jest niedroga, a następnie kliknij na migającej ikonie, aby ją zatrudnić.",
    prev_receptionist = "Kliknij w migającą ikonę, aby zobaczyć poprzednią Recepcjonistkę.",
    accept_purchase = "Kliknij w migającą ikonę, aby je zakupić.",
    place_door = "Przesuń kursor po niebieskiej linii, aby umieścić drzwi w wybranym miejscu.",
    click_and_drag_to_build = "Zanim zbudujesz Gabinet Lekarski, musisz zdecydować o jego rozmiarach. Przytrzymaj lewy przycisk myszy i rozciągnij gabinet do odpowiedniej wielkości.",
    room_in_invalid_position = "Ojej! Rozmiar pomieszczenia jest niewłaściwy - czerwona strefa pokazuje miejsce, gdzie nachodzi on na inne pomieszczenia lub na ściany szpitala.",
    place_objects = "Prawy przycisk myszy obraca przedmioty, lewy ustawia je w danym miejscu.",
    room_too_small = "Kolor czerwony oznacza, że pokój jest za mały. Rozciągnij go trochę, aby go powiększyć.",
    click_gps_office = "Kliknij w migającą linię, aby wybrać Gabinet Lekarski.",
    reception_invalid_position = "Biurko Recepcji jest szare, gdyż znajduje się w niewłaściwym miejscu. Spróbuj je przesunąć lub obrócić.",
    next_receptionist = "To pierwsza Recepcjonistka na liście. Kliknij w migającą ikonę, aby zobaczyć następną Recepcjonistkę.",
    room_big_enough = "Rozmiar gabinetu jest teraz odpowiedni. Kiedy puścisz przycisk, gabinet zostanie zbudowany. Pamiętaj, że zawsze możesz go przesunąć lub zmienić jego rozmiary.",
    object_in_invalid_position = "Ten przedmiot jest w niewłaściwym miejscu. Obróć go lub umieść gdzie indziej.",
    door_in_invalid_position = "Ech! Próbujesz umieścić drzwi w niewłaściwym miejscu. Spróbuj wstawić je gdzie indziej.",
    place_doctor = "Umieść doktora w którymkolwiek miejscu szpitala. Samodzielnie uda się do Gabinetu Lekarskiego i rozpocznie pracę.",
  },
  epidemic = {
    hurry_up = "Jeżeli natychmiast nie zaradzisz tej epidemii, znajdziesz się w niezłych tarapatach. Rusz się!",
    serious_warning = "Ta Zaraźliwa Choroba zaczyna być poważna. Musisz szybko coś zrobić!",
    multiple_epidemies = "Wygląda na to, że w szpitalu szaleje więcej niż jedna epidemia. To może skończyć się kolosalna katastrofą, więc lepiej zacznij działać.",
  },
  staff_advice = {
    need_handyman_machines = "Jeśli chcesz zachować przyrządy szpitalne w dobrym stanie, musisz zatrudnić Dozorcę.",
    need_doctors = "Potrzebujesz więcej Lekarzy. Umieść najlepszych Lekarzy w gabinetach z najdłuższą kolejką.",
    need_handyman_plants = "Musisz zatrudnić Dozorcę, aby podlewał rośliny.",
    need_handyman_litter = "Ludzie zaczęli zaśmiecać twój szpital. Zatrudnij Dozorcę, aby po nich sprzątał.",
    need_nurses = "Musisz zatrudnić więcej Pielęgniarek. Oddział oraz Apteka potrzebują Pielęgniarki.",
    too_many_doctors = "Masz za dużo Lekarzy. Niektórzy z nich nie mają w tej chwili co robić.",
    too_many_nurses = "Myślę, że obecnie zatrudniasz zbyt wiele Pielęgniarek.",
  },
  earthquake = {
    damage = "W wyniku trzęsienia ziemi %d urządzeń zostało uszkodzonych i %d ludzi rannych.",
    alert = "Zbliża się trzęsienie ziemi, podczas którego przyrządy szpitalne ulegną uszkodzeniu. Mogą też zostać zniszczone, jeśli są w kiepskim stanie.",
    ended = "Uff... A już myślałem, że to Gruba Berta -  %d  w skali Richtera.",
  },
  multiplayer = {
    objective_completed = "Poradziłeś sobie z ostatnim zadaniem. Gratulacje!",
    everyone_failed = "Nikt nie poradził sobie z ostatnim zadaniem. W związku z tym wszyscy pozostają w grze!",
    players_failed = "Następujący gracz(e) nie wykonali ostatniego zadania: ",
    poaching = {
      in_progress = "Dam ci znać, czy ta osoba chce pracować dla ciebie.",
      not_interested = "Ha! Nie mają ochoty pracować dla ciebie - dobrze im tam, gdzie teraz są.",
      already_poached_by_someone = "Niemożliwe! Ktoś próbuje podkupić tę osobę.",
    },
    objective_failed = "Nie poradziłeś sobie z ostatnim zadaniem.",
  },
  surgery_requirements = {
    need_surgeons_ward_op = "Musisz zatrudnić dwóch Chirurgów oraz zbudować Oddział i Salę Operacyjną, aby rozpocząć przeprowadzanie operacji.",
    need_surgeon_ward = "Musisz zatrudnić jeszcze jednego Chirurga i wybudować Oddział, aby rozpocząć prowadzenie Operacji.",
  },
  vomit_wave = {
    started = "Wygląda na to, że w twoim szpitalu zalągł się wirus wymiocin. Gdybyś bardziej dbał o czystość, ta sytuacja nie miałaby miejsca. Może powinieneś zatrudnić więcej Dozorców?",
    ended = "Uff! Zdaje się, że wirus, który wywołał tę falę wymiotów prawie całkiem zginął. Od tej chwili staraj się utrzymywać szpital w czystości.",
  },
  cheats = {
    th_cheat = "Gratulacje, odblokowałeś oszustwa!",
    hairyitis_cheat = "Oszustwo Włochacizna aktywowane!",
    roujin_on_cheat = "Wyzwanie Roujinowa aktywowane! Powodzenia...",
    crazy_on_cheat = "O nie! Wszyscy lekarze oszaleli!",
    bloaty_off_cheat = "Oszustwo Głowowzdęcie deaktywowane.",
    bloaty_cheat = "Oszustwo Głowowzdęcie aktywowane!",
    crazy_off_cheat = "Uff... lekarze wrócili do zdrowych zmysłów.",
    roujin_off_cheat = "Wyzwanie Roujinowa deaktywowane.",
    hairyitis_off_cheat = "Oszustwo Włochacizna deaktywowane.",
  },
  level_progress = {
    halfway_lost = "Jesteś w połowie drogi do przegrania tego poziomu.",
    dont_kill_more_patients = "Nie możesz sobie pozwolić na śmierć kolejnych pacjentów!",
    another_patient_killed = "O nie! Zabiłeś kolejnego pacjenta. Masz już na koncie %d zgonów.",
    halfway_won = "Jesteś w połowie drogi do ukończenia tego poziomu.",
    close_to_win_increase_value = "Zbliżasz się do zwycięstwa. Zwiększ wartość swojego szpitala o %d.",
    financial_criteria_met = "Osiągnąłeś kryteria finansowe tego poziomu. Teraz utrzymaj stan konta powyżej %d i upewnij się, że szpital jest sprawnie prowadzony.",
    nearly_won = "Jesteś już bardzo blisko wygrania poziomu.",
    hospital_value_enough = "Utrzymaj wartość szpitala powyżej %d i zajmij się innymi problemami, aby wygrać ten poziom.",
    another_patient_cured = "Dobra robota - kolejny pacjent wyleczony. To juz %d.",
    three_quarters_lost = "Jeżeli nic nie zmienisz przegrasz ten poziom.",
    reputation_good_enough = "Twoja reputacja jest wystarczająca, aby wygrać ten poziom. Utrzymaj ją powyżej %d i rozwiąż pozostałe problemy, aby go ukończyć.",
    cured_enough_patients = "Wyleczyłeś wystarczająco pacjentów, ale musisz zaprowadzić w szpitalu większy porządek, aby wygrać ten poziom.",
    nearly_lost = "Jesteś bardzo bliski przegrania tego poziomu.",
    improve_reputation = "Musisz zwiększyć swoją reputację o %d, aby mieć szansę na zwycięstwo.",
    three_quarters_won = "Jeszcze trochę zostało ci do wygranej na tym poziomie.",
  },
  staff_place_advice = {
    receptionists_only_at_desk = "Recepcjonistka może pracować tylko w Recepcji.",
    only_psychiatrists = "Tylko Lekarz, który posiada specjalizację Psychiatry, może pracować w Gabinecie Psychiatrycznym.",
    only_surgeons = "Tylko Lekarz, który posiada specjalizację Chirurga, może pracować na Sali Operacyjnej.",
    only_nurses_in_room = "Jedynie Pielęgniarka może pracować w %s",
    only_doctors_in_room = "Jedynie Lekarz może pracować w %s",
    only_researchers = "Tylko Lekarz, który posiada specjalizację Naukowca, może pracować w Dziale Badawczym.",
    nurses_cannot_work_in_room = "Pielęgniarka nie może pracować w %s",
    doctors_cannot_work_in_room = "Lekarz nie może pracować w %s",
  },
  room_forbidden_non_reachable_parts = "Budując tutaj to pomieszczenie, zablokujesz dostęp do pozostałych części szpitala.",
  research = {
    machine_improved = "Urządzenie %s zostało ulepszone przez Dział Badawczy.",
    autopsy_discovered_rep_loss = "Wyciekły informacje o używaniu maszyny do Auto-Autopsji. Spodziewaj się negatywnych reakcji opinii publicznej.",
    drug_fully_researched = "Doprowadziłeś badanie %s do 100%.",
    new_machine_researched = "Nowy %s właśnie został odkryty.",
    drug_improved = "Lek %s właśnie został udoskonalony przez twój Dział Badawczy.",
    new_available = "Nowy %s został udostępniony.",
    new_drug_researched = "Nowy specyfik leczący %s właśnie został odkryty.",
  },
  boiler_issue = {
    minimum_heat = "Ach, tutaj jesteś. Bojler w piwnicy się zepsuł. Wygląda na to, że ludzie w twoim szpitalu zaczną nieco marznąć.",
    maximum_heat = "Bojler w piwnicy dostał bzika i kaloryfery strasznie się rozgrzały. Ludzie zaraz zaczną się roztapiać! Postaw więcej Automatów do napoi.",
    resolved = "Dobra wiadomość. Bojler i kaloryfery znowu działają poprawnie. Temperatura powinna być już odpowiednia dla pacjentów i personelu.",
  },
  competitors = {
    staff_poached = "Jeden z twoich pracowników został podkupiony przez inny Szpital.",
    hospital_opened = "%s otworzył w okolicy konkurencyjny szpital. ",
    land_purchased = "%s właśnie kupił nowe tereny.",
  },
  room_requirements = {
    research_room_need_researcher = "W Gabinecie Badawczym musisz zatrudnić Lekarza że specjalizacją Naukowca.",
    op_need_another_surgeon = "Musisz zatrudnić jeszcze jednego Chirurga, aby możliwe było prowadzenie operacji.",
    op_need_ward = "Zanim poddasz pacjentów operacji, musisz zbudować Oddział Przedzabiegowy.",
    reception_need_receptionist = "Musisz zatrudnić Recepcjonistkę, aby rejestrować pacjentów.",
    psychiatry_need_psychiatrist = "Zbudowałeś Gabinet Psychiatryczny, musisz jeszcze zatrudnić Psychiatrę.",
    pharmacy_need_nurse = "Musisz zatrudnić Pielęgniarkę w tej Aptece.",
    ward_need_nurse = "Musisz zatrudnić Pielęgniarkę do pracy na tym Oddziale.",
    op_need_two_surgeons = "Zatrudnij dwóch Chirurgów do pracy w Sali Operacyjnej.",
    training_room_need_consultant = "Musisz zatrudnić Konsultanta w tej Sali Szkoleniowej.",
    gps_office_need_doctor = "Musisz zatrudnić Lekarza do pracy w Gabinecie Lekarskim.",
  },
  goals = {
    win = {
      money = "Potrzebujesz kolejnych %d, aby spełnić wymogi finansowe tego poziomu.",
      cure = "Wylecz kolejnych %d pacjentów, a będziesz miał ich wystarczająco dużo, aby wygrać ten poziom.",
      reputation = "Zwiększ swoja reputację do %d, aby spełnić wymóg misji.",
      value = "Musisz zwiększyć wartość swojego szpitala do %d",
    },
    lose = {
      kill = "Zabij kolejnych %d pacjentów, a przegrasz misję!",
    },
  },
  warnings = {
    charges_too_low = "Pobierasz za niskie opłaty. Ludzie będą wybierać twój szpital, jednak nie zostawią w nim dużo pieniędzy.",
    charges_too_high = "Wprowadziłeś zbyt wysokie opłaty. Przez jakiś czas będziesz miał spore zyski, ale potem pacjenci zaczną rezygnować z twoich usług.",
    staff_overworked = "Twoi pracownicy są niezmiernie przepracowani. Stają się nieefektywni i mogą popełniać katastrofalne błędy.",
    doctor_crazy_overwork = "O nie! Jeden z twoich Lekarzy oszalał z przepracowania. Jeżeli natychmiast pozwolisz mu odpocząć, to może wyzdrowieje.",
    doctors_tired = "Twoi Lekarze są bardzo zmęczeni. Daj im odpocząć.",
    people_did_it_on_the_floor = "Niektórzy z twoich pacjentów nie wytrzymali. Szykuje się dla kogoś duże sprzątanie.",
    queues_too_long = "Kolejki w twoim szpitalu są za długie.",
    money_very_low_take_loan = "Stan twojego konta jest zatrważająco niski. Mógłbyś rozważyć wzięcie kredytu.",
    falling_2 = "Przestaniesz się w końcu wygłupiać?",
    patients_very_thirsty = "Pacjenci naprawdę są spragnieni. Jeżeli nie kupisz szybko Automatów do napoi, będziesz świadkiem wielkiej migracji ludzi do domu po własną colę.",
    machinery_very_damaged = "Pilne! Bezzwłocznie wezwij Dozorcę! Urządzenia za chwilę eksplodują!",
    handymen_tired2 = "Twoi Dozorcy słaniają się ze zmęczenia. Daj im natychmiast odpocząć.",
    desperate_need_for_watering = "Musisz koniecznie zatrudnić Dozorcę, aby dbał o twoje rośliny.",
    nurses_tired = "Twoje Pielęgniarki są zmęczone. Daj im odpocząć.",
    too_much_litter = "Jest problem ze śmieciami, który rozwiązać może większa liczba Dozorców.",
    reception_bottleneck = "W recepcji utworzył się korek. Zatrudnij nową Recepcjonistkę.",
    place_plants4 = "Rozwesel pacjentów stawiając wokół więcej roślin.",
    place_plants3 = "Pacjenci są przygnębieni. Kup więcej roślin, aby ich rozweselić.",
    staff_too_hot = "Twoim pracownikom jest za gorąco. Obniż temperaturę lub usuń kaloryfery z ich gabinetów.",
    finanical_trouble2 = "Zdobądź jakieś pieniądze albo szpital pójdzie pod młotek. Nie ukończysz poziomu, jeśli stracisz kolejne %d.",
    plants_thirsty = "Musisz dbać o szpitalne rośliny. Zaczynają usychać.",
    litter_everywhere = "Śmieci są wszędzie. Niech Dozorcy zajmą się tym problemem.",
    nurses_tired2 = "Twoje Pielęgniarki są bardzo zmęczone. Daj im natychmiast odpocząć.",
    no_desk_2 = "Dobra robota, to musi być rekord świata: prawie rok bez pacjentów! Jeżeli chcesz nadal być kierownikiem tego szpitala, musisz zatrudnić recepcjonistkę i kupić jej biurko aby mogła pracować!",
    plants_dying = "Rośliny umierają błagając o kroplę wody. Niech Dozorcy się tym zajmą. Pacjenci nie lubią martwych roślin.",
    reduce_staff_rest_threshold = "Spróbuj obniżyć próg zmęczenia personelu na ekranie Strategii Szpitala tak, aby załoga mogła częściej odpoczywać.",
    more_toilets = "Potrzebujesz więcej Toalet. Ludzie muszą się załatwić.",
    hospital_is_rubbish = "Ludzie otwarcie mówią, że twój szpital jest do niczego. Chyba wiesz co będzie dalej: zabiorą się ze swoimi choróbskami do innego szpitala.",
    pay_back_loan = "Masz dużo pieniędzy. Może byś pomyślał o spłacie pożyczki?",
    financial_trouble3 = "Stan twojego konta wygląda niepokojąco. Pomyśl jak zarobić więcej pieniędzy. Jesteś o %d od katastrofy.",
    bankruptcy_imminent = "Hej! Zmierzasz do bankructwa. Bądź ostrożny!",
    build_toilet_now = "Zbuduj Toalety! Ludzie nie mogą już dłużej wytrzymać. Nie śmiej się, to poważna sprawa.",
    patient_stuck = "Ktoś się zaklinował. Musisz lepiej rozplanować swój szpital.",
    no_patients_last_month = "W poprzednim miesiącu żaden nowy pacjent nie pojawił się w twoim szpitalu. Tragedia!",
    falling_5 = "To nie miejsce na przewracanie ludzi, wiesz przecież, że są chorzy!",
    patients_too_hot = "Pacjentom jest za gorąco. Usuń kilka kaloryferów, obniż temperaturę, albo dokup automaty do napoi.",
    many_epidemics = "Wygląda na to, że w szpitalu szaleje więcej niż jedna epidemia. To może skończyć się kolosalna katastrofą, więc lepiej zacznij działać.",
    falling_4 = "To jest szpital, nie wesołe miasteczko!",
    place_plants_to_keep_people = "Ludzie odchodzą. Umieszczenie roślin mogłoby ich przekonać do pozostania.",
    patients_thirsty2 = "Ludziom chce się pić. Powinieneś kupić więcej Automatów do napoi, albo przesunąć te, które już masz bliżej pacjentów.",
    money_low = "Kończą ci się pieniądze!",
    staff_unhappy = "Twoi pracownicy są niezadowoleni. Daj im podwyżkę, a najlepiej zbuduj dla nich Pokój Socjalny. Możesz także przydzielić im więcej czasu wolnego w dziale Strategia.",
    people_freezing = "Aż trudno uwierzyć, ale w epoce centralnego ogrzewania niektórzy z twoich pacjentów marzną na kość. Zamontuj kaloryfery i podkręć ogrzewanie.",
    falling_6 = "To nie kręgielnia, chorzy nie powinni być traktowani w taki sposób!",
    need_toilets = "Pacjenci potrzebują toalet. Zbuduj je w łatwo dostępnym miejscu.",
    falling_3 = "Auć, to musiało boleć, niech ktoś wezwie doktora!",
    nobody_cured_last_month = "W poprzednim miesiącu nie wyleczyłeś absolutnie nikogo.",
    financial_trouble = "Jesteś w poważnych finansowych tarapatach. Natychmiast uporządkuj swoje finanse! Jeżeli stracisz kolejne %d, zawalisz ten poziom!",
    patients_very_cold = "Pacjentom jest bardzo zimno. Spróbuj podkręcić ogrzewanie lub zamontuj więcej kaloryferów.",
    no_desk_3 = "Po prostu wspaniale, minął prawie rok a ty nadal nie masz recepcji! W jako sposób zamierzasz zdobyć pacjentów? Zajmij się tym natychmiast i przestań się w końcu wygłupiać!",
    build_toilets = "Czym prędzej zbuduj Toalety, albo ujrzysz coś nieprzyjemnego. Wyobraź sobie także zapach swojego szpitala.",
    cannot_afford = "Nie masz wystarczającej ilości pieniędzy aby zatrudnić tą osobę!",
    no_desk = "Powinieneś zakupić biurko recepcji i zatrudnić recepcjonistkę!",
    patients_annoyed = "Ludzie są strasznie zdenerwowani twoim sposobem prowadzenia szpitala. I wcale im się nie dziwię. Weź się do roboty albo poniesiesz konsekwencje!",
    many_killed = "Masz już na sumieniu %d ludzi. A powinieneś ich leczyć i dobrze o tym wiesz.",
    place_plants2 = "Ludzie odchodzą. Więcej roślin mogłoby ich tu zatrzymać dłużej.",
    staff_tired = "Twoi pracownicy są strasznie zmęczeni. Jeżeli nie dasz im choć trochę odpocząć, niektórzy mogą paść z wycieńczenia.",
    machines_falling_apart = "Przyrządy w twoim szpitalu psują się. Wyślij natychmiast Dozorcę do ich naprawy!",
    patients_unhappy = "Pacjenci nie lubią twojego szpitala. Powinieneś coś zrobić, by poprawić im warunki.",
    no_desk_1 = "Jeżeli chcesz aby pacjenci odwiedzali twój szpital, będziesz musiał zatrudnić recepcjonistkę i zakupić jej biurko, przy którym będzie pracować!",
    staff_unhappy2 = "Twoi pracownicy są niezadowoleni. Poza tym wkrótce będą chcieli więcej pieniędzy.",
    cash_low_consider_loan = "Twoja sytuacja finansowa jest bardzo zła. Czy rozważałeś wzięcie kredytu?",
    queue_too_long_at_reception = "Zbyt wielu pacjentów czeka na rejestrację. Postaw nowe Biurko Recepcji i zatrudnij Recepcjonistkę.",
    queue_too_long_send_doctor = "Kolejki do %s są za długie. Upewnij się, że w gabinecie jest Lekarz.",
    falling_1 = "Hej! To nie jest śmieszne, uważaj gdzie klikasz tą myszką; komuś może stać się krzywda!",
    doctors_tired2 = "Twoi Lekarze ledwo żyją. Potrzebują natychmiastowego odpoczynku.",
    handymen_tired = "Twoi Dozorcy są bardzo zmęczeni. Daj im odpocząć.",
    patient_leaving = "Jakiś pacjent odchodzi. Powód? Twój kiepsko zarządzany i słabo wyposażony szpital.",
    deal_with_epidemic_now = "Jeżeli natychmiast nie zaradzisz tej epidemii, znajdziesz się w niezłych tarapatach. Rusz się!",
    patients_leaving = "Pacjenci odchodzą. Ulepsz swój szpital umieszczając w nim rośliny, ławki, automaty do napoi, itd.",
    machinery_damaged2 = "Musisz zatrudnić Dozorcę do naprawy urządzeń.",
    epidemic_getting_serious = "Ta Zaraźliwa Choroba zaczyna być poważna. Musisz szybko coś zrobić!",
    people_have_to_stand = "Zmuszasz cierpiący lud do stania. Kup natychmiast więcej ławek.",
    receptionists_tired = "Twoje Recepcjonistki są strasznie zmęczone. Daj im odpocząć.",
    build_staffroom = "Natychmiast zbuduj Pokój Socjalny! Twój personel pracuje ponad siły i jest na skraju wyczerpania. Nabierz wreszcie rozumu!",
    machinery_slightly_damaged = "Maszyny w szpitalu są nieco uszkodzone. Nie zapomnij o ich konserwacji.",
    need_staffroom = "Zbuduj Pokój Socjalny, aby twoi pracownicy mieli gdzie odpocząć.",
    patients_getting_hot = "Pacjentom jest bardzo gorąco. Spróbuj zmniejszyć ogrzewanie lub usuń niektóre kaloryfery.",
    machinery_deteriorating = "Twoje urządzenia właśnie zaczęły niszczeć na skutek zużycia. Miej na nie oko.",
    machinery_damaged = "Niedługo będziesz musiał zająć się naprawą urządzeń szpitalnych, bo zaczną się rozpadać.",
    patients_thirsty = "Ludziom chce się pić. Może powinieneś kupić jakieś automaty do napoi.",
    machine_severely_damaged = "%s wkrótce ulegnie nieodwracalnemu uszkodzeniu.",
    litter_catastrophy = "Sytuacja ze śmieciami wygląda strasznie. Niech brygada Dozorców szybko się tym zajmie!",
    staff_very_cold = "Personel narzeka na zimno. Podkręć ogrzewanie lub zamontuj więcej kaloryferów.",
    more_benches = "Pomyśl o wstawieniu większej liczby ławek. Pacjenci nie znoszą stania.",
    too_many_plants = "Masz zdecydowanie za dużo roślin. Tu jest jak w dżungli.",
    change_priorities_to_plants = "Musisz zmienić zadania swoim Dozorcom tak, aby spędzali więcej czasu na podlewaniu roślin.",
    some_litter = "Dozorcy mogą pozbyć się śmieci, zanim staną się one poważnym problemem.",
    receptionists_tired2 = "Twoje Recepcjonistki opadły z sił. Daj im trochę odpocząć.",
    patients_really_thirsty = "Pacjenci są naprawdę spragnieni. Wstaw nowe Automaty do napoi, lub przesuń stare bliżej dużych kolejek.",
    research_screen_open_2 = "Na obecnym poziomie badania są niedostępne.",
    research_screen_open_1 = "Najpierw musisz wybudować Dział Badawczy aby mieć dostęp do ekranu badań.",
  },
  placement_info = {
    door_can_place = "Jeżeli chcesz, możesz umieścić tutaj drzwi.",
    window_can_place = "Możesz wstawić to okno tutaj. Będzie pasowało.",
    door_cannot_place = "Niestety nie możesz tu wstawić drzwi.",
    object_can_place = "Możesz umieścić ten przedmiot tutaj.",
    reception_can_place = "Nie możesz tu umieścić Biurka Recepcji.",
    staff_cannot_place = "Przykro mi, ale nie możesz tu umieścić tego pracownika.",
    staff_can_place = "Możesz umieścić tego pracownika tutaj. ",
    object_cannot_place = "Hej, nie możesz tu umieścić tego przedmiotu.",
    room_cannot_place = "Nie możesz tu zbudować pomieszczenia.",
    room_cannot_place_2 = "Nie możesz tu zbudować pomieszczenia.",
    window_cannot_place = "Ach, prawdę mówiąc nie możesz tu wstawić okna.",
    reception_cannot_place = "Nie możesz tu umieścić Biurka Recepcji.",
  },
  praise = {
    many_benches = "Teraz pacjenci mają wystarczającą liczbę ławek. Świetnie.",
    many_plants = "Wspaniale. W twoim szpitalu jest mnóstwo roślin. Pacjenci to docenią.",
    plants_are_well = "Jak miło. Widzę, że dbasz o swoje rośliny. To wspaniale.",
    few_have_to_stand = "Nikt nie musi stać w twoim szpitalu. Pacjenci będą zadowoleni.",
    plenty_of_benches = "Jest dużo miejsc do siedzenia, więc nie ma problemu.",
    plants_thriving = "Bardzo dobrze. Twoje rośliny dosłownie rozkwitają. Wyglądają cudownie. Tak trzymaj, a może wygrasz za nie trofeum.",
    patients_cured = "Wyleczono %d pacjentów.",
  },
  information = {
    larger_rooms = "Większe pomieszczenia zwiększają zadowolenie i wydajność twojego personelu.",
    extra_items = "Dodatkowe przedmioty w pokojach zapewniają pracownikom większy komfort i zwiększają ich wydajność.",
    epidemic = "W twoim szpitalu rozpleniła się zaraźliwa choroba. Musisz natychmiast rozwiązać ten problem!",
    promotion_to_doctor = "Jeden z twoich ASYSTENTÓW awansował na DOKTORA.",
    emergency = "Mamy nagły wypadek! Ruchy! Ruchy! RUCHY!",
    patient_abducted = "Jednego z twoich pacjentów próbują uprowadzić kosmici.",
    first_cure = "Dobra robota! Właśnie wyleczyłeś swojego pierwszego pacjenta.",
    promotion_to_consultant = "Jeden z twoich LEKARZY awansował na KONSULTANTA.",
    handyman_adjust = "Możesz zmusić Dozorców do efektywniejszego sprzątania poprzez zmianę ich priorytetów.",
    promotion_to_specialist = "Jeden z twoich Lekarzy awansował do stopnia: %s.",
    initial_general_advice = {
      rats_have_arrived = "Szczury nawiedziły twój szpital. Spróbuj wystrzelać je za pomocą myszy.",
      autopsy_available = "Wynaleziono urządzenie do Auto Autopsji. Dzięki temu możesz pozbyć się kłopotliwych lub niepożądanych pacjentów i prowadzić badania na ich zwłokach. Uważaj jednak - używanie tej maszyny jest bardzo kontrowersyjne.",
      first_patients_thirsty = "Ludzie w twoim szpitalu są spragnieni. Postaw więcej Automatów do napoi.",
      research_now_available = "Zbudowałeś swój pierwszy Dział Badawczy. Teraz masz dostęp do ekranu Badań.",
      psychiatric_symbol = "Lekarze wyszkoleni w psychiatrii posiadają symbol: |",
      decrease_heating = "Ludziom w twoim szpitalu jest za gorąco. Zmniejsz poziom ogrzewania. Możesz tego dokonać w ekranie Mapy Miasta.",
      surgeon_symbol = "Lekarze mogący przeprowadzać operacje posiadają symbol: {",
      first_emergency = "Pacjenci z nagłych wypadków maja nad głowami niebieskie lampki. Wylecz ich zanim umrą lub upłynie limit czasu.",
      first_epidemic = "W twoim szpitalu wybuchła epidemia! Zdecyduj czy chcesz zakamuflować czy ujawnić ten problem.",
      taking_your_staff = "Ktoś podkupuje twoich pracowników. Będziesz musiał walczyć, aby ich zatrzymać.",
      place_radiators = "Ludzie w twoim szpitalu marzną - możesz zamontować więcej kaloryferów kupując je w menu Wyposażenie Korytarza.",
      epidemic_spreading = "W twoim szpitalu wykryto zakażenie. Spróbuj wyleczyć wszystkich zakażonych pacjentów, nim opuszczą szpital.",
      research_symbol = "Lekarze mogący prowadzić badania posiadają symbol: }",
      machine_needs_repair = "Jedno z twoich urządzeń wymaga naprawy. Zlokalizuj je - będzie dymiło - i kliknij na nie. Następnie kliknij na przycisk Dozorcy.",
      increase_heating = "Ludziom jest zimno. Podkręć ogrzewanie na ekranie Mapy Miasta.",
      first_VIP = "Twój szpital czeka pierwsza wizytacja VIPa. Upewnij się, że nie zobaczy on niczego niehigienicznego ani nie spotka niezadowolonych pacjentów.",
    },
    patient_leaving_too_expensive = "Pacjent wychodzi bez płacenia za %s. To zbyt kosztowna usługa.",
    vip_arrived = "Uwaga! Przed chwilą przyjechał %s w celu wizytacji twojego szpitala! Miej wszystko pod kontrolą, aby był zadowolony.",
    epidemic_health_inspector = "Wieści o epidemii z twojego szpitala dotarły do Ministerstwa Zdrowia. Przygotuj się na wizytę Inspektora Zdrowia.",
    first_death = "Właśnie zabiłeś swojego pierwszego pacjenta. Jakie to uczucie?",
    pay_rise = "Członek personelu grozi odejściem. Zdecyduj czy zgadzasz się na jego żądania czy też zwolnisz go z pracy. Kliknij na ikonie po lewej stronie, aby zobaczyć kto grozi odejściem.",
    place_windows = "Dzięki oknom pomieszczenia są nasłonecznione, a twoi pracownicy mają lepszy nastrój.",
    fax_received = "Ikona, która właśnie pojawiła się w lewej, dolnej części ekranu, alarmuje cię o ważnych informacjach lub decyzjach, które musisz podjąć.",
  },
  build_advice = {
    placing_object_blocks_door = "Umieszczenie tego obiektu tutaj uniemożliwi dostanie się do drzwi.",
    blueprint_would_block = "Projekt blokuje inne pomieszczenia. Spróbuj zmienić rozmiar pomieszczenia lub przesunąć je gdzie indziej!",
    door_not_reachable = "Ludzie nie będą mogli dostać się do tych drzwi. Zastanów się.",
    blueprint_invalid = "Projekt pomieszczenia jest niewłaściwy.",
  },
}
calls_dispatcher = {
  repair = "Naprawa %s",
  summary = "%d wezwań; %d przydzielono",
  close = "Zamknij",
  watering = "Podlewanie @ %d,%d",
  staff = "%s - %s",
}
information = {
  cheat_not_possible = "Nie można używać oszustwa na tym poziomie. Nie potrafisz nawet oszukiwać, niezbyt to śmieszne co?",
  very_old_save = "Zaszło sporo zmian w grze od czasu, gdy rozpoczęty został ten poziom. Aby mieć pewność, że wszystko działa jak należy, zaleca się rozpoczęcie poziomu od nowa.",
  no_custom_game_in_demo = "Przepraszamy ale w wersji demonstracyjnej nie można grać na niestandardowych mapach.",
  cannot_restart = "Niestety ta dodatkowa mapa była zapisana zanim wprowadzona została możliwość ponownego rozpoczynania gry.",
  custom_game = "Witaj w CorsixTH. Życzymy dużo zabawy z dodatkowymi mapami!",
  level_lost = {
    [1] = "Pech! Nie udało Ci się ukończyć poziomu. Powodzenia następnym razem!",
    [2] = "Powód dla którego przegrałeś:",
    reputation = "Twoja reputacja spadła poniżej %d.",
    balance = "Twój stan konta był mniejszy niż %d.",
    percentage_killed = "Zabiłeś więcej niż %d procent pacientów.",
    cheat = "To był twój wybór czy wcisnąłeś zły przycisk? Więc nawet nie wiesz jak oszukiwać, nie jest ci teraz do śmiechu co?",
  },
}
casebook = {
  sent_home = "odprawionych",
  deaths = "zgony",
  treatment_charge = "koszt leczenia",
  reputation = "reputacja",
  research = "skoncentruj badania",
  cure = "leczenie",
  cured = "wyleczonych",
  earned_money = "zarobiono",
  cure_desc = {
    hire_psychiatrists = "Musisz zatrudnić Psychiatrów.",
    improve_cure = "Ulepsz Leczenie.",
    hire_nurses = "Powinieneś zatrudnić Pielęgniarki.",
    build_ward = "Musisz jeszcze zbudować Oddział.",
    no_cure_known = "Nieznane Leczenie.",
    cure_known = "Leczenie.",
    build_room = "Zalecam, abyś zbudował %s",
    hire_doctors = "Musisz zatrudnić Lekarzy.",
    hire_surgeons = "Musisz zatrudnić Chirurgów.",
  },
}
new_game_window = {
  caption = "Kampania",
  player_name = "Imię gracza",
  option_on = "Włączone",
  option_off = "Wyłączone",
  difficulty = "Poziom trudności",
  easy = "Asystent (Łatwy)",
  medium = "Doktor (Średni)",
  hard = "Konsultan (Trudny)",
  tutorial = "Samouczek",
  start = "Rozpocznij",
  cancel = "Anuluj",
}
diseases = {
  diag_ward = {
    name = "Diag. Oddział",
  },
  diag_ultrascan = {
    name = "Diag. Ultraskan",
  },
  autopsy = {
    name = "Sekcja zwłok",
  },
  third_degree_sideburns = {
    cause = "Przyczyna - tęsknota za latami 70-tymi.",
    cure = "Leczenie - używając najnowszych metod Psychiatra musi przekonać pacjenta, że brokat i buty na koturnach to obciach.",
    name = "Bokobrody",
    symptoms = "Objawy - fryzura afro, spodnie dzwony i brokatowy makijaż.",
  },
  discrete_itching = {
    cause = "Przyczyna - małe insekty z ostrymi zębami.",
    cure = "Leczenie - Pacjent pije apteczny kleisty syrop zapobiegający swędzeniu.",
    name = "Intymny Świąd",
    symptoms = "Objawy - drapanie, prowadzące do częściowego zapalenia ciała.",
  },
  the_squits = {
    cause = "Przyczyna - jedzenie pizzy znalezionej pod kuchenką.",
    cure = "Leczenie - kleista mieszanina włóknistych chemikaliów zespala wnętrzności pacjenta.",
    name = "Rozwolnienie",
    symptoms = "Objawy - fuj, pewnie się domyślasz.",
  },
  spare_ribs = {
    cause = "Przyczyna - siadanie na zimnej podłodze.",
    cure = "Leczenie - to coś musi być usunięte przez dwóch Chirurgów i oddane pacjentowi w papierowej torbie.",
    name = "Żeberka",
    symptoms = "Objawy - nieprzyjemne uczucie w klatce piersiowej.",
  },
  diag_blood_machine = {
    name = "Diag. Morfologia",
  },
  king_complex = {
    cause = "Wywołane przez ducha Króla, przejmującego kontrolę nad umysłem pacjenta.",
    cure = "Leczenie - Psychiatra mówi pacjentowi jak idiotycznie wygląda.",
    name = "Kompleks Króla",
    symptoms = "Objawy - przywdziewanie kolorowego, zamszowego obuwia i jedzenie cheeseburgerów.",
  },
  diag_x_ray = {
    name = "Diag. Rentgen",
  },
  pregnancy = {
    cause = "Przyczyna - braki prądu w obszarach miejskich.",
    cure = "Leczenie - owoc obżarstwa jest usuwany operacyjnie, myty i pokazywany pacjentowi.",
    name = "Ciąża",
    symptoms = "Objawy - mięsień piwny jako następstwo objadania się.",
  },
  fake_blood = {
    cause = "Przyczyna - osoba będąca zwykle ofiarą psikusów.",
    cure = "Leczenie - psychiatryczne uspokajanie jest jedynym rozwiązaniem tego problemu.",
    name = "Sztuczna Krwistość",
    symptoms = "Objawy - czerwony płyn w żyłach, który wyparowuje przy kontakcie z odzieżą.",
  },
  diag_psych = {
    name = "Diag. Psychiatra",
  },
  invisibility = {
    cause = "Przyczyna - ugryzienie przez radioaktywną (i niewidzialną) mrówkę.",
    cure = "Leczenie - kolorowy płyn wypity w Aptece szybko przywróci pacjenta do pełnej widzialności.",
    name = "Niewidzialność",
    symptoms = "Objawy - żaden dyskomfort dla pacjenta; wielu wręcz używa tej przypadłości, by robić kawały swym rodzinom.",
  },
  golf_stones = {
    cause = "Przyczyna - wdychanie gazu z wnętrza piłek golfowych.",
    cure = "Leczenie - objawy usuwane operacyjnie przez dwóch Chirurgów.",
    name = "Kamienie Golfowe",
    symptoms = "Objawy - delirium i wielki wstyd.",
  },
  diag_general_diag = {
    name = "Podst. Badania",
  },
  infectious_laughter = {
    cause = "Przyczyna - typowy serial komediowy.",
    cure = "Leczenie - Psychiatra uświadamia pacjentowi, że w tej dolegliwości nie ma nic zabawnego.",
    name = "Zaraźliwy Śmiech",
    symptoms = "Objawy - ciągły chichot i powtarzanie nieśmiesznych dowcipów.",
  },
  general_practice = {
    name = "Wizyta u Lekarza",
  },
  baldness = {
    cause = "Przyczyna - mówienie kłamstw i niestworzonych historii, aby być popularnym.",
    cure = "Leczenie - włosy są gładko nakładane na głowę pacjenta przy użyciu bolesnej maszynerii.",
    name = "Łysienie",
    symptoms = "Objawy - lśniąca glaca i zakłopotanie.",
  },
  heaped_piles = {
    cause = "Przyczyna - przebywanie w pobliżu automatów z zimnymi napojami.",
    cure = "Leczenie - smaczny, choć mocno kwaśny napój rozpuszcza hemoroidy od wewnątrz.",
    name = "Hemoroidy",
    symptoms = "Objawy - Pacjent czuje się jakby siedział na torbie z kulkami.",
  },
  unexpected_swelling = {
    cause = "Przyczyna - coś niespodziewanego.",
    cure = "Leczenie - opuchlizna może być zmniejszona tylko przez chirurgiczne nacięcie.",
    name = "Nagłe Wzdęcia",
    symptoms = "Objawy - opuchlizna.",
  },
  jellyitis = {
    cause = "Przyczyna - dieta bogata w żelatynę i nadmiar ćwiczeń.",
    cure = "Leczenie - Pacjent jest zanurzany na chwilę w Galaretownicy.",
    name = "Galaretowatość",
    symptoms = "Objawy - drżenie i częste upadki.",
  },
  hairyitis = {
    cause = "Przyczyna - nadmiar naświetlenia księżycowego.",
    cure = "Leczenie - maszyna do elektrolizy usuwa włosy i uszczelnia pory.",
    name = "Włochacizna",
    symptoms = "Objawy - poszkodowani posiadają wyostrzony zmysł węchu.",
  },
  alien_dna = {
    cause = "Przyczyna - twarzołapy z inteligentną krwią obcych.",
    cure = "Leczenie - DNA jest mechanicznie usuwane, czyszczone z obcych elementów i szybko wymieniane.",
    name = "DNA Obcego",
    symptoms = "Objawy - stopniowa metamorfoza w obcego i chęć niszczenia miasta.",
  },
  bloaty_head = {
    cause = "Przyczyna - wąchanie sera i picie nieoczyszczonej deszczówki.",
    cure = "Leczenie - opuchnięta głowa jest przebijana, następnie nadmuchiwana do odpowiedniej wielkości.",
    name = "Głowowzdęcie",
    symptoms = "Objawy - bardzo przykre dla ofiary.",
  },
  gastric_ejections = {
    cause = "Przyczyna - pikantne meksykańskie lub hinduskie jedzenie.",
    cure = "Leczenie - wypicie specjalnego roztworu zapobiega wypuszczaniu czegokolwiek.",
    name = "U-Pierdliwość",
    symptoms = "Objawy - wpół strawione jedzenie uchodzi z pacjenta w małych ilościach.",
  },
  uncommon_cold = {
    cause = "Przyczyna - małe cząsteczki smarków w powietrzu.",
    cure = "Leczenie - duży łyk niezwykłej medycznej mikstury ze specjalnych składników zrobionych w Aptece.",
    name = "Nietypowa Grypa",
    symptoms = "Objawy - zasmarkany nos, kichanie i przebarwione płuca.",
  },
  corrugated_ankles = {
    cause = "Przyczyna - rozjeżdżanie autem znaków ostrzegawczych.",
    cure = "Leczenie - lekko toksyczna mieszanka ziół i przypraw pita w celu naprostowania kostek.",
    name = "Sfałdowane Kostki",
    symptoms = "Objawy - problemy z wkładaniem butów.",
  },
  sleeping_illness = {
    cause = "Przyczyna - nadaktywny gruczoł snu w podniebieniu.",
    cure = "Leczenie - stężona dawka silnego stymulanta podawana przez Pielęgniarkę.",
    name = "Narkolepsja",
    symptoms = "Objawy - przeszywająca chęć spania gdzie popadnie.",
  },
  sweaty_palms = {
    cause = "Przyczyna - strach przed rozmowami kwalifikacyjnymi.",
    cure = "Leczenie - Psychiatra musi wybić pacjentowi z głowy tę urojoną chorobę.",
    name = "Spocone Dłonie",
    symptoms = "Objawy - uścisk dłoni pacjenta to jak ściskanie nasiąkniętej gąbki.",
  },
  serious_radiation = {
    cause = "Przyczyna - pomylenie izotopów plutonu z gumą do żucia.",
    cure = "Leczenie - Pacjent musi być umieszczony w Prysznicu Odkażającym i porządnie umyty.",
    name = "Napromieniowanie",
    symptoms = "Objawy - pacjenci z tą przypadłością czują się bardzo, bardzo źle.",
  },
  diag_cardiogram = {
    name = "Diag. Kardiograf",
  },
  diag_scanner = {
    name = "Diag. Skaner",
  },
  gut_rot = {
    cause = "Przyczyna - picie domowej roboty syropów na kaszel.",
    cure = "Leczenie - specjalna mikstura na odbudowanie warstwy ochronnej brzuszka.",
    name = "Gnijące Jelita",
    symptoms = "Objawy - brak kaszlu - oraz brak żołądka.",
  },
  iron_lungs = {
    cause = "Przyczyna - smog miejski zmieszany z pozostałościami kebabu.",
    cure = "Leczenie - dwaj Chirurdzy usuwają dużą bryłę z płuc pacjenta.",
    name = "Żelazne Płuca",
    symptoms = "Objawy - umiejętnosć ziania ogniem i krzyczenia pod wodą.",
  },
  broken_wind = {
    cause = "Przyczyna - korzystanie z bieżni gimnastycznej po posiłku.",
    cure = "Leczenie - sążnista wodna mikstura wypijana szybko w Aptece.",
    name = "Trujące Wiatry",
    symptoms = "Objawy - pacjent niepokoi ludzi znajdujących się tuż za nim.",
  },
  kidney_beans = {
    cause = "Przyczyna - miażdżenie kostek lodu w drinkach.",
    cure = "Leczenie - dwóch Chirurgów usuwa kamienie bez naruszania nerek.",
    name = "Kamionka Nerkowa",
    symptoms = "Objawy - ból i częste wizyty w toalecie.",
  },
  transparency = {
    cause = "Przyczyna - oblizywanie sreberka z jogurtu po otwarciu pojemniczka.",
    cure = "Leczenie - specjalnie barwiona i chłodzona woda apteczna leczy tę chorobę.",
    name = "Przezroczystość",
    symptoms = "Objawy - ciało staje się obrzydliwie przezroczyste.",
  },
  broken_heart = {
    cause = "Przyczyna - ktoś bogatszy, młodszy i szczuplejszy od pacjenta.",
    cure = "Leczenie - Chirurdzy otwierają klatkę piersiową i, wstrzymując oddech, zszywają serce.",
    name = "Złamane serce",
    symptoms = "Objawy - płacz i ból mięśni spowodowane godzinami darcia zdjęć z wakacji.",
  },
  slack_tongue = {
    cause = "Przyczyna - nałogowe dyskusje o telenowelach.",
    cure = "Leczenie - język umieszczany jest w Krajalnicy i usuwany szybko, skutecznie i boleśnie.",
    name = "Obwisły Język",
    symptoms = "Objawy - pięciokrotnie powiększony, obwisły język.",
  },
  tv_personalities = {
    cause = "Przyczyna - telewizja śniadaniowa.",
    cure = "Leczenie - doświadczony Psychiatra musi przekonać pacjenta do sprzedaży TV i zakupu radia.",
    name = "Osobowość Medialna",
    symptoms = "Objawy - złudzenie, że można poprowadzić program o gotowaniu.",
  },
  ruptured_nodules = {
    cause = "Przyczyna - skoki na bungie podczas mrozu.",
    cure = "Leczenie - dwóch wykwalifikowanych Chirurgów usuwa bąble swymi opanowanymi dłońmi.",
    name = "Przepuklina",
    symptoms = "Objawy - niemożność komfortowego siedzenia.",
  },
  fractured_bones = {
    cause = "Przyczyna - spadanie z dużych wysokości na beton.",
    cure = "Leczenie - gips jest zakładany, po czym zdejmowany przez maszynę sterowaną laserowo.",
    name = "Połamane Kości",
    symptoms = "Objawy - głośne pęknięcie i niemożność używania chorych kończyn.",
  },
  chronic_nosehair = {
    cause = "Przyczyna - Wtykanie nosa w nie swoje sprawy.",
    cure = "Leczenie - obrzydliwy, usuwający włosy napój, zażywany doustnie, robiony przez Pielęgniarkę w Aptece.",
    name = "Włosy w Nosie",
    symptoms = "Objawy - włosów w nosie starczyłoby na gniazdo dla borsuka.",
  },
}
policy = {
  header = "STRATEGIA SZPITALA",
  diag_termination = "zatrzymanie diagnozowania",
  sliders = {
    guess = "POSTAW DIAGNOZĘ",
    send_home = "WYPISZ DO DOMU",
    stop = "ZATRZYMAJ",
    staff_room = "IDŹ ODPOCZĄĆ",
  },
  diag_procedure = "procedura diagnozowania",
  staff_rest = "wyślij personel na odpoczynek",
  staff_leave_rooms = "personel opuszcza gabinet",
}
competitor_names = {
  [1] = "ORAC",
  [2] = "COLOSSUS",
  [3] = "HAL",
  [4] = "MULTIVAC",
  [5] = "HOLLY",
  [6] = "DEEP THOUGHT",
  [7] = "ZEN",
  [8] = "LEON",
  [9] = "MARVIN",
  [10] = "AKIRA",
  [11] = "MOTHER",
  [12] = "JAYNE",
  [13] = "CORSIX",
  [14] = "ROUJIN",
  [15] = "EDVIN",
  [16] = "EMIL",
  [17] = "CHARLIE",
  [18] = "ARTUR",
  [19] = "MAGNUS",
  [20] = "SAL",
  [21] = "JOSHUA",
  [22] = "DANEEL",
  [23] = "OLIVAW",
  [24] = "NIC",
}
options_window = {
  caption = "Opcje",
  option_on = "Włączone",
  option_off = "Wyłączone",
  fullscreen = "Pełny ekran",
  resolution = "Rozdzielczość",
  custom_resolution = "Niestandardowa...",
  browse = "Przeglądaj...",
  width = "Szerokość",
  height = "Wysokość",
  new_th_directory = "Tutaj możesz określić nowy katalog z zainstalowaną grą Theme Hospital. Jak tylko dokonasz wyboru gra będzie uruchomiona ponownie.",
  apply = "Zatwierdź",
  cancel = "Anuluj",
  data_location = "Lokalizacja danych",
  font_location = "Lokalizacja czcionki",
  language = "Game language",
  cancel = "Anuluj",
  back = "Wróć",
}
buy_objects_window = {
  price = "Cena: ",
  choose_items = "Wybierz Przedmioty",
  total = "Suma: ",
}
trophy_room = {
  wait_times = {
    award = {
      [1] = "Gratulacje. Kolejki w twoim szpitalu są zawsze wyjątkowo krótkie. To bardzo ważne wyróżnienie.",
    },
    penalty = {
      [1] = "Ludzie w twoim szpitalu muszą zbyt długo czekać. Kolejki są za długie. Gdybyś tylko chciał, mógłbyś bardziej efektywnie obsługiwać pacjentów.",
    },
  },
  happy_vips = {
    trophies = {
      [1] = "Agencja Znani&Bogaci chciałaby cię nagrodzić Trofeum Sławy za uszczęśliwienie każdego VIPa, jaki odwiedził twój szpital. Możesz uznać się za dość sławnego i prawie jednego z nas.",
      [2] = "Agencja Znani&Bogaci chciałaby cię nagrodzić Trofeum Sławy za uszczęśliwienie każdego VIPa, jaki odwiedził twój szpital. Możesz uznać się za dość sławnego i prawie jednego z nas.",
      [3] = "Gratulacje z okazji nagrody JAZDA VIPa, za pokazanie odwiedzającym jaką to ciężko pracującą placówką jest twój szpital. Wyśmienicie.",
    },
    awards = {
      [1] = "Zdobyłeś Nagrodę Nobla za zaimponowanie VIPom. Wszyscy odwiedzający twój szpital w ostatnim roku byli z niego bardzo zadowoleni.",
      [2] = "Gratulacje z okazji nagrody JAZDA VIPa, za pokazanie odwiedzającym jaką to ciężko pracującą placówką jest twój szpital. Wyśmienicie.",
    },
  },
  hosp_value = {
    penalty = {
      [1] = "Twój szpital nie osiągnął przyzwoitej wartości. Podejmujesz decyzje błędne pod względem finansowym. Pamiętaj, dobry szpital to także drogi szpital.",
    },
    awards = {
      [1] = "Ministerstwo Zdrowia chciałoby ci pogratulować imponującej wartości, jaką osiągnął twój szpital.",
    },
    regional = {
      [1] = "Jesteś geniuszem finansów. Twój szpital jest wart więcej niż wszystkie inne razem wzięte.",
    },
  },
  rats_accuracy = {
    trophies = {
      [1] = "Otrzymałeś Trofeum Najcelniejszego Strzelca im. gry Syndicate Wars za %d%% precyzję w strzelaniu do szczurów.",
      [2] = "Tym trofeum pragniemy uczcić niezwykłą precyzję z jaką wymordowałeś %d%% szczurów, strzelając do nich w zeszłym roku.",
      [3] = "Aby upamiętnić wybicie %d%% wszystkich szczurów w twoim szpitalu, przyznano ci Trofeum Lochy Bez Gryzoni im. Dungeon Keepera. Gratulacje!",
    },
    awards = {
    },
  },
  all_cured = {
    awards = {
      [1] = "Gratulacje z okazji zdobycia nagrody im. Marii Curie, za udane wyleczenie wszystkich pacjentów w ostatnim roku.",
    },
    trophies = {
      [1] = "Międzynarodowa Fundacja Zdrowia, za fakt wyleczenia wszystkich pacjentów twojego szpitala w ostatnim roku, honoruje cię Trofeum Wyleczę Wszystko.",
      [2] = "Zostałeś obdarowany Trofeum Nie-Chorobom, za wyleczenie wszystkich pacjentów szpitala w zeszłym roku.",
    },
  },
  best_value_hosp = {
    trophies = {
      [1] = "Gratulacje z okazji otrzymania Trofeum, za szpital z najlepszą reputacją w ciągu ostatniego roku. Cóż, zasłużyłeś na to.",
    },
    penalty = {
      [1] = "Każdy szpital w okolicy jest wart więcej niż twój. Zrób coś z tym, bo jest to żenujące. Dokup jakieś droższe urządzenia!",
    },
    regional = {
      [1] = "Gratulacje, twój szpital jest najbardziej wartościowy w całej grze. Dobra robota i oby tak dalej.",
    },
  },
  high_rep = {
    trophies = {
      [1] = "Gratulacje z okazji otrzymania Trofeum, za szpital z najlepszą reputacją w ciągu ostatniego roku. Cóż, zasłużyłeś na to.",
    },
    penalty = {
      [1] = "Zostajesz ukarany za utrzymywanie bardzo niskiej reputacji w przeciągu ostatniego roku. Postaraj się, by w przyszłości było lepiej.",
      [2] = "Reputacja twojego szpitala jest najgorsza w okolicy. To hańba. Jak tak dalej pójdzie, możesz szukać nowej pracy.",
    },
    awards = {
      [1] = "Niniejszym zostajesz nominowany do Nagrody Rządowej, za nieskazitelne standardy i najwyższą możliwą reputację w tym roku. Pięknie.",
      [2] = "Przyjmij, proszę, Nagrodę Bullfroga, za najwyższą reputację wśród szpitali w ciągu ostatniego roku. Masz powody do zadowolenia, zapracowałeś na to.",
      [3] = "Dobra robota. Zdobywasz niewielką nagrodę za osiągniecie całkiem niezłej reputacji w ostatnim roku.",
      [4] = "Cudownie! Twój szpital wygrywa nagrodę za osiągniecie najlepszej reputacji w zeszłym roku.",
      [5] = "W tym roku reputacja twojego szpitala przekroczyła reputację wszystkich szpitali razem wziętych. Znaczące osiągnięcie.",
    },
    regional = {
      [1] = "Przyjmij, proszę, Nagrodę Bullfroga, za najwyższą reputację wśród szpitali w ciągu ostatniego roku. Masz powody do zadowolenia, zapracowałeś na to.",
      [2] = "W tym roku reputacja twojego szpitala przekroczyła reputację wszystkich szpitali razem wziętych. Znaczące osiągnięcie.",
    },
  },
  consistant_rep = {
    trophies = {
      [1] = "Niniejszym zostajesz nominowany do Nagrody Rządowej, za nieskazitelne standardy i najwyższą możliwą reputację w tym roku. Pięknie.",
      [2] = "Gratulacje z okazji otrzymania Trofeum, za szpital z najlepszą reputacją w ciągu ostatniego roku. Cóż, zasłużyłeś na to.",
    },
  },
  curesvdeaths = {
    awards = {
      [1] = "Szczere gratulacje za osiągnięcie imponującej proporcji wyleczeń-zgonów w twoim szpitalu w zeszłym roku.",
    },
    penalty = {
      [1] = "Twój współczynnik wyleczeń w stosunku do zgonów jest bardzo mały. Powinieneś się upewnić, że leczysz więcej ludzi niż zabijasz. Nie zawiedź nas.",
    },
  },
  cleanliness = {
    regional_good = {
      [1] = "Twój szpital jest znany jako jeden z najmniej czystych w okolicy. Brudny szpital jest śmierdzący i niebezpieczny. Powinieneś zwracać większą uwagę na bałagan.",
    },
    award = {
      [1] = "Inspekcja odnotowała, że twój szpital jest bardzo czysty. Czysty szpital to bezpieczny szpital. Tak trzymać.",
    },
    regional_bad = {
      [1] = "Twój szpital jest najbrudniejszy w okolicy. Inni administratorzy zdołali utrzymać korytarze w czystości. Przynosisz wstyd środowisku medycznemu.",
    },
  },
  happy_patients = {
    awards = {
      [1] = "Możesz być zadowolony z faktu, że ludzie w twoim szpitalu byli bardzo zadowoleni podczas ostatniego roku.",
      [2] = "Ludzie odwiedzający twój szpital byli bardziej zadowoleni z kuracji niż gdziekolwiek indziej.",
    },
    penalty = {
      [1] = "Ludzie uważają wizyty w twoim szpitalu za niemiłe doświadczenie. Musisz coś z tym zrobić, jeżeli chcesz zdobyć poważanie Ministerstwa.",
      [2] = "Ludzie leczący się w twoim szpitalu byli bardzo niezadowoleni ze stanu tego miejsca. Pamiętaj, najważniejsze jest dobro pacjenta.",
    },
  },
  emergencies = {
    regional_good = {
      [1] = "Ministerstwo zauważyło, że twój szpital radził sobie lepiej z nagłymi wypadkami niż inne szpitale w zeszłym roku i przyznało ci nagrodę.",
    },
    penalty = {
      [1] = "Nie radzisz sobie z nagłymi wypadkami. Pacjenci z nagłych wypadków potrzebują natychmiastowej i właściwej opieki, której ty nie zapewniasz.",
    },
    regional_bad = {
      [1] = "Twój szpital najgorzej w regionie w radzi sobie z nagłymi wypadkami. To twoja wina, że wylądowałeś na szarym końcu lokalnej opieki zdrowotnej.",
    },
    award = {
      [1] = "Gratulacje: skuteczne leczenie nagłych wypadków pozwoliło nam przyznać ci to specjalne wyróżnienie. Dobra robota. ",
      [2] = "Twoja zaradność w nagłych wypadkach jest wyjątkowa. Ta nagroda jest dla najlepszych za radzenie sobie z dużym napływem chorych i cierpiących.",
    },
  },
  gen_repairs = {
    awards = {
      [1] = "Zostałeś nominowany do specjalnej nagrody za błyskotliwość twoich Dozorców w naprawianiu sprzętu szpitalnego. Dobra robota. Weź urlop.",
      [2] = "Twoi Dozorcy są lepsi niż w innych szpitalach. To znaczące osiągnięcie, za które ci gratulujemy.",
      [3] = "Twój sprzęt jest w świetnym stanie. Poświęcenie twoich Dozorców jest niezwykłe. Wszyscy zasługujecie na tę prestiżową nagrodę. Świetna robota.",
    },
    penalty = {
      [1] = "Dozorcy nie dbają za bardzo o twoje urządzenia. Powinieneś ich lepiej nadzorować lub zatrudnić nowych, aby poradzić sobie z natłokiem pracy.",
      [2] = "Masz bałagan w konserwacji urządzeń. Twoi pracownicy powinni szybko i starannie opiekować się wyposażeniem.",
    },
  },
  no_deaths = {
    trophies = {
      [1] = "Towarzystwo Życie Płynie Dalej przyznało ci to trofeum za absolutny brak zgonów w zeszłym roku.",
      [2] = "Zostałeś nominowany do Trofeum Pozostań Żywy za uniknięcie jakichkolwiek zgonów w twoim świetnym szpitalu w tym roku. Super.",
      [3] = "Zostałeś nominowany do Trofeum Pozostań Żywy za uniknięcie jakichkolwiek zgonów w twoim świetnym szpitalu w tym roku. Super.",
    },
    penalty = {
      [1] = "Liczba zgonów w twoim szpitalu przez ostatni rok jest nie do przyjęcia. Zwróć większą uwagę na to, co robisz. Spraw, aby w przyszłości wyleczyć więcej osób.",
      [2] = "Twój szpital niesie ryzyko dla zdrowia pacjentów. Oczekujemy od ciebie leczenia ludzi a nie ich zabijania.",
    },
    awards = {
      [1] = "Zdobyłeś Nagrodę Nie-Odwal-Kity za utrzymanie przy życiu 100 procent pacjentów w ostatnim roku.",
      [2] = "Otrzymujesz tę nagrodę, aby uczcić niską liczbę zgonów w twoim szpitalu w tym roku. Świetna robota.",
      [3] = "Śmiertelność w twoim szpitalu w ubiegłym roku była niższa niż w innych szpitalach. Proszę, przyjmij tę nagrodę.",
      [4] = "Dzięki twojemu talentowi poziom zgonów nie przekroczył minimum. Możesz być z siebie dumny.",
    },
    regional = {
      [1] = "Śmiertelność w twoim szpitalu w ubiegłym roku była niższa niż w innych szpitalach. Proszę, przyjmij tę nagrodę.",
    },
  },
  rats_killed = {
    trophies = {
      [1] = "Przyznano ci Trofeum Anty-Szkodnik za zeszłoroczny odstrzał %d szczurów w twoim szpitalu.",
      [2] = "Zakwalifikowano cię do trofeum z Federacji Przeciw Szczurom i Myszom, dzięki twym wyjątkowym umiejętnościom w wystrzeleniu %d tych stworzeń.",
      [3] = "Zakwalifikowałeś się do otrzymania Trofeum Wysadzić-Szczura za niebywałą umiejętność likwidacji %d szczurów w szpitalu w  zeszłym roku.",
    },
    awards = {
    },
  },
  happy_staff = {
    trophies = {
      [1] = "Zostałeś nagrodzony Radosnym Trofeum za utrzymanie szczęśliwym ciężko pracującego personelu.",
      [2] = "Instytut Szczęścia nagrodził cię, za brak niezadowolonego personelu w twoim szpitalu w ciągu ostatniego roku.",
      [3] = "To trofeum, Więcej Radości jest niniejszym wręczone tobie, za utrzymanie zadowolonego personelu podczas ostatniego roku. Uśmiechajcie się wszyscy!",
    },
    awards = {
      [1] = "Twoi pracownicy fundują ci tę nagrodę. Mówią, że można wprowadzić jeszcze kilka usprawnień, ale ogólnie jest dobrze.",
      [2] = "Twój pracownicy są tak zadowoleni, że uśmiech nie schodzi im z ust. Jesteś wyśmienitym menadżerem.",
    },
    penalty = {
      [1] = "Twój personel nie kryje faktu, że jest bardzo niezadowolony. Dobrzy pracownicy to skarb. Uszczęśliw ich albo dużo na tym stracisz.",
    },
    regional_good = {
      [1] = "Twój personel jest szczęśliwszy niż w innych szpitalach. Zadowolona załoga oznacza większe profity i mniej zgonów.",
    },
    regional_bad = {
      [1] = "Twoi pracownicy podczas ostatniego roku byli bardzo przygnębieni. Powinieneś był to zauważyć. Każdy inny szpital ma szczęśliwszych pracowników niż twój.",
    },
  },
  healthy_plants = {
    awards = {
      [1] = "Gratulacje z okazji wygrania nagrody Jak Na Drożdżach za utrzymywanie roślin w dobrym stanie przez ostatni rok.",
    },
    trophies = {
      [1] = "Przyjaciele Roślin Doniczkowych fundują ci Zielone Trofeum Zdrowia za utrzymanie roślin w dobrym stanie przez ostatni rok.",
      [2] = "Od Słodkich Rosiczek otrzymujesz Trofeum Wielkiego Ogrodnika za utrzymanie szpitalnych roślin w rewelacyjnej kondycji przez ostatni rok.",
    },
  },
  sold_drinks = {
    trophies = {
      [1] = "Światowe Stowarzyszenie Dentystów ma zaszczyt przyznać ci trofeum i odznakę za wysoką sprzedaż napojów w puszkach w twoim szpitalu.",
      [2] = "Twój szpital otrzymał nagrodę Gazowanego Zeusa Handlu Detalicznego za sprzedaż dużej liczby napojów w ostatnim roku.",
      [3] = "W imieniu kompanii Plomba Bomba Inc, otrzymujesz to pokryte czekoladą trofeum, aby uczcić niezwykle wysoką tegoroczną sprzedaż napojów w twoim szpitalu.",
    },
    awards = {
    },
  },
  many_cured = {
    trophies = {
      [1] = "Za wyleczenie ogromnej liczby ludzi w ciągu ostatniego roku, Międzynarodowa Fundacja Zdrowia chce uhonorować cię Trofeum WieloLecz.",
      [2] = "Za wyleczenie znacznego odsetka pacjentów odwiedzających twój szpital w ciągu ostatniego roku, przyznano ci Płukankowe Trofeum Nie Chorobom!",
      [3] = "Za wyleczenie znacznego odsetka pacjentów odwiedzających twój szpital w ciągu ostatniego roku, przyznano ci Płukankowe Trofeum Nie Chorobom!",
    },
    penalty = {
      [1] = "Twój szpital zawodzi w skutecznym niesieniu pomocy potrzebującym. Skoncentruj się na większej wydajności w leczeniu ludzi.",
      [2] = "Twój szpital jest mniej efektywny w leczeniu niż jakikolwiek inny. Zawiodłeś Ministerstwo i zawiodłeś samego siebie. Nic więcej nie mamy do powiedzenia.",
    },
    awards = {
      [1] = "Gratulacje! Zdobywasz Nagrodę Marii Curie za wyleczenie prawie wszystkich pacjentów twojego szpitala w ciągu ostatniego roku.",
      [2] = "Gratulacje za wyleczenie masy ludzi podczas ostatniego roku. Dużo pacjentów czuje się znacznie lepiej dzięki twojej pracy.",
      [3] = "Przyjmij tę nagrodę, za wyleczenie większej liczby pacjentów niż inne szpitale. Niebagatelny uczynek.",
      [4] = "Z zaszczytem wręczamy ci nagrodę za wyleczenie większej ilości pacjentów, niż wszystkie szpitale razem wzięte.",
    },
    regional = {
      [1] = "Z zaszczytem wręczamy ci nagrodę za wyleczenie większej ilości pacjentów, niż wszystkie szpitale razem wzięte.",
    },
  },
  pop_percentage = {
    awards = {
      [1] = "Wiedz, że twój szpital w zeszłym roku odwiedziło bardzo dużo ludzi. Dobra robota.",
      [2] = "Gratulacje. Liczba miejscowej ludności odwiedzającej twój szpital w zeszłym roku była dużo wyższa niż gdzie indziej.",
      [3] = "Wspaniale. Zwabiłeś więcej populacji do swojego szpitala, niż było odwiedzających we wszystkich innych szpitalach razem.",
    },
    penalty = {
      [1] = "Bardzo mało ludzi odwiedziło twój szpital w tym roku. Aby zarabiać pieniądze, ta instytucja potrzebuje pacjentów.",
      [2] = "Każdy szpital w tej okolicy zdołał przyjąć większą liczbę pacjentów, niż twój. Powinieneś się wstydzić.",
    },
  },
  research = {
    regional_good = {
      [1] = "Dzięki badaniom naukowym twój szpital przoduje w nowoczesności. Twój sztab naukowy zasłużył na tę nagrodę. Świetnie.",
    },
    penalty = {
      [1] = "Nie radziłeś sobie z wynajdowaniem nowych kuracji, urządzeń i leków. To niedobrze, gdyż postęp technologiczny jest niezwykle ważny.",
    },
    regional_bad = {
      [1] = "Jesteś najsłabszy w okolicy pod względem badań naukowych. Ministerstwo jest wściekłe, ponieważ powinno ci na tym szczególnie zależeć.",
    },
    awards = {
      [1] = "Dzięki badaniom naukowym twój szpital przoduje w nowoczesności. Twój sztab naukowy zasłużył na tę nagrodę. Świetnie.",
      [2] = "Podczas ostatniego roku wynalazłeś więcej leków i sprzętu, niż ktokolwiek mógł przypuszczać. Proszę, przyjmij tę nagrodę od całego Ministerstwa.",
    },
  },
  reputation = "REPUTACJA",
  cash = "GOTÓWKA",
}
menu_list_window = {
  save_date = "Utworzony",
  name = "Nazwa",
  back = "Wróć",
}
menu_options_volume = {
  [50] = "  50%  ",
  [100] = "  100%  ",
  [30] = "  30%  ",
  [60] = "  60%  ",
  [90] = "  90%  ",
  [10] = "  10%  ",
  [20] = "  20%  ",
  [40] = "  40%  ",
  [80] = "  80%  ",
  [70] = "  70%  ",
}
menu_file_load = {
  [1] = "  GRA 1  ",
  [2] = "  GRA 2  ",
  [3] = "  GRA 3  ",
  [4] = "  GRA 4  ",
  [5] = "  GRA 5  ",
  [6] = "  GRA 6  ",
  [7] = "  GRA 7  ",
  [8] = "  GRA 8  ",
}
menu_file = {
  quit = "  WYJDŹ ",
  save = "  ZAPISZ ",
  load = "  WCZYTAJ ",
  restart = "  RESTART  ",
}
rooms_long = {
  ultrascan = "Ultraskaner",
  research_room = "Dział Badawczy",
  general = "Ogólne",
  gps_office = "Gabinet Lekarski",
  inflation = "Napowietrzalnia",
  staffroom = "Pokój Socjalny",
  jelly_vat = "Galaretownica",
  scanner = "Skaner",
  emergency = "Nagły Wypadek",
  decontamination = "Gabinet Odkażania",
  corridors = "Korytarz",
  cardiogram = "Kardiograf",
  ward = "Oddział",
  training_room = "Sala Szkoleniowa",
  psychiatric = "Psychiatra",
  operating_theatre = "Sala Operacyjna",
  dna_fixer = "Re-GEN-erator",
  tongue_clinic = "Przych. Obrzynania",
  hair_restoration = "Przeszczepiacz Włosów",
  general_diag = "Podst. Badania",
  pharmacy = "Apteka",
  fracture_clinic = "Gab. Ortopedyczny",
  toilets = "Toalety",
  electrolysis = "Gabinet Elektrolizy",
  x_ray = "Rentgen",
  blood_machine = "Analizator Krwi",
}
save_game_window = {
  caption = "Zapisz Grę (%1%)",
  new_save_game = "Nowy Zapis",
}
fax = {
  epidemic_result = {
    fine_amount = "Rząd ogłosił stan zagrożenia i nałożył na ciebie grzywnę %d.",
    close_text = "Hura!",
    hospital_evacuated = "Komisja Zdrowia nie miała wyboru i postanowiła ewakuować twój szpital.",
    succeeded = {
      part_1_name = "Inspektor Zdrowia usłyszał plotki, że twoja instytucja miała do czynienie ze złą sytuacją z %s.",
      part_2 = "Jednakże nie dał rady znaleźć dowodów potwierdzających te plotki.",
    },
    compensation_amount = "Rząd postanowił wypłacić ci odszkodowanie %d za oszczerstwa, które naruszyły dobre imię twojego szpitala.",
    failed = {
      part_1_name = "Usiłujesz ukryć fakt zetknięcia się z zaraźliwym wybuchem %s",
      part_2 = "Twój personel spowodował, że choroba przeszła na ludność żyjącą w pobliżu szpitala.",
    },
    rep_loss_fine_amount = "Prasa będzie miała używanie w związku z tą sprawą, która poważnie zszarga twoją reputację. Poza tym dostaniesz grzywnę %d.",
  },
  vip_visit_query = {
    choices = {
      invite = "Wyślij VIPowi Oficjalne Zaproszenie .",
      refuse = "Spróbuj zbyć VIPa jakąś wymówką.",
    },
    vip_name = "%s wyraził chęć odwiedzenia twojego szpitala",
  },
  vip_visit_result = {
    telegram = "Telegram!",
    remarks = {
      good = {
        [1] = "Doskonale zarządzany szpital. Dziękuję, że mnie tu zaprosiłeś.",
        [2] = "Hmm. Całkiem niezła placówka służby zdrowia.",
        [3] = "Podobał mi się twój czarujący szpital. No dobrze, idzie ktoś na tajskie curry?",
      },
      super = {
        [1] = "Cóż za fantastyczny szpital. Jeśli poważnie zachoruję, przywieźcie mnie tutaj.",
        [2] = "To jest dopiero szpital!",
        [3] = "Super szpital. A wiem co mówię, bo już ich trochę widziałem.",
      },
      bad = {
        [1] = "Po co sobie zawracałem głowę? To było gorsze, niż oglądanie czterogodzinnej opery!",
        [2] = "Odrażający widok. To ma być szpital?! Chyba raczej chlew!",
        [3] = "Jako osoba publiczna mam już dosyć odwiedzania takich nor jak ta! Rezygnuję.",
      },
      free_build = {
        [1] = "Masz tu bardzo ładny szpital! Nie trudno się go prowadzi bez ograniczeń finansowych czyż nie?",
        [2] = "Nie jestem ekonomistą ale wydaje mi się, że też mógłbym poprowadzić ten szpital, jeżeli wiesz o czym mówię...",
        [3] = "Bardzo dobrze prowadzony szpital. Pamiętaj jednak o recesji! Racja... nie musisz się o to martwić.",
      },
      mediocre = {
        [1] = "No cóż, widywałem gorsze, ale powinieneś się bardziej postarać.",
        [2] = "Ojej. Jeśli kiepsko się czujesz, to nie jest miejsce dla ciebie.",
        [3] = "Szczerze mówiąc, to zwyczajny szpital. Oczekiwałem czegoś więcej.",
      },
      very_bad = {
        [1] = "Co za melina. Zrobię co w mojej mocy, żeby ją zamknęli.",
        [2] = "Skandal! W życiu nie widziałem tak koszmarnego szpitala. ",
        [3] = "Jestem w szoku. Tego nie da się nazwać szpitalem! Idę na piwo.",
      },
    },
    rep_boost = "Twoja reputacja w środowisku umocniła się.",
    vip_remarked_name = "Po wizycie w twoim szpitalu %s zdecydował:",
    cash_grant = "Otrzymasz dotację w wysokości %d.",
    rep_loss = "Dlatego też twoja reputacja ucierpiała.",
    close_text = "Dziękuję za odwiedzenie szpitala.",
  },
  disease_discovered_patient_choice = {
    need_to_build = "Musisz zbudować %s, aby sobie z tym poradzić.",
    need_to_employ = "Zatrudnij  %s żeby poradzić sobie z tą sytuacją.",
    what_to_do_question = "Co chcesz zrobić z pacjentem?",
    guessed_percentage_name = "Twoja ekipa musiała domyślać się przypadłości pacjenta. Jest %d procent szans, że to jest %s",
    choices = {
      send_home = "Wypisz Pacjenta do domu.",
      research = "Wyślij pacjenta do Działu Badawczego.",
      wait = "Każ Pacjentowi zaczekać chwilę w szpitalu.",
    },
    disease_name = "Twoja ekipa odkryła nową dolegliwość: %s",
    need_to_build_and_employ = "Jeżeli zbudujesz %s i zatrudnisz %s możesz osiągnąć cel.",
    can_not_cure = "Nie możesz wyleczyć tej choroby.",
  },
  emergency_result = {
    earned_money = "Mogłeś otrzymać maksymalnie %d, zarobiłeś %d.",
    close_text = "Kliknij, aby wyjść.",
    saved_people = "Uratowałeś %d ludzi z %d poszkodowanych.",
  },
  disease_discovered = {
    discovered_name = "Twoja ekipa odkryła nową dolegliwość: %s",
    need_to_employ = "Zatrudnij %s, aby poradzić sobie z tym kryzysem.",
    need_to_build_and_employ = "Jeżeli zbudujesz %s i zatrudnisz %s możesz osiągnąć cel.",
    need_to_build = "Musisz zbudować %s, aby sobie z tym poradzić.",
    close_text = "Dokonano odkrycia.",
    can_cure = "Możesz wyleczyć tę chorobę.",
  },
  emergency = {
    locations = {
      [1] = "Palmiarni Rośliny Chemiczne Rosiczka",
      [2] = "Lipnym Uniwersytecie",
      [3] = "Centrum Ogrodniczym Parakwiat",
      [4] = "Instytucie Naukowym Niebezpieczne Substancje",
      [5] = "Zajeździe Od Zmierzchu do Świtu",
      [6] = "Knajpie pod Żabą i Bykiem",
      [7] = "Salonie Pogrzebowym i Sklepie Monopolowym Radość",
      [8] = "Tajskim Sklepie z Curry",
      [9] = "Imperium Używana Petrochemia",
    },
    num_disease = "Jest %d ludzi z %s wymagających natychmiastowej pomocy.",
    cure_possible_drug_name_efficiency = "Już masz niezbędny sprzęt i umiejętności. Masz lek, którego potrzebują. To %s, a lek jest skuteczny w %d procentach.",
    cure_not_possible_employ = "Musisz zatrudnić %s",
    free_build = "Jeżeli ci się powiedzie, twoja reputacja wzrośnie, jeżeli jednak zawiedziesz, twoja reputacja poważnie ucierpi.",
    cure_not_possible = "W tej chwili nie możesz wyleczyć tej choroby.",
    num_disease_singular = "Jest 1 osoba z %s i wymaga natychmiastowej pomocy..",
    cure_possible = "Masz odpowiedni sprzęt i umiejętności, więc powinieneś poradzić sobie z tym nagłym wypadkiem.",
    choices = {
      accept = "Tak, jestem gotowy przyjąć nagły wypadek. ",
      refuse = "Nie, odmawiam przyjęcia nagłego wypadku.",
    },
    location = "W %s miał miejsce wypadek",
    cure_not_possible_build = "Musisz zbudować %s",
    cure_not_possible_build_and_employ = "Musisz zbudować %s i zatrudnić %s",
    bonus = "Za przyjęcie tego wypadku dostaniesz maksymalną premię w wysokości %d. Jeżeli zawiedziesz, twoja reputacja poważnie ucierpi.",
  },
  choices = {
    decline_new_level = "Kontynuuj grę jeszcze chwilę",
    accept_new_level = "Przejdź do następnego poziomu",
    return_to_main_menu = "Wróc do głównego menu",
  },
  debug_fax = {
    text4 = "PARAMETRY  : LEKARZE %d  PIELĘGNIARKI %d  OBSZAR %d  POKOJE %d  CENNIK %d",
    text5 = "WKŁAD : LEKARZE %d  PIELĘGNIARKI %d  OBSZAR %d  POKOJE %d  CENNIK %d PROCENT",
    text3 = "LICZBY  : LEKARZE %d  PIELĘGNIARKI %d  OBSZAR %d  POKOJE %d  CENNIK %d",
    text9 = "KATASTROFY %d DOZWOLONE (MIES) %d (%d)REDUKCJA %d",
    close_text = "Tak, tak, tak!",
    text1 = "NAJLEPSZY WYNIK %d",
    text6 = "NASTĘPUJĄCE PARAMETRY RÓWNIEŻ SĄ LICZONE",
    text8 = "UŁATWIENIA %d PORADY %d REDUKCJA %d",
    text2 = "SUMA LUDZI W SZPITALU %d PORÓWNUJĄC DO %d",
    text10 = "ZGONY %d DOZWOLONE (MIES) %d (%d) REDUKCJA %d",
    text11 = "LUDZI W TYM MIES %d",
    text7 = "REPUTACJA: %d OCZEKIWANA %d REDUKCJA %d",
  },
  epidemic = {
    cover_up_explanation_1 = "Jeśli jednak spróbujesz to zataić, dostaniesz limit czasu na wyleczenie wszystkich pacjentów, nim o sprawie dowiedzą się władze.",
    cover_up_explanation_2 = "Jeżeli Inspektor Zdrowia przeprowadzi wizytację i odkryje epidemię, może powziąć zdecydowane kroki przeciwko tobie.",
    choices = {
      cover_up = "Wylecz wszystkich zainfekowanych pacjentów w wyznaczonym czasie, nim ktokolwiek opuści szpital.",
      declare = "Ogłoś Epidemię. Zapłać karę i przyjmij cios w reputację.",
    },
    disease_name = "Twoi Lekarze odkryli zaraźliwy szczep wirusa: %s.",
    declare_explanation_fine = "Jeżeli ogłosisz epidemię, zapłacisz karę %d, ucierpi twoja reputacja i wszyscy pacjenci zostaną zaszczepieni automatycznie.",
  },
  diagnosis_failed = {
    choices = {
      send_home = "Wypisz Pacjenta do domu.",
      take_chance = "Podejmij ryzyko leczenia.",
      wait = "Zatrzymaj pacjenta, aż wybudujesz więcej gabinetów diagnostycznych.",
    },
    situation = "Próbowaliśmy wszystkich urządzeń na tym pacjencie i nadal nie jesteśmy pewni co mu dolega.",
    what_to_do_question = "Co powinniśmy zrobić z pacjentem?",
    partial_diagnosis_percentage_name = "Jest %d procent szans, że zidentyfikowaliśmy jaki typ %s dolega pacjentowi.",
  },
}
drug_companies = {
  [1] = "U Goździkowej",
  [2] = "Proszki i Groszki",
  [3] = "Harda Pigułka i Spółka",
  [4] = "Ropiejący Czopek S.A.",
  [5] = "MegaProch Corp.",
}
humanoid_name_ends = {
  [1] = "SMITH",
  [2] = "WICK",
  [3] = "CLIFFE",
  [4] = "SON",
  [5] = "INGTON",
  [6] = "BURY",
  [7] = "TON",
  [8] = "SON",
  [9] = "LEY",
  [10] = "BERRY",
  [11] = "BAUM",
  [12] = "LAN",
  [13] = "HAM",
  [14] = "SILL",
  [15] = "WIN",
  [16] = "LET",
  [17] = "ERS",
  [18] = "TON",
  [19] = "MOND",
  [20] = "MAN",
  [21] = "ELTON",
  [22] = "E",
  [23] = "MORE",
  [24] = "MOOR",
  [25] = "LET",
  [26] = "LIN",
}
menu_debug_overlay = {
  heat = "  TEMPERATURA  ",
  byte_0_1 = "  BYTE 0 & 1  ",
  byte_6 = "  BYTE 6  ",
  flags = "  FLAGS  ",
  byte_7 = "  BYTE 7  ",
  byte_5 = "  BYTE 5  ",
  byte_floor = "  BYTE FLOOR  ",
  positions = "  POSITIONS  ",
  byte_w_wall = "  BYTE W WALL  ",
  parcel = "  PARCEL  ",
  byte_n_wall = "  BYTE N WALL  ",
  none = "  NONE  ",
}
confirmation = {
  abort_edit_room = "W chwili obecnej budujesz lub edytujesz gabinet. Jeżeli wszystkie wymagane obiekty są w nim umieszczone, będzie on ukończony, w przeciwnym razie zostanie on usunięty. Czy na pewno chcesz kontynuować?",
  return_to_blueprint = "Czy na pewno chcesz powrócić do trybu Projektowania?",
  restart_level = "Czy na pewno chcesz rozpocząć poziom od początku?",
  delete_room = "Czy na pewno chcesz usunąć ten gabinet?",
  quit = "Wybrałeś wyjście z gry. Czy na pewno chcesz zakończyć grę?",
  needs_restart = "Zmiana tego ustawienia wymaga ponownego uruchomienia CorsixTH. Wszystkie niezapisane postępy zostaną utracone. Czy na pewno chcesz kontynuować?",
  overwrite_save = "Masz tu już zapisaną grę. Czy na pewno chcesz ją nadpisać?",
  sack_staff = "Czy na pewno chcesz zwolnić tę osobę?",
  replace_machine = "Czy na pewno chcesz wymienić %s za %d PLN?",
}
months = {
  [1] = "sty",
  [2] = "lut",
  [3] = "mar",
  [4] = "kwi",
  [5] = "maj",
  [6] = "cze",
  [7] = "lip",
  [8] = "sie",
  [9] = "wrz",
  [10] = "paź",
  [11] = "lis",
  [12] = "gru",
}
dynamic_info = {
  patient = {
    emergency = "Nagły wypadek: %s",
    guessed_diagnosis = "Odgadnięta diagnoza: %s ",
    diagnosis_progress = "Postęp diagnozy",
    actions = {
      sent_to_other_hospital = "Odesłany gdzie indziej",
      prices_too_high = "Twoje ceny są za wysokie - idę do domu",
      no_gp_available = "Czekam, aż zbudujesz Gabinet Lekarski",
      waiting_for_treatment_rooms = "Czekam, aż zbudujesz gabinet, w którym mnie wyleczysz",
      dying = "Umiera!",
      no_diagnoses_available = "Brak możliwości dalszej diagnozy - idę do domu",
      epidemic_sent_home = "Odesłany do domu przez Inspektora",
      cured = "Wyleczony!",
      waiting_for_diagnosis_rooms = "Czekam, aż zbudujesz więcej gabinetów diagnostycznych",
      epidemic_contagious = "Jestem zakażony",
      awaiting_decision = "Czeka na twoją decyzję",
      sent_home = "Wypisany do domu",
      fed_up = "Ma dosyć i wychodzi",
      no_treatment_available = "Brak możliwości leczenia - idę do domu",
      on_my_way_to = "W drodze do %s",
      queueing_for = "W kolejce do %s",
    },
    diagnosed = "Zdiagnozowano: %s ",
  },
  health_inspector = "Inspektor Zdrowia",
  vip = "Wizytator - VIP",
  object = {
    times_used = "Liczba użyć %d",
    queue_size = "Długość kolejki %d",
    strength = "Wytrzymałość %d",
    queue_expected = "Spodziewana kolejka %d",
  },
  staff = {
    ability = "Umiejętności",
    psychiatrist_abbrev = "Psych.",
    actions = {
      going_to_repair = "Idzie naprawić %s",
      fired = "Fired",
      waiting_for_patient = "Czeka na pacjenta",
      wandering = "Chodzi w kółko bez celu",
      heading_for = "Zmierza do %s",
    },
    tiredness = "Zmęczenie",
  },
}
introduction_texts = {
  level17 =
    "Ostatnia rada - dbaj o Reputację - to ona przyciąga lub zniechęca do twojej placówki pacjentów z całej okolicy. " ..
    "Jeśli tylko uda ci się nie zabić zbyt wielu ludzi i będą oni w miarę zadowoleni, nie powinieneś mieć problemów z tym poziomem!//" ..
    "Teraz już musisz radzić sobie sam. Życzę powodzenia.",
  level1 =
    "Witaj w swoim pierwszym szpitalu!//" ..
    "Aby rozpocząć działalność, postaw Biurko Recepcji, zbuduj Gabinet Lekarski i zatrudnij Recepcjonistkę oraz Lekarza. " ..
    "Następnie zaczekaj, aż pojawią się kolejne zadania." ..
    "Dobrym pomysłem jest budowa Gabinetu Psychiatrycznego oraz zatrudnienie Lekarza Psychiatry. " ..
    "Apteka i Pielęgniarka są także niezbędne w leczeniu pacjentów. " ..
    "Zwróć uwagę na ciężkie przypadki Głowowzdęcia - Napowietrzalnia rozwiąże ten problem. " ..
    "Będziesz musiał wyleczyć 10 ludzi i upewnić się, że twoja reputacja nie spadnie poniżej 200.",
  level9 =
    "Skoro już wzbogaciłeś konto Ministerstwa oraz ufundowałeś nową limuzynę samemu Ministrowi, możesz wracać do szpitala i nieść pomoc chorym i potrzebującym. " ..
    "Tutaj napotkasz wiele różnych trudności." ..
    "Z dobrze wyszkolonym personelem i gabinetami, nie powinieneś się niczego obawiać. " ..
    "Twój szpital musi być wart 200,000 PLN, a na konto ma trafić 400,000 PLN. " ..
    "Ani grosza mniej, bo nie ukończysz poziomu.",
  level2 =
    "Na tym obszarze jest dużo więcej rodzajów schorzeń. " ..
    "Urządź swój szpital tak, aby przyjął więcej pacjentów oraz zaplanuj budowę Działu Badawczego. " ..
    "Pamiętaj o utrzymywaniu czystości i postaraj się o możliwie najwyższą reputację - będziesz miał do czynienia z chorobami takimi jak Obwisły Język, więc potrzebujesz Przychodni Obrzynania. " ..
    "Możesz także zbudować Kardiograf, aby lepiej diagnozować nowe choroby. " ..
    "Oba te gabinety muszą zostać wynalezione zanim będziesz mógł je zbudować. Teraz możesz także kupić dodatkowy grunt, aby rozwinąć swój szpital - w tym celu użyj Mapy Miasta. " ..
    "Twój cel to reputacja na poziomie 300, stan konta 10000 PLN, i 40 wyleczonych osób.",
  level7 =
    "Będziesz tu pod ścisłym nadzorem Ministerstwa Zdrowia, dopilnuj więc by twoje konto wykazywało duże zyski, a reputacja szybowała w górę. " ..
    "Nie stać nas na niepotrzebne zgony - nie służy to biznesowi. " ..
    "Upewnij się, że personel jest w dobrej formie i że masz wszystkie wymagane urządzenia. " ..
    "Wypracuj reputację 600 oraz 200,000 PLN na koncie.",
  level5 =
    "To będzie szpital pełen życia, leczący wiele różnych dolegliwości. " ..
    "Twoi Lekarze dopiero skończyli studia, więc trzeba będzie wybudować salę szkoleniową, aby zdobyli niezbędne kwalifikacje. " ..
    "Masz tylko trzech Konsultantów szkolących twój personel. Dbaj więc o to, by byli zadowoleni. " ..
    "Zauważ także, że fundamenty szpitala znajdują się na uskoku tektonicznym San Android. " ..
    "Występuje tu duże ryzyko trzęsień ziemi. " ..
    "Trzęsienia mogą w znacznym stopniu uszkodzić urządzenia i zakłócić pracę szpitala. " ..
    "Aby odnieść sukces, dociągnij reputację do 400, zgromadź w banku okrągłe 50,000 PLN i wylecz 200 pacjentów.",
  level4 =
    "Staraj się zadowolić swych pacjentów, obłsuguj ich najlepiej jak potrafisz, utrzymaj również liczbę zgonów na absolutnym minimum." ..
    "Stawką jest twoja reputacja, więc dopilnuj żeby osiągnęła wysoki poziom. " ..
    "Nie martw się za bardzo o pieniądze - uzyskasz je wraz z rosnącą reputacją. " ..
    "Będziesz też mógł szkolić swoich Lekarzy, aby zwiększać ich umiejętności. " ..
    "Wyszkolony personel będzie lepiej zajmować się pacjentami, którzy wyglądają na ciężej chorych niż pozostali. " ..
    "Osiągnij reputację na poziomie ponad 500.",
  level14 =
    "Jest jeszcze jedno wyzwanie - totalnie niespodziewany szpital niespodzianka. " ..
    "Jeżeli tutaj odniesiesz sukces, będziesz zwycięzcą wszech czasów. " ..
    "Tylko nie myśl, że to będzie bułka z masłem, ponieważ jest to najtrudniejsze zadanie jakiemu stawisz czoła. " ..
    "Powodzenia!",
  level15 =
    "Tak wyglądają podstawowe mechanizmy działalności szpitala.//" ..
    "Twoi Lekarze będą potrzebować wszelkiej możliwej pomocy do diagnozowania niektórych pacjentów. Możesz im pomóc budując " ..
    "kolejne obiekty, takie jak Gabinet Badań Podstawowych.",
  level8 =
    "Do ciebie należy zadanie urządzenia wydajnego i opłacalnego szpitala. " ..
    "Ludzie tutaj są dość zamożni, więc oskub ich z forsy jak tylko się da. " ..
    "Miło jest leczyć ludzi, ale pamiętaj, że tak naprawdę liczą się PIENIĄDZE. " ..
    "Wyczyść tych chorych ludzi z pieniędzy. " ..
    "Aby ukończyć ten poziom, zgromadź sumę 300,000 PLN.",
  level13 =
    "Twoje niewiarygodne umiejętności w administrowaniu szpitala zwróciły uwagę Trzeciego Wydziału Tajnych Służb Specjalnych. " ..
    "Mają dla ciebie ekstra zadanie: w szpitalu zaatakowanym przez szczury potrzeba Terminatora. " ..
    "Musisz ustrzelić tyle szczurów, ile zdołasz, zanim Dozorcy uprzątną bałagan. " ..
    "Myślisz, że poradzisz sobie z zadaniem?",
  demo =
    "Witaj w szpitalu demonstracyjnym!" ..
    "Niestety wersja demo zawiera tylko ten poziom. Jednakże, jest to więcej niż wystarczająco, aby zając ci trochę czasu!" ..
    "Napotkasz tutaj rozmaite choroby, które będą wymagały różnych gabinetów do ich wyleczenia. Od czasu do czasu moga tu również wystąpić nagłe wypadki. Będziesz musiał równiez wynaleźć nowe pomieszczenia przy użyciu gabinetu badawczego." ..
    "Twoim celem jest zarobienie 100,000 PLN, mieć szpital warty 70,000 PLN i reputację 700, przy czym musisz wyleczyć co najmniej 75% swoich pacjentów." ..
    "Upewnij się, że Twoja reputacja nie spadnie poniżej 300 oraz, że nie zabijesz więcej niż 40% pacjentów, albo przegrasz." ..
    "Powodzenia!",
  level16 =
    "Kiedy już przebadasz część pacjentów, będziesz musiał zbudować pomieszczenia lecznicze oraz przychodnie, aby ich leczyć - " ..
    "dobrze jest zacząć od budowy Apteki. Do wydawania leków w Aptece będzie potrzebna Pielęgniarka .",
  level6 =
    "Użyj całej swojej wiedzy, aby gładko poprowadzić szpital, który przyniesie dobry zysk i poradzi sobie ze wszystkim, co przyniesie mu chore społeczeństwo. " ..
    "Powinieneś uważać na panujący tu klimat, gdyż sprzyja on rozwojowi bakterii i infekcji. " ..
    "Jeśli nie utrzymasz tego miejsca we wzorowej czystości, musisz się liczyć z wybuchem epidemii wśród pacjentów. " ..
    "Powinieneś zarobić 150,000 PLN a twój szpital osiągnąć wartość co najmniej 140,000 PLN.",
  level12 =
    "Masz teraz do czynienia z matką wszystkich wyzwań. " ..
    "Zachwycone twoimi sukcesami Ministerstwo ma dla ciebie zadanie specjalne. Masz zbudować kolejny wspaniały szpital, zarobić bajeczną ilość kasy i zyskać gigantyczną reputację. " ..
    "Musisz także wykupić wszystkie możliwe grunty, wyleczyć wszystko (tak - wszystko) oraz zgarnąć wszystkie nagrody. " ..
    "I jak? Dasz radę?" ..
    "Zarób 650,000 PLN, wylecz 750 ludzi oraz osiągnij reputację 800, aby wygrać.",
  level3 =
    "Tym razem urządzisz swój szpital w zamożej okolicy. " ..
    "Ministerstwo Zdrowia ma nadzieję, że osiągniesz tu znaczne zyski. " ..
    "Musisz wypracować dobrą reputację, jednak gdy szpital będzie już działał, skoncentruj się na zarabianiu tak dużo, jak tylko możliwe. " ..
    "Prawdopodobnie wystąpią tu też Nagłe Wypadki. " ..
    "Mają miejsce, gdy do szpitala przybywa duża grupa ludzi z tą samą dolegliwością. " ..
    "Wyleczenie ich wszystkich przed upływem czasu podnosi twoją reputację i zapewnia premię. " ..
    "Mogą wystąpić choroby takie jak Syndrom Króla. Przeznacz więc pieniądze na budowę Sali Operacyjnej z Oddziałem tuż obok. " ..
    "Aby stanąć na wysokości zadania, zarób 20,000 PLN.",
  level10 =
    "Ministerstwo prosi, abyś poza leczeniem chorób typowych dla tych stron, poświęcił nieco czasu na poprawę skuteczności leków. " ..
    "Zrzeszenie Pacjentów Bolibrzuch zgłosiło kilka krytycznych uwag. Nie daj im powodów do skarg i dopilnuj, by leki były jak najskuteczniejsze. " ..
    "Nikt nie powinien też czynić zarzutów samemu szpitalowi. Zmniejsz poziom umieralności. " ..
    "Dobrze będzie, jeśli zarezerwujesz trochę miejsca na Galaretownicę. " ..
    "Aby wygrać, udoskonal wszystkie leki do 80% skuteczności, zdobądź reputację 650 i zbierz w banku 500,000 PLN. ",
  level11 =
    "Dostałeś szansę budowy szpitala najdoskonalszego ze wszystkich. " ..
    "W tej niezwykle renomowanej okolicy Ministerstwo chciałoby mieć szpital najlepszy z możliwych. " ..
    "Oczekujemy, że zarobisz mnóstwo pieniędzy, zyskasz znakomitą reputację i poradzisz sobie ze wszelkimi ewentualnościami. " ..
    "To jest bardzo ważna robota. " ..
    "Będziesz musiał naprawdę się czymś wyróżnić. " ..
    "Trzeba ci wiedzieć, że w tych okolicach widywane jest UFO. Twój personel powinien być przygotowany na niespodziewanych gości. " ..
    "Warunki wygranej to: wartość szpitala 240,000 PLN, 500,000 PLN na koncie i reputacja na poziomie co najmniej 700.",
  level18 = "",
}
humanoid_name_starts = {
  [1] = "GOLD",
  [2] = "HIGH",
  [3] = "AND",
  [4] = "BEN",
  [5] = "BAN",
  [6] = "BILL",
  [7] = "WY",
  [8] = "WAT",
  [9] = "POD",
  [10] = "KING",
  [11] = "BAR",
  [12] = "PET",
  [13] = "MAN",
  [14] = "BOY",
  [15] = "WAR",
  [16] = "JACK",
  [17] = "CRAB",
  [18] = "FISH",
  [19] = "WATER",
  [20] = "MIL",
  [21] = "BY",
  [22] = "FEN",
  [23] = "RICH",
  [24] = "SCOT",
  [25] = "BUR",
  [26] = "PIKE",
  [27] = "CUR",
  [28] = "WHIT",
  [29] = "BINN",
  [30] = "BONN",
  [31] = "POG",
  [32] = "WRIGHT",
  [33] = "KER",
}
transactions = {
  severance = "Odprawa",
  research = "Koszty Badań",
  eoy_trophy_bonus = "Trofeum za Cały Rok",
  buy_object = "Zakup Przedmiotu",
  cure_colon = "Wyleczony:",
  epidemy_coverup_fine = "Kara za Tuszowanie Epidemii",
  final_treat_colon = "Końcowe Leczenie:",
  jukebox = "Dochody: Szafa Grająca",
  loan_interest = "Koszty Pożyczki",
  overdraft = "Koszty Debetu",
  wages = "Wypłaty",
  loan_repayment = "Spłata Pożyczki",
  personal_bonus = "Premia Indywidualna",
  drug_cost = "Koszty Leków",
  cure = "Leczenie",
  heating = "Koszty Ogrzewania",
  treat_colon = "Leczenie:",
  compensation = "Odszkodowanie Rządowe",
  epidemy_fine = "Kara za Epidemię",
  buy_land = "Kupno Terenu",
  research_bonus = "Premia za Badania",
  general_bonus = "Premia Ogólna",
  deposit = "Depozyt Leczenia",
  eoy_bonus_penalty = "Premia/Kara za Cały Rok",
  cheat = "Kasa za Przekręty",
  drinks = "Dochody: Automaty do Napoi",
  vaccination = "Szczepienie",
  advance_colon = "Awans:",
  vip_award = "Nagroda Pieniężna od VIPa",
  hire_staff = "Zatrudnienie Personelu",
  bank_loan = "Pożyczka Bankowa",
  machine_replacement = "Koszt Wymiany Urządzeń",
  emergency_bonus = "Premia za Nagłe Wypadki",
  build_room = "Budowa Pomieszczenia",
  insurance_colon = "Ubezp. :",
  sell_object = "Sprzedaż Obiektu",
}
object = {
  chair = "Krzesło",
  litter = "Śmieci",
  sofa = "Sofa",
  operating_table = "Stół Operacyjny",
  bed2 = "Łóżko",
  bench = "Ławka",
  scanner = "Skaner",
  couch = "Kozetka",
  blood_machine = "Analizator Krwi",
  table1 = "Stół",
  video_game = "Gra Wideo",
  lamp = "Lampa",
  op_sink2 = "Zlew",
  door = "Drzwi",
  auto_autopsy = "Auto Autopsja",
  reception_desk = "Biurko Recepcji",
  hair_restorer = "Przeszczepiacz",
  projector = "Projektor",
  crash_trolley = "Wózek Lekarski",
  tv = "Telewizor",
  ultrascanner = "Ultraskaner",
  surgeon_screen = "Parawan",
  litter_bomb = "Bomba Śmieciowa",
  inflator = "Napowietrzacz",
  table2 = "Stół",
  desk = "Biurko",
  pool_table = "Bilard",
  x_ray_viewer = "Monitor",
  radiation_shield = "Komputer Sterujący",
  bed = "Łóżko",
  swing_door2 = "Drzwi obrotowe",
  console = "Konsola",
  op_sink1 = "Zlew",
  bookcase = "Biblioteczka",
  drinks_machine = "Automat do napoi",
  comfortable_chair = "Fotel",
  skeleton = "Szkielet",
  computer = "Komputer",
  bin = "Śmietnik",
  pharmacy_cabinet = "Szafka z Lekami",
  radiator = "Kaloryfer",
  cast_remover = "Usuwacz Gipsu",
  atom_analyser = "Analizator Atomów",
  plant = "Rośliny",
  jelly_moulder = "Galaretownica",
  cardio = "Kardiograf",
  toilet = "Toalety",
  electrolyser = "Elektrolizer",
  fire_extinguisher = "Gaśnica",
  bed3 = "Łóżko",
  swing_door1 = "Drzwi obrotowe",
  lecture_chair = "Krzesło ucznia",
  screen = "Parawan",
  toilet_sink = "Zlew",
  shower = "Prysznic",
  gates_of_hell = "Bramy Piekieł",
  entrance_right = "Prawe drzwi wejściowe",
  entrance_left = "Lewe drzwi wejściowe",
  slicer = "Krajalnica",
  dna_fixer = "Re-GEN-erator",
  x_ray = "Rentgen",
  cabinet = "Szafka z aktami",
}
letter = {
  [1] = {
    [1] = "Drogi %s//",
    [2] = "Cudownie! Poradziłeś sobie wspaniale z prowadzeniem tego szpitala. My, grube ryby z Ministerstwa Zdrowia, chcemy wiedzieć czy byłbyś zainteresowany większym projektem. Mamy pracę, do której wydajesz się być wręcz stworzony. Wynagrodzenie będzie wynosiło %d PLN. Bądź łaskaw rozważyć naszą propozycję.//",
    [3] = "Czy jesteś zainteresowany pracą w Szpitalu %s?",
  },
  [2] = {
    [1] = "Drogi %s//",
    [2] = "Wyśmienicie! Dokonałeś wielkiego postępu w swoim szpitalu. Chcielibyśmy przenieść cię w inne miejsce, o ile masz ochotę na zmianę scenerii oraz nowe wyzwania. Nie musisz się zgadzać, jednak to może być w sam raz coś dla ciebie. Oferujemy pensję w wysokości %d PLN//",
    [3] = "Czy chcesz pracę w Szpitalu %s?",
  },
  [3] = {
    [1] = "Drogi %s//",
    [2] = "Przez ostatni czas bardzo pomyślnie zarządzałeś tą placówką. Uważamy, że możesz dokonać wielkich rzeczy i chcemy zaoferować ci pozycję w innym szpitalu. Twoja pensja wyniesie %d PLN. Jesteśmy przekonani, że pokochasz tamtejsze nowe wyzwania.//",
    [3] = "Czy chcesz przyjąć posadę w Szpitalu %s?",
  },
  [4] = {
    [1] = "Drogi %s//",
    [2] = "Gratulacje! My w Ministerstwie, jesteśmy zachwyceni twoimi umiejętnościami. Prawdę mówiąc, cały Departament Zdrowia uważa cię za złotego chłopaka. Wydaje nam się jednak, że wolałbyś nieco większe wyzwanie. Oferujemy ci pensję w wysokości %d PLN, ale decyzja należy do ciebie.//",
    [3] = "Czy jesteś zainteresowany pracą dla Szpitala %s?",
  },
  [5] = {
    [1] = "Drogi %s//",
    [2] = "Witamy ponownie. Respektujemy twoje życzenie, aby pozostać w tym uroczym szpitalu, jednak zachęcamy cię do zmiany decyzji. Zaoferujemy ci pensję w wysokości %dPLN, jeżeli odejdziesz do innego szpitala i dobrze go poprowadzisz.//",
    [3] = "Czy zechcesz się teraz przenieść do Szpitala %s?",
  },
  [6] = {
    [1] = "Drogi %s//",
    [2] = "Witamy. Wiemy jak szczęśliwy jesteś w tej uroczej i świetnie prowadzonej instytucji, jednak powinieneś posunąć swą karierę do przodu. Za przeniesienie będziesz miał prawo żądać %d PLN wynagrodzenia. Co ty na to?//",
    [3] = "Czy zechcesz poprowadzić Szpital %s?",
  },
  [7] = {
    [1] = "Drogi %s//",
    [2] = "Dzień dobry! Ministerstwo Zdrowia chce wiedzieć, czy zdecydowałbyś się opuścić obecny szpital. Zdajemy sobie sprawę, że jest on uroczy i wspaniale prowadzony. Wiemy jednak, że sprostałbyś większym wyzwaniom, za które dostałbyś pensję w wysokości %d PLN.//",
    [3] = "Czy akceptujesz stanowisko w Szpitalu %s?",
  },
  [8] = {
    [1] = "Drogi %s//",
    [2] = "Witamy ponownie. Odpowiedziałeś negatywnie na list, w którym oferowaliśmy ci czołowe stanowisko w nowym Szpitalu, z wynagrodzeniem %d PLN. Wydaje nam się jednak, że powinieneś przemyśleć tę decyzję. Tak się składa, że mamy dla ciebie idealną pracę.//",
    [3] = "Czy przyjmiesz stanowisko w Szpitalu %s?",
  },
  [9] = {
    [1] = "Drogi %s//",
    [2] = "Udowodniłeś, że jesteś najlepszym administratorem szpitala w całej historii medycyny. Tak wspaniałe osiągnięcie nie mogło zostać niezauważone, chcielibyśmy więc powierzyć ci stanowisko Naczelnego Szefa Wszystkich Szpitali. Z tą prestiżową posadą wiąże się pensja w wysokości %d PLN. Od teraz ludzie będą witali cię brawami i okazywali uznanie, gdziekolwiek byś się nie znalazł.//",
    [3] = "Dziękujemy za wszystko co zrobiłeś. Niech ci służy ta ciepła posadka.//",
    [4] = "",
  },
  [10] = {
    [1] = "Drogi %s//",
    [2] = "Gratulujemy udanego kierowania wszystkimi placówkami jakie ci powierzyliśmy. Dzięki tak wspaniałym wynikom cały świat stoi przed tobą otworem. Oferujemy ci pensję w wysokości %d PLN oraz limuzynę. W zamian prosimy tylko, byś podróżował z miasta do miasta, spotykał się z wielbiącym cię społeczeństwem i promował ideę płatnego szpitalnictwa.//",
    [3] = "Jesteśmy z ciebie dumni. Nie ma wśród nas nikogo, kto nie doceniałby twej ciężkiej pracy na rzecz ratowania życia.//",
    [4] = "",
  },
  [11] = {
    [1] = "Drogi %s//",
    [2] = "Twoja wzorowa kariera stanowi inspirację dla każdego z nas. Dziękujemy za prowadzenie tak wielu szpitali i świetne radzenie sobie z każdym problemem. Pragniemy uhonorować cię dożywotnim wynagrodzeniem w wysokości %d PLN. Czy zechciałbyś podróżować odkrytą limuzyną od miasta do miasta i prowadzić wykłady o tym, jak osiągnąłeś tak wiele w tak krótkim czasie?//",
    [3] = "Jesteś przykładem dla wszystkich myślących istot i każdy bez wyjątku uważa cię za bezcenny skarb.//",
    [4] = "",
  },
  [12] = {
    [1] = "Drogi %s//",
    [2] = "Twoja kariera najlepszego zarządcy szpitala od czasów Mojżesza dobiega końca. Mając jednak na uwadze wpływ jaki wywarłeś na kameralny świat medycyny, Minister oferuje ci honorarium w wysokości %d PLN. Twoim jednym zadaniem byłoby otwierać festiwale w naszym imieniu, wodować statki i uczestniczyć w różnych pokazach. Cały świat pada przed tobą na kolana, a my skorzystalibyśmy na twojej popularności!//",
    [3] = "Usilnie prosimy, przyjmij tę propozycję. To nie będzie ciężka praca, a dostaniesz samochód i eskortę policji, gdziekolwiek się wybierzesz.//",
    [4] = "",
  },
  custom_level_completed = "Dobra robota! Ukończyłeś wszystkie zadania w tym niestandardowym poziomie!",
  dear_player = "Drogi %s",
  return_to_main_menu = "Czy chcesz wrócić do głównego menu czy kontynuować grę?",
}
high_score = {
  categories = {
    deaths = "LICZBA ZGONÓW",
    total_value = "CAŁKOWITA WARTOŚĆ",
    money = "NAJBOGATSZY",
    cures = "LICZBA WYLECZEŃ",
    visitors = "NAJWIĘCEJ ODWIEDZAJĄCYCH",
    staff_number = "NAJWIĘCEJ PERSONELU",
    cure_death_ratio = "STOSUNEK WYLECZENI/ZGONY",
    patient_happiness = "ZADOWOLENIE KLIENTÓW",
    staff_happiness = "ZADOWOLENIE PERSONELU",
    salary = "NAJLEPSZE ZAROBKI",
    clean = "NAJCZYSTSZY",
  },
  player = "GRACZ",
  score = "WYNIK",
  pos = "POZ",
  best_scores = "SALA SŁAWY",
  worst_scores = "SALA WSTYDU",
  killed = "Zabici",
}
menu_file_save = {
  [1] = "  GRA 1  ",
  [2] = "  GRA 2  ",
  [3] = "  GRA 3  ",
  [4] = "  GRA 4  ",
  [5] = "  GRA 5  ",
  [6] = "  GRA 6  ",
  [7] = "  GRA 7  ",
  [8] = "  GRA 8  ",
}
build_room_window = {
  pick_room_type = "Wybierz Gabinet",
  pick_department = "Wybierz Dział",
  cost = "Koszt: ",
}
menu = {
  debug = "  BŁĄD  ",
  display = "  WYŚWIETLANIE",
  file = "  PLIK  ",
  options = "  OPCJE  ",
  charts = "  STATYSTYKI ",
}



--------------------------------  UNUSED  -----------------------------------
------------------- (kept for backwards compatibility) ----------------------

options_window.change_resolution = "Zmień rozdzielczość"
tooltip.options_window.change_resolution = "Zmień rozdzielczość okna do rozmiarów wpisanych po lewo"
