/* === This file is part of Calamares - <http://github.com/calamares> ===
 *
 *   Copyright 2015, Teo Mrnjavac <teo@kde.org>
 *   Copyright 2016, Luca Giambonini <almack@chakralinux.org>
 *
 *   Calamares is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   Calamares is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with Calamares. If not, see <http://www.gnu.org/licenses/>.
 */

import QtQuick 2.0;
import calamares.slideshow 1.0;

Presentation
{
    id: presentation

    Timer {
        interval: 10000
        running: true
        repeat: true
        onTriggered: presentation.goToNextSlide()
    }
    
    Slide {
        Image {
            id: background01
            source: "screenshot01.png"
            width: 454; height: 280
            fillMode: Image.PreserveAspectFit
            anchors.centerIn: parent
            anchors.verticalCenterOffset: -40
        }
        Text {
            anchors.horizontalCenter: background01.horizontalCenter
            anchors.top: background01.bottom
            anchors.topMargin: 15
            text: qsTr("Chakra ships with our very own Heritage artwork, including Plasma, SDDM and Application Colors themes, a custom set of wallpapers and a Yakuake skin.")
            wrapMode: Text.WordWrap
            width: 600
            horizontalAlignment: Text.Center
            font.pixelSize: parent.width * .020
        }
    }

    Slide {
        Image {
            id: background02
            source: "screenshot02.png"
            width: 454; height: 280
            fillMode: Image.PreserveAspectFit
            anchors.centerIn: parent
            anchors.verticalCenterOffset: -40
        }
        Text {
            anchors.horizontalCenter: background02.horizontalCenter
            anchors.top: background02.bottom
            anchors.topMargin: 15
            text: qsTr("Through our partnership with DuckDuckGo our users' privacy is protected and Chakra benefits from the shared revenue.")
            wrapMode: Text.WordWrap
            width: 600
            horizontalAlignment: Text.Center
            font.pixelSize: parent.width * .020
        }
    }

    Slide {
        Image {
            id: background03
            source: "screenshot03.png"
            width: 454; height: 280
            fillMode: Image.PreserveAspectFit
            anchors.centerIn: parent
            anchors.verticalCenterOffset: -40
        }
        Text {
            anchors.horizontalCenter: background03.horizontalCenter
            anchors.top: background03.bottom
            anchors.topMargin: 15
            text: qsTr("Dragon Player is the default media player, but you will find alternatives like vlc, mpv and kodi in our repositories.")
            wrapMode: Text.WordWrap
            width: 600
            horizontalAlignment: Text.Center
            font.pixelSize: parent.width * .020
        }
    }

    Slide {
        Image {
            id: background04
            source: "screenshot04.png"
            width: 454; height: 280
            fillMode: Image.PreserveAspectFit
            anchors.centerIn: parent
            anchors.verticalCenterOffset: -40
        }
        Text {
            anchors.horizontalCenter: background04.horizontalCenter
            anchors.top: background04.bottom
            anchors.topMargin: 15
            text: qsTr("Clementine is the default music player, but our repositories offer a great selection of other options like amarok, cantata and mpd.")
            wrapMode: Text.WordWrap
            width: 600
            horizontalAlignment: Text.Center
            font.pixelSize: parent.width * .020
        }
    }

    Slide {
        Image {
            id: background05
            source: "screenshot05.png"
            width: 454; height: 280
            fillMode: Image.PreserveAspectFit
            anchors.centerIn: parent
            anchors.verticalCenterOffset: -40
        }
        Text {
            anchors.horizontalCenter: background05.horizontalCenter
            anchors.top: background05.bottom
            anchors.topMargin: 15
            text: qsTr("Browse through your images using Gwenview or use a more powerful photo management application like Digikam.")
            wrapMode: Text.WordWrap
            width: 600
            horizontalAlignment: Text.Center
            font.pixelSize: parent.width * .020
        }
    }

    Slide {
        Image {
            id: background06
            source: "screenshot06.png"
            width: 454; height: 280
            fillMode: Image.PreserveAspectFit
            anchors.centerIn: parent
            anchors.verticalCenterOffset: -40
        }
        Text {
            anchors.horizontalCenter: background06.horizontalCenter
            anchors.top: background06.bottom
            anchors.topMargin: 15
            text: qsTr("Dolphin is a powerful and feature rich file manager, with many customization capabilities.")
            wrapMode: Text.WordWrap
            width: 600
            horizontalAlignment: Text.Center
        }
    }

    Slide {
        Image {
            id: background07
            source: "screenshot07.png"
            width: 454; height: 280
            fillMode: Image.PreserveAspectFit
            anchors.centerIn: parent
            anchors.verticalCenterOffset: -40
        }
        Text {
            anchors.horizontalCenter: background07.horizontalCenter
            anchors.top: background07.bottom
            anchors.topMargin: 15
            text: qsTr("The Calligra suite offers a set of modern applications to complete your office and design tasks. You will also find the popular LibreOffice suite in our repositories.")
            wrapMode: Text.WordWrap
            width: 600
            horizontalAlignment: Text.Center
            font.pixelSize: parent.width * .020
        }
    }

    Slide {
        Image {
            id: background08
            source: "screenshot08.png"
            width: 454; height: 280
            fillMode: Image.PreserveAspectFit
            anchors.centerIn: parent
            anchors.verticalCenterOffset: -40
        }
        Text {
            anchors.horizontalCenter: background08.horizontalCenter
            anchors.top: background08.bottom
            anchors.topMargin: 15
            text: qsTr("KDE develops a series of educational applications that you can install from our repositories.")
            wrapMode: Text.WordWrap
            width: 600
            horizontalAlignment: Text.Center
            font.pixelSize: parent.width * .020
        }
    }

    Slide {
        Image {
            id: background09
            source: "screenshot09.png"
            width: 454; height: 280
            fillMode: Image.PreserveAspectFit
            anchors.centerIn: parent
            anchors.verticalCenterOffset: -40
        }
        Text {
            anchors.horizontalCenter: background09.horizontalCenter
            anchors.top: background09.bottom
            anchors.topMargin: 15
            text: qsTr("Chakra by default doesn't ship with packages that depend on the Gtk+ toolkit, but we do provide the most popular ones in our [gtk] repository.")
            wrapMode: Text.WordWrap
            width: 600
            horizontalAlignment: Text.Center
            font.pixelSize: parent.width * .020
        }
    }

    Slide {
        Image {
            id: background10
            source: "screenshot10.png"
            width: 454; height: 280
            fillMode: Image.PreserveAspectFit
            anchors.centerIn: parent
            anchors.verticalCenterOffset: -40
        }
        Text {
            anchors.horizontalCenter: background10.horizontalCenter
            anchors.top: background10.bottom
            anchors.topMargin: 15
            text: qsTr("Enjoy your favorite games using Steam on Chakra! Just install it from our [lib32] repository.")
            wrapMode: Text.WordWrap
            width: 600
            horizontalAlignment: Text.Center
            font.pixelSize: parent.width * .020
        }
    }
}
