/* This file is part of the Chakra project

   Copyright (C) 2011 Lukas Appelhans <l.appelhans@gmx.de>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
*/
#ifndef AKABEIPLAINSIGNATUREOPERATION_H
#define AKABEIPLAINSIGNATUREOPERATION_H

#include <akabeioperation.h>
#include "akabeiclient_global.h"

namespace Akabei {
    class Package;
}

namespace AkabeiClient {
class AKABEICLIENTSHARED_EXPORT PlainSignatureOperation : public Akabei::Operation
{
    Q_OBJECT
    Q_DISABLE_COPY(PlainSignatureOperation)
public:
    explicit PlainSignatureOperation(Akabei::Package *package);
    virtual ~PlainSignatureOperation();

protected:
    void validate();
    void run();

private:
    class Private;
    Private * const d;

    Q_PRIVATE_SLOT(d, void __k__finished(bool))
};
}

#endif // AKABEIPLAINSIGNATUREOPERATION_H
