/* This file is part of the Chakra project

   Copyright (C) 2012 Lukas Appelhans <boom1992@chakra-project.org>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
*/

#ifndef AKABEICLIENTPOLKITSIGNATURECHECKER_H
#define AKABEICLIENTPOLKITSIGNATURECHECKER_H

#include <akabeierror.h>

namespace AkabeiClient {
class SignatureChecker;
class PolKitSignatureChecker
{
public:
    virtual ~PolKitSignatureChecker();
    
    /**
     * This method verifies a file with a corresponding signature file
     * Take care that the person signing is added and validated in your local gpg installation
     * @param file the file to be checked
     * @param sigFile the signature of the file to be checked, usually filename.sig
     * @returns true when the verification was successful
     */
    bool verify(const QString &file, const QString &sigFile) const;

    /**
     * @returns an Akabei::Error describing what went wrong, an empty list if nothing went wrong
     */
    Akabei::Error::List errors() const;
    
private:
    PolKitSignatureChecker();
    
    friend class Backend;
    
    class Private;
    Private *d;
};
}

#endif // POLKITSIGNATURECHECKER_H
