/* This file is part of the Chakra project

   Copyright (C) 2011 Lukas Appelhans

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
*/

#ifndef AKABEICLIENTMIRRORLIST_H
#define AKABEICLIENTMIRRORLIST_H

#include <akabeierror.h>
#include <QUrl>

namespace AkabeiClient {
class MirrorList;
/**
 * \class Mirror  akabeiclientmirrorlist.h "akabeiclientmirrorlist.h"
 *
 * \brief Describes a mirror inside a MirrorList
 * 
 * This class is thread-safe.
 */
class Mirror
{
public:
    ~Mirror();

    /**
     * Get the full url of a repository from the Mirror
     * @param repo the repository, e.g. "core"
     */
    QUrl url(const QString &repo);
    /**
     * Mark the mirror as broken. To get the next Mirror in the
     * MirrorList just call MirrorList::mirror() right after this.
     */
    void markBroken();

private:
    Mirror(const QUrl &url, MirrorList * parent);

    class Private;
    Private *d;

    friend class MirrorList;
};
/**
 * \class MirrorList  akabeiclientmirrorlist.h "akabeiclientmirrorlist.h"
 *
 * \brief Class to load mirrorlist files.
 *
 * This class can be used to load mirrorlist files. Those files only have simple
 * "Server = http://bla" lines in them.
 * 
 * This class is thread-safe.
 */
class MirrorList
{
public:
    /**
     * @param path the path of the mirrorlist file
     */
    MirrorList(const QString &path);
    virtual ~MirrorList();

    /**
     * @returns the current mirror, can possibly be 0
     */
    Mirror * mirror();

private:
    class Private;
    Private * d;

    friend class Mirror;
};
}

#endif // AKABEICLIENTMIRRORLIST_H
