#!/usr/bin/python

# Convenience method to show a progress bar in the command line.
#
#   Copyright (C) 2011 Lisa Vitolo <shainer@chakra-project.org>
#
#   This program is free software; you can redistribute it and/or
#   modify it under the terms of the GNU General Public
#   License as published by the Free Software Foundation; either
#   version 2 of the License, or (at your option) any later version.

import math
import sys

# The actual method wasn't written by me.
def showProgress(percent):
    width = 50
    marks = math.floor(width * (percent / 100.0))
    spaces = math.floor(width - marks)
    
    loader = '[' + ('=' * int(marks)) + (' ' * int(spaces)) + ']'
      
    sys.stdout.write("%s %d%%\r" % (loader, percent))
    if percent >= 100:
        sys.stdout.write("\n")
    sys.stdout.flush()