// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#elif defined(_MSC_VER)
#pragma warning(push)
#pragma warning(disable:4056)
#pragma warning(disable:4065)
#pragma warning(disable:4756)
#endif

#include "qtwebengine/browser/qtwebchannel.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/logging.h"
#include "base/run_loop.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "qtwebengine/browser/qtwebchannel.mojom-shared-message-ids.h"
namespace qtwebchannel {
namespace mojom {
const char WebChannelTransportRender::Name_[] = "qtwebchannel.mojom.WebChannelTransportRender";

WebChannelTransportRenderProxy::WebChannelTransportRenderProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void WebChannelTransportRenderProxy::SetWorldId(
    uint32_t in_worldId) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "qtwebchannel::mojom::WebChannelTransportRender::SetWorldId");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kWebChannelTransportRender_SetWorldId_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::qtwebchannel::mojom::internal::WebChannelTransportRender_SetWorldId_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->worldId = in_worldId;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebChannelTransportRender::Name_);
  message.set_method_name("SetWorldId");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void WebChannelTransportRenderProxy::ResetWorldId(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "qtwebchannel::mojom::WebChannelTransportRender::ResetWorldId");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kWebChannelTransportRender_ResetWorldId_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::qtwebchannel::mojom::internal::WebChannelTransportRender_ResetWorldId_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebChannelTransportRender::Name_);
  message.set_method_name("ResetWorldId");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void WebChannelTransportRenderProxy::DispatchWebChannelMessage(
    const std::vector<uint8_t>& in_binaryJson, uint32_t in_worldId) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "qtwebchannel::mojom::WebChannelTransportRender::DispatchWebChannelMessage");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kWebChannelTransportRender_DispatchWebChannelMessage_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::qtwebchannel::mojom::internal::WebChannelTransportRender_DispatchWebChannelMessage_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->binaryJson)::BaseType::BufferWriter
      binaryJson_writer;
  const mojo::internal::ContainerValidateParams binaryJson_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
      in_binaryJson, buffer, &binaryJson_writer, &binaryJson_validate_params,
      &serialization_context);
  params->binaryJson.Set(
      binaryJson_writer.is_null() ? nullptr : binaryJson_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->binaryJson.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null binaryJson in WebChannelTransportRender.DispatchWebChannelMessage request");
  params->worldId = in_worldId;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebChannelTransportRender::Name_);
  message.set_method_name("DispatchWebChannelMessage");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool WebChannelTransportRenderStubDispatch::Accept(
    WebChannelTransportRender* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kWebChannelTransportRender_SetWorldId_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "(Impl)qtwebchannel::mojom::WebChannelTransportRender::SetWorldId",
               "message", message->name());
#endif
      mojo::internal::MessageDispatchContext context(message);

      DCHECK(message->is_serialized());
      internal::WebChannelTransportRender_SetWorldId_Params_Data* params =
          reinterpret_cast<internal::WebChannelTransportRender_SetWorldId_Params_Data*>(
              message->mutable_payload());
      
      mojo::internal::SerializationContext serialization_context;
      serialization_context.TakeHandlesFromMessage(message);
      bool success = true;
      uint32_t p_worldId{};
      WebChannelTransportRender_SetWorldId_ParamsDataView input_data_view(params, &serialization_context);
      
      p_worldId = input_data_view.worldId();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            "WebChannelTransportRender::SetWorldId deserializer");
        return false;
      }
      // A null |impl| means no implementation was bound.
      assert(impl);
      impl->SetWorldId(
std::move(p_worldId));
      return true;
    }
    case internal::kWebChannelTransportRender_ResetWorldId_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "(Impl)qtwebchannel::mojom::WebChannelTransportRender::ResetWorldId",
               "message", message->name());
#endif
      mojo::internal::MessageDispatchContext context(message);

      DCHECK(message->is_serialized());
      internal::WebChannelTransportRender_ResetWorldId_Params_Data* params =
          reinterpret_cast<internal::WebChannelTransportRender_ResetWorldId_Params_Data*>(
              message->mutable_payload());
      
      mojo::internal::SerializationContext serialization_context;
      serialization_context.TakeHandlesFromMessage(message);
      bool success = true;
      WebChannelTransportRender_ResetWorldId_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            "WebChannelTransportRender::ResetWorldId deserializer");
        return false;
      }
      // A null |impl| means no implementation was bound.
      assert(impl);
      impl->ResetWorldId();
      return true;
    }
    case internal::kWebChannelTransportRender_DispatchWebChannelMessage_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "(Impl)qtwebchannel::mojom::WebChannelTransportRender::DispatchWebChannelMessage",
               "message", message->name());
#endif
      mojo::internal::MessageDispatchContext context(message);

      DCHECK(message->is_serialized());
      internal::WebChannelTransportRender_DispatchWebChannelMessage_Params_Data* params =
          reinterpret_cast<internal::WebChannelTransportRender_DispatchWebChannelMessage_Params_Data*>(
              message->mutable_payload());
      
      mojo::internal::SerializationContext serialization_context;
      serialization_context.TakeHandlesFromMessage(message);
      bool success = true;
      std::vector<uint8_t> p_binaryJson{};
      uint32_t p_worldId{};
      WebChannelTransportRender_DispatchWebChannelMessage_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!input_data_view.ReadBinaryJson(&p_binaryJson))
        success = false;
      p_worldId = input_data_view.worldId();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            "WebChannelTransportRender::DispatchWebChannelMessage deserializer");
        return false;
      }
      // A null |impl| means no implementation was bound.
      assert(impl);
      impl->DispatchWebChannelMessage(
std::move(p_binaryJson), 
std::move(p_worldId));
      return true;
    }
  }
  return false;
}

// static
bool WebChannelTransportRenderStubDispatch::AcceptWithResponder(
    WebChannelTransportRender* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  switch (message->header()->name) {
    case internal::kWebChannelTransportRender_SetWorldId_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "(Impl)qtwebchannel::mojom::WebChannelTransportRender::SetWorldId",
               "message", message->name());
#endif
      break;
    }
    case internal::kWebChannelTransportRender_ResetWorldId_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "(Impl)qtwebchannel::mojom::WebChannelTransportRender::ResetWorldId",
               "message", message->name());
#endif
      break;
    }
    case internal::kWebChannelTransportRender_DispatchWebChannelMessage_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "(Impl)qtwebchannel::mojom::WebChannelTransportRender::DispatchWebChannelMessage",
               "message", message->name());
#endif
      break;
    }
  }
  return false;
}

bool WebChannelTransportRenderRequestValidator::Accept(mojo::Message* message) {
  if (!message->is_serialized() ||
      mojo::internal::ControlMessageHandler::IsControlMessage(message)) {
    return true;
  }

  mojo::internal::ValidationContext validation_context(
    message->payload(), message->payload_num_bytes(),
    message->handles()->size(), message->payload_num_interface_ids(), message,
    "WebChannelTransportRender RequestValidator");

  switch (message->header()->name) {
    case internal::kWebChannelTransportRender_SetWorldId_Name: {
      if (!mojo::internal::ValidateMessageIsRequestWithoutResponse(
              message, &validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateMessagePayload<
               internal::WebChannelTransportRender_SetWorldId_Params_Data>(
                  message, &validation_context)) {
        return false;
      }
      return true;
    }
    case internal::kWebChannelTransportRender_ResetWorldId_Name: {
      if (!mojo::internal::ValidateMessageIsRequestWithoutResponse(
              message, &validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateMessagePayload<
               internal::WebChannelTransportRender_ResetWorldId_Params_Data>(
                  message, &validation_context)) {
        return false;
      }
      return true;
    }
    case internal::kWebChannelTransportRender_DispatchWebChannelMessage_Name: {
      if (!mojo::internal::ValidateMessageIsRequestWithoutResponse(
              message, &validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateMessagePayload<
               internal::WebChannelTransportRender_DispatchWebChannelMessage_Params_Data>(
                  message, &validation_context)) {
        return false;
      }
      return true;
    }
    default:
      break;
  }

  // Unrecognized message.
  ReportValidationError(
      &validation_context,
      mojo::internal::VALIDATION_ERROR_MESSAGE_HEADER_UNKNOWN_METHOD);
  return false;
}

void WebChannelTransportRenderInterceptorForTesting::SetWorldId(uint32_t worldId) {
  GetForwardingInterface()->SetWorldId(std::move(worldId));
}
void WebChannelTransportRenderInterceptorForTesting::ResetWorldId() {
  GetForwardingInterface()->ResetWorldId();
}
void WebChannelTransportRenderInterceptorForTesting::DispatchWebChannelMessage(const std::vector<uint8_t>& binaryJson, uint32_t worldId) {
  GetForwardingInterface()->DispatchWebChannelMessage(std::move(binaryJson), std::move(worldId));
}
WebChannelTransportRenderAsyncWaiter::WebChannelTransportRenderAsyncWaiter(
    WebChannelTransportRender* proxy) : proxy_(proxy) {}

WebChannelTransportRenderAsyncWaiter::~WebChannelTransportRenderAsyncWaiter() = default;


const char WebChannelTransportHost::Name_[] = "qtwebchannel.mojom.WebChannelTransportHost";

WebChannelTransportHostProxy::WebChannelTransportHostProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void WebChannelTransportHostProxy::DispatchWebChannelMessage(
    const std::vector<uint8_t>& in_binaryJson) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "qtwebchannel::mojom::WebChannelTransportHost::DispatchWebChannelMessage");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kWebChannelTransportHost_DispatchWebChannelMessage_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::qtwebchannel::mojom::internal::WebChannelTransportHost_DispatchWebChannelMessage_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->binaryJson)::BaseType::BufferWriter
      binaryJson_writer;
  const mojo::internal::ContainerValidateParams binaryJson_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
      in_binaryJson, buffer, &binaryJson_writer, &binaryJson_validate_params,
      &serialization_context);
  params->binaryJson.Set(
      binaryJson_writer.is_null() ? nullptr : binaryJson_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->binaryJson.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null binaryJson in WebChannelTransportHost.DispatchWebChannelMessage request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebChannelTransportHost::Name_);
  message.set_method_name("DispatchWebChannelMessage");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool WebChannelTransportHostStubDispatch::Accept(
    WebChannelTransportHost* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kWebChannelTransportHost_DispatchWebChannelMessage_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "(Impl)qtwebchannel::mojom::WebChannelTransportHost::DispatchWebChannelMessage",
               "message", message->name());
#endif
      mojo::internal::MessageDispatchContext context(message);

      DCHECK(message->is_serialized());
      internal::WebChannelTransportHost_DispatchWebChannelMessage_Params_Data* params =
          reinterpret_cast<internal::WebChannelTransportHost_DispatchWebChannelMessage_Params_Data*>(
              message->mutable_payload());
      
      mojo::internal::SerializationContext serialization_context;
      serialization_context.TakeHandlesFromMessage(message);
      bool success = true;
      std::vector<uint8_t> p_binaryJson{};
      WebChannelTransportHost_DispatchWebChannelMessage_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!input_data_view.ReadBinaryJson(&p_binaryJson))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            "WebChannelTransportHost::DispatchWebChannelMessage deserializer");
        return false;
      }
      // A null |impl| means no implementation was bound.
      assert(impl);
      impl->DispatchWebChannelMessage(
std::move(p_binaryJson));
      return true;
    }
  }
  return false;
}

// static
bool WebChannelTransportHostStubDispatch::AcceptWithResponder(
    WebChannelTransportHost* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  switch (message->header()->name) {
    case internal::kWebChannelTransportHost_DispatchWebChannelMessage_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "(Impl)qtwebchannel::mojom::WebChannelTransportHost::DispatchWebChannelMessage",
               "message", message->name());
#endif
      break;
    }
  }
  return false;
}

bool WebChannelTransportHostRequestValidator::Accept(mojo::Message* message) {
  if (!message->is_serialized() ||
      mojo::internal::ControlMessageHandler::IsControlMessage(message)) {
    return true;
  }

  mojo::internal::ValidationContext validation_context(
    message->payload(), message->payload_num_bytes(),
    message->handles()->size(), message->payload_num_interface_ids(), message,
    "WebChannelTransportHost RequestValidator");

  switch (message->header()->name) {
    case internal::kWebChannelTransportHost_DispatchWebChannelMessage_Name: {
      if (!mojo::internal::ValidateMessageIsRequestWithoutResponse(
              message, &validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateMessagePayload<
               internal::WebChannelTransportHost_DispatchWebChannelMessage_Params_Data>(
                  message, &validation_context)) {
        return false;
      }
      return true;
    }
    default:
      break;
  }

  // Unrecognized message.
  ReportValidationError(
      &validation_context,
      mojo::internal::VALIDATION_ERROR_MESSAGE_HEADER_UNKNOWN_METHOD);
  return false;
}

void WebChannelTransportHostInterceptorForTesting::DispatchWebChannelMessage(const std::vector<uint8_t>& binaryJson) {
  GetForwardingInterface()->DispatchWebChannelMessage(std::move(binaryJson));
}
WebChannelTransportHostAsyncWaiter::WebChannelTransportHostAsyncWaiter(
    WebChannelTransportHost* proxy) : proxy_(proxy) {}

WebChannelTransportHostAsyncWaiter::~WebChannelTransportHostAsyncWaiter() = default;


}  // namespace mojom
}  // namespace qtwebchannel

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#elif defined(_MSC_VER)
#pragma warning(pop)
#endif