// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#elif defined(_MSC_VER)
#pragma warning(push)
#pragma warning(disable:4056)
#pragma warning(disable:4065)
#pragma warning(disable:4756)
#endif

#include "content/browser/process_internals/process_internals.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/logging.h"
#include "base/run_loop.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "content/browser/process_internals/process_internals.mojom-shared-message-ids.h"
namespace mojom {
const char ProcessInternalsHandler::Name_[] = "mojom.ProcessInternalsHandler";

class ProcessInternalsHandler_GetIsolationMode_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ProcessInternalsHandler_GetIsolationMode_ForwardToCallback(
      ProcessInternalsHandler::GetIsolationModeCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  ProcessInternalsHandler::GetIsolationModeCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(ProcessInternalsHandler_GetIsolationMode_ForwardToCallback);
};

class ProcessInternalsHandler_GetIsolatedOriginsSize_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ProcessInternalsHandler_GetIsolatedOriginsSize_ForwardToCallback(
      ProcessInternalsHandler::GetIsolatedOriginsSizeCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  ProcessInternalsHandler::GetIsolatedOriginsSizeCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(ProcessInternalsHandler_GetIsolatedOriginsSize_ForwardToCallback);
};

ProcessInternalsHandlerProxy::ProcessInternalsHandlerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ProcessInternalsHandlerProxy::GetIsolationMode(
    GetIsolationModeCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "mojom::ProcessInternalsHandler::GetIsolationMode");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kProcessInternalsHandler_GetIsolationMode_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::mojom::internal::ProcessInternalsHandler_GetIsolationMode_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ProcessInternalsHandler::Name_);
  message.set_method_name("GetIsolationMode");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ProcessInternalsHandler_GetIsolationMode_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void ProcessInternalsHandlerProxy::GetIsolatedOriginsSize(
    GetIsolatedOriginsSizeCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "mojom::ProcessInternalsHandler::GetIsolatedOriginsSize");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kProcessInternalsHandler_GetIsolatedOriginsSize_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::mojom::internal::ProcessInternalsHandler_GetIsolatedOriginsSize_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ProcessInternalsHandler::Name_);
  message.set_method_name("GetIsolatedOriginsSize");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ProcessInternalsHandler_GetIsolatedOriginsSize_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class ProcessInternalsHandler_GetIsolationMode_ProxyToResponder {
 public:
  static ProcessInternalsHandler::GetIsolationModeCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ProcessInternalsHandler_GetIsolationMode_ProxyToResponder> proxy(
        new ProcessInternalsHandler_GetIsolationMode_ProxyToResponder(
            request_id, is_sync, std::move(responder)));
    return base::BindOnce(&ProcessInternalsHandler_GetIsolationMode_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ProcessInternalsHandler_GetIsolationMode_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  ProcessInternalsHandler_GetIsolationMode_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ProcessInternalsHandler::GetIsolationModeCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      const std::string& in_mode);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(ProcessInternalsHandler_GetIsolationMode_ProxyToResponder);
};

bool ProcessInternalsHandler_GetIsolationMode_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "mojom::ProcessInternalsHandler::GetIsolationModeCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::ProcessInternalsHandler_GetIsolationMode_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ProcessInternalsHandler_GetIsolationMode_ResponseParams_Data*>(
              message->mutable_payload());
  
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  bool success = true;
  std::string p_mode{};
  ProcessInternalsHandler_GetIsolationMode_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (!input_data_view.ReadMode(&p_mode))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        "ProcessInternalsHandler::GetIsolationMode response deserializer");
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_mode));
  return true;
}

void ProcessInternalsHandler_GetIsolationMode_ProxyToResponder::Run(
    const std::string& in_mode) {
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kProcessInternalsHandler_GetIsolationMode_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::mojom::internal::ProcessInternalsHandler_GetIsolationMode_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->mode)::BaseType::BufferWriter
      mode_writer;
  mojo::internal::Serialize<mojo::StringDataView>(
      in_mode, buffer, &mode_writer, &serialization_context);
  params->mode.Set(
      mode_writer.is_null() ? nullptr : mode_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->mode.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null mode in ");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "(Impl)mojom::ProcessInternalsHandler::GetIsolationModeCallback",
               "message", message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ProcessInternalsHandler::Name_);
  message.set_method_name("GetIsolationMode");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ProcessInternalsHandler_GetIsolatedOriginsSize_ProxyToResponder {
 public:
  static ProcessInternalsHandler::GetIsolatedOriginsSizeCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ProcessInternalsHandler_GetIsolatedOriginsSize_ProxyToResponder> proxy(
        new ProcessInternalsHandler_GetIsolatedOriginsSize_ProxyToResponder(
            request_id, is_sync, std::move(responder)));
    return base::BindOnce(&ProcessInternalsHandler_GetIsolatedOriginsSize_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ProcessInternalsHandler_GetIsolatedOriginsSize_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  ProcessInternalsHandler_GetIsolatedOriginsSize_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ProcessInternalsHandler::GetIsolatedOriginsSizeCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      uint32_t in_size);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(ProcessInternalsHandler_GetIsolatedOriginsSize_ProxyToResponder);
};

bool ProcessInternalsHandler_GetIsolatedOriginsSize_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "mojom::ProcessInternalsHandler::GetIsolatedOriginsSizeCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::ProcessInternalsHandler_GetIsolatedOriginsSize_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ProcessInternalsHandler_GetIsolatedOriginsSize_ResponseParams_Data*>(
              message->mutable_payload());
  
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  bool success = true;
  uint32_t p_size{};
  ProcessInternalsHandler_GetIsolatedOriginsSize_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  p_size = input_data_view.size();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        "ProcessInternalsHandler::GetIsolatedOriginsSize response deserializer");
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_size));
  return true;
}

void ProcessInternalsHandler_GetIsolatedOriginsSize_ProxyToResponder::Run(
    uint32_t in_size) {
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kProcessInternalsHandler_GetIsolatedOriginsSize_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::mojom::internal::ProcessInternalsHandler_GetIsolatedOriginsSize_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->size = in_size;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "(Impl)mojom::ProcessInternalsHandler::GetIsolatedOriginsSizeCallback",
               "message", message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ProcessInternalsHandler::Name_);
  message.set_method_name("GetIsolatedOriginsSize");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool ProcessInternalsHandlerStubDispatch::Accept(
    ProcessInternalsHandler* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kProcessInternalsHandler_GetIsolationMode_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "(Impl)mojom::ProcessInternalsHandler::GetIsolationMode",
               "message", message->name());
#endif
      break;
    }
    case internal::kProcessInternalsHandler_GetIsolatedOriginsSize_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "(Impl)mojom::ProcessInternalsHandler::GetIsolatedOriginsSize",
               "message", message->name());
#endif
      break;
    }
  }
  return false;
}

// static
bool ProcessInternalsHandlerStubDispatch::AcceptWithResponder(
    ProcessInternalsHandler* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  switch (message->header()->name) {
    case internal::kProcessInternalsHandler_GetIsolationMode_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "(Impl)mojom::ProcessInternalsHandler::GetIsolationMode",
               "message", message->name());
#endif
      mojo::internal::MessageDispatchContext context(message);

      internal::ProcessInternalsHandler_GetIsolationMode_Params_Data* params =
          reinterpret_cast<
              internal::ProcessInternalsHandler_GetIsolationMode_Params_Data*>(
                  message->mutable_payload());
      
      mojo::internal::SerializationContext serialization_context;
      serialization_context.TakeHandlesFromMessage(message);
      bool success = true;
      ProcessInternalsHandler_GetIsolationMode_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            "ProcessInternalsHandler::GetIsolationMode deserializer");
        return false;
      }
      ProcessInternalsHandler::GetIsolationModeCallback callback =
          ProcessInternalsHandler_GetIsolationMode_ProxyToResponder::CreateCallback(
              message->request_id(),
              message->has_flag(mojo::Message::kFlagIsSync),
              std::move(responder));
      // A null |impl| means no implementation was bound.
      assert(impl);
      impl->GetIsolationMode(std::move(callback));
      return true;
    }
    case internal::kProcessInternalsHandler_GetIsolatedOriginsSize_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "(Impl)mojom::ProcessInternalsHandler::GetIsolatedOriginsSize",
               "message", message->name());
#endif
      mojo::internal::MessageDispatchContext context(message);

      internal::ProcessInternalsHandler_GetIsolatedOriginsSize_Params_Data* params =
          reinterpret_cast<
              internal::ProcessInternalsHandler_GetIsolatedOriginsSize_Params_Data*>(
                  message->mutable_payload());
      
      mojo::internal::SerializationContext serialization_context;
      serialization_context.TakeHandlesFromMessage(message);
      bool success = true;
      ProcessInternalsHandler_GetIsolatedOriginsSize_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            "ProcessInternalsHandler::GetIsolatedOriginsSize deserializer");
        return false;
      }
      ProcessInternalsHandler::GetIsolatedOriginsSizeCallback callback =
          ProcessInternalsHandler_GetIsolatedOriginsSize_ProxyToResponder::CreateCallback(
              message->request_id(),
              message->has_flag(mojo::Message::kFlagIsSync),
              std::move(responder));
      // A null |impl| means no implementation was bound.
      assert(impl);
      impl->GetIsolatedOriginsSize(std::move(callback));
      return true;
    }
  }
  return false;
}

bool ProcessInternalsHandlerRequestValidator::Accept(mojo::Message* message) {
  if (!message->is_serialized() ||
      mojo::internal::ControlMessageHandler::IsControlMessage(message)) {
    return true;
  }

  mojo::internal::ValidationContext validation_context(
    message->payload(), message->payload_num_bytes(),
    message->handles()->size(), message->payload_num_interface_ids(), message,
    "ProcessInternalsHandler RequestValidator");

  switch (message->header()->name) {
    case internal::kProcessInternalsHandler_GetIsolationMode_Name: {
      if (!mojo::internal::ValidateMessageIsRequestExpectingResponse(
              message, &validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateMessagePayload<
               internal::ProcessInternalsHandler_GetIsolationMode_Params_Data>(
                  message, &validation_context)) {
        return false;
      }
      return true;
    }
    case internal::kProcessInternalsHandler_GetIsolatedOriginsSize_Name: {
      if (!mojo::internal::ValidateMessageIsRequestExpectingResponse(
              message, &validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateMessagePayload<
               internal::ProcessInternalsHandler_GetIsolatedOriginsSize_Params_Data>(
                  message, &validation_context)) {
        return false;
      }
      return true;
    }
    default:
      break;
  }

  // Unrecognized message.
  ReportValidationError(
      &validation_context,
      mojo::internal::VALIDATION_ERROR_MESSAGE_HEADER_UNKNOWN_METHOD);
  return false;
}

bool ProcessInternalsHandlerResponseValidator::Accept(mojo::Message* message) {
  if (!message->is_serialized() ||
      mojo::internal::ControlMessageHandler::IsControlMessage(message)) {
    return true;
  }

  mojo::internal::ValidationContext validation_context(
    message->payload(), message->payload_num_bytes(),
    message->handles()->size(), message->payload_num_interface_ids(), message,
    "ProcessInternalsHandler ResponseValidator");

  if (!mojo::internal::ValidateMessageIsResponse(message, &validation_context))
    return false;
  switch (message->header()->name) {
    case internal::kProcessInternalsHandler_GetIsolationMode_Name: {
      if (!mojo::internal::ValidateMessagePayload<
               internal::ProcessInternalsHandler_GetIsolationMode_ResponseParams_Data>(
                    message, &validation_context)) {
        return false;
      }
      return true;
    }
    case internal::kProcessInternalsHandler_GetIsolatedOriginsSize_Name: {
      if (!mojo::internal::ValidateMessagePayload<
               internal::ProcessInternalsHandler_GetIsolatedOriginsSize_ResponseParams_Data>(
                    message, &validation_context)) {
        return false;
      }
      return true;
    }
    default:
      break;
  }

  // Unrecognized message.
  ReportValidationError(
      &validation_context,
      mojo::internal::VALIDATION_ERROR_MESSAGE_HEADER_UNKNOWN_METHOD);
  return false;
}
void ProcessInternalsHandlerInterceptorForTesting::GetIsolationMode(GetIsolationModeCallback callback) {
  GetForwardingInterface()->GetIsolationMode(std::move(callback));
}
void ProcessInternalsHandlerInterceptorForTesting::GetIsolatedOriginsSize(GetIsolatedOriginsSizeCallback callback) {
  GetForwardingInterface()->GetIsolatedOriginsSize(std::move(callback));
}
ProcessInternalsHandlerAsyncWaiter::ProcessInternalsHandlerAsyncWaiter(
    ProcessInternalsHandler* proxy) : proxy_(proxy) {}

ProcessInternalsHandlerAsyncWaiter::~ProcessInternalsHandlerAsyncWaiter() = default;

void ProcessInternalsHandlerAsyncWaiter::GetIsolationMode(
    std::string* out_mode) {
  base::RunLoop loop;
  proxy_->GetIsolationMode(
      base::BindOnce(
          [](base::RunLoop* loop,
             std::string* out_mode
,
             const std::string& mode) {*out_mode = std::move(mode);
            loop->Quit();
          },
          &loop,
          out_mode));
  loop.Run();
}
void ProcessInternalsHandlerAsyncWaiter::GetIsolatedOriginsSize(
    uint32_t* out_size) {
  base::RunLoop loop;
  proxy_->GetIsolatedOriginsSize(
      base::BindOnce(
          [](base::RunLoop* loop,
             uint32_t* out_size
,
             uint32_t size) {*out_size = std::move(size);
            loop->Quit();
          },
          &loop,
          out_size));
  loop.Run();
}

}  // namespace mojom

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#elif defined(_MSC_VER)
#pragma warning(pop)
#endif