# The PEP 484 type hints stub file for the phonon module.
#
# Generated by SIP 4.19.8
#
# Copyright (c) 2016 Riverbank Computing Limited <info@riverbankcomputing.com>
# 
# This file is part of PyQt4.
# 
# This file may be used under the terms of the GNU General Public License
# version 3.0 as published by the Free Software Foundation and appearing in
# the file LICENSE included in the packaging of this file.  Please review the
# following information to ensure the GNU General Public License version 3.0
# requirements will be met: http://www.gnu.org/copyleft/gpl.html.
# 
# If you do not wish to use this file under the terms of the GPL version 3.0
# then you may purchase a commercial license.  For more information contact
# info@riverbankcomputing.com.
# 
# This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
# WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.


import typing
import sip

from PyQt4 import QtGui
from PyQt4 import QtCore

# Support for QDate, QDateTime and QTime.
import datetime

# Convenient type aliases.
PYQT_SIGNAL = typing.Union[QtCore.pyqtSignal, QtCore.pyqtBoundSignal]
PYQT_SLOT = typing.Union[typing.Callable[..., None], QtCore.pyqtBoundSignal]

# Support for old-style signals and slots.
QT_SIGNAL = str
QT_SLOT = str


class Phonon(sip.simplewrapper):

    class ErrorType(int): ...
    NoError = ... # type: 'Phonon.ErrorType'
    NormalError = ... # type: 'Phonon.ErrorType'
    FatalError = ... # type: 'Phonon.ErrorType'

    class Category(int): ...
    NoCategory = ... # type: 'Phonon.Category'
    NotificationCategory = ... # type: 'Phonon.Category'
    MusicCategory = ... # type: 'Phonon.Category'
    VideoCategory = ... # type: 'Phonon.Category'
    CommunicationCategory = ... # type: 'Phonon.Category'
    GameCategory = ... # type: 'Phonon.Category'
    AccessibilityCategory = ... # type: 'Phonon.Category'

    class State(int): ...
    LoadingState = ... # type: 'Phonon.State'
    StoppedState = ... # type: 'Phonon.State'
    PlayingState = ... # type: 'Phonon.State'
    BufferingState = ... # type: 'Phonon.State'
    PausedState = ... # type: 'Phonon.State'
    ErrorState = ... # type: 'Phonon.State'

    class MetaData(int): ...
    ArtistMetaData = ... # type: 'Phonon.MetaData'
    AlbumMetaData = ... # type: 'Phonon.MetaData'
    TitleMetaData = ... # type: 'Phonon.MetaData'
    DateMetaData = ... # type: 'Phonon.MetaData'
    GenreMetaData = ... # type: 'Phonon.MetaData'
    TracknumberMetaData = ... # type: 'Phonon.MetaData'
    DescriptionMetaData = ... # type: 'Phonon.MetaData'
    MusicBrainzDiscIdMetaData = ... # type: 'Phonon.MetaData'

    class DiscType(int): ...
    NoDisc = ... # type: 'Phonon.DiscType'
    Cd = ... # type: 'Phonon.DiscType'
    Dvd = ... # type: 'Phonon.DiscType'
    Vcd = ... # type: 'Phonon.DiscType'

    class MediaNode(sip.simplewrapper):

        def outputPaths(self) -> typing.List['Phonon.Path']: ...
        def inputPaths(self) -> typing.Any: ...
        def isValid(self) -> bool: ...

    class AbstractAudioOutput(QtCore.QObject, 'Phonon.MediaNode'): ...

    class AbstractVideoOutput('Phonon.MediaNode'): ...

    class AudioOutput('Phonon.AbstractAudioOutput'):

        @typing.overload
        def __init__(self, category: 'Phonon.Category', parent: typing.Optional[QtCore.QObject] = ...) -> None: ...
        @typing.overload
        def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

        def outputDeviceChanged(self, newAudioOutputDevice: 'Phonon.AudioOutputDevice') -> None: ...
        def mutedChanged(self, a0: bool) -> None: ...
        def volumeChanged(self, newVolume: float) -> None: ...
        def setMuted(self, mute: bool) -> None: ...
        def setOutputDevice(self, newAudioOutputDevice: 'Phonon.AudioOutputDevice') -> bool: ...
        def setVolumeDecibel(self, newVolumeDecibel: float) -> None: ...
        def setVolume(self, newVolume: float) -> None: ...
        def setName(self, newName: str) -> None: ...
        def isMuted(self) -> bool: ...
        def outputDevice(self) -> 'Phonon.AudioOutputDevice': ...
        def category(self) -> 'Phonon.Category': ...
        def volumeDecibel(self) -> float: ...
        def volume(self) -> float: ...
        def name(self) -> str: ...

    class BackendCapabilities(sip.simplewrapper):

        class Notifier(QtCore.QObject):

            def availableAudioCaptureDevicesChanged(self) -> None: ...
            def availableAudioOutputDevicesChanged(self) -> None: ...
            def capabilitiesChanged(self) -> None: ...

        def availableAudioCaptureDevices(self) -> typing.Any: ...
        def availableAudioEffects(self) -> typing.Any: ...
        def availableAudioOutputDevices(self) -> typing.Any: ...
        def isMimeTypeAvailable(self, mimeType: str) -> bool: ...
        def availableMimeTypes(self) -> typing.List[str]: ...
        def notifier(self) -> 'Phonon.BackendCapabilities.Notifier': ...

    class Effect(QtCore.QObject, 'Phonon.MediaNode'):

        def __init__(self, description: 'Phonon.EffectDescription', parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

        def setParameterValue(self, a0: 'Phonon.EffectParameter', value: typing.Any) -> None: ...
        def parameterValue(self, a0: 'Phonon.EffectParameter') -> typing.Any: ...
        def parameters(self) -> typing.Any: ...
        def description(self) -> 'Phonon.EffectDescription': ...

    class EffectParameter(sip.simplewrapper):

        class Hint(int): ...
        ToggledHint = ... # type: 'Phonon.EffectParameter.Hint'
        LogarithmicHint = ... # type: 'Phonon.EffectParameter.Hint'
        IntegerHint = ... # type: 'Phonon.EffectParameter.Hint'

        class Hints(sip.simplewrapper):

            @typing.overload
            def __init__(self) -> None: ...
            @typing.overload
            def __init__(self, f: typing.Union['Phonon.EffectParameter.Hints', 'Phonon.EffectParameter.Hint']) -> None: ...
            @typing.overload
            def __init__(self, a0: 'Phonon.EffectParameter.Hints') -> None: ...

            def __bool__(self) -> int: ...
            def __invert__(self) -> 'Phonon.EffectParameter.Hints': ...
            def __int__(self) -> int: ...

        @typing.overload
        def __init__(self, parameterId: int, name: str, hints: 'Phonon.EffectParameter.Hints', defaultValue: typing.Any, min: typing.Any = ..., max: typing.Any = ..., values: typing.Any = ..., description: str = ...) -> None: ...
        @typing.overload
        def __init__(self, rhs: 'Phonon.EffectParameter') -> None: ...

        def __hash__(self) -> int: ...
        def possibleValues(self) -> typing.Any: ...
        def defaultValue(self) -> typing.Any: ...
        def maximumValue(self) -> typing.Any: ...
        def minimumValue(self) -> typing.Any: ...
        def isLogarithmicControl(self) -> bool: ...
        def type(self) -> QtCore.QVariant.Type: ...
        def description(self) -> str: ...
        def name(self) -> str: ...

    class EffectWidget(QtGui.QWidget):

        def __init__(self, effect: 'Phonon.Effect', parent: typing.Optional[QtGui.QWidget] = ...) -> None: ...

    class MediaController(QtCore.QObject):

        class Feature(int): ...
        Angles = ... # type: 'Phonon.MediaController.Feature'
        Chapters = ... # type: 'Phonon.MediaController.Feature'
        Titles = ... # type: 'Phonon.MediaController.Feature'

        class Features(sip.simplewrapper):

            @typing.overload
            def __init__(self) -> None: ...
            @typing.overload
            def __init__(self, f: typing.Union['Phonon.MediaController.Features', 'Phonon.MediaController.Feature']) -> None: ...
            @typing.overload
            def __init__(self, a0: 'Phonon.MediaController.Features') -> None: ...

            def __bool__(self) -> int: ...
            def __invert__(self) -> 'Phonon.MediaController.Features': ...
            def __int__(self) -> int: ...

        def __init__(self, parent: 'Phonon.MediaObject') -> None: ...

        def availableAudioChannelsChanged(self) -> None: ...
        def availableSubtitlesChanged(self) -> None: ...
        def setCurrentSubtitle(self, stream: 'Phonon.SubtitleDescription') -> None: ...
        def setCurrentAudioChannel(self, stream: 'Phonon.AudioChannelDescription') -> None: ...
        def availableSubtitles(self) -> typing.Any: ...
        def availableAudioChannels(self) -> typing.Any: ...
        def currentSubtitle(self) -> 'Phonon.SubtitleDescription': ...
        def currentAudioChannel(self) -> 'Phonon.AudioChannelDescription': ...
        def titleChanged(self, titleNumber: int) -> None: ...
        def availableTitlesChanged(self, availableTitles: int) -> None: ...
        def chapterChanged(self, chapterNumber: int) -> None: ...
        def availableChaptersChanged(self, availableChapters: int) -> None: ...
        def angleChanged(self, angleNumber: int) -> None: ...
        def availableAnglesChanged(self, availableAngles: int) -> None: ...
        def previousTitle(self) -> None: ...
        def nextTitle(self) -> None: ...
        def setAutoplayTitles(self, a0: bool) -> None: ...
        def setCurrentTitle(self, titleNumber: int) -> None: ...
        def setCurrentChapter(self, chapterNumber: int) -> None: ...
        def setCurrentAngle(self, angleNumber: int) -> None: ...
        def autoplayTitles(self) -> bool: ...
        def currentTitle(self) -> int: ...
        def availableTitles(self) -> int: ...
        def currentChapter(self) -> int: ...
        def availableChapters(self) -> int: ...
        def currentAngle(self) -> int: ...
        def availableAngles(self) -> int: ...
        def supportedFeatures(self) -> 'Phonon.MediaController.Features': ...

    class MediaObject(QtCore.QObject, 'Phonon.MediaNode'):

        def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

        def totalTimeChanged(self, newTotalTime: int) -> None: ...
        def prefinishMarkReached(self, msecToEnd: int) -> None: ...
        def aboutToFinish(self) -> None: ...
        def currentSourceChanged(self, newSource: 'Phonon.MediaSource') -> None: ...
        def finished(self) -> None: ...
        def bufferStatus(self, percentFilled: int) -> None: ...
        def hasVideoChanged(self, hasVideo: bool) -> None: ...
        def seekableChanged(self, isSeekable: bool) -> None: ...
        def metaDataChanged(self) -> None: ...
        def tick(self, time: int) -> None: ...
        def stateChanged(self, newstate: 'Phonon.State', oldstate: 'Phonon.State') -> None: ...
        def clear(self) -> None: ...
        def seek(self, time: int) -> None: ...
        def stop(self) -> None: ...
        def pause(self) -> None: ...
        def play(self) -> None: ...
        def setTickInterval(self, newTickInterval: int) -> None: ...
        def setTransitionTime(self, msec: int) -> None: ...
        def transitionTime(self) -> int: ...
        def setPrefinishMark(self, msecToEnd: int) -> None: ...
        def prefinishMark(self) -> int: ...
        def remainingTime(self) -> int: ...
        def totalTime(self) -> int: ...
        def currentTime(self) -> int: ...
        def clearQueue(self) -> None: ...
        @typing.overload
        def enqueue(self, source: 'Phonon.MediaSource') -> None: ...
        @typing.overload
        def enqueue(self, sources: typing.Sequence['Phonon.MediaSource']) -> None: ...
        @typing.overload
        def enqueue(self, urls: typing.Sequence[QtCore.QUrl]) -> None: ...
        @typing.overload
        def setQueue(self, sources: typing.Sequence['Phonon.MediaSource']) -> None: ...
        @typing.overload
        def setQueue(self, urls: typing.Sequence[QtCore.QUrl]) -> None: ...
        def queue(self) -> typing.Any: ...
        def setCurrentSource(self, source: 'Phonon.MediaSource') -> None: ...
        def currentSource(self) -> 'Phonon.MediaSource': ...
        def errorType(self) -> 'Phonon.ErrorType': ...
        def errorString(self) -> str: ...
        @typing.overload
        def metaData(self, key: str) -> typing.List[str]: ...
        @typing.overload
        def metaData(self, key: 'Phonon.MetaData') -> typing.List[str]: ...
        @typing.overload
        def metaData(self) -> typing.Any: ...
        def tickInterval(self) -> int: ...
        def isSeekable(self) -> bool: ...
        def hasVideo(self) -> bool: ...
        def state(self) -> 'Phonon.State': ...

    class MediaSource(sip.simplewrapper):

        class Type(int): ...
        Invalid = ... # type: 'Phonon.MediaSource.Type'
        LocalFile = ... # type: 'Phonon.MediaSource.Type'
        Url = ... # type: 'Phonon.MediaSource.Type'
        Disc = ... # type: 'Phonon.MediaSource.Type'
        Stream = ... # type: 'Phonon.MediaSource.Type'
        Empty = ... # type: 'Phonon.MediaSource.Type'

        @typing.overload
        def __init__(self, fileName: str) -> None: ...
        @typing.overload
        def __init__(self, url: QtCore.QUrl) -> None: ...
        @typing.overload
        def __init__(self, discType: 'Phonon.DiscType', deviceName: str = ...) -> None: ...
        @typing.overload
        def __init__(self, ioDevice: QtCore.QIODevice) -> None: ...
        @typing.overload
        def __init__(self, rhs: 'Phonon.MediaSource') -> None: ...

        def deviceName(self) -> str: ...
        def discType(self) -> 'Phonon.DiscType': ...
        def url(self) -> QtCore.QUrl: ...
        def fileName(self) -> str: ...
        def type(self) -> 'Phonon.MediaSource.Type': ...
        def autoDelete(self) -> bool: ...
        def setAutoDelete(self, enable: bool) -> None: ...

    class AudioOutputDevice(sip.simplewrapper):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, index: int, properties: typing.Any) -> None: ...
        @typing.overload
        def __init__(self, a0: 'Phonon.AudioOutputDevice') -> None: ...

        @staticmethod
        def fromIndex(index: int) -> 'Phonon.AudioOutputDevice': ...
        def propertyNames(self) -> typing.List[QtCore.QByteArray]: ...
        def property(self, name: str) -> typing.Any: ...
        def name(self) -> str: ...
        def isValid(self) -> bool: ...
        def index(self) -> int: ...
        def description(self) -> str: ...

    class EffectDescription(sip.simplewrapper):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, index: int, properties: typing.Dict[typing.Union[QtCore.QByteArray, bytes, bytearray], typing.Any]) -> None: ...
        @typing.overload
        def __init__(self, a0: 'Phonon.EffectDescription') -> None: ...

        @staticmethod
        def fromIndex(index: int) -> 'Phonon.EffectDescription': ...
        def propertyNames(self) -> typing.List[QtCore.QByteArray]: ...
        def property(self, name: str) -> typing.Any: ...
        def name(self) -> str: ...
        def isValid(self) -> bool: ...
        def index(self) -> int: ...
        def description(self) -> str: ...

    class SubtitleDescription(sip.simplewrapper):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, index: int, properties: typing.Dict[typing.Union[QtCore.QByteArray, bytes, bytearray], typing.Any]) -> None: ...
        @typing.overload
        def __init__(self, a0: 'Phonon.SubtitleDescription') -> None: ...

        @staticmethod
        def fromIndex(index: int) -> 'Phonon.SubtitleDescription': ...
        def propertyNames(self) -> typing.List[QtCore.QByteArray]: ...
        def property(self, name: str) -> typing.Any: ...
        def name(self) -> str: ...
        def isValid(self) -> bool: ...
        def index(self) -> int: ...
        def description(self) -> str: ...

    class AudioChannelDescription(sip.simplewrapper):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, index: int, properties: typing.Dict[typing.Union[QtCore.QByteArray, bytes, bytearray], typing.Any]) -> None: ...
        @typing.overload
        def __init__(self, a0: 'Phonon.AudioChannelDescription') -> None: ...

        @staticmethod
        def fromIndex(index: int) -> 'Phonon.AudioChannelDescription': ...
        def propertyNames(self) -> typing.List[QtCore.QByteArray]: ...
        def property(self, name: str) -> typing.Any: ...
        def name(self) -> str: ...
        def isValid(self) -> bool: ...
        def index(self) -> int: ...
        def description(self) -> str: ...

    class AudioCaptureDevice(sip.simplewrapper):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, index: int, properties: typing.Dict[typing.Union[QtCore.QByteArray, bytes, bytearray], typing.Any]) -> None: ...
        @typing.overload
        def __init__(self, a0: 'Phonon.AudioCaptureDevice') -> None: ...

        @staticmethod
        def fromIndex(index: int) -> 'Phonon.AudioCaptureDevice': ...
        def propertyNames(self) -> typing.List[QtCore.QByteArray]: ...
        def property(self, name: str) -> typing.Any: ...
        def name(self) -> str: ...
        def isValid(self) -> bool: ...
        def index(self) -> int: ...
        def description(self) -> str: ...

    class AudioOutputDeviceModel(QtCore.QAbstractListModel):

        @typing.overload
        def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...
        @typing.overload
        def __init__(self, data: typing.Sequence['Phonon.AudioOutputDevice'], parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

        def mimeTypes(self) -> typing.List[str]: ...
        def removeRows(self, row: int, count: int, parent: QtCore.QModelIndex = ...) -> bool: ...
        def dropMimeData(self, data: QtCore.QMimeData, action: QtCore.Qt.DropAction, row: int, column: int, parent: QtCore.QModelIndex) -> bool: ...
        def supportedDropActions(self) -> QtCore.Qt.DropActions: ...
        def mimeData(self, indexes: typing.Any) -> QtCore.QMimeData: ...
        def flags(self, index: QtCore.QModelIndex) -> QtCore.Qt.ItemFlags: ...
        def data(self, index: QtCore.QModelIndex, role: int = ...) -> typing.Any: ...
        def rowCount(self, parent: QtCore.QModelIndex = ...) -> int: ...
        @typing.overload
        def modelData(self) -> typing.List['Phonon.AudioOutputDevice']: ...
        @typing.overload
        def modelData(self, index: QtCore.QModelIndex) -> 'Phonon.AudioOutputDevice': ...
        def setModelData(self, data: typing.Sequence['Phonon.AudioOutputDevice']) -> None: ...
        def moveDown(self, index: QtCore.QModelIndex) -> None: ...
        def moveUp(self, index: QtCore.QModelIndex) -> None: ...
        def tupleIndexAtPositionIndex(self, positionIndex: int) -> int: ...
        def tupleIndexOrder(self) -> typing.List[int]: ...

    class EffectDescriptionModel(QtCore.QAbstractListModel):

        @typing.overload
        def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...
        @typing.overload
        def __init__(self, data: typing.Sequence['Phonon.EffectDescription'], parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

        def mimeTypes(self) -> typing.List[str]: ...
        def removeRows(self, row: int, count: int, parent: QtCore.QModelIndex = ...) -> bool: ...
        def dropMimeData(self, data: QtCore.QMimeData, action: QtCore.Qt.DropAction, row: int, column: int, parent: QtCore.QModelIndex) -> bool: ...
        def supportedDropActions(self) -> QtCore.Qt.DropActions: ...
        def mimeData(self, indexes: typing.Any) -> QtCore.QMimeData: ...
        def flags(self, index: QtCore.QModelIndex) -> QtCore.Qt.ItemFlags: ...
        def data(self, index: QtCore.QModelIndex, role: int = ...) -> typing.Any: ...
        def rowCount(self, parent: QtCore.QModelIndex = ...) -> int: ...
        @typing.overload
        def modelData(self) -> typing.List['Phonon.EffectDescription']: ...
        @typing.overload
        def modelData(self, index: QtCore.QModelIndex) -> 'Phonon.EffectDescription': ...
        def setModelData(self, data: typing.Sequence['Phonon.EffectDescription']) -> None: ...
        def moveDown(self, index: QtCore.QModelIndex) -> None: ...
        def moveUp(self, index: QtCore.QModelIndex) -> None: ...
        def tupleIndexAtPositionIndex(self, positionIndex: int) -> int: ...
        def tupleIndexOrder(self) -> typing.List[int]: ...

    class Path(sip.simplewrapper):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, a0: 'Phonon.Path') -> None: ...

        def sink(self) -> 'Phonon.MediaNode': ...
        def source(self) -> 'Phonon.MediaNode': ...
        def disconnect(self) -> bool: ...
        def reconnect(self, source: 'Phonon.MediaNode', sink: 'Phonon.MediaNode') -> bool: ...
        def effects(self) -> typing.Any: ...
        def removeEffect(self, effect: 'Phonon.Effect') -> bool: ...
        @typing.overload
        def insertEffect(self, desc: 'Phonon.EffectDescription', before: typing.Optional['Phonon.Effect'] = ...) -> 'Phonon.Effect': ...
        @typing.overload
        def insertEffect(self, newEffect: 'Phonon.Effect', before: typing.Optional['Phonon.Effect'] = ...) -> bool: ...
        def isValid(self) -> bool: ...

    class SeekSlider(QtGui.QWidget):

        @typing.overload
        def __init__(self, parent: typing.Optional[QtGui.QWidget] = ...) -> None: ...
        @typing.overload
        def __init__(self, media: 'Phonon.MediaObject', parent: typing.Optional[QtGui.QWidget] = ...) -> None: ...

        def setMediaObject(self, a0: 'Phonon.MediaObject') -> None: ...
        def setIconSize(self, size: QtCore.QSize) -> None: ...
        def setIconVisible(self, a0: bool) -> None: ...
        def setOrientation(self, a0: QtCore.Qt.Orientation) -> None: ...
        def mediaObject(self) -> 'Phonon.MediaObject': ...
        def iconSize(self) -> QtCore.QSize: ...
        def isIconVisible(self) -> bool: ...
        def orientation(self) -> QtCore.Qt.Orientation: ...
        def setSingleStep(self, milliseconds: int) -> None: ...
        def singleStep(self) -> int: ...
        def setPageStep(self, milliseconds: int) -> None: ...
        def pageStep(self) -> int: ...
        def setTracking(self, tracking: bool) -> None: ...
        def hasTracking(self) -> bool: ...

    class VideoPlayer(QtGui.QWidget):

        @typing.overload
        def __init__(self, category: 'Phonon.Category', parent: typing.Optional[QtGui.QWidget] = ...) -> None: ...
        @typing.overload
        def __init__(self, parent: typing.Optional[QtGui.QWidget] = ...) -> None: ...

        def finished(self) -> None: ...
        def videoWidget(self) -> 'Phonon.VideoWidget': ...
        def audioOutput(self) -> 'Phonon.AudioOutput': ...
        def mediaObject(self) -> 'Phonon.MediaObject': ...
        def setVolume(self, volume: float) -> None: ...
        def seek(self, ms: int) -> None: ...
        def stop(self) -> None: ...
        def pause(self) -> None: ...
        @typing.overload
        def play(self, source: 'Phonon.MediaSource') -> None: ...
        @typing.overload
        def play(self) -> None: ...
        def load(self, source: 'Phonon.MediaSource') -> None: ...
        def isPaused(self) -> bool: ...
        def isPlaying(self) -> bool: ...
        def volume(self) -> float: ...
        def currentTime(self) -> int: ...
        def totalTime(self) -> int: ...

    class VideoWidget(QtGui.QWidget, 'Phonon.AbstractVideoOutput'):

        class ScaleMode(int): ...
        FitInView = ... # type: 'Phonon.VideoWidget.ScaleMode'
        ScaleAndCrop = ... # type: 'Phonon.VideoWidget.ScaleMode'

        class AspectRatio(int): ...
        AspectRatioAuto = ... # type: 'Phonon.VideoWidget.AspectRatio'
        AspectRatioWidget = ... # type: 'Phonon.VideoWidget.AspectRatio'
        AspectRatio4_3 = ... # type: 'Phonon.VideoWidget.AspectRatio'
        AspectRatio16_9 = ... # type: 'Phonon.VideoWidget.AspectRatio'

        def __init__(self, parent: typing.Optional[QtGui.QWidget] = ...) -> None: ...

        def snapshot(self) -> QtGui.QImage: ...
        def event(self, a0: QtCore.QEvent) -> bool: ...
        def mouseMoveEvent(self, a0: QtGui.QMouseEvent) -> None: ...
        def setSaturation(self, value: float) -> None: ...
        def setHue(self, value: float) -> None: ...
        def setContrast(self, value: float) -> None: ...
        def setBrightness(self, value: float) -> None: ...
        def setScaleMode(self, a0: 'Phonon.VideoWidget.ScaleMode') -> None: ...
        def setAspectRatio(self, a0: 'Phonon.VideoWidget.AspectRatio') -> None: ...
        def enterFullScreen(self) -> None: ...
        def exitFullScreen(self) -> None: ...
        def setFullScreen(self, fullscreen: bool) -> None: ...
        def saturation(self) -> float: ...
        def hue(self) -> float: ...
        def contrast(self) -> float: ...
        def brightness(self) -> float: ...
        def scaleMode(self) -> 'Phonon.VideoWidget.ScaleMode': ...
        def aspectRatio(self) -> 'Phonon.VideoWidget.AspectRatio': ...

    class VolumeSlider(QtGui.QWidget):

        @typing.overload
        def __init__(self, parent: typing.Optional[QtGui.QWidget] = ...) -> None: ...
        @typing.overload
        def __init__(self, a0: 'Phonon.AudioOutput', parent: typing.Optional[QtGui.QWidget] = ...) -> None: ...

        def setAudioOutput(self, a0: 'Phonon.AudioOutput') -> None: ...
        def setIconSize(self, size: QtCore.QSize) -> None: ...
        def setMuteVisible(self, a0: bool) -> None: ...
        def setOrientation(self, a0: QtCore.Qt.Orientation) -> None: ...
        def setMaximumVolume(self, a0: float) -> None: ...
        def audioOutput(self) -> 'Phonon.AudioOutput': ...
        def orientation(self) -> QtCore.Qt.Orientation: ...
        def maximumVolume(self) -> float: ...
        def iconSize(self) -> QtCore.QSize: ...
        def isMuteVisible(self) -> bool: ...
        def setSingleStep(self, milliseconds: int) -> None: ...
        def singleStep(self) -> int: ...
        def setPageStep(self, milliseconds: int) -> None: ...
        def pageStep(self) -> int: ...
        def setTracking(self, tracking: bool) -> None: ...
        def hasTracking(self) -> bool: ...

    def phononVersion(self) -> str: ...
    def categoryToString(self, c: 'Phonon.Category') -> str: ...
    def createPath(self, source: 'Phonon.MediaNode', sink: 'Phonon.MediaNode') -> 'Phonon.Path': ...
    def createPlayer(self, category: 'Phonon.Category', source: 'Phonon.MediaSource' = ...) -> 'Phonon.MediaObject': ...
