# The PEP 484 type hints stub file for the QtNetwork module.
#
# Generated by SIP 4.19.8
#
# Copyright (c) 2016 Riverbank Computing Limited <info@riverbankcomputing.com>
# 
# This file is part of PyQt4.
# 
# This file may be used under the terms of the GNU General Public License
# version 3.0 as published by the Free Software Foundation and appearing in
# the file LICENSE included in the packaging of this file.  Please review the
# following information to ensure the GNU General Public License version 3.0
# requirements will be met: http://www.gnu.org/copyleft/gpl.html.
# 
# If you do not wish to use this file under the terms of the GPL version 3.0
# then you may purchase a commercial license.  For more information contact
# info@riverbankcomputing.com.
# 
# This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
# WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.


import typing
import sip

from PyQt4 import QtCore

# Support for QDate, QDateTime and QTime.
import datetime

# Convenient type aliases.
PYQT_SIGNAL = typing.Union[QtCore.pyqtSignal, QtCore.pyqtBoundSignal]
PYQT_SLOT = typing.Union[typing.Callable[..., None], QtCore.pyqtBoundSignal]

# Support for old-style signals and slots.
QT_SIGNAL = str
QT_SLOT = str


class QNetworkCacheMetaData(sip.simplewrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: 'QNetworkCacheMetaData') -> None: ...

    def setAttributes(self, attributes: typing.Dict['QNetworkRequest.Attribute', typing.Any]) -> None: ...
    def attributes(self) -> typing.Dict['QNetworkRequest.Attribute', typing.Any]: ...
    def setSaveToDisk(self, allow: bool) -> None: ...
    def saveToDisk(self) -> bool: ...
    def setExpirationDate(self, dateTime: typing.Union[QtCore.QDateTime, datetime.datetime]) -> None: ...
    def expirationDate(self) -> QtCore.QDateTime: ...
    def setLastModified(self, dateTime: typing.Union[QtCore.QDateTime, datetime.datetime]) -> None: ...
    def lastModified(self) -> QtCore.QDateTime: ...
    def setRawHeaders(self, headers: typing.Sequence[typing.Tuple[typing.Union[QtCore.QByteArray, bytes, bytearray], typing.Union[QtCore.QByteArray, bytes, bytearray]]]) -> None: ...
    def rawHeaders(self) -> typing.List[typing.Tuple[QtCore.QByteArray, QtCore.QByteArray]]: ...
    def setUrl(self, url: QtCore.QUrl) -> None: ...
    def url(self) -> QtCore.QUrl: ...
    def isValid(self) -> bool: ...


class QAbstractNetworkCache(QtCore.QObject):

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

    def clear(self) -> None: ...
    def insert(self, device: QtCore.QIODevice) -> None: ...
    def prepare(self, metaData: QNetworkCacheMetaData) -> QtCore.QIODevice: ...
    def cacheSize(self) -> int: ...
    def remove(self, url: QtCore.QUrl) -> bool: ...
    def data(self, url: QtCore.QUrl) -> QtCore.QIODevice: ...
    def updateMetaData(self, metaData: QNetworkCacheMetaData) -> None: ...
    def metaData(self, url: QtCore.QUrl) -> QNetworkCacheMetaData: ...


class QAbstractSocket(QtCore.QIODevice):

    class SocketOption(int): ...
    LowDelayOption = ... # type: 'QAbstractSocket.SocketOption'
    KeepAliveOption = ... # type: 'QAbstractSocket.SocketOption'
    MulticastTtlOption = ... # type: 'QAbstractSocket.SocketOption'
    MulticastLoopbackOption = ... # type: 'QAbstractSocket.SocketOption'

    class SocketState(int): ...
    UnconnectedState = ... # type: 'QAbstractSocket.SocketState'
    HostLookupState = ... # type: 'QAbstractSocket.SocketState'
    ConnectingState = ... # type: 'QAbstractSocket.SocketState'
    ConnectedState = ... # type: 'QAbstractSocket.SocketState'
    BoundState = ... # type: 'QAbstractSocket.SocketState'
    ListeningState = ... # type: 'QAbstractSocket.SocketState'
    ClosingState = ... # type: 'QAbstractSocket.SocketState'

    class SocketError(int): ...
    ConnectionRefusedError = ... # type: 'QAbstractSocket.SocketError'
    RemoteHostClosedError = ... # type: 'QAbstractSocket.SocketError'
    HostNotFoundError = ... # type: 'QAbstractSocket.SocketError'
    SocketAccessError = ... # type: 'QAbstractSocket.SocketError'
    SocketResourceError = ... # type: 'QAbstractSocket.SocketError'
    SocketTimeoutError = ... # type: 'QAbstractSocket.SocketError'
    DatagramTooLargeError = ... # type: 'QAbstractSocket.SocketError'
    NetworkError = ... # type: 'QAbstractSocket.SocketError'
    AddressInUseError = ... # type: 'QAbstractSocket.SocketError'
    SocketAddressNotAvailableError = ... # type: 'QAbstractSocket.SocketError'
    UnsupportedSocketOperationError = ... # type: 'QAbstractSocket.SocketError'
    UnfinishedSocketOperationError = ... # type: 'QAbstractSocket.SocketError'
    ProxyAuthenticationRequiredError = ... # type: 'QAbstractSocket.SocketError'
    SslHandshakeFailedError = ... # type: 'QAbstractSocket.SocketError'
    ProxyConnectionRefusedError = ... # type: 'QAbstractSocket.SocketError'
    ProxyConnectionClosedError = ... # type: 'QAbstractSocket.SocketError'
    ProxyConnectionTimeoutError = ... # type: 'QAbstractSocket.SocketError'
    ProxyNotFoundError = ... # type: 'QAbstractSocket.SocketError'
    ProxyProtocolError = ... # type: 'QAbstractSocket.SocketError'
    UnknownSocketError = ... # type: 'QAbstractSocket.SocketError'

    class NetworkLayerProtocol(int): ...
    IPv4Protocol = ... # type: 'QAbstractSocket.NetworkLayerProtocol'
    IPv6Protocol = ... # type: 'QAbstractSocket.NetworkLayerProtocol'
    UnknownNetworkLayerProtocol = ... # type: 'QAbstractSocket.NetworkLayerProtocol'

    class SocketType(int): ...
    TcpSocket = ... # type: 'QAbstractSocket.SocketType'
    UdpSocket = ... # type: 'QAbstractSocket.SocketType'
    UnknownSocketType = ... # type: 'QAbstractSocket.SocketType'

    def __init__(self, socketType: 'QAbstractSocket.SocketType', parent: QtCore.QObject) -> None: ...

    def socketOption(self, option: 'QAbstractSocket.SocketOption') -> typing.Any: ...
    def setSocketOption(self, option: 'QAbstractSocket.SocketOption', value: typing.Any) -> None: ...
    def setPeerName(self, name: str) -> None: ...
    def setPeerAddress(self, address: typing.Union['QHostAddress', 'QHostAddress.SpecialAddress']) -> None: ...
    def setPeerPort(self, port: int) -> None: ...
    def setLocalAddress(self, address: typing.Union['QHostAddress', 'QHostAddress.SpecialAddress']) -> None: ...
    def setLocalPort(self, port: int) -> None: ...
    def setSocketError(self, socketError: 'QAbstractSocket.SocketError') -> None: ...
    def setSocketState(self, state: 'QAbstractSocket.SocketState') -> None: ...
    def writeData(self, data: bytes) -> int: ...
    def readLineData(self, maxlen: int) -> bytes: ...
    def readData(self, maxlen: int) -> bytes: ...
    def disconnectFromHostImplementation(self) -> None: ...
    def connectToHostImplementation(self, hostName: str, port: int, mode: QtCore.QIODevice.OpenMode = ...) -> None: ...
    def proxyAuthenticationRequired(self, proxy: 'QNetworkProxy', authenticator: 'QAuthenticator') -> None: ...
    def stateChanged(self, a0: 'QAbstractSocket.SocketState') -> None: ...
    def disconnected(self) -> None: ...
    def connected(self) -> None: ...
    def hostFound(self) -> None: ...
    def proxy(self) -> 'QNetworkProxy': ...
    def setProxy(self, networkProxy: 'QNetworkProxy') -> None: ...
    def waitForDisconnected(self, msecs: int = ...) -> bool: ...
    def waitForBytesWritten(self, msecs: int = ...) -> bool: ...
    def waitForReadyRead(self, msecs: int = ...) -> bool: ...
    def waitForConnected(self, msecs: int = ...) -> bool: ...
    def flush(self) -> bool: ...
    def atEnd(self) -> bool: ...
    def isSequential(self) -> bool: ...
    def close(self) -> None: ...
    @typing.overload
    def error(self) -> 'QAbstractSocket.SocketError': ...
    @typing.overload
    def error(self, a0: 'QAbstractSocket.SocketError') -> None: ...
    def state(self) -> 'QAbstractSocket.SocketState': ...
    def socketType(self) -> 'QAbstractSocket.SocketType': ...
    def setSocketDescriptor(self, socketDescriptor: int, state: 'QAbstractSocket.SocketState' = ..., mode: typing.Union[QtCore.QIODevice.OpenMode, QtCore.QIODevice.OpenModeFlag] = ...) -> bool: ...
    def socketDescriptor(self) -> int: ...
    def abort(self) -> None: ...
    def setReadBufferSize(self, size: int) -> None: ...
    def readBufferSize(self) -> int: ...
    def peerName(self) -> str: ...
    def peerAddress(self) -> 'QHostAddress': ...
    def peerPort(self) -> int: ...
    def localAddress(self) -> 'QHostAddress': ...
    def localPort(self) -> int: ...
    def canReadLine(self) -> bool: ...
    def bytesToWrite(self) -> int: ...
    def bytesAvailable(self) -> int: ...
    def isValid(self) -> bool: ...
    def disconnectFromHost(self) -> None: ...
    @typing.overload
    def connectToHost(self, hostName: str, port: int, mode: QtCore.QIODevice.OpenMode = ...) -> None: ...
    @typing.overload
    def connectToHost(self, address: typing.Union['QHostAddress', 'QHostAddress.SpecialAddress'], port: int, mode: QtCore.QIODevice.OpenMode = ...) -> None: ...


class QAuthenticator(sip.simplewrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: 'QAuthenticator') -> None: ...

    def setOption(self, opt: str, value: typing.Any) -> None: ...
    def options(self) -> typing.Any: ...
    def option(self, opt: str) -> typing.Any: ...
    def isNull(self) -> bool: ...
    def realm(self) -> str: ...
    def setPassword(self, password: str) -> None: ...
    def password(self) -> str: ...
    def setUser(self, user: str) -> None: ...
    def user(self) -> str: ...


class QFtp(QtCore.QObject):

    class TransferType(int): ...
    Binary = ... # type: 'QFtp.TransferType'
    Ascii = ... # type: 'QFtp.TransferType'

    class TransferMode(int): ...
    Active = ... # type: 'QFtp.TransferMode'
    Passive = ... # type: 'QFtp.TransferMode'

    class Command(int): ...
    None_ = ... # type: 'QFtp.Command'
    SetTransferMode = ... # type: 'QFtp.Command'
    SetProxy = ... # type: 'QFtp.Command'
    ConnectToHost = ... # type: 'QFtp.Command'
    Login = ... # type: 'QFtp.Command'
    Close = ... # type: 'QFtp.Command'
    List = ... # type: 'QFtp.Command'
    Cd = ... # type: 'QFtp.Command'
    Get = ... # type: 'QFtp.Command'
    Put = ... # type: 'QFtp.Command'
    Remove = ... # type: 'QFtp.Command'
    Mkdir = ... # type: 'QFtp.Command'
    Rmdir = ... # type: 'QFtp.Command'
    Rename = ... # type: 'QFtp.Command'
    RawCommand = ... # type: 'QFtp.Command'

    class Error(int): ...
    NoError = ... # type: 'QFtp.Error'
    UnknownError = ... # type: 'QFtp.Error'
    HostNotFound = ... # type: 'QFtp.Error'
    ConnectionRefused = ... # type: 'QFtp.Error'
    NotConnected = ... # type: 'QFtp.Error'

    class State(int): ...
    Unconnected = ... # type: 'QFtp.State'
    HostLookup = ... # type: 'QFtp.State'
    Connecting = ... # type: 'QFtp.State'
    Connected = ... # type: 'QFtp.State'
    LoggedIn = ... # type: 'QFtp.State'
    Closing = ... # type: 'QFtp.State'

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

    def done(self, a0: bool) -> None: ...
    def commandFinished(self, a0: int, a1: bool) -> None: ...
    def commandStarted(self, a0: int) -> None: ...
    def rawCommandReply(self, a0: int, a1: str) -> None: ...
    def dataTransferProgress(self, a0: int, a1: int) -> None: ...
    def readyRead(self) -> None: ...
    def listInfo(self, a0: 'QUrlInfo') -> None: ...
    def stateChanged(self, a0: int) -> None: ...
    def abort(self) -> None: ...
    def errorString(self) -> str: ...
    def error(self) -> 'QFtp.Error': ...
    def state(self) -> 'QFtp.State': ...
    def clearPendingCommands(self) -> None: ...
    def hasPendingCommands(self) -> bool: ...
    def currentCommand(self) -> 'QFtp.Command': ...
    def currentDevice(self) -> QtCore.QIODevice: ...
    def currentId(self) -> int: ...
    def readAll(self) -> QtCore.QByteArray: ...
    def read(self, maxlen: int) -> bytes: ...
    def bytesAvailable(self) -> int: ...
    def rawCommand(self, command: str) -> int: ...
    def rename(self, oldname: str, newname: str) -> int: ...
    def rmdir(self, dir: str) -> int: ...
    def mkdir(self, dir: str) -> int: ...
    def remove(self, file: str) -> int: ...
    @typing.overload
    def put(self, data: typing.Union[QtCore.QByteArray, bytes, bytearray], file: str, type: 'QFtp.TransferType' = ...) -> int: ...
    @typing.overload
    def put(self, device: QtCore.QIODevice, file: str, type: 'QFtp.TransferType' = ...) -> int: ...
    def get(self, file: str, device: typing.Optional[QtCore.QIODevice] = ..., type: 'QFtp.TransferType' = ...) -> int: ...
    def cd(self, directory: str) -> int: ...
    def list(self, directory: str = ...) -> int: ...
    def setTransferMode(self, mode: 'QFtp.TransferMode') -> int: ...
    def close(self) -> int: ...
    def login(self, user: str = ..., password: str = ...) -> int: ...
    def connectToHost(self, host: str, port: int = ...) -> int: ...
    def setProxy(self, host: str, port: int) -> int: ...


class QHostAddress(sip.simplewrapper):

    class SpecialAddress(int): ...
    Null = ... # type: 'QHostAddress.SpecialAddress'
    Broadcast = ... # type: 'QHostAddress.SpecialAddress'
    LocalHost = ... # type: 'QHostAddress.SpecialAddress'
    LocalHostIPv6 = ... # type: 'QHostAddress.SpecialAddress'
    AnyIPv6 = ... # type: 'QHostAddress.SpecialAddress'
    Any = ... # type: 'QHostAddress.SpecialAddress'

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, address: 'QHostAddress.SpecialAddress') -> None: ...
    @typing.overload
    def __init__(self, ip4Addr: int) -> None: ...
    @typing.overload
    def __init__(self, address: str) -> None: ...
    @typing.overload
    def __init__(self, ip6Addr: typing.Tuple[int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int]) -> None: ...
    @typing.overload
    def __init__(self, copy: typing.Union['QHostAddress', 'QHostAddress.SpecialAddress']) -> None: ...

    @staticmethod
    def parseSubnet(subnet: str) -> typing.Tuple['QHostAddress', int]: ...
    @typing.overload
    def isInSubnet(self, subnet: typing.Union['QHostAddress', 'QHostAddress.SpecialAddress'], netmask: int) -> bool: ...
    @typing.overload
    def isInSubnet(self, subnet: typing.Any) -> bool: ...
    def __hash__(self) -> int: ...
    def clear(self) -> None: ...
    def isNull(self) -> bool: ...
    def setScopeId(self, id: str) -> None: ...
    def scopeId(self) -> str: ...
    def toString(self) -> str: ...
    def toIPv6Address(self) -> typing.Tuple[int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int]: ...
    def toIPv4Address(self) -> int: ...
    def protocol(self) -> QAbstractSocket.NetworkLayerProtocol: ...
    @typing.overload
    def setAddress(self, ip4Addr: int) -> None: ...
    @typing.overload
    def setAddress(self, address: str) -> bool: ...
    @typing.overload
    def setAddress(self, ip6Addr: typing.Tuple[int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int]) -> None: ...


class QHostInfo(sip.simplewrapper):

    class HostInfoError(int): ...
    NoError = ... # type: 'QHostInfo.HostInfoError'
    HostNotFound = ... # type: 'QHostInfo.HostInfoError'
    UnknownError = ... # type: 'QHostInfo.HostInfoError'

    @typing.overload
    def __init__(self, id: int = ...) -> None: ...
    @typing.overload
    def __init__(self, d: 'QHostInfo') -> None: ...

    @staticmethod
    def localDomainName() -> str: ...
    @staticmethod
    def localHostName() -> str: ...
    @staticmethod
    def fromName(name: str) -> 'QHostInfo': ...
    @staticmethod
    def abortHostLookup(lookupId: int) -> None: ...
    @typing.overload
    @staticmethod
    def lookupHost(name: str, receiver: QtCore.QObject, member: QT_SLOT) -> int: ...
    @typing.overload
    @staticmethod
    def lookupHost(name: str, slot: PYQT_SLOT) -> int: ...
    def lookupId(self) -> int: ...
    def setLookupId(self, id: int) -> None: ...
    def setErrorString(self, errorString: str) -> None: ...
    def errorString(self) -> str: ...
    def setError(self, error: 'QHostInfo.HostInfoError') -> None: ...
    def error(self) -> 'QHostInfo.HostInfoError': ...
    def setAddresses(self, addresses: typing.Sequence[typing.Union[QHostAddress, QHostAddress.SpecialAddress]]) -> None: ...
    def addresses(self) -> typing.Any: ...
    def setHostName(self, name: str) -> None: ...
    def hostName(self) -> str: ...


class QHttpHeader(sip.simplewrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, header: 'QHttpHeader') -> None: ...
    @typing.overload
    def __init__(self, str: str) -> None: ...

    def setValid(self, a0: bool) -> None: ...
    def parse(self, str: str) -> bool: ...
    def parseLine(self, line: str, number: int) -> bool: ...
    def minorVersion(self) -> int: ...
    def majorVersion(self) -> int: ...
    def isValid(self) -> bool: ...
    def toString(self) -> str: ...
    def setContentType(self, type: str) -> None: ...
    def contentType(self) -> str: ...
    def hasContentType(self) -> bool: ...
    def setContentLength(self, len: int) -> None: ...
    def contentLength(self) -> int: ...
    def hasContentLength(self) -> bool: ...
    def removeAllValues(self, key: str) -> None: ...
    def removeValue(self, key: str) -> None: ...
    def allValues(self, key: str) -> typing.List[str]: ...
    def value(self, key: str) -> str: ...
    def keys(self) -> typing.List[str]: ...
    def hasKey(self, key: str) -> bool: ...
    def values(self) -> typing.List[typing.Tuple[str, str]]: ...
    def addValue(self, key: str, value: str) -> None: ...
    def setValues(self, values: typing.Sequence[typing.Tuple[str, str]]) -> None: ...
    def setValue(self, key: str, value: str) -> None: ...


class QHttpResponseHeader(QHttpHeader):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, header: 'QHttpResponseHeader') -> None: ...
    @typing.overload
    def __init__(self, str: str) -> None: ...
    @typing.overload
    def __init__(self, code: int, text: str = ..., major: int = ..., minor: int = ...) -> None: ...

    def parseLine(self, line: str, number: int) -> bool: ...
    def toString(self) -> str: ...
    def minorVersion(self) -> int: ...
    def majorVersion(self) -> int: ...
    def reasonPhrase(self) -> str: ...
    def statusCode(self) -> int: ...
    def setStatusLine(self, code: int, text: str = ..., major: int = ..., minor: int = ...) -> None: ...


class QHttpRequestHeader(QHttpHeader):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, method: str, path: str, major: int = ..., minor: int = ...) -> None: ...
    @typing.overload
    def __init__(self, header: 'QHttpRequestHeader') -> None: ...
    @typing.overload
    def __init__(self, str: str) -> None: ...

    def parseLine(self, line: str, number: int) -> bool: ...
    def toString(self) -> str: ...
    def minorVersion(self) -> int: ...
    def majorVersion(self) -> int: ...
    def path(self) -> str: ...
    def method(self) -> str: ...
    def setRequest(self, method: str, path: str, major: int = ..., minor: int = ...) -> None: ...


class QHttp(QtCore.QObject):

    class Error(int): ...
    NoError = ... # type: 'QHttp.Error'
    UnknownError = ... # type: 'QHttp.Error'
    HostNotFound = ... # type: 'QHttp.Error'
    ConnectionRefused = ... # type: 'QHttp.Error'
    UnexpectedClose = ... # type: 'QHttp.Error'
    InvalidResponseHeader = ... # type: 'QHttp.Error'
    WrongContentLength = ... # type: 'QHttp.Error'
    Aborted = ... # type: 'QHttp.Error'
    AuthenticationRequiredError = ... # type: 'QHttp.Error'
    ProxyAuthenticationRequiredError = ... # type: 'QHttp.Error'

    class State(int): ...
    Unconnected = ... # type: 'QHttp.State'
    HostLookup = ... # type: 'QHttp.State'
    Connecting = ... # type: 'QHttp.State'
    Sending = ... # type: 'QHttp.State'
    Reading = ... # type: 'QHttp.State'
    Connected = ... # type: 'QHttp.State'
    Closing = ... # type: 'QHttp.State'

    class ConnectionMode(int): ...
    ConnectionModeHttp = ... # type: 'QHttp.ConnectionMode'
    ConnectionModeHttps = ... # type: 'QHttp.ConnectionMode'

    @typing.overload
    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...
    @typing.overload
    def __init__(self, hostName: str, port: int = ..., parent: typing.Optional[QtCore.QObject] = ...) -> None: ...
    @typing.overload
    def __init__(self, hostname: str, mode: 'QHttp.ConnectionMode', port: int = ..., parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

    def sslErrors(self, errors: typing.Any) -> None: ...
    def authenticationRequired(self, hostname: str, port: int, a2: QAuthenticator) -> None: ...
    def proxyAuthenticationRequired(self, proxy: 'QNetworkProxy', a1: QAuthenticator) -> None: ...
    def done(self, a0: bool) -> None: ...
    def requestFinished(self, a0: int, a1: bool) -> None: ...
    def requestStarted(self, a0: int) -> None: ...
    def dataReadProgress(self, a0: int, a1: int) -> None: ...
    def dataSendProgress(self, a0: int, a1: int) -> None: ...
    def readyRead(self, resp: QHttpResponseHeader) -> None: ...
    def responseHeaderReceived(self, resp: QHttpResponseHeader) -> None: ...
    def stateChanged(self, a0: int) -> None: ...
    def ignoreSslErrors(self) -> None: ...
    def abort(self) -> None: ...
    def errorString(self) -> str: ...
    def error(self) -> 'QHttp.Error': ...
    def state(self) -> 'QHttp.State': ...
    def clearPendingRequests(self) -> None: ...
    def hasPendingRequests(self) -> bool: ...
    def lastResponse(self) -> QHttpResponseHeader: ...
    def currentRequest(self) -> QHttpRequestHeader: ...
    def currentDestinationDevice(self) -> QtCore.QIODevice: ...
    def currentSourceDevice(self) -> QtCore.QIODevice: ...
    def currentId(self) -> int: ...
    def readAll(self) -> QtCore.QByteArray: ...
    def read(self, maxlen: int) -> bytes: ...
    def bytesAvailable(self) -> int: ...
    def close(self) -> int: ...
    @typing.overload
    def request(self, header: QHttpRequestHeader, data: typing.Optional[QtCore.QIODevice] = ..., to: typing.Optional[QtCore.QIODevice] = ...) -> int: ...
    @typing.overload
    def request(self, header: QHttpRequestHeader, data: typing.Union[QtCore.QByteArray, bytes, bytearray], to: typing.Optional[QtCore.QIODevice] = ...) -> int: ...
    def head(self, path: str) -> int: ...
    @typing.overload
    def post(self, path: str, data: QtCore.QIODevice, to: typing.Optional[QtCore.QIODevice] = ...) -> int: ...
    @typing.overload
    def post(self, path: str, data: typing.Union[QtCore.QByteArray, bytes, bytearray], to: typing.Optional[QtCore.QIODevice] = ...) -> int: ...
    def get(self, path: str, to: typing.Optional[QtCore.QIODevice] = ...) -> int: ...
    @typing.overload
    def setProxy(self, host: str, port: int, user: str = ..., password: str = ...) -> int: ...
    @typing.overload
    def setProxy(self, proxy: 'QNetworkProxy') -> int: ...
    def setUser(self, userName: str, password: str = ...) -> int: ...
    def setSocket(self, socket: 'QTcpSocket') -> int: ...
    @typing.overload
    def setHost(self, hostName: str, port: int = ...) -> int: ...
    @typing.overload
    def setHost(self, hostname: str, mode: 'QHttp.ConnectionMode', port: int = ...) -> int: ...


class QHttpPart(sip.simplewrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: 'QHttpPart') -> None: ...

    def setBodyDevice(self, device: QtCore.QIODevice) -> None: ...
    def setBody(self, body: typing.Union[QtCore.QByteArray, bytes, bytearray]) -> None: ...
    def setRawHeader(self, headerName: typing.Union[QtCore.QByteArray, bytes, bytearray], headerValue: typing.Union[QtCore.QByteArray, bytes, bytearray]) -> None: ...
    def setHeader(self, header: 'QNetworkRequest.KnownHeaders', value: typing.Any) -> None: ...


class QHttpMultiPart(QtCore.QObject):

    class ContentType(int): ...
    MixedType = ... # type: 'QHttpMultiPart.ContentType'
    RelatedType = ... # type: 'QHttpMultiPart.ContentType'
    FormDataType = ... # type: 'QHttpMultiPart.ContentType'
    AlternativeType = ... # type: 'QHttpMultiPart.ContentType'

    @typing.overload
    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...
    @typing.overload
    def __init__(self, contentType: 'QHttpMultiPart.ContentType', parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

    def setBoundary(self, boundary: typing.Union[QtCore.QByteArray, bytes, bytearray]) -> None: ...
    def boundary(self) -> QtCore.QByteArray: ...
    def setContentType(self, contentType: 'QHttpMultiPart.ContentType') -> None: ...
    def append(self, httpPart: QHttpPart) -> None: ...


class QLocalServer(QtCore.QObject):

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

    def incomingConnection(self, socketDescriptor: sip.voidptr) -> None: ...
    def newConnection(self) -> None: ...
    @staticmethod
    def removeServer(name: str) -> bool: ...
    def waitForNewConnection(self, msecs: int = ...) -> typing.Tuple[bool, bool]: ...
    def setMaxPendingConnections(self, numConnections: int) -> None: ...
    def serverError(self) -> QAbstractSocket.SocketError: ...
    def fullServerName(self) -> str: ...
    def serverName(self) -> str: ...
    def nextPendingConnection(self) -> 'QLocalSocket': ...
    def maxPendingConnections(self) -> int: ...
    def listen(self, name: str) -> bool: ...
    def isListening(self) -> bool: ...
    def hasPendingConnections(self) -> bool: ...
    def errorString(self) -> str: ...
    def close(self) -> None: ...


class QLocalSocket(QtCore.QIODevice):

    class LocalSocketState(int): ...
    UnconnectedState = ... # type: 'QLocalSocket.LocalSocketState'
    ConnectingState = ... # type: 'QLocalSocket.LocalSocketState'
    ConnectedState = ... # type: 'QLocalSocket.LocalSocketState'
    ClosingState = ... # type: 'QLocalSocket.LocalSocketState'

    class LocalSocketError(int): ...
    ConnectionRefusedError = ... # type: 'QLocalSocket.LocalSocketError'
    PeerClosedError = ... # type: 'QLocalSocket.LocalSocketError'
    ServerNotFoundError = ... # type: 'QLocalSocket.LocalSocketError'
    SocketAccessError = ... # type: 'QLocalSocket.LocalSocketError'
    SocketResourceError = ... # type: 'QLocalSocket.LocalSocketError'
    SocketTimeoutError = ... # type: 'QLocalSocket.LocalSocketError'
    DatagramTooLargeError = ... # type: 'QLocalSocket.LocalSocketError'
    ConnectionError = ... # type: 'QLocalSocket.LocalSocketError'
    UnsupportedSocketOperationError = ... # type: 'QLocalSocket.LocalSocketError'
    UnknownSocketError = ... # type: 'QLocalSocket.LocalSocketError'

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

    def writeData(self, a0: bytes) -> int: ...
    def readData(self, maxlen: int) -> bytes: ...
    def stateChanged(self, socketState: 'QLocalSocket.LocalSocketState') -> None: ...
    def disconnected(self) -> None: ...
    def connected(self) -> None: ...
    def waitForReadyRead(self, msecs: int = ...) -> bool: ...
    def waitForDisconnected(self, msecs: int = ...) -> bool: ...
    def waitForConnected(self, msecs: int = ...) -> bool: ...
    def waitForBytesWritten(self, msecs: int = ...) -> bool: ...
    def state(self) -> 'QLocalSocket.LocalSocketState': ...
    def socketDescriptor(self) -> sip.voidptr: ...
    def setSocketDescriptor(self, socketDescriptor: sip.voidptr, state: 'QLocalSocket.LocalSocketState' = ..., mode: typing.Union[QtCore.QIODevice.OpenMode, QtCore.QIODevice.OpenModeFlag] = ...) -> bool: ...
    def setReadBufferSize(self, size: int) -> None: ...
    def readBufferSize(self) -> int: ...
    def isValid(self) -> bool: ...
    def flush(self) -> bool: ...
    @typing.overload
    def error(self) -> 'QLocalSocket.LocalSocketError': ...
    @typing.overload
    def error(self, socketError: 'QLocalSocket.LocalSocketError') -> None: ...
    def close(self) -> None: ...
    def canReadLine(self) -> bool: ...
    def bytesToWrite(self) -> int: ...
    def bytesAvailable(self) -> int: ...
    def isSequential(self) -> bool: ...
    def abort(self) -> None: ...
    def fullServerName(self) -> str: ...
    def serverName(self) -> str: ...
    def disconnectFromServer(self) -> None: ...
    def connectToServer(self, name: str, mode: typing.Union[QtCore.QIODevice.OpenMode, QtCore.QIODevice.OpenModeFlag] = ...) -> None: ...


class QNetworkAccessManager(QtCore.QObject):

    class NetworkAccessibility(int): ...
    UnknownAccessibility = ... # type: 'QNetworkAccessManager.NetworkAccessibility'
    NotAccessible = ... # type: 'QNetworkAccessManager.NetworkAccessibility'
    Accessible = ... # type: 'QNetworkAccessManager.NetworkAccessibility'

    class Operation(int): ...
    HeadOperation = ... # type: 'QNetworkAccessManager.Operation'
    GetOperation = ... # type: 'QNetworkAccessManager.Operation'
    PutOperation = ... # type: 'QNetworkAccessManager.Operation'
    PostOperation = ... # type: 'QNetworkAccessManager.Operation'
    DeleteOperation = ... # type: 'QNetworkAccessManager.Operation'
    CustomOperation = ... # type: 'QNetworkAccessManager.Operation'

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

    def networkAccessible(self) -> 'QNetworkAccessManager.NetworkAccessibility': ...
    def setNetworkAccessible(self, accessible: 'QNetworkAccessManager.NetworkAccessibility') -> None: ...
    def activeConfiguration(self) -> 'QNetworkConfiguration': ...
    def configuration(self) -> 'QNetworkConfiguration': ...
    def setConfiguration(self, config: 'QNetworkConfiguration') -> None: ...
    def sendCustomRequest(self, request: 'QNetworkRequest', verb: typing.Union[QtCore.QByteArray, bytes, bytearray], data: typing.Optional[QtCore.QIODevice] = ...) -> 'QNetworkReply': ...
    def deleteResource(self, request: 'QNetworkRequest') -> 'QNetworkReply': ...
    def setCache(self, cache: QAbstractNetworkCache) -> None: ...
    def cache(self) -> QAbstractNetworkCache: ...
    def setProxyFactory(self, factory: 'QNetworkProxyFactory') -> None: ...
    def proxyFactory(self) -> 'QNetworkProxyFactory': ...
    def createRequest(self, op: 'QNetworkAccessManager.Operation', request: 'QNetworkRequest', device: typing.Optional[QtCore.QIODevice] = ...) -> 'QNetworkReply': ...
    def networkAccessibleChanged(self, accessible: 'QNetworkAccessManager.NetworkAccessibility') -> None: ...
    def sslErrors(self, reply: 'QNetworkReply', errors: typing.Sequence['QSslError']) -> None: ...
    def finished(self, reply: 'QNetworkReply') -> None: ...
    def authenticationRequired(self, reply: 'QNetworkReply', authenticator: QAuthenticator) -> None: ...
    def proxyAuthenticationRequired(self, proxy: 'QNetworkProxy', authenticator: QAuthenticator) -> None: ...
    @typing.overload
    def put(self, request: 'QNetworkRequest', data: QtCore.QIODevice) -> 'QNetworkReply': ...
    @typing.overload
    def put(self, request: 'QNetworkRequest', data: typing.Union[QtCore.QByteArray, bytes, bytearray]) -> 'QNetworkReply': ...
    @typing.overload
    def put(self, request: 'QNetworkRequest', multiPart: QHttpMultiPart) -> 'QNetworkReply': ...
    @typing.overload
    def post(self, request: 'QNetworkRequest', data: QtCore.QIODevice) -> 'QNetworkReply': ...
    @typing.overload
    def post(self, request: 'QNetworkRequest', data: typing.Union[QtCore.QByteArray, bytes, bytearray]) -> 'QNetworkReply': ...
    @typing.overload
    def post(self, request: 'QNetworkRequest', multiPart: QHttpMultiPart) -> 'QNetworkReply': ...
    def get(self, request: 'QNetworkRequest') -> 'QNetworkReply': ...
    def head(self, request: 'QNetworkRequest') -> 'QNetworkReply': ...
    def setCookieJar(self, cookieJar: 'QNetworkCookieJar') -> None: ...
    def cookieJar(self) -> 'QNetworkCookieJar': ...
    def setProxy(self, proxy: 'QNetworkProxy') -> None: ...
    def proxy(self) -> 'QNetworkProxy': ...


class QNetworkConfigurationManager(QtCore.QObject):

    class Capability(int): ...
    CanStartAndStopInterfaces = ... # type: 'QNetworkConfigurationManager.Capability'
    DirectConnectionRouting = ... # type: 'QNetworkConfigurationManager.Capability'
    SystemSessionSupport = ... # type: 'QNetworkConfigurationManager.Capability'
    ApplicationLevelRoaming = ... # type: 'QNetworkConfigurationManager.Capability'
    ForcedRoaming = ... # type: 'QNetworkConfigurationManager.Capability'
    DataStatistics = ... # type: 'QNetworkConfigurationManager.Capability'
    NetworkSessionRequired = ... # type: 'QNetworkConfigurationManager.Capability'

    class Capabilities(sip.simplewrapper):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, f: typing.Union['QNetworkConfigurationManager.Capabilities', 'QNetworkConfigurationManager.Capability']) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QNetworkConfigurationManager.Capabilities') -> None: ...

        def __bool__(self) -> int: ...
        def __invert__(self) -> 'QNetworkConfigurationManager.Capabilities': ...
        def __int__(self) -> int: ...

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

    def updateCompleted(self) -> None: ...
    def onlineStateChanged(self, isOnline: bool) -> None: ...
    def configurationChanged(self, config: 'QNetworkConfiguration') -> None: ...
    def configurationRemoved(self, config: 'QNetworkConfiguration') -> None: ...
    def configurationAdded(self, config: 'QNetworkConfiguration') -> None: ...
    def isOnline(self) -> bool: ...
    def updateConfigurations(self) -> None: ...
    def configurationFromIdentifier(self, identifier: str) -> 'QNetworkConfiguration': ...
    def allConfigurations(self, flags: 'QNetworkConfiguration.StateFlags' = ...) -> typing.Any: ...
    def defaultConfiguration(self) -> 'QNetworkConfiguration': ...
    def capabilities(self) -> 'QNetworkConfigurationManager.Capabilities': ...


class QNetworkConfiguration(sip.simplewrapper):

    class BearerType(int): ...
    BearerUnknown = ... # type: 'QNetworkConfiguration.BearerType'
    BearerEthernet = ... # type: 'QNetworkConfiguration.BearerType'
    BearerWLAN = ... # type: 'QNetworkConfiguration.BearerType'
    Bearer2G = ... # type: 'QNetworkConfiguration.BearerType'
    BearerCDMA2000 = ... # type: 'QNetworkConfiguration.BearerType'
    BearerWCDMA = ... # type: 'QNetworkConfiguration.BearerType'
    BearerHSPA = ... # type: 'QNetworkConfiguration.BearerType'
    BearerBluetooth = ... # type: 'QNetworkConfiguration.BearerType'
    BearerWiMAX = ... # type: 'QNetworkConfiguration.BearerType'

    class StateFlag(int): ...
    Undefined = ... # type: 'QNetworkConfiguration.StateFlag'
    Defined = ... # type: 'QNetworkConfiguration.StateFlag'
    Discovered = ... # type: 'QNetworkConfiguration.StateFlag'
    Active = ... # type: 'QNetworkConfiguration.StateFlag'

    class Purpose(int): ...
    UnknownPurpose = ... # type: 'QNetworkConfiguration.Purpose'
    PublicPurpose = ... # type: 'QNetworkConfiguration.Purpose'
    PrivatePurpose = ... # type: 'QNetworkConfiguration.Purpose'
    ServiceSpecificPurpose = ... # type: 'QNetworkConfiguration.Purpose'

    class Type(int): ...
    InternetAccessPoint = ... # type: 'QNetworkConfiguration.Type'
    ServiceNetwork = ... # type: 'QNetworkConfiguration.Type'
    UserChoice = ... # type: 'QNetworkConfiguration.Type'
    Invalid = ... # type: 'QNetworkConfiguration.Type'

    class StateFlags(sip.simplewrapper):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, f: typing.Union['QNetworkConfiguration.StateFlags', 'QNetworkConfiguration.StateFlag']) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QNetworkConfiguration.StateFlags') -> None: ...

        def __bool__(self) -> int: ...
        def __invert__(self) -> 'QNetworkConfiguration.StateFlags': ...
        def __int__(self) -> int: ...

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: 'QNetworkConfiguration') -> None: ...

    def isValid(self) -> bool: ...
    def name(self) -> str: ...
    def children(self) -> typing.List['QNetworkConfiguration']: ...
    def isRoamingAvailable(self) -> bool: ...
    def identifier(self) -> str: ...
    def bearerTypeName(self) -> str: ...
    def bearerType(self) -> 'QNetworkConfiguration.BearerType': ...
    def bearerName(self) -> str: ...
    def purpose(self) -> 'QNetworkConfiguration.Purpose': ...
    def type(self) -> 'QNetworkConfiguration.Type': ...
    def state(self) -> 'QNetworkConfiguration.StateFlags': ...


class QNetworkCookie(sip.simplewrapper):

    class RawForm(int): ...
    NameAndValueOnly = ... # type: 'QNetworkCookie.RawForm'
    Full = ... # type: 'QNetworkCookie.RawForm'

    @typing.overload
    def __init__(self, name: typing.Union[QtCore.QByteArray, bytes, bytearray] = ..., value: typing.Union[QtCore.QByteArray, bytes, bytearray] = ...) -> None: ...
    @typing.overload
    def __init__(self, other: 'QNetworkCookie') -> None: ...

    def setHttpOnly(self, enable: bool) -> None: ...
    def isHttpOnly(self) -> bool: ...
    @staticmethod
    def parseCookies(cookieString: typing.Union[QtCore.QByteArray, bytes, bytearray]) -> typing.Any: ...
    def toRawForm(self, form: 'QNetworkCookie.RawForm' = ...) -> QtCore.QByteArray: ...
    def setValue(self, value: typing.Union[QtCore.QByteArray, bytes, bytearray]) -> None: ...
    def value(self) -> QtCore.QByteArray: ...
    def setName(self, cookieName: typing.Union[QtCore.QByteArray, bytes, bytearray]) -> None: ...
    def name(self) -> QtCore.QByteArray: ...
    def setPath(self, path: str) -> None: ...
    def path(self) -> str: ...
    def setDomain(self, domain: str) -> None: ...
    def domain(self) -> str: ...
    def setExpirationDate(self, date: typing.Union[QtCore.QDateTime, datetime.datetime]) -> None: ...
    def expirationDate(self) -> QtCore.QDateTime: ...
    def isSessionCookie(self) -> bool: ...
    def setSecure(self, enable: bool) -> None: ...
    def isSecure(self) -> bool: ...


class QNetworkCookieJar(QtCore.QObject):

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

    def allCookies(self) -> typing.List[QNetworkCookie]: ...
    def setAllCookies(self, cookieList: typing.Sequence[QNetworkCookie]) -> None: ...
    def setCookiesFromUrl(self, cookieList: typing.Sequence[QNetworkCookie], url: QtCore.QUrl) -> bool: ...
    def cookiesForUrl(self, url: QtCore.QUrl) -> typing.List[QNetworkCookie]: ...


class QNetworkDiskCache(QAbstractNetworkCache):

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

    def expire(self) -> int: ...
    def clear(self) -> None: ...
    def fileMetaData(self, fileName: str) -> QNetworkCacheMetaData: ...
    def insert(self, device: QtCore.QIODevice) -> None: ...
    def prepare(self, metaData: QNetworkCacheMetaData) -> QtCore.QIODevice: ...
    def remove(self, url: QtCore.QUrl) -> bool: ...
    def data(self, url: QtCore.QUrl) -> QtCore.QIODevice: ...
    def updateMetaData(self, metaData: QNetworkCacheMetaData) -> None: ...
    def metaData(self, url: QtCore.QUrl) -> QNetworkCacheMetaData: ...
    def cacheSize(self) -> int: ...
    def setMaximumCacheSize(self, size: int) -> None: ...
    def maximumCacheSize(self) -> int: ...
    def setCacheDirectory(self, cacheDir: str) -> None: ...
    def cacheDirectory(self) -> str: ...


class QNetworkAddressEntry(sip.simplewrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: 'QNetworkAddressEntry') -> None: ...

    def setPrefixLength(self, length: int) -> None: ...
    def prefixLength(self) -> int: ...
    def setBroadcast(self, newBroadcast: typing.Union[QHostAddress, QHostAddress.SpecialAddress]) -> None: ...
    def broadcast(self) -> QHostAddress: ...
    def setNetmask(self, newNetmask: typing.Union[QHostAddress, QHostAddress.SpecialAddress]) -> None: ...
    def netmask(self) -> QHostAddress: ...
    def setIp(self, newIp: typing.Union[QHostAddress, QHostAddress.SpecialAddress]) -> None: ...
    def ip(self) -> QHostAddress: ...


class QNetworkInterface(sip.simplewrapper):

    class InterfaceFlag(int): ...
    IsUp = ... # type: 'QNetworkInterface.InterfaceFlag'
    IsRunning = ... # type: 'QNetworkInterface.InterfaceFlag'
    CanBroadcast = ... # type: 'QNetworkInterface.InterfaceFlag'
    IsLoopBack = ... # type: 'QNetworkInterface.InterfaceFlag'
    IsPointToPoint = ... # type: 'QNetworkInterface.InterfaceFlag'
    CanMulticast = ... # type: 'QNetworkInterface.InterfaceFlag'

    class InterfaceFlags(sip.simplewrapper):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, f: typing.Union['QNetworkInterface.InterfaceFlags', 'QNetworkInterface.InterfaceFlag']) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QNetworkInterface.InterfaceFlags') -> None: ...

        def __bool__(self) -> int: ...
        def __invert__(self) -> 'QNetworkInterface.InterfaceFlags': ...
        def __int__(self) -> int: ...

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: 'QNetworkInterface') -> None: ...

    def humanReadableName(self) -> str: ...
    def index(self) -> int: ...
    @staticmethod
    def allAddresses() -> typing.List[QHostAddress]: ...
    @staticmethod
    def allInterfaces() -> typing.Any: ...
    @staticmethod
    def interfaceFromIndex(index: int) -> 'QNetworkInterface': ...
    @staticmethod
    def interfaceFromName(name: str) -> 'QNetworkInterface': ...
    def addressEntries(self) -> typing.Any: ...
    def hardwareAddress(self) -> str: ...
    def flags(self) -> 'QNetworkInterface.InterfaceFlags': ...
    def name(self) -> str: ...
    def isValid(self) -> bool: ...


class QNetworkProxy(sip.simplewrapper):

    class Capability(int): ...
    TunnelingCapability = ... # type: 'QNetworkProxy.Capability'
    ListeningCapability = ... # type: 'QNetworkProxy.Capability'
    UdpTunnelingCapability = ... # type: 'QNetworkProxy.Capability'
    CachingCapability = ... # type: 'QNetworkProxy.Capability'
    HostNameLookupCapability = ... # type: 'QNetworkProxy.Capability'

    class ProxyType(int): ...
    DefaultProxy = ... # type: 'QNetworkProxy.ProxyType'
    Socks5Proxy = ... # type: 'QNetworkProxy.ProxyType'
    NoProxy = ... # type: 'QNetworkProxy.ProxyType'
    HttpProxy = ... # type: 'QNetworkProxy.ProxyType'
    HttpCachingProxy = ... # type: 'QNetworkProxy.ProxyType'
    FtpCachingProxy = ... # type: 'QNetworkProxy.ProxyType'

    class Capabilities(sip.simplewrapper):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, f: typing.Union['QNetworkProxy.Capabilities', 'QNetworkProxy.Capability']) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QNetworkProxy.Capabilities') -> None: ...

        def __bool__(self) -> int: ...
        def __invert__(self) -> 'QNetworkProxy.Capabilities': ...
        def __int__(self) -> int: ...

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, type: 'QNetworkProxy.ProxyType', hostName: str = ..., port: int = ..., user: str = ..., password: str = ...) -> None: ...
    @typing.overload
    def __init__(self, other: 'QNetworkProxy') -> None: ...

    def capabilities(self) -> 'QNetworkProxy.Capabilities': ...
    def setCapabilities(self, capab: 'QNetworkProxy.Capabilities') -> None: ...
    def isTransparentProxy(self) -> bool: ...
    def isCachingProxy(self) -> bool: ...
    @staticmethod
    def applicationProxy() -> 'QNetworkProxy': ...
    @staticmethod
    def setApplicationProxy(proxy: 'QNetworkProxy') -> None: ...
    def port(self) -> int: ...
    def setPort(self, port: int) -> None: ...
    def hostName(self) -> str: ...
    def setHostName(self, hostName: str) -> None: ...
    def password(self) -> str: ...
    def setPassword(self, password: str) -> None: ...
    def user(self) -> str: ...
    def setUser(self, userName: str) -> None: ...
    def type(self) -> 'QNetworkProxy.ProxyType': ...
    def setType(self, type: 'QNetworkProxy.ProxyType') -> None: ...


class QNetworkProxyQuery(sip.simplewrapper):

    class QueryType(int): ...
    TcpSocket = ... # type: 'QNetworkProxyQuery.QueryType'
    UdpSocket = ... # type: 'QNetworkProxyQuery.QueryType'
    TcpServer = ... # type: 'QNetworkProxyQuery.QueryType'
    UrlRequest = ... # type: 'QNetworkProxyQuery.QueryType'

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, requestUrl: QtCore.QUrl, type: 'QNetworkProxyQuery.QueryType' = ...) -> None: ...
    @typing.overload
    def __init__(self, hostname: str, port: int, protocolTag: str = ..., type: 'QNetworkProxyQuery.QueryType' = ...) -> None: ...
    @typing.overload
    def __init__(self, bindPort: int, protocolTag: str = ..., type: 'QNetworkProxyQuery.QueryType' = ...) -> None: ...
    @typing.overload
    def __init__(self, networkConfiguration: QNetworkConfiguration, requestUrl: QtCore.QUrl, queryType: 'QNetworkProxyQuery.QueryType' = ...) -> None: ...
    @typing.overload
    def __init__(self, networkConfiguration: QNetworkConfiguration, hostname: str, port: int, protocolTag: str = ..., type: 'QNetworkProxyQuery.QueryType' = ...) -> None: ...
    @typing.overload
    def __init__(self, networkConfiguration: QNetworkConfiguration, bindPort: int, protocolTag: str = ..., type: 'QNetworkProxyQuery.QueryType' = ...) -> None: ...
    @typing.overload
    def __init__(self, other: 'QNetworkProxyQuery') -> None: ...

    def setNetworkConfiguration(self, networkConfiguration: QNetworkConfiguration) -> None: ...
    def networkConfiguration(self) -> QNetworkConfiguration: ...
    def setUrl(self, url: QtCore.QUrl) -> None: ...
    def url(self) -> QtCore.QUrl: ...
    def setProtocolTag(self, protocolTag: str) -> None: ...
    def protocolTag(self) -> str: ...
    def setLocalPort(self, port: int) -> None: ...
    def localPort(self) -> int: ...
    def setPeerHostName(self, hostname: str) -> None: ...
    def peerHostName(self) -> str: ...
    def setPeerPort(self, port: int) -> None: ...
    def peerPort(self) -> int: ...
    def setQueryType(self, type: 'QNetworkProxyQuery.QueryType') -> None: ...
    def queryType(self) -> 'QNetworkProxyQuery.QueryType': ...


class QNetworkProxyFactory(sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QNetworkProxyFactory') -> None: ...

    @staticmethod
    def setUseSystemConfiguration(enable: bool) -> None: ...
    @staticmethod
    def systemProxyForQuery(query: QNetworkProxyQuery = ...) -> typing.List[QNetworkProxy]: ...
    @staticmethod
    def proxyForQuery(query: QNetworkProxyQuery) -> typing.List[QNetworkProxy]: ...
    @staticmethod
    def setApplicationProxyFactory(factory: 'QNetworkProxyFactory') -> None: ...
    def queryProxy(self, query: QNetworkProxyQuery = ...) -> typing.Any: ...


class QNetworkReply(QtCore.QIODevice):

    class NetworkError(int): ...
    NoError = ... # type: 'QNetworkReply.NetworkError'
    ConnectionRefusedError = ... # type: 'QNetworkReply.NetworkError'
    RemoteHostClosedError = ... # type: 'QNetworkReply.NetworkError'
    HostNotFoundError = ... # type: 'QNetworkReply.NetworkError'
    TimeoutError = ... # type: 'QNetworkReply.NetworkError'
    OperationCanceledError = ... # type: 'QNetworkReply.NetworkError'
    SslHandshakeFailedError = ... # type: 'QNetworkReply.NetworkError'
    UnknownNetworkError = ... # type: 'QNetworkReply.NetworkError'
    ProxyConnectionRefusedError = ... # type: 'QNetworkReply.NetworkError'
    ProxyConnectionClosedError = ... # type: 'QNetworkReply.NetworkError'
    ProxyNotFoundError = ... # type: 'QNetworkReply.NetworkError'
    ProxyTimeoutError = ... # type: 'QNetworkReply.NetworkError'
    ProxyAuthenticationRequiredError = ... # type: 'QNetworkReply.NetworkError'
    UnknownProxyError = ... # type: 'QNetworkReply.NetworkError'
    ContentAccessDenied = ... # type: 'QNetworkReply.NetworkError'
    ContentOperationNotPermittedError = ... # type: 'QNetworkReply.NetworkError'
    ContentNotFoundError = ... # type: 'QNetworkReply.NetworkError'
    AuthenticationRequiredError = ... # type: 'QNetworkReply.NetworkError'
    UnknownContentError = ... # type: 'QNetworkReply.NetworkError'
    ProtocolUnknownError = ... # type: 'QNetworkReply.NetworkError'
    ProtocolInvalidOperationError = ... # type: 'QNetworkReply.NetworkError'
    ProtocolFailure = ... # type: 'QNetworkReply.NetworkError'
    ContentReSendError = ... # type: 'QNetworkReply.NetworkError'
    TemporaryNetworkFailureError = ... # type: 'QNetworkReply.NetworkError'

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

    def rawHeaderPairs(self) -> typing.List[typing.Tuple[QtCore.QByteArray, QtCore.QByteArray]]: ...
    def isRunning(self) -> bool: ...
    def isFinished(self) -> bool: ...
    def setFinished(self, finished: bool) -> None: ...
    def setAttribute(self, code: 'QNetworkRequest.Attribute', value: typing.Any) -> None: ...
    def setRawHeader(self, headerName: typing.Union[QtCore.QByteArray, bytes, bytearray], value: typing.Union[QtCore.QByteArray, bytes, bytearray]) -> None: ...
    def setHeader(self, header: 'QNetworkRequest.KnownHeaders', value: typing.Any) -> None: ...
    def setUrl(self, url: QtCore.QUrl) -> None: ...
    def setError(self, errorCode: 'QNetworkReply.NetworkError', errorString: str) -> None: ...
    def setRequest(self, request: 'QNetworkRequest') -> None: ...
    def setOperation(self, operation: QNetworkAccessManager.Operation) -> None: ...
    def writeData(self, data: bytes) -> int: ...
    def downloadProgress(self, bytesReceived: int, bytesTotal: int) -> None: ...
    def uploadProgress(self, bytesSent: int, bytesTotal: int) -> None: ...
    def sslErrors(self, errors: typing.Sequence['QSslError']) -> None: ...
    def finished(self) -> None: ...
    def metaDataChanged(self) -> None: ...
    @typing.overload
    def ignoreSslErrors(self) -> None: ...
    @typing.overload
    def ignoreSslErrors(self, errors: typing.Sequence['QSslError']) -> None: ...
    def setSslConfiguration(self, configuration: 'QSslConfiguration') -> None: ...
    def sslConfiguration(self) -> 'QSslConfiguration': ...
    def attribute(self, code: 'QNetworkRequest.Attribute') -> typing.Any: ...
    def rawHeader(self, headerName: typing.Union[QtCore.QByteArray, bytes, bytearray]) -> QtCore.QByteArray: ...
    def rawHeaderList(self) -> typing.List[QtCore.QByteArray]: ...
    def hasRawHeader(self, headerName: typing.Union[QtCore.QByteArray, bytes, bytearray]) -> bool: ...
    def header(self, header: 'QNetworkRequest.KnownHeaders') -> typing.Any: ...
    def url(self) -> QtCore.QUrl: ...
    @typing.overload
    def error(self) -> 'QNetworkReply.NetworkError': ...
    @typing.overload
    def error(self, a0: 'QNetworkReply.NetworkError') -> None: ...
    def request(self) -> 'QNetworkRequest': ...
    def operation(self) -> QNetworkAccessManager.Operation: ...
    def manager(self) -> QNetworkAccessManager: ...
    def setReadBufferSize(self, size: int) -> None: ...
    def readBufferSize(self) -> int: ...
    def isSequential(self) -> bool: ...
    def close(self) -> None: ...
    def abort(self) -> None: ...


class QNetworkRequest(sip.simplewrapper):

    class Priority(int): ...
    HighPriority = ... # type: 'QNetworkRequest.Priority'
    NormalPriority = ... # type: 'QNetworkRequest.Priority'
    LowPriority = ... # type: 'QNetworkRequest.Priority'

    class LoadControl(int): ...
    Automatic = ... # type: 'QNetworkRequest.LoadControl'
    Manual = ... # type: 'QNetworkRequest.LoadControl'

    class CacheLoadControl(int): ...
    AlwaysNetwork = ... # type: 'QNetworkRequest.CacheLoadControl'
    PreferNetwork = ... # type: 'QNetworkRequest.CacheLoadControl'
    PreferCache = ... # type: 'QNetworkRequest.CacheLoadControl'
    AlwaysCache = ... # type: 'QNetworkRequest.CacheLoadControl'

    class Attribute(int): ...
    HttpStatusCodeAttribute = ... # type: 'QNetworkRequest.Attribute'
    HttpReasonPhraseAttribute = ... # type: 'QNetworkRequest.Attribute'
    RedirectionTargetAttribute = ... # type: 'QNetworkRequest.Attribute'
    ConnectionEncryptedAttribute = ... # type: 'QNetworkRequest.Attribute'
    CacheLoadControlAttribute = ... # type: 'QNetworkRequest.Attribute'
    CacheSaveControlAttribute = ... # type: 'QNetworkRequest.Attribute'
    SourceIsFromCacheAttribute = ... # type: 'QNetworkRequest.Attribute'
    DoNotBufferUploadDataAttribute = ... # type: 'QNetworkRequest.Attribute'
    HttpPipeliningAllowedAttribute = ... # type: 'QNetworkRequest.Attribute'
    HttpPipeliningWasUsedAttribute = ... # type: 'QNetworkRequest.Attribute'
    CustomVerbAttribute = ... # type: 'QNetworkRequest.Attribute'
    CookieLoadControlAttribute = ... # type: 'QNetworkRequest.Attribute'
    AuthenticationReuseAttribute = ... # type: 'QNetworkRequest.Attribute'
    CookieSaveControlAttribute = ... # type: 'QNetworkRequest.Attribute'
    User = ... # type: 'QNetworkRequest.Attribute'
    UserMax = ... # type: 'QNetworkRequest.Attribute'

    class KnownHeaders(int): ...
    ContentTypeHeader = ... # type: 'QNetworkRequest.KnownHeaders'
    ContentLengthHeader = ... # type: 'QNetworkRequest.KnownHeaders'
    LocationHeader = ... # type: 'QNetworkRequest.KnownHeaders'
    LastModifiedHeader = ... # type: 'QNetworkRequest.KnownHeaders'
    CookieHeader = ... # type: 'QNetworkRequest.KnownHeaders'
    SetCookieHeader = ... # type: 'QNetworkRequest.KnownHeaders'
    ContentDispositionHeader = ... # type: 'QNetworkRequest.KnownHeaders'

    @typing.overload
    def __init__(self, url: QtCore.QUrl = ...) -> None: ...
    @typing.overload
    def __init__(self, other: 'QNetworkRequest') -> None: ...

    def setPriority(self, priority: 'QNetworkRequest.Priority') -> None: ...
    def priority(self) -> 'QNetworkRequest.Priority': ...
    def originatingObject(self) -> QtCore.QObject: ...
    def setOriginatingObject(self, object: QtCore.QObject) -> None: ...
    def setSslConfiguration(self, configuration: 'QSslConfiguration') -> None: ...
    def sslConfiguration(self) -> 'QSslConfiguration': ...
    def setAttribute(self, code: 'QNetworkRequest.Attribute', value: typing.Any) -> None: ...
    def attribute(self, code: 'QNetworkRequest.Attribute', defaultValue: typing.Any = ...) -> typing.Any: ...
    def setRawHeader(self, headerName: typing.Union[QtCore.QByteArray, bytes, bytearray], value: typing.Union[QtCore.QByteArray, bytes, bytearray]) -> None: ...
    def rawHeader(self, headerName: typing.Union[QtCore.QByteArray, bytes, bytearray]) -> QtCore.QByteArray: ...
    def rawHeaderList(self) -> typing.List[QtCore.QByteArray]: ...
    def hasRawHeader(self, headerName: typing.Union[QtCore.QByteArray, bytes, bytearray]) -> bool: ...
    def setHeader(self, header: 'QNetworkRequest.KnownHeaders', value: typing.Any) -> None: ...
    def header(self, header: 'QNetworkRequest.KnownHeaders') -> typing.Any: ...
    def setUrl(self, url: QtCore.QUrl) -> None: ...
    def url(self) -> QtCore.QUrl: ...


class QNetworkSession(QtCore.QObject):

    class SessionError(int): ...
    UnknownSessionError = ... # type: 'QNetworkSession.SessionError'
    SessionAbortedError = ... # type: 'QNetworkSession.SessionError'
    RoamingError = ... # type: 'QNetworkSession.SessionError'
    OperationNotSupportedError = ... # type: 'QNetworkSession.SessionError'
    InvalidConfigurationError = ... # type: 'QNetworkSession.SessionError'

    class State(int): ...
    Invalid = ... # type: 'QNetworkSession.State'
    NotAvailable = ... # type: 'QNetworkSession.State'
    Connecting = ... # type: 'QNetworkSession.State'
    Connected = ... # type: 'QNetworkSession.State'
    Closing = ... # type: 'QNetworkSession.State'
    Disconnected = ... # type: 'QNetworkSession.State'
    Roaming = ... # type: 'QNetworkSession.State'

    def __init__(self, connConfig: QNetworkConfiguration, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

    def disconnectNotify(self, signal: QT_SIGNAL) -> None: ...
    def connectNotify(self, signal: QT_SIGNAL) -> None: ...
    def newConfigurationActivated(self) -> None: ...
    def preferredConfigurationChanged(self, config: QNetworkConfiguration, isSeamless: bool) -> None: ...
    def closed(self) -> None: ...
    def opened(self) -> None: ...
    def stateChanged(self, a0: 'QNetworkSession.State') -> None: ...
    def reject(self) -> None: ...
    def accept(self) -> None: ...
    def ignore(self) -> None: ...
    def migrate(self) -> None: ...
    def stop(self) -> None: ...
    def close(self) -> None: ...
    def open(self) -> None: ...
    def waitForOpened(self, msecs: int = ...) -> bool: ...
    def activeTime(self) -> int: ...
    def bytesReceived(self) -> int: ...
    def bytesWritten(self) -> int: ...
    def setSessionProperty(self, key: str, value: typing.Any) -> None: ...
    def sessionProperty(self, key: str) -> typing.Any: ...
    def errorString(self) -> str: ...
    @typing.overload
    def error(self) -> 'QNetworkSession.SessionError': ...
    @typing.overload
    def error(self, a0: 'QNetworkSession.SessionError') -> None: ...
    def state(self) -> 'QNetworkSession.State': ...
    def interface(self) -> QNetworkInterface: ...
    def configuration(self) -> QNetworkConfiguration: ...
    def isOpen(self) -> bool: ...


class QSsl(sip.simplewrapper):

    class SslOption(int): ...
    SslOptionDisableEmptyFragments = ... # type: 'QSsl.SslOption'
    SslOptionDisableSessionTickets = ... # type: 'QSsl.SslOption'
    SslOptionDisableCompression = ... # type: 'QSsl.SslOption'
    SslOptionDisableServerNameIndication = ... # type: 'QSsl.SslOption'
    SslOptionDisableLegacyRenegotiation = ... # type: 'QSsl.SslOption'

    class SslProtocol(int): ...
    UnknownProtocol = ... # type: 'QSsl.SslProtocol'
    SslV3 = ... # type: 'QSsl.SslProtocol'
    SslV2 = ... # type: 'QSsl.SslProtocol'
    TlsV1 = ... # type: 'QSsl.SslProtocol'
    AnyProtocol = ... # type: 'QSsl.SslProtocol'
    TlsV1SslV3 = ... # type: 'QSsl.SslProtocol'
    SecureProtocols = ... # type: 'QSsl.SslProtocol'

    class AlternateNameEntryType(int): ...
    EmailEntry = ... # type: 'QSsl.AlternateNameEntryType'
    DnsEntry = ... # type: 'QSsl.AlternateNameEntryType'

    class KeyAlgorithm(int): ...
    Rsa = ... # type: 'QSsl.KeyAlgorithm'
    Dsa = ... # type: 'QSsl.KeyAlgorithm'

    class EncodingFormat(int): ...
    Pem = ... # type: 'QSsl.EncodingFormat'
    Der = ... # type: 'QSsl.EncodingFormat'

    class KeyType(int): ...
    PrivateKey = ... # type: 'QSsl.KeyType'
    PublicKey = ... # type: 'QSsl.KeyType'

    class SslOptions(sip.simplewrapper):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, f: typing.Union['QSsl.SslOptions', 'QSsl.SslOption']) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QSsl.SslOptions') -> None: ...

        def __bool__(self) -> int: ...
        def __invert__(self) -> 'QSsl.SslOptions': ...
        def __int__(self) -> int: ...


class QSslCertificate(sip.simplewrapper):

    class SubjectInfo(int): ...
    Organization = ... # type: 'QSslCertificate.SubjectInfo'
    CommonName = ... # type: 'QSslCertificate.SubjectInfo'
    LocalityName = ... # type: 'QSslCertificate.SubjectInfo'
    OrganizationalUnitName = ... # type: 'QSslCertificate.SubjectInfo'
    CountryName = ... # type: 'QSslCertificate.SubjectInfo'
    StateOrProvinceName = ... # type: 'QSslCertificate.SubjectInfo'

    @typing.overload
    def __init__(self, device: QtCore.QIODevice, format: QSsl.EncodingFormat = ...) -> None: ...
    @typing.overload
    def __init__(self, data: typing.Union[QtCore.QByteArray, bytes, bytearray] = ..., format: QSsl.EncodingFormat = ...) -> None: ...
    @typing.overload
    def __init__(self, other: 'QSslCertificate') -> None: ...

    def handle(self) -> int: ...
    @staticmethod
    def fromData(data: typing.Union[QtCore.QByteArray, bytes, bytearray], format: QSsl.EncodingFormat = ...) -> typing.List['QSslCertificate']: ...
    @staticmethod
    def fromDevice(device: QtCore.QIODevice, format: QSsl.EncodingFormat = ...) -> typing.List['QSslCertificate']: ...
    @staticmethod
    def fromPath(path: str, format: QSsl.EncodingFormat = ..., syntax: QtCore.QRegExp.PatternSyntax = ...) -> typing.Any: ...
    def toDer(self) -> QtCore.QByteArray: ...
    def toPem(self) -> QtCore.QByteArray: ...
    def publicKey(self) -> 'QSslKey': ...
    def expiryDate(self) -> QtCore.QDateTime: ...
    def effectiveDate(self) -> QtCore.QDateTime: ...
    def alternateSubjectNames(self) -> typing.Dict[QSsl.AlternateNameEntryType, typing.List[str]]: ...
    @typing.overload
    def subjectInfo(self, info: 'QSslCertificate.SubjectInfo') -> str: ...
    @typing.overload
    def subjectInfo(self, tag: typing.Union[QtCore.QByteArray, bytes, bytearray]) -> str: ...
    @typing.overload
    def issuerInfo(self, info: 'QSslCertificate.SubjectInfo') -> str: ...
    @typing.overload
    def issuerInfo(self, tag: typing.Union[QtCore.QByteArray, bytes, bytearray]) -> str: ...
    def digest(self, algorithm: QtCore.QCryptographicHash.Algorithm = ...) -> QtCore.QByteArray: ...
    def serialNumber(self) -> QtCore.QByteArray: ...
    def version(self) -> QtCore.QByteArray: ...
    def clear(self) -> None: ...
    def isValid(self) -> bool: ...
    def isNull(self) -> bool: ...


class QSslConfiguration(sip.simplewrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: 'QSslConfiguration') -> None: ...

    def testSslOption(self, option: QSsl.SslOption) -> bool: ...
    def setSslOption(self, option: QSsl.SslOption, on: bool) -> None: ...
    @staticmethod
    def setDefaultConfiguration(configuration: 'QSslConfiguration') -> None: ...
    @staticmethod
    def defaultConfiguration() -> 'QSslConfiguration': ...
    def setCaCertificates(self, certificates: typing.Sequence[QSslCertificate]) -> None: ...
    def caCertificates(self) -> typing.List[QSslCertificate]: ...
    def setCiphers(self, ciphers: typing.Sequence['QSslCipher']) -> None: ...
    def ciphers(self) -> typing.Any: ...
    def setPrivateKey(self, key: 'QSslKey') -> None: ...
    def privateKey(self) -> 'QSslKey': ...
    def sessionCipher(self) -> 'QSslCipher': ...
    def peerCertificateChain(self) -> typing.List[QSslCertificate]: ...
    def peerCertificate(self) -> QSslCertificate: ...
    def setLocalCertificate(self, certificate: QSslCertificate) -> None: ...
    def localCertificate(self) -> QSslCertificate: ...
    def setPeerVerifyDepth(self, depth: int) -> None: ...
    def peerVerifyDepth(self) -> int: ...
    def setPeerVerifyMode(self, mode: 'QSslSocket.PeerVerifyMode') -> None: ...
    def peerVerifyMode(self) -> 'QSslSocket.PeerVerifyMode': ...
    def setProtocol(self, protocol: QSsl.SslProtocol) -> None: ...
    def protocol(self) -> QSsl.SslProtocol: ...
    def isNull(self) -> bool: ...


class QSslCipher(sip.simplewrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, name: str, protocol: QSsl.SslProtocol) -> None: ...
    @typing.overload
    def __init__(self, other: 'QSslCipher') -> None: ...

    def protocol(self) -> QSsl.SslProtocol: ...
    def protocolString(self) -> str: ...
    def encryptionMethod(self) -> str: ...
    def authenticationMethod(self) -> str: ...
    def keyExchangeMethod(self) -> str: ...
    def usedBits(self) -> int: ...
    def supportedBits(self) -> int: ...
    def name(self) -> str: ...
    def isNull(self) -> bool: ...


class QSslError(sip.simplewrapper):

    class SslError(int): ...
    UnspecifiedError = ... # type: 'QSslError.SslError'
    NoError = ... # type: 'QSslError.SslError'
    UnableToGetIssuerCertificate = ... # type: 'QSslError.SslError'
    UnableToDecryptCertificateSignature = ... # type: 'QSslError.SslError'
    UnableToDecodeIssuerPublicKey = ... # type: 'QSslError.SslError'
    CertificateSignatureFailed = ... # type: 'QSslError.SslError'
    CertificateNotYetValid = ... # type: 'QSslError.SslError'
    CertificateExpired = ... # type: 'QSslError.SslError'
    InvalidNotBeforeField = ... # type: 'QSslError.SslError'
    InvalidNotAfterField = ... # type: 'QSslError.SslError'
    SelfSignedCertificate = ... # type: 'QSslError.SslError'
    SelfSignedCertificateInChain = ... # type: 'QSslError.SslError'
    UnableToGetLocalIssuerCertificate = ... # type: 'QSslError.SslError'
    UnableToVerifyFirstCertificate = ... # type: 'QSslError.SslError'
    CertificateRevoked = ... # type: 'QSslError.SslError'
    InvalidCaCertificate = ... # type: 'QSslError.SslError'
    PathLengthExceeded = ... # type: 'QSslError.SslError'
    InvalidPurpose = ... # type: 'QSslError.SslError'
    CertificateUntrusted = ... # type: 'QSslError.SslError'
    CertificateRejected = ... # type: 'QSslError.SslError'
    SubjectIssuerMismatch = ... # type: 'QSslError.SslError'
    AuthorityIssuerSerialNumberMismatch = ... # type: 'QSslError.SslError'
    NoPeerCertificate = ... # type: 'QSslError.SslError'
    HostNameMismatch = ... # type: 'QSslError.SslError'
    NoSslSupport = ... # type: 'QSslError.SslError'
    CertificateBlacklisted = ... # type: 'QSslError.SslError'

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, error: 'QSslError.SslError') -> None: ...
    @typing.overload
    def __init__(self, error: 'QSslError.SslError', certificate: QSslCertificate) -> None: ...
    @typing.overload
    def __init__(self, other: 'QSslError') -> None: ...

    def certificate(self) -> QSslCertificate: ...
    def errorString(self) -> str: ...
    def error(self) -> 'QSslError.SslError': ...


class QSslKey(sip.simplewrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, encoded: typing.Union[QtCore.QByteArray, bytes, bytearray], algorithm: QSsl.KeyAlgorithm, encoding: QSsl.EncodingFormat = ..., type: QSsl.KeyType = ..., passPhrase: typing.Union[QtCore.QByteArray, bytes, bytearray] = ...) -> None: ...
    @typing.overload
    def __init__(self, device: QtCore.QIODevice, algorithm: QSsl.KeyAlgorithm, encoding: QSsl.EncodingFormat = ..., type: QSsl.KeyType = ..., passPhrase: typing.Union[QtCore.QByteArray, bytes, bytearray] = ...) -> None: ...
    @typing.overload
    def __init__(self, other: 'QSslKey') -> None: ...

    def handle(self) -> int: ...
    def toDer(self, passPhrase: typing.Union[QtCore.QByteArray, bytes, bytearray] = ...) -> QtCore.QByteArray: ...
    def toPem(self, passPhrase: typing.Union[QtCore.QByteArray, bytes, bytearray] = ...) -> QtCore.QByteArray: ...
    def algorithm(self) -> QSsl.KeyAlgorithm: ...
    def type(self) -> QSsl.KeyType: ...
    def length(self) -> int: ...
    def clear(self) -> None: ...
    def isNull(self) -> bool: ...


class QTcpSocket(QAbstractSocket):

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...


class QSslSocket(QTcpSocket):

    class PeerVerifyMode(int): ...
    VerifyNone = ... # type: 'QSslSocket.PeerVerifyMode'
    QueryPeer = ... # type: 'QSslSocket.PeerVerifyMode'
    VerifyPeer = ... # type: 'QSslSocket.PeerVerifyMode'
    AutoVerifyPeer = ... # type: 'QSslSocket.PeerVerifyMode'

    class SslMode(int): ...
    UnencryptedMode = ... # type: 'QSslSocket.SslMode'
    SslClientMode = ... # type: 'QSslSocket.SslMode'
    SslServerMode = ... # type: 'QSslSocket.SslMode'

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

    def setPeerVerifyName(self, hostName: str) -> None: ...
    def peerVerifyName(self) -> str: ...
    def socketOption(self, option: QAbstractSocket.SocketOption) -> typing.Any: ...
    def setSocketOption(self, option: QAbstractSocket.SocketOption, value: typing.Any) -> None: ...
    def encryptedBytesWritten(self, totalBytes: int) -> None: ...
    def peerVerifyError(self, error: QSslError) -> None: ...
    def setSslConfiguration(self, config: QSslConfiguration) -> None: ...
    def sslConfiguration(self) -> QSslConfiguration: ...
    def encryptedBytesToWrite(self) -> int: ...
    def encryptedBytesAvailable(self) -> int: ...
    def setReadBufferSize(self, size: int) -> None: ...
    def setPeerVerifyDepth(self, depth: int) -> None: ...
    def peerVerifyDepth(self) -> int: ...
    def setPeerVerifyMode(self, mode: 'QSslSocket.PeerVerifyMode') -> None: ...
    def peerVerifyMode(self) -> 'QSslSocket.PeerVerifyMode': ...
    def writeData(self, data: bytes) -> int: ...
    def readData(self, maxlen: int) -> bytes: ...
    def disconnectFromHostImplementation(self) -> None: ...
    def connectToHostImplementation(self, hostName: str, port: int, openMode: QtCore.QIODevice.OpenMode) -> None: ...
    def modeChanged(self, newMode: 'QSslSocket.SslMode') -> None: ...
    def encrypted(self) -> None: ...
    @typing.overload
    def ignoreSslErrors(self) -> None: ...
    @typing.overload
    def ignoreSslErrors(self, errors: typing.Sequence[QSslError]) -> None: ...
    def startServerEncryption(self) -> None: ...
    def startClientEncryption(self) -> None: ...
    @staticmethod
    def supportsSsl() -> bool: ...
    @typing.overload
    def sslErrors(self) -> typing.List[QSslError]: ...
    @typing.overload
    def sslErrors(self, errors: typing.Sequence[QSslError]) -> None: ...
    def waitForDisconnected(self, msecs: int = ...) -> bool: ...
    def waitForBytesWritten(self, msecs: int = ...) -> bool: ...
    def waitForReadyRead(self, msecs: int = ...) -> bool: ...
    def waitForEncrypted(self, msecs: int = ...) -> bool: ...
    def waitForConnected(self, msecs: int = ...) -> bool: ...
    @staticmethod
    def systemCaCertificates() -> typing.List[QSslCertificate]: ...
    @staticmethod
    def defaultCaCertificates() -> typing.List[QSslCertificate]: ...
    @staticmethod
    def setDefaultCaCertificates(certificates: typing.Sequence[QSslCertificate]) -> None: ...
    @staticmethod
    def addDefaultCaCertificate(certificate: QSslCertificate) -> None: ...
    @typing.overload
    @staticmethod
    def addDefaultCaCertificates(path: str, format: QSsl.EncodingFormat = ..., syntax: QtCore.QRegExp.PatternSyntax = ...) -> bool: ...
    @typing.overload
    @staticmethod
    def addDefaultCaCertificates(certificates: typing.Sequence[QSslCertificate]) -> None: ...
    def caCertificates(self) -> typing.List[QSslCertificate]: ...
    def setCaCertificates(self, certificates: typing.Sequence[QSslCertificate]) -> None: ...
    def addCaCertificate(self, certificate: QSslCertificate) -> None: ...
    @typing.overload
    def addCaCertificates(self, path: str, format: QSsl.EncodingFormat = ..., syntax: QtCore.QRegExp.PatternSyntax = ...) -> bool: ...
    @typing.overload
    def addCaCertificates(self, certificates: typing.Sequence[QSslCertificate]) -> None: ...
    @staticmethod
    def supportedCiphers() -> typing.List[QSslCipher]: ...
    @staticmethod
    def defaultCiphers() -> typing.List[QSslCipher]: ...
    @staticmethod
    def setDefaultCiphers(ciphers: typing.Sequence[QSslCipher]) -> None: ...
    @typing.overload
    def setCiphers(self, ciphers: typing.Sequence[QSslCipher]) -> None: ...
    @typing.overload
    def setCiphers(self, ciphers: str) -> None: ...
    def ciphers(self) -> typing.List[QSslCipher]: ...
    def privateKey(self) -> QSslKey: ...
    @typing.overload
    def setPrivateKey(self, key: QSslKey) -> None: ...
    @typing.overload
    def setPrivateKey(self, fileName: str, algorithm: QSsl.KeyAlgorithm = ..., format: QSsl.EncodingFormat = ..., passPhrase: typing.Union[QtCore.QByteArray, bytes, bytearray] = ...) -> None: ...
    def sessionCipher(self) -> QSslCipher: ...
    def peerCertificateChain(self) -> typing.List[QSslCertificate]: ...
    def peerCertificate(self) -> QSslCertificate: ...
    def localCertificate(self) -> QSslCertificate: ...
    @typing.overload
    def setLocalCertificate(self, certificate: QSslCertificate) -> None: ...
    @typing.overload
    def setLocalCertificate(self, path: str, format: QSsl.EncodingFormat = ...) -> None: ...
    def abort(self) -> None: ...
    def flush(self) -> bool: ...
    def atEnd(self) -> bool: ...
    def close(self) -> None: ...
    def canReadLine(self) -> bool: ...
    def bytesToWrite(self) -> int: ...
    def bytesAvailable(self) -> int: ...
    def setProtocol(self, protocol: QSsl.SslProtocol) -> None: ...
    def protocol(self) -> QSsl.SslProtocol: ...
    def isEncrypted(self) -> bool: ...
    def mode(self) -> 'QSslSocket.SslMode': ...
    def setSocketDescriptor(self, socketDescriptor: int, state: QAbstractSocket.SocketState = ..., mode: typing.Union[QtCore.QIODevice.OpenMode, QtCore.QIODevice.OpenModeFlag] = ...) -> bool: ...
    @typing.overload
    def connectToHostEncrypted(self, hostName: str, port: int, mode: QtCore.QIODevice.OpenMode = ...) -> None: ...
    @typing.overload
    def connectToHostEncrypted(self, hostName: str, port: int, sslPeerName: str, mode: QtCore.QIODevice.OpenMode = ...) -> None: ...


class QTcpServer(QtCore.QObject):

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

    def newConnection(self) -> None: ...
    def addPendingConnection(self, socket: QTcpSocket) -> None: ...
    def incomingConnection(self, handle: int) -> None: ...
    def proxy(self) -> QNetworkProxy: ...
    def setProxy(self, networkProxy: QNetworkProxy) -> None: ...
    def errorString(self) -> str: ...
    def serverError(self) -> QAbstractSocket.SocketError: ...
    def nextPendingConnection(self) -> QTcpSocket: ...
    def hasPendingConnections(self) -> bool: ...
    def waitForNewConnection(self, msecs: int = ...) -> typing.Tuple[bool, bool]: ...
    def setSocketDescriptor(self, socketDescriptor: int) -> bool: ...
    def socketDescriptor(self) -> int: ...
    def serverAddress(self) -> QHostAddress: ...
    def serverPort(self) -> int: ...
    def maxPendingConnections(self) -> int: ...
    def setMaxPendingConnections(self, numConnections: int) -> None: ...
    def isListening(self) -> bool: ...
    def close(self) -> None: ...
    def listen(self, address: typing.Union[QHostAddress, QHostAddress.SpecialAddress] = ..., port: int = ...) -> bool: ...


class QUdpSocket(QAbstractSocket):

    class BindFlag(int): ...
    DefaultForPlatform = ... # type: 'QUdpSocket.BindFlag'
    ShareAddress = ... # type: 'QUdpSocket.BindFlag'
    DontShareAddress = ... # type: 'QUdpSocket.BindFlag'
    ReuseAddressHint = ... # type: 'QUdpSocket.BindFlag'

    class BindMode(sip.simplewrapper):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, f: typing.Union['QUdpSocket.BindMode', 'QUdpSocket.BindFlag']) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QUdpSocket.BindMode') -> None: ...

        def __bool__(self) -> int: ...
        def __invert__(self) -> 'QUdpSocket.BindMode': ...
        def __int__(self) -> int: ...

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

    def setMulticastInterface(self, iface: QNetworkInterface) -> None: ...
    def multicastInterface(self) -> QNetworkInterface: ...
    @typing.overload
    def leaveMulticastGroup(self, groupAddress: typing.Union[QHostAddress, QHostAddress.SpecialAddress]) -> bool: ...
    @typing.overload
    def leaveMulticastGroup(self, groupAddress: typing.Union[QHostAddress, QHostAddress.SpecialAddress], iface: QNetworkInterface) -> bool: ...
    @typing.overload
    def joinMulticastGroup(self, groupAddress: typing.Union[QHostAddress, QHostAddress.SpecialAddress]) -> bool: ...
    @typing.overload
    def joinMulticastGroup(self, groupAddress: typing.Union[QHostAddress, QHostAddress.SpecialAddress], iface: QNetworkInterface) -> bool: ...
    @typing.overload
    def writeDatagram(self, data: bytes, host: typing.Union[QHostAddress, QHostAddress.SpecialAddress], port: int) -> int: ...
    @typing.overload
    def writeDatagram(self, datagram: typing.Union[QtCore.QByteArray, bytes, bytearray], host: typing.Union[QHostAddress, QHostAddress.SpecialAddress], port: int) -> int: ...
    def readDatagram(self, maxlen: int) -> typing.Tuple[bytes, QHostAddress, int]: ...
    def pendingDatagramSize(self) -> int: ...
    def hasPendingDatagrams(self) -> bool: ...
    @typing.overload
    def bind(self, address: typing.Union[QHostAddress, QHostAddress.SpecialAddress], port: int) -> bool: ...
    @typing.overload
    def bind(self, port: int = ...) -> bool: ...
    @typing.overload
    def bind(self, address: typing.Union[QHostAddress, QHostAddress.SpecialAddress], port: int, mode: 'QUdpSocket.BindMode') -> bool: ...
    @typing.overload
    def bind(self, port: int, mode: 'QUdpSocket.BindMode') -> bool: ...


class QUrlInfo(sip.simplewrapper):

    class PermissionSpec(int): ...
    ReadOwner = ... # type: 'QUrlInfo.PermissionSpec'
    WriteOwner = ... # type: 'QUrlInfo.PermissionSpec'
    ExeOwner = ... # type: 'QUrlInfo.PermissionSpec'
    ReadGroup = ... # type: 'QUrlInfo.PermissionSpec'
    WriteGroup = ... # type: 'QUrlInfo.PermissionSpec'
    ExeGroup = ... # type: 'QUrlInfo.PermissionSpec'
    ReadOther = ... # type: 'QUrlInfo.PermissionSpec'
    WriteOther = ... # type: 'QUrlInfo.PermissionSpec'
    ExeOther = ... # type: 'QUrlInfo.PermissionSpec'

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, ui: 'QUrlInfo') -> None: ...
    @typing.overload
    def __init__(self, name: str, permissions: int, owner: str, group: str, size: int, lastModified: typing.Union[QtCore.QDateTime, datetime.datetime], lastRead: typing.Union[QtCore.QDateTime, datetime.datetime], isDir: bool, isFile: bool, isSymLink: bool, isWritable: bool, isReadable: bool, isExecutable: bool) -> None: ...
    @typing.overload
    def __init__(self, url: QtCore.QUrl, permissions: int, owner: str, group: str, size: int, lastModified: typing.Union[QtCore.QDateTime, datetime.datetime], lastRead: typing.Union[QtCore.QDateTime, datetime.datetime], isDir: bool, isFile: bool, isSymLink: bool, isWritable: bool, isReadable: bool, isExecutable: bool) -> None: ...

    def setLastRead(self, dt: typing.Union[QtCore.QDateTime, datetime.datetime]) -> None: ...
    @staticmethod
    def equal(i1: 'QUrlInfo', i2: 'QUrlInfo', sortBy: int) -> bool: ...
    @staticmethod
    def lessThan(i1: 'QUrlInfo', i2: 'QUrlInfo', sortBy: int) -> bool: ...
    @staticmethod
    def greaterThan(i1: 'QUrlInfo', i2: 'QUrlInfo', sortBy: int) -> bool: ...
    def isExecutable(self) -> bool: ...
    def isReadable(self) -> bool: ...
    def isWritable(self) -> bool: ...
    def isSymLink(self) -> bool: ...
    def isFile(self) -> bool: ...
    def isDir(self) -> bool: ...
    def lastRead(self) -> QtCore.QDateTime: ...
    def lastModified(self) -> QtCore.QDateTime: ...
    def size(self) -> int: ...
    def group(self) -> str: ...
    def owner(self) -> str: ...
    def permissions(self) -> int: ...
    def name(self) -> str: ...
    def isValid(self) -> bool: ...
    def setLastModified(self, dt: typing.Union[QtCore.QDateTime, datetime.datetime]) -> None: ...
    def setPermissions(self, p: int) -> None: ...
    def setReadable(self, b: bool) -> None: ...
    def setWritable(self, b: bool) -> None: ...
    def setSize(self, size: int) -> None: ...
    def setGroup(self, s: str) -> None: ...
    def setOwner(self, s: str) -> None: ...
    def setSymLink(self, b: bool) -> None: ...
    def setFile(self, b: bool) -> None: ...
    def setDir(self, b: bool) -> None: ...
    def setName(self, name: str) -> None: ...
