// This file is generated by kconfig_compiler_kf5 from notificationsettings.kcfg.
// All changes you do to this file will be lost.

#include "notificationsettings.h"

#include <qglobal.h>
#include <QFile>

#include <QDebug>

using namespace NotificationManager;

namespace NotificationManager {

class NotificationSettingsHelper
{
  public:
    NotificationSettingsHelper() : q(nullptr) {}
    ~NotificationSettingsHelper() { delete q; }
    NotificationSettingsHelper(const NotificationSettingsHelper&) = delete;
    NotificationSettingsHelper& operator=(const NotificationSettingsHelper&) = delete;
    NotificationSettings *q;
};
}

Q_GLOBAL_STATIC(NotificationSettingsHelper, s_globalNotificationSettings)
NotificationSettings *NotificationSettings::self()
{
  if (!s_globalNotificationSettings()->q)
     qFatal("you need to call NotificationSettings::instance before using");
  return s_globalNotificationSettings()->q;
}

void NotificationSettings::instance(const QString& cfgfilename)
{
  if (s_globalNotificationSettings()->q) {
     qDebug() << "NotificationSettings::instance called after the first use - ignoring";
     return;
  }
  new NotificationSettings(KSharedConfig::openConfig(cfgfilename));
  s_globalNotificationSettings()->q->read();
}

void NotificationSettings::instance(KSharedConfig::Ptr config)
{
  if (s_globalNotificationSettings()->q) {
     qDebug() << "NotificationSettings::instance called after the first use - ignoring";
     return;
  }
  new NotificationSettings(std::move(config));
  s_globalNotificationSettings()->q->read();
}

NotificationSettings::NotificationSettings( KSharedConfig::Ptr config )
  : KConfigSkeleton( std::move( config ) )
{
  Q_ASSERT(!s_globalNotificationSettings()->q);
  s_globalNotificationSettings()->q = this;
  setCurrentGroup( QStringLiteral( "Notifications" ) );

  KConfigSkeleton::ItemBool  *itemCriticalInDndMode;
  itemCriticalInDndMode = new KConfigSkeleton::ItemBool( currentGroup(), QStringLiteral( "CriticalInDndMode" ), mCriticalInDndMode, true );
  itemCriticalInDndMode->setWriteFlags(KConfigBase::Notify);
  addItem( itemCriticalInDndMode, QStringLiteral( "CriticalInDndMode" ) );
  KConfigSkeleton::ItemBool  *itemCriticalAlwaysOnTop;
  itemCriticalAlwaysOnTop = new KConfigSkeleton::ItemBool( currentGroup(), QStringLiteral( "CriticalAlwaysOnTop" ), mCriticalAlwaysOnTop, true );
  itemCriticalAlwaysOnTop->setWriteFlags(KConfigBase::Notify);
  addItem( itemCriticalAlwaysOnTop, QStringLiteral( "CriticalAlwaysOnTop" ) );
  KConfigSkeleton::ItemBool  *itemLowPriorityPopups;
  itemLowPriorityPopups = new KConfigSkeleton::ItemBool( currentGroup(), QStringLiteral( "LowPriorityPopups" ), mLowPriorityPopups, true );
  itemLowPriorityPopups->setWriteFlags(KConfigBase::Notify);
  addItem( itemLowPriorityPopups, QStringLiteral( "LowPriorityPopups" ) );
  KConfigSkeleton::ItemBool  *itemLowPriorityHistory;
  itemLowPriorityHistory = new KConfigSkeleton::ItemBool( currentGroup(), QStringLiteral( "LowPriorityHistory" ), mLowPriorityHistory, false );
  itemLowPriorityHistory->setWriteFlags(KConfigBase::Notify);
  addItem( itemLowPriorityHistory, QStringLiteral( "LowPriorityHistory" ) );
  QList<KConfigSkeleton::ItemEnum::Choice> valuesPopupPosition;
  {
    KConfigSkeleton::ItemEnum::Choice choice;
    choice.name = QStringLiteral("CloseToWidget");
    valuesPopupPosition.append( choice );
  }
  {
    KConfigSkeleton::ItemEnum::Choice choice;
    choice.name = QStringLiteral("TopLeft");
    valuesPopupPosition.append( choice );
  }
  {
    KConfigSkeleton::ItemEnum::Choice choice;
    choice.name = QStringLiteral("TopCenter");
    valuesPopupPosition.append( choice );
  }
  {
    KConfigSkeleton::ItemEnum::Choice choice;
    choice.name = QStringLiteral("TopRight");
    valuesPopupPosition.append( choice );
  }
  {
    KConfigSkeleton::ItemEnum::Choice choice;
    choice.name = QStringLiteral("BottomLeft");
    valuesPopupPosition.append( choice );
  }
  {
    KConfigSkeleton::ItemEnum::Choice choice;
    choice.name = QStringLiteral("BottomCenter");
    valuesPopupPosition.append( choice );
  }
  {
    KConfigSkeleton::ItemEnum::Choice choice;
    choice.name = QStringLiteral("BottomRight");
    valuesPopupPosition.append( choice );
  }
  KConfigSkeleton::ItemEnum  *itemPopupPosition;
  itemPopupPosition = new KConfigSkeleton::ItemEnum( currentGroup(), QStringLiteral( "PopupPosition" ), mPopupPosition, valuesPopupPosition, Settings::CloseToWidget );
  itemPopupPosition->setWriteFlags(KConfigBase::Notify);
  addItem( itemPopupPosition, QStringLiteral( "PopupPosition" ) );
  KConfigSkeleton::ItemInt  *itemPopupTimeout;
  itemPopupTimeout = new KConfigSkeleton::ItemInt( currentGroup(), QStringLiteral( "PopupTimeout" ), mPopupTimeout, 5000 );
  itemPopupTimeout->setWriteFlags(KConfigBase::Notify);
  addItem( itemPopupTimeout, QStringLiteral( "PopupTimeout" ) );
}

bool NotificationSettings::defaultCriticalInDndModeValue_helper()
{

  return true;
}

bool NotificationSettings::defaultCriticalAlwaysOnTopValue_helper()
{

  return true;
}

bool NotificationSettings::defaultLowPriorityPopupsValue_helper()
{

  return true;
}

bool NotificationSettings::defaultLowPriorityHistoryValue_helper()
{

  return false;
}

int NotificationSettings::defaultPopupPositionValue_helper()
{

  return Settings::CloseToWidget;
}

int NotificationSettings::defaultPopupTimeoutValue_helper()
{

  return 5000;
}

NotificationSettings::~NotificationSettings()
{
  s_globalNotificationSettings()->q = nullptr;
}

