package SDL::ConfigData;
use strict;
my $arrayref = eval do {local $/; <DATA>}
  or die "Couldn't load ConfigData data: $@";
close DATA;
my ($config, $features, $auto_features) = @$arrayref;

sub config { $config->{$_[1]} }

sub set_config { $config->{$_[1]} = $_[2] }
sub set_feature { $features->{$_[1]} = 0+!!$_[2] }  # Constrain to 1 or 0

sub auto_feature_names { grep !exists $features->{$_}, keys %$auto_features }

sub feature_names {
  my @features = (keys %$features, auto_feature_names());
  @features;
}

sub config_names  { keys %$config }

sub write {
  my $me = __FILE__;
  require IO::File;

  # Can't use Module::Build::Dumper here because M::B is only a
  # build-time prereq of this module
  require Data::Dumper;

  my $mode_orig = (stat $me)[2] & 07777;
  chmod($mode_orig | 0222, $me); # Make it writeable
  my $fh = IO::File->new($me, 'r+') or die "Can't rewrite $me: $!";
  seek($fh, 0, 0);
  while (<$fh>) {
    last if /^__DATA__$/;
  }
  die "Couldn't find __DATA__ token in $me" if eof($fh);

  seek($fh, tell($fh), 0);
  my $data = [$config, $features, $auto_features];
  $fh->print( 'do{ my '
	      . Data::Dumper->new([$data],['x'])->Purity(1)->Dump()
	      . '$x; }' );
  truncate($fh, tell($fh));
  $fh->close;

  chmod($mode_orig, $me)
    or warn "Couldn't restore permissions on $me: $!";
}

sub feature {
  my ($package, $key) = @_;
  return $features->{$key} if exists $features->{$key};

  my $info = $auto_features->{$key} or return 0;

  # Under perl 5.005, each(%$foo) isn't working correctly when $foo
  # was reanimated with Data::Dumper and eval().  Not sure why, but
  # copying to a new hash seems to solve it.
  my %info = %$info;

  require Module::Build;  # XXX should get rid of this
  while (my ($type, $prereqs) = each %info) {
    next if $type eq 'description' || $type eq 'recommends';

    my %p = %$prereqs;  # Ditto here.
    while (my ($modname, $spec) = each %p) {
      my $status = Module::Build->check_installed_status($modname, $spec);
      if ((!$status->{ok}) xor ($type =~ /conflicts$/)) { return 0; }
      if ( ! eval "require $modname; 1" ) { return 0; }
    }
  }
  return 1;
}


=head1 NAME

SDL::ConfigData - Configuration for SDL

=head1 SYNOPSIS

  use SDL::ConfigData;
  $value = SDL::ConfigData->config('foo');
  $value = SDL::ConfigData->feature('bar');

  @names = SDL::ConfigData->config_names;
  @names = SDL::ConfigData->feature_names;

  SDL::ConfigData->set_config(foo => $new_value);
  SDL::ConfigData->set_feature(bar => $new_value);
  SDL::ConfigData->write;  # Save changes


=head1 DESCRIPTION

This module holds the configuration data for the C<SDL>
module.  It also provides a programmatic interface for getting or
setting that configuration data.  Note that in order to actually make
changes, you'll have to have write access to the C<SDL::ConfigData>
module, and you should attempt to understand the repercussions of your
actions.


=head1 METHODS

=over 4

=item config($name)

Given a string argument, returns the value of the configuration item
by that name, or C<undef> if no such item exists.

=item feature($name)

Given a string argument, returns the value of the feature by that
name, or C<undef> if no such feature exists.

=item set_config($name, $value)

Sets the configuration item with the given name to the given value.
The value may be any Perl scalar that will serialize correctly using
C<Data::Dumper>.  This includes references, objects (usually), and
complex data structures.  It probably does not include transient
things like filehandles or sockets.

=item set_feature($name, $value)

Sets the feature with the given name to the given boolean value.  The
value will be converted to 0 or 1 automatically.

=item config_names()

Returns a list of all the names of config items currently defined in
C<SDL::ConfigData>, or in scalar context the number of items.

=item feature_names()

Returns a list of all the names of features currently defined in
C<SDL::ConfigData>, or in scalar context the number of features.

=item auto_feature_names()

Returns a list of all the names of features whose availability is
dynamically determined, or in scalar context the number of such
features.  Does not include such features that have later been set to
a fixed value.

=item write()

Commits any changes from C<set_config()> and C<set_feature()> to disk.
Requires write access to the C<SDL::ConfigData> module.

=back


=head1 AUTHOR

C<SDL::ConfigData> was automatically created using C<Module::Build>.
C<Module::Build> was written by Ken Williams, but he holds no
authorship claim or copyright claim to the contents of C<SDL::ConfigData>.

=cut


__DATA__
do{ my $x = [
  {
    'subsystems' => {
      'AudioSpec' => {
        'libraries' => [
          'SDL'
        ],
        'file' => {
          'from' => 'src/Core/objects/AudioSpec.xs',
          'to' => 'lib/SDL/AudioSpec.xs'
        }
      },
      'Cursor' => {
        'libraries' => [
          'SDL'
        ],
        'file' => {
          'from' => 'src/Core/objects/Cursor.xs',
          'to' => 'lib/SDL/Cursor.xs'
        }
      },
      'ImageFilter' => {
        'file' => {
          'to' => 'lib/SDL/GFX/ImageFilter.xs',
          'from' => 'src/GFX/ImageFilter.xs'
        },
        'libraries' => [
          'SDL',
          'SDL_gfx_imagefilter'
        ]
      },
      'Pango' => {
        'file' => {
          'from' => 'src/Pango/Pango.xs',
          'to' => 'lib/SDL/Pango.xs'
        },
        'libraries' => [
          'SDL',
          'SDL_Pango'
        ]
      },
      'MixerSamples' => {
        'file' => {
          'from' => 'src/Mixer/Samples.xs',
          'to' => 'lib/SDL/Mixer/Samples.xs'
        },
        'libraries' => [
          'SDL',
          'SDL_mixer'
        ]
      },
      'SDL' => {
        'libraries' => [
          'SDL'
        ],
        'file' => {
          'to' => 'lib/SDL_perl.xs',
          'from' => 'src/SDL.xs'
        }
      },
      'FPSManager' => {
        'file' => {
          'to' => 'lib/SDL/GFX/FPSManager.xs',
          'from' => 'src/GFX/FPSManager.xs'
        },
        'libraries' => [
          'SDL',
          'SDL_gfx_framerate'
        ]
      },
      'Primitives' => {
        'file' => {
          'from' => 'src/GFX/Primitives.xs',
          'to' => 'lib/SDL/GFX/Primitives.xs'
        },
        'libraries' => [
          'SDL',
          'SDL_gfx_primitives'
        ]
      },
      'Color' => {
        'libraries' => [
          'SDL'
        ],
        'file' => {
          'to' => 'lib/SDL/Color.xs',
          'from' => 'src/Core/objects/Color.xs'
        }
      },
      'Image' => {
        'libraries' => [
          'SDL',
          'SDL_image'
        ],
        'file' => {
          'to' => 'lib/SDL/Image.xs',
          'from' => 'src/Image.xs'
        }
      },
      'PixelFormat' => {
        'libraries' => [
          'SDL'
        ],
        'file' => {
          'from' => 'src/Core/objects/PixelFormat.xs',
          'to' => 'lib/SDL/PixelFormat.xs'
        }
      },
      'BlitFunc' => {
        'libraries' => [
          'SDL',
          'SDL_gfx_blitfunc'
        ],
        'file' => {
          'to' => 'lib/SDL/GFX/BlitFunc.xs',
          'from' => 'src/GFX/BlitFunc.xs'
        }
      },
      'Rotozoom' => {
        'libraries' => [
          'SDL',
          'SDL_gfx_rotozoom'
        ],
        'file' => {
          'to' => 'lib/SDL/GFX/Rotozoom.xs',
          'from' => 'src/GFX/Rotozoom.xs'
        }
      },
      'MixerChannels' => {
        'file' => {
          'to' => 'lib/SDL/Mixer/Channels.xs',
          'from' => 'src/Mixer/Channels.xs'
        },
        'libraries' => [
          'SDL',
          'SDL_mixer'
        ]
      },
      'Video' => {
        'libraries' => [
          'SDL'
        ],
        'file' => {
          'to' => 'lib/SDL/Video.xs',
          'from' => 'src/Core/Video.xs'
        }
      },
      'StateX' => {
        'libraries' => [
          'SDL'
        ],
        'file' => {
          'from' => 'src/SDLx/Controller/State.xs',
          'to' => 'lib/SDLx/Controller/State.xs'
        }
      },
      'LayerX' => {
        'file' => {
          'to' => 'lib/SDLx/Layer.xs',
          'from' => 'src/SDLx/Layer.xs'
        },
        'libraries' => [
          'SDL',
          'SDL_image'
        ]
      },
      'Surface' => {
        'file' => {
          'from' => 'src/Core/objects/Surface.xs',
          'to' => 'lib/SDL/Surface.xs'
        },
        'libraries' => [
          'SDL'
        ]
      },
      'Joystick' => {
        'libraries' => [
          'SDL'
        ],
        'file' => {
          'from' => 'src/Core/Joystick.xs',
          'to' => 'lib/SDL/Joystick.xs'
        }
      },
      'MixChunk' => {
        'libraries' => [
          'SDL',
          'SDL_mixer'
        ],
        'file' => {
          'from' => 'src/Mixer/objects/MixChunk.xs',
          'to' => 'lib/SDL/Mixer/MixChunk.xs'
        }
      },
      'GFX' => {
        'libraries' => [
          'SDL',
          'SDL_gfx_primitives'
        ],
        'file' => {
          'from' => 'src/GFX/GFX.xs',
          'to' => 'lib/SDL/GFX.xs'
        }
      },
      'Framerate' => {
        'file' => {
          'from' => 'src/GFX/Framerate.xs',
          'to' => 'lib/SDL/GFX/Framerate.xs'
        },
        'libraries' => [
          'SDL',
          'SDL_gfx_framerate'
        ]
      },
      'MixerMusic' => {
        'libraries' => [
          'SDL',
          'SDL_mixer'
        ],
        'file' => {
          'from' => 'src/Mixer/Music.xs',
          'to' => 'lib/SDL/Mixer/Music.xs'
        }
      },
      'Event' => {
        'file' => {
          'to' => 'lib/SDL/Event.xs',
          'from' => 'src/Core/objects/Event.xs'
        },
        'libraries' => [
          'SDL'
        ]
      },
      'CDTrack' => {
        'file' => {
          'from' => 'src/Core/objects/CDTrack.xs',
          'to' => 'lib/SDL/CDTrack.xs'
        },
        'libraries' => [
          'SDL'
        ]
      },
      'AudioCVT' => {
        'libraries' => [
          'SDL'
        ],
        'file' => {
          'to' => 'lib/SDL/AudioCVT.xs',
          'from' => 'src/Core/objects/AudioCVT.xs'
        }
      },
      'MixerEffects' => {
        'libraries' => [
          'SDL',
          'SDL_mixer'
        ],
        'file' => {
          'to' => 'lib/SDL/Mixer/Effects.xs',
          'from' => 'src/Mixer/Effects.xs'
        }
      },
      'CD' => {
        'libraries' => [
          'SDL'
        ],
        'file' => {
          'from' => 'src/Core/objects/CD.xs',
          'to' => 'lib/SDL/CD.xs'
        }
      },
      'CDROM' => {
        'libraries' => [
          'SDL'
        ],
        'file' => {
          'from' => 'src/Core/CDROM.xs',
          'to' => 'lib/SDL/CDROM.xs'
        }
      },
      'SurfaceX' => {
        'file' => {
          'to' => 'lib/SDLx/Surface.xs',
          'from' => 'src/SDLx/Surface.xs'
        },
        'libraries' => [
          'SDL',
          'SDL_gfx_primitives'
        ]
      },
      'InterfaceX' => {
        'file' => {
          'from' => 'src/SDLx/Controller/Interface.xs',
          'to' => 'lib/SDLx/Controller/Interface.xs'
        },
        'libraries' => [
          'SDL'
        ]
      },
      'Time' => {
        'file' => {
          'to' => 'lib/SDL/Time.xs',
          'from' => 'src/Core/Time.xs'
        },
        'libraries' => [
          'SDL'
        ]
      },
      'Audio' => {
        'file' => {
          'to' => 'lib/SDL/Audio.xs',
          'from' => 'src/Core/Audio.xs'
        },
        'libraries' => [
          'SDL'
        ]
      },
      'Palette' => {
        'file' => {
          'to' => 'lib/SDL/Palette.xs',
          'from' => 'src/Core/objects/Palette.xs'
        },
        'libraries' => [
          'SDL'
        ]
      },
      'Mixer' => {
        'libraries' => [
          'SDL',
          'SDL_mixer'
        ],
        'file' => {
          'from' => 'src/Mixer/Mixer.xs',
          'to' => 'lib/SDL/Mixer.xs'
        }
      },
      'MultiThread' => {
        'libraries' => [
          'SDL'
        ],
        'file' => {
          'to' => 'lib/SDL/MultiThread.xs',
          'from' => 'src/Core/MultiThread.xs'
        }
      },
      'TimerX' => {
        'libraries' => [
          'SDL'
        ],
        'file' => {
          'from' => 'src/SDLx/Timer.xs',
          'to' => 'lib/SDLx/Controller/Timer.xs'
        }
      },
      'ValidateX' => {
        'libraries' => [
          'SDL'
        ],
        'file' => {
          'from' => 'src/SDLx/Validate.xs',
          'to' => 'lib/SDLx/Validate.xs'
        }
      },
      'SFont' => {
        'file' => {
          'to' => 'lib/SDLx/SFont.xs',
          'from' => 'src/SDLx/SFont.xs'
        },
        'libraries' => [
          'SDL',
          'SDL_image'
        ]
      },
      'Overlay' => {
        'file' => {
          'to' => 'lib/SDL/Overlay.xs',
          'from' => 'src/Core/objects/Overlay.xs'
        },
        'libraries' => [
          'SDL'
        ]
      },
      'MixMusic' => {
        'file' => {
          'to' => 'lib/SDL/Mixer/MixMusic.xs',
          'from' => 'src/Mixer/objects/MixMusic.xs'
        },
        'libraries' => [
          'SDL',
          'SDL_mixer'
        ]
      },
      'Rect' => {
        'libraries' => [
          'SDL'
        ],
        'file' => {
          'from' => 'src/Core/objects/Rect.xs',
          'to' => 'lib/SDL/Rect.xs'
        }
      },
      'TTF' => {
        'libraries' => [
          'SDL',
          'SDL_ttf'
        ],
        'file' => {
          'to' => 'lib/SDL/TTF.xs',
          'from' => 'src/TTF/TTF.xs'
        }
      },
      'RWOps' => {
        'file' => {
          'from' => 'src/Core/objects/RWOps.xs',
          'to' => 'lib/SDL/RWOps.xs'
        },
        'libraries' => [
          'SDL'
        ]
      },
      'Version' => {
        'libraries' => [
          'SDL'
        ],
        'file' => {
          'to' => 'lib/SDL/Version.xs',
          'from' => 'src/Core/objects/Version.xs'
        }
      },
      'LayerManagerX' => {
        'libraries' => [
          'SDL'
        ],
        'file' => {
          'from' => 'src/SDLx/LayerManager.xs',
          'to' => 'lib/SDLx/LayerManager.xs'
        }
      },
      'Mouse' => {
        'libraries' => [
          'SDL'
        ],
        'file' => {
          'from' => 'src/Core/Mouse.xs',
          'to' => 'lib/SDL/Mouse.xs'
        }
      },
      'Events' => {
        'libraries' => [
          'SDL'
        ],
        'file' => {
          'to' => 'lib/SDL/Events.xs',
          'from' => 'src/Core/Events.xs'
        }
      },
      'VideoInfo' => {
        'libraries' => [
          'SDL'
        ],
        'file' => {
          'from' => 'src/Core/objects/VideoInfo.xs',
          'to' => 'lib/SDL/VideoInfo.xs'
        }
      },
      'TTF_Font' => {
        'file' => {
          'to' => 'lib/SDL/TTF/Font.xs',
          'from' => 'src/TTF/objects/Font.xs'
        },
        'libraries' => [
          'SDL',
          'SDL_ttf'
        ]
      },
      'Context' => {
        'file' => {
          'to' => 'lib/SDL/Pango/Context.xs',
          'from' => 'src/Pango/objects/Context.xs'
        },
        'libraries' => [
          'SDL',
          'SDL_Pango'
        ]
      },
      'MixerGroups' => {
        'libraries' => [
          'SDL',
          'SDL_mixer'
        ],
        'file' => {
          'from' => 'src/Mixer/Groups.xs',
          'to' => 'lib/SDL/Mixer/Groups.xs'
        }
      }
    },
    'SDL_lib_translate' => {
      'SDL::Events' => [
        'SDL'
      ],
      'SDL::TTF::Font' => [
        'SDL',
        'SDL_ttf'
      ],
      'SDL::AudioCVT' => [
        'SDL'
      ],
      'SDL::Palette' => [
        'SDL'
      ],
      'SDL::Image' => [
        'SDL',
        'SDL_image'
      ],
      'SDL::MultiThread' => [
        'SDL'
      ],
      'SDL::PixelFormat' => [
        'SDL'
      ],
      'SDL::Joystick' => [
        'SDL'
      ],
      'SDLx::Surface' => [
        'SDL',
        'SDL_gfx'
      ],
      'SDL::AudioSpec' => [
        'SDL'
      ],
      'SDL_perl' => [
        'SDL'
      ],
      'SDLx::SFont' => [
        'SDL',
        'SDL_image'
      ],
      'SDLx::Controller::Interface' => [
        'SDL'
      ],
      'SDL::Mixer::MixChunk' => [
        'SDL',
        'SDL_mixer'
      ],
      'SDLx::Validate' => [
        'SDL'
      ],
      'SDL::Event' => [
        'SDL'
      ],
      'SDL::RWOps' => [
        'SDL'
      ],
      'SDL::Mixer::MixMusic' => [
        'SDL',
        'SDL_mixer'
      ],
      'SDLx::Controller::Timer' => [
        'SDL'
      ],
      'SDL::GFX' => [
        'SDL',
        'SDL_gfx'
      ],
      'SDL::Mixer::Effects' => [
        'SDL',
        'SDL_mixer'
      ],
      'SDL::Overlay' => [
        'SDL'
      ],
      'SDL::GFX::BlitFunc' => [
        'SDL',
        'SDL_gfx'
      ],
      'SDL::GFX::Framerate' => [
        'SDL',
        'SDL_gfx'
      ],
      'SDL::Mixer::Music' => [
        'SDL',
        'SDL_mixer'
      ],
      'SDL::GFX::Rotozoom' => [
        'SDL',
        'SDL_gfx'
      ],
      'SDLx::Layer' => [
        'SDL',
        'SDL_image'
      ],
      'SDLx::Controller::State' => [
        'SDL'
      ],
      'SDL::Surface' => [
        'SDL'
      ],
      'SDL::Mixer::Groups' => [
        'SDL',
        'SDL_mixer'
      ],
      'SDL::Time' => [
        'SDL'
      ],
      'SDLx::LayerManager' => [
        'SDL'
      ],
      'SDL::CD' => [
        'SDL'
      ],
      'SDL::Pango::Context' => [
        'SDL',
        'SDL_Pango'
      ],
      'SDL::CDROM' => [
        'SDL'
      ],
      'SDL::Video' => [
        'SDL'
      ],
      'SDL::Pango' => [
        'SDL',
        'SDL_Pango'
      ],
      'SDL::Color' => [
        'SDL'
      ],
      'SDL::Version' => [
        'SDL'
      ],
      'SDL::GFX::Primitives' => [
        'SDL',
        'SDL_gfx'
      ],
      'SDL::VideoInfo' => [
        'SDL'
      ],
      'SDL::TTF' => [
        'SDL',
        'SDL_ttf'
      ],
      'SDL::Rect' => [
        'SDL'
      ],
      'SDL::CDTrack' => [
        'SDL'
      ],
      'SDL::Mixer::Channels' => [
        'SDL',
        'SDL_mixer'
      ],
      'SDL::Audio' => [
        'SDL'
      ],
      'SDL::Mixer' => [
        'SDL',
        'SDL_mixer'
      ],
      'SDL::Mouse' => [
        'SDL'
      ],
      'SDL::GFX::ImageFilter' => [
        'SDL',
        'SDL_gfx'
      ],
      'SDL::GFX::FPSManager' => [
        'SDL',
        'SDL_gfx'
      ],
      'SDL::Mixer::Samples' => [
        'SDL',
        'SDL_mixer'
      ],
      'SDL::Cursor' => [
        'SDL'
      ]
    },
    'libraries' => {
      'SDL_gfx_rotozoom' => {
        'lib' => 'SDL_gfx',
        'define' => 'HAVE_SDL_GFX_ROTOZOOM',
        'header' => 'SDL_rotozoom.h'
      },
      'SDL_ttf' => {
        'define' => 'HAVE_SDL_TTF',
        'lib' => 'SDL_ttf',
        'header' => 'SDL_ttf.h'
      },
      'SDL_gfx_imagefilter' => {
        'define' => 'HAVE_SDL_GFX_IMAGEFILTER',
        'lib' => 'SDL_gfx',
        'header' => 'SDL_imageFilter.h'
      },
      'tiff' => {
        'lib' => 'tiff',
        'define' => 'HAVE_TIFF',
        'header' => 'tiff.h'
      },
      'SDL_gfx_framerate' => {
        'header' => 'SDL_framerate.h',
        'lib' => 'SDL_gfx',
        'define' => 'HAVE_SDL_GFX_FRAMERATE'
      },
      'png' => {
        'header' => 'png.h',
        'define' => 'HAVE_PNG',
        'lib' => 'png'
      },
      'smpeg' => {
        'define' => 'HAVE_SMPEG',
        'lib' => 'smpeg',
        'header' => 'smpeg/smpeg.h'
      },
      'GL' => {
        'define' => 'HAVE_GL',
        'lib' => 'GL',
        'header' => [
          'GL/gl.h',
          'GL/glext.h'
        ]
      },
      'SDL_gfx' => {
        'header' => 'SDL_gfxPrimitives.h',
        'lib' => 'SDL_gfx',
        'define' => 'HAVE_SDL_GFX'
      },
      'GLU' => {
        'header' => 'GL/glu.h',
        'lib' => 'GLU',
        'define' => 'HAVE_GLU'
      },
      'SDL' => {
        'header' => 'SDL.h',
        'lib' => 'SDL',
        'define' => 'HAVE_SDL'
      },
      'jpeg' => {
        'header' => 'jpeglib.h',
        'define' => 'HAVE_JPEG',
        'lib' => 'jpeg'
      },
      'SDL_Pango' => {
        'header' => 'SDL_Pango.h',
        'define' => 'HAVE_SDL_PANGO',
        'lib' => 'SDL_Pango'
      },
      'SDL_mixer' => {
        'define' => 'HAVE_SDL_MIXER',
        'lib' => 'SDL_mixer',
        'header' => 'SDL_mixer.h'
      },
      'SDL_gfx_primitives' => {
        'header' => 'SDL_gfxPrimitives.h',
        'define' => 'HAVE_SDL_GFX_PRIMITIVES',
        'lib' => 'SDL_gfx'
      },
      'SDL_gfx_blitfunc' => {
        'header' => 'SDL_gfxBlitFunc.h',
        'define' => 'HAVE_SDL_GFX_BLITFUNC',
        'lib' => 'SDL_gfx'
      },
      'SDL_image' => {
        'lib' => 'SDL_image',
        'define' => 'HAVE_SDL_IMAGE',
        'header' => 'SDL_image.h'
      }
    },
    'SDL_cfg' => {
      'MixerGroups' => {
        'links' => [
          '-lSDL',
          '-lSDL_mixer'
        ],
        'libs' => {
          'SDL' => 1,
          'SDL_mixer' => 1
        },
        'defines' => [
          '-DHAVE_SDL',
          '-DHAVE_SDL_MIXER'
        ]
      },
      'Context' => {
        'libs' => {
          'SDL_Pango' => 1,
          'SDL' => 1
        },
        'defines' => [
          '-DHAVE_SDL',
          '-DHAVE_SDL_PANGO'
        ],
        'links' => [
          '-lSDL',
          '-lSDL_Pango'
        ]
      },
      'VideoInfo' => {
        'links' => [
          '-lSDL'
        ],
        'libs' => {
          'SDL' => 1
        },
        'defines' => [
          '-DHAVE_SDL'
        ]
      },
      'TTF_Font' => {
        'libs' => {
          'SDL_ttf' => 1,
          'SDL' => 1
        },
        'defines' => [
          '-DHAVE_SDL',
          '-DHAVE_SDL_TTF'
        ],
        'links' => [
          '-lSDL',
          '-lSDL_ttf'
        ]
      },
      'Events' => {
        'links' => [
          '-lSDL'
        ],
        'defines' => [
          '-DHAVE_SDL'
        ],
        'libs' => {
          'SDL' => 1
        }
      },
      'Mouse' => {
        'libs' => {
          'SDL' => 1
        },
        'defines' => [
          '-DHAVE_SDL'
        ],
        'links' => [
          '-lSDL'
        ]
      },
      'LayerManagerX' => {
        'links' => [
          '-lSDL'
        ],
        'libs' => {
          'SDL' => 1
        },
        'defines' => [
          '-DHAVE_SDL'
        ]
      },
      'Version' => {
        'links' => [
          '-lSDL'
        ],
        'defines' => [
          '-DHAVE_SDL'
        ],
        'libs' => {
          'SDL' => 1
        }
      },
      'RWOps' => {
        'libs' => {
          'SDL' => 1
        },
        'defines' => [
          '-DHAVE_SDL'
        ],
        'links' => [
          '-lSDL'
        ]
      },
      'TTF' => {
        'libs' => {
          'SDL_ttf' => 1,
          'SDL' => 1
        },
        'defines' => [
          '-DHAVE_SDL',
          '-DHAVE_SDL_TTF'
        ],
        'links' => [
          '-lSDL',
          '-lSDL_ttf'
        ]
      },
      'Rect' => {
        'links' => [
          '-lSDL'
        ],
        'defines' => [
          '-DHAVE_SDL'
        ],
        'libs' => {
          'SDL' => 1
        }
      },
      'MixMusic' => {
        'libs' => {
          'SDL_mixer' => 1,
          'SDL' => 1
        },
        'defines' => [
          '-DHAVE_SDL',
          '-DHAVE_SDL_MIXER'
        ],
        'links' => [
          '-lSDL',
          '-lSDL_mixer'
        ]
      },
      'Overlay' => {
        'links' => [
          '-lSDL'
        ],
        'libs' => {
          'SDL' => 1
        },
        'defines' => [
          '-DHAVE_SDL'
        ]
      },
      'SFont' => {
        'links' => [
          '-lSDL',
          '-lSDL_image'
        ],
        'libs' => {
          'SDL' => 1,
          'SDL_image' => 1
        },
        'defines' => [
          '-DHAVE_SDL',
          '-DHAVE_SDL_IMAGE'
        ]
      },
      'ValidateX' => {
        'defines' => [
          '-DHAVE_SDL'
        ],
        'libs' => {
          'SDL' => 1
        },
        'links' => [
          '-lSDL'
        ]
      },
      'TimerX' => {
        'links' => [
          '-lSDL'
        ],
        'defines' => [
          '-DHAVE_SDL'
        ],
        'libs' => {
          'SDL' => 1
        }
      },
      'MultiThread' => {
        'links' => [
          '-lSDL'
        ],
        'libs' => {
          'SDL' => 1
        },
        'defines' => [
          '-DHAVE_SDL'
        ]
      },
      'Palette' => {
        'defines' => [
          '-DHAVE_SDL'
        ],
        'libs' => {
          'SDL' => 1
        },
        'links' => [
          '-lSDL'
        ]
      },
      'Mixer' => {
        'links' => [
          '-lSDL',
          '-lSDL_mixer'
        ],
        'libs' => {
          'SDL_mixer' => 1,
          'SDL' => 1
        },
        'defines' => [
          '-DHAVE_SDL',
          '-DHAVE_SDL_MIXER'
        ]
      },
      'Audio' => {
        'defines' => [
          '-DHAVE_SDL'
        ],
        'libs' => {
          'SDL' => 1
        },
        'links' => [
          '-lSDL'
        ]
      },
      'Time' => {
        'links' => [
          '-lSDL'
        ],
        'libs' => {
          'SDL' => 1
        },
        'defines' => [
          '-DHAVE_SDL'
        ]
      },
      'SurfaceX' => {
        'links' => [
          '-lSDL',
          '-lSDL_gfx'
        ],
        'libs' => {
          'SDL_gfx_primitives' => 1,
          'SDL' => 1
        },
        'defines' => [
          '-DHAVE_SDL',
          '-DHAVE_SDL_GFX_PRIMITIVES'
        ]
      },
      'InterfaceX' => {
        'defines' => [
          '-DHAVE_SDL'
        ],
        'libs' => {
          'SDL' => 1
        },
        'links' => [
          '-lSDL'
        ]
      },
      'CDROM' => {
        'links' => [
          '-lSDL'
        ],
        'libs' => {
          'SDL' => 1
        },
        'defines' => [
          '-DHAVE_SDL'
        ]
      },
      'MixerEffects' => {
        'links' => [
          '-lSDL',
          '-lSDL_mixer'
        ],
        'defines' => [
          '-DHAVE_SDL',
          '-DHAVE_SDL_MIXER'
        ],
        'libs' => {
          'SDL' => 1,
          'SDL_mixer' => 1
        }
      },
      'CD' => {
        'defines' => [
          '-DHAVE_SDL'
        ],
        'libs' => {
          'SDL' => 1
        },
        'links' => [
          '-lSDL'
        ]
      },
      'Event' => {
        'links' => [
          '-lSDL'
        ],
        'libs' => {
          'SDL' => 1
        },
        'defines' => [
          '-DHAVE_SDL'
        ]
      },
      'CDTrack' => {
        'links' => [
          '-lSDL'
        ],
        'defines' => [
          '-DHAVE_SDL'
        ],
        'libs' => {
          'SDL' => 1
        }
      },
      'AudioCVT' => {
        'libs' => {
          'SDL' => 1
        },
        'defines' => [
          '-DHAVE_SDL'
        ],
        'links' => [
          '-lSDL'
        ]
      },
      'MixerMusic' => {
        'links' => [
          '-lSDL',
          '-lSDL_mixer'
        ],
        'defines' => [
          '-DHAVE_SDL',
          '-DHAVE_SDL_MIXER'
        ],
        'libs' => {
          'SDL_mixer' => 1,
          'SDL' => 1
        }
      },
      'Framerate' => {
        'links' => [
          '-lSDL',
          '-lSDL_gfx'
        ],
        'defines' => [
          '-DHAVE_SDL',
          '-DHAVE_SDL_GFX_FRAMERATE'
        ],
        'libs' => {
          'SDL' => 1,
          'SDL_gfx_framerate' => 1
        }
      },
      'GFX' => {
        'links' => [
          '-lSDL',
          '-lSDL_gfx'
        ],
        'libs' => {
          'SDL_gfx_primitives' => 1,
          'SDL' => 1
        },
        'defines' => [
          '-DHAVE_SDL',
          '-DHAVE_SDL_GFX_PRIMITIVES'
        ]
      },
      'Joystick' => {
        'libs' => {
          'SDL' => 1
        },
        'defines' => [
          '-DHAVE_SDL'
        ],
        'links' => [
          '-lSDL'
        ]
      },
      'Surface' => {
        'links' => [
          '-lSDL'
        ],
        'defines' => [
          '-DHAVE_SDL'
        ],
        'libs' => {
          'SDL' => 1
        }
      },
      'MixChunk' => {
        'defines' => [
          '-DHAVE_SDL',
          '-DHAVE_SDL_MIXER'
        ],
        'libs' => {
          'SDL' => 1,
          'SDL_mixer' => 1
        },
        'links' => [
          '-lSDL',
          '-lSDL_mixer'
        ]
      },
      'StateX' => {
        'libs' => {
          'SDL' => 1
        },
        'defines' => [
          '-DHAVE_SDL'
        ],
        'links' => [
          '-lSDL'
        ]
      },
      'LayerX' => {
        'defines' => [
          '-DHAVE_SDL',
          '-DHAVE_SDL_IMAGE'
        ],
        'libs' => {
          'SDL_image' => 1,
          'SDL' => 1
        },
        'links' => [
          '-lSDL',
          '-lSDL_image'
        ]
      },
      'Video' => {
        'links' => [
          '-lSDL'
        ],
        'libs' => {
          'SDL' => 1
        },
        'defines' => [
          '-DHAVE_SDL'
        ]
      },
      'BlitFunc' => {
        'links' => [
          '-lSDL',
          '-lSDL_gfx'
        ],
        'defines' => [
          '-DHAVE_SDL',
          '-DHAVE_SDL_GFX_BLITFUNC'
        ],
        'libs' => {
          'SDL_gfx_blitfunc' => 1,
          'SDL' => 1
        }
      },
      'PixelFormat' => {
        'libs' => {
          'SDL' => 1
        },
        'defines' => [
          '-DHAVE_SDL'
        ],
        'links' => [
          '-lSDL'
        ]
      },
      'MixerChannels' => {
        'libs' => {
          'SDL' => 1,
          'SDL_mixer' => 1
        },
        'defines' => [
          '-DHAVE_SDL',
          '-DHAVE_SDL_MIXER'
        ],
        'links' => [
          '-lSDL',
          '-lSDL_mixer'
        ]
      },
      'Rotozoom' => {
        'libs' => {
          'SDL' => 1,
          'SDL_gfx_rotozoom' => 1
        },
        'defines' => [
          '-DHAVE_SDL',
          '-DHAVE_SDL_GFX_ROTOZOOM'
        ],
        'links' => [
          '-lSDL',
          '-lSDL_gfx'
        ]
      },
      'Image' => {
        'defines' => [
          '-DHAVE_SDL',
          '-DHAVE_SDL_IMAGE'
        ],
        'libs' => {
          'SDL' => 1,
          'SDL_image' => 1
        },
        'links' => [
          '-lSDL',
          '-lSDL_image'
        ]
      },
      'Primitives' => {
        'links' => [
          '-lSDL',
          '-lSDL_gfx'
        ],
        'libs' => {
          'SDL' => 1,
          'SDL_gfx_primitives' => 1
        },
        'defines' => [
          '-DHAVE_SDL',
          '-DHAVE_SDL_GFX_PRIMITIVES'
        ]
      },
      'Color' => {
        'libs' => {
          'SDL' => 1
        },
        'defines' => [
          '-DHAVE_SDL'
        ],
        'links' => [
          '-lSDL'
        ]
      },
      'FPSManager' => {
        'links' => [
          '-lSDL',
          '-lSDL_gfx'
        ],
        'defines' => [
          '-DHAVE_SDL',
          '-DHAVE_SDL_GFX_FRAMERATE'
        ],
        'libs' => {
          'SDL' => 1,
          'SDL_gfx_framerate' => 1
        }
      },
      'SDL' => {
        'links' => [
          '-lSDL'
        ],
        'defines' => [
          '-DHAVE_SDL'
        ],
        'libs' => {
          'SDL' => 1
        }
      },
      'MixerSamples' => {
        'links' => [
          '-lSDL',
          '-lSDL_mixer'
        ],
        'libs' => {
          'SDL' => 1,
          'SDL_mixer' => 1
        },
        'defines' => [
          '-DHAVE_SDL',
          '-DHAVE_SDL_MIXER'
        ]
      },
      'Pango' => {
        'defines' => [
          '-DHAVE_SDL',
          '-DHAVE_SDL_PANGO'
        ],
        'libs' => {
          'SDL_Pango' => 1,
          'SDL' => 1
        },
        'links' => [
          '-lSDL',
          '-lSDL_Pango'
        ]
      },
      'ImageFilter' => {
        'libs' => {
          'SDL_gfx_imagefilter' => 1,
          'SDL' => 1
        },
        'defines' => [
          '-DHAVE_SDL',
          '-DHAVE_SDL_GFX_IMAGEFILTER'
        ],
        'links' => [
          '-lSDL',
          '-lSDL_gfx'
        ]
      },
      'Cursor' => {
        'libs' => {
          'SDL' => 1
        },
        'defines' => [
          '-DHAVE_SDL'
        ],
        'links' => [
          '-lSDL'
        ]
      },
      'AudioSpec' => {
        'links' => [
          '-lSDL'
        ],
        'defines' => [
          '-DHAVE_SDL'
        ],
        'libs' => {
          'SDL' => 1
        }
      }
    }
  },
  {},
  {}
];
$x; }