CREATE TABLE IF NOT EXISTS packages (
  `id` INTEGER PRIMARY KEY ASC ,
  `name` TEXT NOT NULL ,
  `version` TEXT NOT NULL ,
  `epoch` INTEGER NULL DEFAULT 0 ,
  `filename` TEXT NOT NULL ,
  `description` TEXT NOT NULL ,
  `size` INTEGER NOT NULL ,
  `installedsize` INTEGER NULL DEFAULT NULL ,
  `md5sum` VARCHAR(32) NOT NULL ,
  `url` TEXT NULL DEFAULT NULL ,
  `builddate` INTEGER NULL DEFAULT NULL ,
  `arch` TEXT NOT NULL ,
  `packager` TEXT NOT NULL ,
  `flags` TEXT NULL DEFAULT NULL ,
  `screenshoturl` TEXT NULL DEFAULT NULL ,
  `installreason` INTEGER NULL DEFAULT 0,
  `installdate` INTEGER NULL DEFAULT NULL,
  `gitrepository` TEXT NULL DEFAULT NULL,
  `gitbranch` TEXT NULL DEFAULT 'master',
  `gitfolder` TEXT NULL DEFAULT NULL);

CREATE INDEX `packages_name` ON `packages` (`name` ASC) ;

CREATE  TABLE IF NOT EXISTS `files` (
  `id` INTEGER PRIMARY KEY ASC ,
  `package` INTEGER NOT NULL ,
  `file` TEXT NOT NULL ,
  `backup` TEXT NULL DEFAULT NULL ,
  `ultimateowner` INTEGER NULL DEFAULT 0 ,
  CONSTRAINT `fk_files_packages`
    FOREIGN KEY (`package` )
    REFERENCES `packages` (`id` ) );

CREATE  TABLE IF NOT EXISTS `scriptlets` (
  `id` INTEGER PRIMARY KEY ASC ,
  `package` INTEGER NOT NULL ,
  `scriptlet` TEXT NOT NULL ,
  CONSTRAINT `fk_scriptlets_packages`
    FOREIGN KEY (`package` )
    REFERENCES `packages` (`id` ) );

CREATE  TABLE IF NOT EXISTS `hooks` (
  `name` TEXT PRIMARY KEY ,
  `hook` TEXT NOT NULL );

CREATE  TABLE IF NOT EXISTS `groups` (
  `id` INTEGER PRIMARY KEY ASC ,
  `name` TEXT NOT NULL,
  `description` TEXT NULL DEFAULT NULL ,
  `icon` TEXT NULL DEFAULT NULL);

CREATE  TABLE IF NOT EXISTS `deltas` (
  `id` INTEGER PRIMARY KEY ASC ,
  `package` INTEGER NOT NULL ,
  `filename` TEXT NOT NULL ,
  `versionfrom` TEXT NOT NULL ,
  `versionto` TEXT NOT NULL ,
  `md5sum` VARCHAR(32) NOT NULL ,
  CONSTRAINT `fk_deltas_packages`
    FOREIGN KEY (`package` )
    REFERENCES `packages` (`id` ) );

CREATE  TABLE IF NOT EXISTS `depends` (
  `id` INTEGER PRIMARY KEY ASC ,
  `package` INTEGER NOT NULL ,
  `dependency` TEXT NOT NULL ,
  CONSTRAINT `fk_requires_package`
    FOREIGN KEY (`package` )
    REFERENCES `packages` (`id` )
    ON UPDATE CASCADE);

CREATE TABLE IF NOT EXISTS `makedepends` (
  `id` INTEGER PRIMARY KEY ASC ,
  `package` INTEGER NOT NULL ,
  `dependency` TEXT NOT NULL,
  CONSTRAINT `fk_requires_package`
    FOREIGN KEY (`package` )
    REFERENCES `packages` (`id` )
    ON UPDATE CASCADE);

CREATE  TABLE IF NOT EXISTS `conflicts` (
  `id` INTEGER PRIMARY KEY ASC ,
  `package` INTEGER NOT NULL ,
  `conflict` TEXT NOT NULL ,
  CONSTRAINT `fk_conflicts_package`
    FOREIGN KEY (`package` )
    REFERENCES `packages` (`id` )
    ON UPDATE CASCADE);

CREATE  TABLE IF NOT EXISTS `provides` (
  `id` INTEGER PRIMARY KEY ASC ,
  `package` INTEGER NOT NULL ,
  `provides` TEXT NOT NULL ,
  CONSTRAINT `fk_provides_package`
    FOREIGN KEY (`package` )
    REFERENCES `packages` (`id` ) );

CREATE  TABLE IF NOT EXISTS `optional` (
  `id` INTEGER PRIMARY KEY ASC ,
  `package` INTEGER NOT NULL ,
  `dependency` TEXT NOT NULL ,
  CONSTRAINT `fk_optional_package`
    FOREIGN KEY (`package` )
    REFERENCES `packages` (`id` ) );

CREATE  TABLE IF NOT EXISTS `replaces` (
  `id` INTEGER PRIMARY KEY ASC ,
  `package` INTEGER NOT NULL ,
  `replaces` TEXT NOT NULL ,
  CONSTRAINT `fk_replaces_package`
    FOREIGN KEY (`package` )
    REFERENCES `packages` (`id` ) );

CREATE  TABLE IF NOT EXISTS `providesmimetype` (
  `id` INTEGER PRIMARY KEY ASC ,
  `package` INTEGER NOT NULL ,
  `mimetype` TEXT NOT NULL ,
  CONSTRAINT `fk_providesmimetype_package`
    FOREIGN KEY (`package` )
    REFERENCES `packages` (`id` ) );

CREATE  TABLE IF NOT EXISTS `belongsgroup` (
  `package` INTEGER NOT NULL ,
  `groupname` TEXT NOT NULL ,
  CONSTRAINT `fk_belongs_packages`
    FOREIGN KEY (`package` )
    REFERENCES `packages` (`id` ));

CREATE  TABLE IF NOT EXISTS `belongshook` (
  `package` INTEGER NOT NULL ,
  `hookname` TEXT NOT NULL ,
  CONSTRAINT `fk_hooks_packages`
    FOREIGN KEY (`package` )
    REFERENCES `packages` (`id` ) );

CREATE  TABLE IF NOT EXISTS `licensed` (
  `package` INTEGER NOT NULL ,
  `license` TEXT NOT NULL ,
  CONSTRAINT `fk_license_packages`
    FOREIGN KEY (`package` )
    REFERENCES `packages` (`id` ) );