/* This file is part of the Chakra project

   Copyright (C) 2010 Dario Freddi <drf@chakra-project.org>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
*/

#ifndef AKABEI_AKABEIPLAINSCRIPTLETOPERATION_H
#define AKABEI_AKABEIPLAINSCRIPTLETOPERATION_H

#include <akabeioperation.h>
#include <akabeicore_global.h>
#include <QStringList>

namespace Akabei {
class Package;

class AKABEICORESHARED_EXPORT PlainScriptletOperation : public Operation
{
    Q_OBJECT
    public:
        PlainScriptletOperation(Package *p, const QStringList &args = QStringList());
        virtual ~PlainScriptletOperation();


    protected:
        virtual void run() override;
        virtual void validate() override;

    private Q_SLOTS:
        void slotFinished(bool fin);
        void slotErrors(Akabei::Error::List errs);
        void slotMessage(const QString &mes);

    private:
        class Private;
        Private * const d;

        friend class ChrootedProcess;
};

}

#endif // AKABEI_AKABEIPLAINSCRIPTLETOPERATION_H
