/* This file is part of the Chakra project

   Copyright (C) 2010 Dario Freddi <drf@chakra-project.org>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
*/

#ifndef AKABEIPLAINREMOVEOPERATION_H
#define AKABEIPLAINREMOVEOPERATION_H

#include <akabeicore_global.h>
#include <akabeioperation.h>

namespace Akabei
{
class Package;

/**
 * @class PlainRemoveOperation
 * @brief Operation to remove a package from the system.
 */
class AKABEICORESHARED_EXPORT PlainRemoveOperation : public Akabei::Operation
{
    Q_DISABLE_COPY(PlainRemoveOperation)
public:
    explicit PlainRemoveOperation(Package *package);
    virtual ~PlainRemoveOperation();

protected:
    void validate() override;
    void run() override;

private:
    class Private;
    Private * const d;
};

}

#endif // AKABEIPLAINREMOVEOPERATION_H
