/*
    This Yara ruleset is under the GNU-GPLv2 license (http://www.gnu.org/licenses/gpl-2.0.html) and open to any user or organization, as    long as you use it under this license.

*/

/*
	Yara Rule Set
	Author: Florian Roth
	Date: 2016-02-17
	Identifier: Locky
*/

rule Locky_Ransomware : ransom {
	meta:
		description = "Detects Locky Ransomware (matches also on Win32/Kuluoz)"
		author = "Florian Roth (with the help of binar.ly)"
		reference = "https://goo.gl/qScSrE"
		date = "2016-02-17"
		hash = "5e945c1d27c9ad77a2b63ae10af46aee7d29a6a43605a9bfbf35cebbcff184d8"
	strings:
		$o1 = { 45 b8 99 f7 f9 0f af 45 b8 89 45 b8 } // address=0x4144a7
		$o2 = { 2b 0a 0f af 4d f8 89 4d f8 c7 45 } // address=0x413863
	condition:
		all of ($o*)
}

rule Locky_Ransomware_2: ransom {
meta:
    description = "Regla para detectar RANSOM.LOCKY"
    author = "CCN-CERT"
    version = "1.0"
strings:
    $a1 = { 2E 00 6C 00 6F 00 63 00 6B 00 79 00 00 }
    $a2 = { 00 5F 00 4C 00 6F 00 63 00 6B 00 79 00 }
    $a3 = { 5F 00 72 00 65 00 63 00 6F 00 76 00 65 }
    $a4 = { 00 72 00 5F 00 69 00 6E 00 73 00 74 00 }
    $a5 = { 72 00 75 00 63 00 74 00 69 00 6F 00 6E }
    $a6 = { 00 73 00 2E 00 74 00 78 00 74 00 00 }
    $a7 = { 53 6F 66 74 77 61 72 65 5C 4C 6F 63 6B 79 00 }
condition:
    all of them
}
