#
# This script was written by Renaud Deraison <deraison@cvs.nessus.org>
#
# See the Nessus Scripts License for details
#

if(description)
{
 script_id(10307);
 script_version ("$Revision: 1.13 $");
 script_cve_id("CAN-2000-0138");
 
 name["english"] = "Trin00 for Windows Detect";
 name["francais"] = "Detection de Trin00 pour Windows";
 
 script_name(english:name["english"], francais:name["francais"]);
 
 desc["english"] = "
The remote host appears to be running
Trin00 for Windows, which is a trojan that can be 
used to control your system or make it 
attack another network (this is 
actually called a distributed denial
of service attack tool).

It is very likely that this host
has been cracked.

Solution : Restore your system from backups,
	   contact CERT and your local
	   authorities.

Risk factor : Critical";



 desc["francais"] = "
Le systeme distant semble faire tourner
trin00 pour windows, qui peut etre utilis pour prendre 
le controle de celui-ci ou pour attaquer un 
autre rseau (outil de dni de service 
distribu)

Il est trs probable que ce systeme a t
compromis

Solution : reinstallez votre systme  partir
	   des sauvegardes, et contactez le CERT
	   et les autorits locales
	   
Facteur de risque : Critique";


 script_description(english:desc["english"], francais:desc["francais"]);
 
 summary["english"] = "Detects the presence of trin00";
 summary["francais"] = "Detecte la prsence de trin00";
 
 script_summary(english:summary["english"], francais:summary["francais"]);
 
 script_category(ACT_GATHER_INFO);
 
 
 script_copyright(english:"This script is Copyright (C) 2000 Renaud Deraison",
		francais:"Ce script est Copyright (C) 2000 Renaud Deraison");
 family["english"] = "Backdoors";
 family["francais"] = "Backdoors";
 script_family(english:family["english"], francais:family["francais"]);
 script_require_keys("Settings/ThoroughTests");

 
 exit(0);
}

#
# The script code starts here
#


include('global_settings.inc');

if ( ! thorough_tests ) exit(0);
if ( islocalhost() ) exit(0);

command = string("png []..Ks l44");
die = string("d1e []..Ks l44");

ip  = forge_ip_packet(ip_hl:5, ip_v:4,   ip_off:0,
                     ip_id:9, ip_tos:0, ip_p : IPPROTO_UDP,
                     ip_len : 20, ip_src : this_host(),
                     ip_ttl : 255);
		   
length = 8 + strlen(command);		     
udpip = forge_udp_packet(ip : ip,
		         uh_sport : 1024,    
                         uh_dport : 34555,
			 uh_ulen : length,
			 data : command);
		
trg = get_host_ip();
me  = this_host();
pf = string("udp and src host ", trg, " and dst host ", me, " and dst port 35555");
rep = send_packet(udpip, pcap_filter:pf, pcap_active:TRUE);			 	
if(rep)
{
  dstport = get_udp_element(udp:rep, element:"uh_dport");
  if(dstport == 35555)
  { 
   security_hole(port:34555, protocol:"udp");
   length = 8 + strlen(die);		     
   udpip2 = forge_udp_packet(ip : ip,
		         uh_sport : 1024,    
                         uh_dport : 34555,
			 uh_ulen : length,
			 data : die);
   send_packet(udpip2, pcap_active:FALSE);
  }
}
 



