#
# (C) Tenable Network Security
#
# 

if (description) {
  script_id(18370);
  script_version("$Revision: 1.1 $");

  script_bugtraq_id(13762);

  name["english"] = "MaxWebPortal password.asp SQL Injection Vulnerability";
  script_name(english:name["english"]);
 
  desc["english"] = "
The remote host is running a version of MaxWebPortal that fails to
properly sanitize input passed through the 'memKey' parameter to the
'password.asp' script.  An attacker can exploit this flaw to modify
database queries resulting in the disclosure of sensitive information,
modification of data (for example, users' passwords) and even attacks
against the underlying database. 

Solution : None at this time.
Risk factor : High";
  script_description(english:desc["english"]);
 
  summary["english"] = "Checks for SQL injection vulnerability in MaxWebPortal's password.asp";
  script_summary(english:summary["english"]);
 
  script_category(ACT_ATTACK);
  script_family(english:"CGI abuses");

  script_copyright(english:"This script is Copyright (C) 2005 Tenable Network Security");

  script_dependencie("http_version.nasl");
  script_require_ports("Services/www", 80);

  exit(0);
}


include("http_func.inc");
include("http_keepalive.inc");


port = get_http_port(default:80);
if (!get_port_state(port)) exit(0);
if (!can_host_asp(port:port)) exit(0);


# Iterate through CGI directories.
foreach dir (cgi_dirs()) {
  # Pull up the password form.
  req = http_get(item:string(dir, "/password.asp"), port:port);
  res = http_keepalive_send_recv(port:port, data:req, bodyonly:TRUE);
  if (res == NULL) exit(0);

  # If it's from MaxWebPortal...
  if ("This page is generated by MaxWebPortal" >< res) {
    # Try to exploit the flaw.
    postdata = string(
      "pass=123456&",
      "pass2=123456&",
      "memId=-1&",
      # nb: this will result in a syntax error.
      "memKey=", SCRIPT_NAME, "'"
    );
    req = string(
      "POST ", dir, "/password.asp?mode=reset HTTP/1.1\r\n",
      "Host: ", get_host_name(), "\r\n",
      "Connection: Keep-Alive\r\n",
      "Cache-Control: no-cache\r\n",
      "Content-Type: application/x-www-form-urlencoded\r\n",
      "Content-Length: ", strlen(postdata), "\r\n",
      "\r\n",
      postdata
    );
    res = http_keepalive_send_recv(port:port, data:req, bodyonly:TRUE);
    if (res == NULL) exit(0);

    if (
      (
        "<p>Microsoft OLE DB Provider for SQL Server" >< res &&
        egrep(string:res, pattern:string("Unclosed quotation mark .+'", SCRIPT_NAME), icase:TRUE)
      ) ||
      (
        "<p>Microsoft JET Database Engine</font>" >< res &&
        egrep(string:res, pattern:string("Syntax error.+M_KEY = '", SCRIPT_NAME), icase:TRUE)
      )
    ) {
      security_hole(port);
      exit(0);
    }
  }
}
