package wlgmod::mp3;

# You need 'mp3info' to be able to use this plugin
#
# Get it at: http://www.ibiblio.org/mp3info/

# MP3 tag info extract plugin

my $mp3info = "";

sub init {
    open(FILE, "which mp3info|");
    chomp($mp3info = <FILE>);
    close(FILE);
    if ($?) {
        return "Cannot find 'mp3info' (http://www.ibiblio.org/mp3info/)";
    }
    return "";
}

# The second_pass function takes the lines of text (like songnames etc) and add their individual words also to the list.
sub second_pass {
	my $origlist = shift;
	my @templist;
	
	foreach (@$origlist)
	{
	   my @list = split (/\s/,$_);
	   foreach my $word (@list)
	   {
	     chomp $word;
	     $word =~ s/\s+//mg;	    
	     if($word ne "") {
		 push @templist, $word;
	     }
	    }
	}
	
	push (@templist, @$origlist);
	return (@templist);		
}


sub get_words {
	my $this = shift;
	my $filename = shift;
	my @words;
	my @read_tag_info = ("\%a", "\%c", "\%g", "\%l", "\%t", "\%y"); # see 'man mp3infp'

	foreach $info (@read_tag_info) {
	    open(FILE, "$mp3info -p \"$info\" \"$filename\" 2>&1|") || die "Cannot open $filename: $!";
	    chomp(my $temp = <FILE>);
	    close(FILE);
	    # Only add if no error or empty string
	    push @words, $temp if !$? && $temp ne "";
	}
	return (second_pass (\@words));
}


1;
