/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.x.impl.swing;

import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.action.swing.ActionList;
import com.eviware.soapui.support.action.swing.DefaultActionList;
import com.eviware.soapui.support.components.JButtonBar;
import com.eviware.soapui.support.types.StringToStringMap;
import com.eviware.x.form.ValidationMessage;
import com.eviware.x.form.XForm;
import com.eviware.x.form.XFormField;
import com.eviware.x.impl.swing.AbstractSwingXFormField;
import com.eviware.x.impl.swing.SwingXFormDialog;
import com.eviware.x.impl.swing.SwingXFormImpl;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class JTabbedFormDialog
extends SwingXFormDialog {
    private JDialog dialog;
    private List<SwingXFormImpl> forms = new ArrayList<SwingXFormImpl>();
    private JTabbedPane tabs;
    private JButtonBar buttons;

    public JTabbedFormDialog(String name, XForm[] forms, ActionList actions, String description, ImageIcon icon) {
        this.dialog = new JDialog(UISupport.getMainFrame(), name, true);
        this.tabs = new JTabbedPane();
        for (XForm form : forms) {
            SwingXFormImpl swingFormImpl = (SwingXFormImpl)form;
            this.forms.add(swingFormImpl);
            JPanel panel = swingFormImpl.getPanel();
            panel.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
            this.tabs.addTab(form.getName(), panel);
        }
        this.buttons = UISupport.initDialogActions(actions, this.dialog);
        if (description != null || icon != null) {
            this.dialog.getContentPane().add((Component)UISupport.buildDescription(name, description, icon), "North");
        }
        this.dialog.getContentPane().add((Component)UISupport.createTabPanel(this.tabs, false), "Center");
        this.buttons.setBorder(BorderFactory.createEmptyBorder(3, 5, 3, 5));
        this.dialog.getContentPane().add((Component)this.buttons, "South");
        this.dialog.pack();
        Dimension size = this.dialog.getSize();
        if (size.getHeight() < 300.0) {
            this.dialog.setSize(new Dimension((int)size.getWidth(), 300));
        }
    }

    public void setSize(int i, int j) {
        this.dialog.setSize(i, j);
    }

    public XForm[] getForms() {
        ArrayList<SwingXFormImpl> result = new ArrayList<SwingXFormImpl>();
        for (SwingXFormImpl form : this.forms) {
            result.add(form);
        }
        return result.toArray(new XForm[result.size()]);
    }

    public void setValues(StringToStringMap values) {
        for (SwingXFormImpl form : this.forms) {
            form.setValues(values);
        }
    }

    public void setOptions(String field, Object[] options) {
        for (SwingXFormImpl form : this.forms) {
            form.setOptions(field, options);
        }
    }

    public XFormField getFormField(String name) {
        for (SwingXFormImpl form : this.forms) {
            XFormField formField = form.getFormField(name);
            if (formField == null) continue;
            return formField;
        }
        return null;
    }

    public void addAction(Action action) {
        DefaultActionList actions = new DefaultActionList();
        actions.addAction(action);
        this.buttons.addActions(actions);
    }

    public StringToStringMap getValues() {
        StringToStringMap result = new StringToStringMap();
        for (SwingXFormImpl form : this.forms) {
            result.putAll(form.getValues());
        }
        return result;
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.tabs.setSelectedIndex(0);
        }
        UISupport.centerDialog(this.dialog);
        this.dialog.setVisible(visible);
    }

    public boolean validate() {
        for (int i = 0; i < this.forms.size(); ++i) {
            XFormField[] formFields = this.forms.get(i).getFormFields();
            for (int c = 0; c < formFields.length; ++c) {
                ValidationMessage[] messages = formFields[c].validate();
                if (messages == null || messages.length <= 0) continue;
                this.tabs.setSelectedIndex(i);
                ((JComponent)((AbstractSwingXFormField)messages[0].getFormField()).getComponent()).requestFocus();
                UISupport.showErrorMessage(messages[0].getMessage());
                return false;
            }
        }
        return true;
    }

    public void setFormFieldProperty(String name, Object value) {
        for (SwingXFormImpl form : this.forms) {
            form.setFormFieldProperty(name, value);
        }
    }

    public String getValue(String field) {
        for (SwingXFormImpl form : this.forms) {
            if (form.getComponent(field) == null) continue;
            return form.getComponent(field).getValue();
        }
        return null;
    }

    public void setValue(String field, String value) {
        for (SwingXFormImpl form : this.forms) {
            if (form.getComponent(field) == null) continue;
            form.getComponent(field).setValue(value);
        }
    }

    public int getValueIndex(String name) {
        for (SwingXFormImpl form : this.forms) {
            if (form.getComponent(name) == null) continue;
            Object[] options = form.getOptions(name);
            if (options == null) {
                return -1;
            }
            return Arrays.asList(options).indexOf(form.getComponentValue(name));
        }
        return -1;
    }

    public boolean show() {
        this.setReturnValue(2);
        this.show(new StringToStringMap());
        return this.getReturnValue() == 1;
    }

    public void setWidth(int i) {
        this.dialog.setPreferredSize(new Dimension(i, (int)this.dialog.getPreferredSize().getHeight()));
    }

    public void release() {
        this.dialog.dispose();
    }
}

