/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.x.impl.swing;

import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.action.swing.ActionList;
import com.eviware.soapui.support.action.swing.DefaultActionList;
import com.eviware.soapui.support.components.JButtonBar;
import com.eviware.soapui.support.types.StringToStringMap;
import com.eviware.x.form.ValidationMessage;
import com.eviware.x.form.XForm;
import com.eviware.x.form.XFormField;
import com.eviware.x.impl.swing.AbstractSwingXFormField;
import com.eviware.x.impl.swing.SwingXFormDialog;
import com.eviware.x.impl.swing.SwingXFormImpl;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;

public class JFormDialog
extends SwingXFormDialog {
    private JDialog dialog;
    private SwingXFormImpl form;
    private JButtonBar buttons;
    private boolean resized;

    public JFormDialog(String name, SwingXFormImpl form, ActionList actions, String description, ImageIcon icon) {
        this.dialog = new JDialog(UISupport.getMainFrame(), name, true);
        this.buttons = UISupport.initDialogActions(actions, this.dialog);
        this.buttons.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        JPanel panel = new JPanel(new BorderLayout());
        this.form = form;
        panel.add((Component)this.form.getPanel(), "Center");
        panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        if (description != null || icon != null) {
            this.dialog.getContentPane().add((Component)UISupport.buildDescription(name, description, icon), "North");
        }
        this.dialog.getContentPane().add((Component)panel, "Center");
        this.buttons.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, Color.GRAY), BorderFactory.createMatteBorder(1, 0, 0, 0, Color.WHITE)), BorderFactory.createEmptyBorder(3, 5, 3, 5)));
        this.dialog.getContentPane().add((Component)this.buttons, "South");
    }

    public void setValues(StringToStringMap values) {
        this.form.setValues(values);
    }

    public void setSize(int i, int j) {
        this.dialog.setSize(i, j);
        this.resized = true;
    }

    public XForm[] getForms() {
        return new XForm[]{this.form};
    }

    public StringToStringMap getValues() {
        StringToStringMap result = new StringToStringMap();
        result.putAll(this.form.getValues());
        return result;
    }

    public void setOptions(String field, Object[] options) {
        this.form.setOptions(field, options);
    }

    public void setVisible(boolean visible) {
        if (!this.resized) {
            this.dialog.pack();
            if (this.dialog.getHeight() < 270) {
                this.dialog.setSize(new Dimension(this.dialog.getWidth(), 270));
            }
            if (this.dialog.getWidth() < 450) {
                this.dialog.setSize(new Dimension(450, this.dialog.getHeight()));
            }
        }
        UISupport.centerDialog(this.dialog);
        this.dialog.setVisible(visible);
    }

    public void addAction(Action action) {
        DefaultActionList actions = new DefaultActionList();
        actions.addAction(action);
        this.buttons.addActions(actions);
    }

    public boolean validate() {
        XFormField[] formFields = this.form.getFormFields();
        for (int c = 0; c < formFields.length; ++c) {
            ValidationMessage[] messages = formFields[c].validate();
            if (messages == null || messages.length <= 0) continue;
            ((JComponent)((AbstractSwingXFormField)messages[0].getFormField()).getComponent()).requestFocus();
            UISupport.showErrorMessage(messages[0].getMessage());
            return false;
        }
        return true;
    }

    public void setFormFieldProperty(String name, Object value) {
        this.form.setFormFieldProperty(name, value);
    }

    public String getValue(String field) {
        return this.form.getComponentValue(field);
    }

    public void setValue(String field, String value) {
        this.form.setComponentValue(field, value);
    }

    public int getValueIndex(String name) {
        Object[] options = this.form.getOptions(name);
        if (options == null) {
            return -1;
        }
        return StringUtils.toStringList(options).indexOf(this.form.getComponentValue(name));
    }

    public boolean show() {
        this.setReturnValue(2);
        this.show(new StringToStringMap());
        return this.getReturnValue() == 1;
    }

    public XFormField getFormField(String name) {
        return this.form.getFormField(name);
    }

    public void setWidth(int i) {
        this.dialog.setPreferredSize(new Dimension(i, (int)this.dialog.getPreferredSize().getHeight()));
    }

    public void release() {
        this.dialog.dispose();
    }
}

