/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.tools;

import com.eviware.soapui.impl.wsdl.WsdlProject;
import com.eviware.soapui.impl.wsdl.WsdlTestSuite;
import com.eviware.soapui.impl.wsdl.testcase.WsdlProjectRunner;
import com.eviware.soapui.impl.wsdl.testcase.WsdlTestCase;
import com.eviware.soapui.impl.wsdl.testcase.WsdlTestCaseRunner;
import com.eviware.soapui.impl.wsdl.testcase.WsdlTestSuiteRunner;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlRunTestCaseTestStep;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestStep;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestStepResult;
import com.eviware.soapui.model.iface.Attachment;
import com.eviware.soapui.model.iface.MessageExchange;
import com.eviware.soapui.model.project.ProjectFactoryRegistry;
import com.eviware.soapui.model.support.ModelSupport;
import com.eviware.soapui.model.support.ProjectRunListenerAdapter;
import com.eviware.soapui.model.testsuite.Assertable;
import com.eviware.soapui.model.testsuite.AssertionError;
import com.eviware.soapui.model.testsuite.ProjectRunContext;
import com.eviware.soapui.model.testsuite.ProjectRunner;
import com.eviware.soapui.model.testsuite.TestAssertion;
import com.eviware.soapui.model.testsuite.TestCase;
import com.eviware.soapui.model.testsuite.TestCaseRunContext;
import com.eviware.soapui.model.testsuite.TestCaseRunner;
import com.eviware.soapui.model.testsuite.TestRunner;
import com.eviware.soapui.model.testsuite.TestStep;
import com.eviware.soapui.model.testsuite.TestStepResult;
import com.eviware.soapui.model.testsuite.TestSuiteRunner;
import com.eviware.soapui.report.JUnitReportCollector;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.Tools;
import com.eviware.soapui.support.types.StringToObjectMap;
import com.eviware.soapui.tools.AbstractSoapUIRunner;
import com.eviware.soapui.tools.AbstractSoapUITestRunner;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.cli.CommandLine;

public class SoapUITestCaseRunner
extends AbstractSoapUITestRunner {
    public static final String SOAPUI_EXPORT_SEPARATOR = "soapui.export.separator";
    public static final String TITLE = "soapUI 3.5.1 TestCase Runner";
    private String testSuite;
    private String testCase;
    private List<TestAssertion> assertions = new ArrayList<TestAssertion>();
    private Map<TestAssertion, WsdlTestStepResult> assertionResults = new HashMap<TestAssertion, WsdlTestStepResult>();
    private List<TestCase> failedTests = new ArrayList<TestCase>();
    private int testSuiteCount;
    private int testCaseCount;
    private int testStepCount;
    private int testAssertionCount;
    private boolean printReport;
    private boolean exportAll;
    private boolean ignoreErrors;
    private boolean junitReport;
    private int exportCount;
    private JUnitReportCollector reportCollector;
    private String projectPassword;
    private boolean saveAfterRun;

    public static void main(String[] args) throws Exception {
        System.exit(new SoapUITestCaseRunner().runFromCommandLine(args));
    }

    protected boolean processCommandLine(CommandLine cmd) {
        if (cmd.hasOption("e")) {
            this.setEndpoint(cmd.getOptionValue("e"));
        }
        if (cmd.hasOption("s")) {
            this.setTestSuite(this.getCommandLineOptionSubstSpace(cmd, "s"));
        }
        if (cmd.hasOption("c")) {
            this.setTestCase(this.getCommandLineOptionSubstSpace(cmd, "c"));
        }
        if (cmd.hasOption("u")) {
            this.setUsername(cmd.getOptionValue("u"));
        }
        if (cmd.hasOption("p")) {
            this.setPassword(cmd.getOptionValue("p"));
        }
        if (cmd.hasOption("w")) {
            this.setWssPasswordType(cmd.getOptionValue("w"));
        }
        if (cmd.hasOption("d")) {
            this.setDomain(cmd.getOptionValue("d"));
        }
        if (cmd.hasOption("h")) {
            this.setHost(cmd.getOptionValue("h"));
        }
        if (cmd.hasOption("f")) {
            this.setOutputFolder(this.getCommandLineOptionSubstSpace(cmd, "f"));
        }
        if (cmd.hasOption("t")) {
            this.setSettingsFile(this.getCommandLineOptionSubstSpace(cmd, "t"));
        }
        if (cmd.hasOption("x")) {
            this.setProjectPassword(cmd.getOptionValue("x"));
        }
        if (cmd.hasOption("v")) {
            this.setSoapUISettingsPassword(cmd.getOptionValue("v"));
        }
        if (cmd.hasOption("D")) {
            this.setSystemProperties(cmd.getOptionValues("D"));
        }
        if (cmd.hasOption("G")) {
            this.setGlobalProperties(cmd.getOptionValues("G"));
        }
        if (cmd.hasOption("P")) {
            this.setProjectProperties(cmd.getOptionValues("P"));
        }
        this.setIgnoreError(cmd.hasOption("I"));
        this.setEnableUI(cmd.hasOption("i"));
        this.setPrintReport(cmd.hasOption("r"));
        this.setExportAll(cmd.hasOption("a"));
        if (cmd.hasOption("A")) {
            this.setExportAll(true);
            System.setProperty(SOAPUI_EXPORT_SEPARATOR, File.separator);
        }
        this.setJUnitReport(cmd.hasOption("j"));
        this.setSaveAfterRun(cmd.hasOption("S"));
        return true;
    }

    public void setSaveAfterRun(boolean saveAfterRun) {
        this.saveAfterRun = saveAfterRun;
    }

    public void setProjectPassword(String projectPassword) {
        this.projectPassword = projectPassword;
    }

    public String getProjectPassword() {
        return this.projectPassword;
    }

    protected AbstractSoapUIRunner.SoapUIOptions initCommandLineOptions() {
        AbstractSoapUIRunner.SoapUIOptions options = new AbstractSoapUIRunner.SoapUIOptions("testrunner");
        options.addOption("e", true, "Sets the endpoint");
        options.addOption("s", true, "Sets the testsuite");
        options.addOption("c", true, "Sets the testcase");
        options.addOption("u", true, "Sets the username");
        options.addOption("p", true, "Sets the password");
        options.addOption("w", true, "Sets the WSS password type, either 'Text' or 'Digest'");
        options.addOption("i", false, "Enables Swing UI for scripts");
        options.addOption("d", true, "Sets the domain");
        options.addOption("h", true, "Sets the host");
        options.addOption("r", false, "Prints a small summary report");
        options.addOption("f", true, "Sets the output folder to export results to");
        options.addOption("j", false, "Sets the output to include JUnit XML reports");
        options.addOption("a", false, "Turns on exporting of all results");
        options.addOption("A", false, "Turns on exporting of all results using folders instead of long filenames");
        options.addOption("t", true, "Sets the soapui-settings.xml file to use");
        options.addOption("x", true, "Sets project password for decryption if project is encrypted");
        options.addOption("v", true, "Sets password for soapui-settings.xml file");
        options.addOption("D", true, "Sets system property with name=value");
        options.addOption("G", true, "Sets global property with name=value");
        options.addOption("P", true, "Sets or overrides project property with name=value");
        options.addOption("I", false, "Do not stop if error occurs, ignore them");
        options.addOption("S", false, "Saves the project after running the tests");
        return options;
    }

    public void setExportAll(boolean exportAll) {
        this.exportAll = exportAll;
    }

    public void setJUnitReport(boolean junitReport) {
        this.junitReport = junitReport;
        if (junitReport) {
            this.reportCollector = new JUnitReportCollector();
        }
    }

    public SoapUITestCaseRunner() {
        super(TITLE);
    }

    public SoapUITestCaseRunner(String title) {
        super(title);
    }

    public void setPrintReport(boolean printReport) {
        this.printReport = printReport;
    }

    public void setIgnoreError(boolean ignoreErrors) {
        this.ignoreErrors = ignoreErrors;
    }

    public boolean runRunner() throws Exception {
        this.initGroovyLog();
        this.assertions.clear();
        String projectFile = this.getProjectFile();
        WsdlProject project = (WsdlProject)ProjectFactoryRegistry.getProjectFactory("wsdl").createNew(projectFile, this.getProjectPassword());
        if (project.isDisabled()) {
            throw new Exception("Failed to load soapUI project file [" + projectFile + "]");
        }
        this.initProject(project);
        this.ensureOutputFolder(project);
        this.log.info((Object)("Running soapUI tests in project [" + project.getName() + "]"));
        long startTime = System.nanoTime();
        ArrayList<TestCase> testCasesToRun = new ArrayList<TestCase>();
        for (int c = 0; c < project.getTestSuiteCount(); ++c) {
            WsdlTestSuite suite = project.getTestSuiteAt(c);
            for (int i = 0; i < suite.getTestCaseCount(); ++i) {
                TestCase tc = suite.getTestCaseAt(i);
                if ((this.testSuite == null || suite.getName().equals(suite.getName())) && this.testCase != null && tc.getName().equals(this.testCase)) {
                    testCasesToRun.add(tc);
                }
                this.addListeners(tc);
            }
        }
        if (testCasesToRun.size() > 0) {
            for (TestCase testCase : testCasesToRun) {
                this.runTestCase((WsdlTestCase)testCase);
            }
        } else if (this.testSuite != null) {
            this.runSuite(project.getTestSuiteByName(this.testSuite));
        } else {
            this.runProject(project);
        }
        long timeTaken = (System.nanoTime() - startTime) / 1000000L;
        if (this.printReport) {
            this.printReport(timeTaken);
        }
        this.exportReports(project);
        if (this.saveAfterRun && !project.isRemote()) {
            try {
                project.save();
            }
            catch (Throwable t) {
                this.log.error((Object)"Failed to save project", t);
            }
        }
        if (!(this.assertions.size() <= 0 && this.failedTests.size() <= 0 || this.ignoreErrors)) {
            this.throwFailureException();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runProject(WsdlProject project) {
        InternalProjectRunListener projectRunListener = new InternalProjectRunListener();
        project.addProjectRunListener(projectRunListener);
        try {
            try {
                this.log.info((Object)("Running Project [" + project.getName() + "], runType = " + (Object)((Object)project.getRunType())));
                WsdlProjectRunner runner = project.run(new StringToObjectMap(), false);
                this.log.info((Object)("Project [" + project.getName() + "] finished with status [" + (Object)((Object)runner.getStatus()) + "] in " + runner.getTimeTaken() + "ms"));
            }
            catch (Exception e) {
                e.printStackTrace();
                Object var5_6 = null;
                project.removeProjectRunListener(projectRunListener);
            }
            Object var5_5 = null;
            project.removeProjectRunListener(projectRunListener);
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            project.removeProjectRunListener(projectRunListener);
            throw throwable;
        }
    }

    protected void initProject(WsdlProject project) throws Exception {
        this.initProjectProperties(project);
    }

    protected void exportReports(WsdlProject project) throws Exception {
        if (this.junitReport) {
            this.exportJUnitReports(this.reportCollector, this.getAbsoluteOutputFolder(project), project);
        }
    }

    protected void addListeners(TestCase tc) {
        tc.addTestRunListener(this);
        if (this.junitReport) {
            tc.addTestRunListener(this.reportCollector);
        }
    }

    protected void throwFailureException() throws Exception {
        StringBuffer buf = new StringBuffer();
        for (int c = 0; c < this.assertions.size(); ++c) {
            TestAssertion assertion = this.assertions.get(c);
            Assertable assertable = assertion.getAssertable();
            if (assertable instanceof WsdlTestStep) {
                this.failedTests.remove(((WsdlTestStep)((Object)assertable)).getTestCase());
            }
            buf.append(assertion.getName() + " in [" + assertable.getModelItem().getName() + "] failed;\n");
            buf.append(Arrays.toString(assertion.getErrors()) + "\n");
            WsdlTestStepResult result = this.assertionResults.get(assertion);
            StringWriter stringWriter = new StringWriter();
            PrintWriter writer = new PrintWriter(stringWriter);
            result.writeTo(writer);
            buf.append(stringWriter.toString());
        }
        while (!this.failedTests.isEmpty()) {
            buf.append("TestCase [" + this.failedTests.remove(0).getName() + "] failed without assertions\n");
        }
        throw new Exception(buf.toString());
    }

    public void exportJUnitReports(JUnitReportCollector collector, String folder, WsdlProject project) throws Exception {
        collector.saveReports(folder == null ? "" : folder);
    }

    public void printReport(long timeTaken) {
        System.out.println();
        System.out.println("SoapUI 3.5.1 TestCaseRunner Summary");
        System.out.println("-----------------------------");
        System.out.println("Time Taken: " + timeTaken + "ms");
        System.out.println("Total TestSuites: " + this.testSuiteCount);
        System.out.println("Total TestCases: " + this.testCaseCount + " (" + this.failedTests.size() + " failed)");
        System.out.println("Total TestSteps: " + this.testStepCount);
        System.out.println("Total Request Assertions: " + this.testAssertionCount);
        System.out.println("Total Failed Assertions: " + this.assertions.size());
        System.out.println("Total Exported Results: " + this.exportCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runSuite(WsdlTestSuite suite) {
        try {
            try {
                this.log.info((Object)("Running TestSuite [" + suite.getName() + "], runType = " + (Object)((Object)suite.getRunType())));
                WsdlTestSuiteRunner runner = suite.run(new StringToObjectMap(), false);
                this.log.info((Object)("TestSuite [" + suite.getName() + "] finished with status [" + (Object)((Object)runner.getStatus()) + "] in " + runner.getTimeTaken() + "ms"));
            }
            catch (Exception e) {
                e.printStackTrace();
                Object var4_5 = null;
                ++this.testSuiteCount;
            }
            Object var4_4 = null;
            ++this.testSuiteCount;
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            ++this.testSuiteCount;
            throw throwable;
        }
    }

    protected void runTestCase(WsdlTestCase testCase) {
        try {
            this.log.info((Object)("Running TestCase [" + testCase.getName() + "]"));
            WsdlTestCaseRunner runner = testCase.run(new StringToObjectMap(), false);
            this.log.info((Object)("TestCase [" + testCase.getName() + "] finished with status [" + (Object)((Object)runner.getStatus()) + "] in " + runner.getTimeTaken() + "ms"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setTestCase(String testCase) {
        this.testCase = testCase;
    }

    public void setTestSuite(String testSuite) {
        this.testSuite = testSuite;
    }

    public void beforeRun(TestCaseRunner testRunner, TestCaseRunContext runContext) {
        this.log.info((Object)("Running soapUI testcase [" + testRunner.getTestCase().getName() + "]"));
    }

    public void beforeStep(TestCaseRunner testRunner, TestCaseRunContext runContext, TestStep currentStep) {
        super.beforeStep(testRunner, runContext, currentStep);
        if (currentStep != null) {
            this.log.info((Object)("running step [" + currentStep.getName() + "]"));
        }
    }

    public void afterStep(TestCaseRunner testRunner, TestCaseRunContext runContext, TestStepResult result) {
        String countPropertyName;
        Long count;
        super.afterStep(testRunner, runContext, result);
        TestStep currentStep = runContext.getCurrentStep();
        if (currentStep instanceof Assertable) {
            Assertable requestStep = (Assertable)((Object)currentStep);
            for (int c = 0; c < requestStep.getAssertionCount(); ++c) {
                TestAssertion assertion = requestStep.getAssertionAt(c);
                this.log.info((Object)("Assertion [" + assertion.getName() + "] has status " + (Object)((Object)assertion.getStatus())));
                if (assertion.getStatus() == Assertable.AssertionStatus.FAILED) {
                    for (AssertionError error : assertion.getErrors()) {
                        this.log.error((Object)("ASSERTION FAILED -> " + error.getMessage()));
                    }
                    this.assertions.add(assertion);
                    this.assertionResults.put(assertion, (WsdlTestStepResult)result);
                }
                ++this.testAssertionCount;
            }
        }
        if ((count = (Long)runContext.getProperty(countPropertyName = currentStep.getName() + " run count")) == null) {
            count = new Long(0L);
        }
        runContext.setProperty(countPropertyName, new Long(count + 1L));
        if (result.getStatus() == TestStepResult.TestStepStatus.FAILED || this.exportAll) {
            try {
                Attachment[] attachments;
                String exportSeparator = System.getProperty(SOAPUI_EXPORT_SEPARATOR, "-");
                TestCase tc = currentStep.getTestCase();
                String nameBase = StringUtils.createFileName(tc.getTestSuite().getName(), '_') + exportSeparator + StringUtils.createFileName(tc.getName(), '_') + exportSeparator + StringUtils.createFileName(currentStep.getName(), '_') + "-" + count + "-" + (Object)((Object)result.getStatus());
                WsdlTestCaseRunner callingTestCaseRunner = (WsdlTestCaseRunner)runContext.getProperty("#CallingTestCaseRunner#");
                if (callingTestCaseRunner != null) {
                    WsdlTestCase ctc = callingTestCaseRunner.getTestCase();
                    WsdlRunTestCaseTestStep runTestCaseTestStep = (WsdlRunTestCaseTestStep)runContext.getProperty("#CallingRunTestCaseStep#");
                    nameBase = StringUtils.createFileName(ctc.getTestSuite().getName(), '_') + exportSeparator + StringUtils.createFileName(ctc.getName(), '_') + exportSeparator + StringUtils.createFileName(runTestCaseTestStep.getName(), '_') + exportSeparator + StringUtils.createFileName(tc.getTestSuite().getName(), '_') + exportSeparator + StringUtils.createFileName(tc.getName(), '_') + exportSeparator + StringUtils.createFileName(currentStep.getName(), '_') + "-" + count + "-" + (Object)((Object)result.getStatus());
                }
                String absoluteOutputFolder = this.getAbsoluteOutputFolder(ModelSupport.getModelItemProject(tc));
                String fileName = absoluteOutputFolder + File.separator + nameBase + ".txt";
                if (result.getStatus() == TestStepResult.TestStepStatus.FAILED) {
                    this.log.error((Object)(currentStep.getName() + " failed, exporting to [" + fileName + "]"));
                }
                new File(fileName).getParentFile().mkdirs();
                PrintWriter writer = new PrintWriter(fileName);
                result.writeTo(writer);
                writer.close();
                if (result instanceof MessageExchange && (attachments = ((MessageExchange)((Object)result)).getResponseAttachments()) != null && attachments.length > 0) {
                    for (int c = 0; c < attachments.length; ++c) {
                        fileName = nameBase + "-attachment-" + (c + 1) + ".";
                        Attachment attachment = attachments[c];
                        String contentType = attachment.getContentType();
                        fileName = !"application/octet-stream".equals(contentType) && contentType != null && contentType.indexOf(47) != -1 ? fileName + contentType.substring(contentType.lastIndexOf(47) + 1) : fileName + "dat";
                        fileName = absoluteOutputFolder + File.separator + fileName;
                        FileOutputStream outFile = new FileOutputStream(fileName);
                        Tools.writeAll(outFile, attachment.getInputStream());
                        outFile.close();
                    }
                }
                ++this.exportCount;
            }
            catch (Exception e) {
                this.log.error((Object)("Error saving failed result: " + e), (Throwable)e);
            }
        }
        ++this.testStepCount;
    }

    public void afterRun(TestCaseRunner testRunner, TestCaseRunContext runContext) {
        this.log.info((Object)("Finished running soapUI testcase [" + testRunner.getTestCase().getName() + "], time taken: " + testRunner.getTimeTaken() + "ms, status: " + (Object)((Object)testRunner.getStatus())));
        if (testRunner.getStatus() == TestRunner.Status.FAILED) {
            this.failedTests.add(testRunner.getTestCase());
        }
        ++this.testCaseCount;
    }

    private class InternalProjectRunListener
    extends ProjectRunListenerAdapter {
        private InternalProjectRunListener() {
        }

        public void afterTestSuite(ProjectRunner projectRunner, ProjectRunContext runContext, TestSuiteRunner testRunner) {
            SoapUITestCaseRunner.this.testSuiteCount++;
        }
    }
}

