/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support.xml;

import com.eviware.soapui.impl.wsdl.support.xsd.SchemaUtils;
import com.eviware.soapui.support.types.StringToStringMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreePath;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.apache.xmlbeans.SchemaGlobalElement;
import org.apache.xmlbeans.SchemaParticle;
import org.apache.xmlbeans.SchemaProperty;
import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.SchemaTypeSystem;
import org.apache.xmlbeans.XmlBeans;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlLineNumber;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.impl.values.XmlAnyTypeImpl;
import org.jdesktop.swingx.treetable.TreeTableModel;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlObjectTreeModel
implements TreeTableModel {
    private XmlObject xmlObject;
    private Set<TreeModelListener> listeners = new HashSet<TreeModelListener>();
    private XmlCursor cursor;
    private Map<XmlObject, XmlTreeNode> treeNodeMap = new HashMap<XmlObject, XmlTreeNode>();
    public static final Class<?> hierarchicalColumnClass = TreeTableModel.class;
    private SchemaTypeSystem typeSystem;
    private RootXmlTreeNode root;
    private static final Logger log = Logger.getLogger(XmlObjectTreeModel.class);

    public XmlObjectTreeModel(XmlObject xmlObject) {
        this(XmlBeans.getBuiltinTypeSystem(), xmlObject);
    }

    public XmlObjectTreeModel() {
        this(XmlObject.Factory.newInstance());
    }

    public XmlObjectTreeModel(SchemaTypeSystem typeSystem, XmlObject xmlObject) {
        if (typeSystem == null) {
            typeSystem = XmlBeans.getBuiltinTypeSystem();
        }
        this.typeSystem = typeSystem;
        this.xmlObject = xmlObject;
        this.init();
    }

    public XmlObjectTreeModel(SchemaTypeSystem typeSystem) {
        this(typeSystem, XmlObject.Factory.newInstance());
    }

    private void init() {
        this.cursor = null;
        if (this.xmlObject != null) {
            this.cursor = this.xmlObject.newCursor();
            this.cursor.toStartDoc();
        }
        this.root = new RootXmlTreeNode(this.cursor);
    }

    public SchemaTypeSystem getTypeSystem() {
        return this.typeSystem;
    }

    public void setTypeSystem(SchemaTypeSystem typeSystem) {
        if (typeSystem == null) {
            typeSystem = XmlBeans.getBuiltinTypeSystem();
        }
        this.typeSystem = typeSystem;
    }

    public XmlObject getXmlObject() {
        return this.xmlObject;
    }

    public void setXmlObject(XmlObject xmlObject) {
        if (this.cursor != null) {
            this.cursor.dispose();
        }
        this.xmlObject = xmlObject;
        this.init();
        XmlTreeNode xmlTreeNode = (XmlTreeNode)this.getRoot();
        this.fireTreeStructureChanged(xmlTreeNode);
    }

    protected void fireTreeStructureChanged(XmlTreeNode rootNode) {
        for (TreeModelListener listener : this.listeners) {
            listener.treeStructureChanged(new XmlTreeTableModelEvent((Object)this, rootNode.getTreePath(), -1));
        }
    }

    public Class<?> getColumnClass(int arg0) {
        return arg0 == 0 ? hierarchicalColumnClass : XmlTreeNode.class;
    }

    public int getColumnCount() {
        return 3;
    }

    public String getColumnName(int arg0) {
        return null;
    }

    public Object getValueAt(Object arg0, int arg1) {
        return arg0;
    }

    public boolean isCellEditable(Object arg0, int arg1) {
        return ((XmlTreeNode)arg0).isEditable(arg1);
    }

    public void setValueAt(Object arg0, Object arg1, int arg2) {
        XmlTreeNode treeNode = (XmlTreeNode)arg1;
        if (treeNode.setValue(arg2, arg0)) {
            this.fireTreeNodeChanged(treeNode, arg2);
        }
    }

    protected void fireTreeNodeChanged(XmlTreeNode treeNode, int column) {
        for (TreeModelListener listener : this.listeners) {
            listener.treeNodesChanged(new XmlTreeTableModelEvent((Object)this, treeNode.getTreePath(), column));
        }
    }

    public void addTreeModelListener(TreeModelListener l) {
        this.listeners.add(l);
    }

    public Object getChild(Object parent, int index) {
        return ((XmlTreeNode)parent).getChild(index);
    }

    public int getChildCount(Object parent) {
        return ((XmlTreeNode)parent).getChildCount();
    }

    public int getIndexOfChild(Object parent, Object child) {
        return ((XmlTreeNode)parent).getIndexOfChild((XmlTreeNode)child);
    }

    public Object getRoot() {
        return this.getRootNode();
    }

    public RootXmlTreeNode getRootNode() {
        return this.root;
    }

    public boolean isLeaf(Object node) {
        return ((XmlTreeNode)node).isLeaf();
    }

    public void removeTreeModelListener(TreeModelListener l) {
        this.listeners.remove(l);
    }

    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    public TreePath findXmlTreeNode(int line, int column) {
        XmlTreeNode treeNode;
        if ((treeNode = this.findXmlTreeNode(this.root, ++line, column)) instanceof AttributeXmlTreeNode) {
            return treeNode.getParent().getTreePath();
        }
        if (treeNode != null) {
            return treeNode.getTreePath();
        }
        return null;
    }

    private XmlTreeNode findXmlTreeNode(XmlTreeNode treeNode, int line, int column) {
        for (int c = 0; c < treeNode.getChildCount(); ++c) {
            XmlTreeNode child = treeNode.getChild(c);
            XmlLineNumber ln = child.getNodeLineNumber();
            if (ln == null || line >= ln.getLine() && (line != ln.getLine() || column > ln.getColumn())) continue;
            if (c == 0) {
                return treeNode;
            }
            return this.findXmlTreeNode(treeNode.getChild(c - 1), line, column);
        }
        if (treeNode.getChildCount() > 0) {
            return this.findXmlTreeNode(treeNode.getChild(treeNode.getChildCount() - 1), line, column);
        }
        return treeNode;
    }

    public XmlTreeNode getXmlTreeNode(XmlObject object) {
        return this.treeNodeMap.get(object);
    }

    public XmlTreeNode[] selectTreeNodes(String xpath) {
        XmlObject[] nodes = this.xmlObject.selectPath(xpath);
        ArrayList<XmlTreeNode> result = new ArrayList<XmlTreeNode>();
        for (XmlObject xmlObject : nodes) {
            XmlTreeNode tn = this.getXmlTreeNode(xmlObject);
            if (tn == null) continue;
            result.add(tn);
        }
        return result.toArray(new XmlTreeNode[result.size()]);
    }

    public void release() {
        this.typeSystem = null;
        this.treeNodeMap.clear();
        this.listeners.clear();
    }

    public int getHierarchicalColumn() {
        return 0;
    }

    public class XmlTreeTableModelEvent
    extends TreeModelEvent {
        private final int column;

        public XmlTreeTableModelEvent(Object source, Object[] path, int[] childIndices, Object[] children, int column) {
            super(source, path, childIndices, children);
            this.column = column;
        }

        public XmlTreeTableModelEvent(Object source, Object[] path, int column) {
            super(source, path);
            this.column = column;
        }

        public XmlTreeTableModelEvent(Object source, TreePath path, int[] childIndices, Object[] children, int column) {
            super(source, path, childIndices, children);
            this.column = column;
        }

        public XmlTreeTableModelEvent(Object source, TreePath path, int column) {
            super(source, path);
            this.column = column;
        }

        public int getColumn() {
            return this.column;
        }
    }

    public class TextXmlTreeNode
    extends AbstractXmlTreeNode {
        protected TextXmlTreeNode(XmlCursor cursor, ElementXmlTreeNode parent) {
            super(cursor, parent);
        }

        public boolean isEditable(int column) {
            return column == 1;
        }

        public boolean setValue(int column, Object value) {
            if (column == 1) {
                this.node.setNodeValue(this.node == null ? null : value.toString());
            }
            return column == 1;
        }

        public TreePath getTreePath() {
            return super.getTreePath().getParentPath();
        }
    }

    public class AttributeXmlTreeNode
    extends AbstractXmlTreeNode {
        private boolean checkedType;

        protected AttributeXmlTreeNode(XmlCursor cursor, ElementXmlTreeNode parent) {
            super(cursor, parent);
        }

        public String getNodeName() {
            return "@" + super.getNodeName();
        }

        public XmlLineNumber getNodeLineNumber() {
            return this.getParent().getNodeLineNumber();
        }

        public boolean isEditable(int column) {
            return column == 1;
        }

        public boolean setValue(int column, Object value) {
            if (column == 1) {
                this.node.setNodeValue(value.toString());
            }
            return column == 1;
        }

        public SchemaType getSchemaType() {
            if (this.schemaType == null && !this.checkedType) {
                SchemaType parentSchemaType = this.getParent().getSchemaType();
                if (parentSchemaType != null) {
                    this.positionCursor(XmlObjectTreeModel.this.cursor);
                    SchemaProperty attributeProperty = parentSchemaType.getAttributeProperty(XmlObjectTreeModel.this.cursor.getName());
                    if (attributeProperty != null) {
                        this.schemaType = attributeProperty.getType();
                        this.documentation = SchemaUtils.getDocumentation(this.schemaType);
                    }
                }
                this.checkedType = true;
            }
            return this.schemaType;
        }
    }

    public class ElementXmlTreeNode
    extends AbstractXmlTreeNode {
        private LinkedList<XmlTreeNode> elements;
        private TextXmlTreeNode textTreeNode;
        private int attrCount;

        protected ElementXmlTreeNode(XmlCursor cursor, XmlTreeNode parent) {
            super(cursor, parent);
            this.elements = new LinkedList();
            XmlCursor.TokenType token = cursor.toNextToken();
            while (token == XmlCursor.TokenType.ATTR || token == XmlCursor.TokenType.NAMESPACE) {
                if (token == XmlCursor.TokenType.ATTR) {
                    this.elements.add(new AttributeXmlTreeNode(cursor, this));
                }
                token = cursor.toNextToken();
            }
            this.attrCount = this.elements.size();
            this.positionCursor(cursor);
            cursor.toFirstContentToken();
            while (true) {
                if (cursor.isComment() || cursor.isProcinst()) {
                    cursor.toNextToken();
                    continue;
                }
                if (cursor.isContainer()) {
                    this.elements.add(new ElementXmlTreeNode(cursor, this));
                    cursor.toEndToken();
                    cursor.toNextToken();
                }
                if (cursor.isText()) {
                    this.elements.add(new TextXmlTreeNode(cursor, this));
                    cursor.toNextToken();
                }
                if (cursor.isEnd() || cursor.isEnddoc()) break;
            }
            if (this.elements.size() == this.attrCount + 1 && this.elements.get(this.attrCount) instanceof TextXmlTreeNode) {
                this.textTreeNode = (TextXmlTreeNode)this.elements.remove(this.attrCount);
            } else {
                for (int c = this.attrCount; c < this.elements.size(); ++c) {
                    TextXmlTreeNode treeNode;
                    String text;
                    if (!(this.elements.get(c) instanceof TextXmlTreeNode) || (text = (treeNode = (TextXmlTreeNode)this.elements.get(c)).getNodeText().trim()).length() != 0) continue;
                    this.elements.remove(c);
                    --c;
                }
            }
            this.positionCursor(cursor);
        }

        public XmlTreeNode getChild(int ix) {
            return this.elements.get(ix);
        }

        public boolean isEditable(int column) {
            return column == 1 && this.elements.size() == this.attrCount;
        }

        public boolean setValue(int column, Object value) {
            if (column == 1) {
                if (this.textTreeNode != null) {
                    this.textTreeNode.setValue(1, value);
                } else {
                    this.positionCursor(XmlObjectTreeModel.this.cursor);
                    XmlObjectTreeModel.this.cursor.toEndToken();
                    XmlObjectTreeModel.this.cursor.insertChars(value.toString());
                    this.positionCursor(XmlObjectTreeModel.this.cursor);
                    XmlObjectTreeModel.this.cursor.toFirstContentToken();
                    this.textTreeNode = new TextXmlTreeNode(XmlObjectTreeModel.this.cursor, this);
                }
            }
            return column == 1;
        }

        public int getChildCount() {
            return this.elements.size();
        }

        public int getIndexOfChild(XmlTreeNode childNode) {
            return this.elements.indexOf(childNode);
        }

        public String getNodeText() {
            return this.textTreeNode == null ? "" : this.textTreeNode.getNodeText();
        }

        public XmlLineNumber getValueLineNumber() {
            return this.textTreeNode == null ? super.getValueLineNumber() : this.textTreeNode.getValueLineNumber();
        }
    }

    public class RootXmlTreeNode
    extends AbstractXmlTreeNode {
        private ElementXmlTreeNode rootNode;

        protected RootXmlTreeNode(XmlCursor cursor) {
            super(cursor, null);
            if (cursor != null) {
                cursor.toFirstContentToken();
                this.rootNode = new ElementXmlTreeNode(cursor, this);
            }
        }

        public XmlTreeNode getChild(int ix) {
            return ix == 0 ? this.rootNode : null;
        }

        public int getChildCount() {
            return this.rootNode == null ? 0 : 1;
        }

        public int getIndexOfChild(XmlTreeNode childNode) {
            return childNode == this.rootNode ? 0 : -1;
        }
    }

    private abstract class AbstractXmlTreeNode
    implements XmlTreeNode {
        protected Node node;
        protected TreeBookmark bm;
        private final XmlTreeNode parent;
        private XmlLineNumber lineNumber;
        protected SchemaType schemaType;
        protected String documentation;

        protected AbstractXmlTreeNode(XmlCursor cursor, XmlTreeNode parent) {
            this.parent = parent;
            if (cursor != null) {
                this.node = cursor.getDomNode();
                ArrayList list = new ArrayList();
                cursor.getAllBookmarkRefs(list);
                for (Object o : list) {
                    if (!(o instanceof XmlLineNumber)) continue;
                    this.lineNumber = (XmlLineNumber)o;
                }
                this.bm = new TreeBookmark();
                cursor.setBookmark((XmlCursor.XmlBookmark)this.bm);
                XmlObjectTreeModel.this.treeNodeMap.put(cursor.getObject(), this);
            }
        }

        protected SchemaType findSchemaType() {
            if (XmlObjectTreeModel.this.cursor == null) {
                return null;
            }
            this.positionCursor(XmlObjectTreeModel.this.cursor);
            SchemaType resultType = null;
            XmlObject xo = XmlObjectTreeModel.this.cursor.getObject();
            if (xo != null) {
                Element elm;
                String xsiType;
                Node domNode = xo.getDomNode();
                if (domNode.getNodeType() == 1 && (xsiType = (elm = (Element)domNode).getAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "type")) != null && xsiType.length() > 0) {
                    resultType = this.findXsiType(xsiType);
                }
                if (resultType == null) {
                    resultType = XmlObjectTreeModel.this.typeSystem.findType(xo.schemaType().getName());
                }
                if (resultType == null) {
                    resultType = xo.schemaType();
                }
                if (resultType.isNoType()) {
                    SchemaType parentSchemaType;
                    SchemaParticle contentModel;
                    QName nm = XmlObjectTreeModel.this.cursor.getName();
                    if (this.parent != null && this.parent.getSchemaType() != null && (contentModel = (parentSchemaType = this.parent.getSchemaType()).getContentModel()) != null) {
                        SchemaParticle[] children = contentModel.getParticleChildren();
                        for (int c = 0; children != null && c < children.length; ++c) {
                            if (!nm.equals(children[c].getName())) continue;
                            resultType = children[c].getType();
                            this.documentation = SchemaUtils.getDocumentation(resultType);
                            break;
                        }
                        if (resultType.isNoType() && nm.equals(contentModel.getName())) {
                            resultType = contentModel.getType();
                        }
                        if (resultType.isNoType()) {
                            SchemaType[] anonymousTypes = parentSchemaType.getAnonymousTypes();
                            for (int c = 0; anonymousTypes != null && c < anonymousTypes.length; ++c) {
                                QName name = anonymousTypes[c].getName();
                                if (name != null && name.equals(nm)) {
                                    resultType = anonymousTypes[c];
                                    break;
                                }
                                if (!anonymousTypes[c].getContainerField().getName().equals(nm)) continue;
                                resultType = anonymousTypes[c].getContainerField().getType();
                                break;
                            }
                        }
                    }
                    if (resultType.isNoType()) {
                        SchemaGlobalElement elm2 = XmlObjectTreeModel.this.typeSystem.findElement(nm);
                        if (elm2 != null) {
                            resultType = elm2.getType();
                        } else if (XmlObjectTreeModel.this.typeSystem.findDocumentType(nm) != null) {
                            resultType = XmlObjectTreeModel.this.typeSystem.findDocumentType(nm);
                        }
                    }
                }
            }
            if (resultType == null) {
                resultType = XmlAnyTypeImpl.type;
            }
            if (this.documentation == null) {
                this.documentation = SchemaUtils.getDocumentation(resultType);
            }
            return resultType;
        }

        protected String getUserInfo(SchemaType schemaType) {
            XmlObject[] userInformation;
            if (schemaType.getAnnotation() != null && (userInformation = schemaType.getAnnotation().getUserInformation()) != null && userInformation.length > 0) {
                return userInformation[0].toString();
            }
            return null;
        }

        public String getDocumentation() {
            return this.documentation;
        }

        private SchemaType findXsiType(String xsiType) {
            SchemaType resultType;
            int ix = xsiType.indexOf(58);
            QName name = null;
            if (ix == -1) {
                name = new QName(xsiType);
                resultType = XmlObjectTreeModel.this.typeSystem.findType(name);
            } else {
                StringToStringMap map = new StringToStringMap();
                XmlObjectTreeModel.this.cursor.getAllNamespaces((Map)map);
                name = new QName((String)map.get(xsiType.substring(0, ix)), xsiType.substring(ix + 1));
                resultType = XmlObjectTreeModel.this.typeSystem.findType(name);
            }
            return resultType;
        }

        public XmlTreeNode getParent() {
            return this.parent;
        }

        protected void positionCursor(XmlCursor cursor) {
            cursor.toBookmark((XmlCursor.XmlBookmark)this.bm);
        }

        public XmlTreeNode getChild(int ix) {
            return null;
        }

        public int getChildCount() {
            return 0;
        }

        public int getIndexOfChild(XmlTreeNode childNode) {
            return -1;
        }

        public Object getValue(int column) {
            if (column == 0) {
                return this.getNodeName();
            }
            if (column == 1) {
                return this.getNodeText();
            }
            return null;
        }

        public Node getDomNode() {
            return this.node;
        }

        public String getNodeName() {
            return this.node == null ? null : this.node.getNodeName();
        }

        public String getNodeText() {
            if (this.node == null) {
                return null;
            }
            String nodeValue = this.node.getNodeValue();
            return nodeValue == null ? null : nodeValue.trim();
        }

        public boolean isEditable(int column) {
            return false;
        }

        public boolean isLeaf() {
            return this.getChildCount() == 0;
        }

        public boolean setValue(int column, Object value) {
            return false;
        }

        public String toString() {
            return this.getNodeName();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof AbstractXmlTreeNode) {
                return ((AbstractXmlTreeNode)obj).node == this.node;
            }
            return super.equals(obj);
        }

        public XmlLineNumber getNodeLineNumber() {
            return this.lineNumber;
        }

        public XmlLineNumber getValueLineNumber() {
            return this.lineNumber;
        }

        public XmlObject getXmlObject() {
            if (XmlObjectTreeModel.this.cursor != null && XmlObjectTreeModel.this.cursor.toBookmark((XmlCursor.XmlBookmark)this.bm)) {
                XmlObject object = XmlObjectTreeModel.this.cursor.getObject();
                if (object != null) {
                    return object;
                }
                if (this.parent != null) {
                    return this.parent.getXmlObject();
                }
            }
            return null;
        }

        public TreePath getTreePath() {
            ArrayList<XmlTreeNode> nodes = new ArrayList<XmlTreeNode>();
            nodes.add(this);
            XmlTreeNode node = this;
            while (node.getParent() != null) {
                nodes.add(0, node.getParent());
                node = node.getParent();
            }
            return new TreePath(nodes.toArray());
        }

        public SchemaType getSchemaType() {
            if (this.schemaType == null) {
                this.schemaType = this.findSchemaType();
            }
            return this.schemaType;
        }
    }

    public static interface XmlTreeNode {
        public int getChildCount();

        public XmlTreeNode getChild(int var1);

        public int getIndexOfChild(XmlTreeNode var1);

        public String getNodeName();

        public String getNodeText();

        public boolean isEditable(int var1);

        public boolean isLeaf();

        public boolean setValue(int var1, Object var2);

        public XmlLineNumber getNodeLineNumber();

        public XmlLineNumber getValueLineNumber();

        public XmlObject getXmlObject();

        public Node getDomNode();

        public TreePath getTreePath();

        public XmlTreeNode getParent();

        public SchemaType getSchemaType();

        public String getDocumentation();
    }

    private class TreeBookmark
    extends XmlCursor.XmlBookmark {
        private TreeBookmark() {
        }
    }
}

