/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support.editor.registry;

import com.eviware.soapui.support.editor.registry.InspectorFactory;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InspectorRegistry {
    private static InspectorRegistry instance;
    private List<InspectorFactory> factories = new ArrayList<InspectorFactory>();

    public void addFactory(InspectorFactory factory) {
        for (int c = 0; c < this.factories.size(); ++c) {
            InspectorFactory f = this.factories.get(c);
            if (!f.getInspectorId().equals(factory.getInspectorId())) continue;
            this.factories.set(c, factory);
            return;
        }
        this.factories.add(factory);
    }

    public static final InspectorRegistry getInstance() {
        if (instance == null) {
            instance = new InspectorRegistry();
        }
        return instance;
    }

    public void removeFactory(InspectorFactory factory) {
        this.factories.remove(factory);
    }

    public InspectorFactory[] getFactories() {
        return this.factories.toArray(new InspectorFactory[this.factories.size()]);
    }

    public InspectorFactory[] getFactoriesOfType(Class<?> type) {
        ArrayList<InspectorFactory> result = new ArrayList<InspectorFactory>();
        for (InspectorFactory factory : this.factories) {
            if (!type.isAssignableFrom(factory.getClass())) continue;
            result.add(factory);
        }
        return result.toArray(new InspectorFactory[result.size()]);
    }
}

