/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support.editor.inspectors;

import com.eviware.soapui.support.editor.Editor;
import com.eviware.soapui.support.editor.EditorLocation;
import com.eviware.soapui.support.editor.EditorView;
import com.eviware.soapui.support.editor.xml.XmlDocument;
import com.eviware.soapui.support.editor.xml.XmlEditor;
import com.eviware.soapui.support.editor.xml.XmlInspector;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.ImageIcon;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractXmlInspector
implements XmlInspector {
    private final PropertyChangeSupport propertySupport;
    private String title;
    private String description;
    private boolean enabled;
    private XmlEditor editor;
    private final String inspectorId;
    private boolean active;

    protected AbstractXmlInspector(String title, String description, boolean enabled, String inspectorId) {
        this.title = title;
        this.description = description;
        this.enabled = enabled;
        this.inspectorId = inspectorId;
        this.propertySupport = new PropertyChangeSupport(this);
    }

    @Override
    public final String getInspectorId() {
        return this.inspectorId;
    }

    @Override
    public void deactivate() {
        this.active = false;
    }

    @Override
    public ImageIcon getIcon() {
        return null;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertySupport.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertySupport.removePropertyChangeListener(listener);
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    public void setDescription(String description) {
        String oldDescription = this.description;
        this.description = description;
        this.propertySupport.firePropertyChange(DESCRIPTION_PROPERTY, oldDescription, description);
    }

    public void setTitle(String title) {
        String oldTitle = this.title;
        this.title = title;
        this.propertySupport.firePropertyChange(TITLE_PROPERTY, oldTitle, title);
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        boolean oldEnabled = this.enabled;
        this.enabled = enabled;
        this.propertySupport.firePropertyChange(ENABLED_PROPERTY, oldEnabled, enabled);
    }

    @Override
    public void init(Editor<XmlDocument> editor) {
        this.editor = (XmlEditor)editor;
    }

    @Override
    public Editor<XmlDocument> getEditor() {
        return this.editor;
    }

    @Override
    public void release() {
    }

    @Override
    public void activate() {
        this.active = true;
        this.getComponent().requestFocusInWindow();
    }

    public boolean isActive() {
        return this.active;
    }

    @Override
    public boolean isContentHandler() {
        return false;
    }

    @Override
    public void locationChanged(EditorLocation<XmlDocument> location) {
    }

    @Override
    public boolean isEnabledFor(EditorView<XmlDocument> view) {
        return false;
    }
}

