/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support;

import com.eviware.soapui.impl.wsdl.panels.teststeps.support.GroovyEditor;
import com.eviware.soapui.impl.wsdl.panels.teststeps.support.GroovyEditorModel;
import com.eviware.soapui.support.DocumentListenerAdapter;
import com.eviware.soapui.support.EditorFactory;
import com.eviware.soapui.support.EditorModel;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.components.JUndoableTextArea;
import com.eviware.soapui.support.xml.JXEditTextArea;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;

public class DefaultEditorFactory
implements EditorFactory {
    public JComponent buildXPathEditor(EditorModel editorModel) {
        JUndoableTextArea textArea = new JUndoableTextArea();
        textArea.setText(editorModel.getEditorText());
        textArea.getDocument().addDocumentListener(new JTextComponentEditorModelDocumentListener(editorModel, textArea));
        return new JScrollPane(textArea);
    }

    public JComponent buildXmlEditor(EditorModel editorModel) {
        JXEditTextArea xmlEditor = JXEditTextArea.createXmlEditor(true);
        xmlEditor.setText(editorModel.getEditorText());
        xmlEditor.getDocument().addDocumentListener(new EditorModelDocumentListener(editorModel, xmlEditor));
        JScrollPane scrollPane = new JScrollPane(xmlEditor);
        UISupport.addPreviewCorner(scrollPane, false);
        return scrollPane;
    }

    public JComponent buildGroovyEditor(GroovyEditorModel editorModel) {
        return new GroovyEditor(editorModel);
    }

    private static class JTextComponentEditorModelDocumentListener
    extends DocumentListenerAdapter
    implements EditorModel.EditorModelListener {
        private final JTextComponent textField;
        private final EditorModel editorModel;

        public JTextComponentEditorModelDocumentListener(EditorModel editorModel, JTextComponent textField) {
            this.editorModel = editorModel;
            editorModel.addEditorModelListener(this);
            this.textField = textField;
        }

        public void editorTextChanged(String oldText, String newText) {
            this.textField.getDocument().removeDocumentListener(this);
            this.textField.setText(newText);
            this.textField.getDocument().addDocumentListener(this);
        }

        public void update(Document document) {
            this.editorModel.setEditorText(this.getText(document));
        }
    }

    private static class EditorModelDocumentListener
    extends DocumentListenerAdapter
    implements EditorModel.EditorModelListener {
        private EditorModel editorModel;
        private final JXEditTextArea xmlEditor;

        public EditorModelDocumentListener(EditorModel editorModel, JXEditTextArea xmlEditor) {
            this.editorModel = editorModel;
            this.xmlEditor = xmlEditor;
            editorModel.addEditorModelListener(this);
        }

        public void update(Document document) {
            this.editorModel.setEditorText(this.getText(document));
        }

        public void editorTextChanged(String oldText, String newText) {
            this.xmlEditor.getDocument().removeDocumentListener(this);
            this.xmlEditor.setText(newText);
            this.xmlEditor.getDocument().addDocumentListener(this);
        }
    }
}

