/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.model.tree.nodes;

import com.eviware.soapui.impl.rest.RestMethod;
import com.eviware.soapui.impl.rest.RestRequest;
import com.eviware.soapui.model.iface.Request;
import com.eviware.soapui.model.tree.AbstractModelItemTreeNode;
import com.eviware.soapui.model.tree.SoapUITreeModel;
import com.eviware.soapui.model.tree.SoapUITreeNode;
import com.eviware.soapui.model.tree.nodes.RequestTreeNode;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RestMethodTreeNode
extends AbstractModelItemTreeNode<RestMethod> {
    private List<RequestTreeNode> requestNodes = new ArrayList<RequestTreeNode>();
    private AbstractModelItemTreeNode.ReorderPropertyChangeListener propertyChangeListener = new AbstractModelItemTreeNode.ReorderPropertyChangeListener();

    public RestMethodTreeNode(RestMethod method, SoapUITreeModel treeModel) {
        super(method, method.getParent(), treeModel);
        treeModel.mapModelItem(this);
        for (RestRequest request : method.getRequestList()) {
            this.requestAdded(request);
        }
    }

    @Override
    public int getChildCount() {
        return this.requestNodes.size();
    }

    @Override
    public SoapUITreeNode getChildNode(int index) {
        return this.requestNodes.get(index);
    }

    @Override
    public int getIndexOfChild(Object child) {
        return this.requestNodes.indexOf(child);
    }

    public void requestAdded(Request request) {
        RequestTreeNode requestTreeNode = new RequestTreeNode(request, this.getTreeModel());
        this.requestNodes.add(requestTreeNode);
        this.reorder(false);
        request.addPropertyChangeListener(Request.NAME_PROPERTY, this.propertyChangeListener);
        this.getTreeModel().notifyNodeInserted(requestTreeNode);
    }

    public void requestRemoved(Request request) {
        SoapUITreeNode requestTreeNode = this.getTreeModel().getTreeNode(request);
        if (!this.requestNodes.contains(requestTreeNode)) {
            throw new RuntimeException("Removing unknown request");
        }
        this.getTreeModel().notifyNodeRemoved(requestTreeNode);
        this.requestNodes.remove(requestTreeNode);
        request.removePropertyChangeListener(this.propertyChangeListener);
    }

    @Override
    public void release() {
        super.release();
        for (RequestTreeNode treeNode : this.requestNodes) {
            ((Request)treeNode.getModelItem()).removePropertyChangeListener(Request.NAME_PROPERTY, this.propertyChangeListener);
            treeNode.release();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        super.propertyChange(evt);
        if (evt.getPropertyName().equals("childRequests")) {
            if (evt.getNewValue() != null) {
                this.requestAdded((RestRequest)evt.getNewValue());
            } else {
                this.requestRemoved((RestRequest)evt.getOldValue());
            }
        }
    }
}

