/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.model.support;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestStep;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.support.DefaultTestStepProperty;
import org.apache.commons.beanutils.PropertyUtils;

public class TestStepBeanProperty
extends DefaultTestStepProperty {
    public TestStepBeanProperty(String name, boolean isReadOnly, Object targetObject, String targetName, WsdlTestStep testStep) {
        super(name, isReadOnly, new BeanPropertyHandler(targetObject, targetName), testStep);
    }

    public static class BeanPropertyHandler
    implements DefaultTestStepProperty.PropertyHandler {
        private final Object target;
        private final String targetName;

        public BeanPropertyHandler(Object targetObject, String targetName) {
            this.target = targetObject;
            this.targetName = targetName;
        }

        public String getValue(DefaultTestStepProperty prop) {
            try {
                Object property = PropertyUtils.getProperty((Object)this.target, (String)this.targetName);
                return property == null ? null : property.toString();
            }
            catch (Exception e) {
                if (this.target instanceof ModelItem) {
                    SoapUI.logError(new Exception("Error getting property [" + this.targetName + "] from modelItem [" + ((ModelItem)this.target).getName() + "]", e));
                } else {
                    SoapUI.logError(new Exception("Error getting property [" + this.targetName + "] from bean [" + this.target + "]", e));
                }
                return null;
            }
        }

        public void setValue(DefaultTestStepProperty property, String value) {
            try {
                PropertyUtils.setProperty((Object)this.target, (String)this.targetName, (Object)value);
            }
            catch (Exception e) {
                SoapUI.logError(e);
            }
        }
    }
}

