/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.mockaswar;

import com.eviware.soapui.DefaultSoapUICore;
import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.wsdl.WsdlProject;
import com.eviware.soapui.impl.wsdl.mock.DispatchException;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockRunner;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockService;
import com.eviware.soapui.model.mock.MockResult;
import com.eviware.soapui.model.mock.MockRunner;
import com.eviware.soapui.model.mock.MockService;
import com.eviware.soapui.monitor.MockEngine;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.Tools;
import com.eviware.soapui.support.editor.inspectors.attachments.ContentTypeHandler;
import com.eviware.soapui.support.types.StringToStringMap;
import com.eviware.soapui.support.xml.XmlUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Appender;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.spi.LoggingEvent;

public class MockAsWarServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    protected static Logger logger = Logger.getLogger(MockAsWarServlet.class.getName());
    private WsdlProject project;
    private long maxResults;
    private List<MockResult> results = new LinkedList<MockResult>();
    private List<LoggingEvent> events = new LinkedList<LoggingEvent>();
    private boolean enableWebUI;
    private List<MockRunner> mockRunners = new ArrayList<MockRunner>();

    public void init() throws ServletException {
        super.init();
        try {
            String mockServiceEndpoint = this.initMockServiceParameters();
            logger.info("Loading project");
            this.project = new WsdlProject(this.getServletContext().getRealPath(this.getInitParameter("projectFile")));
            logger.info("Starting MockService(s)");
            for (MockService mockService : this.project.getMockServiceList()) {
                logger.info("Starting mockService [" + mockService.getName() + "]");
                if (StringUtils.hasContent(mockServiceEndpoint)) {
                    ((WsdlMockService)mockService).setMockServiceEndpoint(mockServiceEndpoint);
                }
                mockService.start();
            }
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, null, ex);
        }
    }

    protected String initMockServiceParameters() {
        if (StringUtils.hasContent(this.getInitParameter("listeners"))) {
            logger.info("Init listeners");
            System.setProperty("soapui.ext.listeners", this.getServletContext().getRealPath(this.getInitParameter("listeners")));
        } else {
            logger.info("Listeners not set!");
        }
        if (StringUtils.hasContent(this.getInitParameter("actions"))) {
            logger.info("Init actions");
            System.setProperty("soapui.ext.actions", this.getServletContext().getRealPath(this.getInitParameter("actions")));
        } else {
            logger.info("Actions not set!");
        }
        if (StringUtils.hasContent(this.getInitParameter("soapuiSettings"))) {
            logger.info("Init settings");
            SoapUI.setSoapUICore(new MockServletSoapUICore(this.getServletContext(), this.getInitParameter("soapuiSettings")));
        } else {
            logger.info("Settings not set!");
            SoapUI.setSoapUICore(new MockServletSoapUICore(this.getServletContext()));
        }
        if (StringUtils.hasContent(this.getInitParameter("enableWebUI"))) {
            if ("true".equals(this.getInitParameter("enableWebUI"))) {
                logger.info("WebUI ENABLED");
                this.enableWebUI = true;
            } else {
                logger.info("WebUI DISABLED");
                this.enableWebUI = false;
            }
        }
        SoapUI.ensureGroovyLog().addAppender((Appender)new GroovyLogAppender());
        String mockServiceEndpoint = this.getInitParameter("mockServiceEndpoint");
        return mockServiceEndpoint;
    }

    public void destroy() {
        super.destroy();
        this.getMockServletCore().stop();
    }

    protected MockServletSoapUICore getMockServletCore() {
        return (MockServletSoapUICore)SoapUI.getSoapUICore();
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            this.getMockServletCore().dispatchRequest(request, response);
        }
        catch (DispatchException ex) {
            logger.log(Level.SEVERE, null, ex);
        }
    }

    private void printResult(PrintWriter out, MockResult result) {
        out.print("<h4>Details for MockResult at " + new Date(result.getTimestamp()) + " (" + result.getTimeTaken() + "ms)</h4>");
        out.println("<hr/><p><b>Request Headers</b>:</p>");
        out.print("<table border=\"1\"><tr><td>Header</td><td>Value</td></tr>");
        StringToStringMap headers = result.getMockRequest().getRequestHeaders();
        for (String name : headers.getKeys()) {
            out.println("<tr><td>" + name + "</td><td>" + (String)headers.get(name) + "</td></tr>");
        }
        out.println("</table>");
        out.println("<hr/><b>Incoming Request</b>:<br/><pre>" + XmlUtils.entitize(result.getMockRequest().getRequestContent()) + "</pre>");
        out.println("<hr/><p><b>Response Headers</b>:</p>");
        out.print("<table border\"1\"><tr><td>Header</td><td>Value</td></tr>");
        headers = result.getResponseHeaders();
        for (String name : headers.getKeys()) {
            out.println("<tr><td>" + name + "</td><td>" + (String)headers.get(name) + "</td></tr>");
        }
        out.println("</table>");
        out.println("<hr/><b>Returned Response</b>:<pre>" + XmlUtils.entitize(result.getResponseContent()) + "</pre>");
    }

    public void printMaster(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.setStatus(200);
        response.setContentType("text/html");
        PrintWriter out = response.getWriter();
        this.startHtmlPage(out, "MockService Log Table", "15");
        out.print("<h3><img src=\"header_logo.jpg\"> soapUI MockServices Log for project [" + this.project.getName() + "]</h3>" + "<p style=\"text-align: left\">WSDLs:");
        for (MockRunner mockRunner : this.mockRunners) {
            String overviewUrl = ((WsdlMockRunner)mockRunner).getOverviewUrl();
            if (overviewUrl.startsWith("/")) {
                overviewUrl = overviewUrl.substring(1);
            }
            out.print(" [<a target=\"new\" href=\"" + overviewUrl + "\">" + mockRunner.getMockService().getName() + "</a>]");
        }
        out.print("</p>");
        out.print("<hr/><p><b>Processed Requests</b>: ");
        out.print("[<a href=\"master\">Refresh</a>] ");
        out.print("[<a href=\"master?clear\">Clear</a>]</p>");
        if ("clear".equals(request.getQueryString())) {
            this.results.clear();
        }
        out.print("<table border=\"1\">");
        out.print("<tr><td></td><td>Timestamp</td><td>Time Taken</td><td>MockOperation</td><td>MockResponse</td><td>MockService</td></tr>");
        int cnt = 1;
        for (MockResult result : this.results) {
            out.print("<tr><td>" + cnt++ + "</td>");
            out.print("<td><a target=\"detail\" href=\"detail?" + result.hashCode() + "\">" + new Date(result.getTimestamp()) + "</a></td>");
            out.print("<td>" + result.getTimeTaken() + "</td>");
            out.print("<td>" + result.getMockOperation().getName() + "</td>");
            out.print("<td>" + result.getMockResponse().getName() + "</td>");
            out.print("<td>" + result.getMockOperation().getMockService().getName() + "</td></tr>");
        }
        out.print("</table>");
        out.print("</body></html>");
        out.flush();
    }

    private void startHtmlPage(PrintWriter out, String title, String refresh) {
        out.print("<html><head>");
        out.print("<title>" + title + "</head>");
        if (refresh != null) {
            out.print("<meta http-equiv=\"refresh\" content=\"" + refresh + "\"/>");
        }
        out.print("<link type=\"text/css\" rel=\"stylesheet\" href=\"stylesheet.css\" />");
        out.print("</head><body>");
    }

    public void printDisabledLogFrameset(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.setStatus(200);
        response.setContentType("text/html");
        PrintWriter out = response.getWriter();
        out.print("<html><head><title>soapUI MockServices Log for project [" + this.project.getName() + "]</title></head>");
        out.print("<body>");
        out.print("<h3>");
        out.print("Log is disabled.");
        out.print("</h3>");
        out.print("</body></html>");
        out.flush();
    }

    public void printFrameset(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.setStatus(200);
        response.setContentType("text/html");
        PrintWriter out = response.getWriter();
        out.print("<html><head><title>soapUI MockServices Log for project [" + this.project.getName() + "]</title></head>");
        out.print("<frameset rows=\"40%,40%,*\">");
        out.print("<frame src=\"master\"/>");
        out.print("<frame name=\"detail\" src=\"detail\"/>");
        out.print("<frame src=\"log\"/>");
        out.print("</frameset>");
        out.print("</body></html>");
        out.flush();
    }

    public void printDetail(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.setStatus(200);
        response.setContentType("text/html");
        PrintWriter out = response.getWriter();
        this.startHtmlPage(out, "MockService Detail", null);
        int id = 0;
        try {
            id = Integer.parseInt(request.getQueryString());
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        if (id > 0) {
            for (MockResult result : this.results) {
                if (result.hashCode() != id) continue;
                id = 0;
                this.printResult(out, result);
            }
        }
        if (id > 0) {
            out.print("<p>Missing specified MockResult</p>");
        }
        out.print("</body></html>");
        out.flush();
    }

    public void printLog(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.setStatus(200);
        response.setContentType("text/html");
        PrintWriter out = response.getWriter();
        this.startHtmlPage(out, "MockService Groovy Log", "15");
        out.print("<p><b>Groovy Log output</b>: ");
        out.print("[<a href=\"log\">Refresh</a>] ");
        out.print("[<a href=\"log?clear\">Clear</a>]</p>");
        if ("clear".equals(request.getQueryString())) {
            this.events.clear();
        }
        out.print("<table border=\"1\">");
        out.print("<tr><td></td><td>Timestamp</td><td>Message</td></tr>");
        int cnt = 1;
        for (LoggingEvent event : this.events) {
            out.print("<tr><td>" + cnt++ + "</td>");
            out.print("<td>" + new Date(event.timeStamp) + "</td>");
            out.print("<td>" + event.getRenderedMessage() + "</td></tr>");
        }
        out.print("</table>");
        out.print("</body></html>");
        out.flush();
    }

    private class GroovyLogAppender
    extends AppenderSkeleton {
        private GroovyLogAppender() {
        }

        protected void append(LoggingEvent event) {
            MockAsWarServlet.this.events.add(event);
        }

        public void close() {
        }

        public boolean requiresLayout() {
            return false;
        }
    }

    class MockServletSoapUICore
    extends DefaultSoapUICore
    implements MockEngine {
        private final ServletContext servletContext;

        public MockServletSoapUICore(ServletContext servletContext, String soapUISettings) {
            super(servletContext.getRealPath("/"), servletContext.getRealPath(soapUISettings));
            this.servletContext = servletContext;
        }

        public void dispatchRequest(HttpServletRequest request, HttpServletResponse response) throws DispatchException, IOException {
            for (MockRunner mockRunner : this.getMockRunners()) {
                if (!request.getPathInfo().equals(mockRunner.getMockService().getPath())) continue;
                MockResult result = mockRunner.dispatchRequest(request, response);
                while (MockAsWarServlet.this.maxResults > 0L && (long)MockAsWarServlet.this.results.size() > MockAsWarServlet.this.maxResults) {
                    MockAsWarServlet.this.results.remove(0);
                }
                if (result != null) {
                    MockAsWarServlet.this.results.add(result);
                }
                return;
            }
            if (MockAsWarServlet.this.enableWebUI) {
                String pathInfo = request.getPathInfo();
                File file = new File(this.servletContext.getRealPath(pathInfo));
                if (file.exists() && file.isFile()) {
                    FileInputStream in = new FileInputStream(file);
                    response.setStatus(200);
                    long length = file.length();
                    response.setContentLength((int)length);
                    response.setContentType(ContentTypeHandler.getContentTypeFromFilename(file.getName()));
                    Tools.readAndWrite(in, length, (OutputStream)response.getOutputStream());
                    in.close();
                } else if (pathInfo.equals("/master")) {
                    MockAsWarServlet.this.printMaster(request, response);
                } else if (request.getPathInfo().equals("/detail")) {
                    MockAsWarServlet.this.printDetail(request, response);
                } else if (request.getPathInfo().equals("/log")) {
                    MockAsWarServlet.this.printLog(request, response);
                } else {
                    MockAsWarServlet.this.printFrameset(request, response);
                }
            } else {
                MockAsWarServlet.this.printDisabledLogFrameset(request, response);
            }
        }

        public void stop() {
            for (MockRunner mockRunner : this.getMockRunners()) {
                mockRunner.stop();
            }
        }

        public MockServletSoapUICore(ServletContext servletContext) {
            super(servletContext.getRealPath("/"), null);
            this.servletContext = servletContext;
        }

        protected MockEngine buildMockEngine() {
            return this;
        }

        public MockRunner[] getMockRunners() {
            return MockAsWarServlet.this.mockRunners.toArray(new MockRunner[MockAsWarServlet.this.mockRunners.size()]);
        }

        public boolean hasRunningMock(MockService mockService) {
            for (MockRunner runner : MockAsWarServlet.this.mockRunners) {
                if (runner.getMockService() != mockService) continue;
                return true;
            }
            return false;
        }

        public void startMockService(MockRunner runner) throws Exception {
            MockAsWarServlet.this.mockRunners.add(runner);
        }

        public void stopMockService(MockRunner runner) {
            MockAsWarServlet.this.mockRunners.remove(runner);
        }
    }
}

