/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.teststeps.assertions.basic;

import com.eviware.soapui.config.TestAssertionConfig;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlMessageAssertion;
import com.eviware.soapui.impl.wsdl.teststeps.assertions.AbstractTestAssertionFactory;
import com.eviware.soapui.model.iface.MessageExchange;
import com.eviware.soapui.model.iface.SubmitContext;
import com.eviware.soapui.model.propertyexpansion.PropertyExpander;
import com.eviware.soapui.model.testsuite.Assertable;
import com.eviware.soapui.model.testsuite.AssertionError;
import com.eviware.soapui.model.testsuite.AssertionException;
import com.eviware.soapui.model.testsuite.ResponseAssertion;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.xml.XmlObjectConfigurationBuilder;
import com.eviware.soapui.support.xml.XmlObjectConfigurationReader;
import org.apache.xmlbeans.XmlObject;

public class ResponseSLAAssertion
extends WsdlMessageAssertion
implements ResponseAssertion {
    public static final String ID = "Response SLA Assertion";
    public static final String LABEL = "Response SLA";
    private String SLA;

    public ResponseSLAAssertion(TestAssertionConfig assertionConfig, Assertable modelItem) {
        super(assertionConfig, modelItem, false, true, false, false);
        XmlObjectConfigurationReader reader = new XmlObjectConfigurationReader(this.getConfiguration());
        this.SLA = reader.readString("SLA", "200");
    }

    protected String internalAssertRequest(MessageExchange messageExchange, SubmitContext context) throws AssertionException {
        return null;
    }

    protected String internalAssertResponse(MessageExchange messageExchange, SubmitContext context) throws AssertionException {
        if (messageExchange.getTimeTaken() > Long.parseLong(PropertyExpander.expandProperties(context, this.SLA))) {
            throw new AssertionException(new AssertionError("Response did not meet SLA " + messageExchange.getTimeTaken() + "/" + this.SLA));
        }
        return "Response meets SLA";
    }

    public boolean configure() {
        String value = this.SLA;
        if (value == null || value.trim().length() == 0) {
            value = "200";
        }
        value = UISupport.prompt("Specify desired response time", "Configure Response SLA Assertion", value);
        try {
            Long.parseLong(value);
            this.SLA = value;
        }
        catch (Exception e) {
            return false;
        }
        this.setConfiguration(this.createConfiguration());
        return true;
    }

    public String getSLA() {
        return this.SLA;
    }

    public void setSLA(String sla) {
        this.SLA = sla;
        this.setConfiguration(this.createConfiguration());
    }

    protected XmlObject createConfiguration() {
        XmlObjectConfigurationBuilder builder = new XmlObjectConfigurationBuilder();
        return builder.add("SLA", this.SLA).finish();
    }

    public static class Factory
    extends AbstractTestAssertionFactory {
        public Factory() {
            super(ResponseSLAAssertion.ID, ResponseSLAAssertion.LABEL, ResponseSLAAssertion.class);
        }
    }
}

