/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.support.wss.crypto;

import com.eviware.soapui.config.KeyMaterialCryptoConfig;
import com.eviware.soapui.config.WSSCryptoConfig;
import com.eviware.soapui.impl.wsdl.AbstractWsdlModelItem;
import com.eviware.soapui.impl.wsdl.support.wss.DefaultWssContainer;
import com.eviware.soapui.impl.wsdl.support.wss.WssContainer;
import com.eviware.soapui.impl.wsdl.support.wss.WssCrypto;
import com.eviware.soapui.impl.wsdl.teststeps.BeanPathPropertySupport;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.resolver.ResolveContext;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.util.Properties;
import org.apache.commons.ssl.KeyStoreBuilder;
import org.apache.commons.ssl.Util;
import org.apache.ws.security.components.crypto.CredentialException;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.components.crypto.Merlin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeyMaterialWssCrypto
implements WssCrypto {
    private KeyMaterialCryptoConfig config;
    private final WssContainer container;
    private KeyStore keyStore;
    private BeanPathPropertySupport sourceProperty;

    public KeyMaterialWssCrypto(KeyMaterialCryptoConfig config2, WssContainer container, String source, String password) {
        this(config2, container);
        this.setSource(source);
        this.setPassword(password);
    }

    public KeyMaterialWssCrypto(KeyMaterialCryptoConfig cryptoConfig, WssContainer container2) {
        this.config = cryptoConfig;
        this.container = container2;
        this.sourceProperty = new BeanPathPropertySupport((AbstractWsdlModelItem)this.container.getModelItem(), this.config, "source"){

            protected void notifyUpdate(String value, String old) {
                KeyMaterialWssCrypto.this.getWssContainer().fireCryptoUpdated(KeyMaterialWssCrypto.this);
            }
        };
    }

    @Override
    public Crypto getCrypto() {
        try {
            Properties properties = new Properties();
            properties.put("org.apache.ws.security.crypto.merlin.file", this.sourceProperty.expand());
            properties.put("org.apache.ws.security.crypto.merlin.keystore.provider", "this");
            if (StringUtils.hasContent(this.getDefaultAlias())) {
                properties.put("org.apache.ws.security.crypto.merlin.keystore.alias", this.getDefaultAlias());
            }
            if (StringUtils.hasContent(this.getAliasPassword())) {
                properties.put("org.apache.ws.security.crypto.merlin.alias.password", this.getAliasPassword());
            }
            return new KeyMaterialCrypto(properties);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public String getLabel() {
        String source = this.getSource();
        int ix = source.lastIndexOf(File.separatorChar);
        if (ix == -1) {
            ix = source.lastIndexOf(47);
        }
        if (ix != -1) {
            source = source.substring(ix + 1);
        }
        return source;
    }

    @Override
    public String getSource() {
        return this.sourceProperty.expand();
    }

    public void udpateConfig(KeyMaterialCryptoConfig config) {
        this.config = config;
        this.sourceProperty.setConfig(config);
    }

    public void setSource(String source) {
        this.sourceProperty.set(source, true);
        this.keyStore = null;
    }

    public KeyStore load() throws Exception {
        if (this.keyStore != null) {
            return this.keyStore;
        }
        try {
            UISupport.setHourglassCursor();
            this.keyStore = StringUtils.hasContent(this.getDefaultAlias()) && StringUtils.hasContent(this.getAliasPassword()) ? KeyStoreBuilder.build((byte[])Util.streamToBytes((InputStream)new FileInputStream(this.sourceProperty.expand())), (byte[])this.getDefaultAlias().getBytes(), (char[])this.getPassword().toCharArray(), (char[])this.getAliasPassword().toCharArray()) : KeyStoreBuilder.build((byte[])Util.streamToBytes((InputStream)new FileInputStream(this.sourceProperty.expand())), (char[])this.getPassword().toCharArray());
            KeyStore keyStore = this.keyStore;
            return keyStore;
        }
        catch (Throwable t) {
            throw new Exception(t);
        }
        finally {
            UISupport.resetCursor();
        }
    }

    @Override
    public String getStatus() {
        try {
            if (StringUtils.hasContent(this.getSource()) && StringUtils.hasContent(this.getPassword())) {
                this.load();
                return "OK";
            }
            return "<unavailable>";
        }
        catch (Exception e) {
            return "<error: " + e.getMessage() + ">";
        }
    }

    @Override
    public String getPassword() {
        return this.config.getPassword();
    }

    public String getAliasPassword() {
        return this.config.getAliasPassword();
    }

    public String getDefaultAlias() {
        return this.config.getDefaultAlias();
    }

    public void setAliasPassword(String arg0) {
        this.config.setAliasPassword(arg0);
    }

    public void setDefaultAlias(String arg0) {
        this.config.setDefaultAlias(arg0);
    }

    public void setPassword(String arg0) {
        this.config.setPassword(arg0);
        this.keyStore = null;
        this.getWssContainer().fireCryptoUpdated(this);
    }

    @Override
    public void udpateConfig(WSSCryptoConfig config) {
    }

    public String toString() {
        return this.getLabel();
    }

    @Override
    public DefaultWssContainer getWssContainer() {
        return (DefaultWssContainer)this.container;
    }

    public String getCryptoProvider() {
        return this.config.getCryptoProvider();
    }

    public void setCryptoProvider(String provider) {
        this.config.setCryptoProvider(provider);
        this.keyStore = null;
        this.getWssContainer().fireCryptoUpdated(this);
    }

    public void resolve(ResolveContext<?> context) {
        this.sourceProperty.resolveFile(context, "Missing keystore/certificate file");
    }

    private class KeyMaterialCrypto
    extends Merlin {
        private KeyMaterialCrypto(Properties properties) throws CredentialException, IOException {
            super(properties);
        }

        public KeyStore load(InputStream input, String storepass, String provider, String type) throws CredentialException {
            if ("this".equals(provider)) {
                try {
                    return KeyMaterialWssCrypto.this.load();
                }
                catch (Exception e) {
                    throw new CredentialException(0, null, (Throwable)e);
                }
            }
            return super.load(input, storepass, provider, type);
        }

        protected String getCryptoProvider() {
            return KeyMaterialWssCrypto.this.config.getCryptoProvider();
        }
    }
}

