/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.support;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.config.PropertiesTypeConfig;
import com.eviware.soapui.config.PropertyConfig;
import com.eviware.soapui.impl.wsdl.MutableTestPropertyHolder;
import com.eviware.soapui.impl.wsdl.support.wsdl.UrlWsdlLoader;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.propertyexpansion.PropertyExpansion;
import com.eviware.soapui.model.support.TestPropertyUtils;
import com.eviware.soapui.model.testsuite.RenameableTestProperty;
import com.eviware.soapui.model.testsuite.TestProperty;
import com.eviware.soapui.model.testsuite.TestPropertyListener;
import com.eviware.soapui.support.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.xmlbeans.XmlString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlBeansPropertiesTestPropertyHolder
implements MutableTestPropertyHolder,
Map<String, TestProperty> {
    private PropertiesTypeConfig config;
    private List<PropertiesStepProperty> properties = new ArrayList<PropertiesStepProperty>();
    private Map<String, PropertiesStepProperty> propertyMap = new HashMap<String, PropertiesStepProperty>();
    private Set<TestPropertyListener> listeners = new HashSet<TestPropertyListener>();
    private ModelItem modelItem;
    private Properties overrideProperties;
    private String propertiesLabel = "Test Properties";

    public XmlBeansPropertiesTestPropertyHolder(ModelItem modelItem, PropertiesTypeConfig config) {
        this.modelItem = modelItem;
        this.config = config;
        for (int c = 0; c < config.sizeOfPropertyArray(); ++c) {
            PropertyConfig propertyConfig = config.getPropertyArray(c);
            if (StringUtils.hasContent(propertyConfig.getName())) {
                this.addProperty(propertyConfig, false, null);
                continue;
            }
            config.removeProperty(c);
            --c;
        }
    }

    protected PropertiesStepProperty addProperty(PropertyConfig propertyConfig, boolean notify, TestProperty virtualProperty) {
        PropertiesStepProperty propertiesStepProperty = new PropertiesStepProperty(propertyConfig, virtualProperty);
        this.properties.add(propertiesStepProperty);
        this.sortVirtualLast();
        this.propertyMap.put(propertiesStepProperty.getName().toUpperCase(), propertiesStepProperty);
        if (notify) {
            this.firePropertyAdded(propertiesStepProperty.getName());
        }
        return propertiesStepProperty;
    }

    private void sortVirtualLast() {
        ArrayList<PropertiesStepProperty> virtualProperties = new ArrayList<PropertiesStepProperty>();
        ArrayList<PropertiesStepProperty> nonVirtualProperties = new ArrayList<PropertiesStepProperty>();
        for (PropertiesStepProperty psp : this.properties) {
            if (psp.isVirtualProperty()) {
                if (virtualProperties.contains(psp)) continue;
                virtualProperties.add(psp);
                continue;
            }
            nonVirtualProperties.add(psp);
        }
        this.properties.clear();
        this.properties.addAll(nonVirtualProperties);
        this.properties.addAll(virtualProperties);
    }

    private void firePropertyAdded(String name) {
        TestPropertyListener[] listenersArray;
        for (TestPropertyListener listener : listenersArray = this.listeners.toArray(new TestPropertyListener[this.listeners.size()])) {
            listener.propertyAdded(name);
        }
    }

    private void firePropertyRemoved(String name) {
        TestPropertyListener[] listenersArray;
        for (TestPropertyListener listener : listenersArray = this.listeners.toArray(new TestPropertyListener[this.listeners.size()])) {
            listener.propertyRemoved(name);
        }
    }

    private void firePropertyMoved(String name, int oldIndex, int newIndex) {
        TestPropertyListener[] listenersArray;
        for (TestPropertyListener listener : listenersArray = this.listeners.toArray(new TestPropertyListener[this.listeners.size()])) {
            listener.propertyMoved(name, oldIndex, newIndex);
        }
    }

    private void firePropertyRenamed(String oldName, String newName) {
        TestPropertyListener[] listenersArray;
        for (TestPropertyListener listener : listenersArray = this.listeners.toArray(new TestPropertyListener[this.listeners.size()])) {
            listener.propertyRenamed(oldName, newName);
        }
    }

    private void firePropertyValueChanged(String name, String oldValue, String newValue) {
        TestPropertyListener[] listenersArray;
        for (TestPropertyListener listener : listenersArray = this.listeners.toArray(new TestPropertyListener[this.listeners.size()])) {
            listener.propertyValueChanged(name, oldValue, newValue);
        }
    }

    @Override
    public TestProperty addProperty(String name) {
        PropertyConfig propertyConfig = this.config.addNewProperty();
        propertyConfig.setName(name);
        return this.addProperty(propertyConfig, true, null);
    }

    public TestProperty addVirtualProperty(String key, TestProperty virtualProperty) {
        PropertyConfig propertyConfig = PropertyConfig.Factory.newInstance();
        propertyConfig.setName(key);
        return this.addProperty(propertyConfig, true, virtualProperty);
    }

    @Override
    public void addTestPropertyListener(TestPropertyListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public PropertiesStepProperty getProperty(String name) {
        return this.propertyMap.get(name.toUpperCase());
    }

    @Override
    public String[] getPropertyNames() {
        String[] result = new String[this.properties.size()];
        for (int c = 0; c < this.properties.size(); ++c) {
            result[c] = this.properties.get(c).getName();
        }
        return result;
    }

    @Override
    public List<TestProperty> getPropertyList() {
        ArrayList<TestProperty> result = new ArrayList<TestProperty>();
        for (PropertiesStepProperty property : this.properties) {
            result.add(property);
        }
        return result;
    }

    @Override
    public String getPropertyValue(String name) {
        PropertiesStepProperty property = this.getProperty(name);
        return property == null ? null : property.getValue();
    }

    @Override
    public TestProperty removeProperty(String propertyName) {
        PropertiesStepProperty property = this.getProperty(propertyName);
        if (property != null) {
            if (property instanceof PropertiesStepProperty && property.isVirtualProperty()) {
                return property;
            }
            int ix = this.properties.indexOf(property);
            this.propertyMap.remove(propertyName.toUpperCase());
            this.properties.remove(ix);
            this.firePropertyRemoved(propertyName);
            this.config.removeProperty(ix);
            return property;
        }
        return null;
    }

    @Override
    public void removeTestPropertyListener(TestPropertyListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void setPropertyValue(String name, String value) {
        PropertiesStepProperty property = this.getProperty(name);
        if (property != null) {
            property.setValue(value);
        } else {
            this.addProperty(name).setValue(value);
        }
    }

    public void resetPropertiesConfig(PropertiesTypeConfig config) {
        this.config = config;
        for (int c = 0; c < config.sizeOfPropertyArray(); ++c) {
            this.properties.get(c).setConfig(config.getPropertyArray(c));
        }
    }

    @Override
    public boolean renameProperty(String name, String newName) {
        if (this.getProperty(newName) != null) {
            return false;
        }
        PropertiesStepProperty property = this.getProperty(name);
        if (property == null) {
            return false;
        }
        property.setName(newName);
        return true;
    }

    public int saveTo(String fileName) throws IOException {
        return TestPropertyUtils.saveTo(this, fileName);
    }

    @Override
    public int getPropertyCount() {
        return this.properties.size();
    }

    @Override
    public TestProperty getPropertyAt(int index) {
        return this.properties.get(index);
    }

    @Override
    public Map<String, TestProperty> getProperties() {
        HashMap<String, TestProperty> result = new HashMap<String, TestProperty>();
        for (PropertiesStepProperty property : this.propertyMap.values()) {
            result.put(property.getName(), property);
        }
        return result;
    }

    @Override
    public boolean hasProperty(String name) {
        return this.propertyMap.containsKey(name.toUpperCase());
    }

    public int addPropertiesFromFile(String propFile) {
        if (!StringUtils.hasContent(propFile)) {
            return 0;
        }
        try {
            InputStream input = null;
            File file = new File(propFile);
            if (file.exists()) {
                input = new FileInputStream(file);
            } else if (propFile.toLowerCase().startsWith("http://") || propFile.toLowerCase().startsWith("https://")) {
                UrlWsdlLoader loader = new UrlWsdlLoader(propFile, this.getModelItem());
                loader.setUseWorker(false);
                input = loader.load();
            }
            if (input != null) {
                if (this.overrideProperties == null) {
                    this.overrideProperties = new Properties();
                }
                int sz = this.overrideProperties.size();
                this.overrideProperties.load(input);
                for (Object key : this.overrideProperties.keySet()) {
                    String name = key.toString();
                    if (this.hasProperty(name)) continue;
                    this.addProperty(name);
                }
                return this.overrideProperties.size() - sz;
            }
        }
        catch (Exception e) {
            SoapUI.logError(e);
        }
        return 0;
    }

    @Override
    public ModelItem getModelItem() {
        return this.modelItem;
    }

    public PropertyExpansion[] getPropertyExpansions() {
        ArrayList result = new ArrayList();
        return result.toArray(new PropertyExpansion[result.size()]);
    }

    @Override
    public void moveProperty(String propertyName, int targetIndex) {
        PropertiesStepProperty property = this.getProperty(propertyName);
        int ix = this.properties.indexOf(property);
        if (ix == targetIndex) {
            return;
        }
        if (targetIndex < 0) {
            targetIndex = 0;
        }
        String value = property.getValue();
        this.config.removeProperty(ix);
        PropertyConfig propertyConfig = null;
        if (targetIndex < this.properties.size()) {
            this.properties.add(targetIndex, this.properties.remove(ix));
            propertyConfig = this.config.insertNewProperty(targetIndex);
        } else {
            this.properties.add(this.properties.remove(ix));
            propertyConfig = this.config.addNewProperty();
        }
        propertyConfig.setName(propertyName);
        propertyConfig.setValue(value);
        this.resetPropertiesConfig(this.config);
        if (targetIndex > this.properties.size()) {
            targetIndex = this.properties.size();
        }
        this.firePropertyMoved(propertyName, ix, targetIndex);
    }

    @Override
    public void clear() {
        while (this.size() > 0) {
            this.removeProperty(this.getPropertyAt(0).getName());
        }
    }

    @Override
    public boolean containsKey(Object key) {
        return this.hasProperty((String)key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.propertyMap.containsValue(value);
    }

    @Override
    public Set<Map.Entry<String, TestProperty>> entrySet() {
        HashSet<Map.Entry<String, TestProperty>> result = new HashSet<Map.Entry<String, TestProperty>>();
        for (PropertiesStepProperty p : this.propertyMap.values()) {
            result.add(new HashMapEntry<String, PropertiesStepProperty>(p.getName(), p));
        }
        return result;
    }

    @Override
    public TestProperty get(Object key) {
        return this.getProperty((String)key);
    }

    @Override
    public boolean isEmpty() {
        return this.propertyMap.isEmpty();
    }

    @Override
    public Set<String> keySet() {
        return new HashSet<String>(Arrays.asList(this.getPropertyNames()));
    }

    @Override
    public TestProperty put(String key, TestProperty value) {
        TestProperty result = this.addProperty(key);
        result.setValue(value.getValue());
        return result;
    }

    @Override
    public void putAll(Map<? extends String, ? extends TestProperty> m) {
        for (TestProperty testProperty : m.values()) {
            this.addProperty(testProperty.getName()).setValue(testProperty.getValue());
        }
    }

    @Override
    public TestProperty remove(Object key) {
        return this.removeProperty((String)key);
    }

    @Override
    public int size() {
        return this.propertyMap.size();
    }

    @Override
    public Collection<TestProperty> values() {
        ArrayList<TestProperty> result = new ArrayList<TestProperty>();
        result.addAll(this.propertyMap.values());
        return result;
    }

    @Override
    public String getPropertiesLabel() {
        return this.propertiesLabel;
    }

    public void setPropertiesLabel(String propertiesLabel) {
        this.propertiesLabel = propertiesLabel;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class HashMapEntry<K, V>
    implements Map.Entry<K, V> {
        private K key;
        private V value;

        public HashMapEntry(K key, V value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            throw new UnsupportedOperationException();
        }
    }

    public class PropertiesStepProperty
    implements RenameableTestProperty {
        private PropertyConfig propertyConfig;
        private final TestProperty virtualProperty;

        public PropertiesStepProperty(PropertyConfig propertyConfig, TestProperty virtualProperty) {
            this.propertyConfig = propertyConfig;
            this.virtualProperty = virtualProperty;
        }

        public boolean isVirtualProperty() {
            return this.virtualProperty != null;
        }

        public void setConfig(PropertyConfig propertyConfig) {
            this.propertyConfig = propertyConfig;
        }

        public String getName() {
            return this.propertyConfig.getName();
        }

        public void setName(String name) {
            String oldName = this.getName();
            this.propertyConfig.setName(name);
            XmlBeansPropertiesTestPropertyHolder.this.propertyMap.remove(oldName.toUpperCase());
            XmlBeansPropertiesTestPropertyHolder.this.propertyMap.put(name.toUpperCase(), this);
            XmlBeansPropertiesTestPropertyHolder.this.firePropertyRenamed(oldName, name);
        }

        public String getDescription() {
            return null;
        }

        public String getValue() {
            if (XmlBeansPropertiesTestPropertyHolder.this.overrideProperties != null && XmlBeansPropertiesTestPropertyHolder.this.overrideProperties.containsKey(this.getName())) {
                return XmlBeansPropertiesTestPropertyHolder.this.overrideProperties.getProperty(this.getName());
            }
            if (this.virtualProperty != null) {
                return this.virtualProperty.getValue();
            }
            return this.propertyConfig.getValue();
        }

        public void setValue(String value) {
            String oldValue = this.getValue();
            this.propertyConfig.setValue(value);
            if (XmlBeansPropertiesTestPropertyHolder.this.overrideProperties != null && XmlBeansPropertiesTestPropertyHolder.this.overrideProperties.containsKey(this.getName())) {
                XmlBeansPropertiesTestPropertyHolder.this.overrideProperties.remove(this.getName());
                if (XmlBeansPropertiesTestPropertyHolder.this.overrideProperties.isEmpty()) {
                    XmlBeansPropertiesTestPropertyHolder.this.overrideProperties = null;
                }
            }
            XmlBeansPropertiesTestPropertyHolder.this.firePropertyValueChanged(this.getName(), oldValue, value);
        }

        public boolean isReadOnly() {
            return false;
        }

        public QName getType() {
            return XmlString.type.getName();
        }

        public ModelItem getModelItem() {
            return XmlBeansPropertiesTestPropertyHolder.this.modelItem;
        }

        public String getDefaultValue() {
            return null;
        }
    }
}

