/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.submit.transports.http;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.support.AbstractHttpRequestInterface;
import com.eviware.soapui.impl.support.http.HttpRequestInterface;
import com.eviware.soapui.impl.wsdl.AbstractWsdlModelItem;
import com.eviware.soapui.impl.wsdl.WsdlProject;
import com.eviware.soapui.impl.wsdl.submit.RequestFilter;
import com.eviware.soapui.impl.wsdl.submit.transports.http.BaseHttpRequestTransport;
import com.eviware.soapui.impl.wsdl.submit.transports.http.BaseHttpResponse;
import com.eviware.soapui.impl.wsdl.submit.transports.http.ExtendedHttpMethod;
import com.eviware.soapui.impl.wsdl.submit.transports.http.SinglePartHttpResponse;
import com.eviware.soapui.impl.wsdl.submit.transports.http.support.attachments.MimeMessageResponse;
import com.eviware.soapui.impl.wsdl.submit.transports.http.support.methods.ExtendedDeleteMethod;
import com.eviware.soapui.impl.wsdl.submit.transports.http.support.methods.ExtendedGetMethod;
import com.eviware.soapui.impl.wsdl.submit.transports.http.support.methods.ExtendedHeadMethod;
import com.eviware.soapui.impl.wsdl.submit.transports.http.support.methods.ExtendedOptionsMethod;
import com.eviware.soapui.impl.wsdl.submit.transports.http.support.methods.ExtendedPostMethod;
import com.eviware.soapui.impl.wsdl.submit.transports.http.support.methods.ExtendedPutMethod;
import com.eviware.soapui.impl.wsdl.submit.transports.http.support.methods.ExtendedTraceMethod;
import com.eviware.soapui.impl.wsdl.support.PathUtils;
import com.eviware.soapui.impl.wsdl.support.http.HttpClientSupport;
import com.eviware.soapui.impl.wsdl.support.wss.WssCrypto;
import com.eviware.soapui.model.iface.Request;
import com.eviware.soapui.model.iface.Response;
import com.eviware.soapui.model.iface.SubmitContext;
import com.eviware.soapui.model.propertyexpansion.PropertyExpander;
import com.eviware.soapui.model.settings.Settings;
import com.eviware.soapui.model.support.ModelSupport;
import com.eviware.soapui.settings.HttpSettings;
import com.eviware.soapui.support.types.StringToStringMap;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.URI;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpClientRequestTransport
implements BaseHttpRequestTransport {
    private List<RequestFilter> filters = new ArrayList<RequestFilter>();
    private static final Logger log = Logger.getLogger(HttpClientRequestTransport.class);

    @Override
    public void addRequestFilter(RequestFilter filter) {
        this.filters.add(filter);
    }

    @Override
    public void removeRequestFilter(RequestFilter filter) {
        this.filters.remove(filter);
    }

    @Override
    public void abortRequest(SubmitContext submitContext) {
        HttpMethodBase postMethod = (HttpMethodBase)submitContext.getProperty("httpMethod");
        if (postMethod != null) {
            postMethod.abort();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Response sendRequest(SubmitContext submitContext, Request request) throws Exception {
        AbstractHttpRequestInterface httpRequest = (AbstractHttpRequestInterface)request;
        HttpClient httpClient = HttpClientSupport.getHttpClient();
        ExtendedHttpMethod httpMethod = this.createHttpMethod(httpRequest);
        boolean createdState = false;
        HttpState httpState = (HttpState)submitContext.getProperty("#HTTP_STATE");
        if (httpState == null) {
            httpState = new HttpState();
            submitContext.setProperty("#HTTP_STATE", httpState);
            createdState = true;
        }
        HostConfiguration hostConfiguration = new HostConfiguration();
        String localAddress = System.getProperty("soapui.bind.address", httpRequest.getBindAddress());
        if (localAddress == null || localAddress.trim().length() == 0) {
            localAddress = SoapUI.getSettings().getString(HttpSettings.BIND_ADDRESS, null);
        }
        if (localAddress != null && localAddress.trim().length() > 0) {
            try {
                hostConfiguration.setLocalAddress(InetAddress.getByName(localAddress));
            }
            catch (Exception e) {
                SoapUI.logError(e);
            }
        }
        submitContext.removeProperty("httpResponse");
        submitContext.setProperty("httpMethod", httpMethod);
        submitContext.setProperty("postMethod", httpMethod);
        submitContext.setProperty("httpClient", httpClient);
        submitContext.setProperty("requestContent", httpRequest.getRequestContent());
        submitContext.setProperty("hostConfiguration", hostConfiguration);
        submitContext.setProperty("wsdlRequest", httpRequest);
        submitContext.setProperty("httpResponseProperties", new StringToStringMap());
        for (RequestFilter filter : this.filters) {
            filter.filterRequest(submitContext, httpRequest);
        }
        try {
            try {
                Settings settings = httpRequest.getSettings();
                StringToStringMap headers = httpRequest.getRequestHeaders();
                for (String header : headers.keySet()) {
                    String headerValue = (String)headers.get(header);
                    headerValue = PropertyExpander.expandProperties(submitContext, headerValue);
                    httpMethod.setRequestHeader(header, headerValue);
                }
                WsdlProject project = (WsdlProject)ModelSupport.getModelItemProject(httpRequest);
                WssCrypto crypto = null;
                if (project != null) {
                    crypto = project.getWssContainer().getCryptoByName(PropertyExpander.expandProperties(submitContext, httpRequest.getSslKeystore()));
                }
                if (crypto != null && "OK".equals(crypto.getStatus())) {
                    hostConfiguration.getParams().setParameter("soapui.sslConfig", (Object)(crypto.getSource() + " " + crypto.getPassword()));
                }
                httpMethod.setDumpFile(PathUtils.expandPath(httpRequest.getDumpFile(), (AbstractWsdlModelItem)((Object)httpRequest), submitContext));
                URI uri = (URI)submitContext.getProperty("requestUri");
                if (uri != null && uri.isAbsoluteURI()) {
                    hostConfiguration.setHost(uri.getHost(), uri.getPort());
                    String str = uri.toString();
                    int ix = str.indexOf(47, str.indexOf("//") + 2);
                    if (ix != -1) {
                        uri = new URI(str.substring(ix));
                        httpMethod.setURI(uri);
                        submitContext.setProperty("requestUri", uri);
                    }
                }
                if (settings.getBoolean(HttpSettings.INCLUDE_REQUEST_IN_TIME_TAKEN)) {
                    httpMethod.initStartTime();
                }
                httpClient.executeMethod(hostConfiguration, (HttpMethod)httpMethod, httpState);
                httpMethod.getTimeTaken();
            }
            catch (Throwable t) {
                httpMethod.setFailed(t);
                if (t instanceof Exception) {
                    throw (Exception)t;
                }
                SoapUI.logError(t);
                throw new Exception(t);
            }
            Object var18_19 = null;
        }
        catch (Throwable throwable) {
            Object var18_20 = null;
            for (int c = this.filters.size() - 1; c >= 0; --c) {
                this.filters.get(c).afterRequest(submitContext, httpRequest);
            }
            if (!submitContext.hasProperty("httpResponse")) {
                this.createDefaultResponse(submitContext, httpRequest, httpMethod);
            }
            Response response = (Response)submitContext.getProperty("httpResponse");
            StringToStringMap responseProperties = (StringToStringMap)submitContext.getProperty("httpResponseProperties");
            for (String key : responseProperties.keySet()) {
                response.setProperty(key, (String)responseProperties.get(key));
            }
            if (httpMethod != null) {
                httpMethod.releaseConnection();
            } else {
                log.error((Object)"PostMethod is null");
            }
            if (!createdState) throw throwable;
            submitContext.setProperty("#HTTP_STATE", null);
            throw throwable;
        }
        for (int c = this.filters.size() - 1; c >= 0; --c) {
            this.filters.get(c).afterRequest(submitContext, httpRequest);
        }
        if (!submitContext.hasProperty("httpResponse")) {
            this.createDefaultResponse(submitContext, httpRequest, httpMethod);
        }
        Response response = (Response)submitContext.getProperty("httpResponse");
        StringToStringMap responseProperties = (StringToStringMap)submitContext.getProperty("httpResponseProperties");
        for (String key : responseProperties.keySet()) {
            response.setProperty(key, (String)responseProperties.get(key));
        }
        if (httpMethod != null) {
            httpMethod.releaseConnection();
        } else {
            log.error((Object)"PostMethod is null");
        }
        if (!createdState) return (Response)submitContext.getProperty("httpResponse");
        submitContext.setProperty("#HTTP_STATE", null);
        return (Response)submitContext.getProperty("httpResponse");
    }

    private void createDefaultResponse(SubmitContext submitContext, AbstractHttpRequestInterface<?> httpRequest, ExtendedHttpMethod httpMethod) {
        String requestContent = (String)submitContext.getProperty("requestContent");
        Header responseContentTypeHeader = httpMethod.getResponseHeader("Content-Type");
        BaseHttpResponse response = null;
        response = responseContentTypeHeader != null && responseContentTypeHeader.getValue().toUpperCase().startsWith("MULTIPART") ? new MimeMessageResponse(httpRequest, httpMethod, requestContent, submitContext) : new SinglePartHttpResponse(httpRequest, httpMethod, requestContent, submitContext);
        submitContext.setProperty("httpResponse", response);
    }

    private ExtendedHttpMethod createHttpMethod(AbstractHttpRequestInterface<?> httpRequest) {
        if (httpRequest instanceof HttpRequestInterface) {
            HttpRequestInterface restRequest = (HttpRequestInterface)httpRequest;
            switch (restRequest.getMethod()) {
                case GET: {
                    return new ExtendedGetMethod();
                }
                case HEAD: {
                    return new ExtendedHeadMethod();
                }
                case DELETE: {
                    return new ExtendedDeleteMethod();
                }
                case PUT: {
                    return new ExtendedPutMethod();
                }
                case OPTIONS: {
                    return new ExtendedOptionsMethod();
                }
                case TRACE: {
                    return new ExtendedTraceMethod();
                }
            }
        }
        ExtendedPostMethod extendedPostMethod = new ExtendedPostMethod();
        extendedPostMethod.setAfterRequestInjection(httpRequest.getAfterRequestInjection());
        return extendedPostMethod;
    }
}

