/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.submit.filters;

import com.eviware.soapui.impl.support.AbstractHttpRequest;
import com.eviware.soapui.impl.wsdl.submit.filters.AbstractRequestFilter;
import com.eviware.soapui.model.iface.SubmitContext;
import com.eviware.soapui.model.propertyexpansion.PropertyExpander;
import com.eviware.soapui.model.propertyexpansion.PropertyExpansionUtils;
import com.eviware.soapui.model.propertyexpansion.resolvers.ResolverUtils;
import com.eviware.soapui.settings.CommonSettings;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyExpansionRequestFilter
extends AbstractRequestFilter {
    public static final Logger log = Logger.getLogger(PropertyExpansionRequestFilter.class);

    @Override
    public void filterAbstractHttpRequest(SubmitContext context, AbstractHttpRequest<?> httpRequest) {
        String content = (String)context.getProperty("requestContent");
        if (content == null) {
            log.warn((Object)"Missing request content in context, skipping property expansion");
        } else if ((content = PropertyExpander.expandProperties(context, content, httpRequest.getSettings().getBoolean(CommonSettings.ENTITIZE_PROPERTIES))) != null) {
            context.setProperty("requestContent", content);
        }
    }

    public static String expandProperties(SubmitContext context, String content) {
        return PropertyExpander.expandProperties(context, content);
    }

    public static String getGlobalProperty(String propertyName) {
        return PropertyExpansionUtils.getGlobalProperty(propertyName);
    }

    public static String extractXPathPropertyValue(Object property, String xpath) {
        return ResolverUtils.extractXPathPropertyValue(property, xpath);
    }
}

