/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.panels.support;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.model.testsuite.LoadTestRunner;
import com.eviware.soapui.model.testsuite.TestCase;
import com.eviware.soapui.model.testsuite.TestCaseRunner;
import com.eviware.soapui.monitor.support.TestMonitorListenerAdapter;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;

public class TestRunComponentEnabler
extends TestMonitorListenerAdapter {
    private final List<JComponent> components = new ArrayList<JComponent>();
    private final List<Boolean> states = new ArrayList<Boolean>();
    private final TestCase testCase;

    public TestRunComponentEnabler(TestCase testCase) {
        this.testCase = testCase;
        SoapUI.getTestMonitor().addTestMonitorListener(this);
    }

    public void release() {
        SoapUI.getTestMonitor().removeTestMonitorListener(this);
    }

    public void loadTestStarted(LoadTestRunner runner) {
        this.disable();
    }

    private void disable() {
        if (this.states.isEmpty()) {
            for (JComponent component : this.components) {
                this.states.add(component.isEnabled());
                component.setEnabled(false);
            }
        }
    }

    private void enable() {
        if (!this.states.isEmpty()) {
            for (int c = 0; c < this.components.size(); ++c) {
                JComponent component = this.components.get(c);
                component.setEnabled(this.states.get(c));
            }
            this.states.clear();
        }
    }

    public void loadTestFinished(LoadTestRunner runner) {
        if (!SoapUI.getTestMonitor().hasRunningTest(this.testCase)) {
            this.enable();
        }
    }

    public void testCaseStarted(TestCaseRunner runner) {
        this.disable();
    }

    public void testCaseFinished(TestCaseRunner runner) {
        if (!SoapUI.getTestMonitor().hasRunningTest(this.testCase)) {
            this.enable();
        }
    }

    public void add(JComponent component) {
        this.components.add(component);
        if (SoapUI.getTestMonitor().hasRunningTest(this.testCase)) {
            this.states.add(component.isEnabled());
            component.setEnabled(false);
        }
    }
}

