/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wadl.inference.support;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.xmlbeans.XmlAnySimpleType;
import org.apache.xmlbeans.XmlBase64Binary;
import org.apache.xmlbeans.XmlBoolean;
import org.apache.xmlbeans.XmlDate;
import org.apache.xmlbeans.XmlDateTime;
import org.apache.xmlbeans.XmlDecimal;
import org.apache.xmlbeans.XmlGDay;
import org.apache.xmlbeans.XmlGMonth;
import org.apache.xmlbeans.XmlGYear;
import org.apache.xmlbeans.XmlGYearMonth;
import org.apache.xmlbeans.XmlHexBinary;
import org.apache.xmlbeans.XmlInteger;
import org.apache.xmlbeans.XmlNegativeInteger;
import org.apache.xmlbeans.XmlNonNegativeInteger;
import org.apache.xmlbeans.XmlNonPositiveInteger;
import org.apache.xmlbeans.XmlPositiveInteger;
import org.apache.xmlbeans.XmlString;
import org.apache.xmlbeans.XmlTime;

public class TypeInferrer {
    private static TypeInferrer ref;
    private TypeTree types;
    private Map<XmlAnySimpleType, TypeTree> typeTable = new HashMap<XmlAnySimpleType, TypeTree>();

    public static XmlAnySimpleType getType(String typeName) {
        for (XmlAnySimpleType item : TypeInferrer.getRef().typeTable.keySet()) {
            if (!item.schemaType().getName().getLocalPart().equals(typeName)) continue;
            return item;
        }
        return null;
    }

    public static XmlAnySimpleType getBlankType() {
        return TypeInferrer.getRef().types.type;
    }

    public static XmlAnySimpleType expandTypeForValue(String value, XmlAnySimpleType baseType) {
        return TypeInferrer.getRef().expandTypeForValueInternal(baseType, value);
    }

    public static XmlAnySimpleType inferSimpleType(String value) {
        return TypeInferrer.getRef().inferSimpleTypeRec(value, TypeInferrer.getRef().types);
    }

    public static boolean validateSimpleType(String value, XmlAnySimpleType type) {
        try {
            type.setStringValue(value);
            return type.validate();
        }
        catch (Exception e) {
            return false;
        }
    }

    private static TypeInferrer getRef() {
        if (ref == null) {
            ref = new TypeInferrer();
        }
        return ref;
    }

    private TypeInferrer() {
        TypeTree xmlbool = new TypeTree((XmlAnySimpleType)XmlBoolean.Factory.newInstance());
        this.typeTable.put(xmlbool.type, xmlbool);
        TypeTree xmlbool2 = new TypeTree((XmlAnySimpleType)XmlBoolean.Factory.newInstance());
        this.typeTable.put(xmlbool2.type, xmlbool2);
        TypeTree xmlnegint = new TypeTree((XmlAnySimpleType)XmlNegativeInteger.Factory.newInstance());
        this.typeTable.put(xmlnegint.type, xmlnegint);
        TypeTree xmlposint = new TypeTree((XmlAnySimpleType)XmlPositiveInteger.Factory.newInstance());
        this.typeTable.put(xmlposint.type, xmlposint);
        TypeTree xmlnonnegint = new TypeTree((XmlAnySimpleType)XmlNonNegativeInteger.Factory.newInstance());
        this.typeTable.put(xmlnonnegint.type, xmlnonnegint);
        xmlnonnegint.addChild(xmlposint);
        xmlnonnegint.addChild(xmlbool);
        TypeTree xmlnonposint = new TypeTree((XmlAnySimpleType)XmlNonPositiveInteger.Factory.newInstance());
        this.typeTable.put(xmlnonposint.type, xmlnonposint);
        xmlnonposint.addChild(xmlnegint);
        TypeTree xmlint = new TypeTree((XmlAnySimpleType)XmlInteger.Factory.newInstance());
        this.typeTable.put(xmlint.type, xmlint);
        xmlint.addChild(xmlnonnegint);
        xmlint.addChild(xmlnonposint);
        TypeTree xmldec = new TypeTree((XmlAnySimpleType)XmlDecimal.Factory.newInstance());
        this.typeTable.put(xmldec.type, xmldec);
        xmldec.addChild(xmlint);
        TypeTree xmldate = new TypeTree((XmlAnySimpleType)XmlDate.Factory.newInstance());
        this.typeTable.put(xmldate.type, xmldate);
        TypeTree xmltime = new TypeTree((XmlAnySimpleType)XmlTime.Factory.newInstance());
        this.typeTable.put(xmltime.type, xmltime);
        TypeTree xmldatetime = new TypeTree((XmlAnySimpleType)XmlDateTime.Factory.newInstance());
        this.typeTable.put(xmldatetime.type, xmldatetime);
        TypeTree xmlhexbin = new TypeTree((XmlAnySimpleType)XmlHexBinary.Factory.newInstance());
        this.typeTable.put(xmlhexbin.type, xmlhexbin);
        TypeTree xmlb64bin = new TypeTree((XmlAnySimpleType)XmlBase64Binary.Factory.newInstance());
        this.typeTable.put(xmlb64bin.type, xmlb64bin);
        TypeTree xmlgyearmonth = new TypeTree((XmlAnySimpleType)XmlGYearMonth.Factory.newInstance());
        this.typeTable.put(xmlgyearmonth.type, xmlgyearmonth);
        TypeTree xmlgyear = new TypeTree((XmlAnySimpleType)XmlGYear.Factory.newInstance());
        this.typeTable.put(xmlgyear.type, xmlgyear);
        TypeTree xmlgmonth = new TypeTree((XmlAnySimpleType)XmlGMonth.Factory.newInstance());
        this.typeTable.put(xmlgmonth.type, xmlgmonth);
        TypeTree xmlgday = new TypeTree((XmlAnySimpleType)XmlGDay.Factory.newInstance());
        this.typeTable.put(xmlgday.type, xmlgday);
        TypeTree xmlstring = new TypeTree((XmlAnySimpleType)XmlString.Factory.newInstance());
        this.typeTable.put(xmlstring.type, xmlstring);
        xmlstring.addChild(xmldec);
        xmlstring.addChild(xmldate);
        xmlstring.addChild(xmltime);
        xmlstring.addChild(xmldatetime);
        xmlstring.addChild(xmlbool2);
        xmlstring.addChild(xmlgyearmonth);
        xmlstring.addChild(xmlgyear);
        xmlstring.addChild(xmlgmonth);
        xmlstring.addChild(xmlgday);
        xmlstring.addChild(xmlhexbin);
        this.types = xmlstring;
    }

    private XmlAnySimpleType expandTypeForValueInternal(XmlAnySimpleType type, String value) {
        TypeTree p = this.typeTable.get(type);
        while (!TypeInferrer.validateSimpleType(value, p.type)) {
            p = p.parent;
        }
        return p.type;
    }

    private XmlAnySimpleType inferSimpleTypeRec(String value, TypeTree p) {
        for (TypeTree item : p.children) {
            if (!TypeInferrer.validateSimpleType(value, item.type)) continue;
            return this.inferSimpleTypeRec(value, item);
        }
        return p.type;
    }

    private class TypeTree {
        public XmlAnySimpleType type;
        public TypeTree parent;
        public List<TypeTree> children;

        public TypeTree(XmlAnySimpleType type) {
            this.type = type;
            this.children = new ArrayList<TypeTree>();
        }

        public void addChild(TypeTree type) {
            this.children.add(type);
            type.parent = this;
        }
    }
}

