/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.rest.support;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.rest.RestRequestInterface;
import com.eviware.soapui.impl.rest.support.RestParamProperty;
import com.eviware.soapui.impl.rest.support.RestParamsPropertyHolder;
import com.eviware.soapui.model.propertyexpansion.DefaultPropertyExpansionContext;
import com.eviware.soapui.model.propertyexpansion.PropertyExpander;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.Tools;
import com.eviware.soapui.support.types.StringList;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import org.apache.xmlbeans.XmlBoolean;

public class RestUtils {
    public static String[] extractTemplateParams(String path) {
        int endIx;
        if (StringUtils.isNullOrEmpty(path)) {
            return new String[0];
        }
        StringList result = new StringList();
        int ix = path.indexOf(123);
        while (ix != -1 && (endIx = path.indexOf(125, ix)) != -1) {
            if (endIx > ix + 1 && ix > 0 && path.charAt(ix - 1) != '$') {
                result.add(path.substring(ix + 1, endIx));
            }
            ix = path.indexOf(123, ix + 1);
        }
        return result.toStringArray();
    }

    public static String extractParams(String pathOrEndpoint, RestParamsPropertyHolder params, boolean keepHost) {
        URL url;
        String queryString;
        String path;
        block22: {
            if (StringUtils.isNullOrEmpty(pathOrEndpoint)) {
                return "";
            }
            path = pathOrEndpoint;
            queryString = "";
            url = null;
            try {
                url = new URL(pathOrEndpoint);
                path = url.getPath();
                queryString = url.getQuery();
            }
            catch (MalformedURLException e) {
                int ix = path.indexOf(63);
                if (ix < 0) break block22;
                queryString = path.substring(ix + 1);
                path = path.substring(0, ix);
            }
        }
        String[] items = path.split("/");
        int templateParamCount = 0;
        StringBuffer resultPath = new StringBuffer();
        for (int i = 0; i < items.length; ++i) {
            String item = items[i];
            try {
                if (item.startsWith("{") && item.endsWith("}")) {
                    String name = item.substring(1, item.length() - 1);
                    RestParamProperty property = params.getProperty(name);
                    if (!params.hasProperty(name)) {
                        property = params.addProperty(name);
                    }
                    property.setStyle(RestParamsPropertyHolder.ParameterStyle.TEMPLATE);
                    property.setValue(name);
                    property.setDefaultValue(name);
                } else {
                    String[] matrixParams = item.split(";");
                    if (matrixParams.length > 0) {
                        item = matrixParams[0];
                        for (int c = 1; c < matrixParams.length; ++c) {
                            String name;
                            String matrixParam = matrixParams[c];
                            int ix = matrixParam.indexOf(61);
                            if (ix == -1) {
                                name = URLDecoder.decode(matrixParam, "Utf-8");
                                if (params.hasProperty(name)) continue;
                                params.addProperty(name).setStyle(RestParamsPropertyHolder.ParameterStyle.MATRIX);
                                continue;
                            }
                            name = URLDecoder.decode(matrixParam.substring(0, ix), "Utf-8");
                            RestParamProperty property = params.getProperty(name);
                            if (property == null) {
                                property = params.addProperty(name);
                            }
                            property.setStyle(RestParamsPropertyHolder.ParameterStyle.MATRIX);
                            property.setValue(URLDecoder.decode(matrixParam.substring(ix + 1), "Utf-8"));
                            property.setDefaultValue(URLDecoder.decode(matrixParam.substring(ix + 1), "Utf-8"));
                        }
                    }
                    Integer.parseInt(item);
                    String name = "param" + templateParamCount++;
                    RestParamProperty property = params.getProperty(name);
                    if (!params.hasProperty(name)) {
                        property = params.addProperty(name);
                    }
                    property.setStyle(RestParamsPropertyHolder.ParameterStyle.TEMPLATE);
                    property.setValue(item);
                    property.setDefaultValue(item);
                    item = "{" + property.getName() + "}";
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            if (!StringUtils.hasContent(item)) continue;
            resultPath.append('/').append(item);
        }
        if (StringUtils.hasContent(queryString)) {
            for (String item : items = queryString.split("&")) {
                try {
                    String name;
                    int ix = item.indexOf(61);
                    if (ix == -1) {
                        name = URLDecoder.decode(item, "Utf-8");
                        if (params.hasProperty(name)) continue;
                        params.addProperty(name).setStyle(RestParamsPropertyHolder.ParameterStyle.QUERY);
                        continue;
                    }
                    name = URLDecoder.decode(item.substring(0, ix), "Utf-8");
                    RestParamProperty property = params.getProperty(name);
                    if (property == null) {
                        property = params.addProperty(name);
                    }
                    property.setStyle(RestParamsPropertyHolder.ParameterStyle.QUERY);
                    property.setValue(URLDecoder.decode(item.substring(ix + 1), "Utf-8"));
                    property.setDefaultValue(URLDecoder.decode(item.substring(ix + 1), "Utf-8"));
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
            }
        }
        if (path.endsWith("/")) {
            resultPath.append('/');
        }
        if (keepHost && url != null) {
            return Tools.getEndpointFromUrl(url) + resultPath.toString();
        }
        return resultPath.toString();
    }

    public static String expandPath(String path, RestParamsPropertyHolder params, RestRequestInterface request) {
        StringBuffer query = request.isPostQueryString() || "multipart/form-data".equals(request.getMediaType()) ? null : new StringBuffer();
        DefaultPropertyExpansionContext context = new DefaultPropertyExpansionContext(request);
        block7: for (int c = 0; c < params.getPropertyCount(); ++c) {
            RestParamProperty param = params.getPropertyAt(c);
            String value = PropertyExpander.expandProperties(context, param.getValue());
            if (value != null && !param.isDisableUrlEncoding()) {
                try {
                    String encoding = System.getProperty("soapui.request.encoding", request.getEncoding());
                    value = StringUtils.hasContent(encoding) ? URLEncoder.encode(value, encoding) : URLEncoder.encode(value);
                }
                catch (UnsupportedEncodingException e1) {
                    SoapUI.logError(e1);
                    value = URLEncoder.encode(value);
                }
            }
            if (!StringUtils.hasContent(value) && !param.getRequired()) continue;
            if (value == null) {
                value = "";
            }
            switch (param.getStyle()) {
                case QUERY: {
                    if (query == null) continue block7;
                    if (query.length() > 0) {
                        query.append('&');
                    }
                    query.append(URLEncoder.encode(param.getName()));
                    query.append('=');
                    if (!StringUtils.hasContent(value)) continue block7;
                    query.append(value);
                    continue block7;
                }
                case TEMPLATE: {
                    path = path.replaceAll("\\{" + param.getName() + "\\}", value);
                    continue block7;
                }
                case MATRIX: {
                    if (param.getType().equals(XmlBoolean.type.getName())) {
                        if (!value.toUpperCase().equals("TRUE") && !value.equals("1")) continue block7;
                        path = path + ";" + param.getName();
                        continue block7;
                    }
                    path = path + ";" + param.getName();
                    if (!StringUtils.hasContent(value)) continue block7;
                    path = path + "=" + value;
                }
            }
        }
        if (query != null && query.length() > 0) {
            path = path + "?" + query.toString();
        }
        return path;
    }
}

