'use strict';

/**
 * Drive.js
 * This Object spoofs the Scripting.FileSystemObject Drive Object
 * Properties and methods taken from Microsoft documentation
 * https://msdn.microsoft.com/en-us/library/ts2t8ybh(v=vs.84).aspx
 */

class Drive {
    constructor(drive) {
        // Default properties
        this.AvailableSpace = 7156948992;
        this.DriveLetter    = drive;
        this.DriveType      = 2;        // 0: Unknown, 1: Removable, 2: Fixed, 3: Network, 4: CD-ROM, 5: RAM Disk
        this.FileSystem     = 'NFTS';   // FAT-32
        this.FreeSpace      = 7156948992;
        this.IsReady        = true;
        this.Path           = drive + ':';
        this.RootFolder     = drive + ':\\';
        this.SerialNumber   = -1225924828;
        this.ShareName      = '';
        this.TotalSize      = 7725907968;
        this.VolumeName     = '';

        this._name          = 'Drive';
    }

    toString() {
        return this._name;
    }
}

const ProxyGenerator = require('../../../../vendor/ProxyGenerator');
module.exports = new ProxyGenerator(Drive);
