/*
 * Decompiled with CFR 0.152.
 */
package net.seleucus.wsp.client;

import net.seleucus.wsp.client.WSConnection;
import net.seleucus.wsp.client.WSRequestBuilder;
import net.seleucus.wsp.main.WSGestalt;
import net.seleucus.wsp.main.WSVersion;
import net.seleucus.wsp.main.WebSpa;
import net.seleucus.wsp.util.WSUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WSClient
extends WSGestalt {
    private static final Logger LOGGER = LoggerFactory.getLogger(WSClient.class);

    public WSClient(WebSpa myWebSpa) {
        super(myWebSpa);
    }

    @Override
    public void exitConsole() {
        LOGGER.info("Goodbye!");
    }

    @Override
    public void runConsole() {
        LOGGER.info("");
        LOGGER.info("WebSpa - Single HTTP/S Request Authorisation");
        LOGGER.info("version " + WSVersion.getValue() + " (webspa@seleucus.net)");
        LOGGER.info("");
        String host = this.readLineRequired("Host [e.g. https://localhost/]");
        CharSequence password = this.readPasswordRequired("Your pass-phrase for that host");
        int action = this.readLineRequiredInt("The action number", 0, 9);
        WSRequestBuilder myClient = new WSRequestBuilder(host, password, action);
        String knock = myClient.getKnock();
        LOGGER.info("Your WebSpa Knock is: {}", (Object)knock);
        String sendChoice = this.readLineOptional("Send the above URL [Y/n]");
        if (WSUtil.isAnswerPositive(sendChoice) || sendChoice.isEmpty()) {
            WSConnection myConnection = new WSConnection(knock);
            LOGGER.info(myConnection.getActionToBeTaken());
            myConnection.sendRequest();
            if (myConnection.isHttps()) {
                try {
                    LOGGER.info(myConnection.getCertSHA1Hash());
                }
                catch (NullPointerException npEx) {
                    LOGGER.info("Couldn't get the SHA1 hash of the server certificate - probably a self signed certificate.");
                    if (!WSUtil.hasMinJreRequirements(1, 7)) {
                        LOGGER.error("Be sure to run WebSpa with a JRE 1.7 or greater.");
                    }
                    LOGGER.error("An exception was raised when reading the server certificate.");
                    npEx.printStackTrace();
                }
                String trustChoice = this.readLineOptional("Continue connecting [Y/n]");
                if (WSUtil.isAnswerPositive(trustChoice) || sendChoice.isEmpty()) {
                    myConnection.sendRequest();
                    LOGGER.info(myConnection.responseMessage());
                    LOGGER.info("HTTPS Response Code: {}", (Object)myConnection.responseCode());
                } else {
                    LOGGER.info("Nothing was sent.");
                }
            } else {
                myConnection.sendRequest();
                LOGGER.info(myConnection.responseMessage());
                LOGGER.info("HTTP Response Code: {}", (Object)myConnection.responseCode());
            }
        }
    }
}

